/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.inner;

import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.cal.business.calculate.billgroup.BillGroupRelationHelper;
import kd.fi.cal.common.helper.AcctGroupModelHelper;

public class DeleteCalBillHelper {
    public void deleteCalBills(DynamicObject[] bizBills) {
        if (bizBills == null || bizBills.length < 1) {
            return;
        }
        if ("im_initbill".equals(bizBills[0].getDataEntityType().getName())) {
            return;
        }
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        for (DynamicObject item : bizBills) {
            bizBillIds.add((Long)item.getPkValue());
        }
        this.removeAllRecord(bizBillIds);
    }

    private void removeAllRecord(Set<Long> bizBillIds) {
        QFilter qs = new QFilter("bizbillid", "in", bizBillIds);
        QFilter[] filter = qs.toArray();
        HashSet<Long> recordIds = new HashSet<Long>(8);
        HashSet<Object> calBillIds = new HashSet<Object>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,billno,calbillid,isinitbill,entry.id,biztype", (QFilter[])filter, null);){
            for (Row row : dataSet) {
                recordIds.add(row.getLong("id"));
                calBillIds.add(row.getLong("calbillid"));
            }
        }
        new BillGroupRelationHelper().getAndRemoveRelations(calBillIds, false);
        DeleteServiceHelper.delete((String)"cal_costrecord_subentity", (QFilter[])new QFilter("id", "in", recordIds).toArray());
        if (AcctGroupModelHelper.isBizGroupModel()) {
            DeleteServiceHelper.delete((String)"cal_calbill_pk", (QFilter[])qs.toArray());
        } else {
            DeleteServiceHelper.delete((String)"cal_incalbill", (QFilter[])qs.toArray());
            DeleteServiceHelper.delete((String)"cal_outcalbill", (QFilter[])qs.toArray());
        }
    }
}

