/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.inner;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;

public class OverWfAutoUnWfHelper {
    private static final Log logger = LogFactory.getLog(OverWfAutoUnWfHelper.class);

    public void autoUnWf(DynamicObject[] wfDycs) {
        try (TraceSpan span = Tracer.create((String)"autoUnWf", (String)"autoUnWf");
             TXHandle tx = TX.requiresNew();){
            this.doAutoUnWf(wfDycs);
        }
    }

    private void doAutoUnWf(DynamicObject[] wfDycs) {
        if (wfDycs == null || wfDycs.length < 1) {
            return;
        }
        try (AlgoContext context = Algo.newContext();){
            String mainBillEntity = wfDycs[0].getString("billtype");
            String wfRecordEntity = wfDycs[0].getDataEntityType().getName();
            Set<Long> bizBillIds = this.getBizBillIds(wfDycs);
            DataSet costRecDs = this.getCostRecordADs(mainBillEntity, bizBillIds);
            DataSet wfDs = this.getWfDs(wfRecordEntity, costRecDs);
            this.invokeAction(wfRecordEntity, costRecDs, wfDs, wfDycs);
        }
        catch (Throwable e) {
            logger.error("\u4e1a\u52a1\u6570\u636e\u591a\u6838\u9500-\u81ea\u52a8\u53cd\u6838\u9500\u5931\u8d25", e);
        }
    }

    private void invokeAction(String wfRecordEntity, DataSet costRecDs, DataSet wfDs, DynamicObject[] wfDycs) {
        costRecDs = costRecDs.groupBy(costRecDs.getRowMeta().getFieldNames()).finish();
        DataSet diffDs = costRecDs.leftJoin(wfDs).on("wfid", "id").select(new String[]{"wfid", "bizbillid"}, new String[]{"id"}).finish().filter("id is null");
        DynamicObjectType subDataEntityType = EntityMetadataCache.getSubDataEntityType((String)wfRecordEntity, Arrays.asList("id", "billid", "billno", "entry"));
        ArrayList<DynamicObject> needUnWfDycs = new ArrayList<DynamicObject>(16);
        for (Row row : diffDs) {
            Long wfId = row.getLong("wfid");
            if (wfId == null || wfId.equals(0L)) continue;
            Long bizbillid = row.getLong("bizbillid");
            DynamicObject verifyRecord = new DynamicObject(subDataEntityType);
            verifyRecord.set("id", (Object)wfId);
            verifyRecord.set("billid", (Object)bizbillid);
            verifyRecord.set("billno", (Object)bizbillid.toString());
            needUnWfDycs.add(verifyRecord);
        }
        if (needUnWfDycs.size() > 0) {
            logger.info("\u6838\u7b97\u81ea\u52a8\u53cd\u6838\u9500\u5f00\u59cb");
            String actionNmae = ActionEnum.PUR_UN_WRITEOFF.getValue();
            String posActionName = ActionEnum.PUR_WRITEOFF.getValue();
            if ("ar_verifyrecord".equals(wfRecordEntity) || "cal_salwfrecord".equals(wfRecordEntity)) {
                actionNmae = ActionEnum.SALE_UN_WRITEOFF.getValue();
                posActionName = ActionEnum.SALE_WRITEOFF.getValue();
            }
            HashMap<String, String> param = new HashMap<String, String>(16);
            if (wfDycs != null && wfDycs.length > 0) {
                param.put("nolock", "TRUE");
            }
            Map map = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCheckService", (String)"doService", (Object[])new Object[]{actionNmae, param, needUnWfDycs.toArray(new DynamicObject[0])});
            if (wfDycs != null && wfDycs.length > 0) {
                HashMap<String, String> posParam = new HashMap<String, String>(16);
                posParam.put("retry", "1");
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBizService", (String)"doService", (Object[])new Object[]{posActionName, posParam, wfDycs});
            }
            if (map != null && !map.isEmpty()) {
                logger.info("\u6838\u7b97\u81ea\u52a8\u53cd\u6838\u9500\u5931\u8d25==>{}", (Object)map);
            }
            logger.info("\u6838\u7b97\u81ea\u52a8\u53cd\u6838\u9500\u7ed3\u675f");
        }
    }

    private DataSet getWfDs(String wfRecordEntity, DataSet costRecDs) {
        costRecDs = costRecDs.copy();
        HashSet<Long> wfIds = new HashSet<Long>(16);
        for (Row row : costRecDs) {
            Long wfId = row.getLong("wfid");
            if (wfId == null || wfId.equals(0L)) continue;
            wfIds.add(wfId);
        }
        QFilter wfIdsF = new QFilter("id", "in", wfIds);
        DataSet wfDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)wfRecordEntity, (String)"id", (QFilter[])wfIdsF.toArray(), null);
        return wfDs;
    }

    private DataSet getCostRecordADs(String mainBillEntity, Set<Long> bizBillIds) {
        QFilter costRecF = new QFilter("bizbillid", "in", bizBillIds);
        costRecF.and("issplitcreate", "=", (Object)Character.valueOf('1'));
        costRecF.and("writeoffstatus", "=", (Object)Character.valueOf('A'));
        costRecF.and("bizentityobject", "=", (Object)mainBillEntity);
        DataSet costRecDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"entry.writeoffid wfid,bizbillid", (QFilter[])costRecF.toArray(), null);
        return costRecDs;
    }

    private Set<Long> getBizBillIds(DynamicObject[] wfDycs) {
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        for (DynamicObject wfRecordDyc : wfDycs) {
            bizBillIds.add(wfRecordDyc.getLong("billid"));
            for (DynamicObject wfEntryDyc : wfRecordDyc.getDynamicObjectCollection("entry")) {
                bizBillIds.add(wfEntryDyc.getLong("e_billid"));
            }
        }
        return bizBillIds;
    }

    public void autoUnWf(QFilter costRecF) {
        if (costRecF == null) {
            return;
        }
        logger.info("\u6279\u91cf\u540c\u6b65-\u6838\u7b97\u81ea\u52a8\u53cd\u6838\u9500\u5f00\u59cb");
        try (TXHandle tx = TX.requiresNew();
             AlgoContext context = Algo.newContext();){
            Set bizBillIds;
            costRecF.and("issplitcreate", "=", (Object)Boolean.TRUE);
            costRecF.and("writeoffstatus", "=", (Object)Character.valueOf('A'));
            DataSet srcCostRecDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"bizbillid,bizentityobject", (QFilter[])costRecF.toArray(), null);
            HashMap<String, Set> mainEntityBizBillIdsMap = new HashMap<String, Set>(16);
            for (Row row : srcCostRecDs) {
                String entity = row.getString("bizentityobject");
                Long bizBillId = row.getLong("bizbillid");
                bizBillIds = mainEntityBizBillIdsMap.computeIfAbsent(entity, k -> new HashSet(16));
                bizBillIds.add(bizBillId);
            }
            int size = CalDbParamServiceHelper.getInteger((String)"wf_split_mainbill_size");
            for (Map.Entry entry : mainEntityBizBillIdsMap.entrySet()) {
                String mainBillEntity = (String)entry.getKey();
                bizBillIds = (Set)entry.getValue();
                boolean isApWf = "im_purinbill".equals(mainBillEntity) || "im_mdc_ominbill".equals(mainBillEntity) || "im_ospurinbill".equals(mainBillEntity);
                boolean isArWf = "im_saloutbill".equals(mainBillEntity);
                String wfEntity = "";
                if (isApWf) {
                    wfEntity = "ap_verifyrecord";
                } else if (isArWf) {
                    wfEntity = "ar_verifyrecord";
                }
                if (StringUtils.isEmpty((String)wfEntity)) continue;
                String wfRecordEntity = wfEntity;
                Lists.partition(new ArrayList(bizBillIds), (int)size).forEach(list -> {
                    try (AlgoContext context1 = Algo.newContext();
                         TraceSpan span = Tracer.create((String)"CalBatchSyncFormPlugin-autoUnWf", (String)"CalBatchSyncFormPlugin-autoUnWf");){
                        DataSet costRecDs = this.getCostRecordADs(mainBillEntity, new HashSet<Long>((Collection<Long>)list));
                        DataSet wfDs = this.getWfDs(wfRecordEntity, costRecDs);
                        this.invokeAction(wfRecordEntity, costRecDs, wfDs, null);
                    }
                });
            }
        }
        catch (Throwable e) {
            logger.error("\u6279\u91cf\u540c\u6b65-\u6838\u7b97\u81ea\u52a8\u53cd\u6838\u9500\u5931\u8d25", e);
        }
        logger.info("\u6279\u91cf\u540c\u6b65-\u6838\u7b97\u81ea\u52a8\u53cd\u6838\u9500\u7ed3\u675f");
    }
}

