/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.inner;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.model.SynBillErrInfo;

public class PeriodChecker {
    private DynamicObject[] costRecordDycs = null;
    private Map<Long, SynBillErrInfo> errMap = new HashMap<Long, SynBillErrInfo>(32);
    private String beforePeriodMsg = ResManager.loadKDString((String)"\u5f80\u671f\u5355\u636e\u4e0d\u5141\u8bb8\u540c\u6b65\u5230\u5f53\u671f\u3002", (String)"PeriodChecker_0", (String)"fi-cal-business", (Object[])new Object[0]);

    public PeriodChecker() {
    }

    public PeriodChecker(DynamicObject[] costRecordDycs) {
        this.costRecordDycs = costRecordDycs;
    }

    public void doCheck() {
        if (this.costRecordDycs == null || this.costRecordDycs.length < 1) {
            return;
        }
        HashMap<Long, Integer> costRecordIdPeriodMap = new HashMap<Long, Integer>(16);
        HashMap<Long, Long> costRecordIdAcctIdMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> costRecordIdBizBillIdMap = new HashMap<Long, Long>(16);
        for (DynamicObject costRecordDyc : this.costRecordDycs) {
            if (costRecordDyc.getBoolean("isinitbill")) continue;
            costRecordIdPeriodMap.put(costRecordDyc.getLong("id"), costRecordDyc.getInt("period.periodyear") * 100 + costRecordDyc.getInt("period.periodnumber"));
            costRecordIdAcctIdMap.put(costRecordDyc.getLong("id"), costRecordDyc.getLong("costaccount.id"));
            costRecordIdBizBillIdMap.put(costRecordDyc.getLong("id"), costRecordDyc.getLong("bizbillid"));
        }
        this.check(costRecordIdPeriodMap, costRecordIdAcctIdMap, costRecordIdBizBillIdMap);
    }

    public void check(Map<Long, Integer> costRecordIdPeriodMap, Map<Long, Long> costRecordIdAcctIdMap, Map<Long, Long> costRecordIdBizBillIdMap) {
        Map acctPeriods = PeriodHelper.getSysPeriods(new HashSet<Long>(costRecordIdAcctIdMap.values()));
        for (Map.Entry<Long, Long> costRecordIdAcctId : costRecordIdAcctIdMap.entrySet()) {
            Integer billPeriod = costRecordIdPeriodMap.get(costRecordIdAcctId.getKey());
            DynamicObject acctPeriodDyc = (DynamicObject)acctPeriods.get(costRecordIdAcctId.getValue());
            if (acctPeriodDyc == null) continue;
            int acctPeriod = acctPeriodDyc.getInt("periodyear") * 100 + acctPeriodDyc.getInt("periodnumber");
            if (billPeriod >= acctPeriod) continue;
            this.addErrorMsg(costRecordIdBizBillIdMap.get(costRecordIdAcctId.getKey()), "3", this.beforePeriodMsg);
        }
    }

    public DynamicObject[] getCostRecordDycs() {
        return this.costRecordDycs;
    }

    public void setCostRecordDycs(DynamicObject[] costRecordDycs) {
        this.costRecordDycs = costRecordDycs;
    }

    public Map<Long, SynBillErrInfo> getErrMap() {
        return this.errMap;
    }

    public void setErrMap(Map<Long, SynBillErrInfo> errMap) {
        this.errMap = errMap;
    }

    private void addErrorMsg(long bizBillId, String errType, String warnMsg) {
        this.errMap.put(bizBillId, new SynBillErrInfo(errType, warnMsg));
    }

    public void setBeforePeriodMsg(String beforePeriodMsg) {
        this.beforePeriodMsg = beforePeriodMsg;
    }
}

