/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.inner;

import java.util.Map;
import java.util.Set;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;

public class PreDimBuilder {
    private final Set<Long> emptyRanges;
    private final Map<Long, String> rangeAndDivideStr;
    private final Map<Long, String> rangeAndDimenSionStr;
    private static final String DIMSTR = "dimstr";

    public PreDimBuilder(Set<Long> emptyRanges, Map<Long, String> rangeAndDivideStr, Map<Long, String> rangeAndDimenSionStr) {
        this.emptyRanges = emptyRanges;
        this.rangeAndDivideStr = rangeAndDivideStr;
        this.rangeAndDimenSionStr = rangeAndDimenSionStr;
    }

    public StringBuilder getDimKey(Row row) {
        String dimenSionStr;
        StringBuilder key = new StringBuilder();
        Long calrangeId = row.getLong("calrangeid");
        Long materialId = row.getLong("material");
        key.append(materialId).append("@");
        key.append(calrangeId).append("@");
        if (this.emptyRanges.contains(calrangeId)) {
            for (String filed : this.rangeAndDivideStr.get(calrangeId).split(",")) {
                String value = row.getString(filed);
                key.append(value == null ? "0" : value).append("@");
            }
        }
        if ((dimenSionStr = this.rangeAndDimenSionStr.get(calrangeId)) != null) {
            for (String filed : dimenSionStr.split(",")) {
                String value = row.getString(filed);
                key.append(value == null ? "0" : value).append("@");
            }
        }
        return key;
    }

    public String creataAdjustDimKey(MainEntityType entityType, DynamicObject costAdjustInfo, DynamicObject costAdjustEntry) {
        String dimenSionStr;
        StringBuilder outInfoKey = new StringBuilder();
        Long calrangeId = costAdjustEntry.getLong("calrange.id");
        Object material = costAdjustEntry.get("material");
        if (material instanceof DynamicObject) {
            material = ((DynamicObject)material).getPkValue();
        }
        outInfoKey.append(material).append("@");
        outInfoKey.append(calrangeId).append("@");
        if (this.emptyRanges.contains(calrangeId)) {
            for (String filed : this.rangeAndDivideStr.get(calrangeId).split(",")) {
                String value;
                boolean isBaseDataProp;
                IDataEntityProperty fieldProperty = entityType.findProperty(filed);
                boolean bl = isBaseDataProp = fieldProperty instanceof BasedataProp && !(fieldProperty instanceof FlexProp);
                if (isBaseDataProp) {
                    filed = filed + ".id";
                }
                if (fieldProperty.getParent() instanceof MainEntityType) {
                    value = costAdjustInfo.getString(filed);
                    outInfoKey.append(value == null ? "0" : value).append("@");
                    continue;
                }
                if (!(fieldProperty.getParent() instanceof EntryType)) continue;
                value = costAdjustEntry.getString(filed);
                outInfoKey.append(value == null ? "0" : value).append("@");
            }
        }
        if ((dimenSionStr = this.rangeAndDimenSionStr.get(calrangeId)) != null) {
            for (String filed : dimenSionStr.split(",")) {
                String value;
                IDataEntityProperty fieldProperty = entityType.findProperty(filed);
                boolean isBaseDataProp = fieldProperty instanceof BasedataProp;
                if (isBaseDataProp) {
                    filed = filed + ".id";
                }
                if (fieldProperty.getParent() instanceof MainEntityType) {
                    value = costAdjustInfo.getString(filed);
                    outInfoKey.append(value == null ? "0" : value).append("@");
                    continue;
                }
                if (!(fieldProperty.getParent() instanceof EntryType)) continue;
                value = costAdjustEntry.getString(filed);
                outInfoKey.append(value == null ? "0" : value).append("@");
            }
        }
        return outInfoKey.toString();
    }
}

