/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.inner;

import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.fi.cal.business.process.inner.PreDimBuilder;
import kd.fi.cal.common.util.ArrayUtils;

public class PrevCalRangeFunction
extends MapFunction {
    private final Set<Long> emptyRanges;
    private final Map<Long, String> rangeAndDivideStr;
    private final Map<Long, String> rangeAndDimenSionStr;
    private static final String DIMSTR = "dimstr";

    public PrevCalRangeFunction(Set<Long> emptyRanges, Map<Long, String> rangeAndDivideStr, Map<Long, String> rangeAndDimenSionStr, RowMeta rowMeta) {
        this.emptyRanges = emptyRanges;
        this.rangeAndDivideStr = rangeAndDivideStr;
        this.rangeAndDimenSionStr = rangeAndDimenSionStr;
        this.sourceRowMeta = rowMeta;
    }

    public Object[] map(Row row) {
        String[] fieldNames;
        PreDimBuilder preDimBuilder = new PreDimBuilder(this.emptyRanges, this.rangeAndDivideStr, this.rangeAndDimenSionStr);
        StringBuilder key = preDimBuilder.getDimKey(row);
        Object[] newRow = new Object[this.getResultRowMeta().getFieldCount()];
        for (String fieldName : fieldNames = this.getSourceRowMeta().getFieldNames()) {
            int fieldIndex = this.getResultRowMeta().getFieldIndex(fieldName);
            newRow[fieldIndex] = row.get(fieldName);
        }
        int fieldIndex = this.getResultRowMeta().getFieldIndex(DIMSTR);
        newRow[fieldIndex] = key.toString();
        return newRow;
    }

    private StringBuilder getDimKey(Row row) {
        String dimenSionStr;
        StringBuilder key = new StringBuilder();
        Long calrangeId = row.getLong("calrangeid");
        Long materialId = row.getLong("material");
        key.append(materialId).append("@");
        key.append(calrangeId).append("@");
        if (this.emptyRanges.contains(calrangeId)) {
            for (String filed : this.rangeAndDivideStr.get(calrangeId).split(",")) {
                String value = row.getString(filed);
                key.append(value == null ? "0" : value).append("@");
            }
        }
        if ((dimenSionStr = this.rangeAndDimenSionStr.get(calrangeId)) != null) {
            for (String filed : dimenSionStr.split(",")) {
                String value = row.getString(filed);
                key.append(value == null ? "0" : value).append("@");
            }
        }
        return key;
    }

    public RowMeta getResultRowMeta() {
        RowMeta sourceRowMeta = this.sourceRowMeta;
        Object[] fields = sourceRowMeta.getFields();
        return new RowMeta((Field[])ArrayUtils.concatAll((Object[])fields, (Object[][])new Field[][]{{new Field(DIMSTR, (DataType)DataType.StringType)}}));
    }
}

