/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.inner;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.cal.business.balance.BalanceDimFieldParser;
import kd.fi.cal.business.calculate.out.CalIntimeBufferPoolHelper;
import kd.fi.cal.business.process.inner.DealDivideAndDimValueMapFunction;
import kd.fi.cal.business.process.inner.PreDimBuilder;
import kd.fi.cal.business.process.inner.PrevCalRangeFunction;
import kd.fi.cal.business.process.inner.PrevMaxFunction;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBillEnum;
import kd.fi.cal.common.helper.BillNoHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.WriteLogHelper;
import kd.fi.cal.common.model.CostAccount;
import kd.fi.cal.common.model.CostAdjustDetailParams;
import kd.fi.cal.common.util.ArrayUtils;
import kd.fi.cal.common.util.CommonUtils;

public class PrevCostAdjustProcessHelper {
    private static final Log logger = LogFactory.getLog(PrevCostAdjustProcessHelper.class);
    private BalanceDimFieldParser balanceDimFieldParser;
    private Map<Long, String> prevCostParamMap;
    private Map<String, DynamicObject> inOutAdjustMap;
    private Map<Long, BigDecimal> inAdjEntryRateMap;
    private Set<Long> inAdjBillIdSet;
    private final String APPURIN = "appurin";
    private final String FEE = "fee";
    private Set<String> recentCostFields;
    private Set<Long> emptyRanges;
    private Map<Long, Long> accountAndEmptyRangeMap;
    private Map<Long, String> rangeAndDivideStr;
    private Map<Long, String> rangeAndDimenSionStr;
    private Set<String> dimFields;
    private final String[] CREATETYPES = new String[]{CostAdjustBillEnum.PURCHASEAUTO.getValue(), CostAdjustBillEnum.OUTSOURCEAUTO_DIFF.getValue(), CostAdjustBillEnum.FEESHARE.getValue(), CostAdjustBillEnum.COST_ESTIMATE.getValue(), CostAdjustBillEnum.COST_STRIKE.getValue(), "B-A1"};

    public PrevCostAdjustProcessHelper() {
        this.balanceDimFieldParser = new BalanceDimFieldParser();
        this.dimFields = this.balanceDimFieldParser.getDimFields();
        this.prevCostParamMap = new HashMap<Long, String>(16);
        this.inOutAdjustMap = new HashMap<String, DynamicObject>(16);
        this.inAdjEntryRateMap = new HashMap<Long, BigDecimal>(16);
        this.inAdjBillIdSet = new HashSet<Long>(16);
        this.emptyRanges = new HashSet<Long>(16);
        this.accountAndEmptyRangeMap = new HashMap<Long, Long>(16);
        this.rangeAndDivideStr = new HashMap<Long, String>(16);
        this.rangeAndDimenSionStr = new HashMap<Long, String>(16);
        this.recentCostFields = MetadataServiceHelper.getDataEntityType((String)"cal_recentcost").getAllFields().keySet();
    }

    public void dealOutAdjustSet(Set<Long> prevInAdjustIds) {
        String dyNamicFileds;
        QFilter adjFilter = new QFilter("id", "in", prevInAdjustIds);
        adjFilter.and("createtype", "in", (Object)this.CREATETYPES);
        DataSet inAdjustSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costadjust_subentity", (String)this.getCostAdjustBizField(), (QFilter[])adjFilter.toArray(), null);
        inAdjustSet = inAdjustSet.select(this.getCostAdjustBizFieldToInt(inAdjustSet) + ",Int(periodid) as periodid");
        HashSet<Long> recordEntryIds = new HashSet<Long>(16);
        HashSet<Long> materialIds = new HashSet<Long>(16);
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        HashSet<Long> recordIds = new HashSet<Long>(16);
        HashSet<Long> calcRangeIds = new HashSet<Long>(16);
        Boolean allIsNO = Boolean.TRUE;
        Date minCostRecordBookdate = null;
        for (Row row : inAdjustSet.copy()) {
            Long calOrgId;
            String prevCostParam;
            boolean isLessThanMin;
            if (!AccountTypeEnum.MOVE_ADD_AVERAGE.getValue().equals(row.getString("accounttype"))) continue;
            recordEntryIds.add(row.getLong("invbillentryid"));
            recordIds.add(row.getLong("invbillid"));
            materialIds.add(row.getLong("material"));
            costAccountIds.add(row.getLong("costaccount"));
            calcRangeIds.add(row.getLong("calrange"));
            Date curCostRecBookdate = row.getDate("invbizdate");
            boolean bl = isLessThanMin = curCostRecBookdate != null && (minCostRecordBookdate == null || curCostRecBookdate.before(minCostRecordBookdate));
            if (isLessThanMin) {
                minCostRecordBookdate = curCostRecBookdate;
            }
            if ((prevCostParam = this.prevCostParamMap.get(calOrgId = row.getLong("calorg"))) == null) {
                AppParam appParam = new AppParam("/KIUHEXROK3D", "10", calOrgId, Long.valueOf(0L));
                String prevCostAdjustParam = (String)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"prevcostadjustparam");
                this.prevCostParamMap.put(calOrgId, prevCostAdjustParam);
                prevCostParam = prevCostAdjustParam;
            }
            if ("no".equals(prevCostParam)) continue;
            allIsNO = Boolean.FALSE;
        }
        if (allIsNO.booleanValue()) {
            return;
        }
        if (recordEntryIds.isEmpty()) {
            return;
        }
        this.setEmptyEntryRangeInfo(costAccountIds, calcRangeIds, this.emptyRanges, this.accountAndEmptyRangeMap, this.rangeAndDivideStr, this.rangeAndDimenSionStr);
        QFilter recordF = new QFilter("entry.id", "in", recordEntryIds);
        recordF.and("id", "in", recordIds);
        recordF.and("costaccount", "in", costAccountIds);
        String recordFields = "entry.id as entryid,entry.baseqty as baseqty";
        DataSet inRecordSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_subentity", (String)recordFields, (QFilter[])recordF.toArray(), null);
        String[] adjGroups = (String[])ArrayUtils.concatAll((Object[])new String[]{"calorg", "id", "entryid", "invbillentryid", "createtype", "accounttype", "periodid", "entryseq", "adjustamt", "invbizdate", "amtprecision", "calrange", "dividevalue", "caldimvalue", "materialgrouplnum"}, (Object[][])new String[][]{this.dimFields.toArray(new String[0])});
        DataSet inAdjustNoSubSet = inAdjustSet.groupBy(adjGroups).finish();
        inAdjustNoSubSet = inAdjustNoSubSet.leftJoin(inRecordSet).on("invbillentryid", "entryid").select(adjGroups, new String[]{"baseqty"}).finish();
        QFilter outBillFilter = new QFilter("entry.material", "in", materialIds);
        outBillFilter.and("costaccount", "in", costAccountIds);
        outBillFilter.and("billstatus", "=", (Object)"C");
        outBillFilter.and("calbilltype", "=", (Object)"OUT");
        if (minCostRecordBookdate != null) {
            outBillFilter.and("bookdate", ">=", (Object)minCostRecordBookdate);
        }
        if (!(dyNamicFileds = this.balanceDimFieldParser.getCostRecordFields()).contains("calorg")) {
            dyNamicFileds = dyNamicFileds + "calorg,";
        }
        String outRecordFields = dyNamicFileds + "id,billno,bizdate,bookdate,auditdate,customer.id,entry.calrange.id as calrangeid,entry.id,entry.seq,billtype,biztype";
        DataSet outCostRecDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_subentity", (String)outRecordFields, (QFilter[])outBillFilter.toArray(), null);
        PrevCalRangeFunction mapFunction = new PrevCalRangeFunction(this.emptyRanges, this.rangeAndDivideStr, this.rangeAndDimenSionStr, outCostRecDs.getRowMeta());
        outCostRecDs = outCostRecDs.map((MapFunction)mapFunction);
        PrevMaxFunction prevMaxFunction = new PrevMaxFunction(outCostRecDs.getRowMeta());
        outCostRecDs = outCostRecDs.groupBy(new String[]{"dimstr"}).reduceGroup((ReduceGroupFunction)prevMaxFunction);
        HashMap<String, Object[]> outRecordInfos = new HashMap<String, Object[]>();
        for (Row row : outCostRecDs) {
            Object[] values = new Object[]{row.getLong("customer.id"), row.getLong("billtype"), row.getLong("warehouse"), row.getLong("id"), row.getLong("entry.id"), row.getString("billno"), row.getInteger("entry.seq"), row.getLong("biztype")};
            outRecordInfos.put(row.getString("dimstr"), values);
        }
        logger.info("PrevCostAdjustProcessHelper_>outRecordInfos-Key:" + outRecordInfos.keySet());
        QFilter costFilter = new QFilter("material", "in", materialIds);
        costFilter.and("costaccount", "in", costAccountIds);
        DataSet recentCostDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_recentcost", (String)this.getRecentCostField(), (QFilter[])costFilter.toArray(), null);
        recentCostDS = this.groupIgnoreElement(recentCostDS);
        HashMap<Long, CostAccount> costAccountMap = new HashMap<Long, CostAccount>(16);
        for (Long costAccountId : costAccountIds) {
            costAccountMap.put(costAccountId, new CostAccount(costAccountId));
        }
        DealDivideAndDimValueMapFunction adjRangeFun = new DealDivideAndDimValueMapFunction(costAccountMap, this.emptyRanges, this.accountAndEmptyRangeMap, this.rangeAndDivideStr, this.rangeAndDimenSionStr, inAdjustNoSubSet.getRowMeta());
        DealDivideAndDimValueMapFunction recentCostFun = new DealDivideAndDimValueMapFunction(costAccountMap, this.emptyRanges, this.accountAndEmptyRangeMap, this.rangeAndDivideStr, this.rangeAndDimenSionStr, recentCostDS.getRowMeta());
        inAdjustNoSubSet = inAdjustNoSubSet.map((MapFunction)adjRangeFun);
        recentCostDS = recentCostDS.map((MapFunction)recentCostFun);
        recentCostDS = recentCostDS.groupBy(new String[]{"costaccount", "material", "calrange", "dividevalue", "caldimvalue"}).sum("periodendqty").finish();
        JoinDataSet joinDataSet = inAdjustNoSubSet.leftJoin(recentCostDS);
        joinDataSet.on("material", "material").on("calrange", "calrange").on("dividevalue", "dividevalue").on("caldimvalue", "caldimvalue");
        inAdjustNoSubSet = joinDataSet.select(inAdjustNoSubSet.getRowMeta().getFieldNames(), new String[]{"periodendqty"}).finish();
        String[] orderFields = new String[]{"id", "entryseq"};
        inAdjustNoSubSet = inAdjustNoSubSet.orderBy(orderFields);
        for (Object row : inAdjustNoSubSet) {
            String string = row.getString("accounttype");
            if (!AccountTypeEnum.MOVE_ADD_AVERAGE.getValue().equals(string)) continue;
            this.dealMoveAddAveRageOutCost(outRecordInfos, (Row)row);
        }
        if (this.inOutAdjustMap.isEmpty()) {
            logger.info("PrevCostAdjustProcessHelper->noInOutAdjustMap");
            return;
        }
        ArrayList costAdjustList = new ArrayList(this.inOutAdjustMap.size());
        for (Map.Entry entry : this.inOutAdjustMap.entrySet()) {
            costAdjustList.add(entry.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])costAdjustList.toArray(new DynamicObject[costAdjustList.size()]));
        HashSet<Long> set = new HashSet<Long>(costAdjustList.size());
        for (DynamicObject info : costAdjustList) {
            set.add(info.getLong("id"));
        }
        DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((Object[])set.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cal_costadjust_subentity"));
        DynamicObject[] inCostAdjusts = BusinessDataServiceHelper.load((Object[])this.inAdjBillIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cal_costadjust_subentity"));
        Map<Long, DynamicObject> inAdjEntryInfoMap = this.getInAdjEntryInfoMap(inCostAdjusts);
        List<CostAdjustDetailParams> paramsList = this.buildCostAdjustDetail(dynamicObjectArray, inAdjEntryInfoMap);
        OperateOption option = OperateOption.create();
        String params = SerializationUtils.toJsonString(paramsList);
        option.setVariableValue("CostAdjustDetailParms", params);
        option.setVariableValue("ishasright", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_costadjust_subentity", (DynamicObject[])dynamicObjectArray, (OperateOption)option);
        List errors = result.getAllErrorOrValidateInfo();
        if (!result.isSuccess()) {
            StringBuilder msg = new StringBuilder();
            msg.append(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u5ba1\u6838\u5931\u8d25\uff1a", (String)"PrevCostAdjustProcessHelper_0", (String)"fi-cal-business", (Object[])new Object[0]));
            if (!errors.isEmpty()) {
                for (IOperateInfo error : errors) {
                    OperateInfo operror = (OperateInfo)error;
                    msg.append(operror.getMessage()).append('\n');
                }
            }
            msg.append(result.getMessage()).append('\n');
            throw new KDBizException(msg.toString());
        }
    }

    private List<CostAdjustDetailParams> buildCostAdjustDetail(DynamicObject[] costAdjusts, Map<Long, DynamicObject> inAdjEntryInfoMap) {
        ArrayList<CostAdjustDetailParams> paramsList = new ArrayList<CostAdjustDetailParams>();
        for (DynamicObject dynamic : costAdjusts) {
            DynamicObjectCollection costadjustEntry = dynamic.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : costadjustEntry) {
                long entryId = entry.getLong("id");
                Long srcBillEntryId = entry.getLong("srcbillentryid");
                BigDecimal rate = this.inAdjEntryRateMap.get(srcBillEntryId);
                WriteLogHelper.writeInfoLog((Log)logger, (String)("PrevCostAdjustProcessHelper.buildCostAdjustDetail->rate:" + rate), (Object[])new Object[0]);
                if (!inAdjEntryInfoMap.containsKey(srcBillEntryId)) continue;
                DynamicObjectCollection adjEntryDetails = inAdjEntryInfoMap.get(srcBillEntryId).getDynamicObjectCollection("subentryentity");
                for (DynamicObject detail : adjEntryDetails) {
                    CostAdjustDetailParams param = new CostAdjustDetailParams();
                    param.setAdjustAmt(detail.getBigDecimal("sub_adjustamt").multiply(rate).setScale(dynamic.getInt("currency.amtprecision"), RoundingMode.HALF_UP));
                    param.setEntryid((Object)entryId);
                    param.setCostElementId((Object)detail.getLong("costelement.id"));
                    param.setCostSubElementId((Object)detail.getLong("costsubelement.id"));
                    paramsList.add(param);
                }
            }
        }
        return paramsList;
    }

    protected Long getCostTypeId(DynamicObject entity) {
        DynamicObject costTypeDynamic = entity.getDynamicObject("costaccount");
        long costTypeId = costTypeDynamic.getLong("costtype_id");
        return costTypeId;
    }

    private void dealMoveAddAveRageOutCost(Map<String, Object[]> outRecordInfos, Row row) {
        BigDecimal periodEndQty = row.getBigDecimal("periodendqty") == null ? BigDecimal.ZERO : row.getBigDecimal("periodendqty");
        BigDecimal baseQty = row.getBigDecimal("baseqty") == null ? BigDecimal.ZERO : row.getBigDecimal("baseqty");
        WriteLogHelper.writeInfoLog((Log)logger, (String)("PrevCostAdjustProcessHelper->baseQty:" + baseQty), (Object[])new Object[0]);
        WriteLogHelper.writeInfoLog((Log)logger, (String)("PrevCostAdjustProcessHelper->periodEndQty:" + periodEndQty), (Object[])new Object[0]);
        if (baseQty.compareTo(periodEndQty) <= 0 || BigDecimal.ZERO.compareTo(periodEndQty) > 0) {
            return;
        }
        Long calOrgId = row.getLong("calorg");
        String prevCostParam = this.prevCostParamMap.get(calOrgId);
        if (prevCostParam == null) {
            AppParam appParam = new AppParam("/KIUHEXROK3D", "10", calOrgId, Long.valueOf(0L));
            String prevCostAdjustParam = (String)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"prevcostadjustparam");
            this.prevCostParamMap.put(calOrgId, prevCostAdjustParam);
            prevCostParam = prevCostAdjustParam;
        }
        WriteLogHelper.writeInfoLog((Log)logger, (String)("PrevCostAdjustProcessHelper_>prevCostParam:" + prevCostParam), (Object[])new Object[0]);
        if ("no".equals(prevCostParam)) {
            return;
        }
        BigDecimal adjustAmt = row.getBigDecimal("adjustamt");
        BigDecimal rate = baseQty.subtract(periodEndQty).divide(baseQty, 10, RoundingMode.HALF_UP);
        String dealType = this.getDealType(row.getString("createtype"));
        WriteLogHelper.writeInfoLog((Log)logger, (String)("PrevCostAdjustProcessHelper->ivnentryid:" + row.getLong("invbillentryid")), (Object[])new Object[0]);
        WriteLogHelper.writeInfoLog((Log)logger, (String)("PrevCostAdjustProcessHelper->baseQty.subtract(periodEndQty):" + baseQty.subtract(periodEndQty)), (Object[])new Object[0]);
        if (dealType == null) {
            return;
        }
        if (periodEndQty.compareTo(BigDecimal.ZERO) == 0 || "all".equals(prevCostParam)) {
            rate = BigDecimal.ONE;
        }
        adjustAmt = adjustAmt.multiply(rate).setScale((int)row.getInteger("amtprecision"), RoundingMode.HALF_UP);
        WriteLogHelper.writeInfoLog((Log)logger, (String)("PrevCostAdjustProcessHelper->adjustAmt:" + adjustAmt), (Object[])new Object[0]);
        WriteLogHelper.writeInfoLog((Log)logger, (String)("PrevCostAdjustProcessHelper->rate:" + rate), (Object[])new Object[0]);
        Long adjustId = row.getLong("id");
        Long ivnentryid = row.getLong("invbillentryid");
        if (adjustAmt.compareTo(BigDecimal.ZERO) != 0) {
            this.createCostAdjustBill(outRecordInfos, adjustId, ivnentryid, rate, AccountTypeEnum.MOVE_ADD_AVERAGE.getValue());
        }
    }

    private String getDealType(String createType) {
        HashSet<String> apSet = new HashSet<String>(6);
        apSet.add(CostAdjustBillEnum.PURCHASEAUTO.getValue());
        apSet.add(CostAdjustBillEnum.OUTSOURCEAUTO_DIFF.getValue());
        HashSet<String> feeSet = new HashSet<String>(6);
        feeSet.add(CostAdjustBillEnum.FEESHARE.getValue());
        feeSet.add(CostAdjustBillEnum.COST_ESTIMATE.getValue());
        feeSet.add(CostAdjustBillEnum.COST_STRIKE.getValue());
        feeSet.add(CostAdjustBilCreateTypeEnum.PUR_ADJUSTESTIMATE.getValue());
        if (apSet.contains(createType)) {
            return "appurin";
        }
        if (feeSet.contains(createType)) {
            return "fee";
        }
        return null;
    }

    public void createCostAdjustBill(Map<String, Object[]> outRecordInfos, Long adjustId, Long invenrtyid, BigDecimal rate, String accountType) {
        DynamicObject costAdjustInfo = BusinessDataServiceHelper.loadSingle((Object)adjustId, (String)"cal_costadjustbill");
        boolean isFinFout = AccountTypeEnum.FIN_FOUT.getValue().equals(accountType);
        this.addCostAdjustBillEntry(outRecordInfos, invenrtyid, rate, costAdjustInfo, isFinFout, accountType);
    }

    private DynamicObject createCostAdjustHead(Map<String, Object[]> outRecordInfos, DynamicObject costAdjustInfo, BigDecimal rate, boolean isFinFout) {
        DynamicObject costAdjustEntry;
        String outInfoKey;
        DynamicObjectCollection costAdjustEntrys = costAdjustInfo.getDynamicObjectCollection("entryentity");
        Object[] outRecordInfo = null;
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_costadjust_subentity");
        PreDimBuilder preDimBuilder = new PreDimBuilder(this.emptyRanges, this.rangeAndDivideStr, this.rangeAndDimenSionStr);
        Iterator iterator = costAdjustEntrys.iterator();
        while (iterator.hasNext() && (outRecordInfo = outRecordInfos.get(outInfoKey = preDimBuilder.creataAdjustDimKey(entityType, costAdjustInfo, costAdjustEntry = (DynamicObject)iterator.next()))) == null) {
        }
        DynamicObject costAdjustBill = BusinessDataServiceHelper.newDynamicObject((String)"cal_costadjust_subentity");
        costAdjustBill.set("currency", costAdjustInfo.get("currency"));
        Object accountID = costAdjustInfo.getDynamicObject("costaccount").get("masterid");
        DynamicObject costAccont = BusinessDataServiceHelper.loadSingle((Object)accountID, (String)"cal_bd_costaccount", (String)"calorg");
        String number = BillNoHelper.getBillNo((String)"cal_costadjust_subentity", (DynamicObject)costAdjustBill, (String)costAccont.getString("calorg_id"));
        costAdjustBill.set("billno", (Object)number);
        costAdjustBill.set("bizdate", (Object)costAdjustInfo.getDate("bizdate"));
        costAdjustBill.set("bookdate", (Object)costAdjustInfo.getDate("bookdate"));
        costAdjustBill.set("biztype", (Object)"A");
        costAdjustBill.set("billstatus", (Object)"B");
        costAdjustBill.set("createtype", (Object)CostAdjustBillEnum.PREV_COST_ADJUST.getValue());
        costAdjustBill.set("costaccount", (Object)costAdjustInfo.getDynamicObject("costaccount"));
        costAdjustBill.set("calorg", costAccont.get("calorg"));
        if (outRecordInfo != null) {
            costAdjustBill.set("billtype", outRecordInfo[1]);
        }
        Date date = TimeServiceHelper.now();
        costAdjustBill.set("createtime", (Object)date);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        costAdjustBill.set("creator_id", (Object)userId);
        costAdjustBill.set("adminorg", (Object)costAdjustInfo.getDynamicObject("adminorg"));
        costAdjustBill.set("cstype", (Object)"bd_customer");
        return costAdjustBill;
    }

    private void addCostAdjustBillEntry(Map<String, Object[]> outRecordInfos, Long invenrtyid, BigDecimal rate, DynamicObject costAdjustInfo, boolean isFinFout, String accountType) {
        DynamicObjectCollection costAdjustEntrys = costAdjustInfo.getDynamicObjectCollection("entryentity");
        DynamicObject costAdjustEntry = null;
        for (DynamicObject entry : costAdjustEntrys) {
            if (invenrtyid.compareTo(entry.getLong("invbillentryid")) != 0) continue;
            costAdjustEntry = entry;
            break;
        }
        if (costAdjustEntry == null) {
            return;
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_costadjust_subentity");
        PreDimBuilder preDimBuilder = new PreDimBuilder(this.emptyRanges, this.rangeAndDivideStr, this.rangeAndDimenSionStr);
        String outInfoKey = preDimBuilder.creataAdjustDimKey(entityType, costAdjustInfo, costAdjustEntry);
        Object[] outRecordInfo = outRecordInfos.get(outInfoKey);
        Long customerId = 0L;
        if (outRecordInfo != null) {
            customerId = (Long)outRecordInfo[0];
        }
        DynamicObject outCostAdjustBill = null;
        Long adjustId = costAdjustInfo.getLong("id");
        String inAdjKey = adjustId + accountType + customerId;
        if (!this.inOutAdjustMap.containsKey(inAdjKey)) {
            outCostAdjustBill = this.createCostAdjustHead(outRecordInfos, costAdjustInfo, rate, isFinFout);
            if (outCostAdjustBill == null) {
                return;
            }
            this.inOutAdjustMap.put(inAdjKey, outCostAdjustBill);
        }
        DynamicObject costAdjustBillHead = this.inOutAdjustMap.get(inAdjKey);
        DynamicObject entry = costAdjustBillHead.getDynamicObjectCollection("entryentity").addNew();
        entry.set("storageorgunit", costAdjustEntry.get("storageorgunit"));
        entry.set("material", costAdjustEntry.get("material"));
        entry.set("lot", costAdjustEntry.get("lot"));
        costAdjustBillHead.set("biztype", (Object)"B");
        entry.set("adjustamt", (Object)BigDecimal.ZERO);
        entry.set("warehouse", costAdjustEntry.get("warehouse"));
        entry.set("location", costAdjustEntry.get("location"));
        entry.set("ownertype", (Object)"bos_org");
        entry.set("owner", costAdjustEntry.get("owner"));
        entry.set("ecostcenter", costAdjustEntry.get("ecostcenter"));
        entry.set("assist", costAdjustEntry.get("assist"));
        entry.set("invbizdate", costAdjustEntry.get("invbizdate"));
        entry.set("invauditdate", costAdjustEntry.get("invauditdate"));
        entry.set("invbizentityobject", (Object)"cal_costrecord");
        entry.set("srcbilltype", (Object)986031578352241664L);
        entry.set("srcbizentityobject", (Object)"cal_costadjust_subentity");
        entry.set("srcbillnum", costAdjustInfo.get("billno"));
        entry.set("srcentryseq", costAdjustEntry.get("seq"));
        entry.set("srcbillid", costAdjustInfo.get("id"));
        entry.set("srcbillentryid", costAdjustEntry.get("id"));
        entry.set("baseunit", costAdjustEntry.get("baseunit"));
        entry.set("project", costAdjustEntry.get("project"));
        entry.set("invtype", costAdjustEntry.get("invtype"));
        entry.set("invstatus", costAdjustEntry.get("invstatus"));
        entry.set("mversion", costAdjustEntry.get("mversion"));
        entry.set("tracknumber", costAdjustEntry.get("tracknumber"));
        entry.set("configuredcode", costAdjustEntry.get("configuredcode"));
        entry.set("stocktype", costAdjustEntry.get("stocktype"));
        if (outRecordInfo != null) {
            entry.set("warehouse_id", outRecordInfo[2]);
            costAdjustBillHead.set("custsupplier_id", outRecordInfo[0]);
            entry.set("invbillid", outRecordInfo[3]);
            entry.set("invbillentryid", outRecordInfo[4]);
            entry.set("invbillnum", outRecordInfo[5]);
            entry.set("inventryseq", outRecordInfo[6]);
            entry.set("invbiztype", outRecordInfo[7]);
            entry.set("invbilltype", outRecordInfo[1]);
        }
        entry.set("invbizentityobject", (Object)"cal_costrecord_subentity");
        Set exFieldSet = CommonSettingHelper.getExFieldSet();
        MainEntityType costAdjustEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costadjustbill");
        CommonSettingHelper.setExFieldValue((Set)exFieldSet, (MainEntityType)costAdjustEntityType, (MainEntityType)costAdjustEntityType, (DynamicObject)entry, (DynamicObject)costAdjustEntry);
        this.inAdjEntryRateMap.put(costAdjustEntry.getLong("id"), rate);
        this.inAdjBillIdSet.add(costAdjustInfo.getLong("id"));
    }

    private String getCostAdjustBizField() {
        StringBuilder select = new StringBuilder();
        String costAdjustFields = this.balanceDimFieldParser.getCostAdjustFields();
        select.append(costAdjustFields);
        select.append("id,billno,entryentity.id as entryid,entryentity.seq as entryseq,calorg");
        select.append(",isvoucher,period.periodyear*100+period.periodnumber as periodid,billstatus,createtype,entryentity.adjustamt as adjustamt");
        select.append(",entryentity.subentryentity.costsubelement as elementid,entryentity.subentryentity.sub_adjustamt as sub_adjustamt");
        select.append(",currency as localcurrency,currency.amtprecision as amtprecision,currency.priceprecision as priceprecision");
        select.append(",entryentity.accounttype as accounttype,entryentity.invbizdate as invbizdate,entryentity.calrange as calrange");
        select.append(",entryentity.invbillid as invbillid,entryentity.invbillentryid as invbillentryid,entryentity.caldimension as caldimension,bookdate");
        select.append(",' ' as dividevalue,' ' as caldimvalue,entryentity.material.group.longnumber as materialgrouplnum");
        return select.toString();
    }

    private String getCostAdjustBizFieldToInt(DataSet dataset) {
        HashSet<String> set = new HashSet<String>(16);
        for (Field field : dataset.getRowMeta().getFields()) {
            set.add(field.getName());
        }
        set.remove("periodid");
        return String.join((CharSequence)",", set);
    }

    private String getRecentCostField() {
        StringBuilder select = new StringBuilder();
        for (String dimField : this.dimFields) {
            if (!this.recentCostFields.contains(dimField)) continue;
            select.append(dimField).append(",");
        }
        select.append("recentqty as periodendqty");
        select.append(",calrange,' ' as dividevalue,' ' as caldimvalue");
        select.append(",material.group.longnumber as materialgrouplnum");
        if (!this.dimFields.contains("calorg")) {
            select.append(",calorg");
        }
        return select.toString();
    }

    public Long[] getPrevAdjIds(Set<Long> inAdjustIds) {
        QFilter outQ = new QFilter("entryentity.srcbillid", "in", inAdjustIds).and("createtype", "=", (Object)CostAdjustBillEnum.PREV_COST_ADJUST.getValue());
        DynamicObjectCollection outAdjusts = QueryServiceHelper.query((String)"cal_costadjustbill", (String)"id", (QFilter[])outQ.toArray());
        HashSet<Long> prevAdjIds = new HashSet<Long>(outAdjusts.size());
        for (DynamicObject outAdjust : outAdjusts) {
            prevAdjIds.add(outAdjust.getLong("id"));
        }
        return prevAdjIds.toArray(new Long[0]);
    }

    public void unAduitAndDelAdjustBill(Set<Long> inAdjustIds) {
        StringBuilder fields = new StringBuilder();
        MainEntityType calEntityType = EntityMetadataCache.getDataEntityType((String)"cal_costadjust_subentity");
        Set selectorsSet = calEntityType.getAllFields().keySet();
        for (String o : selectorsSet) {
            fields.append(o).append(',');
        }
        fields.setLength(fields.length() - 1);
        QFilter outQ = new QFilter("entryentity.srcbillid", "in", inAdjustIds).and("createtype", "=", (Object)CostAdjustBillEnum.PREV_COST_ADJUST.getValue());
        DynamicObject[] outAdjusts = BusinessDataServiceHelper.load((String)"cal_costadjust_subentity", (String)fields.toString(), (QFilter[])outQ.toArray());
        if (outAdjusts == null || outAdjusts.length == 0) {
            return;
        }
        OperateOption op = OperateOption.create();
        op.setVariableValue("unwriteoff", "true");
        op.setVariableValue("ishasright", "true");
        logger.info("\u524d\u671f\u6210\u672c\u5904\u7406\u8c03\u7528\u63a5\u53e3\uff1a\u6210\u672c\u8c03\u6574\u5355\u53cd\u5ba1\u6838\u5f00\u59cb:" + outAdjusts[0].getString("billno"));
        OperationResult result = OperationServiceHelper.executeOperate((String)"unaudit", (String)"cal_costadjust_subentity", (DynamicObject[])outAdjusts, (OperateOption)op);
        List errors = result.getAllErrorOrValidateInfo();
        if (!errors.isEmpty()) {
            StringBuilder msg = new StringBuilder();
            msg.append(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u53cd\u5ba1\u6838\u5931\u8d25\uff1a", (String)"PurUnWriteOffServiceProcess_0", (String)"fi-cal-business", (Object[])new Object[0]));
            for (IOperateInfo error : errors) {
                OperateInfo operror = (OperateInfo)error;
                msg.append(operror.getMessage()).append('\n');
            }
            throw new KDBizException(msg.toString());
        }
        logger.info("\u524d\u671f\u6210\u672c\u5904\u7406\u8c03\u7528\u63a5\u53e3\uff1a\u6210\u672c\u8c03\u6574\u5355\u53cd\u5ba1\u6838\u7ed3\u675f:" + outAdjusts[0].getString("billno"));
        logger.info("\u524d\u671f\u6210\u672c\u5904\u7406\u8c03\u7528\u63a5\u53e3\uff1a\u6210\u672c\u8c03\u6574\u5355\u53cd\u5ba1\u6838\u4fe1\u606f:" + result.getMessage());
        logger.info("\u524d\u671f\u6210\u672c\u5904\u7406\u8c03\u7528\u63a5\u53e3\uff1a\u6210\u672c\u8c03\u6574\u5355\u53cd\u5ba1\u6838\u6210\u529fID:" + result.getSuccessPkIds().get(0));
        Set<Long> billids = new HashSet<Long>(16);
        for (DynamicObject outAdjust : outAdjusts) {
            billids.add(outAdjust.getLong("id"));
        }
        logger.info("\u524d\u671f\u6210\u672c\u5904\u7406\u8c03\u7528\u63a5\u53e3\uff1a\u6210\u672c\u8c03\u6574\u5355\u5220\u9664\u5f00\u59cb:" + billids);
        billids = CalIntimeBufferPoolHelper.removeBufferPoolRevBill("cal_costadjust_subentity", billids);
        logger.info("\u524d\u671f\u6210\u672c\u5904\u7406\u8c03\u7528\u63a5\u53e3\uff1a\u6210\u672c\u8c03\u6574\u5355\u5220\u9664\u5f00\u59cb:" + billids);
        if (!billids.isEmpty()) {
            QFilter deleteFilter = new QFilter("id", "in", billids);
            DeleteServiceHelper.delete((String)"cal_costadjust_subentity", (QFilter[])new QFilter[]{deleteFilter});
        }
        logger.info("\u524d\u671f\u6210\u672c\u5904\u7406\u8c03\u7528\u63a5\u53e3\uff1a\u6210\u672c\u8c03\u6574\u5355\u5220\u9664\u7ed3\u675f:" + outQ);
    }

    private DataSet groupIgnoreElement(DataSet recentCostDS) {
        StringBuilder groupFields = new StringBuilder();
        for (String dimField : this.dimFields) {
            if (!this.recentCostFields.contains(dimField) || "costsubelement".equals(dimField) || "costelement".equals(dimField)) continue;
            groupFields.append(dimField).append(",");
        }
        groupFields.append("calrange,dividevalue,caldimvalue,materialgrouplnum");
        if (!this.dimFields.contains("calorg")) {
            groupFields.append(",calorg");
        }
        GroupbyDataSet groupByDataSet = recentCostDS.groupBy(groupFields.toString().split(","));
        groupByDataSet.max("periodendqty");
        recentCostDS = groupByDataSet.finish().select(recentCostDS.getRowMeta().getFieldNames());
        return recentCostDS;
    }

    private Map<Long, DynamicObject> getInAdjEntryInfoMap(DynamicObject[] inCostAdjusts) {
        HashMap<Long, DynamicObject> entryInfosMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject inCostAdjust : inCostAdjusts) {
            DynamicObjectCollection entrys = inCostAdjust.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                entryInfosMap.put(entry.getLong("id"), entry);
            }
        }
        return entryInfosMap;
    }

    private void setEmptyEntryRangeInfo(Set<Long> costAccountIds, Set<Long> calcRangeIds, Set<Long> emptyEntryRanges, Map<Long, Long> accountAndEmptyRangeMap, Map<Long, String> rangeAndDivideStr, Map<Long, String> rangeAndDimenSionStr) {
        DynamicObject[] calRanges;
        QFilter filter = new QFilter("costaccount", "in", costAccountIds);
        filter.and("id", "in", calcRangeIds);
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        for (DynamicObject calRange : calRanges = BusinessDataServiceHelper.load((String)"cal_bd_calrange", (String)"id,entry,costaccount,dividebasis,dividebasis.dividebasis,caldimension,caldimension.caldimension", (QFilter[])filter.toArray())) {
            DynamicObjectCollection entryDycs = calRange.getDynamicObjectCollection("entry");
            Long accountId = calRange.getDynamicObject("costaccount").getLong("id");
            Long calrangeId = calRange.getLong("id");
            String dividebasisStr = CommonUtils.trimComma((String)calRange.getDynamicObject("dividebasis").getString("dividebasis"));
            DynamicObject caldimension = calRange.getDynamicObject("caldimension");
            String caldimensionStr = null;
            if (caldimension != null) {
                caldimensionStr = CommonUtils.trimComma((String)caldimension.getString("caldimension"));
            }
            if (entryDycs.isEmpty()) {
                emptyEntryRanges.add(calrangeId);
                accountAndEmptyRangeMap.put(accountId, calrangeId);
            }
            rangeAndDivideStr.put(calrangeId, dividebasisStr);
            if (caldimensionStr == null) continue;
            rangeAndDimenSionStr.put(calrangeId, caldimensionStr);
        }
        logger.info("PrevCostAdjustProcessHelper_>rangeAndDivideStr:" + rangeAndDivideStr);
        logger.info("PrevCostAdjustProcessHelper_>rangeAndDimenSionStr:" + rangeAndDimenSionStr);
        logger.info("PrevCostAdjustProcessHelper_>accountAndEmptyRangeMap:" + accountAndEmptyRangeMap);
    }
}

