/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.inner;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.process.inner.TriggerEventHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;

public class PriceFluctHolder {
    private final String entityName;
    private static final String fields = "entryid,billid,rate";
    private List<Object[]> eIdFluctInfoList = new ArrayList<Object[]>(16);
    private Set<Long> needSdPriceFluctRecEIds = new HashSet<Long>(16);
    private final Integer priceFluctCount = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.PRICE_FLUCT_COUNT);

    public PriceFluctHolder(String entityName, Long[] billIds) {
        this.entityName = entityName;
        this.needSdPriceFluctRecEIds = this.getNeedSdPriceFluctRecEIds(Arrays.asList(billIds));
    }

    public void addFuctuationParams(BigDecimal befRecQty, BigDecimal befRecCOst, BigDecimal aftRecQty, BigDecimal aftRecCost, long eId, long billId) {
        BigDecimal threshold;
        if (this.eIdFluctInfoList.size() > this.priceFluctCount) {
            return;
        }
        if (this.needSdPriceFluctRecEIds.isEmpty() || !this.needSdPriceFluctRecEIds.contains(eId)) {
            return;
        }
        BigDecimal befUnitRecCost = befRecQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : befRecCOst.divide(befRecQty, 10, RoundingMode.HALF_UP);
        BigDecimal aftUnitRecCost = aftRecQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : aftRecCost.divide(aftRecQty, 10, RoundingMode.HALF_UP);
        BigDecimal priceFloat = befUnitRecCost.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : befUnitRecCost.subtract(aftUnitRecCost).divide(befUnitRecCost, 4, RoundingMode.HALF_UP).abs();
        if (priceFloat.compareTo(threshold = CalDbParamServiceHelper.getBigDecimal((String)CalDbParamConstant.PRICE_FLUCT_THRESHOLD)) < 0) {
            return;
        }
        this.eIdFluctInfoList.add(new Object[]{eId, billId, priceFloat});
    }

    public void sendFluctEvent() {
        if (this.eIdFluctInfoList.isEmpty()) {
            return;
        }
        JSONObject param = new JSONObject();
        param.put("info", this.eIdFluctInfoList);
        param.put("fields", (Object)fields);
        param.put("entityNumber", (Object)this.entityName);
        new TriggerEventHelper().triggerEvent("CalPriceFluctuation", param);
    }

    private Set<Long> getNeedSdPriceFluctRecEIds(Collection<Long> costRecordIds) {
        String fieldName = "entry.id";
        QFilter useFilter = new QFilter("use", "=", (Object)"pricefluct");
        String[] entitys = new String[]{"cal_costrecord", "cal_costrecord_subentity"};
        QFilter entityFilter = new QFilter("entity", "in", (Object)entitys);
        DataSet filterDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_filter_config", (String)"filter_tag", (QFilter[])new QFilter[]{useFilter, entityFilter}, null);
        ArrayList<OrmInput> billOIs = new ArrayList<OrmInput>(16);
        QFilter recIdFilter = new QFilter("id", "in", costRecordIds);
        for (Row row : filterDs) {
            String filterTag = row.getString("filter_tag");
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterTag, FilterCondition.class);
            FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)"cal_costrecord_subentity"), filterCondition);
            filterBuilder.buildFilter();
            QFilter filter = filterBuilder.getQFilter();
            OrmInput ormInput = new OrmInput(this.getClass().getName(), "cal_costrecord_subentity", fieldName, new QFilter[]{recIdFilter, filter});
            billOIs.add(ormInput);
        }
        if (billOIs.isEmpty()) {
            return new HashSet<Long>(0);
        }
        HashSet<Long> needSdPriceFluctRecEIds = new HashSet<Long>(16);
        Lists.partition(billOIs, (int)10).forEach(list -> {
            DataSet recIdDs = Algo.create((String)this.getClass().getName()).createDataSet(list.toArray(new Input[list.size()]));
            for (Row row : recIdDs) {
                needSdPriceFluctRecEIds.add(row.getLong(fieldName));
            }
        });
        return needSdPriceFluctRecEIds;
    }
}

