/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.inner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;

public class QueryInvOrgHelper {
    private Boolean mqSplit = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.PROCESS_MQ_SPLIT);

    public List<Long> queryInvOrgByEntity(String entityName, Collection<Long> billIds) {
        if (!this.mqSplit.booleanValue()) {
            return new ArrayList<Long>(0);
        }
        List<Object> invOrgIds = new ArrayList(16);
        if ("cal_costrecord".equals(entityName) || "cal_costrecord_subentity".equals(entityName)) {
            invOrgIds = this.getCostRecordBillInvOrgIdList(billIds);
        } else if ("cal_costadjustbill".equals(entityName) || "cal_costadjust_subentity".equals(entityName)) {
            invOrgIds = this.getCostAdjustBillInvOrgIdList(billIds);
        } else if ("cal_initbill".equals(entityName)) {
            invOrgIds = this.getCalInitBillInvOrgIdList(billIds);
        }
        return invOrgIds;
    }

    public List<Long> getCostRecordBillInvOrgIdList(Collection<Long> costRecordIds) {
        if (!this.mqSplit.booleanValue()) {
            return new ArrayList<Long>(0);
        }
        HashSet<Long> invOrgIdSet = new HashSet<Long>(16);
        QFilter filter = new QFilter("id", "in", costRecordIds);
        filter.and("entry.accounttype", "=", (Object)AccountTypeEnum.MOVE_ADD_AVERAGE.getValue());
        try (DataSet adjustBillDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"storageorgunit", (QFilter[])filter.toArray(), null);){
            for (Row row : adjustBillDs) {
                invOrgIdSet.add(row.getLong("storageorgunit"));
            }
        }
        ArrayList<Long> invOrgIdList = new ArrayList<Long>(invOrgIdSet);
        this.sort(invOrgIdList);
        return invOrgIdList;
    }

    public List<Long> getCostRecordBillInvOrgIdListByBizBill(Collection<Long> bizBillIds) {
        if (!this.mqSplit.booleanValue()) {
            return new ArrayList<Long>(0);
        }
        HashSet<Long> invOrgIdSet = new HashSet<Long>(16);
        QFilter filter = new QFilter("bizbillid", "in", bizBillIds);
        filter.and("entry.accounttype", "=", (Object)AccountTypeEnum.MOVE_ADD_AVERAGE.getValue());
        try (DataSet costRecordDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"storageorgunit", (QFilter[])filter.toArray(), null);){
            for (Row row : costRecordDs) {
                invOrgIdSet.add(row.getLong("storageorgunit"));
            }
        }
        ArrayList<Long> invOrgIdList = new ArrayList<Long>(invOrgIdSet);
        this.sort(invOrgIdList);
        return invOrgIdList;
    }

    public List<Long> getCostAdjustBillInvOrgIdList(Collection<Long> costAdjustBillIds) {
        if (!this.mqSplit.booleanValue()) {
            return new ArrayList<Long>(0);
        }
        HashSet<Long> invOrgIdSet = new HashSet<Long>(16);
        QFilter filter = new QFilter("id", "in", costAdjustBillIds);
        filter.and("entryentity.accounttype", "=", (Object)AccountTypeEnum.MOVE_ADD_AVERAGE.getValue());
        try (DataSet adjustBillDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costadjustbill", (String)"entryentity.storageorgunit storageorgunit", (QFilter[])filter.toArray(), null);){
            for (Row row : adjustBillDs) {
                invOrgIdSet.add(row.getLong("storageorgunit"));
            }
        }
        ArrayList<Long> invOrgIdList = new ArrayList<Long>(invOrgIdSet);
        this.sort(invOrgIdList);
        return invOrgIdList;
    }

    public List<Long> getCalInitBillInvOrgIdList(Collection<Long> calInitBillIds) {
        if (!this.mqSplit.booleanValue()) {
            return new ArrayList<Long>(0);
        }
        HashSet<Long> invOrgIdSet = new HashSet<Long>(16);
        QFilter filter = new QFilter("id", "in", calInitBillIds);
        filter.and("entryentity.accounttype", "=", (Object)AccountTypeEnum.MOVE_ADD_AVERAGE.getValue());
        try (DataSet adjustBillDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_initbill", (String)"entryentity.storageorgunit storageorgunit", (QFilter[])filter.toArray(), null);){
            for (Row row : adjustBillDs) {
                invOrgIdSet.add(row.getLong("storageorgunit"));
            }
        }
        ArrayList<Long> invOrgIdList = new ArrayList<Long>(invOrgIdSet);
        this.sort(invOrgIdList);
        return invOrgIdList;
    }

    private void sort(List<Long> invOrgIdList) {
        Collections.sort(invOrgIdList);
    }
}

