/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.inner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.plugin.IBizPlugin;
import kd.sdk.fi.cal.extpoint.costrecord.IQueueTypeMatch;

public class QueueTypeHelper {
    public static void assignQueueType4CostRecord(DynamicObject[] costRecords) {
        String sql = "update t_cal_calcostrecordentry set fqueuetype = ? ,fsignnum = ? where fentryid = ?";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        HashSet<Long> ids = new HashSet<Long>(16);
        for (int i = 0; i < costRecords.length; ++i) {
            DynamicObject recordInfo = costRecords[i];
            ids.add(recordInfo.getLong("id"));
            String billType = recordInfo.getDynamicObject("bizentityobject").getString("number");
            Object costAccountID = recordInfo.get("costaccount_id");
            Object billid = recordInfo.get("bizbillid");
            String calBillType = recordInfo.getString("calbilltype");
            String queueType = QueueTypeHelper.getQueueTypeBySetting(costAccountID, billType, billid, calBillType);
            int signnum = QueueTypeHelper.getSignNum(queueType, calBillType);
            DynamicObjectCollection entrys = recordInfo.getDynamicObjectCollection("entry");
            for (int j = 0; j < entrys.size(); ++j) {
                DynamicObject recordEntry = (DynamicObject)entrys.get(j);
                recordEntry.set("queuetype", (Object)queueType);
                recordEntry.set("signnum", (Object)signnum);
                paramList.add(new Object[]{queueType, signnum, recordEntry.getLong("id")});
            }
        }
        if (!paramList.isEmpty()) {
            try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, ids)});){
                ctx.set();
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, paramList);
            }
        }
    }

    public static void assingQueueType4CostAdjust(DynamicObject[] costAdjustBill, boolean isStdCostDiffBill, Set<String> updateQueuetypeIdSet) {
        for (int i = 0; i < costAdjustBill.length; ++i) {
            DynamicObject info = costAdjustBill[i];
            String billType = "cal_costadjustbill";
            if (isStdCostDiffBill) {
                billType = "cal_stdcostdiffbill";
            }
            Object costAccountID = info.get("costaccount.id");
            Object billid = info.get("id");
            String calBillType = info.getString("biztype");
            if ("A".equals(calBillType)) {
                calBillType = "IN";
            } else if ("B".equals(calBillType)) {
                calBillType = "OUT";
            }
            String queueType = QueueTypeHelper.getQueueTypeBySetting(costAccountID, billType, billid, calBillType);
            int signnum = QueueTypeHelper.getSignNum(queueType, calBillType);
            String createType = info.getString("createtype");
            if (CostAdjustBilCreateTypeEnum.CAL_OUT_BEFORE_PERIOD.getValue().equals(createType)) {
                queueType = "0";
                signnum = -1;
            }
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entryentity");
            for (int j = 0; j < entrys.size(); ++j) {
                DynamicObject entry = (DynamicObject)entrys.get(j);
                String entryId = String.valueOf(entry.getLong("id"));
                if (updateQueuetypeIdSet != null && updateQueuetypeIdSet.contains(entryId)) continue;
                entry.set("queuetype", (Object)queueType);
                entry.set("signnum", (Object)signnum);
            }
        }
    }

    private static int getSignNum(String queueType, String calBillType) {
        Integer signnum = null;
        signnum = "0".equals(queueType) && "IN".equals(calBillType) ? Integer.valueOf(1) : ("1".equals(queueType) && "OUT".equals(calBillType) ? Integer.valueOf(1) : Integer.valueOf(-1));
        return signnum;
    }

    private static String getQueueTypeBySetting(Object costAccountID, String billType, Object billid, String calBillType) {
        String costAccountId = null;
        costAccountId = costAccountID instanceof DynamicObject ? ((DynamicObject)costAccountID).get("id").toString() : costAccountID.toString();
        Long costAccId = Long.valueOf(costAccountId);
        QFilter filter = new QFilter("costaccount.id", "=", (Object)costAccId);
        filter.and(new QFilter("billtype", "=", (Object)billType));
        filter.and("enable", "=", (Object)"1");
        Map settingInfoMap = BusinessDataServiceHelper.loadFromCache((String)"cal_queuesetting", (String)"id,billno,bizbillno,filterstr_tag,queuetype,bizplugin.plugin,billtype", (QFilter[])new QFilter[]{filter});
        String queueType = null;
        if (settingInfoMap != null && !settingInfoMap.isEmpty()) {
            for (DynamicObject settingInfo : settingInfoMap.values()) {
                MainEntityType bizEntityType = EntityMetadataCache.getDataEntityType((String)billType);
                String filterstr = settingInfo.getString("filterstr_tag");
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterstr, FilterCondition.class);
                FilterBuilder filterBuilder = new FilterBuilder(bizEntityType, filterCondition);
                filterBuilder.buildFilter();
                List list = filterBuilder.getQFilters();
                QFilter qf = new QFilter("id", "=", billid);
                list.add(qf);
                if (!QueryServiceHelper.exists((String)billType, (QFilter[])list.toArray(new QFilter[0])) || !QueueTypeHelper.isMatchPlugin(settingInfo, billid)) continue;
                String settingQueue = settingInfo.getString("queuetype");
                if ("A".equals(settingQueue)) {
                    queueType = "0";
                } else if ("B".equals(settingQueue)) {
                    queueType = "1";
                }
                break;
            }
        } else {
            PluginProxy pluginProxy = PluginProxy.create(null, IQueueTypeMatch.class, (String)"FI_CAL_COSTRECORD_QUEUETYPE", null);
            List ext_queueTypes = pluginProxy.callReplace(p -> {
                String result = p.getQueueType(costAccId, billType, Long.valueOf(billid.toString()));
                return result;
            });
            if (ext_queueTypes != null && !ext_queueTypes.isEmpty()) {
                queueType = (String)ext_queueTypes.get(0);
            }
        }
        if (queueType != null && !queueType.equals("1") && !queueType.equals("0")) {
            queueType = null;
        }
        if (queueType == null) {
            queueType = "OUT".equals(calBillType) ? "1" : "0";
        }
        return queueType;
    }

    private static boolean isMatchPlugin(DynamicObject settingInfo, Object billid) {
        DynamicObject bizPlugin = settingInfo.getDynamicObject("bizplugin");
        DynamicObject bizEntity = settingInfo.getDynamicObject("billtype");
        if (bizPlugin == null) {
            return true;
        }
        String plugin = bizPlugin.getString("plugin");
        try {
            IBizPlugin pluginImpl = (IBizPlugin)TypesContainer.getOrRegisterSingletonInstance((String)plugin);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("bizentitynumber", bizEntity.getString("id"));
            map.put("billid", billid);
            return (Boolean)pluginImpl.doPlugin(map, null);
        }
        catch (Exception e) {
            throw new KDBizException(CommonUtils.getLogMessage((Throwable)e));
        }
    }
}

