/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.inner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.model.CostRecordEntyInfo;

public class SyncBillGroupCostProcess {
    public void syncBillcost(ArrayList<DynamicObject> billGroupRecords) {
        if (billGroupRecords == null || billGroupRecords.size() == 0) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (DynamicObject record : billGroupRecords) {
            long srcbillentryid = record.getLong("srcbillentryid");
            long destbillentryid = record.getLong("destbillentryid");
            ids.add(srcbillentryid);
            ids.add(destbillentryid);
        }
        Map<Long, List> costRecordList = this.getCostRecordEntry(ids);
        this.sysnCost(billGroupRecords, costRecordList);
    }

    private void sysnCost(ArrayList<DynamicObject> billGroupRecords, Map<Long, List> costRecordList) {
        String sql1 = this.getUpdateSQL1();
        String sql2 = this.getUpdateSQL2();
        String sql3 = this.getUpdateSQL3();
        List params = this.buildRelateionParams(billGroupRecords, costRecordList);
        if (params.size() > 0) {
            DB.executeBatch((DBRoute)this.getCalDBRouteKey(), (String)sql1, (List)params);
            DB.executeBatch((DBRoute)this.getCalDBRouteKey(), (String)sql2, (List)params);
            DB.executeBatch((DBRoute)this.getCalDBRouteKey(), (String)sql3, (List)params);
        }
    }

    private List buildRelateionParams(ArrayList<DynamicObject> billGroupRecords, Map<Long, List> costRecordList) {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (Map.Entry<Long, List> mapEntry : costRecordList.entrySet()) {
            Long costAccountID = mapEntry.getKey();
            List recordEntrys = mapEntry.getValue();
            for (DynamicObject record : billGroupRecords) {
                long srcbillentryid = record.getLong("srcbillentryid");
                long destbillentryid = record.getLong("destbillentryid");
                Object[] param = this.buildUpdateParams(recordEntrys, srcbillentryid, destbillentryid);
                if (param == null) continue;
                params.add(param);
            }
        }
        return params;
    }

    private String getUpdateSQL1() {
        StringBuilder update = new StringBuilder();
        update.append(" update t_cal_calcostrecordentry set funitactualcost = ? , factualcost = ? where fentryid =  ?");
        return update.toString();
    }

    private String getUpdateSQL2() {
        StringBuilder update = new StringBuilder();
        update.append(" update t_cal_outqueuerecord set funitactualcost = ? , factualcost = ? where fcalbillentryid =  ?");
        return update.toString();
    }

    private String getUpdateSQL3() {
        StringBuilder update = new StringBuilder();
        update.append(" update t_cal_inqueuerecord set funitactualcost = ? , factualcost = ? where fcalbillentryid =  ?");
        return update.toString();
    }

    private Object[] buildUpdateParams(List<CostRecordEntyInfo> recordEntrys, Long srcID, Long destID) {
        CostRecordEntyInfo srcEntry = null;
        CostRecordEntyInfo destEntry = null;
        Object[] recordParam = new Object[3];
        for (CostRecordEntyInfo info : recordEntrys) {
            Long bizEntryID = info.getBizEntryID();
            Long calEntryID = info.getCalentryid();
            if (bizEntryID.longValue() == srcID.longValue() || calEntryID.longValue() == srcID.longValue()) {
                srcEntry = info;
            }
            if (bizEntryID.longValue() != destID.longValue() && calEntryID.longValue() != destID.longValue()) continue;
            destEntry = info;
        }
        if (srcEntry == null || destEntry == null) {
            return null;
        }
        recordParam[0] = srcEntry.getUnitActualCost();
        recordParam[1] = srcEntry.getActualCost();
        recordParam[2] = destEntry.getEntryID();
        return recordParam;
    }

    private Map<Long, List> getCostRecordEntry(List ids) {
        HashMap<Long, List> retMap = new HashMap<Long, List>();
        StringBuilder fields = new StringBuilder();
        fields.append("id,entry.id,costaccount.id,entry.bizbillentryid,entry.calentryid,entry.actualcost,entry.unitactualcost,entry.baseqty");
        QFilter filter = new QFilter("entry.bizbillentryid", "in", (Object)ids);
        filter.or(new QFilter("entry.calentryid", "in", (Object)ids));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"SyncBillGroupCostProcess_getCostRecordEntry", (String)"cal_costrecord", (String)fields.toString(), (QFilter[])new QFilter[]{filter}, null);
        for (Row entry : dataSet) {
            long costAccountID = entry.getLong("costaccount.id");
            long entryID = entry.getLong("id");
            List recordEntryList = this.getEntryInfoMap(costAccountID, retMap);
            CostRecordEntyInfo info = new CostRecordEntyInfo();
            info.setActualCost(entry.getBigDecimal("entry.actualcost"));
            info.setBaseQty(entry.getBigDecimal("entry.baseqty"));
            info.setUnitActualCost(entry.getBigDecimal("entry.unitactualcost"));
            info.setEntryID(Long.valueOf(entryID));
            info.setBizEntryID(entry.getLong("entry.bizbillentryid"));
            info.setCalentryid(entry.getLong("entry.calentryid"));
            recordEntryList.add(info);
            retMap.put(costAccountID, recordEntryList);
        }
        return retMap;
    }

    private List getEntryInfoMap(Long costAccountID, Map costAccountMap) {
        ArrayList retValue = (ArrayList)costAccountMap.get(costAccountID);
        if (retValue == null) {
            retValue = new ArrayList();
        }
        return retValue;
    }

    public DBRoute getCalDBRouteKey() {
        return new DBRoute("cal");
    }
}

