/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.inner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.calculate.out.IntimeBufferPoolHandle;
import kd.fi.cal.business.calculate.out.calintime.CalInTimeBufferPoolManager;
import kd.fi.cal.business.process.inner.DeleteCalBillHelper;
import kd.fi.cal.business.service.CalProcessContext;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.helper.CalBillRuleCheckHelper;
import kd.fi.cal.common.helper.CalGroupAccountHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.ScmParamsHelper;
import kd.fi.cal.common.model.SynBillErrInfo;

public class SyncOpLegalChecker {
    private Map<Long, DynamicObject> successOpBizBillDycsMap = new HashMap<Long, DynamicObject>(16);
    private Set<Long> successOpBizBillIds = new HashSet<Long>(16);
    private Map<Long, DynamicObject> sucessDbBizBillIdDycsMap = new HashMap<Long, DynamicObject>(16);
    private Map<Long, SynBillErrInfo> errMap = new HashMap<Long, SynBillErrInfo>(32);
    private String entity = "";
    private String opName = "";
    private Map<Long, DynamicObject> sucessBizBillIdDBCostRecordMap = new HashMap<Long, DynamicObject>(16);
    private Map<Long, Boolean> sucessBizBillIdCalIngMap = new HashMap<Long, Boolean>(16);
    private boolean cancel = false;
    private List<DynamicObject> reExecuteSubmitBizDycs = new ArrayList<DynamicObject>(16);
    private Map params = null;
    private boolean containsLastupdatetimeField = true;
    private CalProcessContext calProcessContext;

    public SyncOpLegalChecker(DynamicObject[] curOpBizBillDycs, String opName) {
        if (curOpBizBillDycs == null || curOpBizBillDycs.length < 1) {
            return;
        }
        this.opName = opName;
        this.entity = curOpBizBillDycs[0].getDataEntityType().getName();
        for (DynamicObject bizBillDyc : curOpBizBillDycs) {
            long id = bizBillDyc.getLong("id");
            this.successOpBizBillIds.add(id);
            this.successOpBizBillDycsMap.put(id, bizBillDyc);
        }
        this.containsLastupdatetimeField = EntityMetadataCache.getDataEntityType((String)this.entity).getProperties().containsKey((Object)"lastupdatetime");
        this.loadCostRecord();
        this.loadBizBillIdDycsMap();
    }

    public void doCheck() {
        this.checkCalStatus();
        if (this.params != null && this.params.get("legalCheck") != null) {
            this.reSyncUnAuditDelSubCostRecBill();
            return;
        }
        if (ActionEnum.SUBMIT.getValue().equals(this.opName)) {
            this.doCheckSubmit();
        } else if (ActionEnum.AUDIT.getValue().equals(this.opName)) {
            this.doCheckAudit();
        } else if (ActionEnum.UN_AUDIT.getValue().equals(this.opName)) {
            this.doCheckUnAudit();
        } else if (ActionEnum.MATERIALWRITEOFF.getValue().equals(this.opName)) {
            this.doCheckMatWriteOff();
        }
    }

    public void doCheckSubmit() {
        String saveMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u662f\u6682\u5b58\u72b6\u6001\uff0c\u8be5\u4efb\u52a1\u53d6\u6d88\u3002", (String)"SyncBizBill4SubmitServiceProcess_21", (String)"fi-cal-business", (Object[])new Object[0]);
        ArrayList<DynamicObject> tmpSucessDbBizBillIdDycs = new ArrayList<DynamicObject>(this.sucessDbBizBillIdDycsMap.values());
        for (DynamicObject dbBizBillDyc : tmpSucessDbBizBillIdDycs) {
            String dbBizBillStatus = dbBizBillDyc.getString("billstatus");
            boolean dbBizBillIsSave = "A".equals(dbBizBillStatus);
            if (!dbBizBillIsSave) continue;
            this.addErrorMsg(dbBizBillDyc.getLong("id"), "5", saveMsg);
        }
        tmpSucessDbBizBillIdDycs = new ArrayList<DynamicObject>(this.sucessDbBizBillIdDycsMap.values());
        for (DynamicObject dbBizBillDyc : tmpSucessDbBizBillIdDycs) {
            boolean isRecordEqualBizBillModifyTime;
            long dbBizBillId = dbBizBillDyc.getLong("id");
            DynamicObject dbCostRecordDyc = this.sucessBizBillIdDBCostRecordMap.get(dbBizBillId);
            if (dbCostRecordDyc == null || this.getModifytime(dbCostRecordDyc) == 0L || !(isRecordEqualBizBillModifyTime = this.getModifytime(dbCostRecordDyc) >= this.getModifytime(dbBizBillDyc))) continue;
            this.addErrorMsg(dbBizBillId, "6", "IGNORE");
        }
        this.doCancelCalTimeLargeEqualInvTime();
        String bizErrorMsg = ResManager.loadKDString((String)"\u6838\u7b97\u5355\u540c\u6b65\u672a\u5b8c\u6210\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"SyncBizBill4AfterAuditServiceProcess_1", (String)"fi-cal-business", (Object[])new Object[0]);
        tmpSucessDbBizBillIdDycs = new ArrayList<DynamicObject>(this.sucessDbBizBillIdDycsMap.values());
        for (DynamicObject dbBizBillDyc : tmpSucessDbBizBillIdDycs) {
            boolean recordLessBizBillModifyTime;
            long dbBizBillId = dbBizBillDyc.getLong("id");
            DynamicObject dbCostRecordDyc = this.sucessBizBillIdDBCostRecordMap.get(dbBizBillId);
            if (dbCostRecordDyc == null || this.getModifytime(dbCostRecordDyc) == 0L) continue;
            String dbBizBillStatus = dbBizBillDyc.getString("billstatus");
            boolean dbBizBillIsSubmitOrAudit = "B".equals(dbBizBillStatus) || "C".equals(dbBizBillStatus);
            String dbCostRecordStatus = dbCostRecordDyc.getString("billstatus");
            boolean dbCostRecordIsAudit = "C".equals(dbCostRecordStatus);
            boolean bl = recordLessBizBillModifyTime = this.getModifytime(dbCostRecordDyc) < this.getModifytime(dbBizBillDyc);
            if (!dbBizBillIsSubmitOrAudit || !recordLessBizBillModifyTime || !dbCostRecordIsAudit) continue;
            this.addErrorMsg(dbBizBillId, "3", bizErrorMsg);
        }
    }

    private long getModifytime(DynamicObject dbCostRecordDyc) {
        if (!this.containsLastupdatetimeField || null == dbCostRecordDyc.getDate("lastupdatetime")) {
            return dbCostRecordDyc.getDate("modifytime").getTime();
        }
        return dbCostRecordDyc.getDate("lastupdatetime").getTime();
    }

    private void doCheckAudit() {
        CalBillRuleCheckHelper calBillRuleCheckHelper = new CalBillRuleCheckHelper(this.entity, this.successOpBizBillIds);
        calBillRuleCheckHelper.addSkipProperty("billstatus");
        Set failBillIds = calBillRuleCheckHelper.check();
        if (calBillRuleCheckHelper.isNoUseRules()) {
            String msg = ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u6ca1\u6709\u914d\u7f6e\u6620\u5c04\u5173\u7cfb\u3002", (String)"SyncBizBill4AuditServiceProcess_1", (String)"fi-cal-business", (Object[])new Object[0]);
            HashSet<Long> successOpBizBillIds = new HashSet<Long>(this.successOpBizBillIds);
            for (Long failId : successOpBizBillIds) {
                this.addErrorMsg(failId, "5", msg);
            }
            return;
        }
        String notMatchCalRuleMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u4e0d\u6ee1\u8db3\u6838\u7b97\u5355\u914d\u7f6e\u7684\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"SyncBizBill4AuditServiceProcess_4", (String)"fi-cal-business", (Object[])new Object[0]);
        for (Long failId : failBillIds) {
            this.addErrorMsg(failId, "5", notMatchCalRuleMsg);
        }
        String unAuditMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u672a\u5ba1\u6838\uff0c\u8be5\u4efb\u52a1\u53d6\u6d88\u3002", (String)"SyncBizBill4AuditServiceProcess_25", (String)"fi-cal-business", (Object[])new Object[0]);
        ArrayList<DynamicObject> tmpSuccessOpBizBillDycs = new ArrayList<DynamicObject>(this.successOpBizBillDycsMap.values());
        boolean isBizFinInt = ScmParamsHelper.isEnable((String)"INV0005");
        for (DynamicObject bizBillDyc : tmpSuccessOpBizBillDycs) {
            if ("C".equals(bizBillDyc.getString("billstatus")) || isBizFinInt) continue;
            this.addErrorMsg(bizBillDyc.getLong("id"), "5", unAuditMsg);
        }
        String notSyncMsg = ResManager.loadKDString((String)"\u6838\u7b97\u5355\u540c\u6b65\u672a\u5b8c\u6210\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"SyncBizBill4AfterAuditServiceProcess_1", (String)"fi-cal-business", (Object[])new Object[0]);
        String deleteMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u5df2\u5220\u9664\u3002", (String)"CalServiceReExcuteOP_5", (String)"fi-cal-opplugin", (Object[])new Object[0]);
        ArrayList<DynamicObject> retryBizBillDycs = new ArrayList<DynamicObject>(16);
        tmpSuccessOpBizBillDycs = new ArrayList<DynamicObject>(this.successOpBizBillDycsMap.values());
        for (DynamicObject bizBillDyc : tmpSuccessOpBizBillDycs) {
            DynamicObject dbBizBillDyc = this.sucessDbBizBillIdDycsMap.get(bizBillDyc.getLong("id"));
            if (dbBizBillDyc == null) {
                this.addErrorMsg(bizBillDyc.getLong("id"), "5", deleteMsg);
                continue;
            }
            DynamicObject costRecordDyc = this.sucessBizBillIdDBCostRecordMap.get(bizBillDyc.getLong("id"));
            if (costRecordDyc != null) continue;
            this.addErrorMsg(bizBillDyc.getLong("id"), "3", notSyncMsg);
            retryBizBillDycs.add(bizBillDyc);
        }
        String cancelMsg = ResManager.loadKDString((String)"\u6838\u7b97\u5355\u5df2\u91cd\u65b0\u540c\u6b65\uff0c\u8be5\u4efb\u52a1\u53d6\u6d88\u3002", (String)"SyncBizBill4SubmitServiceProcess_22", (String)"fi-cal-business", (Object[])new Object[0]);
        String dulErrorMsg = ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5df2\u662f\u5ba1\u6838\u72b6\u6001\uff0c\u5ba1\u6838\u5931\u8d25\u3002", (String)"SyncBizBill4AuditNewServiceProcess_1", (String)"fi-cal-business", (Object[])new Object[0]);
        ArrayList<DynamicObject> tmpSucessDbBizBillIdDycs = new ArrayList<DynamicObject>(this.sucessDbBizBillIdDycsMap.values());
        for (DynamicObject dbBizBillDyc : tmpSucessDbBizBillIdDycs) {
            boolean recordLessThanBizBillModifyTime;
            long dbBizBillId = dbBizBillDyc.getLong("id");
            DynamicObject costRecordDyc = this.sucessBizBillIdDBCostRecordMap.get(dbBizBillId);
            if (costRecordDyc == null || this.getModifytime(costRecordDyc) == 0L) continue;
            String costRecordBillStatus = costRecordDyc.getString("billstatus");
            if ("C".equals(costRecordBillStatus)) {
                boolean recordLargeEqualBizBillModifyTime;
                boolean bl = recordLargeEqualBizBillModifyTime = this.getModifytime(costRecordDyc) >= this.getModifytime(dbBizBillDyc);
                if (recordLargeEqualBizBillModifyTime) {
                    this.addErrorMsg(dbBizBillId, "5", cancelMsg);
                    continue;
                }
                this.addErrorMsg(dbBizBillId, "3", dulErrorMsg);
                continue;
            }
            boolean bl = recordLessThanBizBillModifyTime = this.getModifytime(costRecordDyc) < this.getModifytime(dbBizBillDyc);
            if (!"B".equals(costRecordBillStatus) || !recordLessThanBizBillModifyTime) continue;
            this.addErrorMsg(dbBizBillId, "3", notSyncMsg);
        }
        this.addQueue(retryBizBillDycs);
    }

    private void doCheckUnAudit() {
        CalBillRuleCheckHelper calBillRuleCheckHelper = new CalBillRuleCheckHelper(this.entity, this.successOpBizBillIds);
        calBillRuleCheckHelper.addSkipProperty("billstatus");
        Set failBillIds = calBillRuleCheckHelper.check();
        if (calBillRuleCheckHelper.isNoUseRules()) {
            String msg = ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u6ca1\u6709\u914d\u7f6e\u6620\u5c04\u5173\u7cfb\u3002", (String)"SyncBizBill4AuditServiceProcess_1", (String)"fi-cal-business", (Object[])new Object[0]);
            HashSet<Long> successOpBizBillIds = new HashSet<Long>(this.successOpBizBillIds);
            for (Long failId : successOpBizBillIds) {
                this.addErrorMsg(failId, "5", msg);
            }
            return;
        }
        String notMatchCalRuleMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u4e0d\u6ee1\u8db3\u6838\u7b97\u5355\u914d\u7f6e\u7684\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"SyncBizBill4AuditServiceProcess_4", (String)"fi-cal-business", (Object[])new Object[0]);
        HashMap<Long, DynamicObject> tmpSuccessOpBizBillDycsMap = new HashMap<Long, DynamicObject>(this.successOpBizBillDycsMap);
        String saveMsg = ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5df2\u5220\u9664\u3002", (String)"SyncOpLegalChecker_0", (String)"fi-cal-business", (Object[])new Object[0]);
        String unSyncMsg = ResManager.loadKDString((String)"\u5355\u636e\u672a\u540c\u6b65\u5b8c\u6210\uff0c\u5220\u9664\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5931\u8d25\u3002", (String)"DeleteCostRecordServiceProcess_1", (String)"fi-cal-business", (Object[])new Object[0]);
        String bizDelMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u5df2\u5220\u9664\u3002", (String)"CalServiceReExcuteOP_5", (String)"fi-cal-opplugin", (Object[])new Object[0]);
        ArrayList deleteBizBillDycs = new ArrayList(16);
        ArrayList<DynamicObject> retryBizDycs = new ArrayList<DynamicObject>(16);
        CalInTimeBufferPoolManager manager = new CalInTimeBufferPoolManager();
        Map<String, Set<Long>> calIngActionNameBizBillIdsMap = manager.getCalIngActionNameBizBillIdsMap(this.successOpBizBillIds);
        HashSet revCalIngBizBillIds = new HashSet(16);
        HashSet posCalIngBizBillIds = new HashSet(16);
        HashSet<Long> needCalInTimeBizBillIds = new HashSet<Long>(16);
        for (Map.Entry<String, Set<Long>> actionBizBillIdsEnt : calIngActionNameBizBillIdsMap.entrySet()) {
            if (ActionEnum.UN_AUDIT.getValue().equals(actionBizBillIdsEnt.getKey())) {
                revCalIngBizBillIds.addAll(actionBizBillIdsEnt.getValue());
                continue;
            }
            posCalIngBizBillIds.addAll(actionBizBillIdsEnt.getValue());
        }
        String calIngMsg = ResManager.loadKDString((String)"\u6838\u7b97\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"SyncOpLegalChecker_1", (String)"fi-cal-business", (Object[])new Object[0]);
        for (Map.Entry item : tmpSuccessOpBizBillDycsMap.entrySet()) {
            if (this.sucessBizBillIdDBCostRecordMap.containsKey(item.getKey())) {
                boolean isRecordLessEqualBizBillModifyTime;
                if (revCalIngBizBillIds.contains(item.getKey())) {
                    this.addErrorMsg((Long)item.getKey(), "3", calIngMsg);
                    continue;
                }
                if (posCalIngBizBillIds.contains(item.getKey())) {
                    needCalInTimeBizBillIds.add((Long)item.getKey());
                    continue;
                }
                DynamicObject costRecordDyc = this.sucessBizBillIdDBCostRecordMap.get(item.getKey());
                DynamicObject bizBill4db = this.sucessDbBizBillIdDycsMap.get(item.getKey());
                boolean invBillStatusIsSave = bizBill4db != null && "A".equals(bizBill4db.getString("billstatus"));
                boolean calRecordBillStatusIsSubmit = "B".equals(costRecordDyc.getString("billstatus"));
                boolean isBizBillDelOrSave = bizBill4db == null || invBillStatusIsSave;
                boolean bl = isRecordLessEqualBizBillModifyTime = bizBill4db != null && this.getModifytime(costRecordDyc) <= this.getModifytime(bizBill4db);
                if ((isBizBillDelOrSave || isRecordLessEqualBizBillModifyTime) && calRecordBillStatusIsSubmit) {
                    deleteBizBillDycs.add(item.getValue());
                    this.cancel = true;
                    continue;
                }
                if ("C".equals(costRecordDyc.getString("billstatus"))) continue;
                this.addErrorMsg((Long)item.getKey(), "3", unSyncMsg);
                continue;
            }
            if (this.sucessDbBizBillIdDycsMap.containsKey(item.getKey())) {
                if (failBillIds.contains(item.getKey())) {
                    this.addErrorMsg((Long)item.getKey(), "5", notMatchCalRuleMsg);
                    continue;
                }
                DynamicObject bizBill4db = this.sucessDbBizBillIdDycsMap.get(item.getKey());
                boolean invBillStatusIsSave = "A".equals(bizBill4db.getString("billstatus"));
                if (invBillStatusIsSave) {
                    this.addErrorMsg((Long)item.getKey(), "5", saveMsg);
                    continue;
                }
                retryBizDycs.add(this.successOpBizBillDycsMap.get(item.getKey()));
                this.addErrorMsg((Long)item.getKey(), "3", unSyncMsg);
                continue;
            }
            this.addErrorMsg((Long)item.getKey(), "5", bizDelMsg);
        }
        this.doCancelCalTimeLargeEqualInvTime();
        this.checkVoucher();
        needCalInTimeBizBillIds.removeAll(this.errMap.keySet());
        for (Long needCalInTimeBizBillId : needCalInTimeBizBillIds) {
            this.addErrorMsg(needCalInTimeBizBillId, "3", calIngMsg);
        }
        this.insertBufferPool(needCalInTimeBizBillIds);
        new DeleteCalBillHelper().deleteCalBills(deleteBizBillDycs.toArray(new DynamicObject[0]));
        this.addQueue(retryBizDycs);
    }

    private void insertBufferPool(Set<Long> needCalInTimeBizBillIds) {
        if (needCalInTimeBizBillIds.isEmpty()) {
            return;
        }
        QFilter qs = new QFilter("bizbillid", "in", needCalInTimeBizBillIds);
        qs.and("isinitbill", "=", (Object)Boolean.FALSE);
        qs.and("issplitcreate", "=", (Object)Boolean.FALSE);
        qs.and("entry.accounttype", "in", (Object)new String[]{AccountTypeEnum.MOVE_ADD_AVERAGE.getValue(), AccountTypeEnum.FIN_FOUT.getValue(), AccountTypeEnum.STANDARDCOST.getValue()});
        qs.and("invscheme.isforwardamount", "=", (Object)Boolean.TRUE);
        qs.and("entry.invtype.isforwardamount", "=", (Object)Boolean.TRUE);
        qs.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        new CalGroupAccountHelper().addNotGroupAcctFilter4Bill(qs);
        QFilter[] filter = qs.toArray();
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_costrecord", (String)"id,bizbillid,calbilltype,auditdate,costaccount,entry.material as material,entry.accounttype as accounttype,entry.id as entryid,entry.bizbillentryid as bizbillentryid,bookdate,entry.queuetype as queuetype", (QFilter[])filter);
        try (TXHandle t = TX.requiresNew();){
            try {
                IntimeBufferPoolHandle handle = new IntimeBufferPoolHandle(coll, "cal_costrecord_subentity", ActionEnum.UN_AUDIT.getValue(), false);
                handle.insertIntoPool();
                this.calProcessContext.putCustomerParams("bufferPoolBizBills", handle.getBufferPoolBizBillids());
            }
            catch (Throwable e) {
                t.markRollback();
                throw e;
            }
        }
    }

    private void checkVoucher() {
        HashMap<Long, DynamicObject> tmpSucessBizBillIdDBCostRecordMap = new HashMap<Long, DynamicObject>(this.sucessBizBillIdDBCostRecordMap);
        for (Map.Entry bizBillIdCostRecordDyc : tmpSucessBizBillIdDBCostRecordMap.entrySet()) {
            boolean isvoucher;
            DynamicObject costRecordDyc = (DynamicObject)bizBillIdCostRecordDyc.getValue();
            if ("im_initbill".equals(this.entity) || !(isvoucher = costRecordDyc.getBoolean("isvoucher"))) continue;
            String isVoucherMsg = ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"DeleteCostRecordServiceProcess_5", (String)"fi-cal-business", (Object[])new Object[0]);
            this.addErrorMsg((Long)bizBillIdCostRecordDyc.getKey(), "3", isVoucherMsg);
        }
    }

    private void checkCalStatus() {
        String calIngMsg = ResManager.loadKDString((String)"\u6838\u7b97\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"SyncOpLegalChecker_1", (String)"fi-cal-business", (Object[])new Object[0]);
        if (ActionEnum.UN_AUDIT.getValue().equals(this.opName)) {
            boolean isReSync;
            boolean bl = isReSync = this.params != null && this.params.get("legalCheck") != null;
            if (isReSync) {
                CalInTimeBufferPoolManager manager = new CalInTimeBufferPoolManager();
                Map<String, Set<Long>> calIngActionNameBizBillIdsMap = manager.getCalIngActionNameBizBillIdsMap(this.successOpBizBillIds);
                HashSet revCalIngBizBillIds = new HashSet(16);
                HashSet posCalIngBizBillIds = new HashSet(16);
                HashSet<Long> needCalInTimeBizBillIds = new HashSet<Long>(16);
                for (Map.Entry<String, Set<Long>> actionBizBillIdsEnt : calIngActionNameBizBillIdsMap.entrySet()) {
                    if (ActionEnum.UN_AUDIT.getValue().equals(actionBizBillIdsEnt.getKey())) {
                        revCalIngBizBillIds.addAll(actionBizBillIdsEnt.getValue());
                        continue;
                    }
                    posCalIngBizBillIds.addAll(actionBizBillIdsEnt.getValue());
                }
                HashMap<Long, DynamicObject> tmpSuccessOpBizBillDycsMap = new HashMap<Long, DynamicObject>(this.successOpBizBillDycsMap);
                for (Map.Entry item : tmpSuccessOpBizBillDycsMap.entrySet()) {
                    if (!posCalIngBizBillIds.contains(item.getKey())) continue;
                    needCalInTimeBizBillIds.add((Long)item.getKey());
                    this.addErrorMsg((Long)item.getKey(), "3", calIngMsg);
                }
                this.insertBufferPool(needCalInTimeBizBillIds);
            }
            return;
        }
        HashMap<Long, DynamicObject> tmpSucessBizBillIdDBCostRecordMap = new HashMap<Long, DynamicObject>(this.sucessBizBillIdDBCostRecordMap);
        for (Map.Entry bizBillIdCostRecordDyc : tmpSucessBizBillIdDBCostRecordMap.entrySet()) {
            Boolean isCalIng = this.sucessBizBillIdCalIngMap.get(bizBillIdCostRecordDyc.getKey());
            if (isCalIng == null || !isCalIng.booleanValue()) continue;
            this.addErrorMsg((Long)bizBillIdCostRecordDyc.getKey(), "3", calIngMsg);
        }
    }

    private void addErrorMsg(long bizBillId, String errType, String warnMsg) {
        this.errMap.put(bizBillId, new SynBillErrInfo(errType, warnMsg));
        this.successOpBizBillIds.remove(bizBillId);
        this.successOpBizBillDycsMap.remove(bizBillId);
        this.sucessBizBillIdDBCostRecordMap.remove(bizBillId);
        this.sucessDbBizBillIdDycsMap.remove(bizBillId);
    }

    private void loadCostRecord() {
        QFilter costBizBillIdf = new QFilter("bizbillid", "in", this.successOpBizBillIds);
        costBizBillIdf.and("issplitcreate", "=", (Object)Boolean.FALSE);
        new CalGroupAccountHelper().addNotGroupAcctFilter4Bill(costBizBillIdf);
        String calEntity = "cal_costrecord";
        String selectFields = "id,bizbillid,billstatus,modifytime,lastupdatetime,isvoucher,calstatus";
        if ("im_initbill".equals(this.entity)) {
            calEntity = "cal_initbill";
            selectFields = "id,bizbillid,billstatus,modifytime,lastupdatetime,calstatus";
        }
        DynamicObjectCollection dbCostRecordDycs = QueryServiceHelper.query((String)calEntity, (String)selectFields, (QFilter[])new QFilter[]{costBizBillIdf});
        for (DynamicObject record : dbCostRecordDycs) {
            long bizbillid = record.getLong("bizbillid");
            String status = record.getString("billstatus");
            String calStatus = record.getString("calstatus");
            if ("B".equals(status) || "C".equals(status)) {
                this.sucessBizBillIdDBCostRecordMap.put(bizbillid, record);
            }
            if (!"B".equals(calStatus) && !"C".equals(calStatus)) continue;
            this.sucessBizBillIdCalIngMap.put(bizbillid, true);
        }
    }

    private void loadBizBillIdDycsMap() {
        QFilter bizBillIdf = new QFilter("id", "in", this.successOpBizBillIds);
        String selectFields = "id,modifytime,billstatus";
        if (this.containsLastupdatetimeField) {
            selectFields = selectFields + ",lastupdatetime";
        }
        DynamicObjectCollection dbBizBills = QueryServiceHelper.query((String)this.entity, (String)selectFields, (QFilter[])new QFilter[]{bizBillIdf});
        for (DynamicObject item : dbBizBills) {
            this.sucessDbBizBillIdDycsMap.put(item.getLong("id"), item);
        }
    }

    private void addQueue(List<DynamicObject> bizBills) {
        if (bizBills == null || bizBills.isEmpty()) {
            return;
        }
        HashMap<String, String> param = new HashMap<String, String>(16);
        param.put("retry", "1");
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBizService", (String)"doService", (Object[])new Object[]{this.opName, param, bizBills.toArray(new DynamicObject[0])});
    }

    private void doCancelCalTimeLargeEqualInvTime() {
        String warnMsg = ResManager.loadKDString((String)"\u6838\u7b97\u5355\u5df2\u91cd\u65b0\u540c\u6b65\uff0c\u8be5\u4efb\u52a1\u53d6\u6d88\u3002", (String)"SyncBizBill4SubmitServiceProcess_22", (String)"fi-cal-business", (Object[])new Object[0]);
        ArrayList<DynamicObject> tmpSucessDbBizBillIdDycs = new ArrayList<DynamicObject>(this.sucessDbBizBillIdDycsMap.values());
        for (DynamicObject dbBizBillDyc : tmpSucessDbBizBillIdDycs) {
            boolean dbCostIsAuditAndDbBizBillIsSubmit;
            long dbBizBillId = dbBizBillDyc.getLong("id");
            DynamicObject dbCostRecordDyc = this.sucessBizBillIdDBCostRecordMap.get(dbBizBillId);
            if (dbCostRecordDyc == null || this.getModifytime(dbCostRecordDyc) == 0L) continue;
            String dbBizBillStatus = dbBizBillDyc.getString("billstatus");
            boolean dbBizBillIsSubmitOrAudit = "B".equals(dbBizBillStatus) || "C".equals(dbBizBillStatus);
            boolean recordLargeEqualBizBillModifyTime = this.getModifytime(dbCostRecordDyc) >= this.getModifytime(dbBizBillDyc);
            boolean bl = dbCostIsAuditAndDbBizBillIsSubmit = ActionEnum.UN_AUDIT.getValue().equals(this.opName) && "C".equals(dbCostRecordDyc.getString("billstatus")) && "B".equals(dbBizBillStatus);
            if (dbCostIsAuditAndDbBizBillIsSubmit) {
                this.reExecuteSubmitBizDycs.add(this.successOpBizBillDycsMap.get(dbBizBillId));
                continue;
            }
            if (!dbBizBillIsSubmitOrAudit || !recordLargeEqualBizBillModifyTime) continue;
            this.addErrorMsg(dbBizBillId, "5", warnMsg);
        }
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public Map<Long, DynamicObject> getSuccessOpBizBillDycs() {
        return this.successOpBizBillDycsMap;
    }

    public Set<Long> getSuccessOpBizBillIds() {
        return this.successOpBizBillIds;
    }

    public void setSuccessOpBizBillIds(Set<Long> successOpBizBillIds) {
        this.successOpBizBillIds = successOpBizBillIds;
    }

    public Map<Long, DynamicObject> getSucessDbBizBillIdDycsMap() {
        return this.sucessDbBizBillIdDycsMap;
    }

    public Map<Long, SynBillErrInfo> getErrMap() {
        return this.errMap;
    }

    public Map<Long, DynamicObject> getSucessBizBillIdDBCostRecordMap() {
        return this.sucessBizBillIdDBCostRecordMap;
    }

    public void setParams(Map params) {
        this.params = params;
    }

    public void setCalProcessContext(CalProcessContext calProcessContext) {
        this.calProcessContext = calProcessContext;
    }

    private void reSyncUnAuditDelSubCostRecBill() {
        if (!ActionEnum.UN_AUDIT.getValue().equals(this.opName)) {
            return;
        }
        HashMap<Long, DynamicObject> tmpSuccessOpBizBillDycsMap = new HashMap<Long, DynamicObject>(this.successOpBizBillDycsMap);
        ArrayList deleteBizBillDycs = new ArrayList(16);
        for (Map.Entry item : tmpSuccessOpBizBillDycsMap.entrySet()) {
            DynamicObject costRecordDyc;
            boolean calRecordBillStatusIsSubmit;
            if (!this.sucessBizBillIdDBCostRecordMap.containsKey(item.getKey()) || !(calRecordBillStatusIsSubmit = "B".equals((costRecordDyc = this.sucessBizBillIdDBCostRecordMap.get(item.getKey())).getString("billstatus")))) continue;
            deleteBizBillDycs.add(item.getValue());
            this.cancel = true;
        }
        new DeleteCalBillHelper().deleteCalBills(deleteBizBillDycs.toArray(new DynamicObject[0]));
    }

    private void doCheckMatWriteOff() {
        ArrayList<DynamicObject> tmpSucessDbBizBillIdDycs = new ArrayList<DynamicObject>(this.sucessDbBizBillIdDycsMap.values());
        String bizErrorMsg = ResManager.loadKDString((String)"\u6838\u7b97\u5355\u540c\u6b65\u672a\u5b8c\u6210\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"SyncBizBill4AfterAuditServiceProcess_1", (String)"fi-cal-business", (Object[])new Object[0]);
        for (DynamicObject dbBizBillDyc : tmpSucessDbBizBillIdDycs) {
            boolean recordLessBizBillModifyTime;
            long dbBizBillId = dbBizBillDyc.getLong("id");
            DynamicObject dbCostRecordDyc = this.sucessBizBillIdDBCostRecordMap.get(dbBizBillId);
            if (dbCostRecordDyc == null || this.getModifytime(dbCostRecordDyc) == 0L || !(recordLessBizBillModifyTime = this.getModifytime(dbCostRecordDyc) < this.getModifytime(dbBizBillDyc))) continue;
            this.addErrorMsg(dbBizBillId, "3", bizErrorMsg);
        }
    }
}

