/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.inner;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBillDiffTypeEnum;
import kd.fi.cal.common.helper.BillNoHelper;
import kd.fi.cal.common.helper.CalStdcostdiffbillHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.IDGenerator;
import kd.fi.cal.common.helper.MaterialCategoryHelper;
import kd.fi.cal.common.helper.WriteLogHelper;
import kd.fi.cal.common.model.CostAdjustDetailParams;

public class WfDiffHelper {
    private static final Log logger = LogFactory.getLog(MaterialCategoryHelper.class);

    public void dealCalculatedStdDiff(Map<String, DynamicObject> calculatedCostRecordEntry, Map<String, BigDecimal> totalGroupCost) {
        HashMap<String, DynamicObject> costAdjustHeadMap = new HashMap<String, DynamicObject>(16);
        HashMap<Long, DynamicObject> costAdjustEntryMap = new HashMap<Long, DynamicObject>();
        ArrayList<CostAdjustDetailParams> paramsList = new ArrayList<CostAdjustDetailParams>(1024);
        IDGenerator idGen = new IDGenerator("t_cal_stdcostdiffentry");
        for (Map.Entry<String, BigDecimal> groupCostEntry : totalGroupCost.entrySet()) {
            DynamicObject costRecordEntry;
            BigDecimal adjustCost;
            String[] keys = groupCostEntry.getKey().split("\\|");
            DynamicObject[] groupKey = keys[2];
            BigDecimal groupCost = groupCostEntry.getValue();
            long elementId = 0L;
            boolean isCalByElement = false;
            try {
                elementId = Long.parseLong((String)groupKey);
                isCalByElement = true;
            }
            catch (NumberFormatException e) {
                isCalByElement = false;
                WriteLogHelper.writeErrorLog((Log)logger, (String)"WfDiffHelper-dealCalculatedStdDiff", (Throwable)e);
            }
            if ((adjustCost = groupCost).compareTo(BigDecimal.ZERO) == 0 || (costRecordEntry = calculatedCostRecordEntry.get(keys[0] + "|" + keys[1])) == null) continue;
            DynamicObject costRecord = (DynamicObject)costRecordEntry.getParent();
            Long costRecordId = costRecord.getLong("id");
            String accountType = costRecordEntry.getString("accounttype");
            if (!AccountTypeEnum.STANDARDCOST.getValue().equals(accountType)) continue;
            String adjKey = costRecordId + accountType;
            DynamicObject costAdjustHead = costAdjustHeadMap.computeIfAbsent(adjKey, k -> this.createCostAdjust(costRecord, accountType));
            DynamicObject costAdjustEntry = costAdjustEntryMap.computeIfAbsent(costRecordEntry.getLong("id"), k -> this.createCostAdjustEntry(costAdjustHead, costRecord, costRecordEntry));
            costAdjustEntry.set("id", (Object)idGen.getId());
            if (isCalByElement) {
                boolean hasEntry = false;
                long eleId = 0L;
                for (DynamicObject subCostRecordEntry : costRecordEntry.getDynamicObjectCollection("subentrycostelement")) {
                    if (subCostRecordEntry.getLong("costsubelement_id") != elementId) continue;
                    hasEntry = true;
                    adjustCost = groupCost.subtract(subCostRecordEntry.getBigDecimal("sub_actualcost"));
                    eleId = subCostRecordEntry.getLong("costelement_id");
                    break;
                }
                if (!hasEntry) {
                    eleId = CostElementHelper.getCostElementBySub((Long)elementId);
                }
                CostAdjustDetailParams param = new CostAdjustDetailParams();
                param.setAdjustAmt(adjustCost);
                param.setEntryid((Object)costAdjustEntry.getLong("id"));
                param.setCostElementId((Object)eleId);
                param.setCostSubElementId((Object)elementId);
                String diffType = CostAdjustBillDiffTypeEnum.ORDER_DIFF.getValue();
                CalStdcostdiffbillHelper.setParamSubDdiffAmt((String)diffType, (BigDecimal)adjustCost, (CostAdjustDetailParams)param);
                paramsList.add(param);
            } else {
                adjustCost = groupCost.subtract(costRecordEntry.getBigDecimal((String)groupKey));
                Long[] elementIds = CostElementHelper.getDefaultMaterialElements();
                CostAdjustDetailParams param = new CostAdjustDetailParams();
                param.setAdjustAmt(adjustCost);
                param.setEntryid((Object)costAdjustEntry.getLong("id"));
                param.setCostElementId((Object)elementIds[1]);
                param.setCostSubElementId((Object)elementIds[0]);
                String diffType = CostAdjustBillDiffTypeEnum.ORDER_DIFF.getValue();
                CalStdcostdiffbillHelper.setParamSubDdiffAmt((String)diffType, (BigDecimal)adjustCost, (CostAdjustDetailParams)param);
                paramsList.add(param);
            }
            costAdjustEntry.set("adjustamt", (Object)costAdjustEntry.getBigDecimal("adjustamt").add(adjustCost));
        }
        this.removeZeroAmtEntryBill(costAdjustHeadMap);
        if (!costAdjustHeadMap.isEmpty()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            DynamicObject[] costAdjDycs = costAdjustHeadMap.values().toArray(new DynamicObject[costAdjustHeadMap.size()]);
            costAdjDycs = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])costAdjDycs);
            HashSet<Object> ids = new HashSet<Object>(costAdjDycs.length);
            for (DynamicObject costAdjDyc : costAdjDycs) {
                ids.add(costAdjDyc.getPkValue());
            }
            String params = SerializationUtils.toJsonString(paramsList);
            option.setVariableValue("CostAdjustDetailParms", params);
            OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_stdcostdiffbill", (Object[])ids.toArray(new Object[0]), (OperateOption)option);
            List errors = result.getAllErrorOrValidateInfo();
            if (!result.isSuccess()) {
                StringBuilder msg = new StringBuilder();
                msg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u6838\u7b97\u5931\u8d25\uff1a", (String)"CostAdjustDeleteFunction_2", (String)"fi-cal-business", (Object[])new Object[0]));
                for (IOperateInfo error : errors) {
                    OperateInfo operror = (OperateInfo)error;
                    msg.append(operror.getMessage()).append('\n');
                }
                msg.append(result.getMessage()).append('\n');
                throw new KDBizException(msg.toString());
            }
        }
    }

    private DynamicObject createCostAdjust(DynamicObject info, String accountType) {
        DynamicObject costAdjustBill = BusinessDataServiceHelper.newDynamicObject((String)"cal_stdcostdiffbill");
        String calbilltype = info.getString("calbilltype");
        if ("IN".equals(calbilltype)) {
            costAdjustBill.set("cstype", (Object)"bd_supplier");
            costAdjustBill.set("custsupplier", info.get("supplier_id"));
        } else {
            costAdjustBill.set("cstype", (Object)"bd_customer");
            costAdjustBill.set("custsupplier", info.get("customer_id"));
        }
        costAdjustBill.set("currency", info.get("localcurrency_id"));
        costAdjustBill.set("bizdate", (Object)info.getDate("bizdate"));
        costAdjustBill.set("bookdate", (Object)info.getDate("bookdate"));
        if ("IN".equals(info.getString("calbilltype"))) {
            costAdjustBill.set("biztype", (Object)"A");
        } else {
            costAdjustBill.set("biztype", (Object)"B");
        }
        costAdjustBill.set("billstatus", (Object)"B");
        costAdjustBill.set("createtype", (Object)"F");
        if (AccountTypeEnum.STANDARDCOST.getValue().equals(accountType)) {
            costAdjustBill.set("createtype", (Object)"X");
        }
        costAdjustBill.set("costaccount", (Object)info.getLong("costaccount_id"));
        Object accountID = info.get("costaccount_id");
        DynamicObject costAccont = BusinessDataServiceHelper.loadSingleFromCache((Object)accountID, (String)"cal_bd_costaccount", (String)"calorg");
        costAdjustBill.set("calorg", costAccont.get("calorg"));
        costAdjustBill.set("billtype", info.get("billtype_id"));
        Date date = TimeServiceHelper.now();
        costAdjustBill.set("createtime", (Object)date);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        costAdjustBill.set("creator_id", (Object)userId);
        costAdjustBill.set("adminorg", info.get("adminorg_id"));
        String number = BillNoHelper.getBillNo((String)"cal_stdcostdiffbill", (DynamicObject)costAdjustBill, (String)costAccont.get("calorg_id").toString());
        costAdjustBill.set("billno", (Object)number);
        return costAdjustBill;
    }

    private DynamicObject createCostAdjustEntry(DynamicObject costAdjustBillHead, DynamicObject costRecordInfo, DynamicObject costRecordEntry) {
        MainEntityType costRecordEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costrecord");
        MainEntityType costAdjustEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costadjustbill");
        DynamicObject entry = costAdjustBillHead.getDynamicObjectCollection("entryentity").addNew();
        entry.set("storageorgunit", costRecordInfo.get("storageorgunit_id"));
        entry.set("material", costRecordEntry.get("material_id"));
        entry.set("lot", costRecordEntry.get("lot"));
        entry.set("warehouse", costRecordEntry.get("warehouse_id"));
        entry.set("location", costRecordEntry.get("location_id"));
        entry.set("ownertype", (Object)"bos_org");
        entry.set("owner", costRecordEntry.get("owner_id"));
        entry.set("ecostcenter", costRecordEntry.get("ecostcenter_id"));
        entry.set("assist", costRecordEntry.get("assist_id"));
        entry.set("invbilltype", costRecordInfo.get("billtype_id"));
        entry.set("invbizdate", costRecordInfo.get("bookdate"));
        entry.set("invbillnum", (Object)costRecordInfo.getString("billno"));
        entry.set("inventryseq", costRecordEntry.get("seq"));
        entry.set("invbillid", costRecordInfo.get("id"));
        entry.set("invbizentityobject", (Object)"cal_costrecord");
        entry.set("invbillentryid", costRecordEntry.get("id"));
        entry.set("baseunit", costRecordEntry.get("baseunit_id"));
        entry.set("project", costRecordEntry.get("project_id"));
        entry.set("invtype", costRecordEntry.get("invtype_id"));
        entry.set("invstatus", costRecordEntry.get("invstatus_id"));
        entry.set("mversion", costRecordEntry.get("mversion_id"));
        entry.set("tracknumber", costRecordEntry.get("tracknumber"));
        entry.set("configuredcode", costRecordEntry.get("configuredcode"));
        entry.set("noupdatecalfields", costRecordEntry.get("noupdatecalfields"));
        CommonSettingHelper.setExFieldValue((MainEntityType)costAdjustEntityType, (MainEntityType)costRecordEntityType, (DynamicObject)entry, (DynamicObject)costRecordEntry);
        return entry;
    }

    public void removeZeroAmtEntryBill(Map<String, DynamicObject> costAdjustHeadMap) {
        Iterator<Map.Entry<String, DynamicObject>> headIter = costAdjustHeadMap.entrySet().iterator();
        while (headIter.hasNext()) {
            Map.Entry<String, DynamicObject> adjHeadEnt = headIter.next();
            DynamicObject adjHeadDyc = adjHeadEnt.getValue();
            DynamicObjectCollection entryDycs = adjHeadDyc.getDynamicObjectCollection("entryentity");
            Iterator entryDycIter = entryDycs.iterator();
            while (entryDycIter.hasNext()) {
                DynamicObject entryDyc = (DynamicObject)entryDycIter.next();
                if (entryDyc.getBigDecimal("adjustamt").compareTo(BigDecimal.ZERO) != 0) continue;
                entryDycIter.remove();
            }
            if (entryDycs.size() >= 1) continue;
            headIter.remove();
        }
    }
}

