/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.fi.cal.business.process.ErrorMsg;
import kd.fi.cal.business.service.CalProcessContext;
import kd.fi.cal.business.service.CalProcessLogHandle;
import kd.fi.cal.business.service.CalServiceHelper;
import kd.fi.cal.business.service.SyncLockHelper;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.helper.SynBizBillHelper;
import kd.fi.cal.common.util.CommonUtils;

public class CalProcessHandle {
    private static final Log logger = LogFactory.getLog(CalProcessHandle.class);
    private String serviceType = "B";
    private String actionName;
    private Map params;
    private DynamicObject[] bizBills;
    private Map<Long, String> result = new HashMap<Long, String>(16);
    private Map<Long, ErrorMsg> errorBillIdMsgMap = new HashMap<Long, ErrorMsg>(16);
    private CalProcessContext calProcessContext = new CalProcessContext();

    public CalProcessHandle(String actionName, Map params, DynamicObject[] bizBills) {
        this.actionName = actionName;
        this.params = params;
        if (this.params == null) {
            this.params = new HashMap(16);
        }
        this.bizBills = bizBills;
        this.calProcessContext.setActionName(actionName);
    }

    public void handle() {
        try (TraceSpan span = Tracer.create((String)"CalProcessHandle", (String)("handle" + this.actionName));){
            this.doHandle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doHandle() {
        block16: {
            try {
                boolean isAuditOrUnAudit;
                boolean bl = isAuditOrUnAudit = ActionEnum.UN_AUDIT.getValue().equals(this.actionName) || ActionEnum.AUDIT.getValue().equals(this.actionName);
                if (isAuditOrUnAudit && this.bizBills.length < 1) {
                    logger.info("CalProcessHandle-\u5355\u636e\u96c6\u5408\u662f\u5426\u4e3a\u7a7a\uff1a" + (this.bizBills == null));
                    return;
                }
                if (ActionEnum.MATERIALWRITEOFF.getValue().equals(this.actionName) || ActionEnum.PUR_WRITEOFF.getValue().equals(this.actionName) || ActionEnum.SALE_WRITEOFF.getValue().equals(this.actionName)) {
                    if (ActionEnum.MATERIALWRITEOFF.getValue().equals(this.actionName)) {
                        logger.info("CalProcessHandle-\u6838\u9500\u8bb0\u5f55\u7f16\u7801\u4e3a:" + this.bizBills[0].getString("wfnumber"));
                    } else {
                        logger.info("CalProcessHandle-\u6838\u9500\u8bb0\u5f55\u7f16\u7801\u4e3a:" + this.bizBills[0].getString("billno"));
                    }
                    if (!ActionEnum.MATERIALWRITEOFF.getValue().equals(this.actionName)) {
                        this.bizBills = SynBizBillHelper.checkBillsSync((DynamicObject[])this.bizBills);
                    }
                    if (this.bizBills == null || this.bizBills.length == 0) {
                        return;
                    }
                    this.doInnerService(this.serviceType, this.actionName, this.params, this.bizBills);
                    return;
                }
                logger.info("CalProcessHandle-\u5355\u636e\u96c6\u5408\u662f\u5426\u4e3a\u7a7a\uff1a" + (this.bizBills == null));
                if (this.bizBills == null) {
                    this.doInnerService(this.serviceType, this.actionName, this.params, this.bizBills);
                    break block16;
                }
                if (ActionEnum.AUDIT.getValue().equals(this.actionName) || ActionEnum.RESYNC.getValue().equals(this.actionName)) {
                    logger.info("CalProcessHandle-\u5355\u636e\u7f16\u7801\u4e3a:" + this.bizBills[0].getString("billno"));
                    this.doInnerService(this.serviceType, this.actionName, this.params, this.bizBills);
                    return;
                }
                for (DynamicObject bizBill : this.bizBills) {
                    logger.info("CalProcessHandle-\u5355\u636e\u7f16\u7801\u4e3a:" + bizBill.getString("billno"));
                    this.doInnerService(this.serviceType, this.actionName, this.params, new DynamicObject[]{bizBill});
                }
                return;
            }
            finally {
                this.removeDLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map doInnerService(String serviceType, String actionName, Map params, DynamicObject[] bizBills) {
        CalProcessLogHandle calProcessLogHandle = new CalProcessLogHandle();
        calProcessLogHandle.setCalProcessContext(this.calProcessContext);
        DynamicObject[] logs = calProcessLogHandle.beforeActionLog(serviceType, actionName, params, bizBills);
        try (SyncLockHelper syncLockHelper = new SyncLockHelper(actionName, bizBills);){
            Object object;
            syncLockHelper.setSyncParams(params);
            List<ErrorMsg> mutErrors = syncLockHelper.lock();
            bizBills = syncLockHelper.getBizBillDycs();
            ArrayList<ErrorMsg> errList = new ArrayList<ErrorMsg>(16);
            try {
                TXHandle h1 = TX.requiresNew();
                object = null;
                try {
                    try {
                        bizBills = this.submitBeforeAudit(serviceType, actionName, params, bizBills, errList);
                        CalServiceHelper calServiceHelper = new CalServiceHelper();
                        calServiceHelper.setCalProcessContext(this.calProcessContext);
                        List<ErrorMsg> bizChainErrorMsgs = calServiceHelper.doBizChainNew(serviceType, actionName, params, bizBills);
                        errList.addAll(bizChainErrorMsgs);
                        if (errList.size() > 0 && !ActionEnum.AUDIT.getValue().equals(actionName) && !ActionEnum.REESTIMATE.getValue().equals(actionName)) {
                            h1.markRollback();
                        }
                    }
                    catch (KDBizException e) {
                        logger.info("CalProcessHandle-KDBizException", (Object)e);
                        h1.markRollback();
                        String errType = "3";
                        ComboProp successCbo = (ComboProp)EntityMetadataCache.getDataEntityType((String)"cal_businesslog").getProperty("success");
                        for (ValueMapItem item : successCbo.getComboItems()) {
                            if (!item.getValue().equals(e.getErrorCode().getCode())) continue;
                            errType = item.getValue();
                            break;
                        }
                        CalServiceHelper.handleErrorMsg(errList, bizBills, CommonUtils.getLogMessage((Throwable)e, (int)0), errType);
                    }
                    catch (Throwable ex) {
                        logger.info("CalProcessHandle-Throwable", (Object)ex);
                        h1.markRollback();
                        CalServiceHelper.handleErrorMsg(errList, bizBills, CommonUtils.getLogMessage((Throwable)ex, (int)0), "4");
                    }
                }
                catch (Throwable ex) {
                    object = ex;
                    throw ex;
                }
                finally {
                    if (h1 != null) {
                        if (object != null) {
                            try {
                                h1.close();
                            }
                            catch (Throwable ex) {
                                ((Throwable)object).addSuppressed(ex);
                            }
                        } else {
                            h1.close();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                logger.info("CalProcessHandle-\u5f00\u59cb\u64cd\u4f5c\u65e5\u5fd7");
                errList.addAll(mutErrors);
                List errorMsgs2 = (List)ThreadCache.get((Object)"errorMsgs");
                List list = errorMsgs2 = errorMsgs2 == null ? new ArrayList(0) : errorMsgs2;
                if (!ActionEnum.UN_AUDIT.getValue().equals(actionName)) {
                    errList.addAll(errorMsgs2);
                }
                try (TXHandle h = TX.requiresNew();){
                    calProcessLogHandle.setMulErrorBizBillIds(mutErrors);
                    calProcessLogHandle.afterActionLog(actionName, logs, errList, bizBills);
                }
                for (ErrorMsg item : errList) {
                    this.result.put(item.getId(), item.getErrorMsg());
                    this.errorBillIdMsgMap.put(item.getId(), item);
                }
                this.addQueue();
                throw throwable;
            }
            logger.info("CalProcessHandle-\u5f00\u59cb\u64cd\u4f5c\u65e5\u5fd7");
            errList.addAll(mutErrors);
            List errorMsgs = (List)ThreadCache.get((Object)"errorMsgs");
            List list = errorMsgs = errorMsgs == null ? new ArrayList(0) : errorMsgs;
            if (!ActionEnum.UN_AUDIT.getValue().equals(actionName)) {
                errList.addAll(errorMsgs);
            }
            try (TXHandle h = TX.requiresNew();){
                calProcessLogHandle.setMulErrorBizBillIds(mutErrors);
                calProcessLogHandle.afterActionLog(actionName, logs, errList, bizBills);
            }
            object = errList.iterator();
            while (true) {
                if (!object.hasNext()) {
                    this.addQueue();
                    return this.result;
                }
                ErrorMsg item = (ErrorMsg)object.next();
                this.result.put(item.getId(), item.getErrorMsg());
                this.errorBillIdMsgMap.put(item.getId(), item);
            }
        }
        catch (KDBizException e) {
            logger.info("CalProcessHandle-\u540c\u6b65\u51fa\u73b0\u5f02\u5e38", (Object)e);
            return this.result;
        }
        catch (Exception e) {
            logger.error("CalProcessHandle-\u540c\u6b65\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        return this.result;
    }

    public String getserviceType() {
        return this.serviceType;
    }

    public void setserviceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public Map<Long, String> getResult() {
        return this.result;
    }

    public Map<Long, ErrorMsg> getErrorBillIdMsgMap() {
        return this.errorBillIdMsgMap;
    }

    private DynamicObject[] submitBeforeAudit(String serviceType, String actionName, Map params, DynamicObject[] bizBillDycs, List<ErrorMsg> errList) throws Exception {
        if (!ActionEnum.AUDIT.getValue().equals(actionName)) {
            return bizBillDycs;
        }
        try (TXHandle h1 = TX.requiresNew();){
            try {
                CalServiceHelper calServiceHelper = new CalServiceHelper();
                calServiceHelper.setCalProcessContext(this.calProcessContext);
                List<ErrorMsg> submitErrorMsgs = calServiceHelper.doBizChainNew(serviceType, ActionEnum.SUBMIT.getValue(), params, bizBillDycs);
                ArrayList<ErrorMsg> notIgnoreErrorMsgs = new ArrayList<ErrorMsg>(16);
                for (ErrorMsg errorMsg : submitErrorMsgs) {
                    if ("6".equals(errorMsg.getErrorType())) continue;
                    notIgnoreErrorMsgs.add(errorMsg);
                }
                HashSet<Long> notIgnoreErrorBillIds = new HashSet<Long>(16);
                for (ErrorMsg errorMsg : notIgnoreErrorMsgs) {
                    notIgnoreErrorBillIds.add(errorMsg.getId());
                }
                ArrayList<DynamicObject> arrayList = new ArrayList<DynamicObject>(16);
                for (DynamicObject billDyc : bizBillDycs) {
                    long bizBillId = billDyc.getLong("id");
                    if (notIgnoreErrorBillIds.contains(bizBillId)) continue;
                    arrayList.add(billDyc);
                }
                bizBillDycs = arrayList.toArray(new DynamicObject[0]);
                errList.addAll(notIgnoreErrorMsgs);
            }
            catch (Throwable e) {
                h1.markRollback();
                throw new Exception(e);
            }
        }
        return bizBillDycs;
    }

    private void removeDLock() {
        Map<String, DLock> lockMap = this.calProcessContext.getLockMap();
        if (lockMap != null && !lockMap.isEmpty()) {
            for (DLock lock : lockMap.values()) {
                lock.close();
            }
            lockMap.clear();
        }
    }

    private void addQueue() {
        List<DynamicObject> retryBillDycs = this.calProcessContext.getRetryBillDycs();
        if (retryBillDycs.size() > 0) {
            HashMap<String, String> param = new HashMap<String, String>(16);
            param.put("retry", "1");
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBizService", (String)"doService", (Object[])new Object[]{this.calProcessContext.getActionName(), param, retryBillDycs.toArray(new DynamicObject[0])});
        }
    }
}

