/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.business.calculate.out.calintime.CalInTimeBufferPoolManager;
import kd.fi.cal.business.process.ErrorMsg;
import kd.fi.cal.business.service.CalProcessContext;
import kd.fi.cal.business.service.LogBizTimeResolver;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.enums.CalStatusEnum;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;

public class CalProcessLogHandle {
    private static final Log logger = LogFactory.getLog(CalProcessLogHandle.class);
    private Set<Long> mulErrorBizBillIds = new HashSet<Long>(16);
    private CalProcessContext calProcessContext;

    public DynamicObject[] beforeActionLog(String serviceType, String actionName, Map params, DynamicObject[] bizBills) {
        String bizEntityNumber;
        MainEntityType type;
        String string;
        Long settleOrgId = null;
        if (params == null) {
            params = new HashMap(0);
        }
        String paramMap = SerializationUtils.toJsonString(params);
        QFilter f = new QFilter("servicetype", "=", (Object)serviceType);
        f.and(new QFilter("actionname", "=", (Object)actionName));
        Long costAccountId = (Long)params.get("costAccount");
        if (("SETTLEACCOUNT".equals(actionName) || "UNSETTLEACCOUNT".equals(actionName)) && costAccountId != null) {
            DynamicObject accountDyc = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calorg", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costAccountId)});
            if (accountDyc != null) {
                settleOrgId = accountDyc.getLong("calorg");
            }
            f.and("parammap", "=", (Object)paramMap);
        }
        HashSet<Object> idSet = new HashSet<Object>(16);
        HashMap<Object, DynamicObject> billIdDycMap = new HashMap<Object, DynamicObject>(16);
        if (bizBills != null && bizBills.length > 0) {
            for (DynamicObject bill : bizBills) {
                idSet.add(bill.get("id"));
                billIdDycMap.put(bill.get("id"), bill);
            }
            f.and(new QFilter("bizbillid", "in", idSet));
        }
        Object retry = params.get("retry");
        String selectProperties = "id,actionname,parammap_tag,parammap,success,exetime,times,bizentityobject,bizbillid,bizbillnumber,org,bizbillid,times,isclose,log,log_tag,biztime,bookdate,calstatus";
        DynamicObject[] logs = BusinessDataServiceHelper.load((String)"cal_businesslog", (String)selectProperties, (QFilter[])new QFilter[]{f});
        String mainOrgName = "org";
        if (bizBills != null && bizBills.length > 0 && !StringUtils.isEmpty((String)(string = (type = MetadataServiceHelper.getDataEntityType((String)(bizEntityNumber = bizBills[0].getDataEntityType().getName()))).getMainOrg()))) {
            mainOrgName = string;
        }
        HashSet<Long> hasLogBizBillIds = new HashSet<Long>(16);
        Integer retryMaxTimes = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.SYNC_AUTO_RETRYTIMES);
        for (DynamicObject log : logs) {
            int timse = log.getInt("times");
            if (timse > retryMaxTimes && retry != null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u91cd\u8bd5\u8d85\u8fc7\u6b21\u6570\u9650\u5236\uff0c\u5f85\u4efb\u52a1\u81ea\u52a8\u8c03\u5ea6\u5904\u7406\u3002", (String)"CalProcessLogHandle_0", (String)"fi-cal-business", (Object[])new Object[0]));
            }
            log.set("success", (Object)Character.valueOf('2'));
            if (!CalStatusEnum.ERROR.getValue().equals(log.getString("calstatus"))) {
                log.set("calstatus", (Object)"C");
            }
            log.set("isclose", (Object)"0");
            log.set("log", (Object)"");
            log.set("log_tag", (Object)"");
            log.set("exetime", (Object)new Date());
            hasLogBizBillIds.add(log.getLong("bizbillid"));
            DynamicObject bizBillDyc = (DynamicObject)billIdDycMap.get(log.get("bizbillid"));
            if (bizBillDyc == null || ActionEnum.MATERIALWRITEOFF.getValue().equals(actionName)) continue;
            log.set("bizbillnumber", bizBillDyc.get("billno"));
        }
        ArrayList<DynamicObject> arrayList = new ArrayList<DynamicObject>(16);
        if (bizBills != null && bizBills.length > 0) {
            for (DynamicObject bill : bizBills) {
                if (hasLogBizBillIds.contains(bill.getLong("id"))) continue;
                Map<Long, Set<String>> wfRecordIdOmInBillnoMap = this.getWfRecordIdOmInBillnoMap(actionName, bizBills, idSet);
                DynamicObject newLogDyc = this.createLogDyc(serviceType, actionName, paramMap, mainOrgName, bill, wfRecordIdOmInBillnoMap);
                arrayList.add(newLogDyc);
            }
        } else if (logs.length < 1) {
            DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"cal_businesslog");
            log.set("servicetype", (Object)serviceType);
            log.set("actionname", (Object)actionName);
            log.set("parammap_tag", (Object)paramMap);
            log.set("parammap", (Object)paramMap);
            log.set("success", (Object)Character.valueOf('2'));
            log.set("times", (Object)0);
            log.set("exetime", (Object)new Date());
            if (settleOrgId != null) {
                log.set("org", (Object)settleOrgId);
            }
            arrayList.add(log);
        }
        ArrayList<DynamicObject> bizTimeLogs = new ArrayList<DynamicObject>(arrayList);
        bizTimeLogs.addAll(Arrays.asList(logs));
        LogBizTimeResolver resolver = new LogBizTimeResolver(actionName, bizTimeLogs, bizBills);
        resolver.setBizTime();
        try (TXHandle h = TX.requiresNew();){
            ArrayList<DynamicObject> allLogDycs = new ArrayList<DynamicObject>(arrayList.size() + logs.length);
            DynamicObject[] newLogDycArray = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])arrayList.toArray(new DynamicObject[0]));
            allLogDycs.addAll(Arrays.asList(newLogDycArray));
            logs = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])logs);
            allLogDycs.addAll(Arrays.asList(logs));
            logs = allLogDycs.toArray(new DynamicObject[allLogDycs.size()]);
        }
        return logs;
    }

    /*
     * WARNING - void declaration
     */
    public void afterActionLog(String actionName, DynamicObject[] logs, List<ErrorMsg> errList, DynamicObject[] bizBills) {
        HashMap<Long, ErrorMsg> errIdMap;
        int logsLength = logs.length;
        if (logsLength <= 0) {
            logger.info("afterActionLog\u7684\u65e5\u5fd7\u6570\u91cf\u4e3a" + logsLength);
            return;
        }
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        HashSet<Object> idSet = new HashSet<Object>(logsLength);
        for (DynamicObject log : logs) {
            idSet.add(log.getPkValue());
            long bizbillid = log.getLong("bizbillid");
            if (bizbillid == 0L) continue;
            bizBillIds.add(bizbillid);
        }
        CalInTimeBufferPoolManager manager = new CalInTimeBufferPoolManager();
        Map<String, Set<Long>> calIngActionNameBizBillIdsMap = manager.getCalIngActionNameBizBillIdsMap(bizBillIds);
        String selectors = "bizentityobject, exetime, success, log, log_tag ,actionname, bizbillid, bizbillnumber, servicetype, parammap,parammap_tag,isclose,times,biztime,bookdate,calstatus";
        DynamicObject[] newLogs = BusinessDataServiceHelper.load((String)"cal_businesslog", (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)});
        if (errList != null && errList.size() > 0) {
            errIdMap = new HashMap(errList.size());
            for (ErrorMsg errorMsg : errList) {
                ErrorMsg oldMsg = (ErrorMsg)errIdMap.get(errorMsg.getId());
                if (oldMsg == null) {
                    errIdMap.put(errorMsg.getId(), errorMsg);
                    continue;
                }
                oldMsg.setErrorMsg(oldMsg.getErrorMsg() + "\n" + errorMsg.getErrorMsg());
            }
        } else {
            errIdMap = new HashMap<Long, ErrorMsg>(8);
        }
        if (newLogs.length == 1 && newLogs[0].getLong("bizbillid") == 0L) {
            if (errList != null && !errList.isEmpty()) {
                void var14_21;
                StringBuilder errorBuilder = new StringBuilder();
                for (ErrorMsg msg : errList) {
                    errorBuilder.append(msg.getErrorMsg());
                    errorBuilder.append('\n');
                }
                newLogs[0].set("log", null);
                newLogs[0].set("log_tag", null);
                newLogs[0].set("log_tag", (Object)errorBuilder.toString());
                String string = errorBuilder.toString();
                if (string.length() > 200) {
                    String string2 = string.substring(0, 200);
                }
                newLogs[0].set("log", (Object)var14_21);
                newLogs[0].set("isclose", (Object)"");
                newLogs[0].set("isclose", (Object)"0");
                newLogs[0].set("success", (Object)"");
                newLogs[0].set("success", (Object)"0");
            } else {
                newLogs[0].set("log", null);
                newLogs[0].set("log_tag", null);
                newLogs[0].set("isclose", (Object)"");
                newLogs[0].set("isclose", (Object)"1");
                newLogs[0].set("success", (Object)"");
                newLogs[0].set("success", (Object)"1");
            }
            this.setCalStatus(newLogs[0]);
            newLogs[0].set("exetime", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newLogs[0]});
            return;
        }
        HashSet<Long> delEntLogIds = new HashSet<Long>(16);
        if (errIdMap.size() == 0) {
            for (DynamicObject log : newLogs) {
                log.set("log", null);
                log.set("log_tag", null);
                log.set("success", (Object)"");
                log.set("success", (Object)"1");
                this.setCalStatus(log, calIngActionNameBizBillIdsMap);
                delEntLogIds.add(log.getLong("id"));
                log.set("isclose", (Object)"");
                log.set("isclose", (Object)"1");
                log.set("exetime", (Object)new Date());
            }
        } else {
            for (DynamicObject log : newLogs) {
                long id = log.getLong("bizbillid");
                ErrorMsg msg = (ErrorMsg)errIdMap.get(id);
                log.set("log", null);
                log.set("log_tag", null);
                if (msg != null) {
                    log.set("success", (Object)"");
                    String errorType = msg.getErrorType();
                    if (StringUtils.isNotEmpty((String)errorType)) {
                        log.set("success", (Object)errorType);
                    } else {
                        log.set("success", (Object)"0");
                    }
                    String logStr = msg.getErrorMsg();
                    if (!StringUtils.isEmpty((String)logStr)) {
                        log.set("log_tag", (Object)logStr);
                        if (logStr.length() > 200) {
                            logStr = logStr.substring(0, 200);
                            logStr = logStr + "...";
                        }
                        log.set("log", (Object)logStr);
                    }
                    log.set("isclose", (Object)"");
                    log.set("isclose", (Object)"0");
                    if (!this.mulErrorBizBillIds.contains(msg.getId())) {
                        log.set("times", (Object)(log.getInt("times") + 1));
                    }
                } else {
                    log.set("success", (Object)"");
                    log.set("success", (Object)"1");
                    log.set("isclose", (Object)"");
                    log.set("isclose", (Object)"1");
                    delEntLogIds.add(log.getLong("id"));
                }
                this.setCalStatus(log, calIngActionNameBizBillIdsMap);
                log.set("exetime", (Object)new Date());
            }
        }
        try (TXHandle tXHandle = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])newLogs);
            this.deleteEntryLog(delEntLogIds);
        }
    }

    private void deleteEntryLog(Set<Long> delEntLogIds) {
        if (delEntLogIds.isEmpty()) {
            return;
        }
        if (!CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.ENTRY_SPLIT_INTIME_CAL).booleanValue()) {
            return;
        }
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_businesslog", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, delEntLogIds)});){
            ctx.set();
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("delete from t_cal_businesslogentry where ", new Object[0]);
            sqlBuilder.appendIn("fid", delEntLogIds.toArray());
            DB.execute((DBRoute)new DBRoute("cal"), (SqlBuilder)sqlBuilder);
        }
    }

    private void setCalStatus(DynamicObject log, Map<String, Set<Long>> calIngActionNameBizBillIdsMap) {
        String actionName = log.getString("actionname");
        Set<Long> calIngBizBillIds = calIngActionNameBizBillIdsMap.get(actionName);
        long bizBillId = log.getLong("bizbillid");
        if (calIngBizBillIds == null || !calIngBizBillIds.contains(bizBillId)) {
            this.setCalStatus(log);
        }
    }

    private Map<Long, Set<String>> getWfRecordIdOmInBillnoMap(String actionName, DynamicObject[] bizBills, Set idSet) {
        HashMap<Long, Set<String>> wfRecordIdOmInBillnoMap = new HashMap<Long, Set<String>>(bizBills.length);
        if (ActionEnum.MATERIALWRITEOFF.getValue().equals(actionName)) {
            RowMeta rowMeta1 = ORM.create().createRowMeta("im_mdc_omwrfrecord", "id,entry.billtype.number as entity,entry.billno as billno");
            OrmInput billRuleDs1 = new OrmInput(this.getClass().getName(), "im_mdc_omwrfrecord", "id,entry.billtype.number as entity,entry.billno as billno", new QFilter[]{new QFilter("id", "in", (Object)idSet)}, rowMeta1);
            RowMeta rowMeta2 = ORM.create().createRowMeta("im_oswfrecord", "id,entry.billtype.number as entity,entry.billno as billno");
            OrmInput billRuleDs2 = new OrmInput(this.getClass().getName(), "im_oswfrecord", "id,entry.billtype.number as entity,entry.billno as billno", new QFilter[]{new QFilter("id", "in", (Object)idSet)}, rowMeta2);
            try (DataSet billRuleDs = Algo.create((String)this.getClass().getName()).createDataSet((Input[])new OrmInput[]{billRuleDs1, billRuleDs2});){
                for (Row row : billRuleDs) {
                    Long writeOffRecordId;
                    Set omInBillNo;
                    if (!"im_mdc_ominbill".equals(row.getString("entity")) && !"im_ospurinbill".equals(row.getString("entity")) || !(omInBillNo = wfRecordIdOmInBillnoMap.computeIfAbsent(writeOffRecordId = row.getLong("id"), k -> new HashSet(16))).isEmpty()) continue;
                    omInBillNo.add(row.getString("billno"));
                }
            }
        }
        return wfRecordIdOmInBillnoMap;
    }

    private DynamicObject createLogDyc(String serviceType, String actionName, String paramMap, String mainOrgName, DynamicObject bill, Map<Long, Set<String>> wfRecordIdOmInBillnoMap) {
        boolean hasOrgProperty;
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"cal_businesslog");
        log.set("servicetype", (Object)serviceType);
        log.set("actionname", (Object)actionName);
        log.set("parammap_tag", (Object)paramMap);
        log.set("parammap", (Object)paramMap);
        log.set("times", (Object)0);
        log.set("success", (Object)Character.valueOf('2'));
        log.set("calstatus", (Object)"C");
        log.set("exetime", (Object)new Date());
        log.set("bizentityobject", (Object)bill.getDataEntityType().getName());
        log.set("bizbillid", bill.get("id"));
        if (ActionEnum.MATERIALWRITEOFF.getValue().equals(actionName)) {
            Set<String> omInBillNos = wfRecordIdOmInBillnoMap.get(bill.get("id"));
            if (omInBillNos != null && omInBillNos.size() > 0) {
                log.set("bizbillnumber", (Object)String.join((CharSequence)",", omInBillNos));
            } else {
                log.set("bizbillnumber", bill.get("wfnumber"));
            }
            log.set("org", (Object)bill.getLong("org_id"));
        } else {
            log.set("bizbillnumber", bill.get("billno"));
        }
        boolean bl = hasOrgProperty = bill.getDataEntityType().getProperties().get((Object)mainOrgName) != null;
        if (hasOrgProperty) {
            log.set("org", bill.get(mainOrgName));
        }
        return log;
    }

    public void setMulErrorBizBillIds(List<ErrorMsg> mulErrorMsg) {
        if (mulErrorMsg == null || mulErrorMsg.isEmpty()) {
            return;
        }
        for (ErrorMsg errorMsg : mulErrorMsg) {
            this.mulErrorBizBillIds.add(errorMsg.getId());
        }
    }

    public void setCalProcessContext(CalProcessContext calProcessContext) {
        this.calProcessContext = calProcessContext;
    }

    private void setCalStatus(DynamicObject log) {
        if ("1".equals(log.getString("success"))) {
            log.set("calstatus", (Object)"A");
        } else {
            log.set("calstatus", (Object)" ");
        }
    }
}

