/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.cal.business.calculate.bizbillgroup.BizGroupRecordBuilder;
import kd.fi.cal.business.wf.WfHelper;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.SynBizBillHelper;

public class CalProcessReExcuteHandle {
    public void handle(Map<String, List<Long>> auditBillIdMap) {
        this.autoExeMatWfErrorLog(auditBillIdMap);
        this.autoExeApWfErrorLog(auditBillIdMap);
        this.autoExeArWfErrorLog(auditBillIdMap);
        this.autoCostestimateBillErrorLog(auditBillIdMap);
    }

    public void autoExeCurBizBillErrorLog(Map<String, List<Long>> auditBillIdMap) {
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        for (List<Long> auditBillIds : auditBillIdMap.values()) {
            bizBillIds.addAll(auditBillIds);
        }
        QFilter bizBillIdsF = new QFilter("bizbillid", "in", bizBillIds);
        QFilter errorLogF = new QFilter("success", "in", (Object)new String[]{"0", "3", "4", "5"});
        List errorLongIds = QueryServiceHelper.queryPrimaryKeys((String)"cal_businesslog", (QFilter[])new QFilter[]{bizBillIdsF, errorLogF}, null, (int)-1);
        if (errorLongIds.isEmpty()) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        OperationServiceHelper.executeOperate((String)"excute", (String)"cal_businesslog", (Object[])errorLongIds.toArray(), (OperateOption)option);
    }

    private void autoExeMatWfErrorLog(Map<String, List<Long>> auditBillIdMap) {
        List<Long> osPurInBillIds;
        List<Long> omInBillIds = auditBillIdMap.get("im_mdc_ominbill");
        if (omInBillIds != null && omInBillIds.size() > 0) {
            QFilter errorLogF;
            QFilter omInBillIdF = new QFilter("entry.billid", "in", omInBillIds);
            List matWfRecordId = QueryServiceHelper.queryPrimaryKeys((String)"im_mdc_omwrfrecord", (QFilter[])omInBillIdF.toArray(), null, (int)-1);
            QFilter wfIdF = new QFilter("bizbillid", "in", (Object)matWfRecordId);
            List errorWfLogId = QueryServiceHelper.queryPrimaryKeys((String)"cal_businesslog", (QFilter[])new QFilter[]{wfIdF, errorLogF = new QFilter("success", "in", (Object)new String[]{"0", "3", "4"})}, null, (int)-1);
            if (errorWfLogId.isEmpty()) {
                return;
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            OperationServiceHelper.executeOperate((String)"excute", (String)"cal_businesslog", (Object[])errorWfLogId.toArray(), (OperateOption)option);
        }
        if ((osPurInBillIds = auditBillIdMap.get("im_ospurinbill")) != null && osPurInBillIds.size() > 0) {
            QFilter errorLogF;
            QFilter osPurInBillIdF = new QFilter("entry.billid", "in", osPurInBillIds);
            List matWfRecordId = QueryServiceHelper.queryPrimaryKeys((String)"im_oswfrecord", (QFilter[])osPurInBillIdF.toArray(), null, (int)-1);
            QFilter wfIdF = new QFilter("bizbillid", "in", (Object)matWfRecordId);
            List errorWfLogId = QueryServiceHelper.queryPrimaryKeys((String)"cal_businesslog", (QFilter[])new QFilter[]{wfIdF, errorLogF = new QFilter("success", "in", (Object)new String[]{"0", "3", "4"})}, null, (int)-1);
            if (errorWfLogId.isEmpty()) {
                return;
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            OperationServiceHelper.executeOperate((String)"excute", (String)"cal_businesslog", (Object[])errorWfLogId.toArray(), (OperateOption)option);
        }
    }

    private void autoExeApWfErrorLog(Map<String, List<Long>> auditBillIdMap) {
        ArrayList<Long> allInBillIds = new ArrayList<Long>(16);
        List<Long> purInBIllIds = auditBillIdMap.get("im_purinbill");
        List<Long> omInBIllIds = auditBillIdMap.get("im_mdc_ominbill");
        List<Long> osPurInBIllIds = auditBillIdMap.get("im_ospurinbill");
        if (purInBIllIds != null && purInBIllIds.size() > 0) {
            allInBillIds.addAll(purInBIllIds);
        }
        if (omInBIllIds != null && omInBIllIds.size() > 0) {
            allInBillIds.addAll(omInBIllIds);
        }
        if (osPurInBIllIds != null && osPurInBIllIds.size() > 0) {
            allInBillIds.addAll(osPurInBIllIds);
        }
        if (allInBillIds.size() > 0) {
            QFilter allInBillIdF = new QFilter("billid", "in", allInBillIds);
            allInBillIdF.and(new QFilter("entry.e_iswrittenoff", "=", (Object)Boolean.FALSE));
            HashSet<Long> apWfRecordIds = new HashSet<Long>(16);
            String apVerifyrecordEntity = "ap_verifyrecord";
            try (DataSet apWfRecordDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)apVerifyrecordEntity, (String)"id", (QFilter[])allInBillIdF.toArray(), null, (int)-1);){
                for (Row row : apWfRecordDs) {
                    apWfRecordIds.add(row.getLong("id"));
                }
            }
            this.writeOffBillReExcuter(apVerifyrecordEntity, apWfRecordIds, ActionEnum.PUR_WRITEOFF.getValue());
        }
    }

    private void autoExeArWfErrorLog(Map<String, List<Long>> auditBillIdMap) {
        List<Long> salOutBillIds = auditBillIdMap.get("im_saloutbill");
        if (salOutBillIds != null && salOutBillIds.size() > 0) {
            QFilter salOutBillIdF = new QFilter("billid", "in", salOutBillIds);
            salOutBillIdF.and(new QFilter("entry.e_iswrittenoff", "=", (Object)Boolean.FALSE));
            HashSet<Long> arWfRecordIds = new HashSet<Long>(16);
            String arVerifyrecordEntity = "ar_verifyrecord";
            try (DataSet apWfRecordDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)arVerifyrecordEntity, (String)"id", (QFilter[])salOutBillIdF.toArray(), null, (int)-1);){
                for (Row row : apWfRecordDs) {
                    arWfRecordIds.add(row.getLong("id"));
                }
            }
            this.writeOffBillReExcuter(arVerifyrecordEntity, arWfRecordIds, ActionEnum.SALE_WRITEOFF.getValue());
        }
    }

    private void autoCostestimateBillErrorLog(Map<String, List<Long>> auditBillIdMap) {
        HashSet allInBillIds = new HashSet(16);
        List<Long> purInBIllIds = auditBillIdMap.get("im_purinbill");
        String apBusBillEntity = "ap_busbill";
        if (purInBIllIds != null && purInBIllIds.size() > 0) {
            QFilter apBusBillIdF = new QFilter("entry.e_srcbillid", "in", purInBIllIds);
            apBusBillIdF.and(new QFilter("isrevaluation", "=", (Object)Boolean.TRUE));
            HashSet<Long> apBusbillIds = new HashSet<Long>(16);
            try (DataSet apBusBillDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)apBusBillEntity, (String)"id", (QFilter[])apBusBillIdF.toArray(), null, (int)-1);){
                for (Row row : apBusBillDs) {
                    apBusbillIds.add(row.getLong("id"));
                }
            }
            if (apBusbillIds.size() > 0) {
                HashSet<Long> revbillIds = new HashSet<Long>(16);
                QFilter revbillIdF = new QFilter("entry.e_srcbillid", "in", apBusbillIds);
                revbillIdF.and(new QFilter("isrevaluation", "=", (Object)Boolean.TRUE));
                try (DataSet revbillDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)apBusBillEntity, (String)"id", (QFilter[])revbillIdF.toArray(), null, (int)-1);){
                    for (Row row : revbillDs) {
                        revbillIds.add(row.getLong("id"));
                    }
                }
                allInBillIds.addAll(apBusbillIds);
                allInBillIds.addAll(revbillIds);
            }
            if (allInBillIds.size() > 0) {
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBizService", (String)"doService", (Object[])new Object[]{ActionEnum.REESTIMATE.getValue(), null, allInBillIds, "ap_busbill"});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOffBillReExcuter(String entityObject, Set<Long> writeOffBillIds, String actionname) {
        DataSet allDataSet = null;
        DataSet writeOffBillDataSet = null;
        DataSet dataSet = null;
        DataSet dataSettemp = null;
        HashSet<Object> billIds = new HashSet<Object>(1024);
        try {
            QFilter q = new QFilter("id", "in", writeOffBillIds);
            writeOffBillDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityObject, (String)"id,billid,verifyseq", (QFilter[])q.toArray(), null);
            dataSettemp = writeOffBillDataSet.copy();
            HashSet<Long> invBillIds = new HashSet<Long>(64);
            HashSet<Object> hashSet = new HashSet<Object>(64);
            for (Row row : dataSettemp) {
                Long invBillId = row.getLong("billId");
                Object verifySeq = row.get("verifyseq");
                if (invBillId == null || invBillId == 0L || verifySeq == null) continue;
                invBillIds.add(invBillId);
                hashSet.add(verifySeq);
            }
            if (!invBillIds.isEmpty() && !hashSet.isEmpty()) {
                QFilter qFilter = new QFilter("billid", "in", invBillIds);
                qFilter.and("verifyseq", "in", hashSet);
                qFilter.and(new QFilter("entry.e_iswrittenoff", "=", (Object)Boolean.FALSE));
                allDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityObject, (String)"id,billid,verifyseq", (QFilter[])qFilter.toArray(), null);
                dataSet = allDataSet.join(writeOffBillDataSet, JoinType.INNER).on("billid", "billid").on("verifyseq", "verifyseq").select(new String[]{"id", "billid"}, null).finish();
                HashSet<Long> bizBillIds = new HashSet<Long>(16);
                for (Row row : dataSet) {
                    billIds.add(row.get("id"));
                    bizBillIds.add(row.getLong("billid"));
                }
                SynBizBillHelper.removeHasWfIds(billIds, bizBillIds);
            }
        }
        finally {
            if (allDataSet != null) {
                allDataSet.close();
            }
            if (writeOffBillDataSet != null) {
                writeOffBillDataSet.close();
            }
            if (dataSet != null) {
                dataSet.close();
            }
            if (dataSettemp != null) {
                dataSettemp.close();
            }
        }
        if (billIds.isEmpty()) {
            return;
        }
        HashSet<Long> wfIds = new HashSet<Long>(16);
        for (Object e : billIds) {
            wfIds.add((Long)e);
        }
        new WfHelper().invokeBatchWfByIds(actionname, entityObject, wfIds);
    }

    public void autoMatWriteOff(String entityName, Set<Long> billIds) {
        if (billIds.isEmpty()) {
            return;
        }
        Set omInBills = CommonSettingHelper.getBizEntityNumbers((String)"ominbiztype");
        if (!omInBills.contains(entityName)) {
            return;
        }
        DataSet srcDataSet = this.getOmWfDs(billIds, omInBills);
        HashSet<Long> tmpWfRecordIds = new HashSet<Long>(16);
        Long preBillId = null;
        MainEntityType omPurWfEntityType = EntityMetadataCache.getDataEntityType((String)"im_mdc_omwrfrecord");
        MainEntityType omSimpleWfEntityType = EntityMetadataCache.getDataEntityType((String)"im_oswfrecord");
        for (Row row : srcDataSet) {
            boolean diffBillId;
            Long curBillId = row.getLong("billid");
            boolean bl = diffBillId = preBillId != null && !curBillId.equals(preBillId);
            if (diffBillId && tmpWfRecordIds.size() >= 100) {
                this.invokeMatWf(tmpWfRecordIds, omPurWfEntityType, omSimpleWfEntityType);
                tmpWfRecordIds = new HashSet(16);
            }
            tmpWfRecordIds.add(row.getLong("id"));
            preBillId = curBillId;
        }
        if (tmpWfRecordIds.size() > 0) {
            this.invokeMatWf(tmpWfRecordIds, omPurWfEntityType, omSimpleWfEntityType);
        }
    }

    private DataSet getOmWfDs(Set<Long> billIds, Set<String> omInBills) {
        QFilter billIdF = new QFilter("entry.billid", "in", billIds);
        QFilter entityF = new QFilter("entry.billtype", "in", omInBills);
        billIdF.and(entityF);
        ArrayList<OrmInput> inputs = new ArrayList<OrmInput>(16);
        OrmInput omPurBillInput = new OrmInput(this.getClass().getName(), "im_oswfrecord", "id,entry.billid billid", billIdF.toArray());
        OrmInput omSimpleBillInput = new OrmInput(this.getClass().getName(), "im_mdc_omwrfrecord", "id,entry.billid billid", billIdF.toArray());
        inputs.add(omPurBillInput);
        inputs.add(omSimpleBillInput);
        DataSet srcDataSet = Algo.create((String)this.getClass().getName()).createDataSet((Input[])inputs.toArray(new OrmInput[0]));
        srcDataSet = srcDataSet.orderBy(new String[]{"billid"});
        return srcDataSet;
    }

    private void invokeMatWf(Set<Long> tmpWfRecordIds, MainEntityType omPurWfEntityType, MainEntityType omSimpleWfEntityType) {
        ArrayList<DynamicObject> wfDycs = new ArrayList<DynamicObject>(16);
        DynamicObject[] omPurWfDycs = BusinessDataServiceHelper.load((Object[])tmpWfRecordIds.toArray(), (DynamicObjectType)omPurWfEntityType);
        DynamicObject[] omSimpleWfDycs = BusinessDataServiceHelper.load((Object[])tmpWfRecordIds.toArray(), (DynamicObjectType)omSimpleWfEntityType);
        wfDycs.addAll(Arrays.asList(omPurWfDycs));
        wfDycs.addAll(Arrays.asList(omSimpleWfDycs));
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBizService", (String)"doService", (Object[])new Object[]{ActionEnum.MATERIALWRITEOFF.getValue(), null, wfDycs.toArray(new DynamicObject[0])});
    }

    public void autoMatWriteOffBatchSyc(QFilter costRecF) {
        Set bizBillIds;
        costRecF.and("bizentityobject", "in", (Object)new String[]{"im_purinbill", "im_mdc_ominbill"});
        DataSet srcCostRecDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"bizbillid,bizentityobject", (QFilter[])costRecF.toArray(), null);
        HashMap<String, Set<Long>> mainEntityBizBillIdsMap = new HashMap<String, Set<Long>>(16);
        for (Row row : srcCostRecDs.copy()) {
            String entity = row.getString("bizentityobject");
            Long bizBillId = row.getLong("bizbillid");
            bizBillIds = mainEntityBizBillIdsMap.computeIfAbsent(entity, k -> new HashSet(16));
            bizBillIds.add(bizBillId);
        }
        DataSet groupDs = null;
        if (AcctGroupModelHelper.isBizGroupModel()) {
            groupDs = new BizGroupRecordBuilder().getAllGroupRecordDataSetByBizBillIds(mainEntityBizBillIdsMap);
        } else {
            HashSet allBizBillIds = new HashSet(16);
            for (Map.Entry entry : mainEntityBizBillIdsMap.entrySet()) {
                bizBillIds = (Set)entry.getValue();
                allBizBillIds.addAll(bizBillIds);
            }
            QFilter tgtIdF = new QFilter("entryentity.bizbillid", "in", allBizBillIds);
            String groupRecKey = AcctGroupModelHelper.isNewGroupModel() ? "cal_account_grouprecord" : "cal_groupbillrecord";
            String tgSelectFields = "id,entryentity.bizbillid as bizbillid";
            groupDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)groupRecKey, (String)tgSelectFields, (QFilter[])new QFilter[]{tgtIdF}, null);
        }
        srcCostRecDs = srcCostRecDs.leftJoin(groupDs).on("bizbillid", "bizbillid").select(new String[]{"bizbillid", "bizentityobject"}, new String[]{"bizbillid groupbizbillid"}).finish().filter("groupbizbillid is null");
        HashMap<String, Set> needMatWfMainEntityBizBillIdsMap = new HashMap<String, Set>(16);
        for (Row row : srcCostRecDs) {
            String entity = row.getString("bizentityobject");
            Long bizBillId = row.getLong("bizbillid");
            Set bizBillIds2 = needMatWfMainEntityBizBillIdsMap.computeIfAbsent(entity, k -> new HashSet(16));
            bizBillIds2.add(bizBillId);
        }
        for (Map.Entry entry : needMatWfMainEntityBizBillIdsMap.entrySet()) {
            String entityName = (String)entry.getKey();
            Set billIds = (Set)entry.getValue();
            new CalProcessReExcuteHandle().autoMatWriteOff(entityName, billIds);
        }
    }
}

