/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.process.AbstractBizProcessor;
import kd.fi.cal.business.process.ErrorMsg;
import kd.fi.cal.business.process.IBizProcessor;
import kd.fi.cal.business.service.CalProcessContext;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.helper.CommonSettingHelper;

public class CalServiceHelper {
    private static final Log logger = LogFactory.getLog(CalServiceHelper.class);
    private CalProcessContext calProcessContext = null;

    public static List<ErrorMsg> doBizChain(String serviceType, String actionName, Map params, DynamicObject[] bizBills) throws Exception {
        return new CalServiceHelper().doBizChain(CalServiceHelper.getServiceSetting(serviceType, actionName), params, bizBills, actionName);
    }

    public List<ErrorMsg> doBizChainNew(String serviceType, String actionName, Map params, DynamicObject[] bizBills) throws Exception {
        return this.doBizChain(CalServiceHelper.getServiceSetting(serviceType, actionName), params, bizBills, actionName);
    }

    public List<ErrorMsg> doBizChain(List<String> implClassList, Map params, DynamicObject[] bizBills, String actionName) throws Exception {
        List<ErrorMsg> errList = null;
        Object lockMap = null;
        boolean auditOrUnaudit = ActionEnum.AUDIT.getValue().equals(actionName) || ActionEnum.UN_AUDIT.getValue().equals(actionName);
        for (int i = 0; i < implClassList.size(); ++i) {
            String className = implClassList.get(i);
            AbstractBizProcessor process = (AbstractBizProcessor)CalServiceHelper.getProcessByName(className);
            if (process == null) {
                errList = new ArrayList();
                String msg = String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5904\u7406\u5668\uff1a%1$s", (String)"CalServiceHelper_0", (String)"fi-cal-business", (Object[])new Object[0]), className);
                if (auditOrUnaudit) {
                    CalServiceHelper.handleErrorMsg(errList, bizBills, msg, "4");
                    break;
                }
                CalServiceHelper.handleErrorMsg(errList, bizBills, msg);
                break;
            }
            if (errList != null && errList.size() > 0) {
                if (bizBills == null || bizBills.length <= 0) break;
                process.addErrors(errList);
                ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
                for (int j = 0; j < bizBills.length; ++j) {
                    if (bizBills[j] == null) continue;
                    boolean isErrBill = false;
                    for (ErrorMsg msg : errList) {
                        if (!msg.getId().equals(bizBills[j].getLong("id"))) continue;
                        isErrBill = true;
                        break;
                    }
                    if (isErrBill) continue;
                    list.add(bizBills[j]);
                }
                bizBills = list.toArray(new DynamicObject[0]);
            }
            long startTime = System.currentTimeMillis();
            process.setCalProcessContext(this.calProcessContext);
            TraceSpan span = Tracer.create((String)("CalServiceHelper." + className), (String)className);
            Object object = null;
            try {
                process.doProcessor(params, bizBills);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (span != null) {
                    if (object != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        span.close();
                    }
                }
            }
            logger.info(process.getClass().getName() + "\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime) + "ms");
            errList = process.getErrors();
        }
        if (implClassList.size() == 0) {
            errList = new ArrayList<ErrorMsg>();
            if (auditOrUnaudit) {
                CalServiceHelper.handleErrorMsg(errList, bizBills, ResManager.loadKDString((String)"\u6ca1\u6709\u914d\u7f6e\u8be5\u63a5\u53e3", (String)"CalServiceHelper_1", (String)"fi-cal-mservice", (Object[])new Object[0]), "4");
            } else {
                CalServiceHelper.handleErrorMsg(errList, bizBills, ResManager.loadKDString((String)"\u6ca1\u6709\u914d\u7f6e\u8be5\u63a5\u53e3", (String)"CalServiceHelper_1", (String)"fi-cal-mservice", (Object[])new Object[0]));
            }
        }
        return errList;
    }

    public static IBizProcessor getProcessByName(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<?> process = Class.forName(className);
        return (IBizProcessor)process.newInstance();
    }

    public static List<String> getServiceSetting(String serviceType, String actionName) {
        Boolean useNewPlan;
        String fields = "entry.exeseq,entry.implclass";
        QFilter settingFilter = new QFilter("servicetype", "=", (Object)serviceType);
        settingFilter.and(new QFilter("actionname", "=", (Object)actionName));
        if (ActionEnum.AUDIT.getValue().equals(actionName) && "B".equals(serviceType) && (useNewPlan = CommonSettingHelper.isUseNewPlan()).booleanValue()) {
            settingFilter.and(new QFilter("settingnum", "=", (Object)"SYNC_CALBILL_AUDIT_NEW_SYS"));
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)("CalServiceHelper.getServiceSetting." + serviceType + actionName), (String)"cal_actionchain", (String)fields, (QFilter[])new QFilter[]{settingFilter}, (String)"entry.exeseq");
        ArrayList<String> implList = new ArrayList<String>(32);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            String implClassStr = row.get("entry.implclass").toString();
            implList.add(implClassStr);
        }
        return implList;
    }

    public static void handleErrorMsg(List<ErrorMsg> errList, DynamicObject[] bizBills, String errorMsg) {
        CalServiceHelper.handleErrorMsg(errList, bizBills, errorMsg, null);
    }

    public static void handleErrorMsg(List<ErrorMsg> errList, DynamicObject[] bizBills, String errorMsg, String errType) {
        if (bizBills != null && bizBills.length > 0) {
            for (DynamicObject bizBill : bizBills) {
                ErrorMsg msg = new ErrorMsg();
                if (StringUtils.isNotEmpty((String)errType)) {
                    msg.setErrorType(errType);
                }
                msg.setErrorMsg(errorMsg);
                msg.setObject(bizBill);
                msg.setId(bizBill.getLong("id"));
                errList.add(msg);
            }
        } else {
            ErrorMsg msg = new ErrorMsg();
            if (StringUtils.isNotEmpty((String)errType)) {
                msg.setErrorType(errType);
            }
            msg.setErrorMsg(errorMsg);
            errList.add(msg);
        }
    }

    public void setCalProcessContext(CalProcessContext calProcessContext) {
        this.calProcessContext = calProcessContext;
    }
}

