/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.service;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.enums.ActionEnum;

public class LogBizTimeResolver {
    private List<DynamicObject> logs;
    private DynamicObject[] bizBills;
    private String actionName;
    private boolean isLoadFromData;
    private boolean isLoadBookDateFromData;
    private String bizTimeName = "bizdate";
    private String booDateName = "bookdate";
    private Map<Long, Date> bizIdBizTimeMap = new HashMap<Long, Date>(16);
    private Map<Long, Date> bizIdBookDateMap = new HashMap<Long, Date>(16);

    public LogBizTimeResolver(String actionName, List<DynamicObject> logs, DynamicObject[] bizBills) {
        this.logs = logs;
        this.actionName = actionName;
        this.bizBills = bizBills;
        boolean availableTable = true;
        switch (ActionEnum.getEnum((String)actionName)) {
            case SUBMIT: 
            case UN_SUBMIT: 
            case AUDIT: 
            case UN_AUDIT: 
            case RESYNC: {
                this.bizTimeName = "biztime";
                this.booDateName = "bookdate";
                break;
            }
            case PUR_WRITEOFF: 
            case SALE_WRITEOFF: {
                this.bizTimeName = "biztime";
                this.booDateName = "bookdate";
                availableTable = false;
                break;
            }
            case MATERIALWRITEOFF: {
                availableTable = false;
                break;
            }
            case COSTESTIMATECREATE: 
            case COSTESTIMATEDELETE: 
            case REESTIMATE: {
                this.bizTimeName = "bizdate";
                this.booDateName = "bookdate";
                break;
            }
            default: {
                availableTable = false;
            }
        }
        this.isLoadFromData = availableTable && bizBills != null && bizBills.length != 0 && bizBills[0].getDataEntityType().getProperties().containsKey((Object)this.bizTimeName);
        this.isLoadBookDateFromData = availableTable && bizBills != null && bizBills.length != 0 && bizBills[0].getDataEntityType().getProperties().containsKey((Object)this.booDateName);
        this.getBizTimeMap();
    }

    public void getBizTimeMap() {
        if (this.isLoadFromData && this.isLoadBookDateFromData) {
            for (DynamicObject bizBill : this.bizBills) {
                Date bizTime = bizBill.getDate(this.bizTimeName);
                long bizId = bizBill.getLong("id");
                this.bizIdBizTimeMap.put(bizId, bizTime);
                Date bookDate = bizBill.getDate(this.booDateName);
                this.bizIdBookDateMap.put(bizId, bookDate);
            }
        } else {
            this.loadDataFromDb();
        }
    }

    public void loadDataFromDb() {
        HashMap<String, Set<Long>> tableAndIdsMap = new HashMap<String, Set<Long>>(16);
        String entityName = null;
        for (DynamicObject dynamicObject : this.logs) {
            this.setAndMerge(tableAndIdsMap, dynamicObject);
        }
        for (Map.Entry entry : tableAndIdsMap.entrySet()) {
            entityName = (String)entry.getKey();
            Set ids = (Set)entry.getValue();
            switch (ActionEnum.getEnum((String)this.actionName)) {
                case SUBMIT: 
                case UN_SUBMIT: 
                case AUDIT: 
                case UN_AUDIT: 
                case RESYNC: 
                case COSTESTIMATECREATE: 
                case COSTESTIMATEDELETE: 
                case REESTIMATE: {
                    this.queryAndSetBizMap(entityName, ids);
                    break;
                }
                case PUR_WRITEOFF: {
                    this.queryWriteOffDateMap("ap_verifyrecord", "im_purinbill", ids);
                    break;
                }
                case SALE_WRITEOFF: {
                    this.queryWriteOffDateMap("ar_verifyrecord", "im_saloutbill", ids);
                    break;
                }
                case MATERIALWRITEOFF: {
                    this.queryAndSetBizMap(ids);
                    break;
                }
            }
        }
    }

    private void setAndMerge(Map<String, Set<Long>> tableAndIdsMap, DynamicObject logs) {
        String entityName;
        Long bizBillId = logs.getLong("bizbillid");
        Object entity = logs.get("bizentityobject");
        if (entity instanceof DynamicObject) {
            DynamicObject bizObject = logs.getDynamicObject("bizentityobject");
            entityName = bizObject.getString("number");
        } else {
            entityName = (String)entity;
        }
        if (!tableAndIdsMap.containsKey(entityName)) {
            HashSet<Long> ids = new HashSet<Long>();
            ids.add(bizBillId);
            tableAndIdsMap.put(entityName, ids);
        } else {
            Set<Long> ids = tableAndIdsMap.get(entityName);
            ids.add(bizBillId);
        }
    }

    private void queryAndSetBizMap(String entityName, Set<Long> ids) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        DataEntityPropertyCollection properties = entityType.getProperties();
        boolean isContainsBizDate = properties.containsKey((Object)this.bizTimeName);
        boolean isContainsBookDate = properties.containsKey((Object)this.booDateName);
        if (!isContainsBizDate && !isContainsBookDate) {
            return;
        }
        QFilter filter = new QFilter("id", "in", ids);
        String selectField = "id,";
        if (isContainsBizDate) {
            selectField = selectField + this.bizTimeName;
        }
        if (isContainsBookDate && !this.bizTimeName.equals(this.booDateName)) {
            selectField = selectField + "," + this.booDateName;
        }
        try (DataSet results = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityName, (String)selectField, (QFilter[])filter.toArray(), null);){
            for (Row next : results) {
                Long id = next.getLong("id");
                if (isContainsBizDate) {
                    Date bizTime = next.getDate(this.bizTimeName);
                    this.bizIdBizTimeMap.put(id, bizTime);
                }
                if (!isContainsBookDate) continue;
                Date bookDate = next.getDate(this.booDateName);
                this.bizIdBookDateMap.put(id, bookDate);
            }
        }
    }

    private void queryAndSetBizMap(Set<Long> ids) {
        HashSet<Long> ominbillIds = new HashSet<Long>(16);
        HashMap<Long, Long> wfRecordIdOmInBillIdMap = new HashMap<Long, Long>(16);
        QFilter filter = new QFilter("id", "in", ids);
        filter.and(new QFilter("entry.billtype", "=", (Object)"im_mdc_ominbill"));
        RowMeta rowMeta1 = ORM.create().createRowMeta("im_mdc_omwrfrecord", "id,entry.billid");
        OrmInput results1 = new OrmInput(this.getClass().getName(), "im_mdc_omwrfrecord", "id,entry.billid", filter.toArray(), rowMeta1);
        QFilter filter2 = new QFilter("id", "in", ids);
        filter2.and(new QFilter("entry.billtype", "=", (Object)"im_ospurinbill"));
        RowMeta rowMeta2 = ORM.create().createRowMeta("im_oswfrecord", "id,entry.billid");
        OrmInput results2 = new OrmInput(this.getClass().getName(), "im_oswfrecord", "id,entry.billid", filter2.toArray(), rowMeta2);
        try (DataSet results = Algo.create((String)this.getClass().getName()).createDataSet((Input[])new OrmInput[]{results1, results2});){
            for (Row record : results) {
                long billId = record.getLong("entry.billid");
                wfRecordIdOmInBillIdMap.put(record.getLong("id"), billId);
                ominbillIds.add(billId);
            }
        }
        if (ominbillIds == null || ominbillIds.size() == 0) {
            return;
        }
        HashMap<Long, Date> omInBillIdBizDateMap = new HashMap<Long, Date>(16);
        RowMeta rowMeta3 = ORM.create().createRowMeta("im_mdc_ominbill", "id,biztime");
        OrmInput ominbill = new OrmInput(this.getClass().getName(), "im_mdc_ominbill", "id,biztime", new QFilter("id", "in", ominbillIds).toArray(), rowMeta3);
        RowMeta rowMeta4 = ORM.create().createRowMeta("im_ospurinbill", "id,bookdate as biztime");
        OrmInput osinbill = new OrmInput(this.getClass().getName(), "im_ospurinbill", "id,bookdate as biztime", new QFilter("id", "in", ominbillIds).toArray(), rowMeta4);
        try (DataSet ds = Algo.create((String)this.getClass().getName()).createDataSet((Input[])new OrmInput[]{ominbill, osinbill});){
            for (Row row : ds) {
                Long billId = row.getLong("id");
                Date bizTime = row.getDate("biztime");
                omInBillIdBizDateMap.put(billId, bizTime);
            }
        }
        for (Map.Entry item : wfRecordIdOmInBillIdMap.entrySet()) {
            Long omInBillId = (Long)item.getValue();
            Long wfRecordId = (Long)item.getKey();
            this.bizIdBizTimeMap.put(wfRecordId, (Date)omInBillIdBizDateMap.get(omInBillId));
            this.bizIdBookDateMap.put(wfRecordId, (Date)omInBillIdBizDateMap.get(omInBillId));
        }
    }

    public void setBizTime() {
        for (DynamicObject log : this.logs) {
            Long bizEntityObjectId = log.getLong("bizbillid");
            Date bizDate = this.bizIdBizTimeMap.get(bizEntityObjectId);
            Date bookDate = this.bizIdBookDateMap.get(bizEntityObjectId);
            if (bizDate != null) {
                log.set("biztime", (Object)bizDate);
            }
            if (bookDate == null) continue;
            log.set("bookdate", (Object)bookDate);
        }
    }

    private void queryWriteOffDateMap(String wFRecordEntity, String mainBillEntity, Set<Long> ids) {
        QFilter idF = new QFilter("id", "in", ids);
        HashMap<Long, Long> wFIdMainBillIdMap = new HashMap<Long, Long>(16);
        try (DataSet wFDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)wFRecordEntity, (String)"id,billid,billtype", (QFilter[])idF.toArray(), null);){
            for (Row row : wFDs) {
                wFIdMainBillIdMap.put(row.getLong("id"), row.getLong("billid"));
                mainBillEntity = row.getString("billtype");
            }
        }
        if (StringUtils.isEmpty((String)mainBillEntity)) {
            return;
        }
        DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)mainBillEntity).getProperties();
        if (!properties.containsKey((Object)this.bizTimeName) || !properties.containsKey((Object)this.booDateName)) {
            return;
        }
        HashMap<Long, Date> mainBillBizDateMap = new HashMap<Long, Date>(16);
        HashMap<Long, Date> mainBillBookDateMap = new HashMap<Long, Date>(16);
        try (DataSet mainBillDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)mainBillEntity, (String)("id," + this.bizTimeName + "," + this.booDateName), (QFilter[])new QFilter("id", "in", wFIdMainBillIdMap.values()).toArray(), null);){
            for (Row row : mainBillDs) {
                if (mainBillEntity == null) {
                    mainBillEntity = row.getString("billtype");
                }
                mainBillBizDateMap.put(row.getLong("id"), row.getDate(this.bizTimeName));
                mainBillBookDateMap.put(row.getLong("id"), row.getDate(this.booDateName));
            }
        }
        for (Map.Entry wFMainBillIdEntry : wFIdMainBillIdMap.entrySet()) {
            this.bizIdBizTimeMap.put((Long)wFMainBillIdEntry.getKey(), (Date)mainBillBizDateMap.get(wFMainBillIdEntry.getValue()));
            this.bizIdBookDateMap.put((Long)wFMainBillIdEntry.getKey(), (Date)mainBillBookDateMap.get(wFMainBillIdEntry.getValue()));
        }
    }
}

