/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntryType;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.calculate.bizbillgroup.BizGroupRecordBuilder;
import kd.fi.cal.business.process.ErrorMsg;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.lock.DbBatchLock;
import kd.fi.cal.common.lock.IBatchLock;
import kd.fi.cal.common.lock.RedisBatchLock;

public class SyncLockHelper
implements AutoCloseable {
    private final String actionName;
    private List<String> lockKeyFields = new ArrayList<String>(16);
    private DynamicObject[] bizBillDycs = null;
    private List<DynamicObject> errorBizBillDycs = new ArrayList<DynamicObject>(16);
    private Set<String> lockKeys = new HashSet<String>(16);
    private IBatchLock batchLock;
    private static final Set<String> lockOps = new HashSet<String>(16);
    private boolean noRetry = false;
    private boolean noLock = false;
    private Map<String, String> billIdBillNoMap = new HashMap<String, String>(16);
    private Map syncParams = new HashMap(16);

    public SyncLockHelper(String actionName, DynamicObject[] bizBillDycs) {
        this.actionName = actionName;
        if (bizBillDycs == null || bizBillDycs.length < 1) {
            return;
        }
        this.bizBillDycs = bizBillDycs;
        this.getLockSuffixs(bizBillDycs);
        String lockType = CalDbParamServiceHelper.getString((String)CalDbParamConstant.LOCK_TYPE, null);
        this.batchLock = new RedisBatchLock(actionName);
        if ("db".equals(lockType)) {
            this.batchLock = new DbBatchLock(actionName);
        }
        this.batchLock.setLockKeys(this.lockKeys);
        Integer expiretTime = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.SYNC_REDISLOCK_EXPIRETIME);
        this.batchLock.setExpireTime(expiretTime.intValue());
        this.setBillIdBillNoMap();
    }

    private void getLockSuffixs(DynamicObject[] bizBillDycs) {
        if (this.isWF()) {
            this.lockKeyFields.add("billid");
            this.lockKeyFields.add("e_billid");
        } else if (ActionEnum.REESTIMATE.getValue().equals(this.actionName)) {
            this.lockKeyFields.add("id");
            this.lockKeyFields.add("e_srcbillid");
        } else if (ActionEnum.FEESHARE_NEW.getValue().equals(this.actionName)) {
            this.lockKeyFields.add("org");
            this.lockKeyFields.add("billid");
        } else if (ActionEnum.MATERIALWRITEOFF.getValue().equals(this.actionName)) {
            this.lockKeyFields.add("billid");
        } else {
            this.lockKeyFields.add("id");
        }
        for (DynamicObject billDyc : bizBillDycs) {
            for (String lockKeyField : this.lockKeyFields) {
                Set<String> lockKeyByFields = this.getLockKeysByLockField(billDyc, lockKeyField);
                this.lockKeys.addAll(lockKeyByFields);
            }
        }
        this.getGroupBillIdLockKeys(bizBillDycs);
    }

    public List<ErrorMsg> lock() {
        List<ErrorMsg> errorMsgs = new ArrayList<ErrorMsg>(16);
        if (!lockOps.contains(this.actionName)) {
            return errorMsgs;
        }
        if (this.noLock) {
            return errorMsgs;
        }
        this.batchLock.lock();
        Map lockFailIdMsgMap = this.batchLock.getLockFailIdMsgMap();
        errorMsgs = this.recordErrorMsg(lockFailIdMsgMap);
        return errorMsgs;
    }

    private void init() {
        boolean noRetry = false;
        String noRetryStr = (String)this.syncParams.get("noretry");
        if (noRetryStr != null && noRetryStr.equals("TRUE")) {
            noRetry = true;
        }
        boolean noLock = false;
        this.setNoRetry(noRetry);
        String noLockStr = (String)this.syncParams.get("nolock");
        if (noLockStr != null && noLockStr.equals("TRUE")) {
            noLock = true;
        }
        this.setNoLock(noLock);
    }

    private void setNoLock(boolean noLock) {
        this.noLock = noLock;
    }

    @Override
    public void close() {
        if (this.batchLock != null) {
            this.batchLock.unlock();
            this.addQueue();
        }
    }

    public DynamicObject[] getBizBillDycs() {
        return this.bizBillDycs;
    }

    private void addQueue() {
        if (this.noRetry || this.errorBizBillDycs == null || this.errorBizBillDycs.isEmpty()) {
            return;
        }
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBizService", (String)"doService", (Object[])new Object[]{this.actionName, this.syncParams, this.errorBizBillDycs.toArray(new DynamicObject[0])});
    }

    public void setNoRetry(boolean noRetry) {
        this.noRetry = noRetry;
    }

    private Set<String> getLockKeysByLockField(DynamicObject billDyc, String lockKeyField) {
        HashSet<String> lockKeyByFields = new HashSet<String>(16);
        BillEntityType dataEntityType = (BillEntityType)billDyc.getDataEntityType();
        IDataEntityProperty lockKeyFieldProp = dataEntityType.findProperty(lockKeyField);
        if (lockKeyFieldProp == null) {
            return lockKeyByFields;
        }
        IDataEntityType parent = lockKeyFieldProp.getParent();
        IDataEntityProperty assBillTypeProp = dataEntityType.findProperty("e_billtype");
        if (parent instanceof EntryType) {
            for (DynamicObject entry : billDyc.getDynamicObjectCollection(parent.getName())) {
                boolean isAdjust;
                String assBillType;
                if (this.isWF() && assBillTypeProp != null && ("ap_finapbill".equals(assBillType = entry.getString("e_billtype")) || "ar_finarbill".equals(assBillType) || "ar_revcfmbill".equals(assBillType)) || ActionEnum.REESTIMATE.getValue().equals(this.actionName) && !(isAdjust = billDyc.getBoolean("isadjust"))) continue;
                lockKeyByFields.add(entry.getString(lockKeyField));
            }
        } else {
            lockKeyByFields.add(billDyc.getString(lockKeyField));
        }
        return lockKeyByFields;
    }

    private List<ErrorMsg> recordErrorMsg(Map<Object, String> lockFailIdMsgMap) {
        ArrayList<ErrorMsg> errorMsgs = new ArrayList<ErrorMsg>(16);
        if (lockFailIdMsgMap.isEmpty()) {
            return errorMsgs;
        }
        ArrayList<DynamicObject> sucessBizBillDycs = new ArrayList<DynamicObject>(16);
        for (DynamicObject billDyc : this.bizBillDycs) {
            HashSet<String> lockFailKeys = new HashSet<String>(16);
            for (String lockKeyField : this.lockKeyFields) {
                Set<String> curLockFailKeys = this.getLockKeysByLockField(billDyc, lockKeyField);
                curLockFailKeys.retainAll(lockFailIdMsgMap.keySet());
                lockFailKeys.addAll(curLockFailKeys);
            }
            if (lockFailKeys.size() > 0) {
                this.errorBizBillDycs.add(billDyc);
                ErrorMsg error = new ErrorMsg();
                StringBuilder sb = new StringBuilder();
                for (String failKey : lockFailKeys) {
                    String billNo = this.billIdBillNoMap.get(failKey);
                    if (StringUtils.isNotEmpty((String)billNo)) {
                        sb.append(billNo);
                        sb.append("\uff1a");
                    }
                    sb.append(lockFailIdMsgMap.get(failKey));
                    sb.append("\r\n");
                }
                if (sb.length() > 0) {
                    sb.delete(sb.length() - 2, sb.length());
                }
                error.setErrorMsg(sb.toString());
                error.setErrorType("2");
                if (this.noRetry) {
                    error.setErrorType("3");
                }
                error.setId(billDyc.getLong("id"));
                errorMsgs.add(error);
                continue;
            }
            sucessBizBillDycs.add(billDyc);
        }
        this.bizBillDycs = sucessBizBillDycs.toArray(new DynamicObject[0]);
        return errorMsgs;
    }

    private void setBillIdBillNoMap() {
        if (this.isWF()) {
            for (DynamicObject billDyc : this.bizBillDycs) {
                this.billIdBillNoMap.put(billDyc.getString("billid"), billDyc.getString("billno"));
                BillEntityType dataEntityType = (BillEntityType)billDyc.getDataEntityType();
                IDataEntityProperty eBillIdProp = dataEntityType.findProperty("e_billid");
                IDataEntityProperty eBillNoProp = dataEntityType.findProperty("e_billno");
                if (eBillIdProp == null || eBillNoProp == null) continue;
                for (DynamicObject entryDyc : billDyc.getDynamicObjectCollection("entry")) {
                    this.billIdBillNoMap.put(entryDyc.getString("e_billid"), entryDyc.getString("e_billno"));
                }
            }
        }
    }

    private boolean isWF() {
        boolean purWf = this.actionName.equals(ActionEnum.PUR_WRITEOFF.getValue()) || this.actionName.equals(ActionEnum.PUR_UN_WRITEOFF.getValue());
        boolean salWf = this.actionName.equals(ActionEnum.SALE_WRITEOFF.getValue()) || this.actionName.equals(ActionEnum.SALE_UN_WRITEOFF.getValue());
        boolean isWF = purWf || salWf;
        return isWF;
    }

    public void setSyncParams(Map params) {
        if (params != null) {
            this.syncParams = params;
        }
        this.init();
    }

    private void getGroupBillIdLockKeys(DynamicObject[] bizBillDycs) {
        boolean isAuditUnAudit;
        boolean bl = isAuditUnAudit = ActionEnum.AUDIT.getValue().equals(this.actionName) || ActionEnum.UN_AUDIT.getValue().equals(this.actionName) || ActionEnum.RESYNC.getValue().equals(this.actionName);
        if (!isAuditUnAudit) {
            return;
        }
        if (!AcctGroupModelHelper.isBizGroupModel()) {
            return;
        }
        Boolean lockGroupBill = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.SYNC_LOCK_GROUP_BILL);
        if (!lockGroupBill.booleanValue()) {
            return;
        }
        String entity = bizBillDycs[0].getDataEntityType().getName();
        HashMap<String, Set<Long>> form2BizbillIdMap = new HashMap<String, Set<Long>>(16);
        for (DynamicObject bizBillDyc : bizBillDycs) {
            Set billIds = form2BizbillIdMap.computeIfAbsent(entity, k -> new HashSet(16));
            billIds.add(bizBillDyc.getLong("id"));
        }
        DataSet groupDs = new BizGroupRecordBuilder().getAllGroupRecordDataSetByBizBillIds(form2BizbillIdMap);
        for (Row row : groupDs) {
            Long bizBillId = row.getLong("bizbillid");
            if (bizBillId == null || bizBillId == 0L) continue;
            this.lockKeys.add(bizBillId.toString());
        }
    }

    static {
        lockOps.add(ActionEnum.SUBMIT.getValue());
        lockOps.add(ActionEnum.UN_SUBMIT.getValue());
        lockOps.add(ActionEnum.AUDIT.getValue());
        lockOps.add(ActionEnum.UN_AUDIT.getValue());
        lockOps.add(ActionEnum.PUR_WRITEOFF.getValue());
        lockOps.add(ActionEnum.PUR_UN_WRITEOFF.getValue());
        lockOps.add(ActionEnum.SALE_WRITEOFF.getValue());
        lockOps.add(ActionEnum.SALE_UN_WRITEOFF.getValue());
        lockOps.add(ActionEnum.RESYNC.getValue());
        lockOps.add(ActionEnum.AUTORESYNC.getValue());
        lockOps.add(ActionEnum.MATERIALWRITEOFF.getValue());
        lockOps.add(ActionEnum.REESTIMATE.getValue());
    }
}

