/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.sharemodel;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.cal.business.sharemodel.IStandardAmtExchange;

public abstract class AbstractStandardAmtExchange
implements IStandardAmtExchange {
    private Map<String, BigDecimal> exchangeratemap;
    private Map<String, Map<String, Object>> exchangeratemap4Source;
    private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");

    public AbstractStandardAmtExchange() {
        this.exchangeratemap = new HashMap<String, BigDecimal>(16);
        this.exchangeratemap4Source = new HashMap<String, Map<String, Object>>(16);
    }

    @Override
    public BigDecimal exchangeToStandardAmt(BigDecimal sourceamt, DynamicObject sourcecurrency, Date bizdate) {
        BigDecimal exchangerate = this.getExchangeRate(sourcecurrency, bizdate);
        if (exchangerate == null) {
            String msg = String.format(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u4e2d\u4e0d\u5b58\u5728\u201c%1$s\u201d\u5230\u201c%2$s\u201d\u7684\u6c47\u7387\u3002", (String)"AbstractStandardAmtExchange_3", (String)"fi-cal-business", (Object[])new Object[0]), sourcecurrency.getString("name"), this.getStandardCurrency().getString("name"));
            throw new KDBizException(msg);
        }
        BigDecimal standardamt = null;
        int amtprecision = this.getStandardAmtPrecision();
        boolean isIndirect = BaseDataServiceHelper.getRateConversionConfig((Long)sourcecurrency.getLong("id"), (Long)this.getStandardCurrency().getLong("id"), (Date)bizdate);
        standardamt = !isIndirect ? sourceamt.multiply(exchangerate).setScale(amtprecision, 4) : sourceamt.divide(exchangerate, amtprecision, 4);
        return standardamt;
    }

    @Override
    public BigDecimal exchangeToSourceAmt(BigDecimal standardamt, DynamicObject sourcecurrency, Date bizdate) {
        Map<String, Object> rateMap = this.getExchangeRate4Source(sourcecurrency, bizdate);
        BigDecimal exchangerate = null;
        if (rateMap != null) {
            exchangerate = (BigDecimal)rateMap.get("exchangeRate");
        }
        if (exchangerate == null) {
            String msg = String.format(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u4e2d\u4e0d\u5b58\u5728\u201c%1$s\u201d\u5230\u201c%2$s\u201d\u7684\u6c47\u7387\u3002", (String)"AbstractStandardAmtExchange_4", (String)"fi-cal-business", (Object[])new Object[0]), this.getStandardCurrency().getString("name"), sourcecurrency.getString("name"));
            throw new KDBizException(msg);
        }
        BigDecimal sourceamt = null;
        int amtprecision = sourcecurrency.getInt("amtprecision");
        boolean isIndirect = (Boolean)rateMap.get("quoteType");
        sourceamt = !isIndirect ? standardamt.multiply(exchangerate).setScale(amtprecision, 4) : standardamt.divide(exchangerate, amtprecision, 4);
        return sourceamt;
    }

    @Override
    public BigDecimal getExchangeRate(DynamicObject sourcecurency, Date bizdate) {
        String key = this.generateMapKey(sourcecurency, bizdate);
        BigDecimal exchangerate = this.exchangeratemap.get(key);
        if (exchangerate == null) {
            if (sourcecurency.getPkValue().equals(this.getStandardCurrency().getPkValue())) {
                exchangerate = BigDecimal.ONE;
            } else {
                boolean isIndirect = BaseDataServiceHelper.getRateConversionConfig((Long)sourcecurency.getLong("id"), (Long)this.getStandardCurrency().getLong("id"), (Date)bizdate);
                exchangerate = BaseDataServiceHelper.getExchangeRateByQuoteType((Long)sourcecurency.getLong("id"), (Long)this.getStandardCurrency().getLong("id"), (Long)((Long)this.getExRateTableID()), (Date)bizdate, (boolean)isIndirect);
                this.exchangeratemap.put(key, exchangerate);
            }
        }
        return exchangerate;
    }

    public Map<String, Object> getExchangeRate4Source(DynamicObject sourcecurency, Date bizdate) {
        String key = this.generateMapKey(sourcecurency, bizdate);
        Map rateMap = this.exchangeratemap4Source.get(key);
        if (rateMap == null) {
            if (sourcecurency.getPkValue().equals(this.getStandardCurrency().getPkValue())) {
                rateMap = new HashMap<String, Object>(2);
                rateMap.put((String)"quoteType", false);
                rateMap.put((String)"exchangeRate", (Object)BigDecimal.ONE);
            } else {
                rateMap = BaseDataServiceHelper.getExchangeRateMap((Long)this.getStandardCurrency().getLong("id"), (Long)sourcecurency.getLong("id"), (Long)((Long)this.getExRateTableID()), (Date)bizdate);
            }
            this.exchangeratemap4Source.put(key, rateMap);
        }
        return rateMap;
    }

    private synchronized String generateMapKey(DynamicObject sourcecurrency, Date bizdate) {
        String sourcecurrencypk = sourcecurrency.getPkValue().toString();
        String date = this.format.format(bizdate);
        return sourcecurrencypk + "_" + date;
    }
}

