/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.sharemodel;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.AmountProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.sharemodel.AmtShareParams;
import kd.fi.cal.business.sharemodel.IStandardAmtExchange;

public class AmtShareModel {
    private static Log log = LogFactory.getLog(AmtShareModel.class);
    private BigDecimal totalstandardamt;
    private BigDecimal totalstandardtaxamt;
    private BigDecimal totalvalue = null;
    private String dividestandard;
    private IDataEntityProperty property;
    private Map<Object, BigDecimal> valuemap;
    private Map<Object, BigDecimal> sharedstandardamtmap;
    private Map<Object, BigDecimal> sharedsourceamtmap;
    private Map<Object, BigDecimal> sharedstandardtaxamtmap;
    private Map<Object, BigDecimal> sharedsourcetaxamtmap;
    private Boolean isamtstandard = null;
    private String billcurrencyfield = null;
    private int sharedcount = 0;
    private BigDecimal sharedstandardamt = BigDecimal.ZERO;
    private BigDecimal sharedstandardtaxamt = BigDecimal.ZERO;
    private int count = 0;
    private IStandardAmtExchange exchange;
    private Date bizdate;
    private Boolean isInterCostAmt = Boolean.FALSE;

    public AmtShareModel(AmtShareParams params) {
        this.dividestandard = params.getDividestandard();
        this.valuemap = new HashMap<Object, BigDecimal>();
        this.sharedstandardamtmap = new HashMap<Object, BigDecimal>();
        this.sharedsourceamtmap = new HashMap<Object, BigDecimal>();
        this.sharedstandardtaxamtmap = new HashMap<Object, BigDecimal>();
        this.sharedsourcetaxamtmap = new HashMap<Object, BigDecimal>();
        Collection<DynamicObject> sharebills = params.getSharebills();
        this.count = sharebills.size();
        this.exchange = params.getExchange();
        this.bizdate = params.getBizdate();
        for (DynamicObject o : sharebills) {
            this.addDividedBill(o);
        }
        this.isInterCostAmt = params.getIsInterCostAmt();
        this.totalstandardamt = params.getTotalstandardamt();
        this.totalstandardtaxamt = params.getTotalstandardtaxamt();
    }

    private BigDecimal getTotalValue() {
        if (this.totalvalue == null) {
            this.totalvalue = BigDecimal.ZERO;
            for (BigDecimal value : this.valuemap.values()) {
                this.totalvalue = this.totalvalue.add(value);
            }
        }
        if (this.totalvalue.compareTo(BigDecimal.ZERO) == 0) {
            String msg = String.format(ResManager.loadKDString((String)"\u5206\u644a\u6807\u51c6\u201c%1$s\u201d\u4e4b\u548c\u4e3a0\u65e0\u6cd5\u8fdb\u884c\u5206\u644a\u3002", (String)"AmtShareModel_3", (String)"fi-cal-business", (Object[])new Object[0]), this.property.getDisplayName().getLocaleValue());
            throw new KDBizException(msg);
        }
        return this.totalvalue;
    }

    private void addDividedBill(DynamicObject bill) {
        if (this.isamtstandard == null) {
            this.property = (IDataEntityProperty)((EntityType)MetadataServiceHelper.getDataEntityType((String)"cal_costrecord_subentity").getAllEntities().get("entry")).getProperties().get((Object)this.dividestandard);
            this.isamtstandard = this.property instanceof AmountProp;
            if (this.isamtstandard.booleanValue()) {
                AmountProp amtprop = (AmountProp)this.property;
                this.billcurrencyfield = amtprop.getControlPropName();
                if (StringUtils.isEmpty((String)this.billcurrencyfield)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5206\u644a\u6807\u51c6\u4e3a\u91d1\u989d\u5b57\u6bb5\u4e14\u6ca1\u6709\u7ed1\u5b9a\u5bf9\u5e94\u5e01\u79cd\uff0c\u65e0\u6cd5\u8fdb\u884c\u91d1\u989d\u6362\u7b97\u3002", (String)"AmtShareModel_2", (String)"fi-cal-business", (Object[])new Object[0]));
                }
            }
        }
        BigDecimal dividevalue = null;
        Object divideValueObj = bill.get(this.dividestandard);
        dividevalue = divideValueObj instanceof Long ? BigDecimal.valueOf((Long)divideValueObj) : (divideValueObj instanceof Integer ? BigDecimal.valueOf(((Integer)divideValueObj).intValue()) : (BigDecimal)divideValueObj);
        dividevalue = dividevalue.abs();
        if (this.isamtstandard.booleanValue()) {
            dividevalue = this.exchange.exchangeToStandardAmt(dividevalue, this.getBillCurrency(bill, this.billcurrencyfield), this.bizdate);
        }
        Object billid = bill.getPkValue();
        this.valuemap.put(billid, dividevalue);
    }

    private DynamicObject getBillCurrency(DynamicObject bill, String billcurrencyfield) {
        DynamicObject billCurrency;
        block5: {
            billCurrency = null;
            try {
                billCurrency = bill.getDynamicObject(billcurrencyfield);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                DynamicObject recordHead = null;
                if (bill.getDynamicObjectType() instanceof EntryType) {
                    recordHead = (DynamicObject)bill.getParent();
                } else if (bill.getDynamicObjectType() instanceof BasedataEntityType) {
                    recordHead = bill.getDynamicObject("parent");
                }
                if (recordHead == null) break block5;
                billCurrency = recordHead.getDynamicObject(billcurrencyfield);
            }
        }
        return billCurrency;
    }

    public Boolean isAmtstandard() {
        return this.isamtstandard;
    }

    public Boolean isInterCostAmt() {
        return this.isInterCostAmt;
    }

    public BigDecimal getSharedStandardAmt(Object billid) {
        BigDecimal standardamt = this.sharedstandardamtmap.get(billid);
        if (standardamt == null) {
            if (this.sharedcount == this.count - 1) {
                standardamt = this.totalstandardamt.subtract(this.sharedstandardamt);
            } else {
                BigDecimal dividevalue = this.valuemap.get(billid);
                BigDecimal totalvalue = this.getTotalValue();
                standardamt = this.totalstandardamt.multiply(dividevalue).divide(totalvalue, this.exchange.getStandardAmtPrecision(), RoundingMode.HALF_UP);
            }
            this.sharedstandardamtmap.put(billid, standardamt);
            this.sharedstandardamt = this.sharedstandardamt.add(standardamt);
        }
        return standardamt;
    }

    public BigDecimal getSharedBillAmt(Object billid, DynamicObject sourcecurrency) {
        BigDecimal sharedsourceamt = this.sharedsourceamtmap.get(billid);
        if (sharedsourceamt == null) {
            BigDecimal sharedstandardamt = this.getSharedStandardAmt(billid);
            sharedsourceamt = this.exchange.exchangeToSourceAmt(sharedstandardamt, sourcecurrency, this.bizdate);
            this.sharedsourceamtmap.put(billid, sharedsourceamt);
        }
        return sharedsourceamt;
    }

    public BigDecimal getSharedStandardTaxAmt(Object billid) {
        BigDecimal standardtaxamt = this.sharedstandardtaxamtmap.get(billid);
        if (standardtaxamt == null) {
            if (this.sharedcount == this.count - 1) {
                standardtaxamt = this.totalstandardtaxamt.subtract(this.sharedstandardtaxamt);
            } else {
                BigDecimal dividevalue = this.valuemap.get(billid);
                BigDecimal totalvalue = this.getTotalValue();
                standardtaxamt = this.totalstandardtaxamt.multiply(dividevalue).divide(totalvalue, this.exchange.getStandardAmtPrecision(), RoundingMode.HALF_UP);
            }
            this.sharedstandardtaxamtmap.put(billid, standardtaxamt);
            this.sharedstandardtaxamt = this.sharedstandardtaxamt.add(standardtaxamt);
            ++this.sharedcount;
        }
        return standardtaxamt;
    }

    public BigDecimal getSharedBillTaxAmt(Object billid, DynamicObject sourcecurrency) {
        BigDecimal sharedsourcetaxamt = this.sharedsourcetaxamtmap.get(billid);
        if (sharedsourcetaxamt == null) {
            BigDecimal sharedstandardtax = this.getSharedStandardTaxAmt(billid);
            sharedsourcetaxamt = this.exchange.exchangeToSourceAmt(sharedstandardtax, sourcecurrency, this.bizdate);
            this.sharedsourcetaxamtmap.put(billid, sharedsourcetaxamt);
        }
        return sharedsourcetaxamt;
    }

    public BigDecimal getTotalStandardAmt() {
        return this.totalstandardamt;
    }

    public BigDecimal getTotalStandardTaxAmt() {
        return this.totalstandardtaxamt;
    }

    public Set<Object> getBillIds() {
        return this.valuemap.keySet();
    }
}

