/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.sharemodel;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.cal.business.sharemodel.AmtShareModel;
import kd.fi.cal.business.sharemodel.AmtShareParams;
import kd.fi.cal.business.sharemodel.IStandardAmtExchange;
import kd.fi.cal.business.sharemodel.StandardAmtExchange;
import kd.fi.cal.common.helper.CommonSettingHelper;
import org.apache.commons.lang.StringUtils;

public class AutoCostEstimateHandler {
    private boolean isAutoEst = false;
    private String standard = "";
    private DynamicObject estBillDyc;
    private DynamicObject busBill;
    private static final String STANDARDCURRENCY = "standardcurrency";
    private static final String EXRATETABLE = "exratetable";
    private static final String CURRENCY = "currency";
    private static final String ESTIMATEDATE = "estimatedate";
    private static final String EXPENSEENTITY = "expenseentity";
    private static final String ESTIMATESTANDARD = "estimatestandard";
    private static final String AMOUNT = "amount";
    private static final String TAXAMOUNT = "taxamount";
    private static final String EXPENSECURRENCY = "expensecurrency";
    private static final String EXPENSEITEM = "expenseitem";
    private static final String RATE = "rate";
    private static final String ESTIMATEAMOUNT = "estimateamount";
    private static final String ESTIMATETAXAMOUNT = "estimatetaxamount";
    private static final String ASSTACTYPE = "asstacttype";
    private static final String ASSTACT = "asstact";
    private static final String ENTRYBARAP = "entrybarap";
    private static final String RESULTENTITY = "resultentity";
    private static final String PREFIX_EXITEMGROUP = "exitemgroup";
    private static final String PREFIX_SHAREAMT = "preshareamt";
    private static final String PREFIX_SHARETAXAMT = "presharetaxamt";
    private static final String PREFIX_SHAREAMOUNT = "preshareamount";
    private static final String PREFIX_SHARETAXAMOUNT = "presharetaxamount";
    private static final String COSTDETAIL = "costdetail";
    private static final String CALENTRYID = "calentryid";
    private static final String SHAREAMT = "shareamt";
    private static final String SHAREAMOUNT = "shareamount";
    private static final String SHARETAXAMT = "sharetaxamt";
    private static final String SHARETAXAMOUNT = "sharetaxamount";
    private static final String SUBRESULTENTITY = "subresultentity";
    private static final String EXITEMSEQ = "exitemseq";
    private static final String SHAREDETAILAMT = "sharedetailamt";
    private static final String SHAREDETAILTAXAMT = "sharedetailtaxamt";
    private static final String SHAREDETAILAMOUNT = "sharedetailamount";
    private static final String SHAREDETAILTAXAMOUNT = "sharedetailtaxamount";
    private static final String SHAREDETAILEXITEM = "sharedetailexitem";
    private static final String SHAREDETAILATYPE = "sharedetailatype";
    private static final String SHAREDETAILASSTAT = "sharedetailasstact";

    public AutoCostEstimateHandler(DynamicObject busBill, DynamicObject billDyc) {
        this.busBill = busBill;
        this.estBillDyc = billDyc;
    }

    public void handle() {
        DynamicObject setting = CommonSettingHelper.getSettingObj();
        this.isAutoEst = setting.getBoolean("autoestimate");
        if (!this.isAutoEst) {
            return;
        }
        this.standard = setting.getString("autoesstandard");
        DynamicObjectCollection feeInfoDycs = this.estBillDyc.getDynamicObjectCollection(EXPENSEENTITY);
        for (DynamicObject feeInfoDyc : feeInfoDycs) {
            feeInfoDyc.set(ESTIMATESTANDARD, (Object)this.standard);
        }
        Object[] detailids = this.getDetailIDs();
        IStandardAmtExchange exchange = this.getIExchange();
        Map<DynamicObject, List<DynamicObject>> feeItemCostRecordMap = this.getExpenseToCostdetailsRelations(detailids);
        this.shareExpense(feeItemCostRecordMap, exchange);
        this.execEstimate();
    }

    private IStandardAmtExchange getIExchange() {
        DynamicObject stdCurrencyDyc = this.estBillDyc.getDynamicObject(STANDARDCURRENCY);
        DynamicObject extableDyc = this.estBillDyc.getDynamicObject(EXRATETABLE);
        return new StandardAmtExchange(stdCurrencyDyc, extableDyc.getLong("id"), "1");
    }

    private Object[] getDetailIDs() {
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        HashSet<String> bizBillNos = new HashSet<String>(16);
        String entity = "im_purinbill";
        QFilter busBillIdf = new QFilter("id", "=", this.busBill.getPkValue());
        try (DataSet busBillDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"ap_busbill", (String)"sourcebillid,sourcebilltype,sourcebillno", (QFilter[])new QFilter[]{busBillIdf}, null);){
            for (Row row : busBillDs) {
                Long sourceBillId;
                if (StringUtils.isNotBlank((String)row.getString("sourcebillid")) && !(sourceBillId = row.getLong("sourcebillid")).equals(0L)) {
                    bizBillIds.add(sourceBillId);
                }
                bizBillNos.add(row.getString("sourcebillno"));
                if (!StringUtils.isNotBlank((String)row.getString("sourcebilltype"))) continue;
                entity = row.getString("sourcebilltype");
            }
        }
        HashSet<Object> costRecordEntryIds = new HashSet<Object>(16);
        QFilter bizBillNoOrIdf = new QFilter("billnumber", "in", bizBillNos);
        if (bizBillIds.size() > 1) {
            bizBillNoOrIdf = new QFilter("bizbillid", "in", bizBillIds);
        }
        ArrayList<QFilter> costfs = new ArrayList<QFilter>(16);
        costfs.add(bizBillNoOrIdf);
        QFilter srcBillTypef = new QFilter("bizentityobject.number", "=", (Object)entity);
        QFilter isMianAcctf = new QFilter("costaccount.ismainaccount", "=", (Object)Boolean.TRUE);
        costfs.add(srcBillTypef);
        costfs.add(isMianAcctf);
        costfs.add(new QFilter("issplitcreate", "=", (Object)Boolean.FALSE));
        costfs.add(new QFilter("entry.ownertype", "=", (Object)"bos_org"));
        costfs.add(new QFilter("entry.ispresent", "=", (Object)Boolean.FALSE));
        QFilter billStatus = new QFilter("billstatus", "=", (Object)"C");
        costfs.add(billStatus);
        try (DataSet costRecordDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"entry.id as entryid", (QFilter[])costfs.toArray(new QFilter[0]), null);){
            for (Row row : costRecordDs) {
                costRecordEntryIds.add(row.get("entryid"));
            }
        }
        if (costRecordEntryIds.size() < 1) {
            String billNo = "";
            if (bizBillNos.size() > 0) {
                billNo = String.join((CharSequence)"\u3001", bizBillNos);
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55%1$s\uff0c\u81ea\u52a8\u6682\u4f30\u5931\u8d25\u3002", (String)"AutoCostEstimateHandler_1", (String)"fi-cal-business", (Object[])new Object[0]), billNo));
        }
        return costRecordEntryIds.toArray(new Object[0]);
    }

    private Map<DynamicObject, List<DynamicObject>> getExpenseToCostdetailsRelations(Object[] detailids) {
        HashMap<DynamicObject, List<DynamicObject>> feeItemCostRecordMap = new HashMap<DynamicObject, List<DynamicObject>>(16);
        Collection<DynamicObject> details = this.getCostDetailCollection(new QFilter("id", "in", (Object)detailids).toArray());
        for (DynamicObject expense : this.estBillDyc.getDynamicObjectCollection(EXPENSEENTITY)) {
            feeItemCostRecordMap.put(expense, new ArrayList<DynamicObject>(details));
        }
        return feeItemCostRecordMap;
    }

    protected Collection<DynamicObject> getCostDetailCollection(QFilter[] filters) {
        Map detailmap = BusinessDataServiceHelper.loadFromCache((String)"cal_costdetail", (QFilter[])filters);
        Collection<DynamicObject> col = detailmap.values();
        for (DynamicObject detail : col) {
            detail.set(CURRENCY, (Object)detail.getDynamicObject("parent").getDynamicObject("localcurrency"));
        }
        return col;
    }

    protected void shareExpense(Map<DynamicObject, List<DynamicObject>> relationmap, IStandardAmtExchange exchange) {
        List<DynamicObject> costdetails = null;
        Date bizdate = this.estBillDyc.getDate(ESTIMATEDATE);
        HashMap<Object, DynamicObject> costEntryIdResultMap = new HashMap<Object, DynamicObject>(16);
        for (Map.Entry<DynamicObject, List<DynamicObject>> entry : relationmap.entrySet()) {
            DynamicObject expense = entry.getKey();
            costdetails = entry.getValue();
            String dividestandard = expense.getString(ESTIMATESTANDARD);
            BigDecimal expenseamount = expense.getBigDecimal(ESTIMATEAMOUNT);
            BigDecimal expensetax = expense.getBigDecimal(ESTIMATETAXAMOUNT);
            DynamicObject expensecurrency = expense.getDynamicObject(EXPENSECURRENCY);
            DynamicObject expenseitem = expense.getDynamicObject(EXPENSEITEM);
            String asstActype = expense.getString(ASSTACTYPE);
            DynamicObject asstact = expense.getDynamicObject(ASSTACT);
            AmtShareParams param = new AmtShareParams();
            param.setBizdate(bizdate);
            param.setDividestandard(dividestandard);
            param.setExchange(exchange);
            param.setSourcecurrency(expensecurrency);
            param.setSharebills(costdetails);
            param.setTotalstandardamt(expenseamount);
            param.setTotalstandardtaxamt(expensetax);
            AmtShareModel sharemodel = new AmtShareModel(param);
            int seq = expense.getInt("seq");
            for (DynamicObject costdetail : costdetails) {
                if (!costEntryIdResultMap.containsKey(costdetail.getPkValue())) {
                    costEntryIdResultMap.put(costdetail.getPkValue(), this.estBillDyc.getDynamicObjectCollection(RESULTENTITY).addNew());
                }
                DynamicObject estResultDyc = (DynamicObject)costEntryIdResultMap.get(costdetail.getPkValue());
                estResultDyc.set(COSTDETAIL, (Object)costdetail);
                estResultDyc.set(CURRENCY, costdetail.getDynamicObject(CURRENCY).getPkValue());
                estResultDyc.set(CALENTRYID, (Object)costdetail.getLong(CALENTRYID));
                DynamicObjectCollection subResultDycs = estResultDyc.getDynamicObjectCollection(SUBRESULTENTITY);
                DynamicObject newSubResultDyc = subResultDycs.addNew();
                newSubResultDyc.set(SHAREDETAILEXITEM, (Object)expenseitem);
                BigDecimal sharedetailamt = sharemodel.getSharedBillAmt(costdetail.getPkValue(), costdetail.getDynamicObject(CURRENCY));
                BigDecimal sharedetailamount = sharemodel.getSharedStandardAmt(costdetail.getPkValue());
                BigDecimal sharedetailtax = sharemodel.getSharedBillTaxAmt(costdetail.getPkValue(), costdetail.getDynamicObject(CURRENCY));
                BigDecimal sharedetailtaxamt = sharemodel.getSharedStandardTaxAmt(costdetail.getPkValue());
                newSubResultDyc.set(SHAREDETAILAMT, (Object)sharedetailamt);
                newSubResultDyc.set(SHAREDETAILTAXAMT, (Object)sharedetailtax);
                newSubResultDyc.set(SHAREDETAILAMOUNT, (Object)sharedetailamount);
                newSubResultDyc.set(SHAREDETAILTAXAMOUNT, (Object)sharedetailtaxamt);
                newSubResultDyc.set(EXITEMSEQ, (Object)seq);
                newSubResultDyc.set(SHAREDETAILATYPE, (Object)asstActype);
                newSubResultDyc.set(SHAREDETAILASSTAT, (Object)asstact);
                estResultDyc.set(PREFIX_SHAREAMT + seq, (Object)sharedetailamt);
                estResultDyc.set(PREFIX_SHARETAXAMT + seq, (Object)sharedetailtax);
                estResultDyc.set(PREFIX_SHAREAMOUNT + seq, (Object)sharedetailamount);
                estResultDyc.set(PREFIX_SHARETAXAMOUNT + seq, (Object)sharedetailtaxamt);
                estResultDyc.set(SHAREAMT, (Object)estResultDyc.getBigDecimal(SHAREAMT).add(newSubResultDyc.getBigDecimal(SHAREDETAILAMT)));
                estResultDyc.set(SHAREAMOUNT, (Object)estResultDyc.getBigDecimal(SHAREAMOUNT).add(newSubResultDyc.getBigDecimal(SHAREDETAILAMOUNT)));
                estResultDyc.set(SHARETAXAMT, (Object)estResultDyc.getBigDecimal(SHARETAXAMT).add(newSubResultDyc.getBigDecimal(SHAREDETAILTAXAMT)));
                estResultDyc.set(SHARETAXAMOUNT, (Object)estResultDyc.getBigDecimal(SHARETAXAMOUNT).add(newSubResultDyc.getBigDecimal(SHAREDETAILTAXAMOUNT)));
            }
        }
    }

    private void execEstimate() {
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"submit", (String)"cal_costestimatebill", (DynamicObject[])new DynamicObject[]{this.estBillDyc}, null);
        if (!opResult.isSuccess()) {
            StringBuilder errorInfo = new StringBuilder();
            errorInfo.append(opResult.getMessage());
            errorInfo.append("\r\n");
            for (IOperateInfo info : opResult.getAllErrorOrValidateInfo()) {
                errorInfo.append(info.getMessage());
            }
            throw new KDBizException(errorInfo.toString());
        }
    }
}

