/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.IDGenerator;
import kd.fi.cal.common.helper.StopSyncSettingModifyHelper;
import kd.fi.cal.common.helper.WriteLogHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.DynamicObjectUtils;

public class CalSubElementUpdateTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(CalSubElementUpdateTask.class);
    private String insertBalSpSql = "insert into t_cal_snapshootbalance(fid,fmainid,fheadid,funitid,fqty,fstandardcost,factualcost) values(?,?,?,?,?,?,?)";
    private String insertCostRecordDetailSql = "insert into t_cal_costrecord_detail(fdetailid,fentryid,fcostelementid,fcostsubelementid,fmaterialid,fbaseunitid,fbaseqty,funitstandardcost,fstandardcost,funitactualcost,factualcost,fcurrencyid) values(?,?,?,?,?,?,?,?,?,?,?,?)";
    private String insertCostAdjustDetailSql = "insert into t_cal_costadjust_detail(fdetailid,fentryid,fcostelementid,fcostsubelementid,fmaterialid,fadjustamt,fcurrencyid) values(?,?,?,?,?,?,?)";
    private String insertInitCalDetailSql = "insert into t_cal_initbill_detail(fdetailid,fentryid,fcostelementid,fcostsubelementid,fmaterialid,fbaseunitid,fbaseqty,funitprice,famount,fcostdiff,fsubyearinqty,fsubyearincost,fsubyearincostdiff,fsubyearissueqty,fsubyearissuecost,fsubyearissuecostdiff) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private String insertBalanceDetailSql = "insert into t_cal_balance_detail(fdetailid,fid,fcostelementid,fcostsubelementid,fperiodbeginqty,fbeginstandardcost,fperiodbegincostdiff,fperiodbeginactualcost,fperiodinqty,fperiodinstandardcost,fperiodincostdiff,fperiodinactualcost,fperiodissueqty,fperiodissuestandardcost,fperiodissuecostdiff,fperiodissueactualcost,fperiodendqty,fperiodendstandardcost,fperiodendcostdiff,fperiodendactualcost,fyearinqty,fyearinstandradcost,fyearincostdiff,fyearinactualcost,fyearissueqty,fyearissuestandradcost,fyearissuecostdiff,fyearissueactualcost) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private String insertDiffBalDetailSql = "insert into t_cal_purdiff_detail(fid,fbalid,fcostelementid,fcostsubelementid) values(?,?,?,?)";
    private String updateStdCostDiffSql = "update t_cal_stdcostdiffentry set fsubentryentity = ? where fentryid = ?";
    private boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
    private static final String lockKey = "lock_calelementupdate";
    private int batchNum = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.COMMON_SPLITBATCHNUM);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(RequestContext ctx, Map<String, Object> paramMap) throws KDException {
        MessageInfo msgInfo = new MessageInfo();
        ArrayList<Long> userList = new ArrayList<Long>();
        userList.add(RequestContext.get().getCurrUserId());
        msgInfo.setUserIds(userList);
        msgInfo.setNotifyType(MessageChannels.MC.getNumber());
        String content = ResManager.loadKDString((String)"\u5b50\u8981\u7d20\u540c\u6b65\u6267\u884c\u6210\u529f\u3002", (String)"CalSubElementUpdateTask_0", (String)"fi-cal-business", (Object[])new Object[0]);
        msgInfo.setContent(content);
        String bizTag = ResManager.loadKDString((String)"\u5b50\u8981\u7d20\u540c\u6b65\u4efb\u52a1", (String)"CalSubElementUpdateTask_1", (String)"fi-cal-business", (Object[])new Object[0]);
        msgInfo.setTitle(bizTag);
        msgInfo.setMessageTag((ILocaleString)new LocaleString(bizTag));
        try {
            Throwable throwable;
            DataSet dataSet;
            QFilter q;
            IAppCache appCache = AppCache.get((String)"cal");
            try (DLock dLock = DLock.create((String)(CacheKeyUtil.getAcctId() + lockKey), (String)lockKey);){
                dLock.lock();
                String isUpdate = (String)appCache.get(lockKey, String.class);
                if (isUpdate != null) {
                    msgInfo.setContent(ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u5b50\u8981\u7d20\u540c\u6b65\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"CalSubElementUpdateTask_2", (String)"fi-cal-business", (Object[])new Object[0]));
                    return;
                }
                appCache.put(lockKey, (Object)"1");
            }
            HashMap<Long, Long> elementMap = new HashMap<Long, Long>(16);
            HashSet<Long> costAccountIds = new HashSet<Long>(16);
            HashSet<Long> calOrgIds = new HashSet<Long>(16);
            try {
                q = new QFilter("syncflag", "=", (Object)"0");
                dataSet = QueryServiceHelper.queryDataSet((String)CalSubElementUpdateTask.class.getName(), (String)"cad_subelement", (String)"id", (QFilter[])q.toArray(), null);
                throwable = null;
                try (DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)CalSubElementUpdateTask.class.getName(), (String)"cad_elementdetail", (String)"id,element,subelement", null, null);
                     DataSet joinDataSet = dataSet.join(detailDataSet, JoinType.INNER).on("id", "subelement").select(new String[]{"id as subelement"}, new String[]{"element"}).finish();){
                    for (Row row : joinDataSet) {
                        elementMap.put(row.getLong("subelement"), row.getLong("element"));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dataSet != null) {
                        if (throwable != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            dataSet.close();
                        }
                    }
                }
                if (elementMap.isEmpty()) {
                    msgInfo.setContent(ResManager.loadKDString((String)"\u672a\u53d1\u73b0\u9700\u8981\u540c\u6b65\uff08\u201c\u540c\u6b65\u5b58\u8d27\u4f59\u989d\u8868\u201d\u6807\u8bc6\u4e3a\u201c\u5426\u201d\uff09\u7684\u5b50\u8981\u7d20\u3002", (String)"CalSubElementUpdateTask_3", (String)"fi-cal-business", (Object[])new Object[0]));
                    appCache.remove(lockKey);
                    return;
                }
            }
            catch (Exception e) {
                msgInfo.setContent(CommonUtils.getLogMessage((Throwable)e, (int)1000));
                appCache.remove(lockKey);
                throw e;
            }
            q = new QFilter("calpolicy.calbycostelement", "=", (Object)"1");
            dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_bd_costaccount", (String)"id,calorg", (QFilter[])q.toArray(), null);
            throwable = null;
            try {
                for (Row row : dataSet) {
                    costAccountIds.add(row.getLong("id"));
                    calOrgIds.add(row.getLong("calorg"));
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (dataSet != null) {
                    if (throwable != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
            if (costAccountIds.isEmpty()) {
                this.writeBackSubElement(elementMap);
                appCache.remove(lockKey);
                return;
            }
            q = new QFilter("costaccount", "in", costAccountIds);
            if (this.isNewBalance) {
                q.and("costsubelement", "in", elementMap.keySet());
                if (QueryServiceHelper.exists((String)"cal_bal", (QFilter[])q.toArray())) {
                    this.writeBackSubElement(elementMap);
                    appCache.remove(lockKey);
                    return;
                }
            } else {
                q.and("entryentity.costsubelement", "in", elementMap.keySet());
                if (QueryServiceHelper.exists((String)"cal_balance_subentity", (QFilter[])q.toArray())) {
                    this.writeBackSubElement(elementMap);
                    appCache.remove(lockKey);
                    return;
                }
            }
            try (TXHandle tx = TX.requiresNew();){
                try {
                    new StopSyncSettingModifyHelper().modifySetting(calOrgIds, null, null, null, new HashSet(), true, TimeServiceHelper.now());
                    this.handleInitCalBill(costAccountIds, elementMap);
                    this.handleCostAdjust(costAccountIds, elementMap);
                    this.handleStdCostDiffBill(costAccountIds, elementMap);
                    this.handleCostRecord(costAccountIds, elementMap);
                    this.handleByCopyDynamic(costAccountIds, elementMap, "cal_recentcost", "recentcost", "price");
                    this.handleByCopyDynamic(costAccountIds, elementMap, "cal_balance_fifo", "endcost", "endunitcost");
                    this.handleByCopyDynamic(costAccountIds, elementMap, "cal_balance_fifo_period", "begincost", "beginunitcost", "endcost", "endunitcost");
                    if (!this.isNewBalance) {
                        this.handleBalance(costAccountIds, elementMap);
                        this.handleDiffBalance(costAccountIds, elementMap);
                        this.writeBackSubElement(elementMap);
                        return;
                    }
                    appCache.put("calelementupdate_isend", (Object)"1");
                    return;
                }
                catch (Throwable e) {
                    tx.markRollback();
                    msgInfo.setContent(CommonUtils.getLogMessage((Throwable)e, (int)1000));
                    throw e;
                }
            }
            finally {
                if (!this.isNewBalance) {
                    appCache.remove(lockKey);
                    new StopSyncSettingModifyHelper().modifySetting(calOrgIds, null, null, null, new HashSet(), false, TimeServiceHelper.now());
                }
            }
        }
        finally {
            MessageCenterServiceHelper.sendMessage((MessageInfo)msgInfo);
        }
    }

    private void handleStdCostDiffBill(Set<Long> costAccountIds, Map<Long, Long> elementMap) {
        ArrayList<Object[]> stdCostDiffParamList = new ArrayList<Object[]>(1024);
        QFilter q = new QFilter("costaccount", "in", costAccountIds);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_stdcostdiffbill", (String)"entryentity.id,entryentity.subentryentity_json", (QFilter[])q.toArray(), null);
        Object object = null;
        try {
            for (Row row : dataSet) {
                JSONObject valueJson;
                Long entryId = row.getLong("entryentity.id");
                String json = row.getString("entryentity.subentryentity_json");
                if (StringUtils.isEmpty((CharSequence)json)) continue;
                try {
                    valueJson = JSON.parseObject((String)json);
                }
                catch (Exception e) {
                    logger.error("\u5b58\u5728\u9519\u8bef\u7684\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\uff0c\u5206\u5f55id\uff1a" + entryId);
                    WriteLogHelper.writeErrorLog((Log)logger, (String)"CalSubElementUpdateTask-handleStdCostDiffBill", (Throwable)e);
                    continue;
                }
                JSONArray datas = valueJson.getJSONArray("data");
                if (datas == null || datas.isEmpty()) continue;
                Object[] Indexs = valueJson.getJSONArray("index").toArray();
                Object[] lastJson = datas.getJSONArray(datas.size() - 1).toArray();
                int seqIndex = ArrayUtils.indexOf((Object[])Indexs, (Object)"seq");
                int seq = 0;
                if (seqIndex >= 0 && lastJson[seqIndex] != null) {
                    seq = Integer.parseInt(lastJson[seqIndex].toString());
                }
                Object sub_material = lastJson[ArrayUtils.indexOf((Object[])Indexs, (Object)"sub_material")];
                Object sub_currency = lastJson[ArrayUtils.indexOf((Object[])Indexs, (Object)"sub_currency")];
                for (Map.Entry<Long, Long> entry : elementMap.entrySet()) {
                    Object[] detail = new Object[24];
                    detail[ArrayUtils.indexOf((Object[])Indexs, (Object)"id")] = DBServiceHelper.genLongIds((String)"t_cal_costadjust_detail", (int)1)[0];
                    if (seqIndex >= 0) {
                        detail[ArrayUtils.indexOf((Object[])Indexs, (Object)"seq")] = ++seq;
                    }
                    detail[ArrayUtils.indexOf((Object[])Indexs, (Object)"sub_material")] = sub_material;
                    detail[ArrayUtils.indexOf((Object[])Indexs, (Object)"costelement")] = entry.getValue();
                    detail[ArrayUtils.indexOf((Object[])Indexs, (Object)"costsubelement")] = entry.getKey();
                    detail[ArrayUtils.indexOf((Object[])Indexs, (Object)"sub_currency")] = sub_currency;
                    detail[ArrayUtils.indexOf((Object[])Indexs, (Object)"sub_adjustamt")] = BigDecimal.ZERO;
                    detail[ArrayUtils.indexOf((Object[])Indexs, (Object)"ddiff_g")] = BigDecimal.ZERO;
                    detail[ArrayUtils.indexOf((Object[])Indexs, (Object)"ddiff_h")] = BigDecimal.ZERO;
                    detail[ArrayUtils.indexOf((Object[])Indexs, (Object)"ddiff_k")] = BigDecimal.ZERO;
                    detail[ArrayUtils.indexOf((Object[])Indexs, (Object)"ddiff_p")] = BigDecimal.ZERO;
                    detail[ArrayUtils.indexOf((Object[])Indexs, (Object)"ddiff_q")] = BigDecimal.ZERO;
                    detail[ArrayUtils.indexOf((Object[])Indexs, (Object)"ddiff_r")] = BigDecimal.ZERO;
                    detail[ArrayUtils.indexOf((Object[])Indexs, (Object)"ddiff_m")] = BigDecimal.ZERO;
                    detail[ArrayUtils.indexOf((Object[])Indexs, (Object)"ddiff_s")] = BigDecimal.ZERO;
                    detail[ArrayUtils.indexOf((Object[])Indexs, (Object)"ddiff_t")] = BigDecimal.ZERO;
                    detail[ArrayUtils.indexOf((Object[])Indexs, (Object)"ddiff_c")] = BigDecimal.ZERO;
                    detail[ArrayUtils.indexOf((Object[])Indexs, (Object)"ddiff_x")] = BigDecimal.ZERO;
                    detail[ArrayUtils.indexOf((Object[])Indexs, (Object)"ddiff_w")] = BigDecimal.ZERO;
                    detail[ArrayUtils.indexOf((Object[])Indexs, (Object)"ddiff_y")] = BigDecimal.ZERO;
                    detail[ArrayUtils.indexOf((Object[])Indexs, (Object)"sub_material_id")] = sub_material;
                    detail[ArrayUtils.indexOf((Object[])Indexs, (Object)"costelement_id")] = entry.getValue();
                    detail[ArrayUtils.indexOf((Object[])Indexs, (Object)"costsubelement_id")] = entry.getKey();
                    detail[ArrayUtils.indexOf((Object[])Indexs, (Object)"sub_currency_id")] = sub_currency;
                    datas.add((Object)detail);
                }
                stdCostDiffParamList.add(new Object[]{valueJson.toJSONString(), entryId});
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        if (!stdCostDiffParamList.isEmpty()) {
            List costDetailList = CommonUtils.getSplitList(stdCostDiffParamList);
            for (List list : costDetailList) {
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)this.updateStdCostDiffSql, (List)list);
            }
        }
    }

    private void handleInitCalBill(Set<Long> costAccountIds, Map<Long, Long> elementMap) {
        ArrayList<Object[]> initCalDetailParamList = new ArrayList<Object[]>(1024);
        IDGenerator costDetailIdGen = new IDGenerator("t_cal_initbill_detail");
        QFilter q = new QFilter("costaccount", "in", costAccountIds);
        q.and("entryentity.subentryentity.costsubelement", "=", (Object)773175233367685120L);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_initbill", (String)"entryentity.id,entryentity.subentryentity.costelement,entryentity.subentryentity.costsubelement,entryentity.subentryentity.sub_material,entryentity.subentryentity.sub_baseunit,entryentity.subentryentity.sub_baseqty,entryentity.subentryentity.sub_yearinqty,entryentity.subentryentity.sub_yearissueqty", (QFilter[])q.toArray(), null);
        Object object = null;
        try {
            for (Row row : dataSet) {
                for (Map.Entry<Long, Long> entry : elementMap.entrySet()) {
                    Long detailId = costDetailIdGen.getId();
                    initCalDetailParamList.add(new Object[]{detailId, row.getLong("entryentity.id"), entry.getValue(), entry.getKey(), row.getLong("entryentity.subentryentity.sub_material"), row.getLong("entryentity.subentryentity.sub_baseunit"), row.getLong("entryentity.subentryentity.sub_baseqty"), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, row.getLong("entryentity.subentryentity.sub_yearinqty"), BigDecimal.ZERO, BigDecimal.ZERO, row.getLong("entryentity.subentryentity.sub_yearissueqty"), BigDecimal.ZERO, BigDecimal.ZERO});
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        if (!initCalDetailParamList.isEmpty()) {
            List costDetailList = CommonUtils.getSplitList(initCalDetailParamList);
            for (List list : costDetailList) {
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)this.insertInitCalDetailSql, (List)list);
            }
        }
    }

    private void handleCostAdjust(Set<Long> costAccountIds, Map<Long, Long> elementMap) {
        ArrayList<Object[]> costAdjustDetailParamList = new ArrayList<Object[]>(1024);
        IDGenerator costDetailIdGen = new IDGenerator("t_cal_costadjust_detail");
        QFilter q = new QFilter("costaccount", "in", costAccountIds);
        q.and("entryentity.subentryentity.costsubelement", "=", (Object)773175233367685120L);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costadjust_subentity", (String)"entryentity.id,entryentity.subentryentity.costelement,entryentity.subentryentity.costsubelement,entryentity.subentryentity.sub_material,entryentity.subentryentity.sub_currency", (QFilter[])q.toArray(), null);
        Object object = null;
        try {
            for (Row row : dataSet) {
                for (Map.Entry<Long, Long> entry : elementMap.entrySet()) {
                    Long detailId = costDetailIdGen.getId();
                    costAdjustDetailParamList.add(new Object[]{detailId, row.getLong("entryentity.id"), entry.getValue(), entry.getKey(), row.getLong("entryentity.subentryentity.sub_material"), BigDecimal.ZERO, row.getLong("entryentity.subentryentity.sub_currency")});
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        if (!costAdjustDetailParamList.isEmpty()) {
            List costDetailList = CommonUtils.getSplitList(costAdjustDetailParamList);
            for (List list : costDetailList) {
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)this.insertCostAdjustDetailSql, (List)list);
            }
        }
    }

    private void handleCostRecord(Set<Long> costAccountIds, Map<Long, Long> elementMap) {
        IDGenerator costDetailIdGen = new IDGenerator("t_cal_costrecord_detail");
        IDGenerator balSpIdGen = new IDGenerator("t_cal_snapshootbalance");
        ArrayList<Object[]> costRecordDetailParamList = new ArrayList<Object[]>(1024);
        ArrayList<Object[]> balSpParamList = new ArrayList<Object[]>(1024);
        Set bizTypeIdSet = CommonSettingHelper.getNotUpdBalBizType();
        QFilter q = new QFilter("costaccount", "in", costAccountIds);
        q.and("entry.subentrycostelement.costsubelement", "=", (Object)773175233367685120L);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord_subentity", (String)"id,isinitbill,biztype,issplitcreate,entry.id,entry.subentrycostelement.costelement,entry.subentrycostelement.costsubelement,entry.subentrycostelement.sub_material,entry.subentrycostelement.sub_baseunit,entry.subentrycostelement.sub_baseqty,entry.subentrycostelement.sub_currency", (QFilter[])q.toArray(), null);){
            for (Row row : dataSet) {
                for (Map.Entry<Long, Long> entry : elementMap.entrySet()) {
                    Long detailId = costDetailIdGen.getId();
                    costRecordDetailParamList.add(new Object[]{detailId, row.getLong("entry.id"), entry.getValue(), entry.getKey(), row.getLong("entry.subentrycostelement.sub_material"), row.getLong("entry.subentrycostelement.sub_baseunit"), row.getBigDecimal("entry.subentrycostelement.sub_baseqty"), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, row.getLong("entry.subentrycostelement.sub_currency")});
                    if (costRecordDetailParamList.size() >= this.batchNum) {
                        DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)this.insertCostRecordDetailSql, costRecordDetailParamList);
                        costRecordDetailParamList = new ArrayList(this.batchNum);
                    }
                    if (this.isNewBalance || row.getBoolean("isinitbill").booleanValue() || bizTypeIdSet.contains(row.getLong("biztype")) || row.getBoolean("issplitcreate").booleanValue()) continue;
                    balSpParamList.add(new Object[]{balSpIdGen.getId(), detailId, row.getLong("id"), row.getLong("entry.subentrycostelement.sub_baseunit"), row.getBigDecimal("entry.subentrycostelement.sub_baseqty"), BigDecimal.ZERO, BigDecimal.ZERO});
                    if (balSpParamList.size() < this.batchNum) continue;
                    DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)this.insertBalSpSql, balSpParamList);
                    balSpParamList = new ArrayList(this.batchNum);
                }
            }
        }
        if (!costRecordDetailParamList.isEmpty()) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)this.insertCostRecordDetailSql, costRecordDetailParamList);
        }
        if (!balSpParamList.isEmpty()) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)this.insertBalSpSql, balSpParamList);
        }
    }

    private void handleByCopyDynamic(Set<Long> costAccountIds, Map<Long, Long> elementMap, String entityName, String ... zeroDecimalFields) {
        DynamicObject[] infos;
        HashSet<DynamicObject> saveInfos = new HashSet<DynamicObject>(1024);
        QFilter q = new QFilter("costaccount", "in", costAccountIds);
        q.and("costsubelement", "=", (Object)773175233367685120L);
        for (DynamicObject info : infos = BusinessDataServiceHelper.load((String)entityName, (String)CommonUtils.getAllFields((String)entityName), (QFilter[])q.toArray(), null)) {
            for (Map.Entry<Long, Long> entry : elementMap.entrySet()) {
                DynamicObject newInfo = BusinessDataServiceHelper.newDynamicObject((String)entityName);
                DynamicObjectUtils.copy((DynamicObject)info, (DynamicObject)newInfo);
                newInfo.set("costsubelement_id", (Object)entry.getKey());
                newInfo.set("costelement_id", (Object)entry.getValue());
                for (String decimalField : zeroDecimalFields) {
                    newInfo.set(decimalField, (Object)BigDecimal.ZERO);
                }
                saveInfos.add(newInfo);
            }
        }
        if (!saveInfos.isEmpty()) {
            List list = CommonUtils.getSplitDynList(saveInfos);
            for (Set set : list) {
                SaveServiceHelper.save((DynamicObject[])set.toArray(new DynamicObject[0]));
            }
        }
    }

    private void handleBalance(Set<Long> costAccountIds, Map<Long, Long> elementMap) {
        ArrayList<Object[]> balanceDetailParamList = new ArrayList<Object[]>(1024);
        IDGenerator balanceDetailIdGen = new IDGenerator("t_cal_balance_detail");
        QFilter q = new QFilter("costaccount", "in", costAccountIds);
        q.and("entryentity.costsubelement", "=", (Object)773175233367685120L);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_balance_subentity", (String)"id,entryentity.costelement,entryentity.costsubelement,entryentity.sub_periodbeginqty,entryentity.sub_periodinqty,entryentity.sub_periodissueqty,entryentity.sub_periodendqty,entryentity.sub_yearinqty,entryentity.sub_yearissueqty", (QFilter[])q.toArray(), null);
        Object object = null;
        try {
            for (Row row : dataSet) {
                for (Map.Entry<Long, Long> entry : elementMap.entrySet()) {
                    Long detailId = balanceDetailIdGen.getId();
                    balanceDetailParamList.add(new Object[]{detailId, row.getLong("id"), entry.getValue(), entry.getKey(), row.getLong("entryentity.sub_periodbeginqty"), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, row.getLong("entryentity.sub_periodinqty"), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, row.getLong("entryentity.sub_periodissueqty"), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, row.getLong("entryentity.sub_periodendqty"), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, row.getLong("entryentity.sub_yearinqty"), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, row.getLong("entryentity.sub_yearissueqty"), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        if (!balanceDetailParamList.isEmpty()) {
            List costDetailList = CommonUtils.getSplitList(balanceDetailParamList);
            for (List list : costDetailList) {
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)this.insertBalanceDetailSql, (List)list);
            }
        }
    }

    private void handleDiffBalance(Set<Long> costAccountIds, Map<Long, Long> elementMap) {
        ArrayList<Object[]> diffBalanceDetailParamList = new ArrayList<Object[]>(1024);
        IDGenerator balanceDetailIdGen = new IDGenerator("t_cal_purdiff_detail");
        QFilter q = new QFilter("costsubelement", "=", (Object)773175233367685120L);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_purpricediff_detail", (String)"balid,costelement,costsubelement", (QFilter[])q.toArray(), null);
        Object object = null;
        try {
            for (Row row : dataSet) {
                for (Map.Entry<Long, Long> entry : elementMap.entrySet()) {
                    Long detailId = balanceDetailIdGen.getId();
                    diffBalanceDetailParamList.add(new Object[]{detailId, row.getLong("balid"), entry.getValue(), entry.getKey()});
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        if (!diffBalanceDetailParamList.isEmpty()) {
            List costDetailList = CommonUtils.getSplitList(diffBalanceDetailParamList);
            for (List list : costDetailList) {
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)this.insertDiffBalDetailSql, (List)list);
            }
        }
    }

    private void writeBackSubElement(Map<Long, Long> elementMap) {
        try (TXHandle tx1 = TX.requiresNew();){
            String updateSql = "update t_cad_subelement set fsyncflag = '1' where fid in (" + StringUtils.join((Object[])elementMap.keySet().toArray(), (char)',') + ")";
            DB.execute((DBRoute)new DBRoute("sys"), (String)updateSql);
        }
    }
}

