/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.util.JsonUtils;

public class StdCostDiffUpdateTask
extends AbstractTask {
    private static final String[] indexStrs = new String[]{"id", "seq", "sub_material", "costelement", "costsubelement", "sub_currency", "sub_adjustamt", "ddiff_g", "ddiff_h", "ddiff_k", "ddiff_m", "ddiff_p", "ddiff_q", "ddiff_r", "ddiff_s", "ddiff_t", "ddiff_c", "ddiff_x", "ddiff_w", "ddiff_y", "sub_material_id", "costelement_id", "costsubelement_id", "sub_currency_id"};
    private static final String[] diffTypes = new String[]{"G", "H", "K", "M", "P", "Q", "R", "S", "T", "C", "X", "W", "Y"};

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Long paramId = (Long)JsonUtils.jsonToObj((String)map.get("paramid").toString(), Long.class);
        DynamicObject[] params = BusinessDataServiceHelper.load((String)"cal_taskparam", (String)"param_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)paramId)});
        Set ids = (Set)SerializationUtils.fromJsonString((String)params[0].getString("param_tag"), Set.class);
        this.doUpdate(ids, paramId);
    }

    public void doUpdate(Set<Long> ids, Long paramId) {
        QFilter filter = new QFilter("id", "in", ids);
        this.update(filter, paramId);
    }

    private void update(QFilter filter, Long paramId) {
        DataSet billsData = QueryServiceHelper.queryDataSet((String)"", (String)"cal_costadjustbill", (String)"id", (QFilter[])filter.toArray(), null);
        ArrayList<Object[]> ids = new ArrayList<Object[]>(16);
        for (Row row : billsData) {
            ids.add(new Object[]{row.getLong("id")});
        }
        if (ids.size() > 0) {
            this.doCopy(ids, paramId);
        }
    }

    private void doCopy(List<Object[]> ids, Long paramId) {
        try (TXHandle h1 = TX.requiresNew();){
            try {
                this.copyBillData(ids);
                this.insertIdToTable(ids);
                this.updateTask("B", paramId);
                ids.clear();
            }
            catch (Throwable e) {
                h1.markRollback();
                throw e;
            }
        }
    }

    private void copyBillData(List<Object[]> ids) {
        String copyHeaderData = "insert into t_cal_stdcostdiff(" + this.getHeadFields() + "fid) select " + this.getHeadFields() + "fid from t_cal_costadjustbill where fid in (?);";
        DB.executeBatch((DBRoute)new DBRoute("cal"), (String)copyHeaderData, ids);
        String copyEntryData = "insert into t_cal_stdcostdiffentry(" + this.getEntryFields() + "fid,fentryid) select " + this.getEntryFields().replace("fproductlineid", "fproductline").replace("fsubentryentity", " ' ' as fsubentryentity") + "fid,fentryid from t_cal_costadjustbillentry where fid in (?);";
        DB.executeBatch((DBRoute)new DBRoute("cal"), (String)copyEntryData, ids);
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (Object[] id : ids) {
            idSet.add((Long)id[0]);
        }
        QFilter filter = new QFilter("id", "in", idSet);
        DataSet billDetailData = QueryServiceHelper.queryDataSet((String)"", (String)"cal_costadjust_subentity", (String)"id,difftype,currency,entryentity.id as entryid,entryentity.adjustamt as adjustamt,entryentity.subentryentity.id as detailid,entryentity.subentryentity.costelement as costelement,entryentity.subentryentity.costsubelement as costsubelement,entryentity.subentryentity.sub_adjustamt as sub_adjustamt", (QFilter[])filter.toArray(), null);
        String updateSql_g = "update t_cal_stdcostdiffentry set fdiff_g = ?,fsubentryentity=? where fentryid = ?";
        String updateSql_h = "update t_cal_stdcostdiffentry set fdiff_h = ?,fsubentryentity=? where fentryid = ?";
        String updateSql_k = "update t_cal_stdcostdiffentry set fdiff_k = ?,fsubentryentity=? where fentryid = ?";
        String updateSql_p = "update t_cal_stdcostdiffentry set fdiff_p = ?,fsubentryentity=? where fentryid = ?";
        String updateSql_q = "update t_cal_stdcostdiffentry set fdiff_q = ?,fsubentryentity=? where fentryid = ?";
        String updateSql_r = "update t_cal_stdcostdiffentry set fdiff_r = ?,fsubentryentity=? where fentryid = ?";
        String updateSql_m = "update t_cal_stdcostdiffentry set fdiff_m = ?,fsubentryentity=? where fentryid = ?";
        String updateSql_s = "update t_cal_stdcostdiffentry set fdiff_s = ?,fsubentryentity=? where fentryid = ?";
        String updateSql_t = "update t_cal_stdcostdiffentry set fdiff_t = ?,fsubentryentity=? where fentryid = ?";
        String updateSql_x = "update t_cal_stdcostdiffentry set fdiff_x = ?,fsubentryentity=? where fentryid = ?";
        String updateSql_w = "update t_cal_stdcostdiffentry set fdiff_w = ?,fsubentryentity=? where fentryid = ?";
        String updateSql_y = "update t_cal_stdcostdiffentry set fdiff_y = ?,fsubentryentity=? where fentryid = ?";
        String updateSql_c = "update t_cal_stdcostdiffentry set fdiff_c = ?,fsubentryentity=? where fentryid = ?";
        DataSet[] billDetailDatas = billDetailData.splitByFilter(new String[]{"difftype = 'G'", "difftype = 'H'", "difftype = 'K'", "difftype = 'P'", "difftype = 'Q'", "difftype = 'R'", "difftype = 'M'", "difftype = 'S'", "difftype = 'T'", "difftype = 'X'", "difftype = 'W'", "difftype = 'Y'", "difftype = 'C'"}, Boolean.FALSE.booleanValue());
        Map<Long, Object[]> update_g_paramsMap = this.getUpdateParamsMap(billDetailDatas[0]);
        Map<Long, Object[]> update_h_paramsMap = this.getUpdateParamsMap(billDetailDatas[1]);
        Map<Long, Object[]> update_k_paramsMap = this.getUpdateParamsMap(billDetailDatas[2]);
        Map<Long, Object[]> update_p_paramsMap = this.getUpdateParamsMap(billDetailDatas[3]);
        Map<Long, Object[]> update_q_paramsMap = this.getUpdateParamsMap(billDetailDatas[4]);
        Map<Long, Object[]> update_r_paramsMap = this.getUpdateParamsMap(billDetailDatas[5]);
        Map<Long, Object[]> update_m_paramsMap = this.getUpdateParamsMap(billDetailDatas[6]);
        Map<Long, Object[]> update_s_paramsMap = this.getUpdateParamsMap(billDetailDatas[7]);
        Map<Long, Object[]> update_t_paramsMap = this.getUpdateParamsMap(billDetailDatas[8]);
        Map<Long, Object[]> update_x_paramsMap = this.getUpdateParamsMap(billDetailDatas[9]);
        Map<Long, Object[]> update_w_paramsMap = this.getUpdateParamsMap(billDetailDatas[10]);
        Map<Long, Object[]> update_y_paramsMap = this.getUpdateParamsMap(billDetailDatas[11]);
        Map<Long, Object[]> update_c_paramsMap = this.getUpdateParamsMap(billDetailDatas[12]);
        this.excuteDbSql(updateSql_g, new ArrayList<Object[]>(update_g_paramsMap.values()));
        this.excuteDbSql(updateSql_h, new ArrayList<Object[]>(update_h_paramsMap.values()));
        this.excuteDbSql(updateSql_k, new ArrayList<Object[]>(update_k_paramsMap.values()));
        this.excuteDbSql(updateSql_p, new ArrayList<Object[]>(update_p_paramsMap.values()));
        this.excuteDbSql(updateSql_q, new ArrayList<Object[]>(update_q_paramsMap.values()));
        this.excuteDbSql(updateSql_r, new ArrayList<Object[]>(update_r_paramsMap.values()));
        this.excuteDbSql(updateSql_m, new ArrayList<Object[]>(update_m_paramsMap.values()));
        this.excuteDbSql(updateSql_s, new ArrayList<Object[]>(update_s_paramsMap.values()));
        this.excuteDbSql(updateSql_t, new ArrayList<Object[]>(update_t_paramsMap.values()));
        this.excuteDbSql(updateSql_x, new ArrayList<Object[]>(update_x_paramsMap.values()));
        this.excuteDbSql(updateSql_w, new ArrayList<Object[]>(update_w_paramsMap.values()));
        this.excuteDbSql(updateSql_y, new ArrayList<Object[]>(update_y_paramsMap.values()));
        this.excuteDbSql(updateSql_c, new ArrayList<Object[]>(update_c_paramsMap.values()));
    }

    private void insertIdToTable(List<Object[]> ids) {
        ArrayList<Object[]> tempParams = new ArrayList<Object[]>(16);
        for (Object[] id : ids) {
            Object[] params = new Object[]{id[0], id[0]};
            tempParams.add(params);
        }
        String insertDataSql = "insert into T_CAL_SUCCESSBILL(fid,fdataid) values (?,?);";
        DB.executeBatch((DBRoute)new DBRoute("cal"), (String)insertDataSql, tempParams);
    }

    private void excuteDbSql(String sql, List<Object[]> params) {
        if (params == null || params.isEmpty()) {
            return;
        }
        DB.executeBatch((DBRoute)new DBRoute("cal"), (String)sql, params);
    }

    private String getHeadFields() {
        HashSet<String> excludeFields = new HashSet<String>(16);
        excludeFields.add("remark");
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_stdcostdiffbill");
        Map allFields = entityType.getAllFields();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry fieldInfo : allFields.entrySet()) {
            IDataEntityType parentProp = ((IDataEntityProperty)fieldInfo.getValue()).getParent();
            boolean isEntryProp = parentProp instanceof EntryType;
            if (isEntryProp || excludeFields.contains(((IDataEntityProperty)fieldInfo.getValue()).getName()) || ((IDataEntityProperty)fieldInfo.getValue()).getAlias() == null || ((IDataEntityProperty)fieldInfo.getValue()).getAlias().isEmpty()) continue;
            sb.append(((IDataEntityProperty)fieldInfo.getValue()).getAlias()).append(",");
        }
        return sb.toString();
    }

    private String getEntryFields() {
        HashSet<String> excludeFields = new HashSet<String>(16);
        excludeFields.add("diff_g");
        excludeFields.add("diff_h");
        excludeFields.add("diff_k");
        excludeFields.add("diff_p");
        excludeFields.add("diff_q");
        excludeFields.add("diff_r");
        excludeFields.add("diff_m");
        excludeFields.add("diff_s");
        excludeFields.add("diff_t");
        excludeFields.add("diff_x");
        excludeFields.add("diff_w");
        excludeFields.add("diff_y");
        excludeFields.add("diff_c");
        excludeFields.add("fsubentryentity");
        excludeFields.add("groupdiffbillid");
        excludeFields.add("groupdiffbillnum");
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_stdcostdiffbill");
        Map allFields = entityType.getAllFields();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry fieldInfo : allFields.entrySet()) {
            IDataEntityType parentProp = ((IDataEntityProperty)fieldInfo.getValue()).getParent();
            boolean isEntryProp = parentProp instanceof EntryType;
            if ("subentryentity".equals(parentProp.getName()) || excludeFields.contains(((IDataEntityProperty)fieldInfo.getValue()).getName()) || !isEntryProp || ((IDataEntityProperty)fieldInfo.getValue()).getAlias() == null || ((IDataEntityProperty)fieldInfo.getValue()).getAlias().isEmpty()) continue;
            sb.append(((IDataEntityProperty)fieldInfo.getValue()).getAlias()).append(",");
        }
        return sb.toString();
    }

    private Map<Long, Object[]> getUpdateParamsMap(DataSet billDetailData) {
        HashMap<Long, Object[]> update_paramsMap = new HashMap<Long, Object[]>(16);
        for (Row row : billDetailData) {
            Object[] param;
            Long entryId = row.getLong("entryid");
            String difftype = row.getString("difftype");
            if (update_paramsMap.containsKey(entryId)) {
                param = (Object[])update_paramsMap.get(entryId);
                param[1] = this.getJsonData(row, param[1], difftype);
                continue;
            }
            param = new Object[]{row.getBigDecimal("adjustamt"), this.getJsonData(row, null, difftype), row.getLong("entryid")};
            update_paramsMap.put(entryId, param);
        }
        return update_paramsMap;
    }

    private Object dealJsonData(Object val, Object[] detailVals) {
        if (val == null) {
            JSONObject valJson = new JSONObject();
            JSONArray datas = new JSONArray();
            datas.add((Object)detailVals);
            valJson.put("data", (Object)datas);
            valJson.put("index", JSON.toJSON((Object)indexStrs));
            val = valJson.toJSONString();
        } else {
            JSONObject vaJson = JSON.parseObject((String)val.toString());
            JSONArray data = vaJson.getJSONArray("data");
            data.add((Object)detailVals);
            val = vaJson.toString();
        }
        return val;
    }

    private Object getJsonData(Row row, Object param, String difftype) {
        Object[] detail = new Object[24];
        detail[0] = row.getLong("detailid");
        detail[2] = 0L;
        detail[3] = row.getLong("costelement");
        detail[4] = row.getLong("costsubelement");
        detail[5] = row.getLong("currency");
        int index = 1;
        for (String diffType : diffTypes) {
            detail[6 + index++] = diffType.equalsIgnoreCase(difftype) ? row.getBigDecimal("adjustamt") : BigDecimal.ZERO;
        }
        detail[6] = row.getBigDecimal("adjustamt");
        detail[20] = 0L;
        detail[21] = row.getLong("costelement");
        detail[22] = row.getLong("costsubelement");
        detail[23] = row.getLong("currency");
        return this.dealJsonData(param, detail);
    }

    private void updateTask(String status, Long paramId) {
        String updateSql = "update t_cal_taskparam  set fstatus = '" + status + "' where fid = " + paramId;
        DB.execute((DBRoute)new DBRoute("cal"), (String)updateSql);
    }
}

