/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.wf;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.business.process.ErrorMsg;
import kd.fi.cal.business.service.SyncLockHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.enums.PurOmAdjustTypeEnum;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.model.PurOmWfAdjustInfo;
import kd.fi.cal.common.model.PurOmWfReqOutBillInfo;
import kd.fi.cal.common.util.CommonUtils;
import org.apache.commons.lang.StringUtils;

public class PurOmWfAdjustFacade {
    private static final Boolean isNewGroupModel = AcctGroupModelHelper.isNewGroupModel();
    private static final String GROUP_ENTRY_TBNUM = isNewGroupModel != false ? "t_cal_atgrouprecord_entry" : "t_cal_grouprecordentry";
    private static final String DLOCK_KEY = "PurOmWfAdjustFacade_";
    private static final String REWRITE_REQBILL_SQL = "update t_im_osmreqoutbillentry_r set fosverifyqty = fosverifyqty + ?, fosverifybaseqty = fosverifybaseqty + ?,fosunverifyqty = fosunverifyqty - ?,fosunverifybaseqty = fosunverifybaseqty - ? where fentryid = ?";
    private static final String UPDATE_WFRECORD_SQL = "update t_im_oswfrecordentry set fverifybaseqty = ?,fasstbasewritqty = ? where fentryid = ?";
    private PurOmWfAdjustInfo purOmWfAdjustInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long executeWfAdjust(PurOmWfAdjustInfo purOmWfAdjustInfo) {
        this.purOmWfAdjustInfo = purOmWfAdjustInfo;
        DynamicObject record = BusinessDataServiceHelper.loadSingle((String)"im_oswfrecord", (QFilter[])new QFilter("id", "=", (Object)purOmWfAdjustInfo.getOmWfRecordId()).toArray());
        SyncLockHelper syncLockHelper = new SyncLockHelper(ActionEnum.MATERIALWRITEOFF.getValue(), new DynamicObject[]{record});
        ArrayList<DLock> locks = new ArrayList<DLock>(16);
        try {
            Long adjustRecorId;
            this.addLock(locks, syncLockHelper);
            Long l = adjustRecorId = this.doWfAdjust();
            return l;
        }
        finally {
            syncLockHelper.close();
            this.unLock(locks);
        }
    }

    private void addLock(List<DLock> locks, SyncLockHelper syncLockHelper) {
        List reqBillInfos = this.purOmWfAdjustInfo.getReqBillList();
        Collections.sort(reqBillInfos, this.getComparator());
        HashSet hasLockEntryIds = new HashSet(16);
        StringBuilder errBillNoBuilder = new StringBuilder();
        for (PurOmWfReqOutBillInfo reqBillInfo : reqBillInfos) {
            Long reqBillEntryId = reqBillInfo.getReqBillEntryId();
            if (hasLockEntryIds.contains(reqBillEntryId)) continue;
            DLock lock = DLock.createReentrant((String)(DLOCK_KEY + reqBillEntryId), (String)"adjustwf");
            locks.add(lock);
            if (lock.tryLock()) continue;
            errBillNoBuilder.append(reqBillInfo.getReqBillNo());
            errBillNoBuilder.append(',');
        }
        if (errBillNoBuilder.length() > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u6b63\u5728\u6267\u884c\u6838\u9500\u8c03\u6574\u7684\u59d4\u5916\u91c7\u8d2d\u9886\u6599\u5355[%1$s],\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"PurOmWfAdjustFacade_0", (String)"fi-cal-business", (Object[])new Object[0]), CommonUtils.trimComma((String)errBillNoBuilder.toString())));
        }
        List<ErrorMsg> mutErrors = syncLockHelper.lock();
        if (!mutErrors.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u59d4\u5916\u6750\u6599\u6838\u9500\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"PurOmWfAdjustFacade_1", (String)"fi-cal-business", (Object[])new Object[0]));
        }
    }

    private void unLock(List<DLock> locks) {
        for (DLock lock : locks) {
            lock.unlock();
        }
    }

    private Long doWfAdjust() {
        Object reqBill2;
        List reqBillList = this.purOmWfAdjustInfo.getReqBillList();
        ArrayList<PurOmWfReqOutBillInfo> deleteBills = new ArrayList<PurOmWfReqOutBillInfo>(16);
        ArrayList<PurOmWfReqOutBillInfo> addBills = new ArrayList<PurOmWfReqOutBillInfo>(16);
        ArrayList<PurOmWfReqOutBillInfo> updateBills = new ArrayList<PurOmWfReqOutBillInfo>(16);
        for (Object reqBill2 : reqBillList) {
            String adjustType = reqBill2.getAdjustType();
            if (adjustType.equals(PurOmAdjustTypeEnum.ADJUST_DELETE.getValue())) {
                deleteBills.add((PurOmWfReqOutBillInfo)reqBill2);
                continue;
            }
            if (adjustType.equals(PurOmAdjustTypeEnum.ADJUST_ADD.getValue())) {
                addBills.add((PurOmWfReqOutBillInfo)reqBill2);
                continue;
            }
            updateBills.add((PurOmWfReqOutBillInfo)reqBill2);
        }
        TXHandle scmTx = TX.requiresNew();
        reqBill2 = null;
        try {
            try {
                this.doScmDeleteEntry(deleteBills);
                this.doScmUpdateEntry(updateBills);
                this.doAddEntry(addBills);
            }
            catch (Exception e) {
                scmTx.setRollback(true);
                throw e;
            }
        }
        catch (Throwable throwable) {
            reqBill2 = throwable;
            throw throwable;
        }
        finally {
            if (scmTx != null) {
                if (reqBill2 != null) {
                    try {
                        scmTx.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)reqBill2).addSuppressed(throwable);
                    }
                } else {
                    scmTx.close();
                }
            }
        }
        Long adjustRecorId = null;
        try (TXHandle calTx = TX.requiresNew();){
            try {
                this.doCalDeleteEntry(deleteBills);
                this.doCalUpdateEntry(updateBills);
                DynamicObject recordDym = BusinessDataServiceHelper.loadSingle((String)"im_oswfrecord", (QFilter[])new QFilter("id", "=", (Object)this.purOmWfAdjustInfo.getOmWfRecordId()).toArray());
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBizService", (String)"doService", (Object[])new Object[]{ActionEnum.MATERIALWRITEOFF.getValue(), null, new DynamicObject[]{recordDym}});
                adjustRecorId = this.buildWfAdjustRecord(reqBillList);
            }
            catch (Exception e) {
                calTx.setRollback(true);
                throw e;
            }
        }
        this.reWriteWfQty(reqBillList);
        return adjustRecorId;
    }

    private void doScmDeleteEntry(List<PurOmWfReqOutBillInfo> deleteBills) {
        if (deleteBills.isEmpty()) {
            return;
        }
        Set<Long> recordEntryIds = deleteBills.stream().map(s -> s.getRecordEntryId()).collect(Collectors.toSet());
        Lists.partition(Arrays.asList(recordEntryIds.toArray(new Long[0])), (int)CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.COMMON_SPLITBATCHNUM)).forEach(list -> {
            String deleteWfRecordSql = "DELETE FROM t_im_oswfrecordentry WHERE fentryid in (" + StringUtils.join((Collection)list, (String)",") + ")";
            DB.execute((DBRoute)CommonUtils.getScmDBRouteKey(), (String)deleteWfRecordSql);
        });
    }

    private void doCalDeleteEntry(List<PurOmWfReqOutBillInfo> deleteBills) {
        if (deleteBills.isEmpty()) {
            return;
        }
        Set recordIds = deleteBills.stream().map(s -> s.getRecordId()).collect(Collectors.toSet());
        Map<Long, Set<Long>> wfRecordAndCostIdMap = this.getCostEntryIdMap(deleteBills);
        if (wfRecordAndCostIdMap.isEmpty()) {
            return;
        }
        HashSet<Long> costRecordEntryIds = new HashSet<Long>(16);
        for (Set<Long> ids : wfRecordAndCostIdMap.values()) {
            costRecordEntryIds.addAll(ids);
        }
        SqlBuilder deleteGroupRecordSqlBuilder = new SqlBuilder();
        deleteGroupRecordSqlBuilder.append("DELETE FROM ", new Object[0]);
        deleteGroupRecordSqlBuilder.append(GROUP_ENTRY_TBNUM, new Object[0]);
        deleteGroupRecordSqlBuilder.append(" WHERE fgroupno in (", new Object[0]);
        deleteGroupRecordSqlBuilder.append(StringUtils.join(recordIds, (String)","), new Object[0]);
        deleteGroupRecordSqlBuilder.append(") and fcostrecordentryid in (", new Object[0]);
        deleteGroupRecordSqlBuilder.append(StringUtils.join(costRecordEntryIds, (String)","), new Object[0]);
        deleteGroupRecordSqlBuilder.append(")", new Object[0]);
        DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (SqlBuilder)deleteGroupRecordSqlBuilder);
    }

    private void doAddEntry(List<PurOmWfReqOutBillInfo> addBills) {
        if (addBills.isEmpty()) {
            return;
        }
        this.addWfRecordEntry(addBills);
    }

    private void doScmUpdateEntry(List<PurOmWfReqOutBillInfo> updateBills) {
        if (updateBills.isEmpty()) {
            return;
        }
        ArrayList<Object[]> wfRecordParamsList = new ArrayList<Object[]>(16);
        Map<Long, Set<Long>> wfRecordAndCostIdMap = this.getCostEntryIdMap(updateBills);
        if (wfRecordAndCostIdMap.isEmpty()) {
            return;
        }
        for (PurOmWfReqOutBillInfo billInfo : updateBills) {
            BigDecimal crtAdjustWfBaseQty = billInfo.getCrtWfBaseQty();
            BigDecimal crtAdjustWfQty = billInfo.getCrtWfQty();
            Long recordEntryId = billInfo.getRecordEntryId();
            wfRecordParamsList.add(new Object[]{crtAdjustWfBaseQty, crtAdjustWfQty, recordEntryId});
        }
        Lists.partition(wfRecordParamsList, (int)CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.COMMON_SPLITBATCHNUM)).forEach(list -> DB.executeBatch((DBRoute)CommonUtils.getScmDBRouteKey(), (String)UPDATE_WFRECORD_SQL, (List)list));
    }

    private void doCalUpdateEntry(List<PurOmWfReqOutBillInfo> updateBills) {
        if (updateBills.isEmpty()) {
            return;
        }
        ArrayList<SqlBuilder> groupRecordSqlList = new ArrayList<SqlBuilder>(16);
        Map<Long, Set<Long>> wfRecordAndCostIdMap = this.getCostEntryIdMap(updateBills);
        if (wfRecordAndCostIdMap.isEmpty()) {
            return;
        }
        for (PurOmWfReqOutBillInfo billInfo : updateBills) {
            BigDecimal crtAdjustWfBaseQty = billInfo.getCrtWfBaseQty();
            Long recordEntryId = billInfo.getRecordEntryId();
            Long recordId = billInfo.getRecordId();
            Set<Long> recordEntryIds = wfRecordAndCostIdMap.get(recordEntryId);
            if (recordEntryIds == null) continue;
            SqlBuilder updateSqlBuilder = new SqlBuilder();
            updateSqlBuilder.append("update ", new Object[0]);
            updateSqlBuilder.append(GROUP_ENTRY_TBNUM, new Object[0]);
            updateSqlBuilder.append(" set foccupiedqty =", new Object[0]);
            updateSqlBuilder.append(String.valueOf(crtAdjustWfBaseQty), new Object[0]);
            updateSqlBuilder.append(",fweight = 1 where fgroupno = ", new Object[0]);
            updateSqlBuilder.append(String.valueOf(recordId), new Object[0]);
            if (isNewGroupModel.booleanValue()) {
                updateSqlBuilder.append(" and fcostrecordentryid in (", new Object[0]);
                updateSqlBuilder.append(StringUtils.join(recordEntryIds, (String)","), new Object[0]);
                updateSqlBuilder.append(")", new Object[0]);
            }
            groupRecordSqlList.add(updateSqlBuilder);
        }
        if (!groupRecordSqlList.isEmpty()) {
            Lists.partition(groupRecordSqlList, (int)CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.COMMON_SPLITBATCHNUM)).forEach(list -> {
                for (SqlBuilder sql : list) {
                    DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (SqlBuilder)sql);
                }
            });
        }
    }

    private void addWfRecordEntry(List<PurOmWfReqOutBillInfo> addBills) {
        DynamicObject recordDym = BusinessDataServiceHelper.loadSingle((String)"im_oswfrecord", (QFilter[])new QFilter("id", "=", (Object)this.purOmWfAdjustInfo.getOmWfRecordId()).toArray());
        HashSet<Long> matIds = new HashSet<Long>(16);
        HashMap<Long, Long> matMasterIdMap = new HashMap<Long, Long>(16);
        for (PurOmWfReqOutBillInfo purOmWfReqOutBillInfo : addBills) {
            matIds.add(purOmWfReqOutBillInfo.getMatId());
        }
        DataSet matInfoDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_materialinventoryinfo", (String)"masterid,id", (QFilter[])new QFilter("masterid", "in", matIds).toArray(), null);
        for (Row row : matInfoDs) {
            matMasterIdMap.put(row.getLong("masterid"), row.getLong("id"));
        }
        long[] lArray = DB.genLongIds((String)"t_im_oswfrecordentry", (int)addBills.size());
        int i = 0;
        for (PurOmWfReqOutBillInfo billInfo : addBills) {
            DynamicObject newEntry = recordDym.getDynamicObjectCollection("entry").addNew();
            newEntry.set("id", (Object)lArray[i]);
            billInfo.setRecordEntryId(Long.valueOf(lArray[i]));
            newEntry.set("billtype", (Object)"im_osmaterialreqoutbill");
            newEntry.set("billno", (Object)billInfo.getReqBillNo());
            newEntry.set("billid", (Object)billInfo.getReqBillId());
            newEntry.set("billentryid", (Object)billInfo.getReqBillEntryId());
            newEntry.set("billqty", (Object)billInfo.getQty());
            newEntry.set("qty", (Object)billInfo.getCrtWfBaseQty());
            newEntry.set("asstbasewritqty", (Object)billInfo.getCrtWfQty());
            newEntry.set("asstsrcbillentryseq", (Object)billInfo.getReqBillEntrySeq());
            Long matId = (Long)matMasterIdMap.get(billInfo.getMatId());
            if (matId == null) {
                matId = billInfo.getMatId();
            }
            newEntry.set("asstmaterial_id", (Object)matId);
            newEntry.set("asstunit_id", (Object)billInfo.getUnitId());
            newEntry.set("unitfield", (Object)billInfo.getBaseunitId());
            newEntry.set("srcbillno", (Object)billInfo.getMainBillNum());
            newEntry.set("srcentryseq", (Object)billInfo.getMainBillEntrySeq());
            newEntry.set("datefield", (Object)billInfo.getBookDate());
            newEntry.set("asstinvscheme_id", (Object)billInfo.getInvschemeId());
            ++i;
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recordDym});
    }

    private void reWriteWfQty(List<PurOmWfReqOutBillInfo> billInfos) {
        ArrayList<Object[]> reWriteParamsList = new ArrayList<Object[]>(16);
        for (PurOmWfReqOutBillInfo billInfo : billInfos) {
            BigDecimal crtAdjustWfQty = billInfo.getCrtAdjustWfQty();
            BigDecimal crtAdjustWfBaseQty = billInfo.getCrtAdjustWfBaseQty();
            Long reqBillEntryId = billInfo.getReqBillEntryId();
            reWriteParamsList.add(new Object[]{crtAdjustWfQty, crtAdjustWfBaseQty, crtAdjustWfQty, crtAdjustWfBaseQty, reqBillEntryId});
        }
        Lists.partition(reWriteParamsList, (int)CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.COMMON_SPLITBATCHNUM)).forEach(list -> DB.executeBatch((DBRoute)CommonUtils.getScmDBRouteKey(), (String)REWRITE_REQBILL_SQL, (List)list));
    }

    private Long buildWfAdjustRecord(List<PurOmWfReqOutBillInfo> reqBillList) {
        DynamicObject adjustRecordDym = BusinessDataServiceHelper.newDynamicObject((String)"cal_omwfadjustrecord");
        Long id = DB.genLongId((String)"t_cal_omwfadjustrecord");
        adjustRecordDym.set("id", (Object)id);
        adjustRecordDym.set("adjustnum", (Object)id);
        adjustRecordDym.set("adjusttime", (Object)new Date().getTime());
        adjustRecordDym.set("inbillno", (Object)this.purOmWfAdjustInfo.getInBillNo());
        adjustRecordDym.set("inbillseq", (Object)this.purOmWfAdjustInfo.getInBillSeq());
        adjustRecordDym.set("inbillid", (Object)this.purOmWfAdjustInfo.getInBillId());
        DynamicObjectCollection entrys = adjustRecordDym.getDynamicObjectCollection("entryentity");
        for (PurOmWfReqOutBillInfo reqBill : reqBillList) {
            DynamicObject newEntry = entrys.addNew();
            newEntry.set("recordentryid", (Object)reqBill.getRecordEntryId());
            newEntry.set("reqbillno", (Object)reqBill.getReqBillNo());
            newEntry.set("reqbillseq", (Object)reqBill.getReqBillEntrySeq());
            newEntry.set("reqbillno", (Object)reqBill.getReqBillNo());
            newEntry.set("material_id", (Object)reqBill.getMatId());
            newEntry.set("baseunit_id", (Object)reqBill.getBaseunitId());
            newEntry.set("adjustwfqty", (Object)reqBill.getCrtWfBaseQty());
            newEntry.set("diffbaseqty", (Object)reqBill.getCrtAdjustWfBaseQty());
            newEntry.set("diffqty", (Object)reqBill.getCrtAdjustWfQty());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{adjustRecordDym});
        return id;
    }

    private Map<Long, Set<Long>> getCostEntryIdMap(List<PurOmWfReqOutBillInfo> reqBillInfos) {
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        HashSet<Long> bizBillEntryIds = new HashSet<Long>(16);
        HashMap<Long, Long> billAndRecordEntryIdMap = new HashMap<Long, Long>(16);
        for (PurOmWfReqOutBillInfo reqBillInfo : reqBillInfos) {
            Long recordEntryId = reqBillInfo.getRecordEntryId();
            bizBillIds.add(reqBillInfo.getReqBillId());
            bizBillEntryIds.add(reqBillInfo.getReqBillEntryId());
            billAndRecordEntryIdMap.put(reqBillInfo.getReqBillEntryId(), recordEntryId);
        }
        QFilter costRecordQ = new QFilter("bizbillid", "in", bizBillIds);
        costRecordQ.and("entry.bizbillentryid", "in", bizBillEntryIds);
        DataSet costRecordDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_subentity", (String)"entry.id as entryid,entry.bizbillentryid as bizbillentryid", (QFilter[])costRecordQ.toArray(), null);
        HashMap<Long, Set<Long>> recordEntryAndCostIdMap = new HashMap<Long, Set<Long>>(16);
        for (Row row : costRecordDs) {
            Long costRecordEntryId = row.getLong("entryid");
            Long reqBillEntryId = row.getLong("bizbillentryid");
            Long recordEntryId = (Long)billAndRecordEntryIdMap.get(reqBillEntryId);
            if (recordEntryId == null) continue;
            Set costRecordIds = recordEntryAndCostIdMap.computeIfAbsent(recordEntryId, k -> new HashSet(16));
            costRecordIds.add(costRecordEntryId);
        }
        return recordEntryAndCostIdMap;
    }

    private Comparator<PurOmWfReqOutBillInfo> getComparator() {
        Comparator<PurOmWfReqOutBillInfo> comparator = new Comparator<PurOmWfReqOutBillInfo>(){

            @Override
            public int compare(PurOmWfReqOutBillInfo o1, PurOmWfReqOutBillInfo o2) {
                long otherPrior;
                long onePrior = o1.getReqBillEntryId();
                if (Long.compare(onePrior, otherPrior = o2.getReqBillEntryId().longValue()) > 0) {
                    return 1;
                }
                if (Long.compare(onePrior, otherPrior) < 0) {
                    return -1;
                }
                return 0;
            }
        };
        return comparator;
    }
}

