/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.wf;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.cal.common.helper.CalBillRuleCheckHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;

public class WfHelper {
    public void removeNotSyncCalWfIds(Map<String, Set<Long>> mainBillEntityBillIdsMap, Map<Long, Set<Long>> ... mainBillIdWfIdsMaps) {
        if (mainBillEntityBillIdsMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Set<Long>> entry : mainBillEntityBillIdsMap.entrySet()) {
            String entity = entry.getKey();
            Set<Long> billIds = entry.getValue();
            CalBillRuleCheckHelper calBillRuleCheckHelper = new CalBillRuleCheckHelper(entity, billIds);
            calBillRuleCheckHelper.addSkipProperty("billstatus");
            Set failBillIds = calBillRuleCheckHelper.check();
            for (Map<Long, Set<Long>> mainBillIdWfIdsMap : mainBillIdWfIdsMaps) {
                if (mainBillIdWfIdsMap.isEmpty()) continue;
                mainBillIdWfIdsMap.keySet().removeAll(failBillIds);
            }
        }
    }

    public void invokeWfByBatch(Map<Long, Set<Long>> mainBillIdWfIdsMap, String actionName, String wfRecordEntity) {
        if (mainBillIdWfIdsMap.isEmpty()) {
            return;
        }
        int size = CalDbParamServiceHelper.getInteger((String)"wf_split_mainbill_size");
        Lists.partition(new ArrayList<Long>(mainBillIdWfIdsMap.keySet()), (int)size).forEach(list -> {
            HashSet allWfIds = new HashSet(16);
            for (Long billId : list) {
                Set wfIds = (Set)mainBillIdWfIdsMap.get(billId);
                allWfIds.addAll(wfIds);
            }
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBizService", (String)"doService", (Object[])new Object[]{actionName, null, allWfIds, wfRecordEntity});
        });
    }

    public void invokeBatchWfByIds(String actionName, String entityName, Set<Long> bizBillIds) {
        ArrayList inputs = new ArrayList(16);
        Lists.partition(new ArrayList<Long>(bizBillIds), (int)50000).forEach(list -> {
            QFilter wfIdF = new QFilter("id", "in", list);
            OrmInput input = new OrmInput(this.getClass().getName(), entityName, "id,billid", wfIdF.toArray());
            inputs.add(input);
        });
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSet totalDataSet = algo.createDataSet((Input[])inputs.toArray(new OrmInput[inputs.size()]));
        totalDataSet = totalDataSet.orderBy(new String[]{"billid"});
        Long beforeMainBillId = 0L;
        HashMap<Long, Set<Long>> mainBillIdWfIdsMap = new HashMap<Long, Set<Long>>(16);
        int size = CalDbParamServiceHelper.getInteger((String)"wf_split_mainbill_size");
        for (Row row : totalDataSet) {
            boolean diffMainBillId;
            Long wfId = row.getLong("id");
            Long mainBillId = row.getLong("billid");
            if (mainBillId == null || mainBillId.equals(0L)) continue;
            boolean bl = diffMainBillId = !mainBillId.equals(beforeMainBillId);
            if (diffMainBillId && mainBillIdWfIdsMap.size() >= size) {
                this.invokeWf(mainBillIdWfIdsMap, actionName, entityName);
                mainBillIdWfIdsMap = new HashMap(16);
            }
            Set wfIds = mainBillIdWfIdsMap.computeIfAbsent(mainBillId, k -> new HashSet(16));
            wfIds.add(wfId);
            beforeMainBillId = mainBillId;
        }
        this.invokeWf(mainBillIdWfIdsMap, actionName, entityName);
    }

    private void invokeWf(Map<Long, Set<Long>> mainBillIdWfIdsMap, String actionName, String entityName) {
        HashSet<Long> allWfIds = new HashSet<Long>(16);
        for (Set<Long> wfIds : mainBillIdWfIdsMap.values()) {
            allWfIds.addAll(wfIds);
        }
        if (allWfIds.isEmpty()) {
            return;
        }
        String wfRecordFields = "id,billid,verifyseq,billentryid,billtype,billno,verifyqty,billstatus,createtime,auditor,modifytime,auditdate,org,entry.e_billid,entry.e_billentryid,entry.e_billno,entry.e_billtype";
        DynamicObject[] bizBills = BusinessDataServiceHelper.load((String)entityName, (String)wfRecordFields, (QFilter[])new QFilter("id", "in", allWfIds).toArray());
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBizService", (String)"doService", (Object[])new Object[]{actionName, null, bizBills});
    }
}

