/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.chargeoff;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.adjbill.AdjBillDeleteHelper;
import kd.fi.cal.common.enums.DischargeTypeEnum;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.SynBizBillHelper;
import kd.fi.cal.common.helper.WriteLogHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.DBUtil;
import kd.fi.cal.common.util.DynamicObjectUtils;

public class CalChargeOffHelper {
    private static final Log logger = LogFactory.getLog(CalChargeOffHelper.class);
    private static final String[] SUB_AMT_FIELDS = new String[]{"ddiff_g", "ddiff_h", "ddiff_k", "ddiff_p", "ddiff_q", "ddiff_r", "ddiff_m", "ddiff_s", "ddiff_t", "ddiff_c", "ddiff_x", "ddiff_w", "ddiff_y"};
    private static final String[] AMT_FIELDS = new String[]{"diff_g", "diff_h", "diff_k", "diff_p", "diff_q", "diff_r", "diff_m", "diff_s", "diff_t", "diff_c", "diff_x", "diff_w", "diff_y"};
    private static final String[] COSTRECORD_RED_ENTRYFIELDS = new String[]{"baseqty", "standardcost", "actualcost", "materialcost", "fee", "processcost", "manufacturecost", "resource", "localtax", "tax", "taxamt", "loctaxamt"};
    private static final String[] COSTRECORD_RED_SUBENTRYFIELDS = new String[]{"sub_baseqty", "sub_standardcost", "sub_actualcost"};
    private String calBillType = "IN";
    private final Set<Long> bizBillIdsCache = new HashSet<Long>(16);

    public Map<Long, Long> chargeOffWriteRecord(final Set<Long> srcWriteOffRecordIds, Date bizDate, Date bookedDate, Date chargeOffDate, String chargeOffReason) {
        Map<Long, Long> writeOffEndPeriodMap = null;
        try (TXHandle tx = TX.required();){
            try {
                writeOffEndPeriodMap = this.doChargeOffWriteRecord(srcWriteOffRecordIds, bizDate, bookedDate, chargeOffDate, chargeOffReason);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
        TX.addCommitListener((CommitListener)new CommitListener(){

            public void onEnded(boolean rollbacked) {
                try (TXHandle tx = TX.requiresNew();){
                    CalChargeOffHelper.this.autoWriteBackApVou(srcWriteOffRecordIds);
                }
            }
        });
        return writeOffEndPeriodMap;
    }

    private Map<Long, Long> doChargeOffWriteRecord(Set<Long> srcWriteOffRecordIds, Date bizDate, Date bookedDate, Date chargeOffDate, String chargeOffReason) {
        logger.info("\u6838\u7b97\u51b2\u9500\u63a5\u53e3\u5904\u7406\u5f00\u59cb");
        long startTime = System.currentTimeMillis();
        this.filterRecordIds(srcWriteOffRecordIds);
        this.doUnChargeOff(srcWriteOffRecordIds);
        if (srcWriteOffRecordIds.isEmpty()) {
            logger.info("\u6838\u7b97\u51b2\u9500\u63a5\u53e3\u5904\u7406\u7ed3\u675f\uff0c\u8be5\u6838\u9500\u8bb0\u5f55\u5bf9\u5e94\u7684\u4e3b\u65b9\u5355\u636e\u4e0d\u6ee1\u8db3\u6838\u7b97\u540c\u6b65\u6761\u4ef6\uff0c\u6216\u8005\u5b8c\u5168\u627e\u4e0d\u5230\u6838\u9500\u8bb0\u5f55\u6570\u636e\uff0c\u6216\u8005\u8be5\u6838\u9500\u8bb0\u5f55\u5728\u6838\u7b97\u542f\u7528\u671f\u95f4\u4e4b\u524d\u53d1\u751f\uff0c\u65e0\u9700\u89e6\u53d1\u6838\u7b97\u51b2\u9500\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime) + "ms");
            return new HashMap<Long, Long>();
        }
        DynamicObject[] costRecordAs = this.getCostRecordDycs(srcWriteOffRecordIds);
        Map<Long, List<DynamicObject>> ancIdCostRecDycsMap = this.getAncIdCostRecDycsMap(costRecordAs);
        Map<Long, Long> allWriteOffEndPeriodMap = this.splitByAncIdInvoke(bookedDate, chargeOffReason, ancIdCostRecDycsMap);
        logger.info("\u6838\u7b97\u51b2\u9500\u63a5\u53e3\u5904\u7406\u7ed3\u675f\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime) + "ms");
        return allWriteOffEndPeriodMap;
    }

    private DynamicObject[] getCostRecordDycs(Set<Long> srcWriteOffRecordIds) {
        QFilter q = new QFilter("entry.writeoffid", "in", srcWriteOffRecordIds);
        q.and("ischargeoff", "=", (Object)Boolean.FALSE);
        q.and("ischargeoffed", "=", (Object)Boolean.FALSE);
        q.and("bizbillid", "in", this.bizBillIdsCache);
        DynamicObject[] costRecordAs = BusinessDataServiceHelper.load((String)"cal_costrecord_subentity", (String)this.getEntityFields("cal_costrecord_subentity"), (QFilter[])q.toArray());
        return costRecordAs;
    }

    private Map<Long, Long> doChargeOffByBatch(Set<Long> srcWriteOffRecordIds, Date bookedDate, String chargeOffReason, DynamicObject[] costRecordAs) {
        DynamicObject[] preCostAdjusts;
        this.doCheck(srcWriteOffRecordIds, costRecordAs);
        this.calBillType = costRecordAs[0].getString("calbilltype");
        HashSet<Long> costRecordAIds = new HashSet<Long>(costRecordAs.length);
        HashSet<Long> costAccountIds = new HashSet<Long>(costRecordAs.length);
        HashSet<Long> srcCostRecordIds = new HashSet<Long>(costRecordAs.length);
        HashSet<Long> bizbillIds = new HashSet<Long>(costRecordAs.length);
        for (DynamicObject info : costRecordAs) {
            costRecordAIds.add(info.getLong("id"));
            costAccountIds.add(info.getDynamicObject("costaccount").getLong("id"));
            bizbillIds.add(info.getLong("bizbillid"));
            for (DynamicObject entry : info.getDynamicObjectCollection("entry")) {
                srcCostRecordIds.add(entry.getLong("ancestorbillid"));
            }
        }
        QFilter q = new QFilter("entryentity.invbillid", "in", costRecordAIds);
        DynamicObject[] costAdjusts = BusinessDataServiceHelper.load((String)"cal_costadjust_subentity", (String)this.getEntityFields("cal_costadjust_subentity"), (QFilter[])q.toArray());
        HashMap<Long, HashSet<DynamicObject>> costAdjustMap = new HashMap<Long, HashSet<DynamicObject>>(16);
        HashMap<Long, Long> costAdjustId2InvIdMap = new HashMap<Long, Long>(costAdjusts.length);
        HashSet<DynamicObject> costAdjustAllSet = new HashSet<DynamicObject>(16);
        HashSet<DynamicObject> stdcostdiffbillAllSet = new HashSet<DynamicObject>(16);
        for (DynamicObject costAdjust : costAdjusts) {
            costAdjustAllSet.add(costAdjust);
            Long invbillid = ((DynamicObject)costAdjust.getDynamicObjectCollection("entryentity").get(0)).getLong("invbillid");
            HashSet<DynamicObject> invbillCostAdjustSet = (HashSet<DynamicObject>)costAdjustMap.get(invbillid);
            if (null == invbillCostAdjustSet || invbillCostAdjustSet.size() == 0) {
                invbillCostAdjustSet = new HashSet<DynamicObject>(16);
                invbillCostAdjustSet.add(costAdjust);
                costAdjustMap.put(invbillid, invbillCostAdjustSet);
            } else {
                invbillCostAdjustSet.add(costAdjust);
            }
            costAdjustId2InvIdMap.put(costAdjust.getLong("id"), ((DynamicObject)costAdjust.getDynamicObjectCollection("entryentity").get(0)).getLong("invbillid"));
        }
        DynamicObject[] stdcostdiffbills = BusinessDataServiceHelper.load((String)"cal_stdcostdiffbill", (String)this.getEntityFields("cal_stdcostdiffbill"), (QFilter[])q.toArray());
        HashMap stdcostdiffbillMap = new HashMap(16);
        for (DynamicObject stdcostdiffbill : stdcostdiffbills) {
            stdcostdiffbillAllSet.add(stdcostdiffbill);
            Long invbillid = ((DynamicObject)stdcostdiffbill.getDynamicObjectCollection("entryentity").get(0)).getLong("invbillid");
            Set set = (Set)stdcostdiffbillMap.get(invbillid);
            if (null == set || set.size() == 0) {
                HashSet<DynamicObject> hashSet = new HashSet<DynamicObject>(16);
                hashSet.add(stdcostdiffbill);
                stdcostdiffbillMap.put(invbillid, hashSet);
                continue;
            }
            set.add(stdcostdiffbill);
        }
        q = new QFilter("entryentity.srcbillid", "in", costAdjustId2InvIdMap.keySet());
        q.and("createtype", "=", (Object)"V");
        HashMap preCostAdjustMap = new HashMap(costAdjusts.length);
        for (DynamicObject dynamicObject : preCostAdjusts = BusinessDataServiceHelper.load((String)"cal_costadjust_subentity", (String)this.getEntityFields("cal_costadjust_subentity"), (QFilter[])q.toArray())) {
            costAdjustAllSet.add(dynamicObject);
            preCostAdjustMap.put(costAdjustId2InvIdMap.get(((DynamicObject)dynamicObject.getDynamicObjectCollection("entryentity").get(0)).getLong("srcbillid")), dynamicObject);
        }
        q = new QFilter("bizbillid", "in", bizbillIds);
        q.and("costaccount", "in", costAccountIds);
        q.and("issplitcreate", "=", (Object)Boolean.FALSE);
        q.and("calbilltype", "=", (Object)this.calBillType);
        q.and("id", "in", srcCostRecordIds);
        HashMap<Long, Boolean> srcCostRecordMap = new HashMap<Long, Boolean>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,bizbillid,costaccount,istempvoucher", (QFilter[])q.toArray(), null);){
            for (Object row : dataSet) {
                srcCostRecordMap.put(row.getLong("id"), row.getBoolean("istempvoucher"));
            }
        }
        q = new QFilter("bizbillid", "in", bizbillIds);
        q.and("costaccount", "in", costAccountIds);
        q.and("issplitcreate", "=", (Object)Boolean.TRUE);
        q.and("writeoffstatus", "=", (Object)"B");
        q.and("calbilltype", "=", (Object)this.calBillType);
        q.and("entry.ancestorbillid", "in", srcCostRecordIds);
        HashMap<Long, HashMap<Long, Boolean>> costRecordBMap = new HashMap<Long, HashMap<Long, Boolean>>(16);
        Throwable throwable = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,writeoffperiod,bizbillid,costaccount,istempvoucher,entry.ancestorbillid", (QFilter[])q.toArray(), null);){
            for (Row row : dataSet) {
                Long ancestorbillid = row.getLong("entry.ancestorbillid");
                HashMap<Long, Boolean> periodTempVoucher = (HashMap<Long, Boolean>)costRecordBMap.get(ancestorbillid);
                if (periodTempVoucher == null) {
                    periodTempVoucher = new HashMap<Long, Boolean>(16);
                    costRecordBMap.put(ancestorbillid, periodTempVoucher);
                }
                periodTempVoucher.put(row.getLong("writeoffperiod"), row.getBoolean("istempvoucher"));
            }
        }
        catch (Throwable row) {
            Throwable throwable2 = row;
            throw row;
        }
        HashSet<Long> chargeOffCostRecordAIds = new HashSet<Long>(costRecordAs.length);
        HashMap<Long, Long> hashMap = new HashMap<Long, Long>(costRecordAs.length);
        HashMap<Long, Date> chargeOffDateMap = new HashMap<Long, Date>(costRecordAs.length);
        HashSet<DynamicObject> chargeOffCostRecords = new HashSet<DynamicObject>(costRecordAs.length);
        HashSet<DynamicObject> chargeOffAdjusts = new HashSet<DynamicObject>(costRecordAs.length);
        HashSet<DynamicObject> chargeOffstdcostdiffbills = new HashSet<DynamicObject>(costRecordAs.length);
        Map curPeriodMap = PeriodHelper.getCurrentPeriods(costAccountIds);
        HashSet<Long> noWriteChildEntryIds = new HashSet<Long>(costRecordAs.length);
        for (DynamicObject oldCostRecord : costRecordAs) {
            DynamicObject oldPreCostAdjust;
            Set stdcostdiffbillSet;
            for (DynamicObject entry : oldCostRecord.getDynamicObjectCollection("entry")) {
                noWriteChildEntryIds.add(entry.getLong("id"));
            }
            Date oldWriteOffDate = oldCostRecord.getDate("writeoffdate");
            Long costAccountId = oldCostRecord.getDynamicObject("costaccount").getLong("id");
            String dischargeType = oldCostRecord.getString("dischargetype");
            Date writeOffDate = this.getRedWriteOffDate(oldWriteOffDate, bookedDate, costAccountId, curPeriodMap);
            DynamicObject writeOffPeriodInfo = PeriodHelper.getPeriodByDate((Date)writeOffDate, (Long)costAccountId);
            Boolean isTempVoucher = false;
            if (DischargeTypeEnum.BILLCOMECLEAR.getValue().equals(dischargeType)) {
                Long ancestorbillid = ((DynamicObject)oldCostRecord.getDynamicObjectCollection("entry").get(0)).getLong("ancestorbillid");
                if (((Boolean)srcCostRecordMap.get(ancestorbillid)).booleanValue()) {
                    isTempVoucher = true;
                } else {
                    Map periodTempVoucher = (Map)costRecordBMap.get(ancestorbillid);
                    if (periodTempVoucher != null && !periodTempVoucher.isEmpty()) {
                        for (Map.Entry e : periodTempVoucher.entrySet()) {
                            if ((Long)e.getKey() >= writeOffPeriodInfo.getLong("id") || !((Boolean)e.getValue()).booleanValue()) continue;
                            isTempVoucher = true;
                            break;
                        }
                    }
                }
            }
            int writeOffPeriodNumber = writeOffPeriodInfo.getInt("periodyear") * 100 + writeOffPeriodInfo.getInt("periodnumber");
            this.handleCostRecord(oldCostRecord, chargeOffCostRecords, chargeOffCostRecordAIds, hashMap, chargeOffDateMap, writeOffPeriodInfo, writeOffDate, writeOffPeriodNumber, chargeOffReason, isTempVoucher);
            Set oldCostAdjust = (Set)costAdjustMap.get(oldCostRecord.getLong("id"));
            if (oldCostAdjust != null && !oldCostAdjust.isEmpty()) {
                for (Object info : oldCostAdjust) {
                    this.handleCostAdjust((DynamicObject)info, chargeOffAdjusts, writeOffPeriodInfo, writeOffDate, writeOffPeriodNumber, chargeOffReason);
                }
            }
            if ((stdcostdiffbillSet = (Set)stdcostdiffbillMap.get(oldCostRecord.getLong("id"))) != null && !stdcostdiffbillSet.isEmpty()) {
                Object info;
                info = stdcostdiffbillSet.iterator();
                while (info.hasNext()) {
                    DynamicObject info2 = (DynamicObject)info.next();
                    this.handleStdcostdiffbill(info2, chargeOffstdcostdiffbills, writeOffPeriodInfo, writeOffDate, writeOffPeriodNumber, chargeOffReason);
                }
            }
            if ((oldPreCostAdjust = (DynamicObject)preCostAdjustMap.get(oldCostRecord.getLong("id"))) == null) continue;
            this.handleCostAdjust(oldPreCostAdjust, chargeOffAdjusts, writeOffPeriodInfo, writeOffDate, writeOffPeriodNumber, chargeOffReason);
        }
        this.addNewRecordB(chargeOffCostRecords, srcCostRecordIds, noWriteChildEntryIds, costRecordAs);
        this.billsWriteToDB(chargeOffCostRecords, costRecordAs, chargeOffAdjusts, costAdjustAllSet, chargeOffstdcostdiffbills, stdcostdiffbillAllSet);
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fbizbillid", FilterType.in_range, bizbillIds)});){
            ctx.set();
            this.writeBackRecordB(chargeOffCostRecordAIds, bizbillIds, noWriteChildEntryIds);
        }
        this.addNewRecordB(costRecordAs, hashMap, chargeOffDateMap, srcCostRecordIds, noWriteChildEntryIds);
        if (!noWriteChildEntryIds.isEmpty()) {
            ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fbizbillid", FilterType.in_range, bizbillIds)});
            var30_60 = null;
            try {
                ctx.set();
                this.writeBackRecordB(chargeOffCostRecordAIds, bizbillIds, noWriteChildEntryIds);
            }
            catch (Throwable throwable3) {
                var30_60 = throwable3;
                throw throwable3;
            }
            finally {
                if (ctx != null) {
                    if (var30_60 != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable4) {
                            var30_60.addSuppressed(throwable4);
                        }
                    } else {
                        ctx.close();
                    }
                }
            }
        }
        Map<Long, Long> writeOffEndPeriodMap = this.clearWriteOffEndPeriod(srcCostRecordIds, bizbillIds);
        this.writeBackAncestorBillVerifyField(srcCostRecordIds, false, bizbillIds);
        return writeOffEndPeriodMap;
    }

    private void doUnChargeOff(Set<Long> srcWriteOffRecordIds) {
        this.chargeOffWriteRecord4RollBack(srcWriteOffRecordIds, null);
    }

    private void addNewRecordB(Set<DynamicObject> chargeOffCostRecords, Set<Long> srcCostRecordIds, Set<Long> noWriteChildEntryIds, DynamicObject[] costRecordAs) {
        Set<String> bizIdAcctIdWfPeriodKeys = this.getBizIdAcctIdWfPeriodKeys(chargeOffCostRecords, srcCostRecordIds);
        logger.info("writeoffperiod,ancestorbillid==>{}", bizIdAcctIdWfPeriodKeys);
        HashMap<Long, DynamicObject> needAddBAncestorBillIDycMap = new HashMap<Long, DynamicObject>(16);
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        HashSet<Long> acctIds = new HashSet<Long>(16);
        for (DynamicObject info : chargeOffCostRecords) {
            DynamicObjectCollection entryDycs;
            long ancestorBillId;
            long bizbillId = info.getLong("bizbillid");
            long costaccountId = info.getDynamicObject("costaccount").getLong("id");
            DynamicObject writeOffPeriod = info.getDynamicObject("writeoffperiod");
            long writeoffPeriodId = writeOffPeriod.getLong("id");
            String key = this.buildBizIdAcctIdWfPeriodKey(writeoffPeriodId, ancestorBillId = ((DynamicObject)(entryDycs = info.getDynamicObjectCollection("entry")).get(0)).getLong("ancestorbillid"));
            if (bizIdAcctIdWfPeriodKeys.contains(key)) continue;
            needAddBAncestorBillIDycMap.put(ancestorBillId, info);
            bizBillIds.add(bizbillId);
            acctIds.add(costaccountId);
        }
        logger.info("needAddBAncestorBillIDycMap==>{}", needAddBAncestorBillIDycMap.keySet());
        if (needAddBAncestorBillIDycMap.isEmpty()) {
            return;
        }
        Set<Long> maxBeforeBRecIds = this.getMaxBeforeBRecIds(needAddBAncestorBillIDycMap, bizBillIds, acctIds);
        logger.info("maxBeforeBRecIds==>{}", maxBeforeBRecIds);
        this.createBRecs(maxBeforeBRecIds, needAddBAncestorBillIDycMap, noWriteChildEntryIds, costRecordAs);
    }

    private void createBRecs(Set<Long> maxBeforeBRecIds, Map<Long, DynamicObject> needAddBAncestorBillIDycMap, Set<Long> noWriteChildEntryIds, DynamicObject[] costRecordAs) {
        HashMap<Long, Map> ancIdAncEIdCostRecAMap = new HashMap<Long, Map>(16);
        for (DynamicObject srcCostRecADyc : costRecordAs) {
            DynamicObjectCollection entryDycs = srcCostRecADyc.getDynamicObjectCollection("entry");
            long ancestorBillId = ((DynamicObject)entryDycs.get(0)).getLong("ancestorbillid");
            Map ancEIdCostRecEntryAMap = ancIdAncEIdCostRecAMap.computeIfAbsent(ancestorBillId, k -> new HashMap(16));
            for (DynamicObject entryDyc : entryDycs) {
                ancEIdCostRecEntryAMap.put(entryDyc.getLong("ancestorentryid"), entryDyc);
            }
        }
        HashSet billBNos = new HashSet(4);
        Lists.partition(new ArrayList<Long>(maxBeforeBRecIds), (int)5000).forEach(list -> {
            DynamicObject[] recordBs;
            QFilter idsF = new QFilter("id", "in", list);
            for (DynamicObject recordB : recordBs = BusinessDataServiceHelper.load((String)"cal_costrecord_subentity", (String)this.getEntityFields("cal_costrecord_subentity"), (QFilter[])idsF.toArray(), null)) {
                DynamicObject infoB = this.cloneCostRecord(recordB, "cal_costrecord_subentity");
                DynamicObjectCollection entryDycs = infoB.getDynamicObjectCollection("entry");
                long ancestorBillId = ((DynamicObject)entryDycs.get(0)).getLong("ancestorbillid");
                DynamicObject chargeCostRecDyc = (DynamicObject)needAddBAncestorBillIDycMap.get(ancestorBillId);
                DynamicObject writeOffPeriod = chargeCostRecDyc.getDynamicObject("writeoffperiod");
                long writeoffPeriodId = writeOffPeriod.getLong("id");
                infoB.set("writeoffperiod_id", (Object)writeoffPeriodId);
                infoB.set("writeoffdate", (Object)chargeCostRecDyc.getDate("writeoffdate"));
                infoB.set("writeoffstatus", (Object)"B");
                infoB.set("writeofftype", null);
                infoB.set("ischargeoff", (Object)Boolean.FALSE);
                infoB.set("ischargeoffed", (Object)Boolean.FALSE);
                infoB.set("writeoffendperiod_id", (Object)0L);
                String srcBillNo = infoB.getString("billnumber");
                int periodNumber = writeOffPeriod.getInt("periodyear") * 100 + writeOffPeriod.getInt("periodnumber");
                String value = srcBillNo + "-B-" + periodNumber;
                billBNos.add(value);
                infoB.set("billno", (Object)value);
                infoB.set("isvoucher", (Object)Boolean.FALSE);
                infoB.set("isfivoucher", (Object)Boolean.FALSE);
                infoB.set("istempvoucher", (Object)Boolean.FALSE);
                infoB.set("isdischargevoucher", (Object)Boolean.FALSE);
                infoB.set("iscostcarryover", (Object)Boolean.FALSE);
                infoB.set("isfeevoucher", (Object)Boolean.FALSE);
                infoB.set("fivouchernum", null);
                infoB.set("tempvouchernum", null);
                infoB.set("dischargevouchernum", null);
                infoB.set("carryovervouchernum", null);
                infoB.set("feevouchernum", null);
                infoB.set("fivoucherid", null);
                infoB.set("tempvoucherid", null);
                infoB.set("dischargevoucherid", null);
                infoB.set("carryovervoucherid", null);
                infoB.set("feevoucherid", null);
                DynamicObjectCollection entryBs = infoB.getDynamicObjectCollection("entry");
                HashMap<Long, DynamicObject> ancEidEntryBMap = new HashMap<Long, DynamicObject>(16);
                for (DynamicObject entryB : entryBs) {
                    entryB.set("writeoffid", (Object)0L);
                    ancEidEntryBMap.put(entryB.getLong("ancestorentryid"), entryB);
                }
                Map curAncEidCostRecAMap = (Map)ancIdAncEIdCostRecAMap.get(ancestorBillId);
                if (curAncEidCostRecAMap != null) {
                    for (Map.Entry curAncEidCostRecAEntry : curAncEidCostRecAMap.entrySet()) {
                        Long ancEid = (Long)curAncEidCostRecAEntry.getKey();
                        DynamicObject entryA = (DynamicObject)curAncEidCostRecAEntry.getValue();
                        if (ancEidEntryBMap.get(ancEid) != null) continue;
                        DynamicObject newEntry = entryBs.addNew();
                        DynamicObjectUtils.copy((DynamicObject)entryA, (DynamicObject)newEntry);
                        newEntry.set("writeoffid", (Object)0L);
                        noWriteChildEntryIds.remove(entryA.getLong("id"));
                    }
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{infoB});
            }
        });
        logger.info("createBRecs==>{}", billBNos);
    }

    private Set<Long> getMaxBeforeBRecIds(Map<Long, DynamicObject> needAddBAncestorBillIdWfPeriodMap, Set<Long> bizBillIds, Set<Long> acctIds) {
        QFilter q = new QFilter("bizbillid", "in", bizBillIds);
        q.and("costaccount", "in", acctIds);
        q.and("writeoffstatus", "=", (Object)"B");
        q.and("issplitcreate", "=", (Object)Boolean.TRUE);
        q.and("calbilltype", "=", (Object)this.calBillType);
        q.and("entry.ancestorbillid", "in", needAddBAncestorBillIdWfPeriodMap.keySet());
        String select = "id,writeoffendperiod,writeoffperiod,entry.ancestorbillid ancestorbillid";
        HashSet<Long> hasAddAncIds = new HashSet<Long>(16);
        HashSet<Long> maxBeforeBRecIds = new HashSet<Long>(16);
        DataSet maxBeforeBDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)select, (QFilter[])q.toArray(), null).orderBy(new String[]{"writeoffperiod desc"});
        for (Row row : maxBeforeBDs) {
            DynamicObject writeOffPeriod;
            long wfPeriod;
            Long ancestorBillId = row.getLong("ancestorbillid");
            Long writeoffPeriodId = row.getLong("writeoffperiod");
            Long writeoffendperiod = row.getLong("writeoffendperiod");
            DynamicObject costRecDyc = needAddBAncestorBillIdWfPeriodMap.get(ancestorBillId);
            if (costRecDyc == null || hasAddAncIds.contains(ancestorBillId) || writeoffendperiod != null && writeoffendperiod != 0L || (wfPeriod = (writeOffPeriod = costRecDyc.getDynamicObject("writeoffperiod")).getLong("id")) <= writeoffPeriodId) continue;
            maxBeforeBRecIds.add(row.getLong("id"));
            hasAddAncIds.add(ancestorBillId);
        }
        return maxBeforeBRecIds;
    }

    private String buildBizIdAcctIdWfPeriodKey(long writeoffPeriodId, long ancestorBillId) {
        StringBuilder sb = new StringBuilder();
        sb.append(writeoffPeriodId).append(",").append(ancestorBillId);
        String key = sb.toString();
        return key;
    }

    private Set<String> getBizIdAcctIdWfPeriodKeys(Set<DynamicObject> chargeOffCostRecords, Set<Long> srcCostRecordIds) {
        HashSet<String> bizIdAcctIdWfPeriodKeys = new HashSet<String>(16);
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        HashSet<Long> acctIds = new HashSet<Long>(16);
        HashSet<Long> wfPeriodIds = new HashSet<Long>(16);
        for (DynamicObject info : chargeOffCostRecords) {
            long bizbillId = info.getLong("bizbillid");
            long costaccountId = info.getDynamicObject("costaccount").getLong("id");
            DynamicObject writeOffPeriod = info.getDynamicObject("writeoffperiod");
            long writeoffPeriodId = writeOffPeriod.getLong("id");
            bizBillIds.add(bizbillId);
            acctIds.add(costaccountId);
            wfPeriodIds.add(writeoffPeriodId);
        }
        QFilter q = new QFilter("bizbillid", "in", bizBillIds);
        q.and("costaccount", "in", acctIds);
        q.and("writeoffperiod", "in", wfPeriodIds);
        q.and("issplitcreate", "=", (Object)Boolean.TRUE);
        q.and("calbilltype", "=", (Object)this.calBillType);
        q.and("entry.ancestorbillid", "in", srcCostRecordIds);
        logger.info("getBizIdAcctIdWfPeriodKeys-filter==>{}", (Object)q);
        String selectFields = "bizbillid,costaccount,writeoffperiod,entry.ancestorbillid ancestorbillid";
        DataSet costRecDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)selectFields, (QFilter[])q.toArray(), null);
        for (Row row : costRecDs) {
            String key = this.buildBizIdAcctIdWfPeriodKey(row.getLong("writeoffperiod"), row.getLong("ancestorbillid"));
            bizIdAcctIdWfPeriodKeys.add(key);
        }
        return bizIdAcctIdWfPeriodKeys;
    }

    public void chargeOffWriteRecord4RollBack(Set<Long> srcWriteOffRecordIds, Map<Long, Long> writeOffEndPeriodMap) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                if (this.bizBillIdsCache == null || this.bizBillIdsCache.isEmpty()) {
                    this.filterRecordIds(srcWriteOffRecordIds);
                }
                this.doChargeOffWriteRecord4RollBack(srcWriteOffRecordIds, writeOffEndPeriodMap);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private void doChargeOffWriteRecord4RollBack(Set<Long> srcWriteOffRecordIds, Map<Long, Long> writeOffEndPeriodMap) {
        Set<Long> bEntryIds;
        logger.info("\u6838\u7b97\u51b2\u9500\u63a5\u53e3\u5904\u7406\u5f00\u59cb\uff08\u56de\u6eda\uff09");
        long startTime = System.currentTimeMillis();
        QFilter q = new QFilter("entry.writeoffid", "in", srcWriteOffRecordIds);
        q.and("bizbillid", "in", this.bizBillIdsCache);
        HashSet<Long> srcCostRecordAIds = new HashSet<Long>(srcWriteOffRecordIds.size());
        HashSet<Long> chargeOffCostRecordAIds = new HashSet<Long>(srcWriteOffRecordIds.size());
        HashSet<Long> srcCostRecordIds = new HashSet<Long>(srcWriteOffRecordIds.size());
        HashSet<Long> bizbillIds = new HashSet<Long>(srcWriteOffRecordIds.size());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,ischargeoff,bizbillid,calbilltype,entry.ancestorbillid", (QFilter[])q.toArray(), null);){
            for (Row row : dataSet) {
                this.calBillType = row.getString("calbilltype");
                srcCostRecordIds.add(row.getLong("entry.ancestorbillid"));
                bizbillIds.add(row.getLong("bizbillid"));
                if (row.getBoolean("ischargeoff").booleanValue()) {
                    chargeOffCostRecordAIds.add(row.getLong("id"));
                    continue;
                }
                srcCostRecordAIds.add(row.getLong("id"));
            }
        }
        if (chargeOffCostRecordAIds.isEmpty()) {
            logger.info("\u6838\u7b97\u51b2\u9500\u63a5\u53e3\u5904\u7406\u7ed3\u675f\uff08\u56de\u6eda\uff09\uff0c\u4f46\u662f\u5e76\u672a\u627e\u5230\u51b2\u9500\u5b50\u5355\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime) + "ms");
            return;
        }
        ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fbizbillid", FilterType.in_range, bizbillIds)});
        Object object = null;
        try {
            ctx.set();
            bEntryIds = this.writeBackRecordB(srcCostRecordAIds, bizbillIds, null);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ctx != null) {
                if (object != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ctx.close();
                }
            }
        }
        this.deleteRecordB(bEntryIds);
        this.deleteChargeBills(chargeOffCostRecordAIds, srcCostRecordAIds);
        this.rollBackWriteOffEndPeriod(writeOffEndPeriodMap, bizbillIds);
        this.writeBackAncestorBillVerifyField(srcCostRecordIds, true, bizbillIds);
        logger.info("\u6838\u7b97\u51b2\u9500\u63a5\u53e3\u5904\u7406\u7ed3\u675f\uff08\u56de\u6eda\uff09\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime) + "ms");
    }

    private void rollBackWriteOffEndPeriod(Map<Long, Long> writeOffEndPeriodMap, Set<Long> bizbillIds) {
        DynamicObject[] srcWriteBackRecords;
        DynamicObject[] writeBackRecords;
        if (writeOffEndPeriodMap == null || writeOffEndPeriodMap.isEmpty()) {
            return;
        }
        QFilter q = new QFilter("entry.ancestorbillid", "in", writeOffEndPeriodMap.keySet());
        q.and("bizbillid", "in", bizbillIds);
        for (DynamicObject costRecordDyc : writeBackRecords = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)"id,writeoffendperiod,entry.ancestorbillid", (QFilter[])q.toArray())) {
            long ancestorbillid = ((DynamicObject)costRecordDyc.getDynamicObjectCollection("entry").get(0)).getLong("ancestorbillid");
            costRecordDyc.set("writeoffendperiod", (Object)writeOffEndPeriodMap.get(ancestorbillid));
        }
        SaveServiceHelper.save((DynamicObject[])writeBackRecords);
        q = new QFilter("id", "in", writeOffEndPeriodMap.keySet());
        q.and("bizbillid", "in", bizbillIds);
        for (DynamicObject costRecordDyc : srcWriteBackRecords = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)"id,writeoffendperiod", (QFilter[])q.toArray())) {
            costRecordDyc.set("writeoffendperiod", (Object)writeOffEndPeriodMap.get(costRecordDyc.getLong("id")));
        }
        SaveServiceHelper.save((DynamicObject[])srcWriteBackRecords);
    }

    private void deleteChargeBills(Set<Long> chargeOffCostRecordAIds, Set<Long> srcCostRecordAIds) {
        DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"cal_costrecord_subentity"), (Object[])chargeOffCostRecordAIds.toArray());
        QFilter q = new QFilter("entryentity.invbillid", "in", srcCostRecordAIds);
        q.and("ischargeoff", "=", (Object)Boolean.TRUE);
        new AdjBillDeleteHelper().delete(q);
        String sql = "update t_cal_calcostrecord set fischargeoffed = '0' where fid in " + DBUtil.getInStringFromSet2(srcCostRecordAIds);
        DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql);
    }

    private void deleteRecordB(Set<Long> bEntryIds) {
        DynamicObject[] infos;
        QFilter q = new QFilter("entry.id", "in", bEntryIds);
        for (DynamicObject info : infos = BusinessDataServiceHelper.load((String)"cal_costrecord_subentity", (String)"id,entry.id,entry.baseqty", (QFilter[])q.toArray())) {
            Iterator iterator = info.getDynamicObjectCollection("entry").iterator();
            while (iterator.hasNext()) {
                DynamicObject entry = (DynamicObject)iterator.next();
                BigDecimal baseQty = entry.getBigDecimal("baseqty");
                if (BigDecimal.ZERO.compareTo(baseQty) != 0) continue;
                iterator.remove();
            }
        }
        SaveServiceHelper.save((DynamicObject[])infos);
        HashSet<Long> delIds = new HashSet<Long>(bEntryIds.size());
        for (DynamicObject dynamicObject : infos) {
            if (!dynamicObject.getDynamicObjectCollection("entry").isEmpty()) continue;
            delIds.add(dynamicObject.getLong("id"));
        }
        if (!delIds.isEmpty()) {
            DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"cal_costrecord_subentity"), (Object[])delIds.toArray());
        }
        if (!bEntryIds.isEmpty()) {
            HashSet<Long> bizbillIds = new HashSet<Long>(16);
            HashSet<Long> costaccountIds = new HashSet<Long>(16);
            q = new QFilter("entry.id", "in", bEntryIds);
            Throwable throwable = null;
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,bizbillid,costaccount", (QFilter[])q.toArray(), null);){
                for (Row row : dataSet) {
                    bizbillIds.add(row.getLong("bizbillid"));
                    costaccountIds.add(row.getLong("costaccount"));
                }
            }
            catch (Throwable entry) {
                Throwable throwable2 = entry;
                throw entry;
            }
            QFilter qb = new QFilter("entry.id", "in", bEntryIds);
            QFilter qFilter = new QFilter("costaccount", "in", costaccountIds);
            qFilter.and("bizbillid", "in", bizbillIds);
            qFilter.and("issplitcreate", "=", (Object)Boolean.TRUE);
            qFilter.and("writeoffstatus", "=", (Object)"A");
            try (DataSet dataSetB = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,writeoffperiod,bizbillid,costaccount", (QFilter[])qb.toArray(), null);
                 DataSet dataSetA = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,writeoffperiod,bizbillid,costaccount", (QFilter[])qFilter.toArray(), null);
                 DataSet joinSet = dataSetB.leftJoin(dataSetA).on("writeoffperiod", "writeoffperiod").on("bizbillid", "bizbillid").on("costaccount", "costaccount").select(new String[]{"id as bid"}, new String[]{"id as aid"}).finish();){
                HashSet<Long> delbid = new HashSet<Long>(16);
                for (Row row : joinSet) {
                    Long aid = row.getLong("aid");
                    if (aid != null) continue;
                    delbid.add(row.getLong("bid"));
                }
                if (!delbid.isEmpty()) {
                    QFilter filter = new QFilter("id", "in", delbid);
                    DeleteServiceHelper.delete((String)"cal_costrecord_subentity", (QFilter[])filter.toArray());
                }
            }
        }
    }

    private void doCheck(Set<Long> srcWriteOffRecordIds, DynamicObject[] costRecordAs) {
        DynamicObject[] srcCostRecords;
        HashSet<Long> unSyncRecordIds = new HashSet<Long>(srcWriteOffRecordIds);
        HashSet<Long> srcCostRecordIds = new HashSet<Long>(costRecordAs.length);
        for (DynamicObject info : costRecordAs) {
            for (DynamicObject entry : info.getDynamicObjectCollection("entry")) {
                srcCostRecordIds.add(entry.getLong("ancestorbillid"));
                unSyncRecordIds.remove(entry.getLong("writeoffid"));
            }
        }
        if (!unSyncRecordIds.isEmpty()) {
            this.noSplitBill();
        }
        QFilter q = new QFilter("id", "in", srcCostRecordIds);
        for (DynamicObject srcCostRecord : srcCostRecords = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)"id,billno,entry.id,entry.subentryentity.id,entry.subentryentityest.id", (QFilter[])q.toArray())) {
            for (DynamicObject entry : srcCostRecord.getDynamicObjectCollection("entry")) {
                if (entry.getDynamicObjectCollection("subentryentity").isEmpty() && entry.getDynamicObjectCollection("subentryentityest").isEmpty()) continue;
                String content = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5df2\u8d39\u7528\u6682\u4f30\u8fc7\u6216\u8d39\u7528\u5206\u644a\u8fc7\u3002", (String)"CalChargeOffHelper_6", (String)"fi-cal-mservice", (Object[])new Object[0]), srcCostRecord.getString("billno"));
                throw new KDBizException(content);
            }
        }
    }

    private void handleCostRecord(DynamicObject oldCostRecord, Set<DynamicObject> chargeOffCostRecords, Set<Long> chargeOffCostRecordAIds, Map<Long, Long> chargeOffPeriodMap, Map<Long, Date> chargeOffDateMap, DynamicObject writeOffPeriodInfo, Date writeOffDate, int writeOffPeriodNumber, String chargeOffReason, Boolean isTempVoucher) {
        logger.info("\u88ab\u51b2\u9500\u5b50\u5355\uff1a" + oldCostRecord.getString("billno"));
        DynamicObject chargeOffCostRecord = this.cloneCostRecord(oldCostRecord, "cal_costrecord_subentity");
        chargeOffCostRecords.add(chargeOffCostRecord);
        Long chargeOffBillId = DB.genLongId((String)"t_cal_calcostrecord");
        chargeOffCostRecordAIds.add(chargeOffBillId);
        chargeOffCostRecord.set("id", (Object)chargeOffBillId);
        this.costRecordToRed(chargeOffCostRecord);
        chargeOffCostRecord.set("writeoffdate", (Object)writeOffDate);
        chargeOffPeriodMap.put(oldCostRecord.getLong("id"), writeOffPeriodInfo.getLong("id"));
        chargeOffDateMap.put(oldCostRecord.getLong("id"), writeOffDate);
        chargeOffCostRecord.set("billno", (Object)("HC-" + writeOffPeriodNumber + "-" + oldCostRecord.getString("billno")));
        chargeOffCostRecord.set("writeoffperiod", (Object)writeOffPeriodInfo);
        chargeOffCostRecord.set("comment", (Object)chargeOffReason);
        chargeOffCostRecord.set("ischargeoff", (Object)Boolean.TRUE);
        chargeOffCostRecord.set("writeoffendperiod", (Object)0L);
        chargeOffCostRecord.set("isfivoucher", (Object)Boolean.FALSE);
        chargeOffCostRecord.set("isvoucher", (Object)isTempVoucher);
        chargeOffCostRecord.set("istempvoucher", (Object)isTempVoucher);
        chargeOffCostRecord.set("isdischargevoucher", (Object)Boolean.FALSE);
        chargeOffCostRecord.set("iscostcarryover", (Object)Boolean.FALSE);
        chargeOffCostRecord.set("isfeevoucher", (Object)Boolean.FALSE);
        chargeOffCostRecord.set("fivouchernum", null);
        chargeOffCostRecord.set("tempvouchernum", null);
        chargeOffCostRecord.set("dischargevouchernum", null);
        chargeOffCostRecord.set("carryovervouchernum", null);
        chargeOffCostRecord.set("feevouchernum", null);
        chargeOffCostRecord.set("fivoucherid", null);
        chargeOffCostRecord.set("tempvoucherid", null);
        chargeOffCostRecord.set("dischargevoucherid", null);
        chargeOffCostRecord.set("carryovervoucherid", null);
        chargeOffCostRecord.set("feevoucherid", null);
        int i = 0;
        for (DynamicObject costRecordEntry : chargeOffCostRecord.getDynamicObjectCollection("entry")) {
            costRecordEntry.set("srcbillid", (Object)oldCostRecord.getLong("id"));
            costRecordEntry.set("srcbillentryid", (Object)((DynamicObject)oldCostRecord.getDynamicObjectCollection("entry").get(i)).getLong("id"));
            ++i;
        }
        oldCostRecord.set("ischargeoffed", (Object)Boolean.TRUE);
    }

    private void handleCostAdjust(DynamicObject oldCostAdjust, Set<DynamicObject> chargeOffAdjusts, DynamicObject writeOffPeriodInfo, Date writeOffDate, int writeOffPeriodNumber, String chargeOffReason) {
        logger.info("\u88ab\u51b2\u9500\u6210\u672c\u8c03\u6574\u5355\uff1a" + oldCostAdjust.getString("billno"));
        DynamicObject chargeOffCostAdjust = this.cloneCostRecord(oldCostAdjust, "cal_costadjust_subentity");
        chargeOffAdjusts.add(chargeOffCostAdjust);
        this.costAdjustToRed(chargeOffCostAdjust);
        chargeOffCostAdjust.set("bizdate", (Object)writeOffDate);
        chargeOffCostAdjust.set("bookdate", (Object)writeOffDate);
        chargeOffCostAdjust.set("period", (Object)writeOffPeriodInfo);
        chargeOffCostAdjust.set("billno", (Object)("HC-" + writeOffPeriodNumber + "-" + oldCostAdjust.getString("billno")));
        chargeOffCostAdjust.set("remark", (Object)chargeOffReason);
        chargeOffCostAdjust.set("billstatus", (Object)"B");
        chargeOffCostAdjust.set("ischargeoff", (Object)Boolean.TRUE);
        chargeOffCostAdjust.set("isvoucher", (Object)Boolean.FALSE);
        chargeOffCostAdjust.set("vouchernum", null);
        chargeOffCostAdjust.set("voucherid", null);
        oldCostAdjust.set("ischargeoffed", (Object)Boolean.TRUE);
    }

    private void handleStdcostdiffbill(DynamicObject oldCostAdjust, Set<DynamicObject> chargeOffAdjusts, DynamicObject writeOffPeriodInfo, Date writeOffDate, int writeOffPeriodNumber, String chargeOffReason) {
        WriteLogHelper.writeInfoLog((Log)logger, (String)("handleStdcostdiffbill\uff1a" + oldCostAdjust.getString("billno")), (Object[])new Object[0]);
        DynamicObject chargeOffCostAdjust = this.cloneCostRecord(oldCostAdjust, "cal_stdcostdiffbill");
        chargeOffAdjusts.add(chargeOffCostAdjust);
        this.costStdcostdiffbillToRed(chargeOffCostAdjust);
        chargeOffCostAdjust.set("bizdate", (Object)writeOffDate);
        chargeOffCostAdjust.set("bookdate", (Object)writeOffDate);
        chargeOffCostAdjust.set("period", (Object)writeOffPeriodInfo);
        chargeOffCostAdjust.set("billno", (Object)("HC-" + writeOffPeriodNumber + "-" + oldCostAdjust.getString("billno")));
        chargeOffCostAdjust.set("remark", (Object)chargeOffReason);
        chargeOffCostAdjust.set("billstatus", (Object)"B");
        chargeOffCostAdjust.set("ischargeoff", (Object)Boolean.TRUE);
        chargeOffCostAdjust.set("isvoucher", (Object)Boolean.FALSE);
        chargeOffCostAdjust.set("vouchernum", null);
        chargeOffCostAdjust.set("voucherid", null);
        oldCostAdjust.set("ischargeoffed", (Object)Boolean.TRUE);
    }

    private void costRecordToRed(DynamicObject costRecordInfo) {
        DynamicObjectCollection entrys = costRecordInfo.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entrys) {
            for (String field : COSTRECORD_RED_ENTRYFIELDS) {
                entry.set(field, (Object)entry.getBigDecimal(field).negate());
            }
            for (DynamicObject detail : entry.getDynamicObjectCollection("subentrycostelement")) {
                for (String field : COSTRECORD_RED_SUBENTRYFIELDS) {
                    detail.set(field, (Object)detail.getBigDecimal(field).negate());
                }
            }
        }
    }

    private void costAdjustToRed(DynamicObject costAdjustInfo) {
        DynamicObjectCollection entrys = costAdjustInfo.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entrys) {
            entry.set("adjustamt", (Object)entry.getBigDecimal("adjustamt").negate());
            for (DynamicObject detail : entry.getDynamicObjectCollection("subentryentity")) {
                detail.set("sub_adjustamt", (Object)detail.getBigDecimal("sub_adjustamt").negate());
            }
        }
    }

    private void costStdcostdiffbillToRed(DynamicObject costAdjustInfo) {
        DynamicObjectCollection entrys = costAdjustInfo.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entrys) {
            entry.set("adjustamt", (Object)entry.getBigDecimal("adjustamt").negate());
            for (String field : AMT_FIELDS) {
                BigDecimal fieldAmt = entry.getBigDecimal(field);
                if (fieldAmt == null) continue;
                entry.set(field, (Object)fieldAmt.negate());
            }
            for (DynamicObject detail : entry.getDynamicObjectCollection("subentryentity")) {
                detail.set("sub_adjustamt", (Object)detail.getBigDecimal("sub_adjustamt").negate());
                for (String field : SUB_AMT_FIELDS) {
                    BigDecimal fieldAmt = detail.getBigDecimal(field);
                    if (fieldAmt == null) continue;
                    detail.set(field, (Object)fieldAmt.negate());
                }
            }
        }
    }

    private void billsWriteToDB(Set<DynamicObject> chargeOffCostRecords, DynamicObject[] costRecordAs, Set<DynamicObject> chargeOffAdjusts, Set<DynamicObject> costAdjustAllSet, Set<DynamicObject> chargeOffstdcostdiffbills, Set<DynamicObject> stdcostdiffbillAllSet) {
        List errors;
        OperationResult result;
        OperateOption option;
        DynamicObject[] auditCostAdjusts;
        HashSet<Long> costAdjustIdSet;
        if (!chargeOffCostRecords.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])costRecordAs);
            SaveServiceHelper.save((DynamicObject[])chargeOffCostRecords.toArray(new DynamicObject[0]));
        }
        if (!chargeOffAdjusts.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])costAdjustAllSet.toArray(new DynamicObject[0]));
            SaveServiceHelper.save((DynamicObject[])chargeOffAdjusts.toArray(new DynamicObject[0]));
            costAdjustIdSet = new HashSet<Long>(chargeOffAdjusts.size());
            for (DynamicObject info : chargeOffAdjusts) {
                costAdjustIdSet.add(info.getLong("id"));
            }
            auditCostAdjusts = BusinessDataServiceHelper.load((Object[])costAdjustIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cal_costadjust_subentity"));
            option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            result = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_costadjust_subentity", (DynamicObject[])auditCostAdjusts, (OperateOption)option);
            errors = result.getAllErrorOrValidateInfo();
            if (!errors.isEmpty()) {
                StringBuilder msg = new StringBuilder();
                msg.append(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u5ba1\u6838\u5931\u8d25\uff1a", (String)"CalChargeOffHelper_2", (String)"fi-cal-mservice", (Object[])new Object[0]));
                for (IOperateInfo error : errors) {
                    OperateInfo operror = (OperateInfo)error;
                    msg.append(operror.getMessage()).append('\n');
                }
                throw new KDBizException(msg.toString());
            }
        }
        if (!chargeOffstdcostdiffbills.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])stdcostdiffbillAllSet.toArray(new DynamicObject[0]));
            SaveServiceHelper.save((DynamicObject[])chargeOffstdcostdiffbills.toArray(new DynamicObject[0]));
            costAdjustIdSet = new HashSet(chargeOffAdjusts.size());
            for (DynamicObject info : chargeOffstdcostdiffbills) {
                costAdjustIdSet.add(info.getLong("id"));
            }
            auditCostAdjusts = BusinessDataServiceHelper.load((Object[])costAdjustIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cal_stdcostdiffbill"));
            option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            result = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_stdcostdiffbill", (DynamicObject[])auditCostAdjusts, (OperateOption)option);
            errors = result.getAllErrorOrValidateInfo();
            if (!errors.isEmpty()) {
                StringBuilder msg = new StringBuilder();
                msg.append(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u5ba1\u6838\u5931\u8d25\uff1a", (String)"CalChargeOffHelper_2", (String)"fi-cal-mservice", (Object[])new Object[0]));
                for (IOperateInfo error : errors) {
                    OperateInfo operror = (OperateInfo)error;
                    msg.append(operror.getMessage()).append('\n');
                }
                throw new KDBizException(msg.toString());
            }
        }
    }

    private Date getRedWriteOffDate(Date oldWriteOffDate, Date bookedDate, Long costAccountId, Map<Long, DynamicObject> curPeriodMap) {
        DynamicObject curPeriod = curPeriodMap.get(costAccountId);
        if (curPeriod == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u672a\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"CalChargeOffHelper_3", (String)"fi-cal-mservice", (Object[])new Object[0]));
        }
        Date beginDate = curPeriod.getDate("begindate");
        Date maxDate = beginDate.compareTo(bookedDate) > 0 ? beginDate : bookedDate;
        maxDate = oldWriteOffDate.compareTo(maxDate) > 0 ? oldWriteOffDate : maxDate;
        return maxDate;
    }

    private Map<Long, List<String>> getVouSourceMap(Set<Long> idSet) {
        HashMap<Long, List<String>> vouSourceMap = new HashMap<Long, List<String>>(idSet.size());
        QFilter filter = new QFilter("costrecordid", "in", idSet);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_voucher", (String)"costrecordid,vouchersource", (QFilter[])new QFilter[]{filter});
        for (DynamicObject info : coll) {
            ArrayList<String> list = (ArrayList<String>)vouSourceMap.get(info.getLong("costrecordid"));
            if (list == null) {
                list = new ArrayList<String>(16);
                vouSourceMap.put(info.getLong("costrecordid"), list);
            }
            list.add(info.getString("vouchersource"));
        }
        return vouSourceMap;
    }

    private boolean hasVoucher(Long recordID, Map<Long, List<String>> vouSourceMap) {
        List<String> voucherSources = vouSourceMap.get(recordID);
        if (voucherSources == null) {
            return false;
        }
        for (String vouchersource : voucherSources) {
            if (!"A".equals(vouchersource) && !"B".equals(vouchersource)) continue;
            return true;
        }
        return false;
    }

    private Set<Long> writeBackRecordB(Set<Long> costRecordAIds, Set<Long> bizbillIds, Set<Long> noWriteChildEntryIds) {
        HashMap<Long, String> updateIdsMap = new HashMap<Long, String>();
        QFilter qa = new QFilter("id", "in", costRecordAIds);
        HashSet<Long> ancestorIds = new HashSet<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"entry.ancestorbillid", (QFilter[])qa.toArray(), null);){
            for (Row row : dataSet) {
                ancestorIds.add(row.getLong("entry.ancestorbillid"));
            }
        }
        QFilter qb = new QFilter("entry.ancestorbillid", "in", ancestorIds);
        qb.and("writeoffstatus", "=", (Object)"B");
        qb.and("bizbillid", "in", bizbillIds);
        HashMap<Long, HashMap<String, BigDecimal>> bMap = new HashMap<Long, HashMap<String, BigDecimal>>();
        String updateSql = "update t_cal_calcostrecordentry set fbaseqty = fbaseqty + ?,fmaterialcost = fmaterialcost + ?,fprocesscost = fprocesscost + ?,fstandardcost = fstandardcost + ?,ffee = ffee + ?,flocaltax = flocaltax + ?,factualcost = factualcost + ? where fentryid = ?";
        String updateSql_a = "update t_cal_calcostrecordentry set fmanufacturecost = fmanufacturecost + ?,fresource = fresource + ? where fentryid = ?";
        HashMap<Long, HashSet<Long>> abIdMap = new HashMap<Long, HashSet<Long>>();
        HashSet<Long> aIDs = new HashSet<Long>(16);
        DataSet dataSetA = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,entry.id,entry.srcbillentryid,entry.baseqty,entry.materialcost,entry.processcost,entry.standardcost,entry.fee,entry.manufacturecost,entry.resource,entry.localtax,entry.actualcost,entry.ancestorentryid,writeoffperiod", (QFilter[])qa.toArray(), null);
        Object object = null;
        try {
            Throwable throwable = null;
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,billno,entry.id,entry.ancestorentryid,writeoffperiod", (QFilter[])qb.toArray(), null);
                 DataSet joinSet2 = dataSet.join(dataSetA).on("entry.ancestorentryid", "entry.ancestorentryid").select(new String[]{"id as bid", "billno", "entry.id as bentryid", "writeoffperiod as bwriteoffperiod"}, new String[]{"id as aid", "entry.id as aentryid", "entry.srcbillentryid as asrcentryid", "entry.baseqty as abaseqty", "entry.materialcost as amaterialcost", "entry.processcost as aprocesscost", "entry.standardcost as astandardcost", "entry.fee as afee", "entry.manufacturecost as amanufacturecost", "entry.resource as aresource", "entry.localtax as alocaltax", "entry.actualcost as aactualcost", "writeoffperiod as awriteoffperiod"}).finish();){
                for (Row row : joinSet2) {
                    Long aWriteoffperiod = row.getLong("awriteoffperiod");
                    Long bWriteoffperiod = row.getLong("bwriteoffperiod");
                    if (aWriteoffperiod > bWriteoffperiod) continue;
                    Long bEntryId = row.getLong("bentryid");
                    Long aEntryId = row.getLong("aentryid");
                    Long aSrcEntryId = row.getLong("asrcentryid");
                    if (noWriteChildEntryIds != null && !noWriteChildEntryIds.contains(aSrcEntryId)) continue;
                    aIDs.add(aSrcEntryId);
                    updateIdsMap.put(row.getLong("bid"), row.getString("billno"));
                    HashMap<String, BigDecimal> aMap = (HashMap<String, BigDecimal>)bMap.get(bEntryId);
                    HashSet<Long> aidSet = (HashSet<Long>)abIdMap.get(bEntryId);
                    if (aidSet == null) {
                        aidSet = new HashSet<Long>();
                        abIdMap.put(bEntryId, aidSet);
                    }
                    aidSet.add(aEntryId);
                    if (aMap == null) {
                        aMap = new HashMap<String, BigDecimal>(16);
                        aMap.put("baseqty", row.getBigDecimal("abaseqty"));
                        aMap.put("materialcost", row.getBigDecimal("amaterialcost"));
                        aMap.put("processcost", row.getBigDecimal("aprocesscost"));
                        aMap.put("standardcost", row.getBigDecimal("astandardcost"));
                        aMap.put("fee", row.getBigDecimal("afee"));
                        aMap.put("manufacturecost", row.getBigDecimal("amanufacturecost"));
                        aMap.put("resource", row.getBigDecimal("aresource"));
                        aMap.put("localtax", row.getBigDecimal("alocaltax"));
                        aMap.put("actualcost", row.getBigDecimal("aactualcost"));
                        bMap.put(bEntryId, aMap);
                        continue;
                    }
                    aMap.put("baseqty", ((BigDecimal)aMap.get("baseqty")).add(row.getBigDecimal("abaseqty")));
                    aMap.put("materialcost", ((BigDecimal)aMap.get("materialcost")).add(row.getBigDecimal("amaterialcost")));
                    aMap.put("processcost", ((BigDecimal)aMap.get("processcost")).add(row.getBigDecimal("aprocesscost")));
                    aMap.put("standardcost", ((BigDecimal)aMap.get("standardcost")).add(row.getBigDecimal("astandardcost")));
                    aMap.put("fee", ((BigDecimal)aMap.get("fee")).add(row.getBigDecimal("afee")));
                    aMap.put("manufacturecost", ((BigDecimal)aMap.get("manufacturecost")).add(row.getBigDecimal("amanufacturecost")));
                    aMap.put("resource", ((BigDecimal)aMap.get("resource")).add(row.getBigDecimal("aresource")));
                    aMap.put("localtax", ((BigDecimal)aMap.get("localtax")).add(row.getBigDecimal("alocaltax")));
                    aMap.put("actualcost", ((BigDecimal)aMap.get("actualcost")).add(row.getBigDecimal("aactualcost")));
                }
            }
            catch (Throwable joinSet2) {
                Throwable throwable2 = joinSet2;
                throw joinSet2;
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSetA != null) {
                if (object != null) {
                    try {
                        dataSetA.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSetA.close();
                }
            }
        }
        if (noWriteChildEntryIds != null) {
            noWriteChildEntryIds.removeAll(aIDs);
        }
        if (!updateIdsMap.isEmpty()) {
            Map<Long, List<String>> vouSourceMap = this.getVouSourceMap(updateIdsMap.keySet());
            for (Map.Entry entry : updateIdsMap.entrySet()) {
                Long l = (Long)entry.getKey();
                String billNo = (String)entry.getValue();
                if (!this.hasVoucher(l, vouSourceMap)) continue;
                StringBuffer msg = new StringBuffer();
                msg.append(ResManager.loadKDString((String)"\u672a\u6838\u9500\u5355\u636e\uff1a", (String)"CalChargeOffHelper_4", (String)"fi-cal-mservice", (Object[])new Object[0])).append(billNo).append(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u5bfc\u81f4\u51b2\u9500\u5931\u8d25\uff0c\u8bf7\u5148\u5220\u9664\u51ed\u8bc1\u3002", (String)"CalChargeOffHelper_5", (String)"fi-cal-mservice", (Object[])new Object[0]));
                throw new KDBizException(msg.toString());
            }
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(bMap.size());
        ArrayList<Object[]> paramList_a = new ArrayList<Object[]>(bMap.size());
        for (Map.Entry entry : bMap.entrySet()) {
            Map aMap = (Map)entry.getValue();
            paramList.add(new Object[]{((BigDecimal)aMap.get("baseqty")).negate(), ((BigDecimal)aMap.get("materialcost")).negate(), ((BigDecimal)aMap.get("processcost")).negate(), ((BigDecimal)aMap.get("standardcost")).negate(), ((BigDecimal)aMap.get("fee")).negate(), ((BigDecimal)aMap.get("localtax")).negate(), ((BigDecimal)aMap.get("actualcost")).negate(), entry.getKey()});
            paramList_a.add(new Object[]{aMap.get("manufacturecost"), aMap.get("resource"), entry.getKey()});
        }
        if (!paramList.isEmpty()) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateSql, paramList);
        }
        if (!paramList_a.isEmpty()) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateSql_a, paramList_a);
        }
        if (abIdMap.isEmpty()) {
            return bMap.keySet();
        }
        HashSet hashSet = new HashSet();
        for (Set set : abIdMap.values()) {
            hashSet.addAll(set);
        }
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"cal_costrecord_detail", (String)"id,entryid,costsubelement,actualcost,unitactualcost,baseqty,standardcost,unitstandardcost", (QFilter[])new QFilter("entryid", "in", hashSet).toArray());
        if (dynamicObjectCollection == null || dynamicObjectCollection.isEmpty()) {
            return bMap.keySet();
        }
        HashMap<Long, HashSet<DynamicObject>> aInfoMap = new HashMap<Long, HashSet<DynamicObject>>();
        for (DynamicObject info : dynamicObjectCollection) {
            Long aEntryId = info.getLong("entryid");
            HashSet<DynamicObject> set = (HashSet<DynamicObject>)aInfoMap.get(aEntryId);
            if (set == null) {
                set = new HashSet<DynamicObject>();
                aInfoMap.put(aEntryId, set);
            }
            set.add(info);
        }
        String detailSql = "update t_cal_costrecord_detail set fbaseqty = fbaseqty + ?,factualcost = factualcost + ?,fstandardcost = fstandardcost + ? where fentryid = ? and fcostsubelementid = ?";
        ArrayList<Object[]> detailParamList = new ArrayList<Object[]>();
        for (Map.Entry entry : abIdMap.entrySet()) {
            Long bEntryId = (Long)entry.getKey();
            Set aEntryIds = (Set)entry.getValue();
            for (Long aEntryId : aEntryIds) {
                Set aInfoSet = (Set)aInfoMap.get(aEntryId);
                if (aInfoSet == null) continue;
                for (DynamicObject info : aInfoSet) {
                    detailParamList.add(new Object[]{info.getBigDecimal("baseqty").negate(), info.getBigDecimal("actualcost").negate(), info.getBigDecimal("standardcost").negate(), bEntryId, info.getLong("costsubelement")});
                }
            }
        }
        if (!detailParamList.isEmpty()) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)detailSql, detailParamList);
        }
        return bMap.keySet();
    }

    private void addNewRecordB(DynamicObject[] costRecords, Map<Long, Long> chargeOffPeriodMap, Map<Long, Date> chargeOffDateMap, Set<Long> srcCostRecordIds, Set<Long> noWriteChildEntryIds) {
        Map<String, Object[]> existAPeriodDate = this.getMaxAInfoMap(costRecords, chargeOffPeriodMap, chargeOffDateMap, srcCostRecordIds);
        Map<String, Long> ancIdWfIdBIdMap = this.getAncIdWfIdBIdMap(costRecords, existAPeriodDate);
        existAPeriodDate.keySet().removeAll(ancIdWfIdBIdMap.keySet());
        logger.info("existAPeriodDate.keySet()==>{}", existAPeriodDate.keySet());
        this.createRecordBHasANoB(costRecords, existAPeriodDate, noWriteChildEntryIds, chargeOffPeriodMap, chargeOffDateMap);
        this.addEntryB(costRecords, noWriteChildEntryIds, ancIdWfIdBIdMap);
    }

    private void addEntryB(DynamicObject[] costRecords, Set<Long> noWriteChildEntryIds, Map<String, Long> ancIdWfIdBIdMap) {
        if (ancIdWfIdBIdMap.isEmpty()) {
            return;
        }
        HashSet<Long> existBIds = new HashSet<Long>(ancIdWfIdBIdMap.values());
        HashMap<Long, Set> ansIdBIdsMap = new HashMap<Long, Set>(16);
        for (Map.Entry<String, Long> entry : ancIdWfIdBIdMap.entrySet()) {
            DynamicObject[] ansId = Long.valueOf(entry.getKey().split(",")[1]);
            Set bIds = ansIdBIdsMap.computeIfAbsent((Long)ansId, k -> new HashSet(16));
            bIds.add(entry.getValue());
        }
        DynamicObject[] existBInfos = BusinessDataServiceHelper.load((String)"cal_costrecord_subentity", (String)this.getEntityFields("cal_costrecord_subentity"), (QFilter[])new QFilter("id", "in", existBIds).toArray());
        HashMap<Long, DynamicObject> bCostRecIdDycMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject bInfo : existBInfos) {
            bCostRecIdDycMap.put((Long)bInfo.getPkValue(), bInfo);
        }
        HashSet<DynamicObject> allNeedAddEntryRecordBs = new HashSet<DynamicObject>(16);
        for (DynamicObject infoA : costRecords) {
            DynamicObjectCollection entryDycs = infoA.getDynamicObjectCollection("entry");
            long ancestorBillId = ((DynamicObject)entryDycs.get(0)).getLong("ancestorbillid");
            Set tmpExistBIds = (Set)ansIdBIdsMap.get(ancestorBillId);
            if (tmpExistBIds == null || tmpExistBIds.isEmpty()) continue;
            ArrayList tmpExistBDycs = new ArrayList(16);
            for (Long tmpExistBId : tmpExistBIds) {
                tmpExistBDycs.add(bCostRecIdDycMap.get(tmpExistBId));
            }
            DynamicObject[] tmpExistBInfos = tmpExistBDycs.toArray(new DynamicObject[0]);
            Set<DynamicObject> needAddEntryRecordBs = this.addNewRecordBEntry(tmpExistBIds, infoA, noWriteChildEntryIds, tmpExistBInfos);
            allNeedAddEntryRecordBs.addAll(needAddEntryRecordBs);
        }
        SaveServiceHelper.save((DynamicObject[])allNeedAddEntryRecordBs.toArray(new DynamicObject[0]));
    }

    private void createRecordBHasANoB(DynamicObject[] costRecords, Map<String, Object[]> existAPeriodDate, Set<Long> noWriteChildEntryIds, Map<Long, Long> chargeOffPeriodMap, Map<Long, Date> chargeOffDateMap) {
        if (existAPeriodDate.isEmpty()) {
            return;
        }
        HashSet<Long> wfPeriodIds = new HashSet<Long>(16);
        for (Object[] value : existAPeriodDate.values()) {
            wfPeriodIds.add((Long)value[1]);
        }
        HashMap<Long, Integer> periodNumberMap = new HashMap<Long, Integer>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_period", (String)"id,periodyear,periodnumber", (QFilter[])new QFilter("id", "in", wfPeriodIds).toArray(), null);){
            for (Row row : dataSet) {
                int period = row.getInteger("periodyear") * 100 + row.getInteger("periodnumber");
                periodNumberMap.put(row.getLong("id"), period);
            }
        }
        HashSet<DynamicObject> infoBs = new HashSet<DynamicObject>(16);
        HashMap<Long, DynamicObject> ansIdACostRecDycMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject infoA : costRecords) {
            DynamicObjectCollection entryDycs = infoA.getDynamicObjectCollection("entry");
            long ancestorBillId = ((DynamicObject)entryDycs.get(0)).getLong("ancestorbillid");
            ansIdACostRecDycMap.put(ancestorBillId, infoA);
        }
        HashSet<String> billBNos = new HashSet<String>(4);
        for (Map.Entry<String, Object[]> entry : existAPeriodDate.entrySet()) {
            Object[] value = entry.getValue();
            Long ancId = (Long)value[0];
            Long writeOffPeriodB = (Long)value[1];
            Date periodDate = (Date)value[2];
            DynamicObject infoA = (DynamicObject)ansIdACostRecDycMap.get(ancId);
            Long chargeOffPeriod = chargeOffPeriodMap.get(infoA.getLong("id"));
            Date chargeOffDate = chargeOffDateMap.get(infoA.getLong("id"));
            DynamicObject infoB = this.cloneCostRecord(infoA, "cal_costrecord_subentity");
            for (DynamicObject entryA : infoA.getDynamicObjectCollection("entry")) {
                noWriteChildEntryIds.remove(entryA.getLong("id"));
            }
            infoB.set("writeoffperiod_id", (Object)writeOffPeriodB);
            if (writeOffPeriodB.longValue() == chargeOffPeriod.longValue()) {
                infoB.set("writeoffdate", (Object)chargeOffDate);
            } else {
                infoB.set("writeoffdate", (Object)periodDate);
            }
            infoB.set("writeoffstatus", (Object)"B");
            infoB.set("writeofftype", null);
            infoB.set("ischargeoff", (Object)Boolean.FALSE);
            infoB.set("ischargeoffed", (Object)Boolean.FALSE);
            infoB.set("writeoffendperiod_id", (Object)0L);
            String srcBillNo = infoA.getString("billnumber");
            String billno = srcBillNo + "-B-" + periodNumberMap.get(writeOffPeriodB);
            infoB.set("billno", (Object)billno);
            billBNos.add(billno);
            infoB.set("isvoucher", (Object)Boolean.FALSE);
            infoB.set("isfivoucher", (Object)Boolean.FALSE);
            infoB.set("istempvoucher", (Object)Boolean.FALSE);
            infoB.set("isdischargevoucher", (Object)Boolean.FALSE);
            infoB.set("iscostcarryover", (Object)Boolean.FALSE);
            infoB.set("isfeevoucher", (Object)Boolean.FALSE);
            infoB.set("fivouchernum", null);
            infoB.set("tempvouchernum", null);
            infoB.set("dischargevouchernum", null);
            infoB.set("carryovervouchernum", null);
            infoB.set("feevouchernum", null);
            infoB.set("fivoucherid", null);
            infoB.set("tempvoucherid", null);
            infoB.set("dischargevoucherid", null);
            infoB.set("carryovervoucherid", null);
            infoB.set("feevoucherid", null);
            for (DynamicObject entryB : infoB.getDynamicObjectCollection("entry")) {
                entryB.set("writeoffid", (Object)0L);
            }
            infoBs.add(infoB);
        }
        if (!infoBs.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])infoBs.toArray(new DynamicObject[0]));
        }
        logger.info("createRecordBHasANoB==>{}", billBNos);
    }

    private Map<String, Long> getAncIdWfIdBIdMap(DynamicObject[] costRecords, Map<String, Object[]> existAPeriodDate) {
        HashMap<String, Long> ancIdWfIdBIdMap = new HashMap<String, Long>(16);
        if (existAPeriodDate.isEmpty()) {
            return ancIdWfIdBIdMap;
        }
        HashSet<Long> bizBillids = new HashSet<Long>(16);
        HashSet<Long> acctIds = new HashSet<Long>(16);
        for (DynamicObject infoA : costRecords) {
            Long bizBillId = infoA.getLong("bizbillid");
            Long costAccountId = infoA.getDynamicObject("costaccount").getLong("id");
            bizBillids.add(bizBillId);
            acctIds.add(costAccountId);
        }
        HashSet<Long> ancIds = new HashSet<Long>(16);
        HashSet<Long> wfPeriodIds = new HashSet<Long>(16);
        for (Object[] value : existAPeriodDate.values()) {
            ancIds.add((Long)value[0]);
            wfPeriodIds.add((Long)value[1]);
        }
        QFilter q = new QFilter("writeoffperiod", "in", wfPeriodIds);
        q.and("bizbillid", "in", bizBillids);
        q.and("costaccount", "in", acctIds);
        q.and("writeoffstatus", "=", (Object)"B");
        q.and("issplitcreate", "=", (Object)Boolean.TRUE);
        q.and("calbilltype", "=", (Object)this.calBillType);
        q.and("entry.ancestorbillid", "in", ancIds);
        logger.info("getAncIdWfIdBIdMap-filter==>{}", (Object)q);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,writeoffperiod,entry.ancestorbillid ancestorbillid", (QFilter[])q.toArray(), null);){
            for (Row row : dataSet) {
                Long wfPeriodId = row.getLong("writeoffperiod");
                Long ancId = row.getLong("ancestorbillid");
                String key = this.buildBizIdAcctIdWfPeriodKey(wfPeriodId, ancId);
                ancIdWfIdBIdMap.put(key, row.getLong("id"));
            }
        }
        logger.info("ancIdWfIdBIdMap==>{}", ancIdWfIdBIdMap);
        return ancIdWfIdBIdMap;
    }

    private Map<String, Object[]> getMaxAInfoMap(DynamicObject[] costRecords, Map<Long, Long> chargeOffPeriodMap, Map<Long, Date> chargeOffDateMap, Set<Long> srcCostRecordIds) {
        HashMap<String, Object[]> maxAInfoMap = new HashMap<String, Object[]>(16);
        if (costRecords == null || costRecords.length < 1) {
            return maxAInfoMap;
        }
        Long minWfPeriod = null;
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        HashSet<Long> acctIds = new HashSet<Long>(16);
        HashMap<Long, Long> ancestorBillIdWfPeriodMap = new HashMap<Long, Long>(16);
        for (DynamicObject infoA : costRecords) {
            Long chargeOffPeriod = chargeOffPeriodMap.get(infoA.getLong("id"));
            Date chargeOffDate = chargeOffDateMap.get(infoA.getLong("id"));
            Long bizBillId = infoA.getLong("bizbillid");
            Long costAccountId = infoA.getDynamicObject("costaccount").getLong("id");
            bizBillIds.add(bizBillId);
            acctIds.add(costAccountId);
            DynamicObjectCollection entryDycs = infoA.getDynamicObjectCollection("entry");
            long ancestorBillId = ((DynamicObject)entryDycs.get(0)).getLong("ancestorbillid");
            ancestorBillIdWfPeriodMap.put(ancestorBillId, chargeOffPeriod);
            if (minWfPeriod != null && minWfPeriod.compareTo(chargeOffPeriod) <= 0) continue;
            minWfPeriod = chargeOffPeriod;
        }
        QFilter q = new QFilter("writeoffperiod", ">=", minWfPeriod);
        q.and("bizbillid", "in", bizBillIds);
        q.and("costaccount", "in", acctIds);
        q.and("writeoffstatus", "=", (Object)"A");
        q.and("issplitcreate", "=", (Object)Boolean.TRUE);
        q.and("entry.ancestorbillid", "in", srcCostRecordIds);
        HashSet<Long> hasAddAncIds = new HashSet<Long>(16);
        String selectFields = "writeoffperiod,writeoffdate,entry.ancestorbillid ancestorbillid";
        logger.info("getMaxAInfoMap-filter==>{}", (Object)q);
        HashMap<String, String> keyMaps = new HashMap<String, String>(4);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)selectFields, (QFilter[])q.toArray(), (String)"writeoffdate desc");){
            for (Row row : dataSet) {
                Long ancestorBillId = row.getLong("ancestorbillid");
                Long aWfPeriod = (Long)ancestorBillIdWfPeriodMap.get(ancestorBillId);
                Long wfPeriodId = row.getLong("writeoffperiod");
                Date wfDate = row.getDate("writeoffdate");
                if (aWfPeriod == null || hasAddAncIds.contains(ancestorBillId) || wfPeriodId.compareTo(aWfPeriod) < 0) continue;
                String key = this.buildBizIdAcctIdWfPeriodKey(wfPeriodId, ancestorBillId);
                maxAInfoMap.put(key, new Object[]{ancestorBillId, wfPeriodId, wfDate});
                keyMaps.put(key, ancestorBillId + "#" + wfPeriodId + "#" + wfDate);
                hasAddAncIds.add(ancestorBillId);
            }
        }
        logger.info("maxAInfoMap==>{}", keyMaps);
        return maxAInfoMap;
    }

    private Set<DynamicObject> addNewRecordBEntry(Set<Long> existBIds, DynamicObject infoA, Set<Long> noWriteChildEntryIds, DynamicObject[] existBInfos) {
        HashSet<DynamicObject> infoBs = new HashSet<DynamicObject>(existBIds.size());
        if (!existBIds.isEmpty()) {
            DynamicObjectCollection entryAs = infoA.getDynamicObjectCollection("entry");
            for (DynamicObject infoB : existBInfos) {
                boolean needSave = false;
                DynamicObjectCollection entryBs = infoB.getDynamicObjectCollection("entry");
                for (DynamicObject entryA : entryAs) {
                    boolean hasA = false;
                    for (DynamicObject entryB : entryBs) {
                        if (entryB.getLong("ancestorentryid") != entryA.getLong("ancestorentryid")) continue;
                        hasA = true;
                        break;
                    }
                    if (hasA) continue;
                    DynamicObject newEntry = entryBs.addNew();
                    DynamicObjectUtils.copy((DynamicObject)entryA, (DynamicObject)newEntry);
                    newEntry.set("writeoffid", (Object)0L);
                    needSave = true;
                    noWriteChildEntryIds.remove(entryA.getLong("id"));
                }
                if (!needSave) continue;
                infoBs.add(infoB);
            }
        }
        return infoBs;
    }

    private void writeBackAncestorBillVerifyField(Set<Long> ancestorIds, boolean isRollBack, Set<Long> bizbillIds) {
        DynamicObject[] writeBackRecords;
        DynamicObject[] isInvoiceRecords;
        if (ancestorIds == null || ancestorIds.isEmpty()) {
            return;
        }
        HashSet<Long> copyAncestorIds = new HashSet<Long>(ancestorIds);
        if (isRollBack) {
            copyAncestorIds = new HashSet(ancestorIds.size());
        }
        QFilter isInvoiceFilter = new QFilter("entry.ancestorbillid", "in", ancestorIds);
        isInvoiceFilter.and("writeoffstatus", "=", (Object)"A");
        isInvoiceFilter.and("writeofftype", "=", (Object)"B");
        isInvoiceFilter.and("issplitcreate", "=", (Object)Character.valueOf('1'));
        isInvoiceFilter.and("ischargeoff", "=", (Object)Character.valueOf('0'));
        isInvoiceFilter.and("ischargeoffed", "=", (Object)Character.valueOf('0'));
        isInvoiceFilter.and("bizbillid", "in", bizbillIds);
        for (DynamicObject invoiceRecord : isInvoiceRecords = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)"entry.ancestorbillid", (QFilter[])new QFilter[]{isInvoiceFilter})) {
            DynamicObjectCollection recordEntry = invoiceRecord.getDynamicObjectCollection("entry");
            if (recordEntry.size() <= 0) continue;
            if (isRollBack) {
                copyAncestorIds.add(((DynamicObject)recordEntry.get(0)).getLong("ancestorbillid"));
                continue;
            }
            copyAncestorIds.remove(((DynamicObject)recordEntry.get(0)).getLong("ancestorbillid"));
        }
        if (copyAncestorIds.isEmpty()) {
            return;
        }
        QFilter writeBackIds = new QFilter("id", "in", copyAncestorIds);
        for (DynamicObject writeBackRecord : writeBackRecords = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)"issubbillinvoiceverify", (QFilter[])new QFilter[]{writeBackIds})) {
            if (isRollBack) {
                writeBackRecord.set("issubbillinvoiceverify", (Object)true);
                continue;
            }
            writeBackRecord.set("issubbillinvoiceverify", (Object)false);
        }
        SaveServiceHelper.save((DynamicObject[])writeBackRecords);
    }

    private Map<Long, Long> clearWriteOffEndPeriod(Set<Long> ancestorIds, Set<Long> bizbillIds) {
        DynamicObject[] srcWriteBackRecords;
        DynamicObject[] writeBackRecords;
        HashMap<Long, Long> writeOffEndPeriodMap = new HashMap<Long, Long>(16);
        HashSet<Long> updateIdSet = new HashSet<Long>(ancestorIds.size());
        QFilter q = new QFilter("id", "in", ancestorIds);
        q.and("writeoffendperiod", "<>", (Object)0L);
        DynamicObject[] dynamicObjectArray = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,writeoffendperiod", (QFilter[])q.toArray(), null);){
            for (Row row : dataSet) {
                writeOffEndPeriodMap.put(row.getLong("id"), row.getLong("writeoffendperiod"));
                updateIdSet.add(row.getLong("id"));
            }
        }
        catch (Throwable object) {
            dynamicObjectArray = object;
            throw object;
        }
        if (updateIdSet.isEmpty()) {
            return writeOffEndPeriodMap;
        }
        q = new QFilter("entry.ancestorbillid", "in", updateIdSet);
        q.and("bizbillid", "in", bizbillIds);
        for (DynamicObject costRecordDyc : writeBackRecords = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)"writeoffendperiod", (QFilter[])q.toArray())) {
            costRecordDyc.set("writeoffendperiod", (Object)0L);
        }
        SaveServiceHelper.save((DynamicObject[])writeBackRecords);
        q = new QFilter("id", "in", updateIdSet);
        q.and("bizbillid", "in", bizbillIds);
        for (DynamicObject costRecordDyc : srcWriteBackRecords = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)"writeoffendperiod", (QFilter[])q.toArray())) {
            costRecordDyc.set("writeoffendperiod", (Object)0L);
        }
        SaveServiceHelper.save((DynamicObject[])srcWriteBackRecords);
        return writeOffEndPeriodMap;
    }

    private DynamicObject cloneCostRecord(DynamicObject oldCostRecordInfo, String entityName) {
        DynamicObject newRecord = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        DynamicObjectUtils.copy((DynamicObject)oldCostRecordInfo, (DynamicObject)newRecord);
        return newRecord;
    }

    private String getEntityFields(String entityName) {
        StringBuilder fields = new StringBuilder();
        MainEntityType calEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        Set selectorsSet = calEntityType.getAllFields().keySet();
        for (String o : selectorsSet) {
            fields.append(o).append(',');
        }
        if ("cal_costrecord_subentity".equals(entityName) || "cal_costrecord".equals(entityName)) {
            fields.append("entry.seq,");
            fields.append("entry.subentryentity.id,entry.subentryentityest.id");
        } else {
            fields.append("entryentity.seq");
        }
        return fields.toString();
    }

    private void filterRecordIds(Set<Long> srcWriteOffRecordIds) {
        block3: {
            DynamicObject[] apRecords;
            block2: {
                QFilter q = new QFilter("id", "in", srcWriteOffRecordIds);
                q.and("billtype", "!=", (Object)"im_mdc_omcmplinbill");
                DynamicObject[] arRecords = BusinessDataServiceHelper.load((String)"ar_verifyrecord", (String)"id,org,billdate,billid,billtype,billentryid,entry.e_billid,entry.e_billtype", (QFilter[])q.toArray());
                apRecords = BusinessDataServiceHelper.load((String)"ap_verifyrecord", (String)"id,org,billdate,billid,billtype,billentryid,entry.e_billid,entry.e_billtype", (QFilter[])q.toArray());
                srcWriteOffRecordIds.clear();
                if (arRecords == null || arRecords.length <= 0) break block2;
                arRecords = SynBizBillHelper.checkBillsSync((DynamicObject[])arRecords, (boolean)true);
                for (DynamicObject info : arRecords = this.filterBeforeDateBills(arRecords)) {
                    srcWriteOffRecordIds.add(info.getLong("id"));
                    this.cacheBizBillIds(info);
                }
                break block3;
            }
            if (apRecords == null || apRecords.length <= 0) break block3;
            apRecords = SynBizBillHelper.checkBillsSync((DynamicObject[])apRecords, (boolean)true);
            for (DynamicObject info : apRecords = this.filterBeforeDateBills(apRecords)) {
                srcWriteOffRecordIds.add(info.getLong("id"));
                this.cacheBizBillIds(info);
            }
        }
    }

    private void cacheBizBillIds(DynamicObject info) {
        this.bizBillIdsCache.add(info.getLong("billid"));
        for (DynamicObject entryDyc : info.getDynamicObjectCollection("entry")) {
            String assBillType = entryDyc.getString("e_billtype");
            if ("ap_finapbill".equals(assBillType) || "ar_finarbill".equals(assBillType) || "ar_revcfmbill".equals(assBillType)) continue;
            this.bizBillIdsCache.add(entryDyc.getLong("e_billid"));
        }
    }

    private DynamicObject[] filterBeforeDateBills(DynamicObject[] verifyRecords) {
        if (verifyRecords == null || verifyRecords.length == 0) {
            return new DynamicObject[0];
        }
        HashSet<Long> orgIds = new HashSet<Long>(verifyRecords.length);
        for (DynamicObject info : verifyRecords) {
            orgIds.add(info.getDynamicObject("org").getLong("id"));
        }
        QFilter q1 = new QFilter("org", "in", orgIds);
        q1.and("entry.costaccount.enable", "=", (Object)"1");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_sysctrlentity", (String)"org,entry.startperiod.begindate as begindate", (QFilter[])q1.toArray(), null);
        dataSet = dataSet.groupBy(new String[]{"org"}).min("begindate").finish();
        HashMap<Long, Date> calOrgMinDateMap = new HashMap<Long, Date>(verifyRecords.length);
        for (Row row : dataSet) {
            calOrgMinDateMap.put(row.getLong("org"), row.getDate("begindate"));
        }
        Set<Long> initBillIdSet = this.getInitBillIdSet(verifyRecords);
        HashSet<DynamicObject> billSet = new HashSet<DynamicObject>(verifyRecords.length);
        for (DynamicObject info : verifyRecords) {
            Long billId = info.getLong("billid");
            if (initBillIdSet.contains(billId)) {
                billSet.add(info);
                continue;
            }
            Date billDate = info.getDate("billdate");
            Date calOrgMinDate = (Date)calOrgMinDateMap.get(info.getDynamicObject("org").getLong("id"));
            if (calOrgMinDate == null || billDate.before(calOrgMinDate)) continue;
            billSet.add(info);
        }
        return billSet.toArray(new DynamicObject[0]);
    }

    private Set<Long> getInitBillIdSet(DynamicObject[] verifyRecords) {
        HashSet<Long> initBillIdSet = new HashSet<Long>(16);
        HashMap<String, HashSet<Long>> billTypeAndIdMap = new HashMap<String, HashSet<Long>>(16);
        for (DynamicObject info : verifyRecords) {
            Long billId = info.getLong("billid");
            String billTypeName = " ";
            Object billType = info.get("billtype");
            if (billType instanceof String) {
                billTypeName = (String)billType;
            } else if (billType instanceof DynamicObject) {
                billTypeName = ((DynamicObject)billType).getString("number");
            }
            HashSet<Long> billlIdSet = (HashSet<Long>)billTypeAndIdMap.get(billTypeName);
            if (billlIdSet == null) {
                MainEntityType billEntity = MetadataServiceHelper.getDataEntityType((String)billTypeName);
                if (billEntity == null || billEntity.getProperty("isinitbill") == null) continue;
                billlIdSet = new HashSet<Long>(16);
            }
            billlIdSet.add(billId);
            billTypeAndIdMap.put(billTypeName, billlIdSet);
        }
        ArrayList<OrmInput> billIOs = new ArrayList<OrmInput>(16);
        QFilter q = new QFilter("isinitbill", "=", (Object)Character.valueOf('1'));
        for (Map.Entry entry : billTypeAndIdMap.entrySet()) {
            QFilter billQ = q.copy().and("id", "in", entry.getValue());
            OrmInput input = new OrmInput(this.getClass().getName(), (String)entry.getKey(), "id", billQ.toArray());
            billIOs.add(input);
        }
        if (billIOs.isEmpty()) {
            return initBillIdSet;
        }
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSet billDataSet = algo.createDataSet((Input[])billIOs.toArray(new OrmInput[billIOs.size()]));
        for (Row row : billDataSet) {
            initBillIdSet.add(row.getLong("id"));
        }
        return initBillIdSet;
    }

    public void autoInvokeCharge(Collection<DynamicObject> wfRecordDycs, String wfRecordEntity) {
        if (wfRecordDycs.isEmpty()) {
            return;
        }
        HashMap<Long, Set<Long>> assBillIdWfIdsMap = new HashMap<Long, Set<Long>>(16);
        HashMap<String, Set<Long>> assBillTypeBillIdsMap = new HashMap<String, Set<Long>>(16);
        for (DynamicObject wfRecDyc : wfRecordDycs) {
            if (wfRecDyc.getDataEntityType() instanceof EntryType) {
                DynamicObject entryDyc = wfRecDyc;
                this.getAssInfo(assBillIdWfIdsMap, assBillTypeBillIdsMap, entryDyc);
                continue;
            }
            DynamicObjectCollection entryDycs = wfRecDyc.getDynamicObjectCollection("entry");
            Iterator object = entryDycs.iterator();
            while (object.hasNext()) {
                DynamicObject entryDyc = (DynamicObject)object.next();
                this.getAssInfo(assBillIdWfIdsMap, assBillTypeBillIdsMap, entryDyc);
            }
        }
        HashMap<Long, String> assBillIdRemarkMap = new HashMap<Long, String>(16);
        HashMap<Long, Date> assBillIdDateMap = new HashMap<Long, Date>(16);
        for (Map.Entry entry : assBillTypeBillIdsMap.entrySet()) {
            String assBillType = (String)entry.getKey();
            Set assBillIds = (Set)entry.getValue();
            QFilter mainBillIdF = new QFilter("billid", "in", (Object)assBillIds);
            QFilter billTypeF = new QFilter("billtype", "=", (Object)assBillType);
            QFilter assBillTypeF = new QFilter("entry.e_billtype", "=", (Object)assBillType);
            DataSet billDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)wfRecordEntity, (String)"billid,entry.e_billdate bookdate,entry.e_writtenoffremark remark", (QFilter[])new QFilter[]{mainBillIdF, billTypeF, assBillTypeF}, null);
            for (Row row : billDs) {
                assBillIdRemarkMap.put(row.getLong("billid"), row.getString("remark"));
                assBillIdDateMap.put(row.getLong("billid"), row.getDate("bookdate"));
            }
        }
        Throwable throwable = null;
        try (TXHandle t = TX.required();){
            for (Map.Entry entry : assBillIdWfIdsMap.entrySet()) {
                Long assBillId = (Long)entry.getKey();
                String wfRemark = (String)assBillIdRemarkMap.get(assBillId);
                Date bookDate = (Date)assBillIdDateMap.get(assBillId);
                if (bookDate == null) continue;
                this.chargeOffWriteRecord((Set)entry.getValue(), null, bookDate, null, wfRemark);
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
    }

    private void getAssInfo(Map<Long, Set<Long>> assBillIdWfIdsMap, Map<String, Set<Long>> assBillTypeBillIdsMap, DynamicObject entryDyc) {
        boolean hadWf = entryDyc.getBoolean("e_hadwrittenoff");
        if (!hadWf) {
            return;
        }
        long assBillId = entryDyc.getLong("e_billid");
        String billType = entryDyc.getString("e_billtype");
        Set assBillIds = assBillTypeBillIdsMap.computeIfAbsent(billType, k -> new HashSet(16));
        assBillIds.add(assBillId);
        Set srcWfRecIds = assBillIdWfIdsMap.computeIfAbsent(assBillId, k -> new HashSet(16));
        srcWfRecIds.add(((DynamicObject)entryDyc.getParent()).getLong("id"));
    }

    private void autoWriteBackApVou(Set<Long> srcWriteOffRecordIds) {
        logger.info("CalChargeOffHelper-autoWriteBackApVou-\u81ea\u52a8\u8c03\u7528\u51b2\u9500\u5e94\u4ed8\u5355\u53cd\u5199\u51ed\u8bc1-\u5f00\u59cb");
        Set<Long> chargeOffedApIds = this.getChargeOffedApIds(srcWriteOffRecordIds);
        Set<Long> chargeOffApIds = this.getChargeOffApIds(chargeOffedApIds);
        Map<Long, Set<Long>> vouIdApIdsMap = this.getVouIdApIdsMap(chargeOffApIds);
        Map<Long, String> vouIdVouNumMap = this.getVouIdVouNumMap(vouIdApIdsMap.keySet());
        for (Map.Entry<Long, Set<Long>> vouIdApIdsEnt : vouIdApIdsMap.entrySet()) {
            Long vouId = vouIdApIdsEnt.getKey();
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"VoucherWriteBackService", (String)"fiApWriteBack", (Object[])new Object[]{"1", vouIdApIdsEnt.getValue(), vouId, vouIdVouNumMap.get(vouId)});
        }
        logger.info("CalChargeOffHelper-autoWriteBackApVou-\u81ea\u52a8\u8c03\u7528\u51b2\u9500\u5e94\u4ed8\u5355\u53cd\u5199\u51ed\u8bc1-\u7ed3\u675f");
    }

    private Map<Long, String> getVouIdVouNumMap(Set<Long> vouIds) {
        HashMap<Long, String> vouIdVouNumMap = new HashMap<Long, String>(16);
        if (vouIds.isEmpty()) {
            return vouIdVouNumMap;
        }
        QFilter vouIdsF = new QFilter("id", "in", vouIds);
        DataSet vouDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_voucher", (String)"id,billno", (QFilter[])new QFilter[]{vouIdsF}, null);
        for (Row row : vouDs) {
            vouIdVouNumMap.put(row.getLong("id"), row.getString("billno"));
        }
        return vouIdVouNumMap;
    }

    private Map<Long, Set<Long>> getVouIdApIdsMap(Set<Long> chargeOffApIds) {
        HashMap<Long, Set<Long>> vouIdApIdsMap = new HashMap<Long, Set<Long>>(16);
        if (chargeOffApIds.isEmpty()) {
            return vouIdApIdsMap;
        }
        QFilter filter = new QFilter("sourcebillid", "in", chargeOffApIds);
        DataSet apDapDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"ai_daptracker", (String)"voucherid,sourcebillid", (QFilter[])new QFilter[]{filter}, null);
        for (Row row : apDapDs) {
            Long voucherid = row.getLong("voucherid");
            Long sourcebillid = row.getLong("sourcebillid");
            Set sourcebillIds = vouIdApIdsMap.computeIfAbsent(voucherid, k -> new HashSet(16));
            sourcebillIds.add(sourcebillid);
        }
        return vouIdApIdsMap;
    }

    private Set<Long> getChargeOffApIds(Set<Long> chargeOffedApIds) {
        HashSet<Long> chargeOffApIds = new HashSet<Long>(16);
        if (chargeOffedApIds.isEmpty()) {
            return chargeOffApIds;
        }
        QFilter billIdF = new QFilter("billid", "in", chargeOffedApIds);
        QFilter billTypeF = new QFilter("billtype", "=", (Object)"ap_finapbill");
        QFilter assBillTypeF = new QFilter("entry.e_billtype", "=", (Object)"ap_finapbill");
        DataSet billDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"ap_verifyrecord", (String)"billid,entry.e_billid as e_billid", (QFilter[])new QFilter[]{billIdF, billTypeF, assBillTypeF}, null);
        for (Row row : billDs) {
            chargeOffApIds.add(row.getLong("e_billid"));
        }
        return chargeOffApIds;
    }

    private Set<Long> getChargeOffedApIds(Set<Long> srcWriteOffRecordIds) {
        HashSet<Long> chargeOffedApIds = new HashSet<Long>(16);
        if (srcWriteOffRecordIds.isEmpty()) {
            return chargeOffedApIds;
        }
        QFilter wfRecIdsF = new QFilter("id", "in", srcWriteOffRecordIds);
        QFilter billTypeF = new QFilter("billtype", "=", (Object)"im_purinbill");
        QFilter assBillTypeF = new QFilter("entry.e_billtype", "=", (Object)"ap_finapbill");
        QFilter chargeOffedF = new QFilter("entry.e_hadwrittenoff", "=", (Object)Boolean.TRUE);
        DataSet billDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"ap_verifyrecord", (String)"entry.e_billid as e_billid", (QFilter[])new QFilter[]{wfRecIdsF, billTypeF, assBillTypeF, chargeOffedF}, null);
        for (Row row : billDs) {
            chargeOffedApIds.add(row.getLong("e_billid"));
        }
        return chargeOffedApIds;
    }

    private Map<Long, Long> splitByAncIdInvoke(Date bookedDate, String chargeOffReason, Map<Long, List<DynamicObject>> ancIdCostRecDycsMap) {
        HashMap<Long, Long> allWriteOffEndPeriodMap = new HashMap<Long, Long>(16);
        int invokeTimes = 0;
        while (true) {
            ArrayList<DynamicObject> batchCostRecordDycs = new ArrayList<DynamicObject>(16);
            HashSet<Long> batchSrcWriteOffRecordIds = new HashSet<Long>(16);
            Iterator<Map.Entry<Long, List<DynamicObject>>> iterator = ancIdCostRecDycsMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, List<DynamicObject>> ancIdCostRecDycsEnt = iterator.next();
                List<DynamicObject> curCostRecDycs = ancIdCostRecDycsEnt.getValue();
                if (curCostRecDycs.isEmpty()) {
                    iterator.remove();
                    continue;
                }
                DynamicObject firstCostRecDyc = curCostRecDycs.remove(0);
                batchCostRecordDycs.add(firstCostRecDyc);
                DynamicObjectCollection entryDycs = firstCostRecDyc.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entryDycs) {
                    batchSrcWriteOffRecordIds.add(entry.getLong("writeoffid"));
                }
            }
            if (batchCostRecordDycs.isEmpty()) {
                if (invokeTimes != 0) break;
                this.noSplitBill();
                break;
            }
            DynamicObject[] batchCostRecAs = batchCostRecordDycs.toArray(new DynamicObject[0]);
            Map<Long, Long> writeOffEndPeriodMap = this.doChargeOffByBatch(batchSrcWriteOffRecordIds, bookedDate, chargeOffReason, batchCostRecAs);
            allWriteOffEndPeriodMap.putAll(writeOffEndPeriodMap);
            ++invokeTimes;
        }
        return allWriteOffEndPeriodMap;
    }

    private void noSplitBill() {
        throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u8bb0\u5f55\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5b50\u5355\uff0c\u53ef\u80fd\u8fd8\u5728\u62c6\u5355\u6216\u8005\u62c6\u5355\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u6838\u7b97\u4e1a\u52a1\u5904\u7406\u65e5\u5fd7\u3002", (String)"CalChargeOffHelper_0", (String)"fi-cal-mservice", (Object[])new Object[0]));
    }

    private Map<Long, List<DynamicObject>> getAncIdCostRecDycsMap(DynamicObject[] costRecordAs) {
        HashMap<Long, List<DynamicObject>> ancIdCostRecDycsMap = new HashMap<Long, List<DynamicObject>>(16);
        for (DynamicObject costRecDyc : costRecordAs) {
            DynamicObjectCollection entryDycs = costRecDyc.getDynamicObjectCollection("entry");
            long ancestorBillId = ((DynamicObject)entryDycs.get(0)).getLong("ancestorbillid");
            List costRecDycs = ancIdCostRecDycsMap.computeIfAbsent(ancestorBillId, k -> new ArrayList(16));
            costRecDycs.add(costRecDyc);
        }
        return ancIdCostRecDycsMap;
    }
}

