/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.plugin.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.business.calculate.billgroup.AccountGroupRecordHelper;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.IDGenerator;
import kd.fi.cal.plugin.IBizPlugin;

public class ReturnApplyBillGroupPlugin
implements IBizPlugin {
    private String destCalBillSelects = "bizbillid as destbizbillid,id as destcalbillid,entry.id as destcalbillentryid,billno as destcalbillno, bizdate as destbizdate,bookdate as destbookdate,entry.material as destmaterial,entry.owner as destowner,entry.baseqty as destqty,ischargeoffed as destischargeoffed,entry.srcbillentryid as applybillentryid";
    private String applyBillSelects = "billentry.id as applybillentryid,billentry.srcbillentryid as saloutbillentryid,billentry.srcbillid as saloutbillid";
    private String srcCalBillSelects = "bizbillid as srcbizbillid,id as srccalbillid,entry.id as srccalbillentryid,billno as srccalbillno, bizdate as srcbizdate,bookdate as srcbookdate,entry.material as srcmaterial,entry.owner as srcowner,entry.baseqty as srcqty,ischargeoffed as srcischargeoffed,entry.bizbillentryid as saloutbillentryid";
    private Object matchSettingId = null;
    private String groupsettingtype = null;
    private String costcolumn = null;
    private String costfields = null;
    Boolean isNewGroupModel = AcctGroupModelHelper.isNewGroupModel();
    private String calBillIdKey = this.isNewGroupModel != false ? "calbillid" : "billid";
    private String calEntryIdKey = this.isNewGroupModel != false ? "calentryid" : "billentryid";
    private String groupRecKey = this.isNewGroupModel != false ? "cal_account_grouprecord" : "cal_groupbillrecord";
    private String selects = this.isNewGroupModel != false ? "updatetime,groupsettingtype,groupsetting,bizgrouprecordid,groupvalue,iscompleted,costcolumn,costfields,createtime,type,bizbillid,calentryid,calbillid,billno,bookdate,material,owner,baseqty,ischargeoffed,occupiedqty,weight,islastentry,groupno" : "updatetime,groupsettingtype,groupsetting,groupvalue,iscompleted,costcolumn,costfields,createtime,type,bizbillid,billentryid,billid,billno,bizdate,bookdate,material,owner,baseqty,ischargeoffed,occupiedqty,weight,islastentry,groupno";
    private Map<String, List<Map<Object, Object>>> groupBillRecordMap = new HashMap<String, List<Map<Object, Object>>>();
    private Set<Object> srcBillEntryIdSet = new HashSet<Object>(1024);
    private Set<Long> sucessCalBillIds = new HashSet<Long>(16);
    private IDGenerator idGenerator = new IDGenerator(this.isNewGroupModel != false ? "t_cal_accountgrouprecord" : "t_cal_groupbillrecord");

    @Override
    public Object doPlugin(Map params, DynamicObject[] calbills) {
        this.init(params);
        DataSet destBillDataSet = this.getDestBillDataSet(calbills);
        DataSet applyBillDataSet = this.getApplyBillDataSet(destBillDataSet.copy());
        DataSet srcBillDataSet = this.getSrcBillDataSet(applyBillDataSet.copy());
        DataSet dataSet = this.getJoinDataSet(destBillDataSet, applyBillDataSet, srcBillDataSet);
        this.createGroupBillRecord(dataSet);
        boolean isSuccess = this.saveGroupBillRecord();
        HashMap<String, Set<Long>> sucessCalBillIdsMap = new HashMap<String, Set<Long>>(16);
        sucessCalBillIdsMap.put("cal_outcalbill", this.sucessCalBillIds);
        params.put("sucessCalBillIds", sucessCalBillIdsMap);
        return isSuccess;
    }

    private void init(Map params) {
        DynamicObject matchSetting = (DynamicObject)params.get("matchSetting");
        this.matchSettingId = matchSetting.getLong("id");
        this.groupsettingtype = matchSetting.getDataEntityType().getName();
        this.costcolumn = matchSetting.getString("costcolumn");
        this.costfields = matchSetting.getString("costfields");
    }

    private boolean saveGroupBillRecord() {
        boolean isSuccess = false;
        if (!this.groupBillRecordMap.isEmpty()) {
            DynamicObjectCollection entry;
            Set<String> groupValues = this.groupBillRecordMap.keySet();
            QFilter qFilter = new QFilter("groupvalue", "in", groupValues);
            qFilter.and("groupsetting.id", "=", this.matchSettingId);
            DynamicObject[] groupBillRecords = BusinessDataServiceHelper.load((String)this.groupRecKey, (String)this.selects, (QFilter[])qFilter.toArray());
            HashMap<String, DynamicObject> saveExistGroupBillRecordMap = new HashMap<String, DynamicObject>(16);
            HashMap<String, DynamicObject> saveNewGroupBillRecordMap = new HashMap<String, DynamicObject>(16);
            HashSet<Object> calBillEntryIdSet = new HashSet<Object>(1024);
            for (DynamicObject dynamicObject : groupBillRecords) {
                String groupvalue = dynamicObject.getString("groupvalue");
                saveExistGroupBillRecordMap.put(groupvalue, dynamicObject);
                DynamicObjectCollection entry2 = dynamicObject.getDynamicObjectCollection("entryentity");
                for (DynamicObject dynamicObject2 : entry2) {
                    calBillEntryIdSet.add(dynamicObject2.get(this.calEntryIdKey));
                }
            }
            for (Map.Entry entry2 : this.groupBillRecordMap.entrySet()) {
                String groupvalue = (String)entry2.getKey();
                DynamicObject groupBillRecord = (DynamicObject)saveExistGroupBillRecordMap.get(groupvalue);
                if (groupBillRecord == null) {
                    groupBillRecord = (DynamicObject)saveNewGroupBillRecordMap.get(groupvalue);
                }
                if (groupBillRecord == null) {
                    groupBillRecord = BusinessDataServiceHelper.newDynamicObject((String)this.groupRecKey);
                    groupBillRecord.set("id", (Object)this.idGenerator.getId());
                    groupBillRecord.set("groupsetting", this.matchSettingId);
                    groupBillRecord.set("groupsetting_id", this.matchSettingId);
                    groupBillRecord.set("groupsettingtype", (Object)this.groupsettingtype);
                    groupBillRecord.set("iscompleted", (Object)"0");
                    groupBillRecord.set("createtime", (Object)TimeServiceHelper.now());
                    groupBillRecord.set("updatetime", (Object)TimeServiceHelper.now());
                    groupBillRecord.set("groupvalue", (Object)groupvalue);
                    groupBillRecord.set("costcolumn", (Object)this.costcolumn);
                    groupBillRecord.set("costfields", (Object)this.costfields);
                    saveNewGroupBillRecordMap.put(groupvalue, groupBillRecord);
                }
                entry = groupBillRecord.getDynamicObjectCollection("entryentity");
                List list = (List)entry2.getValue();
                for (Map map : list) {
                    Object billentryid = map.get("billentryid");
                    if (!calBillEntryIdSet.add(billentryid)) continue;
                    DynamicObject entryRow = entry.addNew();
                    entryRow.set("type", map.get("type"));
                    entryRow.set("bizbillid", map.get("bizbillid"));
                    entryRow.set(this.calBillIdKey, map.get("billid"));
                    entryRow.set(this.calEntryIdKey, map.get("billentryid"));
                    entryRow.set("billno", map.get("billno"));
                    if (!this.isNewGroupModel.booleanValue()) {
                        entryRow.set("bizdate", map.get("bizdate"));
                    }
                    entryRow.set("bookdate", map.get("bookdate"));
                    entryRow.set("material", map.get("material"));
                    entryRow.set("owner", map.get("owner"));
                    entryRow.set("baseqty", map.get("baseqty"));
                    entryRow.set("ischargeoffed", map.get("ischargeoffed"));
                    entryRow.set("islastentry", (Object)"0");
                    entryRow.set("occupiedqty", map.get("occupiedqty"));
                    entryRow.set("weight", map.get("weight"));
                    entryRow.set("groupno", (Object)0L);
                    groupBillRecord.set("updatetime", (Object)TimeServiceHelper.now());
                    isSuccess = true;
                }
            }
            this.handleIsCompleted(saveExistGroupBillRecordMap.values());
            this.handleIsCompleted(saveNewGroupBillRecordMap.values());
            if (this.isNewGroupModel.booleanValue()) {
                ArrayList<DynamicObject> allGroupBillRecords = new ArrayList<DynamicObject>(16);
                allGroupBillRecords.addAll(saveExistGroupBillRecordMap.values());
                allGroupBillRecords.addAll(saveNewGroupBillRecordMap.values());
                HashSet<Long> hashSet = new HashSet<Long>(16);
                for (DynamicObject record : allGroupBillRecords) {
                    entry = record.getDynamicObjectCollection("entryentity");
                    for (DynamicObject row : entry) {
                        hashSet.add(row.getLong("bizbillid"));
                    }
                }
                new AccountGroupRecordHelper(hashSet, allGroupBillRecords).save();
            } else {
                DynamicObject[] saveExistGroupBillRecords = saveExistGroupBillRecordMap.values().toArray(new DynamicObject[0]);
                SaveServiceHelper.save((DynamicObject[])saveExistGroupBillRecords);
                DynamicObject[] dynamicObjectArray = saveNewGroupBillRecordMap.values().toArray(new DynamicObject[0]);
                SaveServiceHelper.save((DynamicObject[])dynamicObjectArray);
            }
        }
        return isSuccess;
    }

    private void handleIsCompleted(Collection<DynamicObject> values) {
        for (DynamicObject info : values) {
            DynamicObjectCollection entry = info.getDynamicObjectCollection("entryentity");
            BigDecimal srcSumQty = BigDecimal.ZERO;
            BigDecimal destSumQty = BigDecimal.ZERO;
            for (DynamicObject entryRow : entry) {
                String type = entryRow.getString("type");
                boolean ischargeoffed = entryRow.getBoolean("ischargeoffed");
                if ("1".equals(type) && ischargeoffed) continue;
                if ("0".equals(type)) {
                    srcSumQty = srcSumQty.add(entryRow.getBigDecimal("baseqty").abs());
                    continue;
                }
                destSumQty = destSumQty.add(entryRow.getBigDecimal("baseqty").abs());
            }
            if (destSumQty.compareTo(srcSumQty) < 0) continue;
            info.set("iscompleted", (Object)"1");
        }
    }

    private void createGroupBillRecord(DataSet dataSet) {
        dataSet = dataSet.filter("saloutbillentryid <> null");
        for (Row row : dataSet) {
            this.sucessCalBillIds.add(row.getLong("destcalbillid"));
            String key = row.getString("saloutbillentryid") + "#";
            List<Map<Object, Object>> maps = this.groupBillRecordMap.get(key);
            if (maps == null) {
                maps = new ArrayList<Map<Object, Object>>(16);
            }
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("type", "1");
            map.put("bizbillid", row.get("destbizbillid"));
            map.put("billid", row.get("destcalbillid"));
            map.put("billentryid", row.get("destcalbillentryid"));
            map.put("billno", row.get("destcalbillno"));
            map.put("bizdate", row.getDate("destbizdate"));
            map.put("bookdate", row.getDate("destbookdate"));
            map.put("material", row.get("destmaterial"));
            map.put("owner", row.get("destowner"));
            map.put("baseqty", row.get("destqty"));
            map.put("ischargeoffed", row.get("destischargeoffed"));
            map.put("occupiedqty", row.get("destqty"));
            map.put("weight", row.getBigDecimal("destqty").abs());
            maps.add(map);
            Object srcCalBillEntryId = row.get("srccalbillentryid");
            if (this.srcBillEntryIdSet.add(srcCalBillEntryId)) {
                map = new HashMap(16);
                map.put("type", "0");
                map.put("bizbillid", row.get("srcbizbillid"));
                map.put("billid", row.get("srccalbillid"));
                map.put("billentryid", srcCalBillEntryId);
                map.put("billno", row.get("srccalbillno"));
                map.put("bizdate", row.get("srcbizdate"));
                map.put("bookdate", row.get("srcbookdate"));
                map.put("material", row.get("srcmaterial"));
                map.put("owner", row.get("srcowner"));
                map.put("baseqty", row.get("srcqty"));
                map.put("ischargeoffed", row.get("srcischargeoffed"));
                map.put("occupiedqty", row.get("srcqty"));
                map.put("weight", BigDecimal.ONE);
                maps.add(map);
            }
            this.groupBillRecordMap.put(key, maps);
        }
    }

    private DataSet getJoinDataSet(DataSet destBillDataSet, DataSet applyBillDataSet, DataSet srcBillDataSet) {
        DataSet dataSet = destBillDataSet.join(applyBillDataSet, JoinType.LEFT).on("applybillentryid", "applybillentryid").select("destbizbillid,destcalbillid,destcalbillentryid,destcalbillno,destbizdate,destbookdate,destmaterial,destowner,destqty,destischargeoffed".split(","), "saloutbillentryid".split(",")).finish().join(srcBillDataSet, JoinType.LEFT).on("saloutbillentryid", "saloutbillentryid").select("destbizbillid,destcalbillid,destcalbillentryid,destcalbillno,destbizdate,destbookdate,destmaterial,destowner,destqty,destischargeoffed".split(","), "srcbizbillid,srccalbillid,srccalbillentryid,srccalbillno,srcbizdate,srcbookdate,srcmaterial,srcowner,srcqty,srcischargeoffed,saloutbillentryid".split(",")).finish();
        return dataSet;
    }

    private DataSet getSrcBillDataSet(DataSet copy) {
        DataSet tempDataSet = copy;
        HashSet<Object> srcEntryIds = new HashSet<Object>(16);
        HashSet<Object> srcBillIds = new HashSet<Object>(16);
        for (Row row : tempDataSet) {
            srcEntryIds.add(row.get("saloutbillentryid"));
            srcBillIds.add(row.get("saloutbillid"));
        }
        QFilter srcFilter = new QFilter("entry.bizbillentryid", "in", srcEntryIds);
        srcFilter.and("bizbillid", "in", srcBillIds);
        srcFilter.and("entry.baseqty", ">", (Object)0);
        srcFilter.and("bizentityobject", "=", (Object)"im_saloutbill");
        DataSet srcBillDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_outcalbill", (String)this.srcCalBillSelects, (QFilter[])srcFilter.toArray(), null);
        return srcBillDataSet;
    }

    private DataSet getApplyBillDataSet(DataSet copy) {
        DataSet tempDataSet = copy;
        HashSet<Object> applyBillEntryIds = new HashSet<Object>();
        for (Row row : tempDataSet) {
            applyBillEntryIds.add(row.get("applybillentryid"));
        }
        QFilter applyFilter = new QFilter("billentry.id", "in", applyBillEntryIds);
        applyFilter.and("billentry.srcbillentity", "=", (Object)"im_saloutbill");
        DataSet applyBillDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"sm_returnapply", (String)this.applyBillSelects, (QFilter[])applyFilter.toArray(), null);
        return applyBillDataSet;
    }

    private DataSet getDestBillDataSet(DynamicObject[] calbills) {
        HashSet<Object> destBillIds = new HashSet<Object>(16);
        for (DynamicObject dynamicObject : calbills) {
            destBillIds.add(dynamicObject.getPkValue());
        }
        QFilter destFilter = new QFilter("id", "in", destBillIds);
        destFilter.and("entry.baseqty", "<", (Object)0);
        destFilter.and("bizentityobject", "=", (Object)"im_saloutbill");
        destFilter.and("entry.srcbillentity", "=", (Object)"sm_returnapply");
        DataSet destBillDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_outcalbill", (String)this.destCalBillSelects, (QFilter[])destFilter.toArray(), null);
        return destBillDataSet;
    }
}

