/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.mservice;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.calx.algox.CalCulateOutParams;
import kd.fi.calx.algox.CalculateOutService;
import kd.fi.calx.algox.helper.CalBalanceModelHelper;
import kd.fi.calx.algox.helper.CalculateParamHelper;
import kd.fi.calx.algox.helper.PeriodHelper;
import kd.fi.calx.algox.helper.QuerySchemeHelper;
import kd.fi.calx.formplugin.calculate.out.CalculateOutCostTaskDispatcher;
import kd.fi.calx.mservice.api.ICalculateOut;

public class CalculateOutServiceImpl
implements ICalculateOut {
    private static final Set<String> taskStatus = new HashSet<String>(16){
        private static final long serialVersionUID = 1L;
        {
            this.add("B");
            this.add("C");
        }
    };

    public void calculateOut(Map<String, Object> commonParam, List<Map<String, Object>> bizRangeParam) throws KDBizException {
        CalCulateOutParams param = this.buildParam(commonParam, bizRangeParam, false);
        new CalculateOutService().calCulateOut(param);
    }

    private CalCulateOutParams buildParam(Map<String, Object> commonParam, List<Map<String, Object>> bizRangeParam, boolean isConcurrency) {
        CalCulateOutParams param = new CalCulateOutParams();
        if (commonParam != null) {
            Boolean writeErrRpt = (Boolean)commonParam.get("writeErrRpt");
            Boolean isCalMove = commonParam.get("calInTime") == null ? Boolean.FALSE : (Boolean)commonParam.get("calInTime");
            Boolean isCalFifo = commonParam.get("calFifo") == null ? Boolean.FALSE : (Boolean)commonParam.get("calFifo");
            Boolean costEndDateEnable = commonParam.get("costEndDateEnable") == null ? Boolean.FALSE : (Boolean)commonParam.get("costEndDateEnable");
            Date costEndDate = (Date)commonParam.get("costEndDate");
            param.setWriteErrRpt(writeErrRpt == null ? false : writeErrRpt);
            param.setConcurrency(2000);
            if (isCalMove.booleanValue()) {
                param.setMovedavgRunningMode(1);
            }
            if (isCalFifo.booleanValue()) {
                param.setFifoRunningMode(1);
            }
            param.setCostatenddateenable(costEndDateEnable.booleanValue());
            param.setCostatenddate(costEndDate);
        }
        param = this.addCostCallParam(param, commonParam, bizRangeParam, isConcurrency);
        return param;
    }

    private CalCulateOutParams addCostCallParam(CalCulateOutParams param, Map<String, Object> commonParam, List<Map<String, Object>> bizRangeParam, boolean isConcurrency) {
        String matConditionType = "A";
        if (commonParam != null) {
            matConditionType = commonParam.get("matConditionType") == null ? "A" : (String)commonParam.get("matConditionType");
            Boolean writeRpt = (Boolean)commonParam.get("writeRpt");
            param.setWriteRpt(writeRpt == null ? false : writeRpt);
            param.setInvockCostprice4Rework(false);
        }
        for (Map<String, Object> bizParam : bizRangeParam) {
            Set materialIds;
            Long costAccountId = (Long)bizParam.get("costaccount");
            Long calRangeId = (Long)bizParam.get("calrange");
            Set set = materialIds = "A".equals(matConditionType) ? (Set)bizParam.get("materials") : this.getMatIds(bizParam);
            if (!isConcurrency) {
                param.addEntry(costAccountId, calRangeId, materialIds);
                continue;
            }
            param.addEntryNoHandle(costAccountId, calRangeId, materialIds);
        }
        return param;
    }

    public Map<Object, Object> calculateOutForResult(Map<String, Object> commonParam, List<Map<String, Object>> bizRangeParam) {
        String calStatus = "A";
        HashMap warrMatInfos = new HashMap(16);
        HashMap failMatInfos = new HashMap(16);
        HashMap<Object, Object> resultMap = new HashMap<Object, Object>(3);
        resultMap.put("calStatus", calStatus);
        resultMap.put("warrMatInfos", warrMatInfos);
        resultMap.put("failMatInfos", failMatInfos);
        if (!((Boolean)commonParam.get("writeRpt")).booleanValue()) {
            return resultMap;
        }
        Date startTime = new Date();
        Object schemeId = bizRangeParam.get(0).get("calscheme");
        DynamicObject calOutDyc = QuerySchemeHelper.getFormDycBySchemeId((Object)schemeId);
        Boolean isConcurrency = (Boolean)commonParam.get("isConcurrency");
        if (isConcurrency == null || !isConcurrency.booleanValue()) {
            CalCulateOutParams param = null;
            if (calOutDyc != null) {
                param = CalculateParamHelper.buildDistributedParam((boolean)true, (boolean)false, (DynamicObject)calOutDyc, (Long)((Long)schemeId));
                param = this.addCostCallParam(param, commonParam, bizRangeParam, false);
            } else {
                param = this.buildParam(commonParam, bizRangeParam, false);
            }
            CalculateOutService calService = new CalculateOutService();
            calService.calCulateOut(param);
            String checkStatus = calService.getCheckStatus();
            if ("B".equals(checkStatus)) {
                String errorMsg = ResManager.loadKDString((String)"\u51fa\u5e93\u6838\u7b97\u524d\u68c0\u67e5\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u68c0\u67e5\u7ed3\u679c\u3002", (String)"CalculateOutServiceImpl_2", (String)"fi-calx-algox", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
        } else {
            this.calculateOutByTask(calOutDyc, commonParam, bizRangeParam);
        }
        Date endTime = new Date();
        HashSet materialIds = new HashSet(16);
        HashSet<Object> costAccountIds = new HashSet<Object>(16);
        for (Map<String, Object> bizParam : bizRangeParam) {
            costAccountIds.add(bizParam.get("costaccount"));
            materialIds.addAll((Set)bizParam.get("materials"));
        }
        QFilter filter = new QFilter("costaccount", "in", costAccountIds);
        filter.and("material", "in", materialIds);
        filter.and("calstatus", "in", (Object)new String[]{"B", "C"});
        filter.and("caltime", ">=", (Object)startTime);
        filter.and("caltime", "<=", (Object)endTime);
        DataSet calcRptData = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.mservice.CalculateOutServiceImpl.calculateOutForReturn", (String)"cal_calculateoutrpt", (String)"calstatus,material.id as matid,material.number as matnumber", (QFilter[])filter.toArray(), null);
        for (Row row : calcRptData) {
            HashMap<String, String> matInfo;
            if ("C".equals(row.getString("calstatus")) && "A".equals(calStatus)) {
                calStatus = "C";
            }
            if ("C".equals(row.getString("calstatus")) && !warrMatInfos.containsKey(row.getLong("matid"))) {
                matInfo = new HashMap<String, String>(1);
                matInfo.put("number", row.getString("matnumber"));
                warrMatInfos.put(row.getLong("matid"), matInfo);
            }
            if (!"B".equals(row.getString("calstatus"))) continue;
            calStatus = "B";
            if (failMatInfos.containsKey(row.getLong("matid"))) continue;
            matInfo = new HashMap(1);
            matInfo.put("number", row.getString("matnumber"));
            failMatInfos.put(row.getLong("matid"), matInfo);
        }
        resultMap.put("calStatus", calStatus);
        resultMap.put("startTime", startTime);
        resultMap.put("endTime", endTime);
        return resultMap;
    }

    private Set<Object> getMatIds(Map<String, Object> bizParam) {
        Long costAccountId = (Long)bizParam.get("costaccount");
        Set materialIds = (Set)bizParam.get("materials");
        DynamicObject currPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId);
        currPeriod = this.getPeriodObj(currPeriod.getLong("id"));
        Integer period = currPeriod.getInt("periodyear") * 100 + currPeriod.getInt("periodnumber");
        QFilter filter = new QFilter("costaccount.id", "=", (Object)costAccountId);
        filter.and("period", "=", (Object)period);
        DataSet balanceData = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.mservice.CalculateOutServiceImpl.getMatIds", (String)CalBalanceModelHelper.getBalanceEntityName((boolean)false), (String)"material.id as matid", (QFilter[])filter.toArray(), null);
        HashSet<Object> matIds = new HashSet<Object>();
        for (Row row : balanceData) {
            if (materialIds.contains(row.get("matid"))) continue;
            matIds.add(row.get("matid"));
        }
        return matIds;
    }

    public DynamicObject getPeriodObj(Long periodId) {
        DynamicObject period = BusinessDataServiceHelper.loadSingle((Object)periodId, (String)"bd_period", (String)"periodyear,periodnumber");
        return period;
    }

    public void calculateOutDyc(DynamicObject calOutDyc, Map<String, Object> cusParamMap) {
        CalculateOutCostTaskDispatcher dispatcher = new CalculateOutCostTaskDispatcher(calOutDyc);
        Long querySchemeId = (Long)cusParamMap.get("querySchemeId");
        dispatcher.setQuerySchemeId(querySchemeId);
        dispatcher.dispatch();
    }

    private void calculateOutByTask(DynamicObject calOutDyc, Map<String, Object> commonParam, List<Map<String, Object>> bizRangeParam) {
        DynamicObjectCollection mainTasks;
        Long timestamp = TimeServiceHelper.now().getTime();
        CalCulateOutParams param = null;
        CalCulateOutParams oldParam = null;
        if (calOutDyc != null) {
            param = CalculateParamHelper.buildDistributedParam((boolean)true, (boolean)true, (DynamicObject)calOutDyc, null);
            oldParam = CalculateParamHelper.buildDistributedParam((boolean)true, (boolean)false, (DynamicObject)calOutDyc, null);
            param = this.addCostCallParam(param, commonParam, bizRangeParam, true);
            oldParam = this.addCostCallParam(param, commonParam, bizRangeParam, false);
        } else {
            param = this.buildParam(commonParam, bizRangeParam, true);
            oldParam = this.buildParam(commonParam, bizRangeParam, false);
        }
        HashMap<String, Object> jobParams = new HashMap<String, Object>();
        try {
            jobParams.put("params", JSONUtils.toString((Object)param));
            jobParams.put("oldparams", JSONUtils.toString((Object)oldParam));
            jobParams.put("concurrency", "2000");
            jobParams.put("batchmatsize", "100");
            jobParams.put("batchrowsize", this.getBatchSize());
            jobParams.put("timestamp", timestamp);
            jobParams.put("calnumber", timestamp.toString());
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        JobInfo job = new JobInfo();
        String OpName = ResManager.loadKDString((String)"\u51fa\u5e93\u6838\u7b97\u4e3b\u4efb\u52a1\u201c%1$s\u201d\uff0c\u64cd\u4f5c\u4eba\u201c%2$s\u201d\u3002", (String)"CalculateOutCostPlugin_21", (String)"fi-calx-algox", (Object[])new Object[0]);
        OpName = String.format(OpName, timestamp.toString(), RequestContext.get().getUserName());
        job.setName(OpName);
        job.setTaskDefineId("2TEFFDM0LS74");
        job.setJobType(JobType.REALTIME);
        job.setParams(jobParams);
        job.setAppId("calx");
        job.setTaskClassname("kd.fi.calx.formplugin.calculate.out.CalculateOutPartitionTask");
        job.setRunByLang(Lang.get());
        JobClient.dispatch((JobInfo)job);
        QFilter filter = new QFilter("calnumber", "=", (Object)timestamp.toString());
        filter.and("ismaintask", "=", (Object)true);
        while ((mainTasks = QueryServiceHelper.query((String)"cal_task", (String)"id,status", (QFilter[])filter.toArray())).size() == 0 || taskStatus.contains(((DynamicObject)mainTasks.get(0)).getString("status"))) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                throw new KDBizException(e.getMessage());
            }
        }
        if ("D".equals(((DynamicObject)mainTasks.get(0)).getString("status"))) {
            String errorMsg = String.format(ResManager.loadKDString((String)"%1$s,\u4efb\u52a1\u6267\u884c\u5931\u8d25\u3002", (String)"CalculateOutServiceImpl_1", (String)"fi-calx-algox", (Object[])new Object[0]), OpName);
            throw new KDBizException(errorMsg);
        }
    }

    private String getBatchSize() {
        DBRoute dbRoute = new DBRoute("scm");
        int defaultSize = 10000;
        String strSql = "SELECT FVALUE FROM T_IM_INVDBPARAM WHERE FID = 1358642492731313152 AND FKEY = 'caloutbatchrowsize'";
        DataSet batSizeData = DB.queryDataSet((String)"kd.fi.calx.mservice.DiffAllocServiceImpl.getBatchSize", (DBRoute)dbRoute, (String)strSql);
        Iterator it = batSizeData.iterator();
        if (batSizeData != null && it.hasNext()) {
            defaultSize = Integer.parseInt(((Row)it.next()).get("FVALUE").toString());
        }
        return String.valueOf(defaultSize);
    }
}

