/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.mservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.diff.DiffAllocParamter;
import kd.fi.calx.algox.diff.DiffAllocParamterEntry;
import kd.fi.calx.algox.diff.DiffAllocService;
import kd.fi.calx.algox.diff.PartitionTaskService;
import kd.fi.calx.algox.diff.helper.DiffAllocDeleteHelper;
import kd.fi.calx.algox.diff.helper.DiffAllocHelper;
import kd.fi.calx.algox.helper.CalBalanceModelHelper;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.helper.CalLogHelper;
import kd.fi.calx.algox.helper.ParamsHelper;
import kd.fi.calx.algox.helper.PeriodHelper;
import kd.fi.calx.algox.util.CommonUtils;
import kd.fi.calx.mservice.api.IDiffAlloc;

public class DiffAllocServiceImpl
implements IDiffAlloc {
    private static final String DLOCK_KEY = "calx_diffalloc#";
    private static final Log logger = LogFactory.getLog(DiffAllocServiceImpl.class);
    private static final Set<String> CAlSYS_DIFFALLOC_DIMS = new HashSet<String>(16){
        private static final long serialVersionUID = 1L;
        {
            this.add("configuredcode");
            this.add("assist");
            this.add("tracknumber");
            this.add("project");
            this.add("lot");
            this.add("costaccount");
            this.add("material");
            this.add("calorg");
        }
    };
    private static final Set<String> completedTaskStatus = new HashSet<String>(16){
        private static final long serialVersionUID = 1L;
        {
            this.add("COMPLETED");
            this.add("FAILED");
            this.add("TIMEOUT");
            this.add("ABORTED");
            this.add("SKIP");
        }
    };

    public void diffAlloc(Map<String, Object> commonParam, List<Map<String, Object>> bizRangeParam) {
        if ("false".equals(CalDbParamServiceHelper.getString((String)CalDbParamConstant.ISDO_DIFFALLOC_BY_OUTBILL, null))) {
            return;
        }
        try {
            Long wartTime = CalDbParamServiceHelper.getLong((String)CalDbParamConstant.DIFFALLOC_WAITTIME);
            Thread.sleep(wartTime);
        }
        catch (InterruptedException e) {
            logger.error("DiffAllocServiceImpl.sleep_fail:" + commonParam);
        }
        CalLogHelper.alwaysPrintLog((String)(this.getClass().getName() + "_diffAlloc_commonParam"), (String)commonParam.toString());
        CalLogHelper.alwaysPrintLog((String)(this.getClass().getName() + "_diffAlloc_bizRangeParam"), (String)bizRangeParam.toString());
        commonParam.put("matconditiontype", "A");
        for (Map<String, Object> bizRange : bizRangeParam) {
            List allocDimValsList = (List)bizRange.get("materials");
            DiffAllocParamter param = this.buildDiffAllocParam(commonParam, bizRange, Boolean.FALSE, allocDimValsList);
            if (!CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.ISDO_NOMFMAT_DIFFALLOC).booleanValue() && "B".equals(param.getMatConditionType())) {
                return;
            }
            this.doAlloc(param, Boolean.TRUE);
            this.doCircleAlloc(commonParam, bizRange);
        }
    }

    public void diffAllocForCal(Map<String, Object> commonParam, List<Map<String, Object>> bizRangeParam) {
        CalLogHelper.alwaysPrintLog((String)(this.getClass().getName() + "_diffAllocForCal_commonParam"), (String)commonParam.toString());
        CalLogHelper.alwaysPrintLog((String)(this.getClass().getName() + "_diffAllocForCal_bizRangeParam"), (String)bizRangeParam.toString());
        if ("false".equals(CalDbParamServiceHelper.getString((String)CalDbParamConstant.ISDO_DIFFALLOC_BY_OUTBILL, null))) {
            return;
        }
        if (!CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.ISDO_NOMFMAT_DIFFALLOC).booleanValue()) {
            return;
        }
        commonParam.put("matconditiontype", "B");
        for (Map<String, Object> bizRange : bizRangeParam) {
            List allocDimValsList = (List)bizRange.get("materials");
            DiffAllocParamter param = this.buildDiffAllocParam(commonParam, bizRange, Boolean.FALSE, allocDimValsList);
            this.doAlloc(param, Boolean.TRUE);
        }
    }

    public void deleteDiffBill(Map<String, Object> params) {
        DiffAllocParamter param = new DiffAllocParamter();
        param.setAllocByCostSys(Boolean.TRUE.booleanValue());
        Long costAccountId = (Long)params.get("costaccount");
        DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccountId);
        DiffAllocParamterEntry paramEntry = new DiffAllocParamterEntry();
        paramEntry.setPeriodId(Long.valueOf(period.getLong("id")));
        paramEntry.setEndDate(period.getDate("enddate"));
        paramEntry.setStartDate(period.getDate("begindate"));
        paramEntry.setCostAccountId(costAccountId);
        paramEntry.setMatIdSet((Set)params.get("materials"));
        DiffAllocHelper.deleteAllocResultByNewBal((DiffAllocParamter)param, (DiffAllocParamterEntry)paramEntry);
    }

    public Integer getBalIsUpdating(Map<String, Object> params) {
        logger.info("kd.fi.calx.mservice.DiffAllocServiceImpl.getBalIsUpdating start params==>{}", params);
        long start = System.currentTimeMillis();
        int returnStatus = 0;
        Long costAccountId = (Long)params.get("costaccount");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod period,entry.currentperiod.begindate begindate,entry.currentperiod.enddate enddate", (QFilter[])new QFilter[]{new QFilter("entry.costaccount.id", "=", (Object)costAccountId)});
        if (dynamicObject == null) {
            return returnStatus;
        }
        QFilter filter = new QFilter("costaccount", "=", (Object)costAccountId);
        filter.and("bookdate", ">=", (Object)dynamicObject.getDate("begindate"));
        filter.and("bookdate", "<=", (Object)dynamicObject.getDate("enddate"));
        filter.and("createtype", "in", this.getCreateTypes());
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"DiffAllocServiceImpl.getBalIsUpdating", (String)"cal_stdcostdiffbill", (String)"id", (QFilter[])new QFilter[]{filter}, null);
        SqlBuilder balSql = new SqlBuilder();
        balSql.append("select fbillid from t_bal_async_info", new Object[0]);
        DataSet asyncDs = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("cal"), (SqlBuilder)balSql);
        SqlBuilder balTpSql = new SqlBuilder();
        balTpSql.append("select fbillid from t_cal_bal_tp", new Object[0]);
        DataSet balTpDs = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("cal"), (SqlBuilder)balTpSql);
        DataSet balDataset = asyncDs.union(balTpDs);
        if (balDataset.isEmpty()) {
            return returnStatus;
        }
        DataSet result = dataSet.join(balDataset).on("id", "fbillid").select(dataSet.getRowMeta().getFieldNames(), balDataset.getRowMeta().getFieldNames()).finish();
        returnStatus = result.count("id", false);
        logger.info("kd.fi.calx.mservice.DiffAllocServiceImpl.getBalIsUpdating,time consuming==>{} \u6beb\u79d2,return result==>{}", (Object)(System.currentTimeMillis() - start), (Object)returnStatus);
        return returnStatus;
    }

    public Map<String, String> diffReCalculateCheck(Map<String, Object> checkParam) {
        logger.info("kd.fi.calx.mservice.DiffAllocServiceImpl.diffReCalculateCheck param==\u300b{}", checkParam);
        Long org = (Long)checkParam.get("org");
        Long costAccount = (Long)checkParam.get("costAccount");
        Long periodId = (Long)checkParam.get("periodId");
        Date checkDate = (Date)checkParam.get("checkDate");
        Long reportId = (Long)checkParam.get("reportId");
        QFilter filter = new QFilter("org", "=", (Object)org);
        filter.and("closetype", "=", (Object)"B");
        filter.and("operationtime", ">", (Object)checkDate);
        HashMap<String, String> resultMap = new HashMap<String, String>(16);
        boolean exists = QueryServiceHelper.exists((String)"cal_closeaccountlog", (QFilter[])new QFilter[]{filter});
        if (exists) {
            resultMap.put("status", "500");
            resultMap.put("msg", ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u7c3f\u5728\u4e0a\u6b21\u8ba1\u7b97\u5931\u8d25\u540e\u8fdb\u884c\u4e86\u53cd\u5173\u8d26\uff0c\u4e0d\u652f\u6301\u7ee7\u7eed\u8ba1\u7b97\u3002", (String)"DiffAllocServiceImpl_1", (String)"fi-calx-mservice", (Object[])new Object[0]));
            return resultMap;
        }
        Date[] periodStartAndEndTime = PeriodHelper.getPeriodStartAndEndTime((Long)periodId);
        if (periodStartAndEndTime != null) {
            QFilter stdFilter = new QFilter("calorg", "=", (Object)org);
            stdFilter.and("costaccount", "=", (Object)costAccount);
            stdFilter.and("bookdate", ">=", (Object)periodStartAndEndTime[0]);
            stdFilter.and("bookdate", "<=", (Object)periodStartAndEndTime[1]);
            stdFilter.and("createtime", ">", (Object)checkDate);
            stdFilter.and("createtype", "not in", (Object)new String[]{"G", "Y", "Z", "C1", "W"});
            boolean stdExist = QueryServiceHelper.exists((String)"cal_stdcostdiffbill", (QFilter[])new QFilter[]{stdFilter});
            if (stdExist) {
                resultMap.put("status", "500");
                resultMap.put("msg", ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u7c3f\u5728\u4e0a\u6b21\u8ba1\u7b97\u5931\u8d25\u540e\u6709\u5dee\u5f02\u5355\u751f\u6210\uff0c\u4e0d\u652f\u6301\u7ee7\u7eed\u8ba1\u7b97\u3002", (String)"DiffAllocServiceImpl_2", (String)"fi-calx-mservice", (Object[])new Object[0]));
                return resultMap;
            }
        }
        QFilter taskFilter = new QFilter("taskgroupno", "=", (Object)reportId.toString());
        taskFilter.and("status", "=", (Object)"A");
        boolean taskExist = QueryServiceHelper.exists((String)"cal_taskparam", (QFilter[])new QFilter[]{taskFilter});
        if (taskExist) {
            resultMap.put("status", "500");
            resultMap.put("msg", ResManager.loadKDString((String)"\u5f53\u524d\u5dee\u5f02\u5206\u644a\u4efb\u52a1\u8fd8\u672a\u5168\u90e8\u6267\u884c\u6210\u529f\uff0c\u4e0d\u652f\u6301\u7ee7\u7eed\u8ba1\u7b97\u3002", (String)"DiffAllocServiceImpl_4", (String)"fi-calx-mservice", (Object[])new Object[0]));
            return resultMap;
        }
        resultMap.put("status", "200");
        resultMap.put("msg", ResManager.loadKDString((String)"\u6821\u9a8c\u901a\u8fc7\u3002", (String)"DiffAllocServiceImpl_3", (String)"fi-calx-mservice", (Object[])new Object[0]));
        return resultMap;
    }

    private Set<String> doAlloc(DiffAllocParamter param, Boolean isSynchronous) {
        DiffAllocService service = new DiffAllocService();
        if (param.isParallel()) {
            return this.diffAllocByTask(param, isSynchronous);
        }
        service.alloc(param);
        return new HashSet<String>(1);
    }

    public Map<String, String> diffReCalculateDelBill(Map<String, Object> bizRange) {
        logger.info("kd.fi.calx.mservice.DiffAllocServiceImpl.diffReCalculateDelBill param==\u300b{}", bizRange);
        HashMap<String, String> resultMap = new HashMap<String, String>(16);
        Long costAccountId = (Long)bizRange.get("costAccount");
        Long periodId = (Long)bizRange.get("periodId");
        List allocDimValList = (List)bizRange.get("materials");
        if (allocDimValList != null && !allocDimValList.isEmpty()) {
            DynamicObject costAccount = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calorg", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costAccountId)});
            long calOrgId = costAccount.getLong("calorg");
            String diffAllocDims = ParamsHelper.getAppParam((long)calOrgId, (String)"diffalloccols").toString();
            String equationSetDims = CalDbParamServiceHelper.getString((String)CalDbParamConstant.EQUATION_DIMS, (String)Long.toString(calOrgId));
            String allDims = DiffAllocHelper.mergDiffAllocDims((String)equationSetDims, (String)diffAllocDims);
            HashSet<String> allocDimKeyCols = new HashSet<String>(16);
            HashSet<Long> materials = new HashSet<Long>(16);
            for (Map allocDims : allocDimValList) {
                StringBuilder costDomainStr = new StringBuilder();
                String[] dims = allDims.split(",");
                List<String> dimsKeys = Arrays.asList(dims);
                Collections.sort(dimsKeys);
                for (String field : dimsKeys) {
                    if ("calorg".equals(field)) {
                        costDomainStr.append(calOrgId);
                        continue;
                    }
                    if ("costaccount".equals(field)) {
                        costDomainStr.append(costAccountId);
                        continue;
                    }
                    if (!CAlSYS_DIFFALLOC_DIMS.contains(field)) continue;
                    if (allocDims.get(field) == null) {
                        if ("lot".equals(field)) {
                            costDomainStr.append(" ");
                            continue;
                        }
                        costDomainStr.append(0L);
                        continue;
                    }
                    costDomainStr.append(allocDims.get(field));
                }
                materials.add((Long)allocDims.get("material"));
                allocDimKeyCols.add(CommonUtils.getSHA256Base64Str((String)costDomainStr.toString()));
            }
            DiffAllocDeleteHelper.deleteStdBill((Long)costAccountId, (Long)periodId, materials, allocDimKeyCols, (String)equationSetDims, (String)diffAllocDims, (Object)bizRange.get("startDate"));
        }
        resultMap.put("status", "200");
        resultMap.put("msg", ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DiffAllocServiceImpl_5", (String)"fi-calx-mservice", (Object[])new Object[0]));
        return resultMap;
    }

    private DiffAllocParamter buildDiffAllocParam(Map<String, Object> commonParam, Map<String, Object> bizRange, Boolean isCircleMats, List<Map<String, Object>> allocDimValsList) {
        DiffAllocParamter param = new DiffAllocParamter();
        param.setStartTime(new Date());
        param.setAlloctor(Long.valueOf(RequestContext.get().getCurrUserId()));
        Object onlyAdjustDiff = commonParam.get("onlyAdjustDiff");
        if (onlyAdjustDiff != null) {
            param.setOnlyAdjustDiff(((Boolean)onlyAdjustDiff).booleanValue());
        } else {
            param.setOnlyAdjustDiff(false);
        }
        long reportId = commonParam.get("reportId") == null ? 0L : (Long)commonParam.get("reportId");
        param.setReportId(Long.valueOf(reportId));
        commonParam = commonParam == null ? new HashMap(16) : commonParam;
        String allocmodel = (String)commonParam.get("allocmodel");
        param.setAllocModel(allocmodel == null ? "A" : allocmodel);
        String carryrule = (String)commonParam.get("carryrule");
        param.setCarryRule(carryrule == null ? "A" : carryrule);
        String iswriterpt = CalDbParamServiceHelper.getString((String)CalDbParamConstant.IS_WRITERPT_BY_CALSYS, null);
        param.setWriterpt("true".equals(iswriterpt));
        param.setWriteErrRpt(true);
        Boolean runjob = (Boolean)commonParam.get("runjob");
        param.setRunJob(runjob == null ? true : runjob);
        Boolean isParallel = (Boolean)commonParam.get("isParallel");
        param.setParallel(isParallel == null ? false : isParallel);
        Boolean isLastLevel = (Boolean)commonParam.get("isLastLevel");
        param.setLastLevel(isLastLevel == null ? false : isLastLevel);
        param.setAllocByCostSys(true);
        Long costAccountId = (Long)bizRange.get("costaccount");
        Long calRangeId = (Long)bizRange.get("calrange");
        Long l = calRangeId = calRangeId == null ? Long.valueOf(0L) : calRangeId;
        if (isCircleMats.booleanValue() && (allocDimValsList == null || allocDimValsList.isEmpty())) {
            return null;
        }
        String nestPreDiffDsCacheId = (String)bizRange.get("nestPreDiffDsCache");
        param.setNestPreDiffDsCache(nestPreDiffDsCacheId == null ? "" : nestPreDiffDsCacheId);
        String nestMatUseQtyDsCacheId = (String)bizRange.get("nestMatUseQtyDsCache");
        param.setNestMatUseQtyDsCache(nestMatUseQtyDsCacheId == null ? "" : nestMatUseQtyDsCacheId);
        DynamicObject costAccount = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"id,calorg,calpolicy.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costAccountId)});
        Long calOrgId = costAccount.getLong("calorg");
        Object diffAllocDims = ParamsHelper.getAppParam((long)calOrgId, (String)"diffalloccols");
        if (diffAllocDims != null && !diffAllocDims.toString().isEmpty()) {
            param.setAllocDims(diffAllocDims.toString());
        }
        param.setEquationSetDims(CalDbParamServiceHelper.getString((String)CalDbParamConstant.EQUATION_DIMS, (String)calOrgId.toString()));
        if (allocDimValsList != null && !allocDimValsList.isEmpty() && isCircleMats.booleanValue()) {
            param.setCircle(Boolean.TRUE);
        }
        Long calpolicyId = costAccount.getLong("calpolicy.id");
        DynamicObject currencyDyc = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency.amtprecision", (QFilter[])new QFilter("id", "=", (Object)calpolicyId).toArray());
        param.setPrecision(currencyDyc.getInt("currency.amtprecision"));
        String matConditionType = (String)commonParam.get("matconditiontype");
        Boolean isReverse = Boolean.TRUE;
        if ("A".equals(matConditionType) || matConditionType == null) {
            isReverse = Boolean.FALSE;
        }
        this.setCalcMatId(allocDimValsList, costAccountId, calRangeId, calOrgId, param, isReverse);
        return isCircleMats != false && param.getEntityEntry().isEmpty() ? null : param;
    }

    private void setCalcMatId(List<Map<String, Object>> allocDimsList, Long costAccountId, Long calRangeId, Long calOrgId, DiffAllocParamter param, Boolean isReverse) {
        if ((allocDimsList == null || allocDimsList.isEmpty()) && !isReverse.booleanValue()) {
            return;
        }
        Set<String> allocDimKeyCols = this.getAllocDimKeyCols(allocDimsList, param, costAccountId, calOrgId);
        Set<Object> allocDimKeyColsParam = new HashSet();
        List<Object> allocDimsListParam = new ArrayList();
        HashSet<Object> matIds = new HashSet<Object>(16);
        for (Map<String, Object> allocDims : allocDimsList) {
            matIds.add(allocDims.get("material"));
        }
        HashSet<Object> matIdsParam = new HashSet<Object>();
        if (isReverse.booleanValue()) {
            DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccountId);
            int periodNum = period.getInt("periodyear") * 100 + period.getInt("periodnumber");
            QFilter filter = new QFilter("period", "<=", (Object)periodNum);
            filter.and(new QFilter("endperiod", ">=", (Object)periodNum));
            filter.and("costaccount.id", "=", (Object)costAccountId);
            filter.and("costsubelement.id", "=", (Object)773175233367685120L);
            boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
            String entityName = "cal_purpricediff";
            if (isNewBalance) {
                entityName = "cal_standcost_bal";
            }
            DataSet stdCostBalanceData = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.mservice.DiffAllocServiceImpl", (String)entityName, (String)DiffAllocHelper.mergDiffAllocDims((String)param.getAllocDims(), (String)param.getEquationSetDims()), (QFilter[])filter.toArray(), null);
            for (Row row : stdCostBalanceData) {
                StringBuilder costDomainStr = new StringBuilder();
                HashMap<String, Object> dimVals = new HashMap<String, Object>();
                String allDims = DiffAllocHelper.mergDiffAllocDims((String)param.getEquationSetDims(), (String)param.getAllocDims());
                String[] dims = allDims.split(",");
                List<String> dimsKeys = Arrays.asList(dims);
                Collections.sort(dimsKeys);
                for (String field : dimsKeys) {
                    if ("calorg".equals(field)) {
                        costDomainStr.append(calOrgId);
                        continue;
                    }
                    if ("costaccount".equals(field)) {
                        costDomainStr.append(costAccountId);
                        continue;
                    }
                    if (!CAlSYS_DIFFALLOC_DIMS.contains(field)) continue;
                    dimVals.put(field, row.get(field));
                    costDomainStr.append(row.get(field));
                }
                String keyCol = CommonUtils.getSHA256Base64Str((String)costDomainStr.toString());
                if (allocDimKeyCols.contains(keyCol)) continue;
                allocDimKeyColsParam.add(keyCol);
                allocDimsListParam.add(dimVals);
                matIdsParam.add(row.get("material"));
            }
        } else {
            allocDimKeyColsParam = allocDimKeyCols;
            allocDimsListParam = allocDimsList;
            matIdsParam = matIds;
        }
        param.addEntry(costAccountId + "@" + calRangeId, matIdsParam, allocDimKeyColsParam, allocDimsListParam);
    }

    private Set<String> getAllocDimKeyCols(List<Map<String, Object>> allocDimsList, DiffAllocParamter param, Long costAccountId, Long calOrgId) {
        HashSet<String> allocDimKeyCols = new HashSet<String>(16);
        for (Map<String, Object> allocDims : allocDimsList) {
            StringBuilder costDomainStr = new StringBuilder();
            String allDims = DiffAllocHelper.mergDiffAllocDims((String)param.getEquationSetDims(), (String)param.getAllocDims());
            String[] dims = allDims.split(",");
            List<String> dimsKeys = Arrays.asList(dims);
            Collections.sort(dimsKeys);
            logger.info("DiffAllocServiceImpl.getAllocDimKeyCols\u2014\u2014dimsKeys:" + dimsKeys + " \n");
            for (String field : dimsKeys) {
                if ("calorg".equals(field)) {
                    costDomainStr.append(calOrgId);
                    continue;
                }
                if ("costaccount".equals(field)) {
                    costDomainStr.append(costAccountId);
                    continue;
                }
                if (!CAlSYS_DIFFALLOC_DIMS.contains(field)) continue;
                costDomainStr.append(allocDims.get(field));
            }
            logger.info("DiffAllocServiceImpl.getAllocDimKeyCols:" + costDomainStr + " \n");
            allocDimKeyCols.add(CommonUtils.getSHA256Base64Str((String)costDomainStr.toString()));
        }
        return allocDimKeyCols;
    }

    private void genAllocRecord(DiffAllocParamter param) {
        DynamicObject allocRecord = BusinessDataServiceHelper.newDynamicObject((String)"calx_diffallocrc");
        allocRecord.set("user", (Object)RequestContext.get().getCurrUserId());
        allocRecord.set("starttime", (Object)new Date());
        allocRecord.set("status", (Object)"A");
        allocRecord.set("allocmodel", (Object)param.getAllocModel());
        allocRecord.set("param_tag", (Object)SerializationUtils.toJsonString((Object)param));
        Object[] result = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{allocRecord});
        param.setAllocRecordId(Long.valueOf(((DynamicObject)result[0]).getLong("id")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> diffAllocByTask(DiffAllocParamter param, Boolean isSynchronous) {
        PartitionTaskService taskService = new PartitionTaskService();
        ArrayList<DLock> lockList = new ArrayList<DLock>(param.getEntityEntry().size());
        HashSet<String> taskIds = new HashSet<String>(16);
        int batchSize = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.DIFFALLOC_MAT_BATCHSIZE);
        try {
            Map entrys = param.getEntityEntry();
            HashSet<Long> costAccountIDs = new HashSet<Long>(entrys.size());
            for (Map.Entry entry : entrys.entrySet()) {
                costAccountIDs.add(((DiffAllocParamterEntry)entry.getValue()).getCostAccountId());
            }
            for (Map.Entry entry : param.getEntityEntry().entrySet()) {
                DLock lock = DLock.create((String)(DLOCK_KEY + ((DiffAllocParamterEntry)entry.getValue()).getCostAccountId()));
                lockList.add(lock);
                if (!lock.tryLock()) {
                    String msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u4e0b\u5b58\u5728\u6b63\u5728\u8fd0\u884c\u4e2d\u7684\u5dee\u5f02\u5206\u644a\u4efb\u52a1\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"DiffAllocService_5", (String)"fi-calx-algox", (Object[])new Object[0]), ((DiffAllocParamterEntry)entry.getValue()).getCostAccountName());
                    throw new KDBizException(msg);
                }
                HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
                paramMap.put("fixedParam", param);
                if (CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.DIFF_ALLOC_DIMS_ISMAT, (String)((DiffAllocParamterEntry)entry.getValue()).getCalOrgId().toString()).booleanValue()) {
                    paramMap.put("partialDm", ((DiffAllocParamterEntry)entry.getValue()).getMatIdSet());
                } else {
                    paramMap.put("partialDm", ((DiffAllocParamterEntry)entry.getValue()).getAllocDimKeyCols());
                }
                ((DiffAllocParamterEntry)entry.getValue()).setMatIdSet(new HashSet(16));
                paramMap.put("batchSize", batchSize);
                paramMap.put("isSynchronous", isSynchronous);
                String taskName = ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a\u8ba1\u7b97", (String)"ReCalcBalanceServiceImpl_1", (String)"fi-calx-algox", (Object[])new Object[0]);
                paramMap.put("taskName", taskName);
                paramMap.put("taskdefineid", "2TEFWWEURC0=");
                paramMap.put("appId", "calx");
                paramMap.put("taskClass", "kd.fi.calx.algox.diff.DiffAllocNewTask");
                taskIds.addAll(taskService.execute(paramMap));
            }
        }
        finally {
            for (DLock lock : lockList) {
                if (lock == null) continue;
                lock.close();
            }
        }
        return taskIds;
    }

    private void doCircleAlloc(Map<String, Object> commonParam, Map<String, Object> bizRange) {
        List allocCircleDimValsList = (List)bizRange.get("circlemats");
        if (allocCircleDimValsList == null || allocCircleDimValsList.isEmpty()) {
            return;
        }
        ArrayList<Map<String, Object>> singalDimValsList = new ArrayList<Map<String, Object>>(16);
        ArrayList<List> multDimValsList = new ArrayList<List>(16);
        logger.info("DiffAllocServiceImpl.doCircleAlloc.diffalloc_params_allocCircleDimValsList:" + allocCircleDimValsList);
        for (List allocCircleDimVals : allocCircleDimValsList) {
            if (allocCircleDimVals.size() == 1) {
                singalDimValsList.add((Map<String, Object>)allocCircleDimVals.get(0));
                continue;
            }
            if (allocCircleDimVals.size() <= 1) continue;
            multDimValsList.add(allocCircleDimVals);
        }
        logger.info("DiffAllocServiceImpl.doCircleAlloc.singalDimValsList.size:" + singalDimValsList.size());
        DiffAllocParamter singalDimParam = this.buildDiffAllocParam(commonParam, bizRange, Boolean.FALSE, singalDimValsList);
        if (singalDimParam != null) {
            singalDimParam.setRework(Boolean.TRUE);
            singalDimParam.setAllocDims("material," + singalDimParam.getAllocDims());
            this.genAllocRecord(singalDimParam);
            this.doAlloc(singalDimParam, Boolean.TRUE);
        }
        logger.info("DiffAllocServiceImpl.multDimValsList.size:" + multDimValsList.size());
        HashSet<String> taskIds = new HashSet<String>(16);
        for (List allocCircleDimVals : multDimValsList) {
            DiffAllocParamter circleParam = this.buildDiffAllocParam(commonParam, bizRange, Boolean.TRUE, allocCircleDimVals);
            if (circleParam == null || !circleParam.isCircle().booleanValue()) continue;
            circleParam.setEquationSetDims(circleParam.getEquationSetDims().replaceAll(".material", ""));
            circleParam.setAllocDims("material," + circleParam.getAllocDims());
            this.genAllocRecord(circleParam);
            taskIds.addAll(this.doAlloc(circleParam, Boolean.FALSE));
        }
        if (taskIds.contains("12321412") && taskIds.size() == 1 || taskIds.isEmpty()) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, calendar.get(11) - 1);
        Boolean stayConnected = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.STAY_CONNECTED);
        while (true) {
            QFilter completedFilter = new QFilter("id", "in", taskIds);
            completedFilter.and("status", "in", completedTaskStatus);
            DynamicObjectCollection runningTasks = QueryServiceHelper.query((String)"sch_task", (String)"id", (QFilter[])completedFilter.toArray());
            if (runningTasks.size() == taskIds.size() - 1) {
                QFilter failTtaskFilter = new QFilter("id", "in", taskIds);
                failTtaskFilter.and("status", "=", (Object)"FAILED");
                failTtaskFilter.and("runtime", ">=", (Object)calendar.getTime());
                DynamicObjectCollection failTasks = QueryServiceHelper.query((String)"sch_task", (String)"id", (QFilter[])failTtaskFilter.toArray());
                if (failTasks != null && failTasks.size() > 0) {
                    this.closeDataSetCache(bizRange);
                    String taskName = ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a\u8ba1\u7b97", (String)"ReCalcBalanceServiceImpl_1", (String)"fi-calx-algox", (Object[])new Object[0]);
                    throw new KDBizException(taskName + "task\uff0cDiffAllocServiceImpl_task_execute_failed\u3002");
                }
                this.closeDataSetCache(bizRange);
                return;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                logger.info("DiffAllocServiceImpl_doCircleAlloc", (Object)e);
            }
            if (!stayConnected.booleanValue()) continue;
            QFilter filter = new QFilter("id", "=", (Object)0L);
            QueryServiceHelper.queryOne((String)"cal_dbparam", (String)"id", (QFilter[])new QFilter[]{filter});
        }
    }

    private void closeDataSetCache(Map<String, Object> bizRange) {
        if (CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.DIFFALLOC_IS_DEBUG).booleanValue()) {
            return;
        }
        String nestPreDiffDsCacheId = (String)bizRange.get("NestPreDiffDsCache");
        String nestMatUseQtyDsCacheId = (String)bizRange.get("NestPreDiffDsCache");
        if (nestPreDiffDsCacheId != null && !nestPreDiffDsCacheId.isEmpty()) {
            try {
                Algo.removeCacheDataSet((String)nestPreDiffDsCacheId);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                throw e;
            }
        }
        if (nestMatUseQtyDsCacheId != null && !nestMatUseQtyDsCacheId.isEmpty()) {
            try {
                Algo.removeCacheDataSet((String)nestMatUseQtyDsCacheId);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                throw e;
            }
        }
    }

    private List<String> getCreateTypes() {
        ArrayList<String> createTypes = new ArrayList<String>(16);
        createTypes.add("G");
        createTypes.add("C1");
        createTypes.add("Z");
        createTypes.add("Y");
        createTypes.add("W");
        return createTypes;
    }
}

