/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.mservice.mq;

import java.util.ArrayList;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.calx.algox.report.CalOutRptHolder;

public class CalReportConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog(CalReportConsumer.class);
    private static final String INSERT_RPTHEAD_SQL = "insert into t_cal_caloutrpt(fid,fcostaccountid,fmaterialid,fdividebasisid,fcaldimensionid,fdividebasisvalue,fcaldimensionvalue,faccounttype,fperiodid,fcaltime,fcalstatus,fnextseq,fcalorgid,fcalrangeid,flog,foperationuserid,fmatrix,fcostatenddateenable,fcostatenddate,fassistid,fconfiguredcodeid,fprojectid,ftracknumberid)values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String INSERT_RPTENTRY_SQL = "insert into t_cal_caloutrptentry(fid,fentryid,fseq,fbizbillid,fbizbillentryid,fbilltypenum,fbilltype,fbillnumber,finstr,foutstr,fbalancestr,fparententryid,fbizdate,fauditdate,fdescribe)values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String INSERT_MATRIX_DTL_SQL = "insert into t_cal_caloutrpt_dtl (fid,frptid,fmatrixtype,fbillno,fbookdate,fauditdate,fcostsubelementid,fbaseunitid,fcurrencyid,finqty,finunitcost,fincost,foutqty,foutunitcost,foutcost,fcostdomainkey,fperiodid,fcostaccountid,fcaltime,fentryid,fsortlistid,fentity,fremark,fcostpricesource,fmaterialid,fbilltypename)values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final DBRoute route = new DBRoute("cal");

    public void onMessage(Object paramObject, String paramString, boolean paramBoolean, MessageAcker paramMessageAcker) {
        long startTime = System.currentTimeMillis();
        logger.info("CalReportConsumer-\u5f00\u59cb\u6d88\u8d39\u6d88\u606f");
        try {
            CalOutRptHolder reportInfo = (CalOutRptHolder)paramObject;
            Boolean matrix = reportInfo.getMatrix();
            String log = reportInfo.getLog();
            if (!("".equals(log) || log.isEmpty() || matrix.booleanValue())) {
                String newLog = log.substring(0, log.length() - 1);
                reportInfo.setNewLog(newLog);
            }
            reportInfo.getRptHead()[11] = reportInfo.getEntrys().size() + 1;
            Object[] header = reportInfo.getRptHead();
            this.saveHeadToDB(reportInfo.getRptHead());
            try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_caloutrpt", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fcostaccountid", FilterType.eq, header[1]), new ShardingHintContext.ShardingHintCondition("fperiodid", FilterType.eq, header[8])});){
                ctx.set();
                this.saveEntryToDB(reportInfo.getEntrys());
            }
            this.saveMatrixDtls(reportInfo.getMatrixDtls());
            paramMessageAcker.ack(paramString);
        }
        catch (Throwable e) {
            logger.error("CalReportConsumer-\u6d88\u8d39\u5931\u8d25", e);
            logger.info("CalReportConsumer-\u6d88\u8d39\u5931\u8d25");
        }
        logger.info("CalReportConsumer-\u7ed3\u675f\u6d88\u8d39\u6d88\u606f");
        long time = (System.currentTimeMillis() - startTime) / 1000L;
        logger.info("CalReportConsumer-\u6d88\u8d39\u6d88\u606f\u8017\u65f6(\u79d2)\uff1a" + time);
    }

    private void saveMatrixDtls(List<Object[]> matrixDtls) {
        if (matrixDtls != null && matrixDtls.size() > 0) {
            logger.info("CalOutRptHolder-matrixdtl:\u65b9\u7a0b\u7ec4\u660e\u7ec6\u63d2\u5165\u6570\u636e\u5e93\u5f00\u59cb");
            DB.executeBatch((DBRoute)route, (String)INSERT_MATRIX_DTL_SQL, matrixDtls);
            logger.info("CalOutRptHolder-matrixdtl:\u65b9\u7a0b\u7ec4\u660e\u7ec6\u63d2\u5165\u6570\u636e\u5e93\u7ed3\u675f");
        }
    }

    private void saveEntryToDB(List<Object[]> entrys) {
        if (entrys == null || entrys.isEmpty()) {
            logger.info("CalReportConsumer:\u65e5\u5fd7\u5206\u5f55\u4e3a\u7a7a");
            return;
        }
        logger.info("CalReportConsumer:\u5f00\u59cb\u65e5\u5fd7\u5206\u5f55\u63d2\u5165");
        DB.executeBatch((DBRoute)route, (String)INSERT_RPTENTRY_SQL, entrys);
        logger.info("CalReportConsumer:\u7ed3\u675f\u65e5\u5fd7\u5206\u5f55\u63d2\u5165");
    }

    private void saveHeadToDB(Object[] head) {
        if (head == null || head.length < 1) {
            logger.info("CalReportConsumer:\u65e5\u5fd7\u8868\u5934\u4e3a\u7a7a");
            return;
        }
        logger.info("CalReportConsumer:\u5f00\u59cb\u65e5\u5fd7\u8868\u5934\u63d2\u5165");
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        params.add(head);
        DB.executeBatch((DBRoute)route, (String)INSERT_RPTHEAD_SQL, params);
        logger.info("CalReportConsumer:\u7ed3\u675f\u65e5\u5fd7\u8868\u5934\u63d2\u5165");
    }
}

