/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.balance.BizDataType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.balance.BalanceServiceHelper;
import kd.fi.calx.algox.helper.CalBalanceModelHelper;

public class BalanceDimFieldParser {
    private static final String[] DEFAULT_DIM_FIELDS = new String[]{"costaccount", "storageorgunit", "ownertype", "owner", "material", "assist", "lot", "warehouse", "location", "invtype", "invstatus", "project", "mversion"};
    private final Map<String, IDataEntityProperty> dimFieldMap;
    private Map<String, MainEntityType> entityCache = new HashMap<String, MainEntityType>();
    private static final String COST_RECORD_ENTRY_KEY = "entry";
    private static final String COST_ADJUST_ENTRY_KEY = "entryentity";
    protected boolean isNewBalance = CalBalanceModelHelper.isNewBalance();

    public BalanceDimFieldParser() {
        this.dimFieldMap = new HashMap<String, IDataEntityProperty>();
        MainEntityType balanceType = null;
        balanceType = this.isNewBalance ? this.registerEntity("cal_bal") : this.registerEntity("cal_balance");
        HashSet<BizDataType> bizDataTypeSet = new HashSet<BizDataType>();
        bizDataTypeSet.add(BizDataType.MAIN);
        bizDataTypeSet.add(BizDataType.DIM);
        Map fieldMap = null;
        if (this.isNewBalance) {
            BalanceTB tb = BalanceTB.getBalanceTB((String)"cal_bal");
            Set dimFields = tb.getColsByDataType(new BizDataType[]{BizDataType.DIM, BizDataType.MAIN});
            ArrayList dimList = new ArrayList(dimFields);
            Collections.sort(dimList);
            for (String field : dimList) {
                if ("costelement".equals(field) || "costsubelement".equals(field)) continue;
                this.dimFieldMap.put(field, balanceType.findProperty(field));
            }
        } else {
            fieldMap = BalanceServiceHelper.loadBizData((String)"cal_balancemodel", bizDataTypeSet);
            if (fieldMap.get(BizDataType.MAIN) != null) {
                for (String dimField : (Set)fieldMap.get(BizDataType.MAIN)) {
                    this.dimFieldMap.put(dimField, balanceType.findProperty(dimField));
                }
            }
            if (fieldMap.get(BizDataType.DIM) != null) {
                for (String dimField : (Set)fieldMap.get(BizDataType.DIM)) {
                    this.dimFieldMap.put(dimField, balanceType.findProperty(dimField));
                }
            }
        }
        if (this.dimFieldMap.isEmpty()) {
            for (String defaultdim : DEFAULT_DIM_FIELDS) {
                this.dimFieldMap.put(defaultdim, balanceType.findProperty(defaultdim));
            }
        }
    }

    public Set<String> getDimFields() {
        return new HashSet<String>(this.dimFieldMap.keySet());
    }

    public Set<String> getDimFieldsWithBaseName(boolean hasDimFieldName, boolean hasDimFieldNumber) {
        HashSet<String> fieldSet = new HashSet<String>(this.dimFieldMap.size() * 2);
        for (Map.Entry<String, IDataEntityProperty> entry : this.dimFieldMap.entrySet()) {
            String fieldKey = entry.getKey();
            fieldSet.add(fieldKey);
            if (!(entry.getValue() instanceof BasedataProp) || entry.getValue() instanceof FlexProp) continue;
            if (hasDimFieldNumber) {
                fieldSet.add(fieldKey + ".number as " + fieldKey + "number");
            }
            if (!hasDimFieldName) continue;
            fieldSet.add(fieldKey + ".name as " + fieldKey + "name");
        }
        return fieldSet;
    }

    public Set<String> getDimFieldsWithBaseNameNotAs(boolean hasDimFieldName, boolean hasDimFieldNumber) {
        HashSet<String> fieldSet = new HashSet<String>(this.dimFieldMap.size() * 2);
        for (Map.Entry<String, IDataEntityProperty> entry : this.dimFieldMap.entrySet()) {
            String fieldKey = entry.getKey();
            fieldSet.add(fieldKey);
            if (!(entry.getValue() instanceof BasedataProp) || entry.getValue() instanceof FlexProp) continue;
            if (hasDimFieldNumber) {
                fieldSet.add(fieldKey + ".number");
            }
            if (!hasDimFieldName) continue;
            fieldSet.add(fieldKey + ".name");
        }
        return fieldSet;
    }

    public Set<String> getBalanceFields(boolean hasDimFieldName, boolean hasDimFieldNumber) {
        Set<String> fieldSet = this.getDimFieldsWithBaseName(hasDimFieldName, hasDimFieldNumber);
        fieldSet.add("id");
        fieldSet.add("period");
        if (hasDimFieldNumber) {
            fieldSet.add("calorg.number as calorgnumber");
        }
        if (hasDimFieldName) {
            fieldSet.add("calorg.name as calorgname");
        }
        return fieldSet;
    }

    public Set<String> getDimAliasWithBaseName(boolean hasDimFieldName, boolean hasDimFieldNumber) {
        HashSet<String> fieldSet = new HashSet<String>(this.dimFieldMap.size() * 2);
        for (Map.Entry<String, IDataEntityProperty> entry : this.dimFieldMap.entrySet()) {
            String fieldKey = entry.getKey();
            fieldSet.add(fieldKey);
            if (!(entry.getValue() instanceof BasedataProp) || entry.getValue() instanceof FlexProp) continue;
            if (hasDimFieldNumber) {
                fieldSet.add(fieldKey + "number");
            }
            if (!hasDimFieldName) continue;
            fieldSet.add(fieldKey + "name");
        }
        return fieldSet;
    }

    public Set<String> getDimAliasWithBaseNameNotAs(boolean hasDimFieldName, boolean hasDimFieldNumber) {
        HashSet<String> fieldSet = new HashSet<String>(this.dimFieldMap.size() * 2);
        for (Map.Entry<String, IDataEntityProperty> entry : this.dimFieldMap.entrySet()) {
            String fieldKey = entry.getKey();
            fieldSet.add(fieldKey);
            if (!(entry.getValue() instanceof BasedataProp) || entry.getValue() instanceof FlexProp) continue;
            if (hasDimFieldNumber) {
                fieldSet.add(fieldKey + ".number");
            }
            if (!hasDimFieldName) continue;
            fieldSet.add(fieldKey + ".name");
        }
        return fieldSet;
    }

    public Set<String> getBalanceAlias(boolean hasDimFieldName, boolean hasDimFieldNumber) {
        Set<String> fieldSet = this.getDimAliasWithBaseName(hasDimFieldName, hasDimFieldNumber);
        fieldSet.add("period");
        if (hasDimFieldNumber) {
            fieldSet.add("calorgnumber");
        }
        if (hasDimFieldName) {
            fieldSet.add("calorgname");
        }
        return fieldSet;
    }

    public Set<String> getDetailAlias(boolean hasDimFieldName, boolean hasDimFieldNumber) {
        return this.getBalanceAlias(hasDimFieldName, hasDimFieldNumber);
    }

    public String getCostRecordFields() {
        return this.getDetailDimFieldsAndBaseName("cal_costrecord_subentity", COST_RECORD_ENTRY_KEY);
    }

    public String getCostAdjustFields() {
        return this.getDetailDimFieldsAndBaseName("cal_costadjust_subentity", COST_ADJUST_ENTRY_KEY);
    }

    public String getDetailDimFieldsAndBaseName(String entityType, String entryKey) {
        StringBuilder fieldsStr = new StringBuilder();
        MainEntityType detailEntityType = this.registerEntity(entityType);
        for (Map.Entry<String, IDataEntityProperty> entry : this.dimFieldMap.entrySet()) {
            String fieldKey = entry.getKey();
            if (detailEntityType.findProperty(fieldKey).getParent() instanceof MainEntityType) {
                fieldsStr.append(fieldKey).append(',');
                fieldsStr.append(fieldKey).append(".number as ").append(fieldKey).append("number").append(',');
                continue;
            }
            if (!(detailEntityType.findProperty(fieldKey).getParent() instanceof EntryType)) continue;
            fieldsStr.append(entryKey).append('.').append(fieldKey).append(" as ").append(fieldKey).append(',');
            if (!(entry.getValue() instanceof BasedataProp) || entry.getValue() instanceof FlexProp) continue;
            fieldsStr.append(entryKey).append('.').append(fieldKey).append(".number as ").append(fieldKey).append("number").append(',');
        }
        return fieldsStr.toString();
    }

    public String getDetailDimFieldsAndBaseNumberName(String entityType, String entryKey) {
        StringBuilder fieldsStr = new StringBuilder();
        MainEntityType detailEntityType = this.registerEntity(entityType);
        for (Map.Entry<String, IDataEntityProperty> entry : this.dimFieldMap.entrySet()) {
            String fieldKey = entry.getKey();
            if (detailEntityType.findProperty(fieldKey).getParent() instanceof MainEntityType) {
                fieldsStr.append(fieldKey).append(',');
                fieldsStr.append(fieldKey).append(".number as ").append(fieldKey).append("number").append(',');
                fieldsStr.append(fieldKey).append(".name as ").append(fieldKey).append("name").append(',');
                continue;
            }
            if (!(detailEntityType.findProperty(fieldKey).getParent() instanceof EntryType)) continue;
            fieldsStr.append(entryKey).append('.').append(fieldKey).append(" as ").append(fieldKey).append(',');
            if (!(entry.getValue() instanceof BasedataProp) || entry.getValue() instanceof FlexProp) continue;
            fieldsStr.append(entryKey).append('.').append(fieldKey).append(".number as ").append(fieldKey).append("number").append(',');
            fieldsStr.append(entryKey).append('.').append(fieldKey).append(".name as ").append(fieldKey).append("name").append(',');
        }
        return fieldsStr.toString();
    }

    public String getFieldName(String field) {
        return this.dimFieldMap.get(field).getDisplayName().toString();
    }

    public String getFieldDisplayField(String field) {
        IDataEntityProperty prop = this.dimFieldMap.get(field);
        if (prop instanceof BasedataProp) {
            return field + "number";
        }
        return field;
    }

    private MainEntityType registerEntity(String entityType) {
        MainEntityType entityTypeObj = this.entityCache.get(entityType);
        if (entityTypeObj == null) {
            entityTypeObj = MetadataServiceHelper.getDataEntityType((String)entityType);
            this.entityCache.put(entityType, entityTypeObj);
        }
        return entityTypeObj;
    }

    public String getDetailDimFields(String entityType, String entryKey) {
        StringBuilder fieldsStr = new StringBuilder();
        MainEntityType detailEntityType = this.registerEntity(entityType);
        for (Map.Entry<String, IDataEntityProperty> entry : this.dimFieldMap.entrySet()) {
            String fieldKey = entry.getKey();
            if (detailEntityType.findProperty(fieldKey).getParent() instanceof MainEntityType) {
                fieldsStr.append(fieldKey).append(" as ").append(fieldKey).append(',');
                continue;
            }
            if (!(detailEntityType.findProperty(fieldKey).getParent() instanceof EntryType)) continue;
            fieldsStr.append(entryKey).append('.').append(fieldKey).append(" as ").append(fieldKey).append(',');
        }
        return fieldsStr.toString();
    }
}

