/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Date;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.calx.algox.helper.PeriodHelper;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CalCulateOutParamEntry {
    private Long costAccountId;
    private Long periodId;
    private Long calOrgId;
    private Long calrangeId;
    private Long calPolicyId;
    private Long calSystemId;
    private Date startDate;
    private Date endDate;
    private int period;
    private Set<Object> materialIdSet = null;

    public void setMaterialIdSet(Set<Object> materialIdSet) {
        this.materialIdSet = materialIdSet;
    }

    public CalCulateOutParamEntry() {
    }

    public CalCulateOutParamEntry(Long costAccountId, Long calrangeId, Set<Object> materialIdSet) {
        DynamicObject costAccount = BusinessDataServiceHelper.loadSingle((Object)costAccountId, (String)"cal_bd_costaccount", (String)"name,calorg,calsystem,calpolicy");
        this.costAccountId = costAccount.getLong("id");
        this.calOrgId = costAccount.getDynamicObject("calorg").getLong("id");
        this.calSystemId = costAccount.getDynamicObject("calsystem").getLong("id");
        this.calPolicyId = costAccount.getDynamicObject("calpolicy").getLong("id");
        DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod(costAccountId);
        if (currentPeriod == null) {
            String msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u5c1a\u672a\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u65e0\u6cd5\u53c2\u4e0e\u51fa\u5e93\u6838\u7b97\u3002", (String)"CalCulateOutParamEntry_3", (String)"fi-calx-algox", (Object[])new Object[0]), costAccount.getString("name"));
            throw new KDBizException(msg);
        }
        this.periodId = currentPeriod.getLong("id");
        this.startDate = currentPeriod.getDate("begindate");
        this.endDate = currentPeriod.getDate("enddate");
        this.period = currentPeriod.getInt("periodyear") * 100 + currentPeriod.getInt("periodnumber");
        this.calrangeId = calrangeId;
        this.materialIdSet = materialIdSet;
    }

    public CalCulateOutParamEntry(DynamicObject costAccount, Long calrangeId, Set<Object> materialIdSet, DynamicObject currentPeriod) {
        this.costAccountId = costAccount.getLong("id");
        this.calOrgId = costAccount.getDynamicObject("calorg").getLong("id");
        this.calSystemId = costAccount.getDynamicObject("calsystem").getLong("id");
        this.calPolicyId = costAccount.getDynamicObject("calpolicy").getLong("id");
        if (currentPeriod == null) {
            String msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u5c1a\u672a\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u65e0\u6cd5\u53c2\u4e0e\u51fa\u5e93\u6838\u7b97\u3002", (String)"CalCulateOutParamEntry_3", (String)"fi-calx-algox", (Object[])new Object[0]), costAccount.getString("name"));
            throw new KDBizException(msg);
        }
        this.periodId = currentPeriod.getLong("id");
        this.startDate = currentPeriod.getDate("begindate");
        this.endDate = currentPeriod.getDate("enddate");
        this.period = currentPeriod.getInt("periodyear") * 100 + currentPeriod.getInt("periodnumber");
        this.calrangeId = calrangeId;
        this.materialIdSet = materialIdSet;
    }

    public void joinMaterialIDs(Set<Object> materialIdSet) {
        if (this.isAllMaterial()) {
            return;
        }
        if (materialIdSet == null) {
            this.materialIdSet = null;
            return;
        }
        this.materialIdSet.addAll(materialIdSet);
    }

    public Long getCostAccountId() {
        return this.costAccountId;
    }

    public Long getPeriodId() {
        return this.periodId;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Long getCalOrgId() {
        return this.calOrgId;
    }

    public Long getCalPolicyId() {
        return this.calPolicyId;
    }

    public Long getCalSystemId() {
        return this.calSystemId;
    }

    public Set<Object> getMaterialIdSet() {
        return this.materialIdSet;
    }

    public boolean isAllMaterial() {
        return this.materialIdSet == null;
    }

    public Long getCalrangeId() {
        return this.calrangeId;
    }

    public void setCalrangeId(Long calrangeId) {
        this.calrangeId = calrangeId;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }
}

