/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.calx.algox.CalCulateOutParamEntry;
import kd.fi.calx.algox.accounttype.AccountTypeEnum;

public class CalCulateOutParams {
    private Map<String, Map<Long, String>> checkItems = new HashMap<String, Map<Long, String>>(16);
    private boolean writeRpt = true;
    private boolean writeErrRpt = false;
    private Map<String, Integer> runningModeMap = new HashMap<String, Integer>();
    private Map<String, CalCulateOutParamEntry> entrys = new HashMap<String, CalCulateOutParamEntry>();
    private Long querySchemeId = 0L;
    private String calNumber = "";
    private boolean matrix;
    private boolean costatenddateenable = false;
    private Date costatenddate;
    private boolean voucherdutweightedavgat = false;
    private boolean desigoutweightedavgat = false;
    private boolean coverdesigoutcost = false;
    private String billNoFilterStr;
    private String startMatNumber = "";
    private String endMatNumber = "";
    private int concurrency = 5;
    private boolean invockCostprice4Rework = true;
    private boolean subTask = false;

    public String getStartMatNumber() {
        return this.startMatNumber;
    }

    public void setStartMatNumber(String startMatNumber) {
        this.startMatNumber = startMatNumber;
    }

    public String getEndMatNumber() {
        return this.endMatNumber;
    }

    public void setEndMatNumber(String endMatNumber) {
        this.endMatNumber = endMatNumber;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    public boolean isInvockCostprice4Rework() {
        return this.invockCostprice4Rework;
    }

    public void setInvockCostprice4Rework(boolean invockCostprice4Rework) {
        this.invockCostprice4Rework = invockCostprice4Rework;
    }

    public void setEntrys(Map<String, CalCulateOutParamEntry> entrys) {
        this.entrys = entrys;
    }

    public boolean isSubTask() {
        return this.subTask;
    }

    public void setIsSubTask(boolean isSubTask) {
        this.subTask = isSubTask;
    }

    public CalCulateOutParams() {
        this.runningModeMap.put(AccountTypeEnum.WEIGHTAVG.getValue(), 1);
        this.runningModeMap.put(AccountTypeEnum.SPPRICE.getValue(), 1);
        this.runningModeMap.put(AccountTypeEnum.MOVEDAVG_INTIME.getValue(), 0);
        this.runningModeMap.put(AccountTypeEnum.FIFO.getValue(), 0);
        this.runningModeMap.put(AccountTypeEnum.FIN_FOUT_PERIOD.getValue(), 1);
        this.runningModeMap.put(AccountTypeEnum.STANDARDCOST.getValue(), 1);
    }

    public Map<String, CalCulateOutParamEntry> getEntrys() {
        return this.entrys;
    }

    public Map<String, Map<Long, String>> getCheckItems() {
        return this.checkItems;
    }

    public void setCheckItems(Map<String, Map<Long, String>> checkItems) {
        this.checkItems = checkItems;
    }

    public boolean isWriteRpt() {
        return this.writeRpt;
    }

    public void setWriteRpt(boolean writeRpt) {
        this.writeRpt = writeRpt;
    }

    public boolean isWriteErrRpt() {
        return this.writeErrRpt;
    }

    public void setWriteErrRpt(boolean writeErrRpt) {
        this.writeErrRpt = writeErrRpt;
    }

    public void addEntry(Long costAccountId, Long calrangeId, Set<Object> materialIdSet) {
        if (calrangeId == null) {
            QFilter filter = new QFilter("costaccount", "=", (Object)costAccountId);
            filter = filter.and("status", "=", (Object)"C");
            DynamicObjectCollection rangeCol = QueryServiceHelper.query((String)"cal_bd_calrange", (String)"id", (QFilter[])(filter = filter.and("enable", "=", (Object)Boolean.TRUE)).toArray());
            if (rangeCol.isEmpty()) {
                DynamicObject costAccount = BusinessDataServiceHelper.loadSingle((Object)costAccountId, (String)"cal_bd_costaccount", (String)"number,name");
                String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6210\u672c\u8d26\u7c3f\u3010%1$s\u3011\u4e0b\u662f\u5426\u5b58\u5728\u5df2\u5ba1\u6838\u4e14\u53ef\u7528\u7684\u6838\u7b97\u8303\u56f4", (String)"CostAccount_3", (String)"fi-calx-algox", (Object[])new Object[0]), costAccount.getString("name"));
                throw new KDBizException(msg);
            }
            for (DynamicObject calRange : rangeCol) {
                this.joinEntry(costAccountId, calRange.getLong("id"), materialIdSet);
            }
        } else {
            this.joinEntry(costAccountId, calrangeId, materialIdSet);
        }
    }

    public void addEntry(DynamicObject costAccount, DynamicObjectCollection rangeCol, Set<Object> materialIdSet, DynamicObject currentperiod) {
        for (DynamicObject calRange : rangeCol) {
            this.joinEntry(costAccount, calRange.getLong("id"), materialIdSet, currentperiod);
        }
    }

    public void addEntryNoHandle(Long costAccountId, Long calrangeId, Set<Object> materialIdSet) {
        this.joinEntry(costAccountId, calrangeId, materialIdSet);
    }

    private void joinEntry(Long costAccountId, Long calrangeId, Set<Object> materialIdSet) {
        String key = costAccountId + "#" + calrangeId;
        CalCulateOutParamEntry entry = this.entrys.get(key);
        if (entry == null) {
            entry = new CalCulateOutParamEntry(costAccountId, calrangeId, materialIdSet);
            this.entrys.put(key, entry);
        } else {
            entry.joinMaterialIDs(materialIdSet);
        }
    }

    private void joinEntry(DynamicObject costAccount, Long calrangeId, Set<Object> materialIdSet, DynamicObject currentperiod) {
        Long costAccountId = costAccount.getLong("id");
        String key = costAccountId + "#" + calrangeId;
        CalCulateOutParamEntry entry = this.entrys.get(key);
        if (entry == null) {
            entry = new CalCulateOutParamEntry(costAccount, calrangeId, materialIdSet, currentperiod);
            this.entrys.put(key, entry);
        } else {
            entry.joinMaterialIDs(materialIdSet);
        }
    }

    public void setWeightavgRunningMode(int runningMode) {
        this.runningModeMap.put(AccountTypeEnum.WEIGHTAVG.getValue(), runningMode);
    }

    public void setSppriceRunningMode(int runningMode) {
        this.runningModeMap.put(AccountTypeEnum.SPPRICE.getValue(), runningMode);
    }

    public void setMovedavgRunningMode(int runningMode) {
        this.runningModeMap.put(AccountTypeEnum.MOVEDAVG_INTIME.getValue(), runningMode);
    }

    public void setFifoRunningMode(int runningMode) {
        this.runningModeMap.put(AccountTypeEnum.FIFO.getValue(), runningMode);
    }

    public void setFifoPeriodRunningMode(int runningMode) {
        this.runningModeMap.put(AccountTypeEnum.FIN_FOUT_PERIOD.getValue(), runningMode);
    }

    public Map<String, Integer> getRunningModeMap() {
        return this.runningModeMap;
    }

    public boolean hasCalInTimeAccountType() {
        return this.runningModeMap.get(AccountTypeEnum.MOVEDAVG_INTIME.getValue()) != 0 || this.runningModeMap.get(AccountTypeEnum.FIFO.getValue()) != 0;
    }

    public void setQuerySchemeId(Long querySchemeId) {
        this.querySchemeId = querySchemeId;
    }

    public Long getQuerySchemeId() {
        return this.querySchemeId;
    }

    public String getCalNumber() {
        return this.calNumber;
    }

    public void setCalNumber(String calNumber) {
        this.calNumber = calNumber;
    }

    public void setMatrix(boolean matrix) {
        this.matrix = matrix;
    }

    public boolean getMatrix() {
        return this.matrix;
    }

    public boolean isCostatenddateenable() {
        return this.costatenddateenable;
    }

    public void setCostatenddateenable(boolean costatenddateenable) {
        this.costatenddateenable = costatenddateenable;
    }

    public Date getCostatenddate() {
        return this.costatenddate;
    }

    public void setCostatenddate(Date costatenddate) {
        this.costatenddate = costatenddate;
    }

    public boolean isVoucherdutweightedavgat() {
        return this.voucherdutweightedavgat;
    }

    public void setVoucherdutweightedavgat(boolean voucherdutweightedavgat) {
        this.voucherdutweightedavgat = voucherdutweightedavgat;
    }

    public boolean isDesigoutweightedavgat() {
        return this.desigoutweightedavgat;
    }

    public void setDesigoutweightedavgat(boolean desigoutweightedavgat) {
        this.desigoutweightedavgat = desigoutweightedavgat;
    }

    public boolean isCoverdesigoutcost() {
        return this.coverdesigoutcost;
    }

    public void setCoverdesigoutcost(boolean coverdesigoutcost) {
        this.coverdesigoutcost = coverdesigoutcost;
    }

    public String getBillNoFilterStr() {
        return this.billNoFilterStr;
    }

    public void setBillNoFilterStr(String billNoFilterStr) {
        this.billNoFilterStr = billNoFilterStr;
    }
}

