/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.calx.algox.CalCulateOutParamEntry;
import kd.fi.calx.algox.CalCulateOutParams;
import kd.fi.calx.algox.CostAccount;
import kd.fi.calx.algox.accounttype.AccountTypeEnum;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.helper.PeriodHelper;

public class CalOutDataRangeHolder
implements Serializable {
    private static final long serialVersionUID = 8646582388337199846L;
    private int MATERIALSETSIZE = CalDbParamServiceHelper.getInteger(CalDbParamConstant.CALOUT_MATERIALSPLIT_BATCHSIZE);
    private Map<String, CalOutRange> originRangeMap = new HashMap<String, CalOutRange>(16);
    private Map<String, CalOutRange> associationRangeMap = new HashMap<String, CalOutRange>(16);
    private Map<Long, CostAccount> costAccountMap = new HashMap<Long, CostAccount>();
    private Map<Long, DynamicObject> periodMap = new HashMap<Long, DynamicObject>();
    private Map<Long, Set<Long>> calorgMapPeriod = null;
    private List<CalOutRange> rangeList = null;
    private boolean needCalculatedLater;
    private Set<Long> costAccountSet = null;
    private Map<Long, Long> costAccount2CurPeriodMap = null;

    public Long getCurrentPeirod(Long costAccountId) {
        Long curperiodId;
        if (this.costAccount2CurPeriodMap == null || this.costAccount2CurPeriodMap.isEmpty()) {
            this.costAccount2CurPeriodMap = new HashMap<Long, Long>(16);
            Map<Long, DynamicObject> currentPeriods = PeriodHelper.getCurrentPeriods(this.getCostAccountSet());
            for (Map.Entry<Long, DynamicObject> entry : currentPeriods.entrySet()) {
                Long caId = entry.getKey();
                DynamicObject period = entry.getValue();
                if (period == null) continue;
                this.costAccount2CurPeriodMap.put(caId, period.getLong("id"));
            }
        }
        if ((curperiodId = this.costAccount2CurPeriodMap.get(costAccountId)) == null) {
            DynamicObject curperiod = PeriodHelper.getCurrentPeriod(costAccountId);
            if (curperiod == null) {
                return null;
            }
            curperiodId = curperiod.getLong("id");
            this.costAccount2CurPeriodMap.put(costAccountId, curperiodId);
        }
        return curperiodId;
    }

    public CalOutDataRangeHolder(CalCulateOutParams param) {
        Map<String, Integer> runningModeMap = param.getRunningModeMap();
        this.needCalculatedLater = runningModeMap.get(AccountTypeEnum.MOVEDAVG_INTIME.getValue()) != 0 || runningModeMap.get(AccountTypeEnum.FIFO.getValue()) != 0;
        for (CalCulateOutParamEntry paramEntry : param.getEntrys().values()) {
            Long period = 0L;
            String key = paramEntry.getCostAccountId() + "#" + paramEntry.getCalrangeId() + "#" + period;
            this.originRangeMap.put(key, new CalOutRange(paramEntry));
        }
        this.loadAllAssociationRange();
    }

    private void loadAllAssociationRange() {
        this.associationRangeMap.clear();
        for (CalOutRange range : this.originRangeMap.values()) {
            this.loadAssociationRange(range);
        }
    }

    private void loadAssociationRange(CalOutRange range) {
        HashSet<Long> groupNoSet = new HashSet<Long>(10);
        QFilter sortFilter = new QFilter("costaccount", "=", (Object)range.getCostAccountId());
        sortFilter = sortFilter.and("calrange", "=", (Object)range.getCalRangeId());
        sortFilter = sortFilter.and("groupno", ">", (Object)-1);
        if (range.isAllMaterial()) {
            DynamicObjectCollection resultCol = QueryServiceHelper.query((String)"cal_sortresult", (String)"groupno,groupseq", (QFilter[])sortFilter.toArray());
            for (DynamicObject sortResult : resultCol) {
                Long groupNo = sortResult.getLong("groupno");
                groupNoSet.add(groupNo);
            }
        } else {
            for (Set set : range.getMaterialSetList()) {
                QFilter materialFilter = sortFilter.copy().and("material", "in", (Object)set);
                DynamicObjectCollection resultCol = QueryServiceHelper.query((String)"cal_sortresult", (String)"groupno,groupseq", (QFilter[])materialFilter.toArray());
                for (DynamicObject sortResult : resultCol) {
                    Long groupNo = sortResult.getLong("groupno");
                    groupNoSet.add(groupNo);
                }
            }
        }
        QFilter filter = new QFilter("groupno", "in", groupNoSet);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_sortresult", (String)"costaccount,calrange,material,period", (QFilter[])filter.toArray(), null);
        for (Row sortResult : dataSet) {
            Long costaccount = sortResult.getLong("costaccount");
            Long calrange = sortResult.getLong("calrange");
            Long period = 0L;
            Long materialid = sortResult.getLong("material");
            String key = costaccount + "#" + calrange + "#" + period;
            if (this.isInOriginal(key, materialid)) continue;
            CalOutRange associationRange = this.associationRangeMap.get(key);
            if (associationRange == null) {
                associationRange = new CalOutRange(costaccount, calrange, period, materialid);
                this.associationRangeMap.put(key, associationRange);
                continue;
            }
            associationRange.add(materialid);
        }
    }

    private boolean isInOriginal(String key, Long materialId) {
        CalOutRange originRange = this.originRangeMap.get(key);
        if (originRange == null) {
            return false;
        }
        if (originRange.isAllMaterial()) {
            return true;
        }
        for (Set<Object> materialIdSet : originRange.getMaterialSetList()) {
            if (!materialIdSet.contains(materialId)) continue;
            return true;
        }
        return false;
    }

    public Map<Long, Set<Long>> getCalorgMapPeriod() {
        if (this.calorgMapPeriod == null) {
            List<CalOutRange> rangeList = this.getCalOutRangeList();
            this.calorgMapPeriod = new HashMap<Long, Set<Long>>(rangeList.size());
            for (CalOutRange range : rangeList) {
                Long calOrgId = range.getCalOrgId();
                Long periodId = range.getPeriodId();
                Set periodIdSet = this.calorgMapPeriod.computeIfAbsent(calOrgId, k -> new HashSet());
                periodIdSet.add(periodId);
            }
        }
        return this.calorgMapPeriod;
    }

    public DynamicObject getPeriodObj(Long periodId) {
        DynamicObject period = this.periodMap.get(periodId);
        if (period == null) {
            period = BusinessDataServiceHelper.loadSingle((Object)periodId, (String)"bd_period", (String)"begindate,enddate,periodyear,periodnumber");
            this.periodMap.put(periodId, period);
        }
        return period;
    }

    public Set<Long> getCostAccountSet() {
        if (this.costAccountSet == null) {
            List<CalOutRange> rangeList = this.getCalOutRangeList();
            this.costAccountSet = new HashSet<Long>(rangeList.size());
            for (CalOutRange range : rangeList) {
                this.costAccountSet.add(range.getCostAccountId());
            }
        }
        return this.costAccountSet;
    }

    public List<CalOutRange> getCalOutRangeList() {
        if (this.rangeList == null) {
            this.rangeList = new ArrayList<CalOutRange>(this.originRangeMap.size() + this.associationRangeMap.size());
            this.rangeList.addAll(this.originRangeMap.values());
            this.rangeList.addAll(this.associationRangeMap.values());
        }
        this.rangeList = this.getMergeRangeListHasRangeId(this.rangeList);
        return this.rangeList;
    }

    public List<CalOutRange> getMergeRangeListNoRangeId() {
        CalOutRange mergeRange;
        ArrayList<CalOutRange> rangeList = new ArrayList<CalOutRange>(16);
        List<CalOutRange> calOutRangeList = this.getCalOutRangeList();
        HashMap<String, CalOutRange> acctIdPeriodRangeMap = new HashMap<String, CalOutRange>(16);
        HashMap<String, Set> acctIdPeriodMatIdsMap = new HashMap<String, Set>(16);
        for (CalOutRange calOutRange : calOutRangeList) {
            String acctIdPeriodIdKey = calOutRange.getCostAccountId() + "_" + calOutRange.getPeriodId();
            mergeRange = acctIdPeriodRangeMap.computeIfAbsent(acctIdPeriodIdKey, k -> curOutRange);
            Set mergeMatIds = acctIdPeriodMatIdsMap.computeIfAbsent(acctIdPeriodIdKey, k -> new HashSet(16));
            if (calOutRange.isAllMaterial) {
                mergeRange.setAllMaterial(true);
            }
            for (Set<Object> matIds : calOutRange.getMaterialSetList()) {
                mergeMatIds.addAll(matIds);
            }
        }
        for (Map.Entry entry : acctIdPeriodRangeMap.entrySet()) {
            String key = (String)entry.getKey();
            mergeRange = (CalOutRange)entry.getValue();
            rangeList.add(mergeRange);
            if (mergeRange.isAllMaterial) continue;
            mergeRange.getMaterialSetList().clear();
            Set mergeRangeMatIds = (Set)acctIdPeriodMatIdsMap.get(key);
            HashSet tmpMatIds = new HashSet(16);
            for (Object mergeRangeMatId : mergeRangeMatIds) {
                tmpMatIds.add(mergeRangeMatId);
                if (tmpMatIds.size() < this.MATERIALSETSIZE) continue;
                mergeRange.getMaterialSetList().add(tmpMatIds);
                tmpMatIds = new HashSet(16);
            }
            mergeRange.getMaterialSetList().add(tmpMatIds);
        }
        return rangeList;
    }

    public List<CalOutRange> getMergeRangeListHasRangeId(List<CalOutRange> srcRangeList) {
        CalOutRange mergeRange;
        ArrayList<CalOutRange> rangeList = new ArrayList<CalOutRange>(16);
        List<CalOutRange> calOutRangeList = srcRangeList;
        HashMap<String, CalOutRange> acctIdPeriodRangeMap = new HashMap<String, CalOutRange>(16);
        HashMap<String, Set> acctIdPeriodMatIdsMap = new HashMap<String, Set>(16);
        for (CalOutRange calOutRange : calOutRangeList) {
            String acctIdPeriodIdKey = calOutRange.getCostAccountId() + "_" + calOutRange.getPeriodId() + "_" + calOutRange.getCalRangeId();
            mergeRange = acctIdPeriodRangeMap.computeIfAbsent(acctIdPeriodIdKey, k -> curOutRange);
            Set mergeMatIds = acctIdPeriodMatIdsMap.computeIfAbsent(acctIdPeriodIdKey, k -> new HashSet(16));
            if (calOutRange.isAllMaterial) {
                mergeRange.setAllMaterial(true);
            }
            for (Set<Object> matIds : calOutRange.getMaterialSetList()) {
                mergeMatIds.addAll(matIds);
            }
        }
        for (Map.Entry entry : acctIdPeriodRangeMap.entrySet()) {
            String key = (String)entry.getKey();
            mergeRange = (CalOutRange)entry.getValue();
            rangeList.add(mergeRange);
            if (mergeRange.isAllMaterial) continue;
            mergeRange.getMaterialSetList().clear();
            Set mergeRangeMatIds = (Set)acctIdPeriodMatIdsMap.get(key);
            HashSet tmpMatIds = new HashSet(16);
            for (Object mergeRangeMatId : mergeRangeMatIds) {
                tmpMatIds.add(mergeRangeMatId);
                if (tmpMatIds.size() < this.MATERIALSETSIZE) continue;
                mergeRange.getMaterialSetList().add(tmpMatIds);
                tmpMatIds = new HashSet(16);
            }
            mergeRange.getMaterialSetList().add(tmpMatIds);
        }
        return rangeList;
    }

    public Map<Long, CostAccount> getCostAccountMap() {
        return this.costAccountMap;
    }

    public boolean isNeedCalculatedLater() {
        return this.needCalculatedLater;
    }

    public void setNeedCalculatedLater(boolean needCalculatedLater) {
        this.needCalculatedLater = needCalculatedLater;
    }

    public class CalOutRange
    implements Serializable {
        private static final long serialVersionUID = -4555707914665431120L;
        private List<Set<Object>> materialSetList = new ArrayList<Set<Object>>();
        private Long costAccountId = null;
        private Long calOrgId = null;
        private Long calRangeId = null;
        private Long periodId = null;
        private Date startDate;
        private Date endDate;
        private Integer period = null;
        private boolean isAllMaterial = false;

        public CalOutRange(CalCulateOutParamEntry paramEntry) {
            boolean isAllMaterial;
            this.costAccountId = paramEntry.getCostAccountId();
            CostAccount costAccount = CalOutDataRangeHolder.this.costAccountMap.computeIfAbsent(this.costAccountId, k -> new CostAccount((Long)k));
            this.calOrgId = costAccount.getCalOrgId();
            this.calRangeId = paramEntry.getCalrangeId();
            this.periodId = paramEntry.getPeriodId();
            this.startDate = paramEntry.getStartDate();
            this.endDate = paramEntry.getEndDate();
            this.period = paramEntry.getPeriod();
            this.isAllMaterial = isAllMaterial = paramEntry.isAllMaterial();
            if (!isAllMaterial) {
                Set<Object> allIdSet = paramEntry.getMaterialIdSet();
                if (allIdSet.size() <= CalOutDataRangeHolder.this.MATERIALSETSIZE) {
                    this.materialSetList.add(allIdSet);
                } else {
                    for (Object materialId : allIdSet) {
                        this.add(materialId);
                    }
                }
            }
        }

        public CalOutRange(Long costAccountId, Long calRangeId, Long periodId, Object materialId) {
            this.costAccountId = costAccountId;
            CostAccount costAccount = CalOutDataRangeHolder.this.costAccountMap.computeIfAbsent(this.costAccountId, k -> new CostAccount((Long)k));
            this.calOrgId = costAccount.getCalOrgId();
            this.calRangeId = calRangeId;
            DynamicObject periodObj = PeriodHelper.getCurrentPeriod(costAccountId);
            this.periodId = periodObj.getLong("id");
            this.startDate = periodObj.getDate("begindate");
            this.endDate = periodObj.getDate("enddate");
            this.period = periodObj.getInt("periodyear") * 100 + periodObj.getInt("periodnumber");
            HashSet<Object> materialIdSet = new HashSet<Object>();
            materialIdSet.add(materialId);
            this.materialSetList.add(materialIdSet);
        }

        private void add(Object materialId) {
            if (this.isAllMaterial) {
                return;
            }
            Set<Object> materialIdSet = null;
            if (this.materialSetList.isEmpty()) {
                materialIdSet = new HashSet();
                this.materialSetList.add(materialIdSet);
            } else {
                materialIdSet = this.materialSetList.get(this.materialSetList.size() - 1);
                if (materialIdSet.size() >= CalOutDataRangeHolder.this.MATERIALSETSIZE) {
                    materialIdSet = new HashSet();
                    this.materialSetList.add(materialIdSet);
                }
            }
            materialIdSet.add(materialId);
        }

        public List<Set<Object>> getMaterialSetList() {
            if (this.materialSetList == null) {
                this.materialSetList = new ArrayList<Set<Object>>(4);
            }
            if (this.materialSetList.isEmpty()) {
                this.materialSetList.add(new HashSet(4));
            }
            return this.materialSetList;
        }

        public Long getCostAccountId() {
            return this.costAccountId;
        }

        public Long getPeriodId() {
            return this.periodId;
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public void setEndDate(Date endDate) {
            this.endDate = endDate;
        }

        public boolean isEmpty() {
            return this.materialSetList.isEmpty();
        }

        public Integer getPeriod() {
            return this.period;
        }

        public boolean isAllMaterial() {
            return this.isAllMaterial;
        }

        public void setAllMaterial(boolean isAllMaterial) {
            this.isAllMaterial = isAllMaterial;
            if (isAllMaterial) {
                this.materialSetList.clear();
            }
        }

        public Long getCalRangeId() {
            return this.calRangeId;
        }

        public void setCalRangeId(Long calRangeId) {
            this.calRangeId = calRangeId;
        }

        public Long getCalOrgId() {
            return this.calOrgId;
        }

        public void setCalOrgId(Long calOrgId) {
            this.calOrgId = calOrgId;
        }
    }
}

