/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;

public class CalRange
implements Serializable {
    private static final long serialVersionUID = 1073095421184222818L;
    private String[] dividebasis;
    private List<CalRangeEntry> entrys;
    private String caldimension;
    private Long rangeId;
    private String accountType;
    private Long calDimensionID;

    public CalRange(DynamicObject calRange, String[] dividebasis) {
        this.dividebasis = dividebasis;
        this.entrys = new ArrayList<CalRangeEntry>();
        this.rangeId = calRange.getLong("id");
        this.accountType = calRange.getString("accounttype");
        DynamicObject caldimesion = calRange.getDynamicObject("caldimension");
        if (caldimesion == null) {
            this.calDimensionID = 0L;
            this.caldimension = "";
        } else {
            this.calDimensionID = caldimesion.getLong("id");
            this.caldimension = caldimesion.getString("caldimension");
        }
        for (DynamicObject entry : calRange.getDynamicObjectCollection("entry")) {
            this.entrys.add(new CalRangeEntry(entry));
        }
    }

    public CalRangeEntry getValidCalRangeEntry(RowX row, RowMeta rowMeta) {
        for (CalRangeEntry rangeEntry : this.entrys) {
            if (!rangeEntry.isMatchRow(row, rowMeta)) continue;
            return rangeEntry;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.entrys.isEmpty();
    }

    public Long getRangeId() {
        return this.rangeId;
    }

    public String getCaldimension() {
        return this.caldimension;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public Long getCalDimensionID() {
        return this.calDimensionID;
    }

    public String[] getDividebasis() {
        return this.dividebasis;
    }

    public void setDividebasis(String[] dividebasis) {
        this.dividebasis = dividebasis;
    }

    public class CalRangeEntry
    implements Serializable {
        private static final long serialVersionUID = -7628933563046841324L;
        private Map<String, Long> fieldValue = new HashMap<String, Long>();
        private String displayName;

        private CalRangeEntry(DynamicObject entry) {
            StringBuilder sb = new StringBuilder();
            String[] stringArray = CalRange.this.dividebasis;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String dividebasis;
                DynamicObject dimesionObj = entry.getDynamicObject(dividebasis = stringArray[i]);
                this.fieldValue.put(dividebasis, dimesionObj == null ? 0L : dimesionObj.getLong("id"));
                sb.append(dimesionObj == null ? ResManager.loadKDString((String)"\u7a7a", (String)"CalRange_0", (String)"fi-calx-algox", (Object[])new Object[0]) : dimesionObj.getString("name"));
            }
            this.displayName = sb.length() > 0 ? sb.substring(0, sb.length() - 1) : "";
        }

        private boolean isMatchRow(RowX row, RowMeta rowMeta) {
            for (Map.Entry<String, Long> entry : this.fieldValue.entrySet()) {
                int index;
                String key = entry.getKey();
                Long value = entry.getValue();
                if (value.equals(row.getLong(index = rowMeta.getFieldIndex(key)))) continue;
                return false;
            }
            return true;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Long getRangeId() {
            return CalRange.this.rangeId;
        }

        public String getCaldimension() {
            return CalRange.this.caldimension;
        }
    }
}

