/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.calx.algox.CalRange;
import kd.fi.calx.algox.helper.PeriodHelper;

public class CostAccount
implements Serializable {
    private static final long serialVersionUID = 6198166738021791347L;
    private Long id;
    private Long costAccountId;
    private Long currentPeriod;
    private String costAccountName;
    private Long calSystemId;
    private Long calPolicyId;
    private Long calOrgId;
    private Long bookTypeId;
    private List<CalRange> notEmptyCalRange = new ArrayList<CalRange>();
    private CalRange emptyCalRange = null;
    private Long divideBasisID;
    private String[] divideBasis;
    private Map<Long, CalRange> rangeMap = new HashMap<Long, CalRange>();
    private String longNumberDLM = ".";
    private Map<String, String> spMaterialAccountType = new HashMap<String, String>();
    private Map<String, String> spMGroupAccountType = new HashMap<String, String>();
    private Map<String, String> spMaterialCaldimension = new HashMap<String, String>();
    private Map<String, String> spMGroupCaldimension = new HashMap<String, String>();

    public CostAccount(Long costAccountId) {
        this.costAccountId = costAccountId;
        DynamicObject costAccount = BusinessDataServiceHelper.loadSingleFromCache((Object)costAccountId, (String)"cal_bd_costaccount");
        DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod(costAccountId);
        if (currentPeriod == null) {
            String msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u5c1a\u672a\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u65e0\u6cd5\u53c2\u4e0e\u51fa\u5e93\u6838\u7b97\u3002", (String)"CalCulateOutParamEntry_3", (String)"fi-calx-algox", (Object[])new Object[0]), costAccount.getString("name"));
            throw new KDBizException(msg);
        }
        this.currentPeriod = currentPeriod.getLong("id");
        this.id = costAccount.getLong("id");
        this.costAccountName = costAccount.getString("name");
        DynamicObject divideBasisObj = costAccount.getDynamicObject("dividebasis");
        this.divideBasisID = divideBasisObj.getLong("id");
        this.divideBasis = divideBasisObj.getString("dividebasis").split(",");
        this.calSystemId = costAccount.getDynamicObject("calsystem").getLong("id");
        this.calPolicyId = costAccount.getDynamicObject("calpolicy").getLong("id");
        this.calOrgId = costAccount.getDynamicObject("calorg").getLong("id");
        this.bookTypeId = costAccount.getDynamicObject("booktype").getLong("id");
        this.initCalRanges(costAccountId);
        this.initSpAccountType();
        this.initSpCaldimension();
        this.initlongNumberDLM();
    }

    private void initlongNumberDLM() {
        DynamicProperty property = EntityMetadataCache.getDataEntityType((String)"bd_materialgroup").getProperty("parent");
        GroupProp group = (GroupProp)property;
        if (group instanceof ParentBasedataProp) {
            this.longNumberDLM = ((ParentBasedataProp)group).getLongNumberDLM();
        }
    }

    private void initCalRanges(Long costAccountId) {
        QFilter filter = new QFilter("costaccount", "=", (Object)costAccountId);
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        Map calRangeMap = BusinessDataServiceHelper.loadFromCache((String)"cal_bd_calrange", (QFilter[])filter.toArray());
        if (calRangeMap.isEmpty()) {
            String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6210\u672c\u8d26\u7c3f\u3010%1$s\u3011\u4e0b\u662f\u5426\u5b58\u5728\u5df2\u5ba1\u6838\u4e14\u53ef\u7528\u7684\u6838\u7b97\u8303\u56f4", (String)"CostAccount_3", (String)"fi-calx-algox", (Object[])new Object[0]), this.costAccountName);
            throw new KDBizException(msg);
        }
        for (DynamicObject calRangeDym : calRangeMap.values()) {
            CalRange calRange = new CalRange(calRangeDym, this.divideBasis);
            if (calRange.isEmpty()) {
                this.emptyCalRange = calRange;
            } else {
                this.notEmptyCalRange.add(calRange);
            }
            this.rangeMap.put(calRange.getRangeId(), calRange);
        }
    }

    private void initSpAccountType() {
        QFilter filter = new QFilter("calrange.costaccount.id", "=", (Object)this.costAccountId);
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        Map accountTypeMap = BusinessDataServiceHelper.loadFromCache((String)"cal_bd_accounttype", (QFilter[])filter.toArray());
        for (DynamicObject accountTypeObj : accountTypeMap.values()) {
            Object calRangeId = accountTypeObj.getDynamicObject("calrange").getPkValue();
            for (DynamicObject entry : accountTypeObj.getDynamicObjectCollection("entry")) {
                String accountType = entry.getString("accounttype");
                DynamicObject material = entry.getDynamicObject("material");
                if (material != null) {
                    this.spMaterialAccountType.put(calRangeId + "_" + material.getPkValue(), accountType);
                    continue;
                }
                DynamicObject mGroup = entry.getDynamicObject("materialgroup");
                this.spMGroupAccountType.put(calRangeId + "_" + mGroup.getString("longnumber"), accountType);
            }
        }
    }

    private void initSpCaldimension() {
        QFilter filter = new QFilter("calrange.costaccount.id", "=", (Object)this.costAccountId);
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        Map caldimensionMap = BusinessDataServiceHelper.loadFromCache((String)"cal_bd_materialdimension", (QFilter[])filter.toArray());
        for (DynamicObject caldimensionMapObj : caldimensionMap.values()) {
            Object calRangeId = caldimensionMapObj.getDynamicObject("calrange").getPkValue();
            for (DynamicObject entry : caldimensionMapObj.getDynamicObjectCollection("entry")) {
                DynamicObject caldimension = entry.getDynamicObject("caldimension");
                DynamicObject material = entry.getDynamicObject("material");
                if (material != null) {
                    this.spMaterialCaldimension.put(calRangeId + "_" + material.getPkValue(), caldimension.getPkValue() + "@" + caldimension.getString("caldimension"));
                    continue;
                }
                DynamicObject mGroup = entry.getDynamicObject("materialgroup");
                this.spMGroupCaldimension.put(calRangeId + "_" + mGroup.getString("longnumber"), caldimension.getPkValue() + "@" + caldimension.getString("caldimension"));
            }
        }
    }

    public String getSpAccountType(String calRangeId, String materialId, String mGroupNo) {
        String accountType = this.spMaterialAccountType.get(calRangeId + "_" + materialId);
        if (accountType == null) {
            if (mGroupNo == null) {
                return null;
            }
            int beforeLongNoLenth = 0;
            for (Map.Entry<String, String> entry : this.spMGroupAccountType.entrySet()) {
                String[] key = entry.getKey().split("_");
                if (!calRangeId.equals(key[0]) || !mGroupNo.startsWith(key[1] + this.longNumberDLM) && !mGroupNo.equals(key[1]) || beforeLongNoLenth >= key[1].length()) continue;
                accountType = entry.getValue();
                beforeLongNoLenth = key[1].length();
            }
        }
        return accountType;
    }

    public String getSpCaldimension(String calRangeId, String materialId, String mGroupNo) {
        String caldimension = this.spMaterialCaldimension.get(calRangeId + "_" + materialId);
        if (caldimension == null) {
            if (mGroupNo == null) {
                return null;
            }
            int beforeLongNoLenth = 0;
            for (Map.Entry<String, String> entry : this.spMGroupCaldimension.entrySet()) {
                String[] key = entry.getKey().split("_");
                if (!calRangeId.equals(key[0]) || !mGroupNo.startsWith(key[1]) || beforeLongNoLenth >= key[1].length()) continue;
                caldimension = entry.getValue();
                beforeLongNoLenth = key[1].length();
            }
        }
        return caldimension;
    }

    public Long getDivideBasisID() {
        return this.divideBasisID;
    }

    public CalRange getEmptyCalRange() {
        return this.emptyCalRange;
    }

    public List<CalRange> getNotEmptyCalRange() {
        return this.notEmptyCalRange;
    }

    public String[] getDivideBasis() {
        return this.divideBasis;
    }

    public Map<Long, CalRange> getRangeMap() {
        return this.rangeMap;
    }

    public Set<Long> getAllCalRangeId() {
        return this.rangeMap.keySet();
    }

    public Long getCalSystemId() {
        return this.calSystemId;
    }

    public Long getCalPolicyId() {
        return this.calPolicyId;
    }

    public Long getCalOrgId() {
        return this.calOrgId;
    }

    public Long getId() {
        return this.id;
    }

    public String getCostAccountName() {
        return this.costAccountName;
    }

    public Long getBookTypeId() {
        return this.bookTypeId;
    }

    public Long getCurrentPeriod() {
        return this.currentPeriod;
    }
}

