/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class CostPriceResultInfo {
    private boolean success;
    private String errMsg;
    private Long entryId = -1L;
    private boolean detail;
    private String srcPriceName;
    private String srcSchemeNum;
    private Map<Long, BigDecimal> costSubElementUnitcostMap = new HashMap<Long, BigDecimal>();
    private Map<String, BigDecimal> entryUnitcostMap = new HashMap<String, BigDecimal>();
    private BigDecimal totalUnitCost = null;
    private String srcBillno = "";
    private String srcSchemeName;

    public Long getEntryId() {
        return this.entryId;
    }

    public void setEntryId(Long entryId) {
        this.entryId = entryId;
    }

    public String getSrcSchemeNum() {
        return this.srcSchemeNum;
    }

    public void setSrcSchemeNum(String srcSchemeNum) {
        this.srcSchemeNum = srcSchemeNum;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public boolean isDetail() {
        return this.detail;
    }

    public void setDetail(boolean detail) {
        this.detail = detail;
    }

    public String getSrcPriceName() {
        return this.srcPriceName;
    }

    public void setSrcPriceName(String srcPriceName) {
        this.srcPriceName = srcPriceName;
    }

    public Map<Long, BigDecimal> getCostSubElementUnitcostMap() {
        return this.costSubElementUnitcostMap;
    }

    public void setCostSubElementUnitcostMap(Map<Long, BigDecimal> costSubElementUnitcostMap) {
        this.costSubElementUnitcostMap = costSubElementUnitcostMap;
    }

    public void putCostSubElementUnitcostMap(Long costSubElementId, BigDecimal unitCost) {
        this.costSubElementUnitcostMap.put(costSubElementId, unitCost);
    }

    public Map<String, BigDecimal> getEntryUnitcostMap() {
        return this.entryUnitcostMap;
    }

    public void setEntryUnitcostMap(Map<String, BigDecimal> entryUnitcostMap) {
        this.entryUnitcostMap = entryUnitcostMap;
    }

    public void putEntryUnitcostMap(String costName, BigDecimal unitCost) {
        this.entryUnitcostMap.put(costName, unitCost);
    }

    public String getCostPriceLog() {
        StringBuilder sb = new StringBuilder();
        sb.append("Price Scheme:\u3010");
        sb.append(this.srcSchemeNum);
        sb.append("\u3011\r\n");
        if (this.success) {
            sb.append("Cost Price:\u3010");
            sb.append(this.srcPriceName);
            sb.append("\u3011\r\n");
            sb.append("EntryId:\u3010");
            sb.append(this.entryId);
            sb.append("\u3011\r\n");
            sb.append("SrcBillno:\u3010");
            sb.append(this.srcBillno);
            sb.append("\u3011\r\n");
            sb.append("detail:\u3010");
            sb.append(this.costSubElementUnitcostMap.toString());
            sb.append("\u3011\r\n");
            sb.append("entry:\u3010");
            sb.append(this.entryUnitcostMap.toString());
            sb.append("\u3011\r\n");
        } else {
            sb.append("error:\u3010");
            sb.append(this.errMsg);
            sb.append("\u3011\r\n");
        }
        return sb.toString();
    }

    public String toString() {
        return this.getCostPriceLog();
    }

    public BigDecimal getTotalUnitCost() {
        return this.totalUnitCost;
    }

    public void setTotalUnitCost(BigDecimal totalUnitCost) {
        this.totalUnitCost = totalUnitCost;
    }

    public void refreshTotalUnitCost() {
        this.totalUnitCost = BigDecimal.ZERO;
        if (this.detail) {
            for (BigDecimal unitCost : this.costSubElementUnitcostMap.values()) {
                this.totalUnitCost = this.totalUnitCost.add(unitCost);
            }
        } else {
            for (BigDecimal unitCost : this.entryUnitcostMap.values()) {
                this.totalUnitCost = this.totalUnitCost.add(unitCost);
            }
        }
    }

    public String getSrcBillno() {
        return this.srcBillno;
    }

    public void setSrcBillno(String srcBillno) {
        this.srcBillno = srcBillno;
    }

    public void setSrcSchemeName(String srcSchemeName) {
        this.srcSchemeName = srcSchemeName;
    }

    public String getSrcSchemeName() {
        return this.srcSchemeName;
    }
}

