/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.calx.algox.CalCulateOutParams;
import kd.fi.calx.algox.CalOutDataRangeHolder;
import kd.fi.calx.algox.accounttype.AccountTypeEnum;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.groupbill.BizGroupReplaceSrcBillHelper;
import kd.fi.calx.algox.helper.AcctGroupModelHelper;
import kd.fi.calx.algox.helper.BizGroupRecordHelper;
import kd.fi.calx.algox.helper.CBFieldsQueryHelper;
import kd.fi.calx.algox.helper.CalBalanceModelHelper;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.helper.CommonSettingHelper;
import kd.fi.calx.algox.util.CommonUtils;

public class DataInputFactory {
    private static final String ALGOKEY = "kd.fi.cal.business.calculate.distributedout.DataInputFactory";
    private static final String MATERIALGROUPSTANDARD = "JBFLBZ";
    public static final int SPLIT_ID_SIZE = 100000;
    protected boolean isMatrix = false;
    private CBFieldsQueryHelper fieldHelper;
    private CalOutDataRangeHolder holder;
    private Set<Long> groupRecordIdSet = null;
    private Set<Long> costAdjustRecordIdSet = new HashSet<Long>(32);
    private static final int SPLIT_SIZE = 5000;
    private RowMeta bizDataMeta;
    private static final String[] ADJUSTBILL_CREATETYPE = new String[]{"G", "H", "K"};
    private Boolean isNewGroup = CalDbParamServiceHelper.getBoolean(CalDbParamConstant.ACCOUNTGROUP_NEWMODEL);
    protected Boolean isBizGroup = AcctGroupModelHelper.isBizGroupModel();
    private BizGroupRecordHelper bizGroupRecordHelper = null;
    private boolean onlyCurPeriodTgtBill = true;
    Set<Long> notUpdateBalBizTypeIds = CommonSettingHelper.getNotUpdBalBizType();
    Set<Long> calInvTypeIds = new HashSet<Long>(16);
    Set<Long> calInvSchemeIds = new HashSet<Long>(16);

    public void closeBizGroup() {
        if (this.bizGroupRecordHelper != null) {
            this.bizGroupRecordHelper.close();
        }
    }

    public DataInputFactory(CalOutDataRangeHolder holder, CalCulateOutParams param) {
        try (DataSet invSchemeDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_invscheme", (String)"id", (QFilter[])new QFilter("isforwardamount", "=", (Object)true).toArray(), null);){
            for (Row row : invSchemeDS) {
                this.calInvSchemeIds.add(row.getLong("id"));
            }
        }
        var4_4 = null;
        try (DataSet invTypeDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_invtype", (String)"id", (QFilter[])new QFilter("isforwardamount", "=", (Object)true).toArray(), null);){
            for (Row row : invTypeDS) {
                this.calInvTypeIds.add(row.getLong("id"));
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        this.fieldHelper = new CBFieldsQueryHelper();
        this.buildBizRowMeta();
        this.holder = holder;
    }

    private void buildBizRowMeta() {
        this.bizDataMeta = ORM.create().createRowMeta("cal_costrecord_subentity", this.getCostRecordBizField());
        this.bizDataMeta.getField("rowtype").setDataType((DataType)DataType.StringType);
        this.bizDataMeta.getField("createtype").setDataType((DataType)DataType.StringType);
        this.bizDataMeta.getField("costaccounttype").setDataType((DataType)DataType.LongType);
        this.bizDataMeta.getField("priceprecision").setDataType((DataType)DataType.IntegerType);
        this.bizDataMeta.getField("ordercol").setDataType((DataType)DataType.StringType);
        this.bizDataMeta.getField("calrangeid").setDataType((DataType)DataType.LongType);
        this.bizDataMeta.getField("costrecordentryid").setDataType((DataType)DataType.LongType);
        this.bizDataMeta.getField("bizentityobject").setDataType((DataType)DataType.StringType);
        this.bizDataMeta.getField("incostadjustentryid").setDataType((DataType)DataType.LongType);
        this.bizDataMeta.getField("accounttype").setDataType((DataType)DataType.StringType);
        this.bizDataMeta.getField("invbillnum").setDataType((DataType)DataType.StringType);
        this.bizDataMeta.getField("costpricesourcetype").setDataType((DataType)DataType.StringType);
        this.bizDataMeta.getField("enablejoincalute").setDataType((DataType)DataType.BooleanType);
    }

    public RowMeta getBizDataMeta() {
        return this.bizDataMeta;
    }

    public String[] getCaldimensionAndDivideBasisFields() {
        return this.fieldHelper.getCaldimensionAndDivideBasisFields();
    }

    public Input[] createInMaterialSeqInput() {
        QFilter filter = null;
        ArrayList<OrmInput> inputList = new ArrayList<OrmInput>(16);
        StringBuilder sb = new StringBuilder();
        sb.append("sortlistid,groupno,groupseq,material,headcalorg as calorg,costaccount,calrange,period as periodid");
        sb.append(",entryentity.seq as ingroupseq");
        sb.append(",entryentity.dividebasis as divideBasisStr,entryentity.dividebasisvalue as divideBasisValue");
        sb.append(",entryentity.caldimension as calDimensionStr,entryentity.caldimensionvalue as calDimensionValue");
        for (CalOutDataRangeHolder.CalOutRange range : this.holder.getCalOutRangeList()) {
            filter = filter != null ? filter.and("costaccount.id", "=", (Object)range.getCostAccountId()) : new QFilter("costaccount.id", "=", (Object)range.getCostAccountId());
            filter.and(new QFilter("calrange.id", "=", (Object)range.getCalRangeId()));
            if (!range.isAllMaterial()) {
                HashSet<Object> matIds = new HashSet<Object>(128);
                for (Set<Object> materialIds : range.getMaterialSetList()) {
                    matIds.addAll(materialIds);
                }
                filter.and("material", "in", matIds);
            }
            inputList.add(new OrmInput(ALGOKEY, "cal_sortresult", sb.toString(), filter != null ? filter.toArray() : null));
            filter = null;
        }
        return inputList.toArray(new Input[inputList.size()]);
    }

    public Input[] createOutSortInput() {
        QFilter filter = null;
        ArrayList<OrmInput> inputList = new ArrayList<OrmInput>(16);
        StringBuilder sb = new StringBuilder();
        sb.append("material,headcalorg as calorg,costaccount,calrange,period as periodid,");
        sb.append("groupno,groupseq");
        for (CalOutDataRangeHolder.CalOutRange range : this.holder.getCalOutRangeList()) {
            filter = filter != null ? filter.and("costaccount.id", "=", (Object)range.getCostAccountId()) : new QFilter("costaccount.id", "=", (Object)range.getCostAccountId());
            filter.and(new QFilter("calrange.id", "=", (Object)range.getCalRangeId()));
            if (!range.isAllMaterial()) {
                HashSet<Object> matIds = new HashSet<Object>(128);
                for (Set<Object> materialIds : range.getMaterialSetList()) {
                    matIds.addAll(materialIds);
                }
                filter.and("material", "in", matIds);
            }
            inputList.add(new OrmInput(ALGOKEY, "cal_sortresult", sb.toString(), filter != null ? filter.toArray() : null));
            filter = null;
        }
        return inputList.toArray(new Input[inputList.size()]);
    }

    public Input[] createBillGroupInput() {
        if (this.isBizGroup.booleanValue()) {
            DataSet groupDataSet = this.getBizGroupDS();
            groupDataSet = groupDataSet.select("groupid,costfields,costcolumn,iscompleted,type as grouptype,costrecordentryid as groupentryid,weight as groupweight,occupiedqty as groupoccupiedqty,groupno as groupgroupno");
            return new Input[]{new DataSetInput(groupDataSet)};
        }
        ArrayList<OrmInput> inputList = new ArrayList<OrmInput>();
        if (this.groupRecordIdSet == null) {
            this.groupRecordIdSet = new HashSet<Long>(16);
            DataSet groupIdDataSet = this.getGroupRecordDataSet();
            if (groupIdDataSet == null) {
                return null;
            }
            while (groupIdDataSet.hasNext()) {
                this.groupRecordIdSet.add(groupIdDataSet.next().getLong("id"));
            }
        }
        HashSet<Long> tempIdSet = new HashSet<Long>();
        RowMeta rowMeta = ORM.create().createRowMeta("cal_account_grouprecord", "TO_CHAR(id) as groupid,costfields,costcolumn,iscompleted,entryentity.type as grouptype,entryentity.costrecordentryid as groupentryid,entryentity.weight as groupweight,entryentity.occupiedqty as groupoccupiedqty,entryentity.groupno as groupgroupno ");
        rowMeta.getField("groupid").setDataType((DataType)DataType.StringType);
        for (Long groupid : this.groupRecordIdSet) {
            if (tempIdSet.size() >= 5000) {
                inputList.add(new OrmInput(ALGOKEY, "cal_account_grouprecord", "TO_CHAR(id) as groupid,costfields,costcolumn,iscompleted,entryentity.type as grouptype,entryentity.costrecordentryid as groupentryid,entryentity.weight as groupweight,entryentity.occupiedqty as groupoccupiedqty,entryentity.groupno as groupgroupno", new QFilter("id", "in", tempIdSet).toArray(), rowMeta));
                tempIdSet = new HashSet();
            }
            tempIdSet.add(groupid);
        }
        inputList.add(new OrmInput(ALGOKEY, "cal_account_grouprecord", "TO_CHAR(id) as groupid,costfields,costcolumn,iscompleted,entryentity.type as grouptype,entryentity.costrecordentryid as groupentryid,entryentity.weight as groupweight,entryentity.occupiedqty as groupoccupiedqty,entryentity.groupno as groupgroupno", new QFilter("id", "in", tempIdSet).toArray(), rowMeta));
        return inputList.toArray(new Input[inputList.size()]);
    }

    protected DataSet getBizGroupDS() {
        if (this.bizGroupRecordHelper == null) {
            String selectFields = "groupid,costfields,costcolumn,iscompleted,type,costrecordentryid,weight,occupiedqty,groupno,periodenddate,costaccount,bookdate,period,bizbillid,isbeforeperiod";
            this.bizGroupRecordHelper = new BizGroupRecordHelper(this.holder, selectFields);
        }
        DataSet groupBillRecordDS = this.bizGroupRecordHelper.getGroupBillRecordDS();
        Boolean replaceGroupSrc = CalDbParamServiceHelper.getBoolean(CalDbParamConstant.REPLACE_GROUP_SRC);
        if (replaceGroupSrc.booleanValue() && this.isMatrix) {
            groupBillRecordDS = new BizGroupReplaceSrcBillHelper().replace(groupBillRecordDS);
        }
        return groupBillRecordDS;
    }

    public DataSet createBillGroupDataSet() {
        String selectFields = "id as groupid,groupsetting.costfields as costfields,groupsetting.costcolumn as costcolumn,iscompleted,entryentity.type as grouptype,entryentity.costrecordentryid as groupentryid";
        return this.createBillGroupDataSet(selectFields);
    }

    public DataSet createBillGroupDataSet(String selectFields) {
        DataSet finalDataSet = null;
        if (this.groupRecordIdSet == null) {
            this.groupRecordIdSet = new HashSet<Long>(16);
            DataSet groupIdDataSet = this.getGroupRecordDataSet();
            if (groupIdDataSet == null) {
                return null;
            }
            while (groupIdDataSet.hasNext()) {
                this.groupRecordIdSet.add(groupIdDataSet.next().getLong("id"));
            }
        }
        HashSet<Long> tempIdSet = new HashSet<Long>(16);
        for (Long groupid : this.groupRecordIdSet) {
            if (tempIdSet.size() >= 5000) {
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_account_grouprecord", (String)selectFields, (QFilter[])new QFilter("id", "in", tempIdSet).toArray(), null);
                finalDataSet = finalDataSet == null ? dataSet : finalDataSet.union(dataSet);
                tempIdSet = new HashSet();
            }
            tempIdSet.add(groupid);
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_account_grouprecord", (String)selectFields, (QFilter[])new QFilter("id", "in", tempIdSet).toArray(), null);
        finalDataSet = finalDataSet == null ? dataSet : finalDataSet.union(dataSet);
        return finalDataSet;
    }

    private DataSet getGroupRecordDataSet() {
        DataSet groupIdDataSet = null;
        ArrayList<DataSet> groupIdDataSets = new ArrayList<DataSet>(16);
        for (CalOutDataRangeHolder.CalOutRange range : this.holder.getMergeRangeListNoRangeId()) {
            QFilter filter = new QFilter("entryentity.costaccount", "=", (Object)range.getCostAccountId());
            if (this.holder.isNeedCalculatedLater()) {
                filter.and("entryentity.period", ">=", (Object)range.getPeriodId());
            } else {
                filter.and("entryentity.period", "=", (Object)range.getPeriodId());
            }
            if (this.getOnlyCurPeriodTgtBill()) {
                filter.and("entryentity.type", "=", (Object)"1");
            }
            if (range.isAllMaterial()) {
                DataSet col = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_account_grouprecord", (String)"id", (QFilter[])filter.toArray(), null);
                if (groupIdDataSet == null) {
                    groupIdDataSet = col;
                    continue;
                }
                groupIdDataSets.add(col);
                continue;
            }
            HashSet<Object> matIds = new HashSet<Object>(128);
            for (Set<Object> materialIds : range.getMaterialSetList()) {
                matIds.addAll(materialIds);
            }
            QFilter mfilter = filter.copy();
            mfilter = mfilter.and("entryentity.material.id", "in", matIds);
            DataSet col = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_account_grouprecord", (String)"id", (QFilter[])mfilter.toArray(), null);
            if (groupIdDataSet == null) {
                groupIdDataSet = col;
                continue;
            }
            groupIdDataSets.add(col);
        }
        if (groupIdDataSet != null && !groupIdDataSets.isEmpty()) {
            groupIdDataSet = groupIdDataSet.union(groupIdDataSets.toArray(new DataSet[0]));
        }
        return groupIdDataSet;
    }

    public Input[] createMaterialGroupNoInput() {
        ArrayList<Object> inputList = new ArrayList<Object>();
        QFilter matCatgorFilter = new QFilter("standard.number", "=", (Object)MATERIALGROUPSTANDARD);
        boolean isAllMatrial = false;
        HashSet<Object> matIds = new HashSet<Object>(128);
        for (CalOutDataRangeHolder.CalOutRange range : this.holder.getMergeRangeListNoRangeId()) {
            boolean bl = isAllMatrial = isAllMatrial || range.isAllMaterial();
            if (isAllMatrial) break;
            for (Set<Object> materialIds : range.getMaterialSetList()) {
                matIds.addAll(materialIds);
            }
        }
        QFilter filter = new QFilter("material.id", "in", matIds);
        if (isAllMatrial) {
            inputList.add(new OrmInput(ALGOKEY, "bd_materialgroupdetail", "material,group.longnumber as materialGroupNo", new QFilter[]{matCatgorFilter}));
        } else {
            inputList.add(new OrmInput(ALGOKEY, "bd_materialgroupdetail", "material,group.longnumber as materialGroupNo", new QFilter[]{matCatgorFilter, filter}));
        }
        if (inputList.isEmpty()) {
            Algo algo = Algo.create((String)ALGOKEY);
            RowMeta matGroupMeta = ORM.create().createRowMeta("bd_materialgroupdetail", "material,group.longnumber as materialGroupNo");
            DataSet emptySet = algo.createDataSet(new ArrayList(), matGroupMeta);
            inputList.add(new DataSetInput(emptySet, matGroupMeta));
        }
        return inputList.toArray(new Input[inputList.size()]);
    }

    public Input[] createBalanceBizDataInput() {
        ArrayList<OrmInput> inputList = new ArrayList<OrmInput>();
        for (CalOutDataRangeHolder.CalOutRange range : this.holder.getMergeRangeListNoRangeId()) {
            Integer period = range.getPeriod();
            Long costAccountId = range.getCostAccountId();
            QFilter filter = new QFilter("period", "<", (Object)period);
            filter.and("endperiod", ">=", (Object)period);
            filter.and("costaccount.id", "=", (Object)costAccountId);
            filter.and("invtype", "in", this.calInvTypeIds);
            String qtyFiledName = "periodendqty";
            String costFiledName = "entryentity.sub_periodendactualcost";
            if (CalBalanceModelHelper.isNewBalance()) {
                qtyFiledName = "baseqty_bal";
                costFiledName = "actualcost_bal";
            }
            QFilter qtyFilter = new QFilter(qtyFiledName, "!=", (Object)BigDecimal.ZERO);
            qtyFilter.or(costFiledName, "!=", (Object)BigDecimal.ZERO);
            filter = filter.and(qtyFilter);
            RowMeta bizDataMeta = ORM.create().createRowMeta(CalBalanceModelHelper.getBalanceEntityName(true), this.getBalanceBizField(range.getPeriodId(), period));
            bizDataMeta.getField("billno").setDataType((DataType)DataType.StringType);
            bizDataMeta.getField("invzerocost").setDataType((DataType)DataType.BooleanType);
            bizDataMeta.getField("rowtype").setDataType((DataType)DataType.StringType);
            bizDataMeta.getField("createtype").setDataType((DataType)DataType.StringType);
            bizDataMeta.getField("costaccounttype").setDataType((DataType)DataType.LongType);
            bizDataMeta.getField("priceprecision").setDataType((DataType)DataType.IntegerType);
            bizDataMeta.getField("ordercol").setDataType((DataType)DataType.StringType);
            bizDataMeta.getField("calrangeid").setDataType((DataType)DataType.LongType);
            bizDataMeta.getField("costrecordentryid").setDataType((DataType)DataType.LongType);
            bizDataMeta.getField("bizbillid").setDataType((DataType)DataType.LongType);
            bizDataMeta.getField("biztypeid").setDataType((DataType)DataType.LongType);
            bizDataMeta.getField("bizbillentryid").setDataType((DataType)DataType.LongType);
            bizDataMeta.getField("calentryid").setDataType((DataType)DataType.LongType);
            bizDataMeta.getField("queuetype").setDataType((DataType)DataType.StringType);
            bizDataMeta.getField("iscalculated").setDataType((DataType)DataType.BooleanType);
            bizDataMeta.getField("isvoucher").setDataType((DataType)DataType.BooleanType);
            bizDataMeta.getField("isfivoucher").setDataType((DataType)DataType.BooleanType);
            bizDataMeta.getField("isrework").setDataType((DataType)DataType.BooleanType);
            bizDataMeta.getField("ispresent").setDataType((DataType)DataType.BooleanType);
            bizDataMeta.getField("billstatus").setDataType((DataType)DataType.StringType);
            bizDataMeta.getField("periodid").setDataType((DataType)DataType.LongType);
            bizDataMeta.getField("materialcost").setDataType((DataType)DataType.BigDecimalType);
            bizDataMeta.getField("fee").setDataType((DataType)DataType.BigDecimalType);
            bizDataMeta.getField("processcost").setDataType((DataType)DataType.BigDecimalType);
            bizDataMeta.getField("manufacturecost").setDataType((DataType)DataType.BigDecimalType);
            bizDataMeta.getField("resource").setDataType((DataType)DataType.BigDecimalType);
            bizDataMeta.getField("calbilltype").setDataType((DataType)DataType.StringType);
            bizDataMeta.getField("billnumber").setDataType((DataType)DataType.StringType);
            bizDataMeta.getField("billtypenum").setDataType((DataType)DataType.StringType);
            bizDataMeta.getField("billtypename").setDataType((DataType)DataType.StringType);
            bizDataMeta.getField("signnum").setDataType((DataType)DataType.IntegerType);
            bizDataMeta.getField("baseqty").setDataType((DataType)DataType.BigDecimalType);
            bizDataMeta.getField("actualcost").setDataType((DataType)DataType.BigDecimalType);
            bizDataMeta.getField("entryseq").setDataType((DataType)DataType.IntegerType);
            bizDataMeta.getField("entrystatus").setDataType((DataType)DataType.StringType);
            bizDataMeta.getField("cost").setDataType((DataType)DataType.BigDecimalType);
            bizDataMeta.getField("designatedcost").setDataType((DataType)DataType.BooleanType);
            bizDataMeta.getField("costpricesource").setDataType((DataType)DataType.StringType);
            bizDataMeta.getField("invbillnum").setDataType((DataType)DataType.StringType);
            bizDataMeta.getField("bizentityobject").setDataType((DataType)DataType.StringType);
            bizDataMeta.getField("incostadjustentryid").setDataType((DataType)DataType.LongType);
            bizDataMeta.getField("issubbillinvoiceverify").setDataType((DataType)DataType.BooleanType);
            bizDataMeta.getField("accounttype").setDataType((DataType)DataType.StringType);
            bizDataMeta.getField("invzerocost").setDataType((DataType)DataType.BooleanType);
            bizDataMeta.getField("costpricesourcetype").setDataType((DataType)DataType.StringType);
            bizDataMeta.getField("enablejoincalute").setDataType((DataType)DataType.BooleanType);
            if (range.isAllMaterial()) {
                inputList.add(new OrmInput(ALGOKEY, CalBalanceModelHelper.getBalanceEntityName(true), this.getBalanceBizField(range.getPeriodId(), period), filter.toArray(), bizDataMeta));
                continue;
            }
            for (Set<Object> materialIds : range.getMaterialSetList()) {
                HashSet<Object> matIds = new HashSet<Object>(128);
                matIds.addAll(materialIds);
                QFilter mfilter = filter.copy();
                mfilter.and("material.id", "in", matIds);
                inputList.add(new OrmInput(ALGOKEY, CalBalanceModelHelper.getBalanceEntityName(true), this.getBalanceBizField(range.getPeriodId(), period), mfilter.toArray(), bizDataMeta));
            }
        }
        return inputList.toArray(new Input[inputList.size()]);
    }

    public Input[] createFIFOBalDataInput() {
        ArrayList<DataSetInput> inputList = new ArrayList<DataSetInput>();
        QFilter q1 = new QFilter("endqty", "<>", (Object)0);
        q1.or("endcost", "<>", (Object)0);
        HashSet<Long> accountSet = new HashSet<Long>(16);
        for (CalOutDataRangeHolder.CalOutRange range : this.holder.getMergeRangeListNoRangeId()) {
            Integer period = range.getPeriod();
            Long costAccountId = range.getCostAccountId();
            if (accountSet.contains(costAccountId)) continue;
            accountSet.add(costAccountId);
            QFilter filter = new QFilter("costaccount.id", "=", (Object)costAccountId);
            filter.and(q1);
            if (range.isAllMaterial()) {
                DataSet data = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_balance_fifo", (String)this.getFIFOBalField(range.getPeriodId(), period), (QFilter[])filter.toArray(), null);
                inputList.add(new DataSetInput(data, this.bizDataMeta));
                continue;
            }
            HashSet<Object> matIds = new HashSet<Object>(128);
            for (Set<Object> materialIds : range.getMaterialSetList()) {
                matIds.addAll(materialIds);
            }
            QFilter mfilter = filter.copy();
            mfilter.and("material.id", "in", matIds);
            DataSet data = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_balance_fifo", (String)this.getFIFOBalField(range.getPeriodId(), period), (QFilter[])mfilter.toArray(), null);
            inputList.add(new DataSetInput(data, this.bizDataMeta));
        }
        return inputList.toArray(new Input[inputList.size()]);
    }

    public Input[] createFIFOPeriodBalDataInput() {
        ArrayList<DataSetInput> inputList = new ArrayList<DataSetInput>();
        QFilter q1 = new QFilter("beginqty", "<>", (Object)0);
        q1.or("begincost", "<>", (Object)0);
        HashSet<Long> accountSet = new HashSet<Long>(16);
        for (CalOutDataRangeHolder.CalOutRange range : this.holder.getMergeRangeListNoRangeId()) {
            Long periodId = range.getPeriodId();
            Long costAccountId = range.getCostAccountId();
            if (accountSet.contains(costAccountId)) continue;
            accountSet.add(costAccountId);
            QFilter filter = new QFilter("costaccount.id", "=", (Object)costAccountId);
            filter.and("period.id", "=", (Object)periodId);
            filter.and(q1);
            if (range.isAllMaterial()) {
                DataSet data = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_balance_fifo_period", (String)this.getFIFOPeriodBalField(), (QFilter[])filter.toArray(), null);
                inputList.add(new DataSetInput(data, this.bizDataMeta));
                continue;
            }
            HashSet<Object> matIds = new HashSet<Object>(128);
            for (Set<Object> materialIds : range.getMaterialSetList()) {
                matIds.addAll(materialIds);
            }
            QFilter mfilter = filter.copy();
            mfilter.and("material.id", "in", matIds);
            DataSet data = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_balance_fifo_period", (String)this.getFIFOPeriodBalField(), (QFilter[])mfilter.toArray(), null);
            inputList.add(new DataSetInput(data, this.bizDataMeta));
        }
        return inputList.toArray(new Input[inputList.size()]);
    }

    public Input[] createCostAdjustBizDataInput() {
        ArrayList<OrmInput> inputList = new ArrayList<OrmInput>();
        for (CalOutDataRangeHolder.CalOutRange range : this.holder.getCalOutRangeList()) {
            Long periodId = range.getPeriodId();
            Long costAccountId = range.getCostAccountId();
            QFilter filter = null;
            filter = this.holder.isNeedCalculatedLater() ? new QFilter("period.id", ">=", (Object)periodId) : new QFilter("period.id", "=", (Object)periodId);
            filter.and("costaccount.id", "=", (Object)costAccountId);
            filter.and("entryentity.calrange", "=", (Object)range.getCalRangeId());
            filter.and("createtype", "not in", (Object)ADJUSTBILL_CREATETYPE);
            filter.and("difftype", "=", (Object)"B");
            filter.and("isupdatecost", "=", (Object)Boolean.TRUE);
            if (range.isAllMaterial()) {
                DataSet data = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costadjust_subentity", (String)this.getCostAdjustBizField(), (QFilter[])filter.toArray(), null);
                for (Row row : data) {
                    long costRecordEntryId = row.getLong("costrecordentryid");
                    if (costRecordEntryId == 0L) continue;
                    this.costAdjustRecordIdSet.add(costRecordEntryId);
                }
                inputList.add(new OrmInput(ALGOKEY, "cal_costadjust_subentity", this.getCostAdjustBizField(), filter.toArray(), this.bizDataMeta));
                continue;
            }
            HashSet matIds = new HashSet(128);
            for (Set set : range.getMaterialSetList()) {
                matIds.addAll(set);
            }
            QFilter mFilter = filter.copy();
            mFilter.and("entryentity.material.id", "in", matIds);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costadjust_subentity", (String)this.getCostAdjustBizField(), (QFilter[])mFilter.toArray(), null);
            for (Row row : dataSet) {
                long costRecordEntryId = row.getLong("costrecordentryid");
                if (costRecordEntryId == 0L) continue;
                this.costAdjustRecordIdSet.add(costRecordEntryId);
            }
            inputList.add(new OrmInput(ALGOKEY, "cal_costadjust_subentity", this.getCostAdjustBizField(), mFilter.toArray(), this.bizDataMeta));
        }
        return inputList.toArray(new Input[inputList.size()]);
    }

    public Map<String, Set<Long>> getStdCostAdjust() {
        HashMap<String, Set<Long>> statusBill = new HashMap<String, Set<Long>>();
        for (CalOutDataRangeHolder.CalOutRange range : this.holder.getCalOutRangeList()) {
            Long periodId = range.getPeriodId();
            Long costAccountId = range.getCostAccountId();
            QFilter filter = new QFilter("period.id", "=", (Object)periodId);
            filter.and("costaccount.id", "=", (Object)costAccountId);
            filter.and("entryentity.calrange", "=", (Object)range.getCalRangeId());
            filter.and("createtype", "=", (Object)"WW-A5");
            filter.and("billstatus", "in", (Object)new String[]{"A", "B", "C"});
            DataSet data = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_stdcostdiffbill", (String)"id,billstatus", (QFilter[])filter.toArray(), null);
            for (Row row : data) {
                long id = row.getLong("id");
                String billStatus = row.getString("billstatus");
                if (id == 0L) continue;
                statusBill.putIfAbsent(billStatus, new HashSet());
                Set stdIds = (Set)statusBill.get(billStatus);
                stdIds.add(id);
            }
        }
        return statusBill;
    }

    public DataSet createCostAdjustBizDataSet() {
        DataSet finalDataSet = null;
        ArrayList<DataSet> finalDataSets = new ArrayList<DataSet>(16);
        for (CalOutDataRangeHolder.CalOutRange range : this.holder.getCalOutRangeList()) {
            Long periodId = range.getPeriodId();
            Long costAccountId = range.getCostAccountId();
            QFilter filter = null;
            filter = this.holder.isNeedCalculatedLater() ? new QFilter("period.id", ">=", (Object)periodId) : new QFilter("period.id", "=", (Object)periodId);
            filter.and("costaccount.id", "=", (Object)costAccountId);
            filter.and("createtype", "not in", (Object)ADJUSTBILL_CREATETYPE);
            filter.and("difftype", "=", (Object)"B");
            filter.and("isupdatecost", "=", (Object)Boolean.TRUE);
            if (range.isAllMaterial()) {
                DataSet data = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costadjust_subentity", (String)this.getCostAdjustBizField(), (QFilter[])filter.toArray(), null);
                if (finalDataSet == null) {
                    finalDataSet = data;
                    continue;
                }
                finalDataSets.add(data);
                continue;
            }
            HashSet<Object> matIds = new HashSet<Object>(128);
            for (Set<Object> materialIds : range.getMaterialSetList()) {
                matIds.addAll(materialIds);
            }
            QFilter mFilter = filter.copy();
            mFilter.and("entryentity.material.id", "in", matIds);
            DataSet data = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costadjust_subentity", (String)this.getCostAdjustBizField(), (QFilter[])mFilter.toArray(), null);
            if (finalDataSet == null) {
                finalDataSet = data;
                continue;
            }
            finalDataSets.add(data);
        }
        if (finalDataSet != null && !finalDataSets.isEmpty()) {
            finalDataSet = finalDataSet.union(finalDataSets.toArray(new DataSet[0]));
        }
        return finalDataSet;
    }

    public Input[] createCostRecordBizDataInput(String billNoFilterStr) {
        ArrayList<Object> inputList = new ArrayList<Object>();
        Algo algo = Algo.create((String)ALGOKEY);
        HashSet<String> accounttypeSet = new HashSet<String>(16);
        accounttypeSet.add(AccountTypeEnum.WEIGHTAVG.getValue());
        accounttypeSet.add(AccountTypeEnum.SPPRICE.getValue());
        for (CalOutDataRangeHolder.CalOutRange range : this.holder.getCalOutRangeList()) {
            QFilter filter = null;
            if (this.holder.isNeedCalculatedLater()) {
                filter = new QFilter("period.id", ">=", (Object)range.getPeriodId());
                filter.and("bookdate", ">=", (Object)range.getStartDate());
            } else {
                filter = new QFilter("period.id", "=", (Object)range.getPeriodId());
                filter.and("bookdate", ">=", (Object)range.getStartDate());
                filter.and("bookdate", "<=", (Object)range.getEndDate());
            }
            filter.and("costaccount.id", "=", (Object)range.getCostAccountId());
            filter.and("entry.calrange", "=", (Object)range.getCalRangeId());
            filter.and("isinitbill", "=", (Object)Boolean.FALSE);
            filter.and("issplitcreate", "=", (Object)Boolean.FALSE);
            filter.and("invscheme", "in", this.calInvSchemeIds);
            filter.and("entry.invtype", "in", this.calInvTypeIds);
            if (this.notUpdateBalBizTypeIds != null && !this.notUpdateBalBizTypeIds.isEmpty()) {
                filter.and("biztype", "not in", this.notUpdateBalBizTypeIds);
            }
            QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
            filter.and(billStatusf);
            if (StringUtils.isNotEmpty((CharSequence)billNoFilterStr)) {
                QFilter billNoFilter = QFilter.of((String)billNoFilterStr, (Object[])new Object[0]);
                accounttypeSet.add(AccountTypeEnum.WEIGHTAVG.getValue());
                accounttypeSet.add(AccountTypeEnum.SPPRICE.getValue());
                billNoFilter.and("entry.accounttype", "in", accounttypeSet);
                filter.and(billNoFilter);
            }
            if (range.isAllMaterial()) {
                if (StringUtils.isNotEmpty((CharSequence)billNoFilterStr)) {
                    RowMeta unCalubizDataMeta = ORM.create().createRowMeta("cal_costrecord_subentity", this.getUnCaluCostRecordBizField());
                    unCalubizDataMeta.getField("uncaluteentryname").setDataType((DataType)DataType.StringType);
                    inputList.add(new OrmInput(ALGOKEY, "cal_costrecord_subentity", this.getUnCaluCostRecordBizField(), filter.toArray(), unCalubizDataMeta));
                    continue;
                }
                inputList.add(new OrmInput(ALGOKEY, "cal_costrecord_subentity", this.getCostRecordBizField(), filter.toArray(), this.bizDataMeta));
                continue;
            }
            for (Set<Object> materialIds : range.getMaterialSetList()) {
                HashSet<Object> matIds = new HashSet<Object>(128);
                matIds.addAll(materialIds);
                QFilter mFilter = filter.copy();
                mFilter.and("entry.material.id", "in", matIds);
                if (StringUtils.isNotEmpty((CharSequence)billNoFilterStr)) {
                    RowMeta unCalubizDataMeta = ORM.create().createRowMeta("cal_costrecord_subentity", this.getUnCaluCostRecordBizField());
                    unCalubizDataMeta.getField("uncaluteentryname").setDataType((DataType)DataType.StringType);
                    inputList.add(new OrmInput(ALGOKEY, "cal_costrecord_subentity", this.getUnCaluCostRecordBizField(), mFilter.toArray(), unCalubizDataMeta));
                    continue;
                }
                inputList.add(new OrmInput(ALGOKEY, "cal_costrecord_subentity", this.getCostRecordBizField(), mFilter.toArray(), this.bizDataMeta));
            }
        }
        DataSet emptySet = algo.createDataSet(new ArrayList(), this.bizDataMeta);
        inputList.add(new DataSetInput(emptySet, this.bizDataMeta));
        return inputList.toArray(new Input[inputList.size()]);
    }

    public DataSet createCostRecordBizDataSet() {
        DataSet finalDataSet = null;
        ArrayList<DataSet> finalDataSets = new ArrayList<DataSet>(16);
        for (CalOutDataRangeHolder.CalOutRange range : this.holder.getCalOutRangeList()) {
            QFilter filter = null;
            if (this.holder.isNeedCalculatedLater()) {
                filter = new QFilter("period.id", ">=", (Object)range.getPeriodId());
                filter.and("bookdate", ">=", (Object)range.getStartDate());
            } else {
                filter = new QFilter("period.id", "=", (Object)range.getPeriodId());
                filter.and("bookdate", ">=", (Object)range.getStartDate());
                filter.and("bookdate", "<=", (Object)range.getEndDate());
            }
            filter.and("costaccount.id", "=", (Object)range.getCostAccountId());
            filter.and("entry.calrange", "=", (Object)range.getCalRangeId());
            filter.and("isinitbill", "=", (Object)Boolean.FALSE);
            filter.and("issplitcreate", "=", (Object)Boolean.FALSE);
            filter.and("invscheme", "in", this.calInvSchemeIds);
            filter.and("entry.invtype", "in", this.calInvTypeIds);
            if (this.notUpdateBalBizTypeIds != null && !this.notUpdateBalBizTypeIds.isEmpty()) {
                filter.and("biztype", "not in", this.notUpdateBalBizTypeIds);
            }
            if (range.isAllMaterial()) {
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costrecord_subentity", (String)this.getCostRecordBizField(), (QFilter[])filter.toArray(), null);
                if (finalDataSet == null) {
                    finalDataSet = dataSet;
                    continue;
                }
                finalDataSets.add(dataSet);
                continue;
            }
            HashSet<Object> matIds = new HashSet<Object>(128);
            for (Set<Object> materialIds : range.getMaterialSetList()) {
                matIds.addAll(materialIds);
            }
            QFilter mFilter = filter.copy();
            mFilter.and("entry.material.id", "in", matIds);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costrecord_subentity", (String)this.getCostRecordBizField(), (QFilter[])mFilter.toArray(), null);
            if (finalDataSet == null) {
                finalDataSet = dataSet;
                continue;
            }
            finalDataSets.add(dataSet);
        }
        if (finalDataSet != null && !finalDataSets.isEmpty()) {
            finalDataSet = finalDataSet.union(finalDataSets.toArray(new DataSet[0]));
        }
        return finalDataSet;
    }

    public Input[] createAllSplitData() {
        ArrayList<OrmInput> inputList = new ArrayList<OrmInput>();
        for (CalOutDataRangeHolder.CalOutRange range : this.holder.getMergeRangeListNoRangeId()) {
            QFilter filter = new QFilter("costaccount.id", "=", (Object)range.getCostAccountId());
            if (this.holder.isNeedCalculatedLater()) {
                filter.and("bookdate", ">=", (Object)range.getStartDate());
            } else {
                filter.and("bookdate", ">=", (Object)range.getStartDate());
                filter.and("bookdate", "<=", (Object)range.getEndDate());
            }
            filter.and("isinitbill", "=", (Object)Boolean.FALSE);
            filter.and("issplitcreate", "=", (Object)Boolean.TRUE);
            filter.and("writeoffstatus", "in", (Object)new String[]{"A", "B"});
            QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
            filter.and(billStatusf);
            RowMeta bizDataMeta = ORM.create().createRowMeta("cal_costrecord_subentity", this.getSplitCostRecordField());
            bizDataMeta.getField("calrangeid").setDataType((DataType)DataType.LongType);
            bizDataMeta.getField("ordercol").setDataType((DataType)DataType.StringType);
            bizDataMeta.getField("costrecordentryid").setDataType((DataType)DataType.LongType);
            bizDataMeta.getField("bizentityobject").setDataType((DataType)DataType.StringType);
            bizDataMeta.getField("incostadjustentryid").setDataType((DataType)DataType.LongType);
            bizDataMeta.getField("issubbillinvoiceverify").setDataType((DataType)DataType.BooleanType);
            bizDataMeta.getField("costpricesourcetype").setDataType((DataType)DataType.StringType);
            bizDataMeta.getField("baseqty").setDataType((DataType)DataType.BigDecimalType);
            bizDataMeta.getField("actualcost").setDataType((DataType)DataType.BigDecimalType);
            bizDataMeta.getField("materialcost").setDataType((DataType)DataType.BigDecimalType);
            bizDataMeta.getField("fee").setDataType((DataType)DataType.BigDecimalType);
            bizDataMeta.getField("processcost").setDataType((DataType)DataType.BigDecimalType);
            bizDataMeta.getField("manufacturecost").setDataType((DataType)DataType.BigDecimalType);
            bizDataMeta.getField("resource").setDataType((DataType)DataType.BigDecimalType);
            bizDataMeta.getField("cost").setDataType((DataType)DataType.BigDecimalType);
            if (range.isAllMaterial()) {
                inputList.add(new OrmInput(ALGOKEY, "cal_costrecord_subentity", this.getSplitCostRecordField(), filter.toArray(), bizDataMeta));
                continue;
            }
            HashSet<Object> matIds = new HashSet<Object>(128);
            for (Set<Object> materialIds : range.getMaterialSetList()) {
                matIds.addAll(materialIds);
            }
            filter.and("entry.material.id", "in", matIds);
            inputList.add(new OrmInput(ALGOKEY, "cal_costrecord_subentity", this.getSplitCostRecordField(), filter.toArray(), bizDataMeta));
        }
        return inputList.toArray(new Input[inputList.size()]);
    }

    public Input[] createAllGroupData() {
        Date maxDate = null;
        Date minDate = null;
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        ArrayList<OrmInput> costRecordList = new ArrayList<OrmInput>(16);
        HashSet<Long> tempGIds = new HashSet<Long>(16);
        DataSet entryIdSet = null;
        if (this.isBizGroup.booleanValue()) {
            String selectField = "costrecordentryid as entryentity.costrecordentryid,costaccount as entryentity.costaccount,bookdate as entryentity.bookdate,period as entryentity.period,periodenddate as entryentity.period.enddate";
            entryIdSet = this.getBizGroupDS();
            entryIdSet = entryIdSet.select(selectField);
        } else {
            ArrayList<OrmInput> accountGroupRecordList = new ArrayList<OrmInput>(16);
            for (Long gId : this.groupRecordIdSet) {
                tempGIds.add(gId);
                if (tempGIds.size() < 100000) continue;
                OrmInput tempInput = new OrmInput(ALGOKEY, "cal_account_grouprecord", "entryentity.costrecordentryid,entryentity.costaccount,entryentity.bookdate,entryentity.period,entryentity.period.enddate", new QFilter("id", "in", tempGIds).toArray());
                accountGroupRecordList.add(tempInput);
                tempGIds = new HashSet(100000);
            }
            OrmInput tempInput = new OrmInput(ALGOKEY, "cal_account_grouprecord", "entryentity.costrecordentryid,entryentity.costaccount,entryentity.bookdate,entryentity.period,entryentity.period.enddate", new QFilter("id", "in", tempGIds).toArray());
            accountGroupRecordList.add(tempInput);
            entryIdSet = Algo.create((String)this.getClass().getName()).createDataSet((Input[])accountGroupRecordList.toArray(new OrmInput[0]));
        }
        String sels = this.getSplitCostRecordField();
        String addPriceField = this.getAddPriceField();
        sels = addPriceField + sels;
        RowMeta RowMeta2 = this.getSplitRowMeta(sels);
        tempGIds = new HashSet(16);
        while (entryIdSet.hasNext()) {
            Row row = entryIdSet.next();
            Long costrecordentryid = row.getLong("entryentity.costrecordentryid");
            Date endDate = row.getDate("entryentity.period.enddate");
            Date bookDate = row.getDate("entryentity.bookdate");
            Long costaccountid = row.getLong("entryentity.costaccount");
            costAccountIds.add(costaccountid);
            tempGIds.add(costrecordentryid);
            if (endDate != null && (maxDate == null || maxDate.compareTo(endDate) < 0)) {
                maxDate = endDate;
            }
            if (bookDate != null && (minDate == null || minDate.after(bookDate))) {
                minDate = bookDate;
            }
            if (tempGIds.size() < 100000) continue;
            QFilter filter = new QFilter("entry.id", "in", tempGIds);
            filter = filter.and("issplitcreate", "=", (Object)Boolean.FALSE);
            filter = filter.and("costaccount", "in", costAccountIds);
            filter = filter.and("bookdate", "<=", (Object)maxDate);
            if (this.isNewGroup.booleanValue()) {
                filter = filter.and("bookdate", ">=", (Object)minDate);
            }
            OrmInput crInput = new OrmInput(ALGOKEY, "cal_costrecord_subentity", sels, filter.toArray(), RowMeta2);
            costRecordList.add(crInput);
            tempGIds = new HashSet(100000);
            costAccountIds = new HashSet(16);
            maxDate = null;
            minDate = null;
        }
        QFilter filter = new QFilter("entry.id", "in", tempGIds);
        filter = filter.and("issplitcreate", "=", (Object)Boolean.FALSE);
        filter = filter.and("costaccount", "in", costAccountIds);
        filter = filter.and("bookdate", "<=", maxDate);
        if (this.isNewGroup.booleanValue()) {
            filter = filter.and("bookdate", ">=", minDate);
        }
        OrmInput crInput = new OrmInput(ALGOKEY, "cal_costrecord_subentity", sels, filter.toArray(), RowMeta2);
        costRecordList.add(crInput);
        return (Input[])costRecordList.toArray(new OrmInput[0]);
    }

    private RowMeta getSplitRowMeta(String sels) {
        RowMeta RowMeta2 = ORM.create().createRowMeta("cal_costrecord_subentity", sels);
        RowMeta2.getField("ordercol").setDataType((DataType)DataType.StringType);
        RowMeta2.getField("calrangeid").setDataType((DataType)DataType.LongType);
        RowMeta2.getField("costrecordentryid").setDataType((DataType)DataType.LongType);
        RowMeta2.getField("bizentityobject").setDataType((DataType)DataType.StringType);
        RowMeta2.getField("incostadjustentryid").setDataType((DataType)DataType.LongType);
        RowMeta2.getField("issubbillinvoiceverify").setDataType((DataType)DataType.BooleanType);
        RowMeta2.getField("costpricesourcetype").setDataType((DataType)DataType.StringType);
        return RowMeta2;
    }

    public Input createCostRecordChildDataInput() {
        QFilter q = new QFilter("1", "!=", (Object)1);
        if (!this.costAdjustRecordIdSet.isEmpty()) {
            q = new QFilter("entry.id", "in", this.costAdjustRecordIdSet);
            q.and("costaccount", "in", this.holder.getCostAccountSet());
        }
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        q.and(billStatusf);
        DataSet recordDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costrecord", (String)"entry.ancestorentryid as ancestorentryid,entry.id as entryid", (QFilter[])q.toArray(), null);
        return new DataSetInput(recordDataSet);
    }

    public Input[] createRecentCostDataInput() {
        ArrayList<Object> inputList = new ArrayList<Object>();
        Algo algo = Algo.create((String)ALGOKEY);
        String selectFields = "id as recentcostid,costaccount,material,calrange as calrangeid," + this.fieldHelper.getAllCalFields("cal_recentcost");
        RowMeta recentCostDataMeta = ORM.create().createRowMeta("cal_recentcost", selectFields);
        HashSet<Long> queryedCostAccountIds = new HashSet<Long>(16);
        for (CalOutDataRangeHolder.CalOutRange range : this.holder.getMergeRangeListNoRangeId()) {
            if (queryedCostAccountIds.contains(range.getCostAccountId())) continue;
            queryedCostAccountIds.add(range.getCostAccountId());
            QFilter filter = new QFilter("costaccount.id", "=", (Object)range.getCostAccountId());
            filter.and("costsubelement.id", "=", (Object)773175233367685120L);
            if (range.isAllMaterial()) {
                inputList.add(new OrmInput(ALGOKEY, "cal_recentcost", selectFields, filter.toArray(), recentCostDataMeta));
                continue;
            }
            HashSet<Object> matIds = new HashSet<Object>();
            for (Set<Object> materialIds : range.getMaterialSetList()) {
                matIds.addAll(materialIds);
            }
            filter.and("material.id", "in", matIds);
            inputList.add(new OrmInput(ALGOKEY, "cal_recentcost", selectFields, filter.toArray(), recentCostDataMeta));
        }
        DataSet emptySet = algo.createDataSet(new ArrayList(), recentCostDataMeta);
        inputList.add(new DataSetInput(emptySet, this.bizDataMeta));
        return inputList.toArray(new Input[inputList.size()]);
    }

    private String getBalanceBizField(Long periodId, Integer period) {
        String s = ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"DataInputFactory_0", (String)"fi-calx-algox", (Object[])new Object[0]);
        String balanceFileds = "";
        if (CalBalanceModelHelper.isNewBalance()) {
            String dimFields = CalBalanceModelHelper.getDimFields(false);
            balanceFileds = " id as id,'0' as invzerocost,'' as billno,id as entryid,'0' as isrework," + dimFields + ",costaccount.name as costaccountname,costaccount.calsystem as calsystem,costaccount.calpolicy as calpolicy,costaccount.costtype as costtype,costaccount.booktype as costaccounttype,'' as calbilltype,periodid.begindate as bizdate,periodid.begindate as auditdate,'' as billnumber,'' as billtypenum,'" + s + "' as billtypename,0L as bizbillid,0L as biztypeid,0L as bizbillentryid,0L as calentryid,calorg,'0' as rowtype,0 as queuetype,0 as signnum,'1' as iscalculated,'0' as issubbillinvoiceverify," + periodId + " as periodid,baseqty_bal as baseqty,costaccount.calpolicy.currency as localcurrency,costaccount.calpolicy.currency.amtprecision as amtprecision,costaccount.calpolicy.currency.priceprecision as priceprecision,'0' as isvoucher,'0' as isfivoucher,'0' as ispresent,'A' as billstatus,' ' as createtype,actualcost_bal as actualcost,0 as materialcost,0 as fee,0 as processcost,0 as manufacturecost,0 as resource,0 as entryseq,0L as calrangeid,baseunit as baseunit,baseunit.precision as qtyprecision,'0' as ordercol,0L as costrecordentryid,'' as bizentityobject,0L as incostadjustentryid,'A' as accounttype,'0' as designatedcost,null as costpricesource,null as invbillnum,null as costpricesourcetype,'1' as enablejoincalute,'C' as entrystatus,costsubelement as elementid,actualcost_bal as cost";
        } else {
            balanceFileds = " id as id,'0' as invzerocost,'' as billno,id as entryid,'0' as isrework,costaccount,costaccount.name as costaccountname,costaccount.calsystem as calsystem,costaccount.calpolicy as calpolicy,costaccount.costtype as costtype,costaccount.booktype as costaccounttype,'' as calbilltype,periodid.begindate as bizdate,periodid.begindate as auditdate,'' as billnumber,'' as billtypenum,'" + s + "' as billtypename,0L as bizbillid,0L as biztypeid,0L as bizbillentryid,0L as calentryid,material," + this.fieldHelper.getAllCalFields("cal_balance") + ",'0' as rowtype,0 as queuetype,0 as signnum,'1' as iscalculated,'0' as issubbillinvoiceverify," + periodId + " as periodid,periodendqty as baseqty,costaccount.calpolicy.currency as localcurrency,costaccount.calpolicy.currency.amtprecision as amtprecision,costaccount.calpolicy.currency.priceprecision as priceprecision,'0' as isvoucher,'0' as isfivoucher,'0' as ispresent,'A' as billstatus,' ' as createtype,periodendactualcost as actualcost,0 as materialcost,0 as fee,0 as processcost,0 as manufacturecost,0 as resource,0 as entryseq,0L as calrangeid,baseunit as baseunit,baseunit.precision as qtyprecision,'0' as ordercol,0L as costrecordentryid,'' as bizentityobject,0L as incostadjustentryid,'A' as accounttype,'0' as designatedcost,null as costpricesource,null as invbillnum,null as costpricesourcetype,'1' as enablejoincalute,'C' as entrystatus,entryentity.costsubelement as elementid,entryentity.sub_periodendactualcost as cost";
        }
        return balanceFileds;
    }

    private String getFIFOBalField(Long periodId, Integer period) {
        String s = ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"DataInputFactory_0", (String)"fi-calx-algox", (Object[])new Object[0]);
        return " id as id,'0' as invzerocost,billno as billno,billentryid as entryid,'0' as isrework,costaccount,costaccount.name as costaccountname,costaccount.calsystem as calsystem,costaccount.calpolicy as calpolicy,costaccount.costtype as costtype,costaccount.booktype as costaccounttype,'' as calbilltype,bizdate as bizdate,auditdate as auditdate,billno as billnumber,'' as billtypenum,'" + s + "' as billtypename,0 as bizbillid,0L as biztypeid,0 as bizbillentryid,0 as calentryid,material," + this.fieldHelper.getAllCalFields("cal_balance_fifo") + ",'3' as rowtype,0 as queuetype,0 as signnum,'1' as iscalculated,'0' as issubbillinvoiceverify," + periodId + " as periodid,endqty as baseqty,currency as localcurrency,currency.amtprecision as amtprecision,currency.priceprecision as priceprecision,'0' as isvoucher,'0' as isfivoucher,'0' as ispresent,'A' as billstatus,' ' as createtype,endcost as actualcost,0 as materialcost,0 as fee,0 as processcost,0 as manufacturecost,0 as resource,entryseq as entryseq,calrange as calrangeid,baseunit as baseunit,baseunit.precision as qtyprecision,'0' as ordercol,0L as costrecordentryid,'' as bizentityobject,0L as incostadjustentryid,'A' as accounttype,'0' as designatedcost,null as costpricesource,null as invbillnum,null as costpricesourcetype,'1' as enablejoincalute,'C' as entrystatus,costsubelement as elementid,endcost as cost";
    }

    private String getFIFOPeriodBalField() {
        String s = ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"DataInputFactory_0", (String)"fi-calx-algox", (Object[])new Object[0]);
        return " id as id,'0' as invzerocost,billno as billno,billentryid as entryid,'0' as isrework,costaccount,costaccount.name as costaccountname,costaccount.calsystem as calsystem,costaccount.calpolicy as calpolicy,costaccount.costtype as costtype,costaccount.booktype as costaccounttype,'' as calbilltype,bizdate as bizdate,auditdate as auditdate,billno as billnumber,'' as billtypenum,'" + s + "' as billtypename,0 as bizbillid,0L as biztypeid,0 as bizbillentryid,0 as calentryid,material," + this.fieldHelper.getAllCalFields("cal_balance_fifo_period") + ",'4' as rowtype,0 as queuetype,0 as signnum,'1' as iscalculated,'0' as issubbillinvoiceverify,period as periodid,beginqty as baseqty,currency as localcurrency,currency.amtprecision as amtprecision,currency.priceprecision as priceprecision,'0' as isvoucher,'0' as isfivoucher,'0' as ispresent,'A' as billstatus,' ' as createtype,begincost as actualcost,0 as materialcost,0 as fee,0 as processcost,0 as manufacturecost,0 as resource,entryseq as entryseq,calrange as calrangeid,baseunit as baseunit,baseunit.precision as qtyprecision,'0' as ordercol,0L as costrecordentryid,'' as bizentityobject,0L as incostadjustentryid,'A' as accounttype,'0' as designatedcost,null as costpricesource,null as invbillnum,null as costpricesourcetype,'1' as enablejoincalute,'C' as entrystatus,costsubelement as elementid,begincost as cost";
    }

    private String getCostRecordBizField() {
        return "id,invscheme.zerocost as invzerocost,billno,entry.id as entryid,entry.isrework as isrework,costaccount,costaccount.name as costaccountname,costaccount.calsystem as calsystem,costaccount.calpolicy as calpolicy,costaccount.costtype as costtype,costaccount.booktype as costaccounttype,calbilltype,bookdate as bizdate,auditdate,billno as billnumber,billtype.number as billtypenum,billtype.name as billtypename,id as bizbillid,biztype as biztypeid,entry.bizbillentryid as bizbillentryid,entry.calentryid as calentryid,entry.material as material," + this.fieldHelper.getAllCalFields("cal_costrecord") + ",'1' as rowtype,entry.queuetype as queuetype,entry.signnum as signnum,entry.iscalculated as iscalculated,issubbillinvoiceverify,period as periodid,entry.baseqty as baseqty,localcurrency,localcurrency.amtprecision as amtprecision,localcurrency.priceprecision as priceprecision,isvoucher,isfivoucher,entry.ispresent as ispresent,billstatus,' ' as createtype,entry.actualcost as actualcost,entry.materialcost as materialcost,entry.fee as fee,entry.processcost as processcost,entry.manufacturecost as manufacturecost,entry.resource as resource,entry.seq as entryseq,0L as calrangeid,entry.baseunit as baseunit,entry.baseunit.precision as qtyprecision,case when entry.queuetype = '0' and entry.baseqty*entry.signnum > 0 then '1' when entry.queuetype = '0' and entry.baseqty*entry.signnum < 0 then '2' when entry.queuetype = '1' and entry.baseqty*entry.signnum > 0 then '2' else '1' end as ordercol,0L as costrecordentryid,bizentityobject,0L as incostadjustentryid,entry.accounttype as accounttype,entry.designatedcost as designatedcost,entry.costpricesource as costpricesource,null as invbillnum,null as costpricesourcetype,'1' as enablejoincalute,entry.entrystatus as entrystatus,entry.subentrycostelement.costsubelement as elementid,entry.subentrycostelement.sub_actualcost as cost";
    }

    protected String getSplitCostRecordField() {
        return "costaccount,costaccount.booktype as costaccounttype,id,invscheme.zerocost as invzerocost,entry.id as entryid,entry.isrework as isrework,entry.calentryid as calentryid,entry.ancestorentryid as ancestorentryid,entry.fatherentryid as parentid,period as periodid,isvoucher,issplitcreate,issplit,isinitbill,ischargeoff,ischargeoffed,writeofftype,auditdate,entry.material as material, " + this.fieldHelper.getAllCalFields("cal_costrecord_subentity") + ",entry.baseqty as baseqty,entry.queuetype as queuetype,entry.signnum as signnum,entry.accounttype as accounttype,entry.iscalculated as iscalculated,issubbillinvoiceverify,writeoffperiod,writeoffendperiod,writeoffstatus,entry.writeoffid as writeoffid,invscheme.bizdirection as invbizdirection,localcurrency,localcurrency.amtprecision as amtprecision,localcurrency.priceprecision as priceprecision,costaccount.calsystem as calsystem,costaccount.calpolicy as calpolicy,costaccount.calpolicy.exratetable as exratetable,costaccount.calpolicy.convertmode as convertmode,entry.actualcost as actualcost,entry.materialcost as materialcost,entry.fee as fee,entry.processcost as processcost,entry.manufacturecost as manufacturecost,entry.resource as resource,billno,entry.costpricesource as costpricesource,null as costpricesourcetype,entry.designatedcost as designatedcost,entry.seq as entryseq,0L as calrangeid,entry.baseunit as baseunit,entry.baseunit.precision as qtyprecision,case when entry.queuetype = '0' and entry.baseqty*entry.signnum > 0 then '1' when entry.queuetype = '0' and entry.baseqty*entry.signnum < 0 then '2' when entry.queuetype = '1' and entry.baseqty*entry.signnum > 0 then '2' else '1' end as ordercol,0L as costrecordentryid,bizentityobject,0L as incostadjustentryid,entry.entrystatus as entrystatus,entry.subentrycostelement.costsubelement as elementid,entry.subentrycostelement.sub_actualcost as cost";
    }

    private String getCostAdjustBizField() {
        String s = ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355", (String)"DataInputFactory_1", (String)"fi-calx-algox", (Object[])new Object[0]);
        return "id,'0' as invzerocost,billno,entryentity.id as entryid,'0' as isrework,costaccount,costaccount.name as costaccountname,costaccount.calsystem as calsystem,costaccount.calpolicy as calpolicy,costaccount.costtype as costtype,costaccount.booktype as costaccounttype, case when biztype = 'A' then 'IN' else 'OUT' end as calbilltype,entryentity.invbizdate as bizdate,entryentity.invauditdate as auditdate,billno as billnumber,'cal_costadjustbill' as billtypenum,'" + s + "' as billtypename,id as bizbillid,0L as biztypeid,entryentity.id as bizbillentryid,0 as calentryid,entryentity.material as material," + this.fieldHelper.getAllCalFields("cal_costadjustbill") + ",'2' as rowtype,entryentity.queuetype as queuetype,entryentity.signnum as signnum,'1' as iscalculated,'0' as issubbillinvoiceverify,period as periodid,0.0 as baseqty,currency as localcurrency,currency.amtprecision as amtprecision,currency.priceprecision as priceprecision,isvoucher,'0' as isfivoucher,'0' as ispresent,billstatus,createtype,entryentity.adjustamt as actualcost,0 as materialcost,0 as fee,0 as processcost,0 as manufacturecost,0 as resource,entryentity.seq as entryseq,0L as calrangeid,entryentity.baseunit as baseunit,entryentity.baseunit.precision as qtyprecision,case when biztype = 'A' then '1' else '2' end as ordercol,entryentity.invbillentryid as costrecordentryid,'cal_costadjustbill' as bizentityobject,entryentity.srcbillentryid as incostadjustentryid,entryentity.accounttype as accounttype,'0' as designatedcost,null as costpricesource,entryentity.invbillnum as invbillnum,null as costpricesourcetype,'1' as enablejoincalute,'C' as entrystatus,entryentity.subentryentity.costsubelement as elementid,entryentity.subentryentity.sub_adjustamt as cost";
    }

    private String getUnCaluCostRecordBizField() {
        return "entry.id as entryid,'1' as uncaluteentryname";
    }

    public Boolean getNewGroup() {
        return this.isNewGroup;
    }

    public Set<Long> getGroupRecordIdSet() {
        return this.groupRecordIdSet;
    }

    public void setOnlyCurPeriodTgtBill(boolean onlyCurPeriodTgtBill) {
        this.onlyCurPeriodTgtBill = onlyCurPeriodTgtBill;
    }

    private String getAddPriceField() {
        String addPriceField = "";
        String costRecAddPriceField = CalDbParamServiceHelper.getString("costrec_add_price", null);
        if (StringUtils.isNotEmpty((CharSequence)costRecAddPriceField)) {
            String fieldPath = CommonUtils.getFieldPath("cal_costrecord", costRecAddPriceField);
            addPriceField = fieldPath + " as addpricefield,";
        }
        return addPriceField;
    }

    public boolean getOnlyCurPeriodTgtBill() {
        return this.onlyCurPeriodTgtBill;
    }
}

