/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Field;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class DealReplaceSrcBillFunction
extends ReduceGroupFunction {
    protected static Log log = LogFactory.getLog(DealReplaceSrcBillFunction.class);
    private final RowMeta srcRowMeta;

    public DealReplaceSrcBillFunction(RowMeta rowMeta) {
        this.srcRowMeta = rowMeta;
    }

    public Iterator<Object[]> reduce(Iterator<Row> iter) {
        HashMap<Object, Object[]> srcGroupEIdRowMap = new HashMap<Object, Object[]>(16);
        HashMap<String, List> groupIdGroupInfosMap = new HashMap<String, List>(16);
        while (iter.hasNext()) {
            Row row = iter.next();
            String groupId = row.getString("groupid");
            Object[] objectArray = this.createNewRow(row);
            String groupType = row.getString("type");
            if (groupType.equals("0")) {
                srcGroupEIdRowMap.put(groupId, objectArray);
            }
            List dataList = groupIdGroupInfosMap.computeIfAbsent(groupId, k -> new ArrayList(16));
            dataList.add(objectArray);
        }
        RowMeta resultRowMeta = this.getResultRowMeta();
        for (Map.Entry entry : groupIdGroupInfosMap.entrySet()) {
            String groupId = (String)entry.getKey();
            List groupInfos = (List)entry.getValue();
            ArrayList<String> srcGroupIds = new ArrayList<String>(16);
            for (Object[] objects : groupInfos) {
                String srcGroupId = (String)objects[resultRowMeta.getFieldIndex("srcgroupid")];
                if (srcGroupId == null || !StringUtils.isNotEmpty((String)srcGroupId)) continue;
                srcGroupIds.add(srcGroupId);
            }
            if (srcGroupIds.isEmpty()) continue;
            ArrayList<Object[]> srcRows = null;
            int i = 0;
            while (!srcGroupIds.isEmpty()) {
                if (i >= 5) {
                    srcRows = null;
                    log.info("\u66ff\u6362\u6e90\u5355\u6210\u7ec4\u9012\u5f52\u5c42\u6570\u8d85\u9650");
                    break;
                }
                srcRows = new ArrayList<Object[]>(16);
                ArrayList<String> newSrcRowIds = new ArrayList<String>(16);
                for (String srcGroupId : srcGroupIds) {
                    Object[] srcRow = (Object[])srcGroupEIdRowMap.get(srcGroupId);
                    if (srcRow == null) continue;
                    srcRows.add(srcRow);
                    String newSrcGroupId = (String)srcRow[resultRowMeta.getFieldIndex("srcgroupid")];
                    if (newSrcGroupId == null || !StringUtils.isNotEmpty((String)newSrcGroupId)) continue;
                    newSrcRowIds.add(newSrcGroupId);
                }
                srcGroupIds = newSrcRowIds;
                ++i;
            }
            if (srcRows == null || srcRows.size() <= 0) continue;
            Iterator iterator = groupInfos.iterator();
            while (iterator.hasNext()) {
                Object[] groupInfo = (Object[])iterator.next();
                String groupType = (String)groupInfo[resultRowMeta.getFieldIndex("type")];
                if ("0".equals(groupType)) {
                    iterator.remove();
                }
                groupInfo[resultRowMeta.getFieldIndex((String)"iscompleted")] = false;
            }
            for (Object[] srcRow : srcRows) {
                Object[] newSrcRow = Arrays.asList(srcRow).toArray();
                newSrcRow[resultRowMeta.getFieldIndex((String)"groupid")] = groupId;
                newSrcRow[resultRowMeta.getFieldIndex((String)"iscompleted")] = false;
                groupInfos.add(newSrcRow);
            }
        }
        ArrayList dataList = new ArrayList(16);
        for (List groupInfos : groupIdGroupInfosMap.values()) {
            dataList.addAll(groupInfos);
        }
        return dataList.iterator();
    }

    public RowMeta getResultRowMeta() {
        return this.srcRowMeta;
    }

    private Object[] createNewRow(Row row) {
        RowMeta resultRowMeta = this.getResultRowMeta();
        int resultFieldCount = resultRowMeta.getFieldCount();
        Object[] newValues = new Object[resultFieldCount];
        Field[] srcFields = this.srcRowMeta.getFields();
        for (int i = 0; i < this.srcRowMeta.getFieldCount(); ++i) {
            newValues[i] = row.get(srcFields[i].getName());
        }
        return newValues;
    }
}

