/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox;

import java.util.ArrayList;
import java.util.Iterator;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.fi.calx.algox.util.ArrayUtils;

public class DealTgtGid2RelaGidFunction
extends ReduceGroupFunction {
    private final RowMeta srcRowMeta;

    public DealTgtGid2RelaGidFunction(RowMeta rowMeta) {
        this.srcRowMeta = rowMeta;
    }

    public Iterator<Object[]> reduce(Iterator<Row> iter) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(16);
        boolean isSrcBill = false;
        boolean isDstBill = false;
        String groupId = "";
        while (iter.hasNext()) {
            Row row = iter.next();
            String groupType = row.getString("type");
            if ("0".equals(groupType)) {
                isSrcBill = true;
            } else if ("1".equals(groupType)) {
                isDstBill = true;
                groupId = row.getString("groupid");
            }
            Object[] newValues = this.createNewRow(row);
            dataList.add(newValues);
        }
        if (isSrcBill && isDstBill) {
            RowMeta resultRowMeta = this.getResultRowMeta();
            for (Object[] objects : dataList) {
                objects[resultRowMeta.getFieldIndex((String)"srcgroupid")] = groupId;
                objects[resultRowMeta.getFieldIndex((String)"issrcandtgt")] = Boolean.TRUE;
            }
        }
        return dataList.iterator();
    }

    private Object[] createNewRow(Row row) {
        RowMeta resultRowMeta = this.getResultRowMeta();
        int resultFieldCount = resultRowMeta.getFieldCount();
        Object[] newValues = new Object[resultFieldCount];
        Field[] srcFields = this.srcRowMeta.getFields();
        for (int i = 0; i < this.srcRowMeta.getFieldCount(); ++i) {
            newValues[i] = row.get(srcFields[i].getName());
        }
        newValues[resultRowMeta.getFieldIndex((String)"srcgroupid")] = "";
        newValues[resultRowMeta.getFieldIndex((String)"issrcandtgt")] = Boolean.FALSE;
        return newValues;
    }

    public RowMeta getResultRowMeta() {
        return new RowMeta(ArrayUtils.concatAll(this.srcRowMeta.getFields(), new Field[][]{{new Field("srcgroupid", (DataType)DataType.StringType), new Field("issrcandtgt", (DataType)DataType.BooleanType)}}));
    }
}

