/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algo.output.IgnoreOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.FilterFunction;
import kd.bos.algox.FlatMapFunction;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.config.client.util.JSONUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.calx.algox.CalCulateOutParams;
import kd.fi.calx.algox.CalOutDataRangeHolder;
import kd.fi.calx.algox.CostAccount;
import kd.fi.calx.algox.CostSubElement;
import kd.fi.calx.algox.DataInputFactory;
import kd.fi.calx.algox.ParamCache;
import kd.fi.calx.algox.accounttype.AccountTypeEnum;
import kd.fi.calx.algox.balance.BalanceCalculator;
import kd.fi.calx.algox.balance.BalanceSourceEnum;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.function.BuildCostRecordUpdateInfoFunction;
import kd.fi.calx.algox.function.CommonInfo;
import kd.fi.calx.algox.function.CostAdjustDeleteFunction;
import kd.fi.calx.algox.function.CostRecordUpdateFunction;
import kd.fi.calx.algox.function.FilterBalanceByCalRangeFunction;
import kd.fi.calx.algox.function.GroupIdBakFunction;
import kd.fi.calx.algox.function.GroupRecordAggFunction;
import kd.fi.calx.algox.function.MatchCalRangeFunction;
import kd.fi.calx.algox.function.MatchGroupDataFunction;
import kd.fi.calx.algox.function.MatchRecentCostCostDomainFunction;
import kd.fi.calx.algox.function.MoveAddAccountTypeFunction;
import kd.fi.calx.algox.function.RecentCostUpdateInfoFunction;
import kd.fi.calx.algox.function.SubElementCostDealFunction;
import kd.fi.calx.algox.helper.BalanceInvokeHelper;
import kd.fi.calx.algox.helper.CalBalanceModelHelper;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.helper.CalServiceHelper;
import kd.fi.calx.algox.helper.CostAccountGroupRecordHelper;
import kd.fi.calx.algox.helper.CustomEventCallHelper;
import kd.fi.calx.algox.helper.FIFOPeriodDataCalculate;
import kd.fi.calx.algox.helper.GPAPrevCostAdjustHelper;
import kd.fi.calx.algox.helper.StopSyncSettingModifyHelper;
import kd.fi.calx.algox.matrix.CalOutByMatrixService;
import kd.fi.calx.algox.util.CommonUtils;
import kd.fi.calx.algox.util.DataSetUtil;
import org.apache.flink.util.SerializedThrowable;

public class MoveAvgIntimeCalculateOutService {
    private static final Log logger = LogFactory.getLog(MoveAvgIntimeCalculateOutService.class);
    private static final String DLOCK_KEY = "calx_calculateout#";
    private static final Long CHECKBEFORETASK_ID = 1228995490352290816L;
    private static final Long CHECKAFTERTASK_ID = 1234050040448761856L;
    public static final String WRITE_HEADID_SQL = "update t_cal_task set fresultparams_tag = ? where fid = ? ";
    private String taskId;
    private DynamicObject progressInfo;
    private DynamicObject taskInfo;
    private Map<Long, DynamicObject> progressEntryMap = new HashMap<Long, DynamicObject>(16);
    private long startTime = 0L;
    private Integer BALUPDATE_BATCHSIZE = CalDbParamServiceHelper.getInteger(CalDbParamConstant.BALUPDATE_BATCHSIZE);
    private Integer COSTRECORDUPDATE_BATCHSIZE = CalDbParamServiceHelper.getInteger(CalDbParamConstant.COSTRECORDUPDATE_BATCHSIZE);

    public MoveAvgIntimeCalculateOutService() {
    }

    public MoveAvgIntimeCalculateOutService(String taskId) {
        this.taskId = taskId;
        this.taskInfo = BusinessDataServiceHelper.loadSingle((Object)taskId, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cal_task"));
        QFilter q = new QFilter("taskid", "=", (Object)Long.valueOf(taskId));
        this.progressInfo = BusinessDataServiceHelper.loadSingle((String)"cal_progress", (String)"id,progress,entry.status,entry.time,entry.step,entry.errorinfo,entry.errorinfo_tag", (QFilter[])q.toArray());
        for (DynamicObject entry : this.progressInfo.getDynamicObjectCollection("entry")) {
            this.progressEntryMap.put(entry.getDynamicObject("step").getLong("id"), entry);
        }
    }

    public String calCulateOutAsync(CalCulateOutParams param) {
        HashMap<String, String> jobParams = new HashMap<String, String>();
        try {
            jobParams.put("param", JSONUtils.toString((Object)param));
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        jobParams.put("taskid", this.taskId);
        JobInfo job = new JobInfo();
        String OpName = String.format(ResManager.loadKDString((String)"\u51fa\u5e93\u6838\u7b97 \u64cd\u4f5c\u4eba: %1$s", (String)"CalculateOutCostPlugin_8", (String)"fi-calx-algox", (Object[])new Object[0]), RequestContext.get().getUserName());
        job.setName(OpName);
        job.setTaskDefineId("2TEF93NS2PXT");
        job.setRunByLang(Lang.get());
        job.setJobType(JobType.REALTIME);
        job.setParams(jobParams);
        job.setAppId("calx");
        job.setRunByLang(Lang.get());
        job.setTaskClassname("kd.fi.calx.formplugin.calculate.out.CalculateOutTask");
        job.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        return JobClient.dispatch((JobInfo)job);
    }

    public String calCulateOutAsync(CalCulateOutParams param, int batch, int size, String timestampStr) {
        HashMap<String, String> jobParams = new HashMap<String, String>();
        try {
            jobParams.put("param", JSONUtils.toString((Object)param));
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        jobParams.put("taskid", this.taskId);
        JobInfo job = new JobInfo();
        String OpName = ResManager.loadKDString((String)"\u51fa\u5e93\u6838\u7b97\u3010%1$s\u3011\u7b2c\u3010%2$s\u3011\u6279\uff0c\u64cd\u4f5c\u4eba:%3$s", (String)"CalculateOutCostPlugin_20", (String)"fi-calx-algox", (Object[])new Object[0]);
        OpName = String.format(OpName, timestampStr, batch + "/" + size, RequestContext.get().getUserName());
        job.setName(OpName);
        job.setTaskDefineId("2TEF93NS2PXT");
        job.setJobType(JobType.BIZ);
        job.setParams(jobParams);
        job.setAppId("calx");
        job.setRunByLang(Lang.get());
        job.setTaskClassname("kd.fi.calx.formplugin.calculate.out.CalculateOutTask");
        job.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        return JobClient.dispatch((JobInfo)job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void calCulateOut(CalCulateOutParams param) throws KDBizException {
        Iterator t2;
        this.startTime = System.currentTimeMillis();
        this.setProgress(10, 0L, 0L, null, 1047020178682303488L);
        CalOutDataRangeHolder holder = null;
        CommonInfo commonInfo = null;
        Map<String, Integer> runningModeMap = param.getRunningModeMap();
        ArrayList<DLock> lockList = new ArrayList<DLock>(16);
        ArrayList<String> lockStrings = new ArrayList<String>(16);
        IAppCache calCache = AppCache.get((String)"cal");
        String userName = RequestContext.get().getUserName();
        try {
            block76: {
                try {
                    if (!param.isSubTask()) {
                        CostAccountGroupRecordHelper.refreshGroupRecordByTime();
                    }
                    holder = new CalOutDataRangeHolder(param);
                    Set<Long> costAccountIds = holder.getCostAccountSet();
                    commonInfo = this.buildCommonInfo(param, holder);
                    this.setProgress(15);
                    if (param.isSubTask()) break block76;
                    Map<Long, String> runningTaskCostAccountMap = this.getRunningTaskCostAccountIds();
                    for (Long costAccountId : costAccountIds) {
                        String lockKey = DLOCK_KEY + costAccountId;
                        DLock lock = DLock.create((String)lockKey);
                        lockList.add(lock);
                        String useName = null;
                        if (!lock.tryLock()) {
                            useName = (String)calCache.get(lockKey, String.class);
                        }
                        if (runningTaskCostAccountMap.get(costAccountId) != null) {
                            useName = runningTaskCostAccountMap.get(costAccountId);
                        }
                        if (useName != null) {
                            String msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u4e0b\u5b58\u5728\u6b63\u5728\u8fd0\u884c\u4e2d\u7684\u51fa\u5e93\u6838\u7b97\u4efb\u52a1\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"CalculateOutService_5", (String)"fi-calx-algox", (Object[])new Object[0]), holder.getCostAccountMap().get(costAccountId).getCostAccountName());
                            throw new KDBizException(msg);
                        }
                        lockStrings.add(lockKey);
                        calCache.put(lockKey, (Object)userName);
                    }
                    this.addLock(runningModeMap, holder.getCalorgMapPeriod().keySet());
                    if (0 != param.getRunningModeMap().get(AccountTypeEnum.FIFO.getValue())) {
                        this.calFIFOBalBegin(holder);
                    }
                    if (param.isInvockCostprice4Rework() && commonInfo.enableRework()) {
                        commonInfo.invockCostprice4Rework(param);
                    }
                }
                catch (KDBizException e) {
                    this.setProgress(20, 1047020178682303488L, System.currentTimeMillis() - this.startTime, CommonUtils.getLogMessage(e), 0L);
                    throw e;
                }
                catch (Throwable t2) {
                    logger.error("\u51fa\u5e93\u6838\u7b97\u51fa\u73b0\u5f02\u5e38", t2);
                    this.setProgress(20, 1047020178682303488L, System.currentTimeMillis() - this.startTime, CommonUtils.getLogMessage(t2), 0L);
                    throw t2;
                }
            }
            this.doCalculateOut(param, holder, commonInfo);
        }
        catch (Throwable throwable) {
            Iterator iterator;
            try {
                if (!param.isSubTask() && holder != null) {
                    this.releaseLock(runningModeMap, holder.getCalorgMapPeriod().keySet());
                }
                iterator = lockList.iterator();
            }
            catch (Throwable throwable2) {
                for (DLock lock : lockList) {
                    lock.close();
                }
                for (String lockString : lockStrings) {
                    calCache.remove(lockString);
                }
                this.setProgress(100);
                if (this.taskInfo == null) throw throwable2;
                this.taskInfo.set("endtime", (Object)TimeServiceHelper.now());
                this.taskInfo.set("status", (Object)"A");
                try (TXHandle tx = TX.requiresNew();){
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.taskInfo});
                    throw throwable2;
                }
            }
            while (iterator.hasNext()) {
                DLock lock = (DLock)iterator.next();
                lock.close();
            }
            for (String lockString : lockStrings) {
                calCache.remove(lockString);
            }
            this.setProgress(100);
            if (this.taskInfo != null) {
                this.taskInfo.set("endtime", (Object)TimeServiceHelper.now());
                this.taskInfo.set("status", (Object)"A");
                try (TXHandle tx = TX.requiresNew();){
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.taskInfo});
                }
            }
            Algo.closeAllDataSet();
            throw throwable;
        }
        try {
            if (!param.isSubTask() && holder != null) {
                this.releaseLock(runningModeMap, holder.getCalorgMapPeriod().keySet());
            }
            t2 = lockList.iterator();
        }
        catch (Throwable throwable) {
            for (DLock lock : lockList) {
                lock.close();
            }
            for (String lockString : lockStrings) {
                calCache.remove(lockString);
            }
            this.setProgress(100);
            if (this.taskInfo == null) throw throwable;
            this.taskInfo.set("endtime", (Object)TimeServiceHelper.now());
            this.taskInfo.set("status", (Object)"A");
            try (TXHandle tx = TX.requiresNew();){
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.taskInfo});
                throw throwable;
            }
        }
        while (t2.hasNext()) {
            DLock lock = (DLock)t2.next();
            lock.close();
        }
        for (String lockString : lockStrings) {
            calCache.remove(lockString);
        }
        this.setProgress(100);
        if (this.taskInfo != null) {
            this.taskInfo.set("endtime", (Object)TimeServiceHelper.now());
            this.taskInfo.set("status", (Object)"A");
            try (TXHandle tx = TX.requiresNew();){
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.taskInfo});
            }
        }
        Algo.closeAllDataSet();
    }

    private Map<Long, String> getRunningTaskCostAccountIds() {
        DynamicObject[] allMainTasks;
        HashMap<Long, String> runningTaskCostAccountIdMap = new HashMap<Long, String>(16);
        Calendar now = Calendar.getInstance();
        now.set(5, now.get(5) - 1);
        QFilter mainTaskFilter = new QFilter("ismaintask", "=", (Object)"1");
        mainTaskFilter.and("starttime", ">", (Object)now.getTime());
        mainTaskFilter.and("status", "=", (Object)"B");
        mainTaskFilter.and("tasktype", "=", (Object)"A");
        for (DynamicObject mainTask : allMainTasks = BusinessDataServiceHelper.load((String)"cal_task", (String)"id,calnumber,params_tag,creator.name", (QFilter[])mainTaskFilter.toArray())) {
            String params = mainTask.getString("params_tag");
            try {
                CalCulateOutParams runningParam = (CalCulateOutParams)kd.bos.util.JSONUtils.cast((String)params, CalCulateOutParams.class);
                Long runnintCostAccountId = runningParam.getEntrys().values().iterator().next().getCostAccountId();
                runningTaskCostAccountIdMap.put(runnintCostAccountId, mainTask.getString("creator.name"));
            }
            catch (IOException e) {
                logger.error("\u83b7\u53d6\u8fd0\u884c\u4e2d\u7684\u51fa\u5e93\u6838\u7b97\u4efb\u52a1\u6210\u672c\u8d26\u7c3f\u53cd\u5e8f\u5217\u5316\u9519\u8bef", (Throwable)e);
            }
        }
        return runningTaskCostAccountIdMap;
    }

    private void addLock(Map<String, Integer> runningModeMap, Set<Long> calOrgIdSet) {
        if (runningModeMap.get(AccountTypeEnum.MOVEDAVG_INTIME.getValue()) != 0) {
            new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, AccountTypeEnum.MOVEDAVG_INTIME.getValue(), null, new HashSet<Long>(), true);
        }
        if (runningModeMap.get(AccountTypeEnum.FIFO.getValue()) != 0) {
            new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, AccountTypeEnum.FIFO.getValue(), null, new HashSet<Long>(), true);
        }
    }

    private void releaseLock(Map<String, Integer> runningModeMap, Set<Long> calOrgIdSet) {
        if (runningModeMap.get(AccountTypeEnum.MOVEDAVG_INTIME.getValue()) != 0) {
            new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, AccountTypeEnum.MOVEDAVG_INTIME.getValue(), null, new HashSet<Long>(), false);
        }
        if (runningModeMap.get(AccountTypeEnum.FIFO.getValue()) != 0) {
            new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, AccountTypeEnum.FIFO.getValue(), null, new HashSet<Long>(), false);
        }
    }

    private void doCalculateOut(CalCulateOutParams param, CalOutDataRangeHolder holder, CommonInfo commonInfo) {
        if (param.getCheckItems().get("D") == null) {
            this.setProgress(20, 1047020178682303488L, System.currentTimeMillis() - this.startTime, null, 1043473988375819264L);
        } else {
            this.setProgress(20, 1047020178682303488L, System.currentTimeMillis() - this.startTime, null, 1229515981550833664L);
            this.startTime = System.currentTimeMillis();
            try {
                Map<String, Map<Integer, Object>> calOutRangeMap = this.getCalOutRangeMap(holder, commonInfo.isVoucherdutweightedavgat());
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalOutDataCheckService", (String)"doCalOutDataCheck", (Object[])new Object[]{calOutRangeMap, param.getCheckItems().get("D"), this.taskId, CHECKBEFORETASK_ID});
                String checkStatus = this.getCheckStatus(CHECKBEFORETASK_ID);
                if (!"A".equals(checkStatus) && !"E".equals(checkStatus)) {
                    this.setProgress(50, 1229515981550833664L, System.currentTimeMillis() - this.startTime, "fail", 0L);
                    return;
                }
                this.setProgress(50, 1229515981550833664L, System.currentTimeMillis() - this.startTime, null, 1043473988375819264L);
                this.setProgressStatus(1229515981550833664L, checkStatus);
            }
            catch (Exception e) {
                this.setProgress(50, 1229515981550833664L, System.currentTimeMillis() - this.startTime, e.getMessage(), 0L);
                logger.info("\u51fa\u5e93\u6838\u7b97(\u524d)\u6267\u884c\u68c0\u67e5\u9879\u5fae\u670d\u52a1\u51fa\u9519:", (Object)e);
                return;
            }
        }
        this.startTime = System.currentTimeMillis();
        JobSession session = AlgoX.createSession((String)"kd.fi.calx.algox.CalculateOutService");
        String calcModel = CalDbParamServiceHelper.getString(CalDbParamConstant.CALCULATEOUT_MODEL, null);
        String resultId = null;
        DataInputFactory factory = null;
        if ("A".equals(calcModel)) {
            resultId = this.calculateByNomal(param, holder, commonInfo, session, factory);
        } else {
            try {
                CalOutByMatrixService calService = new CalOutByMatrixService(param, holder, commonInfo);
                resultId = calService.calCulateOut(param, holder, session);
            }
            catch (Exception e) {
                this.setProgress(55, 1043473988375819264L, System.currentTimeMillis() - this.startTime, CommonUtils.getLogMessage(e), 0L);
                throw e;
            }
        }
        try {
            this.setProgress(55, 1043473988375819264L, System.currentTimeMillis() - this.startTime, null, 1043474328139609088L);
            logger.info("\u51fa\u5e93\u6838\u7b97\u53d6\u6570\u4ee5\u53ca\u5206\u5e03\u5f0f\u8ba1\u7b97\u62d3\u6251\u7ed3\u6784\u6784\u5efa\u8017\u65f6:" + (System.currentTimeMillis() - this.startTime));
            this.startTime = System.currentTimeMillis();
            try {
                session.commit(10, TimeUnit.HOURS);
                logger.info("\u51fa\u5e93\u6838\u7b97\u5206\u5e03\u5f0f\u8ba1\u7b97\u8017\u65f6:" + (System.currentTimeMillis() - this.startTime));
            }
            catch (Exception e) {
                logger.error("\u51fa\u5e93\u6838\u7b97\u53d6\u6570\u4ee5\u53ca\u5206\u5e03\u5f0f\u8ba1\u7b97\u62d3\u6251\u7ed3\u6784\u5f02\u5e38", (Throwable)e);
                this.setProgress(80, 1043474328139609088L, System.currentTimeMillis() - this.startTime, CommonUtils.getLogMessage(e), 0L);
                throw e;
            }
            finally {
                if (factory != null) {
                    factory.closeBizGroup();
                }
            }
            this.setProgress(80, 1043474328139609088L, System.currentTimeMillis() - this.startTime, null, 1043474456359482368L);
            this.startTime = System.currentTimeMillis();
            try {
                DataSet recordEntryIdSet = session.readDataSet(resultId);
                Integer maxSize = CalDbParamServiceHelper.getInteger(CalDbParamConstant.COST_UPDATE_NOTICE_OPENDETAIL_COUNT);
                boolean isDetail = true;
                Set<String> salOutBillNums = MoveAvgIntimeCalculateOutService.getSalOutBillNums();
                HashSet<Long> recordIds = new HashSet<Long>(10000);
                HashSet<Long> entryIdSet = new HashSet<Long>(16);
                HashSet<Long> headIdSet = new HashSet<Long>(16);
                ArrayList fieldList = new ArrayList(20);
                Collections.addAll(fieldList, recordEntryIdSet.getRowMeta().getFieldNames());
                for (Row row : recordEntryIdSet) {
                    String billTypeNum = row.getString("billtypenum");
                    if (recordIds.size() > maxSize) {
                        isDetail = false;
                    }
                    entryIdSet.add(row.getLong("entryid"));
                    if (fieldList.contains("headid")) {
                        if (salOutBillNums.contains(billTypeNum)) {
                            recordIds.add(row.getLong("headid"));
                        }
                        headIdSet.add(row.getLong("headid"));
                        continue;
                    }
                    if (salOutBillNums.contains(billTypeNum)) {
                        recordIds.add(row.getLong("id"));
                    }
                    headIdSet.add(row.getLong("id"));
                }
                CustomEventCallHelper.calDeliveryAccEventCall(holder, isDetail, recordIds);
                if (!headIdSet.isEmpty() && !entryIdSet.isEmpty()) {
                    HashSet<Long> partSet;
                    boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
                    if (isNewBalance && param.isSubTask()) {
                        try {
                            String str = JSONUtils.toString(headIdSet);
                            DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)WRITE_HEADID_SQL, (Object[])new Object[]{str, Long.valueOf(this.taskId)});
                        }
                        catch (IOException e) {
                            throw new KDBizException(e.getMessage());
                        }
                    } else if (isNewBalance && !param.isSubTask()) {
                        partSet = new HashSet(this.BALUPDATE_BATCHSIZE);
                        for (Long id : headIdSet) {
                            partSet.add(id);
                            if (partSet.size() < this.BALUPDATE_BATCHSIZE) continue;
                            new BalanceInvokeHelper().updateBalance(partSet, BalanceSourceEnum.CAL_OUTCOST);
                            partSet.clear();
                        }
                        if (!partSet.isEmpty()) {
                            new BalanceInvokeHelper().updateBalance(partSet, BalanceSourceEnum.CAL_OUTCOST);
                        }
                    } else {
                        partSet = new HashSet<Long>(this.BALUPDATE_BATCHSIZE);
                        for (Long id : entryIdSet) {
                            partSet.add(id);
                            if (partSet.size() < this.BALUPDATE_BATCHSIZE) continue;
                            commonInfo.getBalanceCalculator().updateBalance4Others(partSet.toArray(), BalanceSourceEnum.CAL_OUTCOST);
                            partSet.clear();
                        }
                        if (!partSet.isEmpty()) {
                            commonInfo.getBalanceCalculator().updateBalance4Others(partSet.toArray(), BalanceSourceEnum.CAL_OUTCOST);
                        }
                    }
                }
                logger.info("\u51fa\u5e93\u6838\u7b97\u4f59\u989d\u66f4\u65b0\u5171" + entryIdSet.size() + "\u6761\u8bb0\u5f55\uff0c\u8017\u65f6:" + (System.currentTimeMillis() - this.startTime));
            }
            catch (Exception e) {
                this.setProgress(95, 1043474456359482368L, System.currentTimeMillis() - this.startTime, CommonUtils.getLogMessage(e), 0L);
                throw e;
            }
        }
        catch (AlgoException e) {
            this.analysisException(e);
        }
        if (param.getCheckItems().get("E") == null) {
            this.setProgress(100, 1043474456359482368L, System.currentTimeMillis() - this.startTime, null, 0L);
        } else {
            this.setProgress(95, 1043474456359482368L, System.currentTimeMillis() - this.startTime, null, 1234070852702711808L);
            this.startTime = System.currentTimeMillis();
            try {
                Map<String, Map<Integer, Object>> calOutRangeMap = this.getCalOutRangeMap(holder, commonInfo.isVoucherdutweightedavgat());
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalOutDataCheckService", (String)"doCalOutDataCheck", (Object[])new Object[]{calOutRangeMap, param.getCheckItems().get("E"), this.taskId, CHECKAFTERTASK_ID});
                String checkStatus = this.getCheckStatus(CHECKAFTERTASK_ID);
                if ("A".equals(checkStatus) || "E".equals(checkStatus)) {
                    this.setProgress(100, 1234070852702711808L, System.currentTimeMillis() - this.startTime, null, 0L);
                    this.setProgressStatus(1234070852702711808L, checkStatus);
                } else {
                    this.setProgress(100, 1234070852702711808L, System.currentTimeMillis() - this.startTime, "fail", 0L);
                }
            }
            catch (Exception e) {
                this.setProgress(100, 1234070852702711808L, System.currentTimeMillis() - this.startTime, e.getMessage(), 0L);
                logger.info("\u51fa\u5e93\u6838\u7b97\uff08\u540e\uff09\u6267\u884c\u68c0\u67e5\u9879\u5fae\u670d\u52a1\u51fa\u9519:", (Object)e);
            }
        }
    }

    private String calculateByNomal(CalCulateOutParams param, CalOutDataRangeHolder holder, CommonInfo commonInfo, JobSession session, DataInputFactory factory) {
        String resultId = null;
        factory = new DataInputFactory(holder, param);
        try {
            if (0 != param.getRunningModeMap().get(AccountTypeEnum.WEIGHTAVG.getValue())) {
                GPAPrevCostAdjustHelper costAdjustHelper = new GPAPrevCostAdjustHelper();
                costAdjustHelper.dealOutAdjustGpa(holder);
            }
            Map<Long, CostSubElement> elementMap = commonInfo.getElementMap();
            DataSetX costAdjustBizData = session.fromInput(factory.createCostAdjustBizDataInput());
            costAdjustBizData = costAdjustBizData.groupBy(new String[]{"entryid"}).reduceGroup((GroupReduceFunction)new SubElementCostDealFunction(costAdjustBizData.getRowMeta(), elementMap));
            costAdjustBizData = costAdjustBizData.addFields(new Field[]{new Field("groupid", (DataType)DataType.StringType)}, new Object[]{"0"});
            DataSetX groupBillCostAdjustData = costAdjustBizData.filter("createtype in ('F','N')");
            groupBillCostAdjustData = groupBillCostAdjustData.groupBy(new String[]{"id"}).reduceGroup((GroupReduceFunction)new CostAdjustDeleteFunction(groupBillCostAdjustData.getRowMeta(), commonInfo.getBalanceCalculator(), commonInfo.getRunningModeMap()));
            groupBillCostAdjustData.output((Output)new IgnoreOutput());
            costAdjustBizData = costAdjustBizData.filter("createtype not in ('F','N') and billstatus = 'C'");
            DataSetX costRecordBizData = session.fromInput(factory.createCostRecordBizDataInput(null));
            costRecordBizData = costRecordBizData.groupBy(new String[]{"entryid"}).reduceGroup((GroupReduceFunction)new SubElementCostDealFunction(costRecordBizData.getRowMeta(), elementMap));
            DataSetX billGroupRecordData = session.fromInput(factory.createBillGroupInput());
            costRecordBizData = costRecordBizData.leftJoin(billGroupRecordData).on("entryid", "groupentryid").select(DataSetUtil.getAllFieldStr(costRecordBizData), new String[]{"groupid"});
            DataSetX balanceBizData = session.fromInput(factory.createBalanceBizDataInput());
            String[] groupFields = new String[]{"entryid", "periodid"};
            RowMeta balMeta = balanceBizData.getRowMeta();
            SubElementCostDealFunction func = new SubElementCostDealFunction(balMeta, elementMap);
            if (CalBalanceModelHelper.isNewBalance()) {
                groupFields = (CalBalanceModelHelper.getDimFields(false) + ",periodid").split(",");
                balMeta = factory.getBizDataMeta();
                func = new SubElementCostDealFunction(balMeta, balanceBizData.getRowMeta(), elementMap);
            }
            balanceBizData = balanceBizData.groupBy(groupFields).reduceGroup((GroupReduceFunction)func);
            balanceBizData = balanceBizData.addFields(new Field[]{new Field("groupid", (DataType)DataType.StringType)}, new Object[]{"0"});
            DataSetX allData = costRecordBizData.union(costAdjustBizData).union(balanceBizData);
            if (0 != param.getRunningModeMap().get(AccountTypeEnum.FIFO.getValue())) {
                DataSetX fifoBalData = session.fromInput(factory.createFIFOBalDataInput());
                fifoBalData = fifoBalData.groupBy(new String[]{"entryid", "periodid"}).reduceGroup((GroupReduceFunction)new SubElementCostDealFunction(fifoBalData.getRowMeta(), elementMap));
                fifoBalData = fifoBalData.addFields(new Field[]{new Field("groupid", (DataType)DataType.StringType)}, new Object[]{"0"});
                allData = allData.union(fifoBalData);
                DataSetX ancestorDataSet = session.fromInput(factory.createCostRecordChildDataInput());
                allData = allData.leftJoin(ancestorDataSet).on("costrecordentryid", "entryid").select(DataSetUtil.getAllFieldStr(allData), new String[]{"ancestorentryid"});
            }
            DataSetX materialGroupNoSet = session.fromInput(factory.createMaterialGroupNoInput());
            allData = allData.leftJoin(materialGroupNoSet).on("material", "material").select(DataSetUtil.getAllFieldStr(allData), new String[]{"materialGroupNo"});
            allData = allData.flatMap((FlatMapFunction)new MatchCalRangeFunction(allData.getRowMeta(), holder.getCostAccountMap()));
            allData = allData.filter((FilterFunction)new FilterBalanceByCalRangeFunction(allData.getRowMeta(), holder.getCalOutRangeList()));
            allData = allData.filter("accountType = 'C'");
            DataSetX recentCostData = session.fromInput(factory.createRecentCostDataInput());
            recentCostData = recentCostData.leftJoin(materialGroupNoSet).on("material", "material").select(DataSetUtil.getAllFieldStr(recentCostData), new String[]{"materialGroupNo"});
            recentCostData = recentCostData.flatMap((FlatMapFunction)new MatchRecentCostCostDomainFunction(recentCostData.getRowMeta(), holder.getCostAccountMap()));
            allData = allData.leftJoin(recentCostData).on("costdomainid", "costdomainid").select(DataSetUtil.getAllFieldStr(allData), new String[]{"recentcostid"});
            DataSetX billGroupRecordDataCopy = session.fromInput(factory.createBillGroupInput());
            allData = allData.leftJoin(billGroupRecordDataCopy).on("groupid", "groupid").select(DataSetUtil.getAllFieldStr(allData), new String[]{"costfields", "costcolumn", "iscompleted", "grouptype", "groupentryid", "groupweight", "groupoccupiedqty", "groupgroupno"});
            DataSetX notSplitedAllData = session.fromInput(factory.createAllGroupData());
            notSplitedAllData = notSplitedAllData.groupBy(new String[]{"entryid"}).reduceGroup((GroupReduceFunction)new SubElementCostDealFunction(notSplitedAllData.getRowMeta(), elementMap));
            notSplitedAllData = notSplitedAllData.leftJoin(materialGroupNoSet).on("material", "material").select(DataSetUtil.getAllFieldStr(notSplitedAllData), new String[]{"materialGroupNo"});
            notSplitedAllData = notSplitedAllData.flatMap((FlatMapFunction)new MatchGroupDataFunction(notSplitedAllData.getRowMeta(), holder.getCostAccountMap()));
            billGroupRecordDataCopy = billGroupRecordDataCopy.join(notSplitedAllData).on("groupentryid", "entryid").select(new String[]{"groupid", "costfields", "costcolumn", "iscompleted", "grouptype", "groupentryid", "groupweight", "groupoccupiedqty", "groupgroupno"}, this.getGroupBizFields(elementMap));
            commonInfo.setGroupInfoRowMeta(billGroupRecordDataCopy.getRowMeta());
            billGroupRecordDataCopy = billGroupRecordDataCopy.groupBy(new String[]{"groupid"}).reduceGroup((GroupReduceFunction)new GroupRecordAggFunction(billGroupRecordDataCopy.getRowMeta()));
            String[] allFieldStr = DataSetUtil.getAllFieldStr(allData);
            allData = allData.groupBy(new String[]{"groupid"}).reduceGroup((GroupReduceFunction)new GroupIdBakFunction(allData.getRowMeta()));
            allData = allData.leftJoin(billGroupRecordDataCopy).on("groupidbak", "groupid").select(allFieldStr, new String[]{"groupinfovalues"});
            DataSetX costUpdateData = allData.groupBy(new String[]{"material", "costaccount", "periodid"}).reduceGroup((GroupReduceFunction)new MoveAddAccountTypeFunction(allData.getRowMeta(), commonInfo, holder.getCostAccountMap()));
            DataSetX recentCostUpdateData = costUpdateData.select(new String[]{"recentcostid", "recentcost", "recentcostqty", "calrptid", "rcidmod"});
            recentCostUpdateData = recentCostUpdateData.distinct(new String[]{"recentcostid", "recentcost", "recentcostqty", "calrptid", "rcidmod"});
            recentCostUpdateData = recentCostUpdateData.groupBy(new String[]{"rcidmod"}).reduceGroup((GroupReduceFunction)new RecentCostUpdateInfoFunction(holder));
            DataSetX splitedAllData = session.fromInput(factory.createAllSplitData());
            splitedAllData = splitedAllData.groupBy(new String[]{"entryid"}).reduceGroup((GroupReduceFunction)new SubElementCostDealFunction(splitedAllData.getRowMeta(), elementMap));
            costUpdateData = costUpdateData.leftJoin(splitedAllData).on("entryid", "ancestorentryid").select(DataSetUtil.getAllFieldStr(costUpdateData), new String[]{"writeoffperiod", "writeoffendperiod", "writeoffstatus", "id childheadid", "entryid childid", "parentid parentid", "baseqty childbaseqty", "issplit childissplit", "isvoucher childisvoucher", "signnum groupsignnum", "materialcost childmaterialcost", "fee childfee", "processcost childprocesscost", "manufacturecost childmanufacturecost", "resource childresource", "ischargeoff childischargeoff", "ischargeoffed childischargeoffed"});
            costUpdateData = costUpdateData.groupBy(new String[]{"entryid"}).reduceGroup((GroupReduceFunction)new BuildCostRecordUpdateInfoFunction(costUpdateData.getRowMeta(), elementMap));
            RowMeta resultMeta = this.buildEntryIdMeta();
            costUpdateData = costUpdateData.groupBy(new String[]{"mod"}).reduceGroup((GroupReduceFunction)new CostRecordUpdateFunction(costUpdateData.getRowMeta(), resultMeta, this.COSTRECORDUPDATE_BATCHSIZE));
            costUpdateData = costUpdateData.leftJoin(recentCostUpdateData).on("headid", "id").select(DataSetUtil.getAllFieldStr(costUpdateData));
            DataSetOutput resultSet = new DataSetOutput(resultMeta);
            resultId = resultSet.getId();
            costUpdateData.output((Output)resultSet);
        }
        catch (Exception e) {
            this.setProgress(55, 1043473988375819264L, System.currentTimeMillis() - this.startTime, CommonUtils.getLogMessage(e), 0L);
            throw e;
        }
        return resultId;
    }

    private String getCheckStatus(Long checkTaskId) {
        String checkStatus = "A";
        QFilter q = new QFilter("checkplan", "=", (Object)Long.parseLong(this.taskId));
        q.and("checktask", "=", (Object)checkTaskId);
        DataSet checkResultDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_datacheck_result", (String)"id,entryentity.entrystatus", (QFilter[])q.toArray(), null);
        for (Row row : checkResultDataSet) {
            String result = row.getString("entryentity.entrystatus");
            if ("B".equals(result) || "C".equals(result)) {
                checkStatus = "B";
                break;
            }
            if (!"A".equals(result)) continue;
            checkStatus = "E";
        }
        return checkStatus;
    }

    private RowMeta buildEntryIdMeta() {
        Field[] resultFields = new Field[]{new Field("entryid", (DataType)DataType.LongType), new Field("headid", (DataType)DataType.LongType), new Field("billtypenum", (DataType)DataType.StringType)};
        return new RowMeta(resultFields);
    }

    private void analysisException(AlgoException e) {
        for (Throwable t = e.getCause(); t != null; t = t.getCause()) {
            SerializedThrowable st;
            Throwable kt;
            if (t instanceof SerializedThrowable && (kt = (st = (SerializedThrowable)t).deserializeError(null)) instanceof KDBizException) {
                throw (KDBizException)kt;
            }
            if (!(t instanceof KDBizException)) continue;
            throw (KDBizException)t;
        }
        throw e;
    }

    private ParamCache buildParamCache(CalOutDataRangeHolder holder) {
        ParamCache cache = new ParamCache();
        DynamicObjectCollection costAccountCol = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,calorg,calpolicy.calbycostelement", null);
        HashSet<Long> calOrgIdSet = new HashSet<Long>(costAccountCol.size());
        HashMap<Long, Boolean> calByElementMap = new HashMap<Long, Boolean>(costAccountCol.size());
        for (DynamicObject costAccount : costAccountCol) {
            calOrgIdSet.add(costAccount.getLong("calorg"));
            calByElementMap.put(costAccount.getLong("id"), costAccount.getBoolean("calpolicy.calbycostelement"));
        }
        cache.setCostAccountCalbyElement(calByElementMap);
        cache.loadOrgParams(calOrgIdSet, "iscyclebillcal", "iscreatediffbill");
        Map<Long, CostAccount> costAccoumtMap = holder.getCostAccountMap();
        HashMap<Long, Long> periodMap = new HashMap<Long, Long>(costAccoumtMap.size());
        for (Map.Entry<Long, CostAccount> entry : costAccoumtMap.entrySet()) {
            CostAccount account = entry.getValue();
            periodMap.put(entry.getKey(), account.getCurrentPeriod());
        }
        cache.setCostAccountPeriods(periodMap);
        return cache;
    }

    private String[] getGroupBizFields(Map<Long, CostSubElement> elementMap) {
        ArrayList<String> fields = new ArrayList<String>(18 + elementMap.size());
        fields.add("periodid groupperiodid");
        fields.add("baseqty groupbaseqty");
        fields.add("queuetype groupqueuetype");
        fields.add("signnum groupsignnum");
        fields.add("localcurrency grouplocalcurrency");
        fields.add("exratetable groupexratetable");
        fields.add("convertmode groupconvertmode");
        fields.add("amtprecision groupamtprecision");
        fields.add("priceprecision grouppriceprecision");
        fields.add("isvoucher groupisvoucher");
        fields.add("actualcost groupactualcost");
        fields.add("materialcost groupmaterialcost");
        fields.add("fee groupfee");
        fields.add("processcost groupprocesscost");
        fields.add("manufacturecost groupmanufacturecost");
        fields.add("resource groupresource");
        fields.add("accounttype groupaccounttype");
        fields.add("iscalculated groupiscalculated");
        fields.add("calorg groupcalorg");
        fields.add("isinitbill groupisinitbill");
        fields.add("costaccount groupcostaccount");
        fields.add("isrework groupisrework");
        fields.add("id groupbillheadid");
        fields.add("bizentityobject groupbizentityobject");
        fields.add("issubbillinvoiceverify groupissubbillinvoiceverify");
        fields.add("groupcostdomainid");
        fields.add("invzerocost groupinvzerocost");
        for (Long key : elementMap.keySet()) {
            fields.add(key + " group" + key);
        }
        fields.add("ischargeoffed");
        return fields.toArray(fields.toArray(new String[fields.size()]));
    }

    /*
     * Exception decompiling
     */
    private Map<Long, CostSubElement> getElementMap() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void calFIFOBalBegin(CalOutDataRangeHolder holder) {
        for (CalOutDataRangeHolder.CalOutRange range : holder.getCalOutRangeList()) {
            long costAccountId = range.getCostAccountId();
            if (range.isAllMaterial()) {
                FIFOPeriodDataCalculate cal = new FIFOPeriodDataCalculate(costAccountId, range.getCalRangeId(), new HashSet<Long>(1));
                cal.calculate();
                continue;
            }
            for (Set<Object> materialSet : range.getMaterialSetList()) {
                HashSet<Long> mSet = new HashSet<Long>(materialSet.size());
                for (Object id : materialSet) {
                    mSet.add(Long.valueOf(id.toString()));
                }
                FIFOPeriodDataCalculate cal = new FIFOPeriodDataCalculate(costAccountId, range.getCalRangeId(), mSet);
                cal.calculate();
            }
        }
    }

    private CommonInfo buildCommonInfo(CalCulateOutParams param, CalOutDataRangeHolder holder) {
        CommonInfo commonInfo = new CommonInfo();
        commonInfo.setWriteRpt(param.isWriteRpt());
        commonInfo.setOnlyWriteErrRpt(param.isWriteErrRpt());
        commonInfo.setRunningModeMap(param.getRunningModeMap());
        commonInfo.setBalanceCalculator(new BalanceCalculator());
        commonInfo.setParamCache(this.buildParamCache(holder));
        commonInfo.setElementMap(this.getElementMap());
        commonInfo.setCalGroupCostImplClasses(this.getCalGroupCostClasses());
        return commonInfo;
    }

    private void setProgress(int progress) {
        if (this.progressInfo == null) {
            return;
        }
        this.progressInfo.set("progress", (Object)progress);
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.progressInfo});
        }
    }

    private void setProgress(int progress, long stepId, long time, String errInfo, long nextStepId) {
        if (this.progressInfo == null) {
            return;
        }
        this.progressInfo.set("progress", (Object)progress);
        if (stepId != 0L) {
            DynamicObject entry = this.progressEntryMap.get(stepId);
            entry.set("status", (Object)"A");
            entry.set("time", (Object)time);
            if (!StringUtils.isEmpty((String)errInfo)) {
                entry.set("errorinfo_tag", (Object)errInfo);
                entry.set("status", (Object)"B");
            }
        }
        if (nextStepId != 0L) {
            DynamicObject nextEntry = this.progressEntryMap.get(nextStepId);
            nextEntry.set("status", (Object)"C");
        }
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.progressInfo});
        }
    }

    private void setProgressStatus(long stepId, String status) {
        if (this.progressInfo == null) {
            return;
        }
        if (stepId != 0L) {
            DynamicObject entry = this.progressEntryMap.get(stepId);
            entry.set("status", (Object)status);
        }
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.progressInfo});
        }
    }

    private void setRangeMapValue(Map<String, Map<Integer, Object>> calOutRangeMap, String key, Object value, int index) {
        Map<Object, Object> dimMap;
        if (calOutRangeMap.get(key) == null) {
            dimMap = new HashMap(16);
            dimMap.put(index, value);
        } else {
            dimMap = calOutRangeMap.get(key);
            dimMap.put(index, value);
        }
        calOutRangeMap.put(key, dimMap);
    }

    private Map<String, Map<Integer, Object>> getCalOutRangeMap(CalOutDataRangeHolder holder, boolean voucherdutweightedavgat) {
        HashMap<String, Map<Integer, Object>> calOutRangeMap = new HashMap<String, Map<Integer, Object>>(16);
        int index = 0;
        boolean isNeedCalculatedLater = holder.isNeedCalculatedLater();
        for (CalOutDataRangeHolder.CalOutRange range : holder.getCalOutRangeList()) {
            List<Set<Object>> materialSetList = range.getMaterialSetList();
            Long costAccountId = range.getCostAccountId();
            Long periodId = range.getPeriodId();
            Long crtPeriod = holder.getCurrentPeirod(costAccountId);
            if (crtPeriod.compareTo(periodId) != 0) continue;
            Long calOrgId = range.getCalOrgId();
            Long calRangeId = range.getCalRangeId();
            Date startDate = range.getStartDate();
            Date endDate = range.getEndDate();
            Integer period = range.getPeriod();
            boolean isAllMaterial = range.isAllMaterial();
            this.setRangeMapValue(calOutRangeMap, "materialSetListMap", materialSetList, index);
            this.setRangeMapValue(calOutRangeMap, "calOrgIdMap", calOrgId, index);
            this.setRangeMapValue(calOutRangeMap, "calRangeIdMap", calRangeId, index);
            this.setRangeMapValue(calOutRangeMap, "costAccountIdMap", costAccountId, index);
            this.setRangeMapValue(calOutRangeMap, "startDateMap", startDate, index);
            this.setRangeMapValue(calOutRangeMap, "endDateMap", endDate, index);
            this.setRangeMapValue(calOutRangeMap, "periodMap", period, index);
            this.setRangeMapValue(calOutRangeMap, "periodIdMap", periodId, index);
            this.setRangeMapValue(calOutRangeMap, "isAllMaterialMap", isAllMaterial, index);
            this.setRangeMapValue(calOutRangeMap, "isNeedCalculatedLaterMap", isNeedCalculatedLater, index);
            this.setRangeMapValue(calOutRangeMap, "voucherdutweightedavgat", voucherdutweightedavgat, index);
            ++index;
        }
        return calOutRangeMap;
    }

    private List<String> getCalGroupCostClasses() {
        String serviceType = "B";
        String actionName = "ADDAVERAG";
        List<String> implClassList = CalServiceHelper.getServiceSetting(serviceType, actionName);
        return implClassList;
    }

    private static Set<String> getSalOutBillNums() {
        QFilter filter = new QFilter("enable", "=", (Object)true);
        filter.and("status", "=", (Object)"C");
        filter.and("billformid", "=", (Object)"im_saloutbill");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bos_billtype", (String)"number", (QFilter[])new QFilter[]{filter});
        return dynamicObjects.stream().map(r -> r.getString("number")).collect(Collectors.toSet());
    }
}

