/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class TaskProgresssPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String CALC_PROGRESSBAR = "progressbarap";
    private static final Long CHECKBEFORETASK_ID = 1228995490352290816L;
    private static final Long CHECKAFTERTASK_ID = 1234050040448761856L;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(CALC_PROGRESSBAR);
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_close"});
        this.start();
        this.updateStatusColor();
    }

    public void onProgress(ProgressEvent paramProgressEvent) {
        this.getView().invokeOperation("refresh");
        int progress = 0;
        long taskId = (Long)this.getModel().getValue("taskid");
        progress = taskId == 0L ? 100 : (Integer)this.getModel().getValue("progress");
        paramProgressEvent.setProgress(progress);
        if (progress == 100) {
            ProgressBar progressBar = (ProgressBar)this.getView().getControl(CALC_PROGRESSBAR);
            ((Label)this.getView().getControl("labelap")).setText(ResManager.loadKDString((String)"\u8ba1\u7b97\u5b8c\u6210", (String)"TaskProgresssPlugin_4", (String)"fi-calx-algox", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_close"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_close1"});
            progressBar.stop();
        } else {
            ((Label)this.getView().getControl("labelap")).setText(ResManager.loadKDString((String)"\u8ba1\u7b97\u8fdb\u884c", (String)"TaskProgresssPlugin_3", (String)"fi-calx-algox", (Object[])new Object[0]));
        }
        this.updateStatusColor();
    }

    private void updateStatusColor() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("entry");
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
        ArrayList<CellStyle> csList = new ArrayList<CellStyle>(16);
        for (DynamicObject row : entry) {
            CellStyle cs2;
            CellStyle cs = new CellStyle();
            String status = row.getString("status");
            cs.setForeColor(this.getColorByStatus(status));
            cs.setFieldKey("status");
            cs.setRow(row.getInt("seq") - 1);
            csList.add(cs);
            if ("B".equals(status) || "E".equals(status)) {
                cs2 = new CellStyle();
                cs2.setFieldKey("operationcolumnap");
                cs2.setRow(row.getInt("seq") - 1);
                cs2.setFontSize(11);
                csList.add(cs2);
                continue;
            }
            cs2 = new CellStyle();
            cs2.setFieldKey("operationcolumnap");
            cs2.setRow(row.getInt("seq") - 1);
            cs2.setFontSize(0);
            csList.add(cs2);
        }
        grid.setCellStyle(csList);
    }

    private String getColorByStatus(String status) {
        switch (status) {
            case "A": {
                return "#1BA854";
            }
            case "B": {
                return "#FB2323";
            }
            case "C": {
                return "#276FF5";
            }
            case "D": {
                return "#666666";
            }
            case "E": {
                return "#FF991C";
            }
        }
        return "#FB2323";
    }

    private void start() {
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(CALC_PROGRESSBAR);
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        String text = ResManager.loadKDString((String)"\u5f00\u59cb\u8ba1\u7b97", (String)"TaskProgresssPlugin_1", (String)"fi-calx-algox", (Object[])new Object[0]);
        if ("1".equals(type)) {
            text = ResManager.loadKDString((String)"\u5f00\u59cb\u67e5\u627e\u4efb\u52a1", (String)"TaskProgresssPlugin_2", (String)"fi-calx-algox", (Object[])new Object[0]);
        }
        ((Label)this.getView().getControl("labelap")).setText(text);
        progressBar.setPercent(0);
        progressBar.start();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if ("detail".equals(key)) {
            boolean isAfterCheckStep;
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
            String status = (String)this.getModel().getValue("status", rowIndex);
            Long stepId = ((DynamicObject)this.getModel().getValue("step", rowIndex)).getLong("id");
            boolean isBeforeCheckStep = Long.valueOf(1229515981550833664L).compareTo(stepId) == 0;
            boolean bl = isAfterCheckStep = Long.valueOf(1234070852702711808L).compareTo(stepId) == 0;
            if ("D".equals(status)) {
                if (isBeforeCheckStep || isAfterCheckStep) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u6b21\u672a\u5bf9\u51fa\u5e93\u6838\u7b97\u8fdb\u884c\u5408\u6cd5\u6027\u68c0\u67e5\uff0c\u6ca1\u6709\u68c0\u67e5\u7ed3\u679c\u3002", (String)"TaskProgresssPlugin_5", (String)"fi-calx-algox", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u5931\u8d25\u72b6\u6001\u7684\u6b65\u9aa4\u4e0d\u652f\u6301\u8be6\u60c5\u67e5\u770b\u3002", (String)"TaskProgresssPlugin_0", (String)"fi-calx-algox", (Object[])new Object[0]));
                }
                return;
            }
            if ("B".equals(status) || isBeforeCheckStep || isAfterCheckStep) {
                if (isBeforeCheckStep) {
                    this.showCheckResultByTaskId(CHECKBEFORETASK_ID);
                } else if (isAfterCheckStep) {
                    this.showCheckResultByTaskId(CHECKAFTERTASK_ID);
                } else {
                    long entryId = (Long)this.getModel().getValue("entry.id", rowIndex);
                    FormShowParameter parameter = new FormShowParameter();
                    parameter.setAppId("calx");
                    parameter.getOpenStyle().setShowType(ShowType.Modal);
                    parameter.setFormId("cal_showresult");
                    parameter.setCustomParam("entryid", (Object)String.valueOf(entryId));
                    this.getView().showForm(parameter);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u5931\u8d25\u72b6\u6001\u7684\u6b65\u9aa4\u4e0d\u652f\u6301\u8be6\u60c5\u67e5\u770b\u3002", (String)"TaskProgresssPlugin_0", (String)"fi-calx-algox", (Object[])new Object[0]));
            }
        }
    }

    private void showCheckResultByTaskId(Long checkTaskId) {
        String taskId = (String)this.getView().getFormShowParameter().getCustomParam("taskId");
        QFilter q = new QFilter("checkplan", "=", (Object)Long.parseLong(taskId));
        q.and("checktask", "=", (Object)checkTaskId);
        DynamicObject checkResult = QueryServiceHelper.queryOne((String)"cal_datacheck_result", (String)"id", (QFilter[])q.toArray());
        if (checkResult != null) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId((Object)checkResult.getLong("id"));
            showParameter.setFormId("cal_datacheck_result");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }
}

