/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.accounttype;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.calx.algox.CostAccount;
import kd.fi.calx.algox.CostPriceResultInfo;
import kd.fi.calx.algox.CostSubElement;
import kd.fi.calx.algox.ParamCache;
import kd.fi.calx.algox.accounttype.AccountTypeEnum;
import kd.fi.calx.algox.accounttype.CostAdjustInfo;
import kd.fi.calx.algox.accounttype.IAccountType;
import kd.fi.calx.algox.accounttype.LocalRow;
import kd.fi.calx.algox.diff.helper.DiffAllocHelper;
import kd.fi.calx.algox.function.AccountTypeContext;
import kd.fi.calx.algox.helper.CalServiceHelper;
import kd.fi.calx.algox.report.CalOutRptHolder;
import kd.fi.calx.algox.report.RptStatus;

public abstract class AbstractAccountType
implements IAccountType,
Serializable {
    protected static Log logger = LogFactory.getLog(AbstractAccountType.class);
    private static final long serialVersionUID = -7439548560172786861L;
    protected CalOutRptHolder holder = new CalOutRptHolder();
    private long calOrgId;
    private long costAccountId;
    private long materialId;
    private long divideBasis;
    private String divideBasisStr;
    private String divideBasisValue;
    private Map<String, String> divideBasisValueMap = null;
    private long calDimension;
    private String calDimensionStr;
    private Map<String, String> calDimensionMap = null;
    private String calDimensionValue;
    private boolean isEmptyRange;
    protected Set<Long> zeroInOutBizTypeIds;
    private long calRangeId;
    private String accountType;
    private Long periodId;
    private int amtPrecision = 2;
    private int pricePrecision = 10;
    private Long currency = 0L;
    private int calPricePrecision = 10;
    private int qtyPrecision = 2;
    private int BeginPrice = 1;
    protected boolean neg2pos = false;
    private boolean invalidCalBal = false;
    private boolean beginQtyAllZero = true;
    private boolean beginAmtAllZero = true;
    private boolean inBillQtyAllZero = true;
    private boolean weightInBillAmtAllZero = true;
    private boolean weightOutBillUnitAmtAllZero = true;
    private Long assistId = 0L;
    private Long configuredcodeId = 0L;
    private Long projectId = 0L;
    private Long tracknumberId = 0L;
    protected AccountTypeContext ctx;
    private BigDecimal currentTotalQty = BigDecimal.ZERO;
    private BigDecimal currentTotalCost = BigDecimal.ZERO;
    private Map<Long, BigDecimal> currentTotalElementCost;
    private Map<Long, Object[]> toUpdatedRowMap = new HashMap<Long, Object[]>();
    private Map<Long, Object[]> toUpdatedGroupRowMap = new HashMap<Long, Object[]>(16);
    protected List<LocalRow> tempInGroupRow = new ArrayList<LocalRow>();
    private List<LocalRow> exceptionRow = new ArrayList<LocalRow>();
    private int runningMode;
    protected DataSet dataSet;
    private Long beforeRowId = null;
    private LocalRow beforeRow = null;
    private boolean calbycostelement = false;
    private boolean isPriced = false;
    private String createDiffBillType = "diffadjust";
    private Map<Long, CostSubElement> elementMap;
    private boolean hasPriceFailedBill = false;
    private Map<Long, CostAdjustInfo> adjustInfoMap = new HashMap<Long, CostAdjustInfo>();
    private Map<Long, CostAccount> costAccountMap = new HashMap<Long, CostAccount>();
    private BigDecimal diffrange;
    protected boolean isLastRow = false;

    public String getDivideBasisStr() {
        return this.divideBasisStr;
    }

    public String getDivideBasisValue() {
        return this.divideBasisValue;
    }

    public String getCalDimensionStr() {
        return this.calDimensionStr;
    }

    public String getCalDimensionValue() {
        return this.calDimensionValue;
    }

    public Map<String, String> getDivideBasisValueMap() {
        if (this.divideBasisValueMap == null) {
            String[] names = this.divideBasisStr.split(",");
            String[] values = this.divideBasisValue.split("_");
            this.divideBasisValueMap = new HashMap<String, String>(names.length);
            for (int i = 0; i < names.length; ++i) {
                String value = values[i];
                if (value.equals("#")) continue;
                this.divideBasisValueMap.put(names[i], value);
            }
        }
        return this.divideBasisValueMap;
    }

    public Map<String, String> getCalDimensionMap() {
        if (this.calDimensionMap == null) {
            String[] names = this.calDimensionStr.split(",");
            String[] values = this.calDimensionValue.split("_");
            this.calDimensionMap = new HashMap<String, String>(names.length);
            for (int i = 0; i < names.length; ++i) {
                if (StringUtils.isEmpty((String)names[i])) continue;
                String value = values[i];
                if ("assist".equals(names[i])) {
                    if (!StringUtils.isEmpty((String)value)) {
                        this.assistId = Long.parseLong(value);
                    }
                } else if ("configuredcode".equals(names[i])) {
                    if (!StringUtils.isEmpty((String)value)) {
                        this.configuredcodeId = Long.parseLong(value);
                    }
                } else if ("project".equals(names[i])) {
                    if (!StringUtils.isEmpty((String)value)) {
                        this.projectId = Long.parseLong(value);
                    }
                } else if ("tracknumber".equals(names[i]) && !StringUtils.isEmpty((String)value)) {
                    this.tracknumberId = Long.parseLong(value);
                }
                if (value.equals("#")) continue;
                this.calDimensionMap.put(names[i], value);
            }
        }
        return this.calDimensionMap;
    }

    public boolean isEmptyRange() {
        return this.isEmptyRange;
    }

    public long getCalRangeId() {
        return this.calRangeId;
    }

    public long getCostAccountId() {
        return this.costAccountId;
    }

    public long getMaterialId() {
        return this.materialId;
    }

    public int getPricePrecision() {
        return this.pricePrecision;
    }

    public int getAmtPrecision() {
        return this.amtPrecision;
    }

    public int getBeginPrice() {
        return this.BeginPrice;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public boolean isBeginQtyAllZero() {
        return this.beginQtyAllZero;
    }

    public boolean isInvalidCalBal() {
        return this.invalidCalBal;
    }

    public void setInvalidCalBal(boolean invalidCalBal) {
        this.invalidCalBal = invalidCalBal;
    }

    public boolean isBeginAmtAllZero() {
        return this.beginAmtAllZero;
    }

    public AbstractAccountType(AccountTypeContext ctx, DataSet dataSet, int runningMode) {
        this.ctx = ctx;
        this.dataSet = dataSet;
        this.runningMode = runningMode;
        this.zeroInOutBizTypeIds = (Set)ctx.getParamCache().getParamValue("zeroInOutBizTypeIds");
    }

    public AbstractAccountType(AccountTypeContext ctx, DataSet dataSet, int runningMode, Map<Long, CostAccount> costAccountMap) {
        this.ctx = ctx;
        this.dataSet = dataSet;
        this.runningMode = runningMode;
        this.costAccountMap = costAccountMap;
    }

    @Override
    public void calculateOut() {
        Row row;
        if (this.runningMode == 0) {
            return;
        }
        String balanceType = this.getBalanceRowType();
        DataSet balanceData = this.dataSet.copy().filter("rowtype = '" + balanceType + "'");
        DataSet data = this.dataSet.copy().filter("rowtype in ('1','2')");
        data = this.filterEndDate(data, this.ctx.getCostatenddate());
        DataSet copyData = this.dataSet.copy();
        if (copyData.hasNext()) {
            row = copyData.next();
            this.initCalRangeInfo(row);
        }
        this.dealBalanceData(balanceData.copy());
        this.addRptBeginData(balanceData);
        data = data.orderBy(this.buildOrderByField());
        this.beforeCalculated();
        while (data.hasNext()) {
            Long currentId;
            row = data.next();
            if (this.isEmptyRange) {
                this.holder.addDivideBasisValue(row.getString("divideBasisValue"));
            }
            if (!(currentId = row.getLong("entryid")).equals(this.beforeRowId)) {
                this.doCalculate(this.ctx);
            }
            this.beforeRow = this.createCurrentRow(row);
            this.beforeRowId = currentId;
        }
        this.isLastRow = true;
        this.doCalculate(this.ctx);
        this.afterCalculated();
    }

    protected String getBalanceRowType() {
        return "0";
    }

    protected void afterCalculated() {
    }

    protected void beforeCalculated() {
    }

    protected void beforeEndCalculated() {
    }

    protected void afterEndCalculated() {
    }

    protected void sumToTotal(LocalRow row) {
        this.neg2pos = this.currentTotalQty.compareTo(BigDecimal.ZERO) < 0 && this.currentTotalQty.add(row.getBaseqty()).compareTo(BigDecimal.ZERO) > 0;
        this.currentTotalQty = this.currentTotalQty.add(row.getBaseqty()).stripTrailingZeros();
        this.currentTotalCost = this.currentTotalCost.add(row.getActualCost()).setScale(row.getAmtprecision(), RoundingMode.HALF_UP);
        for (Long elementId : this.getElementMap().keySet()) {
            BigDecimal elementTotalCost = this.currentTotalElementCost.get(elementId);
            BigDecimal rowElementCost = row.getCost(elementId);
            elementTotalCost = elementTotalCost.add(rowElementCost);
            this.currentTotalElementCost.put(elementId, elementTotalCost.stripTrailingZeros());
        }
    }

    protected void sumToTotal(CostAdjustInfo adjustInfo) {
        this.currentTotalCost = this.currentTotalCost.add(adjustInfo.getAdjustAmt());
        for (Long elementId : this.getElementMap().keySet()) {
            BigDecimal elementTotalCost = this.currentTotalElementCost.get(elementId);
            BigDecimal rowElementCost = adjustInfo.getAdjustCost(elementId);
            elementTotalCost = elementTotalCost.add(rowElementCost);
            this.currentTotalElementCost.put(elementId, elementTotalCost.stripTrailingZeros());
        }
    }

    protected void substractToTotal(LocalRow row) {
        this.neg2pos = this.currentTotalQty.compareTo(BigDecimal.ZERO) < 0 && this.currentTotalQty.subtract(row.getBaseqty()).compareTo(BigDecimal.ZERO) > 0;
        this.currentTotalQty = this.currentTotalQty.subtract(row.getBaseqty()).stripTrailingZeros();
        this.currentTotalCost = this.currentTotalCost.subtract(row.getActualCost()).setScale(row.getAmtprecision(), RoundingMode.HALF_UP);
        for (Long elementId : this.getElementMap().keySet()) {
            BigDecimal elementTotalCost = this.currentTotalElementCost.get(elementId);
            BigDecimal rowElementCost = row.getCost(elementId);
            elementTotalCost = elementTotalCost.subtract(rowElementCost);
            this.currentTotalElementCost.put(elementId, elementTotalCost.stripTrailingZeros());
        }
    }

    protected void substractToTotal(CostAdjustInfo adjustInfo) {
        this.currentTotalCost = this.currentTotalCost.subtract(adjustInfo.getAdjustAmt());
        for (Long elementId : this.getElementMap().keySet()) {
            BigDecimal elementTotalCost = this.currentTotalElementCost.get(elementId);
            BigDecimal rowElementCost = adjustInfo.getAdjustCost(elementId);
            elementTotalCost = elementTotalCost.subtract(rowElementCost);
            this.currentTotalElementCost.put(elementId, elementTotalCost.stripTrailingZeros());
        }
    }

    protected final void addTotalCostElementCost(Long elementId, BigDecimal amt) {
        BigDecimal elementTotalCost = this.currentTotalElementCost.get(elementId);
        elementTotalCost = elementTotalCost.add(amt);
        this.currentTotalElementCost.put(elementId, elementTotalCost);
        this.currentTotalCost = this.currentTotalCost.add(amt);
    }

    protected BigDecimal getElementTotalCost(Long elementId) {
        BigDecimal totalCost = this.currentTotalElementCost.get(elementId);
        if (totalCost == null) {
            totalCost = BigDecimal.ZERO;
            this.currentTotalElementCost.put(elementId, totalCost);
        }
        return totalCost;
    }

    protected Map<Long, BigDecimal> getElementTotalCostMap() {
        return this.currentTotalElementCost;
    }

    protected BigDecimal getCurrentTotalQty() {
        return this.currentTotalQty;
    }

    protected BigDecimal getCurrentTotalCost() {
        return this.currentTotalCost;
    }

    protected LocalRow getGroupedRow(Long rowId) {
        return this.ctx.getGroupBillHolder().getGroupedLocalRow(rowId, this.calbycostelement);
    }

    private LocalRow createCurrentRow(Row row) {
        LocalRow localRow = new LocalRow(this.calbycostelement, this.getElementMap());
        localRow.setHeadid(row.getLong("id"));
        localRow.setEntyrId(row.getLong("entryid"));
        localRow.setCostaccountid(row.getLong("costaccount"));
        localRow.setLocalcurrencyid(row.getLong("localcurrency"));
        localRow.setPriceprecision(10);
        localRow.setAmtprecision(row.getInteger("amtprecision"));
        localRow.setQtyPrecision(row.getInteger("qtyprecision"));
        localRow.setRowtype(row.getString("rowtype"));
        BigDecimal signnum = BigDecimal.valueOf(row.getInteger("signnum").intValue());
        localRow.setSignnum(signnum);
        localRow.setBaseqty(row.getBigDecimal("baseqty").multiply(signnum));
        if ("2".equals(localRow.getRowtype())) {
            localRow.setSign(BigDecimal.valueOf(row.getBigDecimal("actualcost").signum()).multiply(signnum));
        } else if ("1".equals(localRow.getRowtype())) {
            localRow.setSign(BigDecimal.valueOf(localRow.getBaseqty().signum()));
        }
        localRow.setQueuetype(row.getString("queuetype"));
        localRow.setCalbilltype(row.getString("calbilltype"));
        localRow.setBizbillid(row.getLong("bizbillid"));
        localRow.setBizbillentryid(row.getLong("bizbillentryid"));
        localRow.setBizTypeId(row.getLong("biztypeid"));
        localRow.setBilltypenum(row.getString("billtypenum"));
        String createtype = row.getString("createtype");
        localRow.setCreatetype(createtype);
        String invbillnum = row.getString("invbillnum");
        if ("2".equals(localRow.getRowtype()) && StringUtils.isNotEmpty((String)invbillnum)) {
            String msg = String.format(ResManager.loadKDString((String)"(\u5bf9\u5e94\u5e93\u5b58\u5355\u636e\u53f7\uff1a%1$s)", (String)"CalculateOutCostPlugin_31", (String)"fi-calx-algox", (Object[])new Object[0]), invbillnum);
            localRow.setBilltype(row.getString("billtypename") + msg);
        } else {
            localRow.setBilltype(row.getString("billtypename"));
        }
        localRow.setBillnumber(row.getString("billnumber"));
        localRow.setBizDate(row.getDate("bizdate"));
        localRow.setAuditTime(row.getDate("auditdate"));
        localRow.setPeriodid(row.getLong("periodid"));
        localRow.setBaseUnitId(row.getLong("baseunit"));
        localRow.setBizEntityObject(row.getString("bizentityobject"));
        localRow.setInCostAdjustEntryId(row.getLong("incostadjustentryid"));
        localRow.setSubbillInvoiceverify(row.getBoolean("issubbillinvoiceverify"));
        if ((AccountTypeEnum.FIFO.getValue().equals(this.accountType) || AccountTypeEnum.FIN_FOUT_PERIOD.getValue().equals(this.accountType)) && 0 != this.runningMode && row.get("ancestorentryid") != null) {
            localRow.setCostRecordEntryid(row.getLong("ancestorentryid"));
        }
        localRow.setMaterialcost(row.getBigDecimal("materialcost").multiply(signnum));
        localRow.setProcesscost(row.getBigDecimal("processcost").multiply(signnum));
        localRow.setFee(row.getBigDecimal("fee").multiply(signnum));
        BigDecimal manufacturecost = BigDecimal.ZERO;
        BigDecimal resource = BigDecimal.ZERO;
        if (row.getBigDecimal("manufacturecost") != null) {
            manufacturecost = row.getBigDecimal("manufacturecost");
        }
        if (row.getBigDecimal("resource") != null) {
            resource = row.getBigDecimal("resource");
        }
        localRow.setManufacturecost(manufacturecost.multiply(signnum));
        localRow.setResource(resource.multiply(signnum));
        localRow.setEntrySeq(row.getInteger("entryseq"));
        boolean isVoucher = row.getBoolean("isvoucher");
        boolean isCalculated = row.getBoolean("iscalculated");
        boolean isrework = row.getBoolean("isrework");
        localRow.setCostDetermined(isVoucher || isCalculated && 2 == this.runningMode || isrework && this.ctx.enableRework());
        localRow.setVoucher(isVoucher);
        localRow.setInvTxZeroCost(row.getBoolean("invzerocost"));
        localRow.setPresent(row.getBoolean("ispresent"));
        localRow.setEnableInBillZeroCost(this.zeroInOutBizTypeIds.contains(row.getLong("biztypeid")));
        for (Long elementId : this.getElementMap().keySet()) {
            BigDecimal elementCost = row.getBigDecimal(elementId.toString());
            if (elementCost == null) {
                elementCost = BigDecimal.ZERO;
            }
            localRow.setCost(elementId, elementCost.multiply(signnum));
        }
        localRow.refreshActualCost();
        localRow.setCostpricesource(row.getString("costpricesource"));
        localRow.setDesignatedcost(row.getBoolean("designatedcost"));
        localRow.setCostpriceSourceType(row.getString("costpricesourcetype"));
        localRow.setEnableJoinCalute(row.getBoolean("enablejoincalute"));
        return localRow;
    }

    protected final Map<Long, CostSubElement> getElementMap() {
        if (this.elementMap != null) {
            return this.elementMap;
        }
        if (this.calbycostelement) {
            this.elementMap = this.ctx.getElementMap();
        } else {
            this.elementMap = new HashMap<Long, CostSubElement>();
            this.elementMap.put(773175233367685120L, this.ctx.getElementMap().get(773175233367685120L));
        }
        return this.elementMap;
    }

    @Override
    public void afterAllCalculate() {
        if (this.runningMode == 0) {
            return;
        }
        this.beforeEndCalculated();
        this.writeEndRpt();
        this.afterEndCalculated();
        this.flushUpdateRow();
        this.flushCostAdjust();
        this.insertCalRpt();
    }

    private void flushUpdateRow() {
        if (RptStatus.ERROR.getValue().equals(this.holder.getCalStatusValue())) {
            for (Object[] updateRowInfo : this.toUpdatedGroupRowMap.values()) {
                this.ctx.collectCostUpdateInfo(updateRowInfo);
            }
            return;
        }
        for (Object[] updateRowInfo : this.toUpdatedRowMap.values()) {
            this.ctx.collectCostUpdateInfo(updateRowInfo);
        }
    }

    private void flushCostAdjust() {
        if (RptStatus.ERROR.getValue().equals(this.holder.getCalStatusValue()) || this.adjustInfoMap.isEmpty()) {
            return;
        }
        HashSet<DynamicObject> adjustDyInfos = new HashSet<DynamicObject>(this.adjustInfoMap.size());
        HashMap periodAdjustInfoMap = new HashMap(16);
        for (CostAdjustInfo costAdjustInfo : this.adjustInfoMap.values()) {
            if (costAdjustInfo.isEmptyEntry()) continue;
            adjustDyInfos.add(costAdjustInfo.getCostAdjustBill());
            Object period = costAdjustInfo.getCostAdjustBill().get("period");
            periodAdjustInfoMap.putIfAbsent(period, new ArrayList());
            List adjustInfoList = (List)periodAdjustInfoMap.get(period);
            adjustInfoList.add(costAdjustInfo.getCostAdjustEntryId());
        }
        if (adjustDyInfos.isEmpty()) {
            return;
        }
        SaveServiceHelper.save((DynamicObject[])adjustDyInfos.toArray(new DynamicObject[0]));
        HashSet<Long> adjustIdSet = new HashSet<Long>(16);
        for (DynamicObject info : adjustDyInfos) {
            adjustIdSet.add(info.getLong("id"));
        }
        DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((Object[])adjustIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cal_costadjust_subentity"));
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignoreop", "true");
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignoreValidation", "true");
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_costadjust_subentity", (DynamicObject[])dynamicObjectArray, (OperateOption)option);
        if (!opResult.isSuccess()) {
            throw new KDBizException(opResult.getAllErrorOrValidateInfo() + "\r\n" + opResult.getMessage());
        }
        for (List entryIdList : periodAdjustInfoMap.values()) {
            this.ctx.getBalanceCalculator().updateBalance4CostAdjust(entryIdList.toArray());
        }
    }

    protected void doCalculate(AccountTypeContext ctx) throws KDBizException {
        if (this.beforeRowId == null) {
            return;
        }
        LocalRow groupedRow = this.getGroupedRow(this.beforeRowId);
        if (groupedRow == null) {
            if ("OUT".equals(this.beforeRow.getCalbilltype()) && "0".equals(this.beforeRow.getQueuetype()) && ctx.enableNoSrcOutReturn()) {
                this.getCostPrice4CostRecord(this.beforeRow, "I");
            }
            this.calculateOut(this.beforeRow);
        } else {
            if (!groupedRow.isCostDetermined() && groupedRow.isGroupCostCalculated().booleanValue() && groupedRow.isDestBill()) {
                ArrayList<LocalRow> localRows = new ArrayList<LocalRow>(1);
                localRows.add(groupedRow);
                this.afterCalcGroupCost(localRows);
            }
            if (AccountTypeEnum.WEIGHTAVG.getValue().equals(this.accountType) || AccountTypeEnum.SPPRICE.getValue().equals(this.accountType) || AccountTypeEnum.MOVEDAVG_INTIME.getValue().equals(this.accountType)) {
                this.loopInBillGetPrice(groupedRow);
            }
            groupedRow.setBizbillid(this.beforeRow.getBizbillid());
            groupedRow.setBizbillentryid(this.beforeRow.getBizbillentryid());
            groupedRow.setBilltypenum(this.beforeRow.getBilltypenum());
            groupedRow.setBilltype(this.beforeRow.getBilltype());
            groupedRow.setBillnumber(this.beforeRow.getBillnumber());
            groupedRow.setBizTypeId(this.beforeRow.getBizTypeId());
            groupedRow.setCalbilltype(this.beforeRow.getCalbilltype());
            groupedRow.setBizDate(this.beforeRow.getBizDate());
            groupedRow.setAuditTime(this.beforeRow.getAuditTime());
            groupedRow.setEntrySeq(this.beforeRow.getEntrySeq());
            groupedRow.setBaseUnitId(this.beforeRow.getBaseUnitId());
            groupedRow.setQtyPrecision(this.beforeRow.getQtyPrecision());
            groupedRow.setInvTxZeroCost(this.beforeRow.isInvTxZeroCost());
            groupedRow.setPresent(this.beforeRow.isPresent());
            this.calculateOut(groupedRow);
        }
    }

    protected void loopInBillGetPrice(LocalRow groupedRow) {
        if (!groupedRow.isCostDetermined() && !groupedRow.isGroupCostCalculated().booleanValue() && this.isPriced && "0".equals(groupedRow.getQueuetype()) && groupedRow.isDestBill() && this.ctx.enableLoopInBill()) {
            this.getCostPrice4CostRecord(groupedRow, "D");
        }
    }

    protected String getCreateDiffBillType() {
        return this.createDiffBillType;
    }

    protected BigDecimal getDiffrange() {
        return this.diffrange;
    }

    private void loadParameters() {
        BigDecimal diffrangeqty;
        ParamCache param = this.ctx.getParamCache();
        Object iscyclebillcal = param.getParamValue(this.getCalOrgId(), "iscyclebillcal");
        String creatediffbilltype = (String)param.getParamValue(this.getCalOrgId(), "creatediffbilltype");
        if (StringUtils.isEmpty((String)creatediffbilltype)) {
            creatediffbilltype = "diffadjust";
        }
        this.createDiffBillType = creatediffbilltype;
        Object diffrangeOj = param.getParamValue(this.getCalOrgId(), "diffrange");
        this.diffrange = diffrangeqty = new BigDecimal(String.valueOf(diffrangeOj));
        this.isPriced = iscyclebillcal == null ? false : (Boolean)iscyclebillcal;
        this.calbycostelement = param.isCalByElement(this.getCostAccountId());
    }

    protected abstract void calculateOut(LocalRow var1);

    protected String[] buildOrderByField() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.addAll(Arrays.asList(this.getOrderByField()));
        fields.add("entryid");
        return fields.toArray(new String[fields.size()]);
    }

    protected abstract String[] getOrderByField();

    protected void writeEndRpt() {
        String errorInfo;
        StringBuilder endFormula = new StringBuilder();
        int endindex = this.holder.createNewEntry();
        this.holder.setBillType(endindex, ResManager.loadKDString((String)"\u671f\u672b\u4f59\u989d", (String)"AbstractAccountType_1", (String)"fi-calx-algox", (Object[])new Object[0]));
        endFormula.append(this.toBigDecimalString(this.currentTotalQty.setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
        endFormula.append('*');
        BigDecimal unitActualCost = this.currentTotalQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(this.pricePrecision) : this.currentTotalCost.divide(this.currentTotalQty, this.pricePrecision, RoundingMode.HALF_UP);
        endFormula.append(this.toBigDecimalString(unitActualCost));
        endFormula.append('=');
        endFormula.append(this.toBigDecimalString(this.currentTotalCost.setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
        this.holder.setBalanceFormula(endindex, endFormula.toString());
        if (AccountTypeEnum.WEIGHTAVG.getValue().equals(this.accountType) || AccountTypeEnum.SPPRICE.getValue().equals(this.accountType)) {
            if (this.currentTotalQty.compareTo(BigDecimal.ZERO) < 0) {
                this.holder.setCalStatus(RptStatus.WARNING);
                this.holder.setLog(ResManager.loadKDString((String)"\u671f\u672b\u8d1f\u5e93\u5b58", (String)"AbstractAccountType_14", (String)"fi-calx-algox", (Object[])new Object[0]) + "\n");
            }
            if (this.currentTotalQty.compareTo(BigDecimal.ZERO) == 0 && this.currentTotalCost.compareTo(BigDecimal.ZERO) != 0 || this.currentTotalQty.compareTo(BigDecimal.ZERO) != 0 && this.currentTotalCost.compareTo(BigDecimal.ZERO) == 0) {
                if (!this.beginAmtAllZero || !this.weightInBillAmtAllZero || this.inBillQtyAllZero || !this.weightOutBillUnitAmtAllZero) {
                    this.holder.setCalStatus(RptStatus.WARNING);
                    this.holder.setLog(ResManager.loadKDString((String)"\u671f\u672b\u96f6\u5355\u4ef7", (String)"AbstractAccountType_16", (String)"fi-calx-algox", (Object[])new Object[0]) + "\n");
                }
            } else if (unitActualCost.compareTo(BigDecimal.ZERO) < 0) {
                this.holder.setCalStatus(RptStatus.WARNING);
                this.holder.setLog(ResManager.loadKDString((String)"\u671f\u672b\u8d1f\u5355\u4ef7", (String)"AbstractAccountType_15", (String)"fi-calx-algox", (Object[])new Object[0]) + "\n");
            }
        }
        if (StringUtils.isEmpty((String)(errorInfo = this.getEndErrorMsg()))) {
            String warnInfo = this.getEndWarnMsg();
            if (StringUtils.isNotEmpty((String)warnInfo)) {
                this.holder.appendBalanceFormula(endindex, warnInfo);
                this.holder.setCalStatus(RptStatus.WARNING);
            }
        } else {
            int j;
            StringBuilder describeSb;
            String[] describeStrs;
            Object describe;
            String describeStr;
            boolean updateCostPrice;
            int i;
            if (AccountTypeEnum.WEIGHTAVG.getValue().equals(this.accountType) || AccountTypeEnum.SPPRICE.getValue().equals(this.accountType)) {
                if (errorInfo.contains(ResManager.loadKDString((String)"\u5b58\u5728\u6210\u7ec4\u5165\u5e93\u6216\u51fa\u5e93\u5355\u4f4d\u6750\u6599\u6210\u672c\u5c0f\u4e8e0\u7684\u5355\u636e\u3002", (String)"AbstractAccountType_18", (String)"fi-calx-algox", (Object[])new Object[0]))) {
                    this.holder.setCalStatus(RptStatus.ERROR);
                    for (i = 0; i < this.holder.getEntrys().size(); ++i) {
                        if (this.holder.getUpdateCostPriceMap().get(i) == null || !(updateCostPrice = this.holder.getUpdateCostPriceMap().get(i).booleanValue()) || !StringUtils.isNotEmpty((String)(describeStr = String.valueOf(describe = this.holder.getEntrys().get(i)[14])))) continue;
                        describeStrs = describeStr.split(",");
                        describeSb = new StringBuilder();
                        for (j = 0; j < describeStrs.length - 1; ++j) {
                            describeSb.append(describeStrs[j]);
                            describeSb.append(",");
                        }
                        if (describeSb.length() <= 0) continue;
                        describeStr = describeSb.substring(0, describeSb.length() - 1);
                        this.holder.setDescribe(i, describeStr);
                    }
                    this.holder.setLog(ResManager.loadKDString((String)"\u6210\u7ec4\u5355\u636e\u6216\u8005\u51fa\u5e93\u5355\u636e\u8d1f\u5355\u4ef7\u3002", (String)"AbstractAccountType_17", (String)"fi-calx-algox", (Object[])new Object[0]) + "\n");
                } else {
                    this.holder.setCalStatus(RptStatus.WARNING);
                }
            } else {
                this.holder.setCalStatus(RptStatus.ERROR);
                for (i = 0; i < this.holder.getEntrys().size(); ++i) {
                    if (this.holder.getUpdateCostPriceMap().get(i) == null || !(updateCostPrice = this.holder.getUpdateCostPriceMap().get(i).booleanValue()) || !StringUtils.isNotEmpty((String)(describeStr = String.valueOf(describe = this.holder.getEntrys().get(i)[14])))) continue;
                    describeStrs = describeStr.split(",");
                    describeSb = new StringBuilder();
                    for (j = 0; j < describeStrs.length - 1; ++j) {
                        describeSb.append(describeStrs[j]);
                        describeSb.append(",");
                    }
                    if (describeSb.length() <= 0) continue;
                    describeStr = describeSb.substring(0, describeSb.length() - 1);
                    this.holder.setDescribe(i, describeStr);
                }
            }
            this.holder.appendBalanceFormula(endindex, errorInfo);
        }
        Map<Long, CostSubElement> id2NameMap = this.getElementMap();
        for (Map.Entry<Long, BigDecimal> entry : this.currentTotalElementCost.entrySet()) {
            endFormula.setLength(0);
            Long elementId = entry.getKey();
            BigDecimal elementTotalCost = entry.getValue();
            if (elementTotalCost.compareTo(BigDecimal.ZERO) == 0) continue;
            int subIndex = this.holder.createNewSubEntry(endindex, id2NameMap.get(elementId).getName());
            endFormula.append(this.toBigDecimalString(this.currentTotalQty.setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
            endFormula.append('*');
            BigDecimal elementUnitActualCost = this.currentTotalQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(this.pricePrecision) : elementTotalCost.divide(this.currentTotalQty, this.pricePrecision, RoundingMode.HALF_UP);
            endFormula.append(this.toBigDecimalString(elementUnitActualCost));
            endFormula.append('=');
            endFormula.append(this.toBigDecimalString(elementTotalCost.setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
            this.holder.setBalanceFormula(subIndex, endFormula.toString());
        }
    }

    protected String getEndErrorMsg() {
        StringBuilder endFormula = new StringBuilder();
        if (this.hasPriceFailedBill) {
            endFormula.append("\r\n");
            endFormula.append(ResManager.loadKDString((String)"\u6210\u672c\u57df\u5185\u5b58\u5728\u53d6\u4ef7\u5931\u8d25\u7684\u5355\u636e\uff0c\u7ed3\u8f6c\u5931\u8d25\u3002", (String)"AbstractAccountType_12", (String)"fi-calx-algox", (Object[])new Object[0]));
        } else if (this.exceptionRow.size() > 0) {
            endFormula.append("\r\n");
            StringBuilder newEndFormula = new StringBuilder();
            if (this.exceptionRow.size() > 3) {
                for (int i = 0; i <= 3; ++i) {
                    LocalRow row = this.exceptionRow.get(i);
                    newEndFormula.append(row.getBillnumber());
                    newEndFormula.append(',');
                }
                newEndFormula.deleteCharAt(newEndFormula.length() - 1);
                newEndFormula.append("...");
            } else {
                for (LocalRow row : this.exceptionRow) {
                    newEndFormula.append(row.getBillnumber());
                    newEndFormula.append(',');
                }
                newEndFormula.deleteCharAt(newEndFormula.length() - 1);
            }
            String msg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u6210\u7ec4\u5165\u5e93\u6216\u51fa\u5e93\u5355\u4f4d\u6750\u6599\u6210\u672c\u5c0f\u4e8e0\u7684\u5355\u636e\u201c%1$s\u201d\uff0c\u7ed3\u8f6c\u5931\u8d25\u3002", (String)"AbstractAccountType_6", (String)"fi-calx-algox", (Object[])new Object[0]), newEndFormula.toString());
            endFormula.append(msg);
        } else {
            return null;
        }
        return endFormula.toString();
    }

    protected String getEndWarnMsg() {
        BigDecimal unitActualCost;
        StringBuilder endFormula = new StringBuilder();
        BigDecimal bigDecimal = unitActualCost = this.currentTotalQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : this.currentTotalCost.divide(this.currentTotalQty, 10, RoundingMode.HALF_UP);
        if (this.currentTotalQty.compareTo(BigDecimal.ZERO) != 0 && unitActualCost.compareTo(BigDecimal.ZERO) == 0) {
            if ((AccountTypeEnum.WEIGHTAVG.getValue().equals(this.accountType) || AccountTypeEnum.SPPRICE.getValue().equals(this.accountType)) && this.beginAmtAllZero && this.weightInBillAmtAllZero && !this.inBillQtyAllZero && this.weightOutBillUnitAmtAllZero) {
                return null;
            }
            endFormula.append("\r\n");
            endFormula.append(ResManager.loadKDString((String)"\u8b66\u544a\uff1a\u671f\u672b\u6570\u91cf\u4e0d\u4e3a0\uff0c\u4f46\u671f\u672b\u5355\u4ef7=0\u3002", (String)"AbstractAccountType_13", (String)"fi-calx-algox", (Object[])new Object[0]));
        } else if (this.currentTotalQty.compareTo(BigDecimal.ZERO) != 0 && unitActualCost.compareTo(BigDecimal.ZERO) < 0) {
            endFormula.append("\r\n");
            endFormula.append(ResManager.loadKDString((String)"\u8b66\u544a\uff1a\u671f\u672b\u6570\u91cf\u4e0d\u4e3a0\uff0c\u4f46\u671f\u672b\u5355\u4ef7<0\u3002", (String)"AbstractAccountType_2", (String)"fi-calx-algox", (Object[])new Object[0]));
        } else if (this.currentTotalQty.compareTo(BigDecimal.ZERO) < 0) {
            endFormula.append("\r\n");
            endFormula.append(ResManager.loadKDString((String)"\u8b66\u544a\uff1a\u671f\u672b\u6570\u91cf<0\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"AbstractAccountType_3", (String)"fi-calx-algox", (Object[])new Object[0]));
        } else if (this.currentTotalQty.compareTo(BigDecimal.ZERO) == 0 && this.currentTotalCost.compareTo(BigDecimal.ZERO) != 0) {
            endFormula.append("\r\n");
            endFormula.append(ResManager.loadKDString((String)"\u8b66\u544a\uff1a\u671f\u672b\u6570\u91cf\u4e3a0\u4f46\u671f\u672b\u6210\u672c\u4e0d\u4e3a0\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"AbstractAccountType_5", (String)"fi-calx-algox", (Object[])new Object[0]));
        } else {
            return null;
        }
        return endFormula.toString();
    }

    protected void addCostUpdateInfo(LocalRow row) {
        if (row.getUnitActualCost().compareTo(BigDecimal.ZERO) < 0) {
            this.exceptionRow.add(row);
            return;
        }
        Object[] updateInfo = this.toUpdatedRowMap.get(row.getEntryId());
        if (updateInfo == null) {
            updateInfo = this.ctx.createUpdateInfo(row);
            this.toUpdatedRowMap.put(row.getEntryId(), updateInfo);
        }
        if (row.isDestBill() && this.isUpdateDestBillAccountType()) {
            this.toUpdatedGroupRowMap.put(row.getEntryId(), updateInfo);
        }
        this.ctx.setUpdateCost(row, updateInfo);
    }

    protected boolean isUpdateDestBillAccountType() {
        return false;
    }

    protected final CostAdjustInfo addGroupBillCostAdjustInfo(LocalRow row) {
        if (!row.isGenGroupAdjBill()) {
            return null;
        }
        String callbilltype = null;
        callbilltype = row.getQueuetype().equals("0") ? "A" : "B";
        CostAdjustInfo adjustInfo = null;
        BigDecimal totalAdjustAmt = BigDecimal.ZERO;
        Set purSet = (Set)this.ctx.getParamCache().getParamValue("purBizEntityObjectSet");
        Set ominSet = (Set)this.ctx.getParamCache().getParamValue("ominBizEntityObjectSet");
        for (Map.Entry<Object, BigDecimal> entry : row.getGroupCostAmtMap().entrySet()) {
            BigDecimal adjustCost = BigDecimal.ZERO;
            if (row.isCalbycostelement()) {
                Long subElementId = (Long)entry.getKey();
                if (purSet.contains(row.getBizEntityObject()) && row.isSubbillInvoiceverify() && "001".equals(this.elementMap.get(subElementId).getType()) || ominSet.contains(row.getBizEntityObject()) && row.isSubbillInvoiceverify() && "005".equals(this.elementMap.get(subElementId).getType())) continue;
                adjustCost = entry.getValue().subtract(row.getCost((Long)entry.getKey()));
            } else {
                String entryField = (String)entry.getKey();
                if (purSet.contains(row.getBizEntityObject()) && row.isSubbillInvoiceverify() && "materialcost".equals(entryField) || ominSet.contains(row.getBizEntityObject()) && row.isSubbillInvoiceverify() && "processcost".equals(entryField)) continue;
                adjustCost = entry.getValue().subtract(row.getCost((String)entry.getKey()));
            }
            if (adjustCost.compareTo(BigDecimal.ZERO) == 0) continue;
            if (adjustInfo == null) {
                adjustInfo = CostAdjustInfo.createCostAdjustByRecord(row.getHeadid(), row.getEntryId(), callbilltype, "F", null);
            }
            totalAdjustAmt = totalAdjustAmt.add(adjustCost);
            if (!row.isCalbycostelement()) continue;
            adjustInfo.setAdjustCost(this.getElementMap().get((Long)entry.getKey()), adjustCost);
        }
        if (adjustInfo != null) {
            if (!row.isCalbycostelement()) {
                adjustInfo.setAdjustCost(this.getElementMap().get(773175233367685120L), totalAdjustAmt);
            }
            this.adjustInfoMap.put(adjustInfo.getCostAdjustEntryId(), adjustInfo);
        }
        return adjustInfo;
    }

    protected final void insertCalRpt() {
        try (TXHandle h = TX.requiresNew();){
            if (this.isLastPeriodData().booleanValue() || !this.ctx.isWriteRpt() || this.ctx.isOnlyWriteErrRpt() && this.holder.getCalStatusValue().equals(RptStatus.SUCESS.getValue())) {
                return;
            }
            try {
                this.holder.flushRptInfo(new DBRoute("cal"));
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    protected String toBigDecimalString(BigDecimal bigdecimal) {
        String bgStr = bigdecimal.toPlainString();
        if (bigdecimal.signum() < 0) {
            bgStr = "(" + bgStr + ")";
        }
        return bgStr;
    }

    protected CostAdjustInfo createCostAdjustInfo(LocalRow row, String callBillType, String createType, DynamicObject costAdjustOutBillType) {
        CostAdjustInfo info = null;
        if ("1".equals(row.getRowtype())) {
            boolean isBillTypeToCostAdjust = "OUT".equals(row.getBilltype()) && !row.isDestBill() && !row.isSrcBill() && "N".equals(createType);
            info = CostAdjustInfo.createCostAdjustByRecord(row.getHeadid(), row.getEntryId(), callBillType, createType, costAdjustOutBillType, isBillTypeToCostAdjust);
        } else if ("2".equals(row.getRowtype())) {
            info = CostAdjustInfo.createCostAdjustByAdjust(row.getHeadid(), row.getEntryId(), callBillType, createType, costAdjustOutBillType);
        }
        if (info != null) {
            this.adjustInfoMap.put(info.getCostAdjustEntryId(), info);
        }
        return info;
    }

    private void dealBalanceData(DataSet balanceData) {
        HashSet<Long> balanceIdSet = new HashSet<Long>(16);
        while (balanceData.hasNext()) {
            Row row = balanceData.next();
            Long balanceId = row.getLong("id");
            if (balanceIdSet.contains(balanceId)) continue;
            balanceIdSet.add(balanceId);
            if (this.isEmptyRange) {
                this.holder.addDivideBasisValue(row.getString("divideBasisValue"));
            }
            BigDecimal actualcost = row.getBigDecimal("actualcost");
            BigDecimal qty = row.getBigDecimal("baseqty");
            for (Long elementId : this.getElementMap().keySet()) {
                BigDecimal elementBalance = this.currentTotalElementCost.get(elementId);
                this.currentTotalElementCost.put(elementId, elementBalance.add(row.getBigDecimal(elementId.toString())));
            }
            this.currentTotalCost = this.currentTotalCost.add(actualcost);
            this.currentTotalQty = this.currentTotalQty.add(qty);
        }
    }

    protected void addRptBeginData(DataSet balanceData) {
        int index = this.holder.createNewEntry();
        this.holder.setBillType(index, ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"AbstractAccountType_4", (String)"fi-calx-algox", (Object[])new Object[0]));
        StringBuilder formula = new StringBuilder();
        formula.append(this.toBigDecimalString(this.currentTotalQty.setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
        formula.append('*');
        BigDecimal unitActualCost = this.currentTotalQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(this.pricePrecision) : this.currentTotalCost.divide(this.currentTotalQty, this.pricePrecision, RoundingMode.HALF_UP);
        formula.append(this.toBigDecimalString(unitActualCost));
        formula.append('=');
        formula.append(this.toBigDecimalString(this.currentTotalCost.setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
        this.holder.setBalanceFormula(index, formula.toString());
        if (AccountTypeEnum.WEIGHTAVG.getValue().equals(this.accountType) || AccountTypeEnum.SPPRICE.getValue().equals(this.accountType) || AccountTypeEnum.MOVEDAVG_INTIME.getValue().equals(this.accountType)) {
            if (unitActualCost.compareTo(BigDecimal.ZERO) < 0) {
                this.BeginPrice = -1;
                this.beginAmtAllZero = false;
            } else if (unitActualCost.compareTo(BigDecimal.ZERO) == 0) {
                this.BeginPrice = 0;
            } else {
                this.beginAmtAllZero = false;
            }
            if (BigDecimal.ZERO.compareTo(this.currentTotalQty) != 0) {
                this.beginQtyAllZero = false;
            }
            if (this.currentTotalCost == null && this.currentTotalQty == null || this.currentTotalCost != null && this.currentTotalQty != null && BigDecimal.ZERO.compareTo(this.currentTotalCost) == 0 && BigDecimal.ZERO.compareTo(this.currentTotalQty) == 0) {
                this.setInvalidCalBal(true);
            }
        }
        for (Map.Entry<Long, BigDecimal> entry : this.currentTotalElementCost.entrySet()) {
            Long elementId = entry.getKey();
            BigDecimal elementBalance = entry.getValue();
            if (elementBalance.compareTo(BigDecimal.ZERO) == 0) continue;
            int subIndex = this.holder.createNewSubEntry(index, this.getElementMap().get(elementId).getName());
            formula.setLength(0);
            formula.append(this.toBigDecimalString(this.currentTotalQty.setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
            formula.append('*');
            formula.append(this.toBigDecimalString(this.currentTotalQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(this.pricePrecision) : elementBalance.divide(this.currentTotalQty, this.pricePrecision, RoundingMode.HALF_UP)));
            formula.append('=');
            formula.append(this.toBigDecimalString(elementBalance.setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
            this.holder.setBalanceFormula(subIndex, formula.toString());
        }
    }

    private void initCalRangeInfo(Row row) {
        String[] calDimensions;
        this.setCalOrgId(row.getLong("calorg"));
        this.costAccountId = row.getLong("costaccount");
        this.materialId = row.getLong("material");
        this.amtPrecision = row.getInteger("amtprecision");
        this.pricePrecision = row.getInteger("priceprecision");
        this.qtyPrecision = row.getInteger("qtyprecision");
        this.currency = row.getLong("localcurrency");
        this.periodId = row.getLong("periodid");
        this.accountType = row.getString("accountType");
        this.calDimension = row.getLong("calDimension");
        this.calDimensionStr = row.getString("calDimensionStr");
        if (!StringUtils.isEmpty((String)this.calDimensionStr) && this.calDimensionStr.endsWith(",")) {
            this.calDimensionStr = this.calDimensionStr.substring(0, this.calDimensionStr.length() - 1);
        }
        if (!StringUtils.isEmpty((String)this.calDimensionStr) && (calDimensions = this.calDimensionStr.split(",")) != null && calDimensions.length > 0) {
            for (String calDimension : calDimensions) {
                if (StringUtils.isEmpty((String)calDimension)) continue;
                if ("assist".equals(calDimension)) {
                    this.assistId = row.getLong(calDimension);
                    if (this.assistId != null) continue;
                    this.assistId = 0L;
                    continue;
                }
                if ("configuredcode".equals(calDimension)) {
                    this.configuredcodeId = row.getLong(calDimension);
                    if (this.configuredcodeId != null) continue;
                    this.configuredcodeId = 0L;
                    continue;
                }
                if ("project".equals(calDimension)) {
                    this.projectId = row.getLong(calDimension);
                    if (this.projectId != null) continue;
                    this.projectId = 0L;
                    continue;
                }
                if (!"tracknumber".equals(calDimension)) continue;
                this.tracknumberId = row.getLong(calDimension);
                if (this.tracknumberId != null) continue;
                this.tracknumberId = 0L;
            }
        }
        this.calDimensionValue = row.getString("calDimensionValue");
        this.divideBasis = row.getLong("divideBasis");
        this.divideBasisStr = row.getString("divideBasisStr");
        if (this.divideBasisStr.endsWith(",")) {
            this.divideBasisStr = this.divideBasisStr.substring(0, this.divideBasisStr.length() - 1);
        }
        this.divideBasisValue = row.getString("divideBasisValue");
        this.calRangeId = row.getLong("calRange");
        this.isEmptyRange = row.getBoolean("isEmptyRange");
        this.initRptHolder();
        this.loadParameters();
        Map<Long, CostSubElement> elementNameMap = this.getElementMap();
        this.currentTotalElementCost = new HashMap<Long, BigDecimal>(elementNameMap.size());
        for (Long elementId : elementNameMap.keySet()) {
            this.currentTotalElementCost.put(elementId, BigDecimal.ZERO);
        }
        if (!"2".equals(row.getString("rowtype")) && "IN".equals(row.getString("calbilltype"))) {
            BigDecimal qty;
            BigDecimal bigDecimal = qty = row.getBigDecimal("baseqty") == null ? BigDecimal.ZERO : row.getBigDecimal("baseqty");
            if (BigDecimal.ZERO.compareTo(qty) != 0) {
                this.inBillQtyAllZero = false;
            }
        }
    }

    private void initRptHolder() {
        this.holder.setCalDimensionID(this.calDimension);
        this.holder.setDivideBasisID(this.divideBasis);
        this.holder.setCalDimensionValue(this.calDimensionValue);
        this.holder.setAccountType(this.accountType);
        this.holder.setCalOrgID(this.getCalOrgId());
        this.holder.setCostAccountID(this.costAccountId);
        this.holder.setMaterialID(this.materialId);
        this.holder.setPeriodID(this.periodId);
        this.holder.setCalRangeID(this.calRangeId);
        this.holder.setAssistId(this.assistId);
        this.holder.setConfiguredcodeId(this.configuredcodeId);
        this.holder.setProjectId(this.projectId);
        this.holder.setTracknumberId(this.tracknumberId);
        boolean matrix = this.ctx.enableMatrix();
        this.holder.setMatrix(matrix);
        boolean costatenddateenable = this.ctx.enableCostatenddateenable();
        this.holder.setCostatenddateenable(costatenddateenable);
        if (costatenddateenable) {
            Date costatenddate = this.ctx.getCostatenddate();
            this.holder.setCostatenddate(costatenddate);
        }
    }

    protected final void getCostPrice4CostRecord(LocalRow row, String priceObject) {
        if (!"1".equals(row.getRowtype())) {
            return;
        }
        CostPriceResultInfo priceResult = this.getCostPrice(row.getHeadid(), row.getEntryId(), row.getRowtype(), priceObject);
        row.setPriceResult(priceResult);
        if (priceResult == null || !priceResult.isSuccess()) {
            this.hasPriceFailedBill = true;
        }
    }

    protected final CostPriceResultInfo getCostPrice(Long rowHeadId, Long rowEntryId, String rowType, String priceConstant) {
        CostPriceResultInfo result = null;
        if ("1".equals(rowType)) {
            result = this.ctx.getPriceHelper().getPriceFromEntryId("cal_costrecord_subentity", rowHeadId, rowEntryId, priceConstant);
        } else if ("2".equals(rowType)) {
            result = this.ctx.getPriceHelper().getPriceFromEntryId("cal_costadjust_subentity", rowHeadId, rowEntryId, priceConstant);
        }
        return result;
    }

    public int getCalPricePrecision() {
        return this.calPricePrecision;
    }

    public void setCalPricePrecision(int calPricePrecision) {
        this.calPricePrecision = calPricePrecision;
    }

    public long getCalOrgId() {
        return this.calOrgId;
    }

    public void setCalOrgId(long calOrgId) {
        this.calOrgId = calOrgId;
    }

    public int getQtyPrecision() {
        return this.qtyPrecision;
    }

    public void setQtyPrecision(int qtyPrecision) {
        this.qtyPrecision = qtyPrecision;
    }

    public Long getCurrency() {
        return this.currency;
    }

    public void setCurrency(Long currency) {
        this.currency = currency;
    }

    public int getRunningMode() {
        return this.runningMode;
    }

    private Boolean isLastPeriodData() {
        if (this.costAccountMap.get(this.costAccountId) == null) {
            return Boolean.FALSE;
        }
        Long costAccountPeriodid = this.costAccountMap.get(this.costAccountId).getCurrentPeriod();
        if (costAccountPeriodid != null && costAccountPeriodid.compareTo(this.periodId) != 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected Map<Long, String> afterCalcGroupCost(List<LocalRow> oldInGroupRows) {
        ArrayList<LocalRow> inGroupRows = new ArrayList<LocalRow>(16);
        for (LocalRow inGroupRow : oldInGroupRows) {
            if (inGroupRow == null) continue;
            inGroupRows.add(inGroupRow);
        }
        this.addPriceByPercent(inGroupRows);
        List<String> implClassList = this.ctx.getCalGroupCostImplClasses();
        CalServiceHelper calServiceHelper = new CalServiceHelper();
        if (inGroupRows == null || inGroupRows.size() < 1) {
            return null;
        }
        BigDecimal actualCost = inGroupRows.get(0) == null ? BigDecimal.ZERO : ((LocalRow)inGroupRows.get(0)).getActualCost();
        Long entryid = inGroupRows.get(0) == null ? Long.valueOf(0L) : ((LocalRow)inGroupRows.get(0)).getEntryId();
        DiffAllocHelper.writeLog(logger, "AbstractAccountType_afterCalcGroupCost_billentryid:" + entryid + "_before_afterCalcGroupCost_actualcost:" + actualCost);
        Long currtime = System.currentTimeMillis();
        Map<Long, String> result = calServiceHelper.doBizChain(implClassList, inGroupRows);
        Long times = System.currentTimeMillis() - currtime;
        DiffAllocHelper.writeLog(logger, "AbstractAccountType_afterCalcGroupCost_time:" + times + "ms");
        actualCost = inGroupRows.get(0) == null ? BigDecimal.ZERO : ((LocalRow)inGroupRows.get(0)).getActualCost();
        DiffAllocHelper.writeLog(logger, "AbstractAccountType_afterCalcGroupCost_billentryid:" + entryid + "_after_afterCalcGroupCost_actualcost:" + actualCost);
        return result;
    }

    private void addPriceByPercent(List<LocalRow> inGroupRows) {
        for (LocalRow destRow : inGroupRows) {
            if (!destRow.isGroupCostCalculated().booleanValue()) continue;
            BigDecimal addPricePercent = destRow.getAddPricePercent();
            int destAmtPrecision = destRow.getAmtprecision();
            boolean isPriced = destRow.isPriced();
            if (addPricePercent == null || addPricePercent.compareTo(BigDecimal.ZERO) == 0) continue;
            addPricePercent = BigDecimal.ONE.add(addPricePercent.divide(new BigDecimal(100), 10, RoundingMode.HALF_UP));
            boolean isVoucher = destRow.isCostDetermined();
            ParamCache paramCache = this.ctx.getParamCache();
            Set purSet = (Set)paramCache.getParamValue("purBizEntityObjectSet");
            Set ominSet = (Set)paramCache.getParamValue("ominBizEntityObjectSet");
            if (isVoucher || isPriced) continue;
            for (Map.Entry<Object, BigDecimal> groupCostEntry : destRow.getGroupCostAmtMap().entrySet()) {
                BigDecimal destCost;
                if (destRow.isCalbycostelement()) {
                    Long subElementId = (Long)groupCostEntry.getKey();
                    if (purSet.contains(destRow.getBizEntityObject()) && destRow.isSubbillInvoiceverify() && "001".equals(this.elementMap.get(subElementId).getType()) || ominSet.contains(destRow.getBizEntityObject()) && destRow.isSubbillInvoiceverify() && "005".equals(this.elementMap.get(subElementId).getType())) continue;
                    destCost = destRow.getCost(subElementId);
                    destCost = destCost == null ? BigDecimal.ZERO : destCost;
                    destCost = destCost.multiply(addPricePercent).setScale(destAmtPrecision, 4);
                    destRow.setCost(subElementId, destCost);
                } else {
                    String entryField = (String)groupCostEntry.getKey();
                    if (purSet.contains(destRow.getBizEntityObject()) && destRow.isSubbillInvoiceverify() && "materialcost".equals(entryField) || ominSet.contains(destRow.getBizEntityObject()) && destRow.isSubbillInvoiceverify() && "processcost".equals(entryField)) continue;
                    destCost = destRow.getCost(entryField);
                    destCost = destCost == null ? BigDecimal.ZERO : destCost;
                    destCost = destCost.multiply(addPricePercent).setScale(destAmtPrecision, 4);
                    destRow.setCost(entryField, destCost);
                }
                destRow.setGenGroupAdjBill(false);
            }
            destRow.refreshActualCost();
        }
    }

    protected Long getPeriodId() {
        return this.periodId;
    }

    protected DataSet filterEndDate(DataSet data, Date costatenddate) {
        return data;
    }

    protected void setWeightOutBillUnitAmtAllZero(boolean value) {
        this.weightOutBillUnitAmtAllZero = value;
    }

    protected void setWeightInBillAmtAllZero(boolean value) {
        this.weightInBillAmtAllZero = value;
    }
}

