/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.accounttype;

import kd.bos.dataentity.resource.ResManager;

public enum AccountTypeEnum {
    WEIGHTAVG("A", AccountTypeEnum.getWeightavg()),
    SPPRICE("F", AccountTypeEnum.getSpprice()),
    MOVEDAVG_INTIME("C", AccountTypeEnum.getMovedavgIntime()),
    STANDARDCOST("D", AccountTypeEnum.getStandardCost()),
    FIFO("E", AccountTypeEnum.getFIFO()),
    FIN_FOUT_PERIOD("G", AccountTypeEnum.getFinFoutPeriod());

    private String value;
    private String desc;

    private static String getWeightavg() {
        return ResManager.loadKDString((String)"\u52a0\u6743\u5e73\u5747\u6cd5", (String)"AccountTypeEnum_0", (String)"fi-calx-algox", (Object[])new Object[0]);
    }

    private static String getSpprice() {
        return ResManager.loadKDString((String)"\u4e2a\u522b\u8ba1\u4ef7\u6cd5", (String)"AccountTypeEnum_1", (String)"fi-calx-algox", (Object[])new Object[0]);
    }

    private static String getMovedavgIntime() {
        return ResManager.loadKDString((String)"\u5b9e\u65f6\u79fb\u52a8\u52a0\u6743\u5e73\u5747\u6cd5", (String)"AccountTypeEnum_3", (String)"fi-calx-algox", (Object[])new Object[0]);
    }

    private static String getFIFO() {
        return ResManager.loadKDString((String)"\u5148\u8fdb\u5148\u51fa\u6cd5\uff08\u5b9e\u65f6\uff09", (String)"AccountTypeEnum_4", (String)"fi-calx-algox", (Object[])new Object[0]);
    }

    private static String getStandardCost() {
        return ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c\u6cd5", (String)"AccountTypeEnum_5", (String)"fi-calx-algox", (Object[])new Object[0]);
    }

    private static String getFinFoutPeriod() {
        return ResManager.loadKDString((String)"\u5148\u8fdb\u5148\u51fa\u6cd5\uff08\u6708\u672b\uff09", (String)"AccountTypeEnum_6", (String)"fi-calx-algox", (Object[])new Object[0]);
    }

    private AccountTypeEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public static String getName(String accounttype) {
        for (AccountTypeEnum at : AccountTypeEnum.values()) {
            if (!at.getValue().equals(accounttype)) continue;
            return at.getDesc();
        }
        return null;
    }
}

