/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.accounttype;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.fi.calx.algox.CostSubElement;
import kd.fi.calx.algox.helper.CommonSettingHelper;

public class CostAdjustInfo {
    public static final String CALLTYPE_IN = "A";
    public static final String CALLTYPE_OUT = "B";
    public static final String CREATETYPE_GROUPBILL = "F";
    public static final String CREATETYPE_DIFF = "N";
    public static final String CREATETYPE_PREV = "V";
    public static final String CREATETYPE_SALEWF = "B-A2";
    private Long entryId;
    private Long costAdjustId = DBServiceHelper.genLongIds((String)"t_cal_costadjustbill", (int)1)[0];
    private Long costAdjustEntryId = DBServiceHelper.genLongIds((String)"t_cal_costadjustbillentry", (int)1)[0];
    private DynamicObject costAdjustBill;
    private DynamicObject costAdjustBillEntry;
    private Map<Long, DynamicObject> subEntityMap = new HashMap<Long, DynamicObject>();
    private String callBillType;
    private String createType;
    private DynamicObject costAdjustOutBillType;
    private boolean emptyEntry = false;
    private boolean billTypeToCostAdjust = false;

    private CostAdjustInfo(Long id, Long entryId, String callBillType, String createType, DynamicObject costAdjustOutBillType, boolean isFromCostRecord, boolean isBillTypeToCostAdjust) {
        this.entryId = entryId;
        this.callBillType = callBillType;
        this.createType = createType;
        this.costAdjustOutBillType = costAdjustOutBillType;
        this.billTypeToCostAdjust = isBillTypeToCostAdjust;
        this.costAdjustBill = BusinessDataServiceHelper.newDynamicObject((String)"cal_costadjust_subentity");
        if (isFromCostRecord) {
            DynamicObject costRecordInfo = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cal_costrecord");
            this.refreshCostAdjustByRecord(costRecordInfo);
        } else {
            DynamicObject costAdjustInfo = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cal_costadjust_subentity");
            this.refreshCostAdjustByAdjust(costAdjustInfo);
        }
    }

    public static CostAdjustInfo createCostAdjustByRecord(Long costRecordId, Long costRecordEntryId, String callBillType, String createType, DynamicObject costAdjustOutBillType) {
        CostAdjustInfo info = new CostAdjustInfo(costRecordId, costRecordEntryId, callBillType, createType, costAdjustOutBillType, true, false);
        return info;
    }

    public static CostAdjustInfo createCostAdjustByRecord(Long costRecordId, Long costRecordEntryId, String callBillType, String createType, DynamicObject costAdjustOutBillType, boolean isBillTypeToCostAdjust) {
        CostAdjustInfo info = new CostAdjustInfo(costRecordId, costRecordEntryId, callBillType, createType, costAdjustOutBillType, true, isBillTypeToCostAdjust);
        return info;
    }

    public static CostAdjustInfo createCostAdjustByAdjust(Long costAdjustid, Long costAdjustEntryId, String callBillType, String createType, DynamicObject costAdjustOutBillType) {
        CostAdjustInfo info = new CostAdjustInfo(costAdjustid, costAdjustEntryId, callBillType, createType, costAdjustOutBillType, false, false);
        return info;
    }

    private void refreshCostAdjustByRecord(DynamicObject costRecordInfo) {
        String adjustBillno;
        this.costAdjustBill.set("id", (Object)this.costAdjustId);
        this.costAdjustBill.set("currency", costRecordInfo.get("localcurrency"));
        this.costAdjustBill.set("bizdate", (Object)costRecordInfo.getDate("bizdate"));
        this.costAdjustBill.set("bookdate", (Object)costRecordInfo.getDate("bookdate"));
        this.costAdjustBill.set("biztype", (Object)this.callBillType);
        this.costAdjustBill.set("billstatus", (Object)CALLTYPE_OUT);
        this.costAdjustBill.set("difftype", (Object)CALLTYPE_OUT);
        this.costAdjustBill.set("createtype", (Object)this.createType);
        this.costAdjustBill.set("costaccount", (Object)costRecordInfo.getDynamicObject("costaccount"));
        Object accountID = costRecordInfo.getDynamicObject("costaccount").get("masterid");
        DynamicObject costAccont = BusinessDataServiceHelper.loadSingle((Object)accountID, (String)"cal_bd_costaccount", (String)"calorg");
        this.costAdjustBill.set("calorg", costAccont.get("calorg"));
        if (this.costAdjustOutBillType == null) {
            this.costAdjustBill.set("billtype", costRecordInfo.get("billtype"));
        } else {
            this.costAdjustBill.set("billtype", (Object)this.costAdjustOutBillType);
        }
        if (this.billTypeToCostAdjust) {
            this.costAdjustBill.set("billtype", costRecordInfo.get("billtype"));
        }
        Date date = TimeServiceHelper.now();
        this.costAdjustBill.set("createtime", (Object)date);
        this.costAdjustBill.set("auditdate", (Object)date);
        this.costAdjustBill.set("modifytime", (Object)date);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        this.costAdjustBill.set("creator_id", (Object)userId);
        this.costAdjustBill.set("modifier_id", (Object)userId);
        this.costAdjustBill.set("auditor_id", (Object)userId);
        this.costAdjustBill.set("period", costRecordInfo.get("period"));
        if (this.createType.equals(CREATETYPE_DIFF)) {
            this.costAdjustBill.set("cstype", (Object)"bd_customer");
        } else if (this.callBillType.equals(CALLTYPE_IN)) {
            this.costAdjustBill.set("cstype", (Object)"bd_supplier");
        } else {
            this.costAdjustBill.set("cstype", (Object)"bd_customer");
        }
        for (DynamicObject costRecordEntry : costRecordInfo.getDynamicObjectCollection("entry")) {
            if (!costRecordEntry.getPkValue().equals(this.entryId)) continue;
            this.refreshCostAdjustEntryByRecord(costRecordInfo, costRecordEntry, this.callBillType);
            if (this.createType.equals(CREATETYPE_DIFF)) break;
            if (this.callBillType.equals(CALLTYPE_IN)) {
                this.costAdjustBill.set("custsupplier", costRecordEntry.get("balancesupplier"));
                break;
            }
            this.costAdjustBill.set("custsupplier", costRecordEntry.get("balancecustomer"));
            break;
        }
        if ((adjustBillno = CodeRuleServiceHelper.getNumber((String)"cal_costadjust_subentity", (DynamicObject)this.costAdjustBill, (String)String.valueOf(this.costAdjustBill.getLong("calorg_id")))) == null) {
            adjustBillno = String.valueOf(System.currentTimeMillis());
        }
        this.costAdjustBill.set("billno", (Object)adjustBillno);
        this.costAdjustBill.set("adminorg", costRecordInfo.get("adminorg"));
    }

    private void refreshCostAdjustEntryByRecord(DynamicObject costRecordInfo, DynamicObject costRecordEntry, String callBillType) {
        this.costAdjustBillEntry = this.costAdjustBill.getDynamicObjectCollection("entryentity").addNew();
        this.costAdjustBillEntry.set("id", (Object)this.costAdjustEntryId);
        this.costAdjustBillEntry.set("storageorgunit", costRecordInfo.get("storageorgunit"));
        this.costAdjustBillEntry.set("material", costRecordEntry.get("material"));
        this.costAdjustBillEntry.set("lot", costRecordEntry.get("lot"));
        this.costAdjustBillEntry.set("assist", costRecordEntry.get("assist"));
        this.costAdjustBillEntry.set("warehouse", costRecordEntry.get("warehouse"));
        this.costAdjustBillEntry.set("location", costRecordEntry.get("location"));
        this.costAdjustBillEntry.set("ownertype", (Object)"bos_org");
        this.costAdjustBillEntry.set("owner", (Object)costRecordEntry.getDynamicObject("owner"));
        this.costAdjustBillEntry.set("ecostcenter", (Object)costRecordEntry.getDynamicObject("ecostcenter"));
        this.costAdjustBillEntry.set("invbizdate", this.costAdjustBill.get("bookdate"));
        this.costAdjustBillEntry.set("invbilltype", costRecordInfo.get("billtype"));
        this.costAdjustBillEntry.set("invbillnum", (Object)costRecordInfo.getString("billno"));
        this.costAdjustBillEntry.set("inventryseq", costRecordEntry.get("seq"));
        this.costAdjustBillEntry.set("invbillid", costRecordInfo.get("id"));
        this.costAdjustBillEntry.set("invbizentityobject", (Object)"cal_costrecord_subentity");
        this.costAdjustBillEntry.set("invbillentryid", costRecordEntry.get("id"));
        this.costAdjustBillEntry.set("baseunit", costRecordEntry.get("baseunit"));
        this.costAdjustBillEntry.set("project", costRecordEntry.get("project"));
        this.costAdjustBillEntry.set("invtype", costRecordEntry.get("invtype"));
        this.costAdjustBillEntry.set("invstatus", costRecordEntry.get("invstatus"));
        this.costAdjustBillEntry.set("tracknumber", costRecordEntry.get("tracknumber"));
        this.costAdjustBillEntry.set("configuredcode", costRecordEntry.get("configuredcode"));
        this.costAdjustBillEntry.set("adjustamt", (Object)BigDecimal.ZERO);
        this.costAdjustBillEntry.set("queuetype", (Object)(CALLTYPE_IN.equals(callBillType) ? "0" : "1"));
        this.costAdjustBillEntry.set("productline", costRecordEntry.get("productline"));
        this.costAdjustBillEntry.set("noupdatecalfields", costRecordEntry.get("noupdatecalfields"));
        this.costAdjustBillEntry.set("stocktype", costRecordEntry.get("stocktype"));
        MainEntityType costRecordEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costrecord");
        MainEntityType costAdjustEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costadjust_subentity");
        CommonSettingHelper.setExFieldValue(costAdjustEntityType, costRecordEntityType, this.costAdjustBillEntry, costRecordEntry);
    }

    private void refreshCostAdjustByAdjust(DynamicObject costAdjustInfo) {
        String adjustBillno;
        this.costAdjustBill.set("id", (Object)this.costAdjustId);
        this.costAdjustBill.set("currency", this.costAdjustBill.get("currency"));
        this.costAdjustBill.set("bizdate", (Object)costAdjustInfo.getDate("bizdate"));
        this.costAdjustBill.set("bookdate", (Object)costAdjustInfo.getDate("bookdate"));
        this.costAdjustBill.set("biztype", (Object)this.callBillType);
        this.costAdjustBill.set("billstatus", (Object)CALLTYPE_OUT);
        this.costAdjustBill.set("difftype", (Object)CALLTYPE_OUT);
        this.costAdjustBill.set("createtype", (Object)this.createType);
        this.costAdjustBill.set("costaccount", (Object)costAdjustInfo.getDynamicObject("costaccount"));
        Object accountID = costAdjustInfo.getDynamicObject("costaccount").get("masterid");
        DynamicObject costAccont = BusinessDataServiceHelper.loadSingle((Object)accountID, (String)"cal_bd_costaccount", (String)"calorg");
        this.costAdjustBill.set("calorg", costAccont.get("calorg"));
        if (this.costAdjustOutBillType == null) {
            this.costAdjustBill.set("billtype", costAdjustInfo.get("billtype"));
        } else {
            this.costAdjustBill.set("billtype", (Object)this.costAdjustOutBillType);
        }
        Date date = TimeServiceHelper.now();
        this.costAdjustBill.set("createtime", (Object)date);
        this.costAdjustBill.set("auditdate", (Object)date);
        this.costAdjustBill.set("modifytime", (Object)date);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        this.costAdjustBill.set("creator_id", (Object)userId);
        this.costAdjustBill.set("modifier_id", (Object)userId);
        this.costAdjustBill.set("auditor_id", (Object)userId);
        this.costAdjustBill.set("period", costAdjustInfo.get("period"));
        this.costAdjustBill.set("currency", costAdjustInfo.get("currency"));
        for (DynamicObject costAdjustEntry : costAdjustInfo.getDynamicObjectCollection("entryentity")) {
            if (!costAdjustEntry.getPkValue().equals(this.entryId)) continue;
            this.refreshCostAdjustEntryByAdjust(costAdjustInfo, costAdjustEntry, this.callBillType);
            break;
        }
        if ((adjustBillno = CodeRuleServiceHelper.getNumber((String)"cal_costadjust_subentity", (DynamicObject)this.costAdjustBill, (String)String.valueOf(this.costAdjustBill.getLong("calorg_id")))) == null) {
            adjustBillno = String.valueOf(System.currentTimeMillis());
        }
        this.costAdjustBill.set("billno", (Object)adjustBillno);
        this.costAdjustBill.set("cstype", (Object)"bd_customer");
        this.costAdjustBill.set("adminorg", costAdjustInfo.get("adminorg"));
    }

    private void refreshCostAdjustEntryByAdjust(DynamicObject costAdjustInfo, DynamicObject costAdjustEntry, String callBillType) {
        this.costAdjustBillEntry = this.costAdjustBill.getDynamicObjectCollection("entryentity").addNew();
        this.costAdjustBillEntry.set("id", (Object)this.costAdjustEntryId);
        this.costAdjustBillEntry.set("storageorgunit", costAdjustEntry.get("storageorgunit"));
        this.costAdjustBillEntry.set("material", costAdjustEntry.get("material"));
        this.costAdjustBillEntry.set("lot", costAdjustEntry.get("lot"));
        this.costAdjustBillEntry.set("assist", costAdjustEntry.get("assist"));
        this.costAdjustBillEntry.set("warehouse", costAdjustEntry.get("warehouse"));
        this.costAdjustBillEntry.set("location", costAdjustEntry.get("location"));
        this.costAdjustBillEntry.set("ownertype", (Object)"bos_org");
        this.costAdjustBillEntry.set("owner", (Object)costAdjustEntry.getDynamicObject("owner"));
        this.costAdjustBillEntry.set("invbilltype", ((DynamicObject)costAdjustEntry.getParent()).get("billtype"));
        this.costAdjustBillEntry.set("invbillnum", ((DynamicObject)costAdjustEntry.getParent()).get("billno"));
        this.costAdjustBillEntry.set("inventryseq", costAdjustEntry.get("seq"));
        this.costAdjustBillEntry.set("invbillid", ((DynamicObject)costAdjustEntry.getParent()).get("id"));
        this.costAdjustBillEntry.set("invbizentityobject", (Object)"cal_costadjust_subentity");
        this.costAdjustBillEntry.set("invbillentryid", costAdjustEntry.get("id"));
        this.costAdjustBillEntry.set("baseunit", costAdjustEntry.get("baseunit"));
        this.costAdjustBillEntry.set("project", costAdjustEntry.get("project"));
        this.costAdjustBillEntry.set("invtype", costAdjustEntry.get("invtype"));
        this.costAdjustBillEntry.set("invstatus", costAdjustEntry.get("invstatus"));
        this.costAdjustBillEntry.set("tracknumber", costAdjustEntry.get("tracknumber"));
        this.costAdjustBillEntry.set("configuredcode", costAdjustEntry.get("configuredcode"));
        this.costAdjustBillEntry.set("adjustamt", (Object)BigDecimal.ZERO);
        this.costAdjustBillEntry.set("queuetype", (Object)(CALLTYPE_IN.equals(callBillType) ? "0" : "1"));
        this.costAdjustBillEntry.set("productline", costAdjustEntry.get("productline"));
        this.costAdjustBillEntry.set("noupdatecalfields", costAdjustEntry.get("noupdatecalfields"));
        this.costAdjustBillEntry.set("stocktype", costAdjustEntry.get("stocktype"));
        this.costAdjustBillEntry.set("ecostcenter", (Object)costAdjustEntry.getDynamicObject("ecostcenter"));
        if (CREATETYPE_PREV.equals(this.createType)) {
            this.costAdjustBillEntry.set("srcbilltype", (Object)986031578352241664L);
            this.costAdjustBillEntry.set("srcbillnum", costAdjustInfo.get("billno"));
            this.costAdjustBillEntry.set("srcentryseq", (Object)costAdjustEntry.getInt("seq"));
            this.costAdjustBillEntry.set("srcbillid", ((DynamicObject)costAdjustEntry.getParent()).get("id"));
            this.costAdjustBillEntry.set("srcbizentityobject", (Object)"cal_costadjust_subentity");
            this.costAdjustBillEntry.set("srcbillentryid", costAdjustEntry.get("id"));
        }
        MainEntityType costAdjustEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costadjust_subentity");
        CommonSettingHelper.setExFieldValue(costAdjustEntityType, costAdjustEntityType, this.costAdjustBillEntry, costAdjustEntry);
    }

    public void setAdjustCost(CostSubElement subElement, BigDecimal adjustAmt) {
        DynamicObject subEntry = this.subEntityMap.get(subElement.getId());
        BigDecimal beforeCost = BigDecimal.ZERO;
        if (subEntry == null) {
            subEntry = this.costAdjustBillEntry.getDynamicObjectCollection("subentryentity").addNew();
            subEntry.set("costsubelement", (Object)subElement.getId());
            subEntry.set("costelement", (Object)subElement.getCostElementId());
            subEntry.set("sub_material", this.costAdjustBillEntry.get("material"));
            subEntry.set("sub_currency", this.costAdjustBill.get("currency"));
            this.subEntityMap.put(subElement.getId(), subEntry);
        } else {
            beforeCost = subEntry.getBigDecimal("sub_adjustamt");
        }
        BigDecimal totalAmt = this.costAdjustBillEntry.getBigDecimal("adjustamt");
        totalAmt = totalAmt.add(adjustAmt).subtract(beforeCost);
        this.costAdjustBillEntry.set("adjustamt", (Object)totalAmt);
        subEntry.set("sub_adjustamt", (Object)adjustAmt);
    }

    public Long getCostAdjustId() {
        return this.costAdjustId;
    }

    public Long getCostAdjustEntryId() {
        return this.costAdjustBillEntry.getLong("id");
    }

    public DynamicObject getCostAdjustBill() {
        return this.costAdjustBill;
    }

    public BigDecimal getAdjustAmt() {
        return this.costAdjustBillEntry.getBigDecimal("adjustamt");
    }

    public String getBillNo() {
        return this.costAdjustBill.getString("billno");
    }

    public BigDecimal getAdjustCost(Long elementId) {
        DynamicObject subEntry = this.subEntityMap.get(elementId);
        if (subEntry == null) {
            return BigDecimal.ZERO;
        }
        return subEntry.getBigDecimal("sub_adjustamt");
    }

    public String getCallBillType() {
        return this.callBillType;
    }

    public String getCreateType() {
        return this.createType;
    }

    public Date getBizDate() {
        return this.costAdjustBill.getDate("bookdate");
    }

    public Date getAuditDate() {
        return this.costAdjustBill.getDate("auditdate");
    }

    public void clearRelations() {
        this.costAdjustBillEntry.set("invbilltype", null);
        this.costAdjustBillEntry.set("invbillnum", null);
        this.costAdjustBillEntry.set("inventryseq", null);
        this.costAdjustBillEntry.set("invbillid", null);
        this.costAdjustBillEntry.set("invbizentityobject", null);
        this.costAdjustBillEntry.set("invbillentryid", null);
    }

    public boolean isEmptyEntry() {
        return this.emptyEntry;
    }

    public void setEmptyEntry(boolean emptyEntry) {
        this.emptyEntry = emptyEntry;
    }
}

