/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.accounttype;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.calx.algox.CostPriceResultInfo;
import kd.fi.calx.algox.CostSubElement;
import kd.fi.calx.algox.InOutRelationInfo;
import kd.fi.calx.algox.accounttype.AbstractAccountType;
import kd.fi.calx.algox.accounttype.CostAdjustInfo;
import kd.fi.calx.algox.accounttype.FIFOPeriodCalAT;
import kd.fi.calx.algox.accounttype.LocalRow;
import kd.fi.calx.algox.constant.CostAdjustBilCreateTypeEnum;
import kd.fi.calx.algox.constant.CostPriceSourceTypeEnum;
import kd.fi.calx.algox.function.AccountTypeContext;
import kd.fi.calx.algox.groupbill.BillGroupRecord;
import kd.fi.calx.algox.helper.CostPriceSourceTypeHelper;
import kd.fi.calx.algox.report.RptStatus;

public class FIFOCalAT
extends AbstractAccountType {
    private static final long serialVersionUID = 4901795370639651198L;
    private static Log logger = LogFactory.getLog(FIFOCalAT.class);
    private List<BalInfo> balList = new ArrayList<BalInfo>(16);
    private Set<Long> idSet = new HashSet<Long>(16);
    private List<Long> sortIdList = new ArrayList<Long>(16);
    private List<Long> destIdList = new ArrayList<Long>(16);
    private Map<Long, LocalRow> rowMap = new HashMap<Long, LocalRow>(16);
    private boolean hasPriceFailed = false;
    protected Map<String, Object[]> updateBalMap = new HashMap<String, Object[]>(16);
    protected Map<Long, Long> updateBalRptMap = new HashMap<Long, Long>(16);
    protected Set<DynamicObject> insertBalSet = new HashSet<DynamicObject>(16);
    private BigDecimal groupBaseQty = BigDecimal.ZERO;
    private Map<Long, BigDecimal> groupCostMap = new HashMap<Long, BigDecimal>(16);
    private BigDecimal gmaterialcost = BigDecimal.ZERO;
    private BigDecimal gfee = BigDecimal.ZERO;
    private BigDecimal gprocesscost = BigDecimal.ZERO;
    private BigDecimal gmanufacturecost = BigDecimal.ZERO;
    private BigDecimal gresource = BigDecimal.ZERO;
    private LocalRow gRow = null;
    private Map<String, List<Long>> groupMap = new HashMap<String, List<Long>>(32);
    private BigDecimal endSumQty = BigDecimal.ZERO;
    private BigDecimal endSumCost = BigDecimal.ZERO;
    protected Map<Long, List<InOutRelationInfo>> addNewRelationMap = new HashMap<Long, List<InOutRelationInfo>>(32);
    protected Map<Long, InOutRelationInfo> inRelationMap = new HashMap<Long, InOutRelationInfo>(32);
    protected Map<Long, List<InOutRelationInfo>> addEntryRelationMap = new HashMap<Long, List<InOutRelationInfo>>(32);
    protected Map<Long, InOutRelationInfo> outRelationMap = new HashMap<Long, InOutRelationInfo>(32);
    private Map<Long, List<Long>> inOutCostAdjustMap = new HashMap<Long, List<Long>>(16);
    private boolean inBillAllAmtZero = true;
    private boolean inBillAllQtyZero = true;
    private int zeroCostMark = 2;
    private int presentMark = 1;
    private boolean allBeginAmtZero = true;
    private boolean allBeginQtyZero = true;
    private boolean isFirstBill = true;
    private boolean priceResultSuccess = false;
    private String priceResultNo;

    public FIFOCalAT(AccountTypeContext ctx, DataSet dataSet, int runningMode) {
        super(ctx, dataSet, runningMode);
    }

    @Override
    protected void beforeCalculated() {
        super.beforeCalculated();
        DataSet data = this.dataSet.copy().filter("rowtype in ('1','2')");
        data = data.orderBy(this.buildOrderByField());
        for (Row row : data) {
            this.idSet.add(row.getLong("entryid"));
            Long inCostAdjustEntryId = row.getLong("incostadjustentryid");
            if (!"2".equals(row.getString("rowtype")) || inCostAdjustEntryId == null || inCostAdjustEntryId == 0L) continue;
            List<Long> outList = this.inOutCostAdjustMap.get(row.getLong("incostadjustentryid"));
            if (outList == null) {
                outList = new ArrayList<Long>(16);
                this.inOutCostAdjustMap.put(row.getLong("incostadjustentryid"), outList);
            }
            outList.add(row.getLong("entryid"));
        }
    }

    @Override
    protected void calculateOut(LocalRow row) {
        Long id = row.getEntryId();
        this.rowMap.put(id, row);
        Map<Long, BillGroupRecord> destMap = this.ctx.getGroupBillHolder().getDestRowRecordMap();
        Map<Long, List<BillGroupRecord>> srcMap = this.ctx.getGroupBillHolder().getSrcRowRecordMap();
        if (row.isDestBill()) {
            BillGroupRecord groupRecord = destMap.get(id);
            Set<Long> srcIds = groupRecord.getSrcEntryIds();
            boolean groupIn = false;
            for (Long srcId : srcIds) {
                if (!this.idSet.contains(srcId)) continue;
                groupIn = true;
                break;
            }
            if (groupIn) {
                this.destIdList.add(id);
            } else {
                this.sortIdList.add(id);
            }
        }
        if (row.isSrcBill() && !row.isDestBill() && !this.sortIdList.contains(id)) {
            List<BillGroupRecord> groupRecords = srcMap.get(id);
            if (groupRecords.isEmpty()) {
                this.sortIdList.add(id);
            } else {
                BillGroupRecord groupRecord = srcMap.get(id).get(0);
                Set<Long> srcIds = groupRecord.getSrcEntryIds();
                int maxIndex = -1;
                for (Long srcId : srcIds) {
                    if (srcId.longValue() == id.longValue() || this.sortIdList.indexOf(srcId) <= maxIndex) continue;
                    maxIndex = this.sortIdList.indexOf(srcId);
                }
                if (maxIndex >= 0) {
                    this.sortIdList.add(maxIndex + 1, id);
                } else {
                    this.sortIdList.add(id);
                }
            }
        }
        if (!row.isDestBill() && !row.isSrcBill()) {
            this.sortIdList.add(id);
        }
    }

    @Override
    protected void afterCalculated() {
        super.afterCalculated();
        Map<Long, List<BillGroupRecord>> srcMap = this.ctx.getGroupBillHolder().getSrcRowRecordMap();
        Map<Long, BillGroupRecord> destMap = this.ctx.getGroupBillHolder().getDestRowRecordMap();
        HashMap<Long, List<BillGroupRecord>> copySrcMap = new HashMap<Long, List<BillGroupRecord>>(16);
        for (Map.Entry<Long, List<BillGroupRecord>> longListEntry : srcMap.entrySet()) {
            copySrcMap.put(longListEntry.getKey(), new ArrayList(longListEntry.getValue()));
        }
        HashMap<Long, BillGroupRecord> finalDestMap = new HashMap<Long, BillGroupRecord>(destMap);
        this.removeNoInGroupRecord(copySrcMap, finalDestMap);
        Map<Long, BillGroupRecord> finalSrcMap = this.filterSrcMap(copySrcMap);
        this.filterAllMap(finalSrcMap, finalDestMap);
        for (Long destId : this.destIdList) {
            BillGroupRecord groupRecord = (BillGroupRecord)finalDestMap.get(destId);
            if (groupRecord == null) {
                if (this.sortIdList.contains(destId)) continue;
                this.sortIdList.add(destId);
                continue;
            }
            Set<Long> srcIds = groupRecord.getSrcEntryIds();
            Set<Long> destIds = groupRecord.getDestEntryIds();
            int maxIndex = -1;
            for (Long srcId : srcIds) {
                if (this.sortIdList.indexOf(srcId) <= maxIndex) continue;
                maxIndex = this.sortIdList.indexOf(srcId);
            }
            for (Long id : destIds) {
                if (!finalDestMap.containsKey(id) || this.sortIdList.indexOf(id) <= maxIndex) continue;
                maxIndex = this.sortIdList.indexOf(id);
            }
            if (maxIndex >= 0) {
                this.sortIdList.add(maxIndex + 1, destId);
                continue;
            }
            this.sortIdList.add(destId);
        }
        this.buildGroupMap(finalSrcMap, finalDestMap);
        this.sort4PreCostAdjust();
        for (int i = 0; i < this.sortIdList.size(); ++i) {
            Long id = this.sortIdList.get(i);
            LocalRow row = this.rowMap.get(id);
            String queueType = row.getQueuetype();
            if ("2".equals(row.getRowtype())) {
                this.joinCalculate(row, null, false, null);
            } else {
                int index;
                String groupId;
                List<Long> groupList;
                BillGroupRecord groupRecord;
                boolean isGroup = false;
                if (row.isSrcBill() && (groupRecord = finalSrcMap.get(id)) != null && (groupList = this.groupMap.get(groupId = groupRecord.getId())) != null) {
                    isGroup = true;
                    index = groupList.indexOf(id);
                    if (index == 0) {
                        this.gRow = row.copy();
                    }
                    row.setDestBill(false);
                    if ("0".equals(queueType)) {
                        this.calculate4In(row, true);
                    } else {
                        this.calculate4Out(row, true);
                    }
                    this.sumGroupData(row);
                }
                if (row.isDestBill() && (groupRecord = (BillGroupRecord)finalDestMap.get(id)) != null && (groupList = this.groupMap.get(groupId = groupRecord.getId())) != null) {
                    isGroup = true;
                    index = groupList.indexOf(id);
                    row.setSrcBill(false);
                    if ("0".equals(queueType)) {
                        this.calculate4In(row, true);
                    } else {
                        this.calculate4Out(row, true);
                    }
                    this.sumGroupData(row);
                    if (index == groupList.size() - 1 && this.gRow != null) {
                        this.calculate4Group();
                        this.clearGroupData();
                    }
                }
                if (!isGroup) {
                    if ("0".equals(queueType)) {
                        this.calculate4In(row, false);
                    } else {
                        this.calculate4Out(row, false);
                    }
                }
            }
            this.isFirstBill = false;
        }
    }

    private void sort4PreCostAdjust() {
        for (int i = 0; i < this.sortIdList.size(); ++i) {
            Long entryId = this.sortIdList.get(i);
            List<Long> preOutCostAdjustEntryIds = this.inOutCostAdjustMap.get(entryId);
            if (preOutCostAdjustEntryIds == null || preOutCostAdjustEntryIds.isEmpty()) continue;
            int k = 0;
            for (Long preOutCostAdjustEntryId : preOutCostAdjustEntryIds) {
                if (preOutCostAdjustEntryId == null || preOutCostAdjustEntryId == 0L) continue;
                int z = i + k;
                int preIndex = this.sortIdList.indexOf(preOutCostAdjustEntryId);
                if (preIndex < 0 || preIndex == z) continue;
                if (preIndex > z) {
                    Long tempId = 0L;
                    for (int j = preIndex; j > z + 1; --j) {
                        tempId = this.sortIdList.get(j);
                        this.sortIdList.set(j, this.sortIdList.get(j - 1));
                        this.sortIdList.set(j - 1, tempId);
                    }
                }
                ++k;
            }
        }
    }

    private Map<Long, BillGroupRecord> filterSrcMap(Map<Long, List<BillGroupRecord>> srcMap) {
        HashMap<Long, BillGroupRecord> resultSrcMap = new HashMap<Long, BillGroupRecord>(srcMap.size());
        for (Map.Entry<Long, List<BillGroupRecord>> e : srcMap.entrySet()) {
            Long entryId = e.getKey();
            List<BillGroupRecord> recordList = e.getValue();
            if (recordList.size() == 1) {
                resultSrcMap.put(entryId, recordList.get(0));
                continue;
            }
            if (recordList.size() <= 1) continue;
            boolean hasValidGroupRecord = false;
            for (BillGroupRecord groupRecord : recordList) {
                if (!this.isSameBizBillGroupRecord(groupRecord)) continue;
                resultSrcMap.put(entryId, groupRecord);
                hasValidGroupRecord = true;
                break;
            }
            if (hasValidGroupRecord) continue;
            resultSrcMap.put(entryId, recordList.get(0));
        }
        return resultSrcMap;
    }

    private void filterAllMap(Map<Long, BillGroupRecord> finalSrcMap, Map<Long, BillGroupRecord> finalDestMap) {
        Set<Long> srcSet = finalSrcMap.keySet();
        Set<Long> destSet = finalDestMap.keySet();
        HashSet<Long> retainSet = new HashSet<Long>(srcSet);
        retainSet.retainAll(destSet);
        if (retainSet.isEmpty()) {
            return;
        }
        for (Long id : retainSet) {
            BillGroupRecord srcRecord = finalSrcMap.get(id);
            BillGroupRecord destRecord = finalDestMap.get(id);
            if (this.isSameBizBillGroupRecord(srcRecord)) {
                finalDestMap.remove(id);
                continue;
            }
            if (this.isSameBizBillGroupRecord(destRecord)) {
                finalSrcMap.remove(id);
                continue;
            }
            finalSrcMap.remove(id);
            finalDestMap.remove(id);
        }
    }

    private boolean isGroupIn(BillGroupRecord groupRecord) {
        Set<Long> srcIds = groupRecord.getSrcEntryIds();
        Set<Long> destIds = groupRecord.getDestEntryIds();
        boolean srcContains = false;
        boolean destContains = false;
        for (Long id : srcIds) {
            if (!this.idSet.contains(id)) continue;
            srcContains = true;
            break;
        }
        for (Long id : destIds) {
            if (!this.idSet.contains(id)) continue;
            destContains = true;
            break;
        }
        return srcContains && destContains;
    }

    private boolean isSameBizBillGroupRecord(BillGroupRecord groupRecord) {
        Set<Long> srcIds = groupRecord.getSrcEntryIds();
        Set<Long> destIds = groupRecord.getDestEntryIds();
        if (srcIds.size() != 1 || destIds.size() != 1) {
            return false;
        }
        Long srcId = srcIds.iterator().next();
        Long destId = destIds.iterator().next();
        if (!this.idSet.contains(srcId) || !this.idSet.contains(destId)) {
            return false;
        }
        LocalRow srcRow = this.rowMap.get(srcId);
        LocalRow destRow = this.rowMap.get(destId);
        return srcRow.getBizbillentryid().longValue() == destRow.getBizbillentryid().longValue();
    }

    private void removeNoInGroupRecord(Map<Long, List<BillGroupRecord>> copySrcMap, Map<Long, BillGroupRecord> finalDestMap) {
        HashSet<Long> removeSet = new HashSet<Long>(8);
        for (Map.Entry<Long, List<BillGroupRecord>> entry : copySrcMap.entrySet()) {
            List<BillGroupRecord> recordList = entry.getValue();
            Iterator<BillGroupRecord> it = recordList.iterator();
            while (it.hasNext()) {
                BillGroupRecord record = it.next();
                if (this.isGroupIn(record)) continue;
                it.remove();
            }
            if (!recordList.isEmpty()) continue;
            removeSet.add(entry.getKey());
        }
        for (Long l : removeSet) {
            copySrcMap.remove(l);
        }
        removeSet.clear();
        for (Map.Entry<Long, Object> entry : finalDestMap.entrySet()) {
            Long id = entry.getKey();
            BillGroupRecord groupRecord = (BillGroupRecord)entry.getValue();
            if (this.isGroupIn(groupRecord)) continue;
            removeSet.add(id);
        }
        for (Long l : removeSet) {
            finalDestMap.remove(l);
        }
    }

    private void buildGroupMap(Map<Long, BillGroupRecord> finalSrcMap, Map<Long, BillGroupRecord> finalDestMap) {
        HashMap<String, Boolean> groupSrcMap = new HashMap<String, Boolean>(32);
        for (int i = 0; i < this.sortIdList.size(); ++i) {
            List<Long> groupList;
            String groupId;
            BillGroupRecord groupRecord;
            Long id = this.sortIdList.get(i);
            LocalRow row = this.rowMap.get(id);
            if (row.isSrcBill() && (groupRecord = finalSrcMap.get(id)) != null) {
                groupId = groupRecord.getId();
                groupList = this.groupMap.get(groupId);
                if (groupList == null) {
                    groupList = new ArrayList<Long>(16);
                    this.groupMap.put(groupId, groupList);
                }
                groupList.add(id);
                groupSrcMap.put(groupId, Boolean.FALSE);
            }
            if (!row.isDestBill() || (groupRecord = finalDestMap.get(id)) == null || (groupList = this.groupMap.get(groupId = groupRecord.getId())) == null) continue;
            groupList.add(id);
            groupSrcMap.put(groupId, Boolean.TRUE);
        }
        Iterator<Map.Entry<String, List<Long>>> it = this.groupMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, List<Long>> entry = it.next();
            if (entry.getValue().size() > 1 && ((Boolean)groupSrcMap.get(entry.getKey())).booleanValue()) continue;
            it.remove();
        }
    }

    private void calculate4Out(LocalRow row, boolean isGroupBill) {
        HashMap<Long, BigDecimal> unitCostAmtMap = new HashMap<Long, BigDecimal>(16);
        BigDecimal baseQty = row.getBaseqty();
        for (long subElementId : row.getUnitCostAmt().keySet()) {
            Object unitCost = row.getUnitCostAmt().get(subElementId);
            unitCost = unitCost == null ? BigDecimal.ZERO : unitCost;
            unitCostAmtMap.put(subElementId, (BigDecimal)unitCost);
        }
        if (row.isDestBill()) {
            if (!row.isGroupCostCalculated().booleanValue()) {
                row = this.getGroupedRow(row.getEntryId());
            }
            if (row.isGroupCostCalculated().booleanValue()) {
                Long entryid = row.getEntryId();
                this.tempInGroupRow = this.tempInGroupRow.stream().filter(tempRow -> tempRow.getEntryId().compareTo(entryid) != 0).collect(Collectors.toList());
                if (!row.isCostDetermined()) {
                    CostPriceSourceTypeHelper.setCostpriceSourceByGroup(row, this.ctx.enableCoverdesigoutcost());
                }
                this.joinCalculate(row, null, isGroupBill, null);
                if (row.isCostDetermined()) {
                    CostAdjustInfo costAdjustInfo = this.addGroupBillCostAdjustInfo(row);
                    if (costAdjustInfo != null) {
                        LocalRow costAdjustRow = this.costAdjustToLocalRow(costAdjustInfo, row);
                        this.joinCalculate(costAdjustRow, null, isGroupBill, costAdjustInfo);
                        if (isGroupBill) {
                            for (Long elementId : this.getElementMap().keySet()) {
                                row.setCost(elementId, row.getCost(elementId).add(costAdjustInfo.getAdjustCost(elementId)));
                            }
                            row.refreshDirectActualCostByElement();
                        }
                    }
                } else {
                    this.addCostUpdateInfo(row);
                }
            } else {
                this.tempInGroupRow.add(row);
            }
        } else {
            if (!row.isCostDetermined()) {
                BigDecimal sumQty = BigDecimal.ZERO;
                for (BalInfo balInfo : this.balList) {
                    sumQty = sumQty.add(balInfo.getQty());
                }
                this.fetchFIFOPrice(row);
                row.refreshDirectActualCostByElement();
                if (row.getUnitActualCost().signum() == 0 && this.ctx.enableZeroPrice() && sumQty.compareTo(BigDecimal.ZERO) == 0 && !row.isInvTxZeroCost() && (!this.isBeginAmtAllZero() || !this.isInBillAllAmtZero() || this.allBeginAmtZero && this.allBeginQtyZero)) {
                    int index = this.holder.createNewEntry();
                    CostPriceResultInfo priceInfo = this.getCostPrice(row.getHeadid(), row.getEntryId(), row.getRowtype(), "E");
                    this.holder.setBillType(index, ResManager.loadKDString((String)"\u96f6\u5355\u4ef7\u53d6\u4ef7\u7ed3\u679c", (String)"WeightedAvgAT_5", (String)"fi-calx-algox", (Object[])new Object[0]));
                    if (priceInfo != null && priceInfo.isSuccess()) {
                        if (StringUtils.isEmpty((String)row.getSrcbillno())) {
                            row.setCostpriceSourceType(CostPriceSourceTypeEnum.GET_COST_SPECIFICATION.getValue());
                            row.setSrcbillno(priceInfo.getSrcPriceName() + priceInfo.getSrcBillno());
                        }
                        boolean designatedcost = row.isDesignatedcost();
                        boolean coverdesigoutcost = this.ctx.enableCoverdesigoutcost();
                        if (!designatedcost || designatedcost && coverdesigoutcost) {
                            this.priceResultSuccess = true;
                            this.priceResultNo = priceInfo.getSrcPriceName() + priceInfo.getSrcBillno();
                            if (StringUtils.isEmpty((String)row.getSrcbillno())) {
                                row.setCostpriceSourceType(CostPriceSourceTypeEnum.GET_COST_SPECIFICATION.getValue());
                                row.setSrcbillno(priceInfo.getSrcPriceName() + priceInfo.getSrcBillno());
                                this.priceResultNo = row.getSrcbillno();
                            }
                        }
                        StringBuilder sb = new StringBuilder();
                        BigDecimal priceTotalUnitCost = BigDecimal.ZERO;
                        for (Map.Entry<Long, BigDecimal> priceEntry : priceInfo.getCostSubElementUnitcostMap().entrySet()) {
                            Long priceElementId = priceEntry.getKey();
                            BigDecimal priceUnitCost = priceEntry.getValue();
                            priceTotalUnitCost = priceTotalUnitCost.add(priceUnitCost);
                            int subIndex = this.holder.createNewSubEntry(index, this.getElementMap().get(priceElementId).getName());
                            this.holder.setInFormula(subIndex, priceInfo.getSrcPriceName() + ":" + this.toBigDecimalString(priceUnitCost.setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
                        }
                        sb.append(priceInfo.getSrcPriceName());
                        sb.append(':');
                        sb.append(this.toBigDecimalString(priceTotalUnitCost.setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
                        this.holder.setInFormula(index, sb.toString());
                        Iterator<Object> iterator = this.getElementMap().keySet().iterator();
                        while (iterator.hasNext()) {
                            long subElementId = (Long)iterator.next();
                            BigDecimal unitCost = priceInfo.getCostSubElementUnitcostMap().get(subElementId);
                            unitCost = unitCost == null ? BigDecimal.ZERO : unitCost;
                            row.setDirectUnitCost(subElementId, unitCost);
                            row.setDirectCost(subElementId, unitCost.multiply(row.getBaseqty()).setScale(row.getAmtprecision(), RoundingMode.HALF_UP));
                        }
                        row.refreshDirectActualCostByElement();
                    } else {
                        for (long subElementId : this.getElementMap().keySet()) {
                            BigDecimal unitCost = (BigDecimal)unitCostAmtMap.get(subElementId);
                            unitCost = unitCost == null ? BigDecimal.ZERO : unitCost;
                            row.setDirectUnitCost(subElementId, unitCost);
                            row.setDirectCost(subElementId, unitCost.multiply(baseQty).setScale(row.getAmtprecision(), RoundingMode.HALF_UP));
                        }
                        row.refreshDirectActualCostByElement();
                        this.hasPriceFailed = true;
                        if (priceInfo != null) {
                            this.holder.setInFormula(index, priceInfo.getErrMsg());
                        }
                    }
                }
                this.addCostUpdateInfo(row);
                if (row.isSrcBill()) {
                    row.setGroupCostCalculated(true);
                }
            }
            if (row.isCostDetermined() && 2 == this.getRunningMode() && !isGroupBill) {
                row.setCostpriceSourceType(CostPriceSourceTypeEnum.getLastByCostPriceSource(row.getCostpricesource()));
            }
            this.joinCalculate(row, null, isGroupBill, null);
        }
    }

    private void calculate4In(LocalRow row, boolean isGroupBill) {
        if (row.isDestBill()) {
            if (!row.isGroupCostCalculated().booleanValue()) {
                row = this.getGroupedRow(row.getEntryId());
                this.loopInBillGetPrice(row);
            }
            if (row.isGroupCostCalculated().booleanValue()) {
                if (!row.isCostDetermined()) {
                    CostPriceSourceTypeHelper.setCostpriceSourceByGroup(row, this.ctx.enableCoverdesigoutcost());
                }
                Long entryid = row.getEntryId();
                this.tempInGroupRow = this.tempInGroupRow.stream().filter(tempRow -> tempRow.getEntryId().compareTo(entryid) != 0).collect(Collectors.toList());
                this.joinCalculate(row, null, isGroupBill, null);
                if (row.isCostDetermined()) {
                    CostAdjustInfo costAdjustInfo = this.addGroupBillCostAdjustInfo(row);
                    if (costAdjustInfo != null) {
                        LocalRow costAdjustRow = this.costAdjustToLocalRow(costAdjustInfo, row);
                        this.joinCalculate(costAdjustRow, null, isGroupBill, costAdjustInfo);
                        if (isGroupBill) {
                            for (Long elementId : this.getElementMap().keySet()) {
                                row.setCost(elementId, row.getCost(elementId).add(costAdjustInfo.getAdjustCost(elementId)));
                            }
                            row.refreshDirectActualCostByElement();
                        }
                    }
                } else {
                    this.addCostUpdateInfo(row);
                }
            } else if (!isGroupBill) {
                CostPriceResultInfo priceResult;
                if (row.isPriced() && (priceResult = row.getPriceResult()).isSuccess()) {
                    this.addCostUpdateInfo(row);
                    row.setCostpriceSourceType(CostPriceSourceTypeEnum.GET_COST_SPECIFICATION.getValue());
                    this.joinCalculate(row, null, false, null);
                }
                this.tempInGroupRow.add(row);
            }
        } else {
            this.joinCalculate(row, null, isGroupBill, null);
        }
        if (!row.isCostDetermined()) {
            if (row.isDestBill() && row.isGroupCostCalculated().booleanValue() || row.isPriced() && row.getPriceResult().isSuccess()) {
                this.addCostUpdateInfo(row);
            } else if (this instanceof FIFOPeriodCalAT && !this.tempInGroupRow.contains(row)) {
                row.setIscalculated(true);
                this.addCostUpdateInfo(row);
            }
        }
    }

    private void calculate4Group() {
        BigDecimal firstGroupSign = BigDecimal.ONE;
        if ("1".equals(this.gRow.getQueuetype())) {
            firstGroupSign = firstGroupSign.negate();
        }
        this.gRow.setBaseqty(this.groupBaseQty.multiply(firstGroupSign));
        this.gRow.setMaterialcost(this.gmaterialcost.multiply(firstGroupSign));
        this.gRow.setFee(this.gfee.multiply(firstGroupSign));
        this.gRow.setProcesscost(this.gprocesscost.multiply(firstGroupSign));
        this.gRow.setManufacturecost(this.gmanufacturecost.multiply(firstGroupSign));
        this.gRow.setResource(this.gresource.multiply(firstGroupSign));
        for (Long elementId : this.getElementMap().keySet()) {
            this.gRow.setCost(elementId, this.groupCostMap.get(elementId).multiply(firstGroupSign));
        }
        this.gRow.refreshActualCost();
        if (this.gRow.getBaseqty().signum() != 0 || this.gRow.getActualCost().signum() != 0) {
            String groupQueueType = this.gRow.getQueuetype();
            int groupSign = this.gRow.getBaseqty().signum();
            if ("0".equals(groupQueueType) && groupSign > 0 || "1".equals(groupQueueType) && groupSign < 0) {
                this.addBalList(this.gRow);
            } else if ("0".equals(groupQueueType) && groupSign < 0 || "1".equals(groupQueueType) && groupSign > 0) {
                if (this.balList.isEmpty()) {
                    this.addBalList(this.gRow);
                } else {
                    this.mergeBalList(this.gRow);
                }
            }
        }
        int reportIndex = this.holder.createNewEntry(this.gRow);
        String billType = ResManager.loadKDString((String)"\u6210\u7ec4\u5355\u636e\u5408\u8ba1", (String)"FIFOCalAT_0", (String)"fi-calx-algox", (Object[])new Object[0]);
        this.holder.setBillType(reportIndex, billType);
        StringBuilder formula = new StringBuilder();
        formula.append(this.toBigDecimalString(this.gRow.getBaseqty().setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
        formula.append('*');
        formula.append(this.toBigDecimalString(this.gRow.getUnitActualCost().setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
        formula.append('=');
        formula.append(this.toBigDecimalString(this.gRow.getActualCost().stripTrailingZeros().setScale(this.gRow.getAmtprecision(), RoundingMode.HALF_UP)));
        if ("0".equals(this.gRow.getQueuetype())) {
            this.holder.setInFormula(reportIndex, formula.toString());
        } else {
            this.holder.setOutFormula(reportIndex, formula.toString());
        }
        int maxRow = 5;
        int i = 0;
        formula.setLength(0);
        for (BalInfo balInfo : this.balList) {
            if (i >= maxRow) {
                formula.append("...");
                formula.append('\n');
                break;
            }
            BigDecimal balQty = balInfo.getQty();
            BigDecimal balCost = balInfo.getAllCost();
            BigDecimal balUnitCost = balInfo.getAllUnitCost();
            formula.append(this.toBigDecimalString(balQty.setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
            formula.append('*');
            formula.append(this.toBigDecimalString(balUnitCost.stripTrailingZeros().setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
            formula.append('=');
            formula.append(this.toBigDecimalString(balCost.stripTrailingZeros().setScale(this.gRow.getAmtprecision(), RoundingMode.HALF_UP)));
            formula.append('\n');
            ++i;
        }
        BigDecimal sumQty = BigDecimal.ZERO;
        BigDecimal sumCost = BigDecimal.ZERO;
        for (BalInfo balInfo : this.balList) {
            BigDecimal balQty = balInfo.getQty();
            BigDecimal balCost = balInfo.getAllCost();
            sumQty = sumQty.add(balQty);
            sumCost = sumCost.add(balCost);
        }
        BigDecimal sumUnitCost = sumQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(this.getPricePrecision(), RoundingMode.HALF_UP) : sumCost.divide(sumQty, this.getPricePrecision(), RoundingMode.HALF_UP);
        this.appendEndMsg(formula, sumQty, sumUnitCost, sumCost);
        this.holder.setBalanceFormula(reportIndex, formula.toString());
        Map<Long, CostSubElement> elementMap = this.getElementMap();
        for (Map.Entry<Long, CostSubElement> entry : elementMap.entrySet()) {
            Long elementId = entry.getKey();
            BigDecimal elementCost = this.gRow.getCost(elementId);
            if (elementCost.compareTo(BigDecimal.ZERO) == 0 && this.isBalanceZero(elementId)) continue;
            int subIndex = this.holder.createNewSubEntry(reportIndex, entry.getValue().getName());
            formula.setLength(0);
            formula.append(this.toBigDecimalString(elementCost.stripTrailingZeros().setScale(this.gRow.getAmtprecision(), RoundingMode.HALF_UP)));
            if ("0".equals(this.gRow.getQueuetype())) {
                this.holder.setInFormula(subIndex, formula.toString());
            } else {
                this.holder.setOutFormula(subIndex, formula.toString());
            }
            i = 0;
            formula.setLength(0);
            for (BalInfo balInfo : this.balList) {
                if (i >= maxRow) {
                    formula.append("...");
                    formula.append('\n');
                    break;
                }
                BigDecimal elementBalCost = balInfo.getCostMap().get(elementId);
                BigDecimal elementBalUnitCost = balInfo.getUnitCostMap().get(elementId);
                formula.append(this.toBigDecimalString(balInfo.getQty().setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
                formula.append('*');
                formula.append(this.toBigDecimalString(elementBalUnitCost.setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
                formula.append('=');
                formula.append(this.toBigDecimalString(elementBalCost.stripTrailingZeros().setScale(this.gRow.getAmtprecision(), RoundingMode.HALF_UP)));
                formula.append('\n');
                ++i;
            }
            sumQty = BigDecimal.ZERO;
            sumCost = BigDecimal.ZERO;
            for (BalInfo balInfo : this.balList) {
                BigDecimal balQty = balInfo.getQty();
                BigDecimal elementBalCost = balInfo.getCostMap().get(elementId);
                sumQty = sumQty.add(balQty);
                sumCost = sumCost.add(elementBalCost);
            }
            sumUnitCost = sumQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(this.getPricePrecision(), RoundingMode.HALF_UP) : sumCost.divide(sumQty, this.getPricePrecision(), RoundingMode.HALF_UP);
            this.appendEndMsg(formula, sumQty, sumUnitCost, sumCost);
            this.holder.setBalanceFormula(subIndex, formula.toString());
        }
        this.dealSpCondition(this.gRow);
    }

    private void sumGroupData(LocalRow row) {
        if (row.isDestBill() && !row.isGroupCostCalculated().booleanValue()) {
            return;
        }
        BigDecimal sign = BigDecimal.ONE;
        if ("1".equals(row.getQueuetype())) {
            sign = new BigDecimal("-1");
        }
        this.groupBaseQty = this.groupBaseQty.add(row.getBaseqty().multiply(sign));
        BigDecimal materialcost = row.getMaterialcost().multiply(sign);
        BigDecimal fee = row.getFee().multiply(sign);
        BigDecimal processcost = row.getProcesscost().multiply(sign);
        BigDecimal manufacturecost = row.getManufacturecost().multiply(sign);
        BigDecimal resource = row.getResource().multiply(sign);
        this.gmaterialcost = this.gmaterialcost.add(materialcost);
        this.gfee = this.gfee.add(fee);
        this.gprocesscost = this.gprocesscost.add(processcost);
        this.gmanufacturecost = this.gmanufacturecost.add(manufacturecost);
        this.gresource = this.gresource.add(resource);
        Map<Long, BigDecimal> costMap = row.getElementCostMap();
        for (Map.Entry<Long, BigDecimal> entry : costMap.entrySet()) {
            Long subElementId = entry.getKey();
            BigDecimal cost = entry.getValue();
            BigDecimal groupCost = this.groupCostMap.get(subElementId);
            groupCost = groupCost == null ? cost.multiply(sign) : groupCost.add(cost.multiply(sign));
            this.groupCostMap.put(subElementId, groupCost);
        }
    }

    private void clearGroupData() {
        this.groupBaseQty = BigDecimal.ZERO;
        this.groupCostMap.clear();
        this.gmaterialcost = BigDecimal.ZERO;
        this.gfee = BigDecimal.ZERO;
        this.gprocesscost = BigDecimal.ZERO;
        this.gmanufacturecost = BigDecimal.ZERO;
        this.gresource = BigDecimal.ZERO;
        this.gRow = null;
    }

    private LocalRow costAdjustToLocalRow(CostAdjustInfo costAdjustInfo, LocalRow row) {
        LocalRow localRow = new LocalRow(row.isCalbycostelement(), this.getElementMap());
        localRow.setHeadid(costAdjustInfo.getCostAdjustId());
        localRow.setEntyrId(costAdjustInfo.getCostAdjustEntryId());
        localRow.setLocalcurrencyid(row.getLocalcurrencyid());
        localRow.setPriceprecision(10);
        localRow.setAmtprecision(row.getAmtprecision());
        localRow.setQtyPrecision(row.getQtyPrecision());
        localRow.setRowtype("2");
        localRow.setSign(BigDecimal.valueOf(costAdjustInfo.getAdjustAmt().signum()));
        String queueType = "0";
        if ("B".equals(costAdjustInfo.getCallBillType())) {
            queueType = "1";
        }
        localRow.setQueuetype(queueType);
        localRow.setCalbilltype(costAdjustInfo.getCallBillType());
        localRow.setBizbillid(costAdjustInfo.getCostAdjustId());
        localRow.setBizbillentryid(costAdjustInfo.getCostAdjustEntryId());
        localRow.setBilltypenum("cal_costadjustbill");
        localRow.setBilltype(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355", (String)"DataInputFactory_1", (String)"fi-calx-algox", (Object[])new Object[0]));
        localRow.setBillnumber(costAdjustInfo.getBillNo());
        localRow.setBizDate(costAdjustInfo.getBizDate());
        localRow.setAuditTime(costAdjustInfo.getAuditDate());
        localRow.setPeriodid(row.getPeriodid());
        BigDecimal signnum = BigDecimal.ONE;
        localRow.setSignnum(signnum);
        localRow.setBaseqty(BigDecimal.ZERO);
        localRow.setBaseUnitId(row.getBaseUnitId());
        localRow.setCostRecordEntryid(row.getEntryId());
        localRow.setEntrySeq(1);
        localRow.setCostDetermined(false);
        for (Long elementId : this.getElementMap().keySet()) {
            localRow.setCost(elementId, costAdjustInfo.getAdjustCost(elementId).multiply(signnum));
        }
        localRow.setCreatetype(costAdjustInfo.getCreateType());
        localRow.refreshActualCost();
        return localRow;
    }

    /*
     * WARNING - void declaration
     */
    private void joinCalculate(LocalRow row, String exDescription, boolean isGroupBill, CostAdjustInfo costAdjustInfo) {
        boolean bl;
        String createtype;
        CostPriceResultInfo priceInfo;
        String queueType = row.getQueuetype();
        if (!isGroupBill) {
            if (row.getRowtype().equals("2")) {
                Long costRecordEntryId = 0L;
                Long inCostAdjustEntryId = row.getInCostAdjustEntryId();
                LocalRow inCostAdjustRow = this.rowMap.get(inCostAdjustEntryId);
                if (inCostAdjustRow != null) {
                    costRecordEntryId = inCostAdjustRow.getCostRecordEntryid();
                }
                if (costRecordEntryId == 0L) {
                    costRecordEntryId = row.getCostRecordEntryid();
                }
                if (costRecordEntryId != 0L && !this.balList.isEmpty()) {
                    List<BalInfo> newBalList = this.createSortList4CostAdjust(costRecordEntryId);
                    this.mergeBalList(row, newBalList);
                } else if (this.balList.isEmpty()) {
                    this.addBalList(row);
                } else if ("0".equals(queueType)) {
                    BalInfo lastBalInfo = this.balList.get(this.balList.size() - 1);
                    ArrayList<BalInfo> newBalList = new ArrayList<BalInfo>(6);
                    newBalList.add(lastBalInfo);
                    this.mergeBalList(row, newBalList);
                } else {
                    this.mergeBalList(row);
                }
            } else {
                BigDecimal baseQty = row.getBaseqty();
                if ("0".equals(queueType) && baseQty.signum() > 0 || "1".equals(queueType) && baseQty.signum() < 0) {
                    this.addBalList(row);
                } else if ("0".equals(queueType) && baseQty.signum() < 0 || "1".equals(queueType) && baseQty.signum() > 0) {
                    if (this.balList.isEmpty()) {
                        this.addBalList(row);
                    } else {
                        this.mergeBalList(row);
                    }
                }
            }
        }
        int index = this.holder.createNewEntry(row);
        String billtypestr = row.getBilltype();
        boolean vouStr = false;
        String srcBillNo = null;
        boolean isGroupCost = false;
        if ("1".equals(row.getRowtype())) {
            Object msg;
            String costPriceSourceStr;
            boolean coverdesigoutcost = this.ctx.enableCoverdesigoutcost();
            if (StringUtils.isEmpty((String)exDescription) && (row.isGroupCostCalculated() == null || !row.isGroupCostCalculated().booleanValue()) && row.isPriced() && (priceInfo = row.getPriceResult()).isSuccess()) {
                row.setCostpriceSourceType(CostPriceSourceTypeEnum.GET_COST_SPECIFICATION.getValue());
            }
            CostPriceSourceTypeEnum.setDescribeByCostpricesource(row, coverdesigoutcost, this.holder, index, null);
            String costpricesource = row.getCostpricesource();
            String costpriceSourceType = row.getCostpriceSourceType();
            if (row.isVoucher()) {
                vouStr = true;
            }
            if (StringUtils.isNotEmpty((String)costpricesource) && StringUtils.isNotEmpty((String)(costPriceSourceStr = CostPriceSourceTypeEnum.getLastByCostPriceSource(costpricesource))) && CostPriceSourceTypeEnum.GROUP_COST_SPECIFICATION.getValue().equals(costPriceSourceStr) && row.isDestBill()) {
                srcBillNo = row.getSrcbillno();
                isGroupCost = true;
            }
            if (StringUtils.isNotEmpty((String)costpriceSourceType) && CostPriceSourceTypeEnum.GET_COST_SPECIFICATION.getValue().equals(costpriceSourceType)) {
                srcBillNo = row.getSrcbillno();
            }
            if (vouStr && srcBillNo != null) {
                msg = null;
                msg = isGroupCost ? String.format(ResManager.loadKDString((String)"%1$s(\u5df2\u751f\u6210\u51ed\u8bc1,\u6765\u6e90\u5355\u53f7\uff1a%2$s)", (String)"CalculateOutCostPlugin_32", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr, srcBillNo) : String.format(ResManager.loadKDString((String)"%1$s(\u5df2\u751f\u6210\u51ed\u8bc1,%2$s)", (String)"CalculateOutCostPlugin_35", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr, srcBillNo);
                billtypestr = msg;
            } else if (vouStr && srcBillNo == null) {
                msg = String.format(ResManager.loadKDString((String)"%1$s(\u5df2\u751f\u6210\u51ed\u8bc1)", (String)"CalculateOutCostPlugin_33", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr);
                billtypestr = msg;
            } else if (!vouStr && srcBillNo != null) {
                msg = null;
                msg = isGroupCost ? String.format(ResManager.loadKDString((String)"%1$s(\u6765\u6e90\u5355\u53f7\uff1a%2$s)", (String)"CalculateOutCostPlugin_34", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr, srcBillNo) : String.format(ResManager.loadKDString((String)"%1$s(%2$s)", (String)"CalculateOutCostPlugin_36", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr, srcBillNo);
                billtypestr = msg;
            }
            this.holder.setBillType(index, billtypestr);
        }
        if ("2".equals(row.getRowtype()) && StringUtils.isNotEmpty((String)(createtype = row.getCreatetype()))) {
            String msg;
            this.holder.setDescribe(index, CostAdjustBilCreateTypeEnum.getEnumDesc(createtype));
            String invbillnum = null;
            if (costAdjustInfo != null) {
                invbillnum = CostPriceSourceTypeEnum.getCostAdjuestInvbillNum(costAdjustInfo);
            }
            if (row.isVoucher()) {
                if (!StringUtils.isEmpty((String)invbillnum)) {
                    msg = String.format(ResManager.loadKDString((String)"%1$s(\u5df2\u751f\u6210\u51ed\u8bc1)(\u5bf9\u5e94\u5e93\u5b58\u5355\u636e\u53f7\uff1a%2$s)", (String)"CalculateOutCostPlugin_40", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr, invbillnum);
                    this.holder.setBillType(index, msg);
                } else {
                    msg = String.format(ResManager.loadKDString((String)"%1$s(\u5df2\u751f\u6210\u51ed\u8bc1)", (String)"CalculateOutCostPlugin_33", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr);
                    this.holder.setBillType(index, msg);
                }
            } else if (!StringUtils.isEmpty((String)invbillnum)) {
                msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355(\u5bf9\u5e94\u5e93\u5b58\u5355\u636e\u53f7\uff1a%1$s)", (String)"MoveAddAverageCalculate_14", (String)"fi-calx-algox", (Object[])new Object[0]), invbillnum);
                this.holder.setBillType(index, msg);
            }
        }
        if (exDescription != null) {
            this.holder.setBillType(index, billtypestr + exDescription);
        } else {
            String curBillType = "";
            if ((row.isGroupCostCalculated() == null || !row.isGroupCostCalculated().booleanValue()) && row.isPriced()) {
                priceInfo = row.getPriceResult();
                if (priceInfo.isSuccess()) {
                    curBillType = billtypestr + "(" + priceInfo.getSrcPriceName() + ")";
                    this.holder.setBillType(index, curBillType);
                } else {
                    this.holder.setBillType(index, billtypestr + "(" + priceInfo.getErrMsg() + ")");
                }
            }
            if (row.isPresent() && "0".equals(queueType)) {
                curBillType = String.format(ResManager.loadKDString((String)"%1$s(\u8d60\u54c1)", (String)"WeightedAvgAT_15", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr);
                this.holder.setBillType(index, curBillType);
            } else if (row.isInvTxZeroCost()) {
                curBillType = String.format(ResManager.loadKDString((String)"%1$s(\u96f6\u6210\u672c)", (String)"WeightedAvgAT_14", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr);
                this.holder.setBillType(index, curBillType);
            }
        }
        StringBuilder formula = new StringBuilder();
        formula.append(this.toBigDecimalString(row.getBaseqty().setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
        formula.append('*');
        formula.append(this.toBigDecimalString(row.getUnitActualCost().setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
        formula.append('=');
        formula.append(this.toBigDecimalString(row.getActualCost().stripTrailingZeros().setScale(row.getAmtprecision(), RoundingMode.HALF_UP)));
        if ("0".equals(row.getQueuetype())) {
            this.holder.setInFormula(index, formula.toString());
        } else {
            this.holder.setOutFormula(index, formula.toString());
        }
        int maxRow = 5;
        if (!isGroupBill) {
            void var15_27;
            formula.setLength(0);
            int i = 0;
            for (BalInfo balInfo : this.balList) {
                if (i >= maxRow) {
                    formula.append("...");
                    formula.append('\n');
                    break;
                }
                BigDecimal balQty = balInfo.getQty();
                BigDecimal balCost = balInfo.getAllCost();
                BigDecimal balUnitCost = balInfo.getAllUnitCost();
                formula.append(this.toBigDecimalString(balQty.setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
                formula.append('*');
                formula.append(this.toBigDecimalString(balUnitCost.stripTrailingZeros().setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
                formula.append('=');
                formula.append(this.toBigDecimalString(balCost.stripTrailingZeros().setScale(row.getAmtprecision(), RoundingMode.HALF_UP)));
                formula.append('\n');
                ++i;
            }
            Object sumQty = BigDecimal.ZERO;
            BigDecimal bigDecimal = BigDecimal.ZERO;
            for (BalInfo balInfo : this.balList) {
                BigDecimal balQty = balInfo.getQty();
                BigDecimal balCost = balInfo.getAllCost();
                sumQty = ((BigDecimal)sumQty).add(balQty);
                BigDecimal bigDecimal2 = var15_27.add(balCost);
            }
            BigDecimal sumUnitCost = ((BigDecimal)sumQty).compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(this.getPricePrecision(), RoundingMode.HALF_UP) : var15_27.divide((BigDecimal)sumQty, this.getPricePrecision(), RoundingMode.HALF_UP);
            this.appendEndMsg(formula, (BigDecimal)sumQty, sumUnitCost, (BigDecimal)var15_27);
            this.holder.setBalanceFormula(index, formula.toString());
        }
        if (!row.getRowtype().equals("2") && "1".equals(row.getQueuetype())) {
            if (row.getUnitActualCost().compareTo(BigDecimal.ZERO) == 0) {
                this.holder.appendBalanceFormula(index, ResManager.loadKDString((String)"\u8b66\u544a\uff1a\u51fa\u5e93\u96f6\u5355\u4ef7", (String)"FIFOCalAT_01", (String)"fi-calx-algox", (Object[])new Object[0]) + "\n");
                this.holder.setCalStatus(RptStatus.WARNING);
            } else if (row.getUnitActualCost().compareTo(BigDecimal.ZERO) < 0) {
                this.holder.appendBalanceFormula(index, ResManager.loadKDString((String)"\u9519\u8bef\uff1a\u51fa\u5e93\u8d1f\u5355\u4ef7", (String)"FIFOCalAT_1", (String)"fi-calx-algox", (Object[])new Object[0]) + "\n");
                this.holder.setCalStatus(RptStatus.ERROR);
            }
        }
        Map<Long, CostSubElement> elementMap = this.getElementMap();
        for (Map.Entry entry : elementMap.entrySet()) {
            Long elementId = (Long)entry.getKey();
            BigDecimal elementCost = row.getCost(elementId);
            if (elementCost.compareTo(BigDecimal.ZERO) == 0 && this.isBalanceZero(elementId)) continue;
            int subIndex = this.holder.createNewSubEntry(index, ((CostSubElement)entry.getValue()).getName());
            formula.setLength(0);
            formula.append(this.toBigDecimalString(elementCost.stripTrailingZeros().setScale(row.getAmtprecision(), RoundingMode.HALF_UP)));
            if ("0".equals(row.getQueuetype())) {
                this.holder.setInFormula(subIndex, formula.toString());
            } else {
                this.holder.setOutFormula(subIndex, formula.toString());
            }
            if (isGroupBill) continue;
            formula.setLength(0);
            int i = 0;
            for (BalInfo balInfo : this.balList) {
                if (i >= maxRow) {
                    formula.append("...");
                    formula.append('\n');
                    break;
                }
                BigDecimal elementBalCost = balInfo.getCostMap().get(elementId);
                BigDecimal elementBalUnitCost = balInfo.getUnitCostMap().get(elementId);
                formula.append(this.toBigDecimalString(balInfo.getQty().setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
                formula.append('*');
                formula.append(this.toBigDecimalString(elementBalUnitCost.setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
                formula.append('=');
                formula.append(this.toBigDecimalString(elementBalCost.stripTrailingZeros().setScale(row.getAmtprecision(), RoundingMode.HALF_UP)));
                formula.append('\n');
                ++i;
            }
            BigDecimal sumQty = BigDecimal.ZERO;
            BigDecimal sumCost = BigDecimal.ZERO;
            for (BalInfo balInfo : this.balList) {
                BigDecimal balQty = balInfo.getQty();
                BigDecimal elementBalCost = balInfo.getCostMap().get(elementId);
                sumQty = sumQty.add(balQty);
                sumCost = sumCost.add(elementBalCost);
            }
            BigDecimal sumUnitCost = sumQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(this.getPricePrecision(), RoundingMode.HALF_UP) : sumCost.divide(sumQty, this.getPricePrecision(), RoundingMode.HALF_UP);
            this.appendEndMsg(formula, sumQty, sumUnitCost, sumCost);
            this.holder.setBalanceFormula(subIndex, formula.toString());
        }
        boolean hasPreCostAdjust = row.getRowtype().equals("2") && this.inOutCostAdjustMap.containsKey(row.getEntryId());
        boolean bl2 = false;
        if (row.getRowtype().equals("2")) {
            for (List<Long> outList : this.inOutCostAdjustMap.values()) {
                int outIndex = outList.indexOf(row.getEntryId());
                if (outIndex <= -1) continue;
                if (outIndex == outList.size() - 1) break;
                bl = true;
                break;
            }
        }
        if (!(isGroupBill || hasPreCostAdjust || bl)) {
            this.dealSpCondition(row);
        }
    }

    private void joinCalculate(CostAdjustInfo adjustInfo) {
        BigDecimal cost;
        if (adjustInfo == null) {
            return;
        }
        BalInfo lastBalInfo = this.balList.get(this.balList.size() - 1);
        BigDecimal sign = BigDecimal.ONE;
        if ("B".equals(adjustInfo.getCallBillType())) {
            sign = new BigDecimal("-1");
        }
        for (Long elementId : this.getElementMap().keySet()) {
            BigDecimal adjustAmt = adjustInfo.getAdjustCost(elementId);
            cost = lastBalInfo.getCostMap().get(elementId);
            BigDecimal newCost = cost.add(adjustAmt.multiply(sign));
            BigDecimal qty = lastBalInfo.getQty();
            BigDecimal unitCost = qty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : newCost.divide(qty, this.getCalPricePrecision(), 4);
            lastBalInfo.getCostMap().put(elementId, newCost);
            lastBalInfo.getUnitCostMap().put(elementId, unitCost);
            this.updateBalMap.put(lastBalInfo.getBillEntryId() + "," + elementId, new Object[]{qty, newCost, unitCost});
        }
        for (int i = this.balList.size() - 1; i >= 0; --i) {
            BalInfo balInfo = this.balList.get(i);
            if (balInfo.getQty().signum() != 0 || balInfo.getAllCost().signum() != 0) continue;
            this.balList.remove(i);
        }
        int index = this.holder.createNewEntry(adjustInfo);
        StringBuilder formula = new StringBuilder();
        formula.append(this.toBigDecimalString(BigDecimal.ZERO.setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
        formula.append('*');
        formula.append(this.toBigDecimalString(BigDecimal.ZERO.setScale(this.getPricePrecision())));
        formula.append('=');
        formula.append(this.toBigDecimalString(adjustInfo.getAdjustAmt().setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
        if ("A".equals(adjustInfo.getCallBillType())) {
            this.holder.setInFormula(index, formula.toString());
        } else {
            this.holder.setOutFormula(index, formula.toString());
        }
        String invbillnum = CostPriceSourceTypeEnum.getCostAdjuestInvbillNum(adjustInfo);
        if (!StringUtils.isEmpty((String)invbillnum)) {
            String msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355(\u5bf9\u5e94\u5e93\u5b58\u5355\u636e\u53f7\uff1a%1$s)", (String)"MoveAddAverageCalculate_14", (String)"fi-calx-algox", (Object[])new Object[0]), invbillnum);
            this.holder.setBillType(index, msg);
        }
        formula.setLength(0);
        cost = lastBalInfo.getAllCost();
        BigDecimal qty = lastBalInfo.getQty();
        BigDecimal allUnitCost = lastBalInfo.getAllUnitCost();
        formula.append(this.toBigDecimalString(qty.setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
        formula.append('*');
        formula.append(this.toBigDecimalString(allUnitCost.setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
        formula.append('=');
        formula.append(this.toBigDecimalString(cost.stripTrailingZeros().setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
        formula.append('\n');
        BigDecimal sumQty = BigDecimal.ZERO;
        BigDecimal sumCost = BigDecimal.ZERO;
        for (BalInfo balInfo : this.balList) {
            BigDecimal balQty = balInfo.getQty();
            BigDecimal balCost = balInfo.getAllCost();
            sumQty = sumQty.add(balQty);
            sumCost = sumCost.add(balCost);
        }
        BigDecimal sumUnitCost = sumQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(this.getPricePrecision(), RoundingMode.HALF_UP) : sumCost.divide(sumQty, this.getPricePrecision(), RoundingMode.HALF_UP);
        this.appendEndMsg(formula, sumQty, sumUnitCost, sumCost);
        this.holder.setBalanceFormula(index, formula.toString());
        for (Map.Entry<Long, CostSubElement> entry : this.getElementMap().entrySet()) {
            long subElementId = entry.getKey();
            BigDecimal adjustAmt = adjustInfo.getAdjustCost(subElementId);
            BigDecimal elementCost = lastBalInfo.getCostMap().get(subElementId);
            if (adjustAmt.compareTo(BigDecimal.ZERO) == 0 && elementCost.compareTo(BigDecimal.ZERO) == 0) continue;
            formula.setLength(0);
            int subIndex = this.holder.createNewSubEntry(index, entry.getValue().getName());
            formula.append(this.toBigDecimalString(adjustInfo.getAdjustCost(subElementId).setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
            if ("A".equals(adjustInfo.getCallBillType())) {
                this.holder.setInFormula(subIndex, formula.toString());
            } else {
                this.holder.setOutFormula(subIndex, formula.toString());
            }
            formula.setLength(0);
            BigDecimal elementUnitCost = lastBalInfo.getUnitCostMap().get(subElementId);
            formula.append(this.toBigDecimalString(qty.setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
            formula.append('*');
            formula.append(this.toBigDecimalString(elementUnitCost.setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
            formula.append('=');
            formula.append(this.toBigDecimalString(elementCost.setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
            formula.append('\n');
            sumQty = BigDecimal.ZERO;
            sumCost = BigDecimal.ZERO;
            for (BalInfo balInfo : this.balList) {
                BigDecimal balQty = balInfo.getQty();
                BigDecimal elementBalCost = balInfo.getCostMap().get(subElementId);
                sumQty = sumQty.add(balQty);
                sumCost = sumCost.add(elementBalCost);
            }
            sumUnitCost = sumQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(this.getPricePrecision(), RoundingMode.HALF_UP) : sumCost.divide(sumQty, this.getPricePrecision(), RoundingMode.HALF_UP);
            this.appendEndMsg(formula, sumQty, sumUnitCost, sumCost);
            this.holder.setBalanceFormula(subIndex, formula.toString());
        }
    }

    private List<BalInfo> createSortList4CostAdjust(Long costRecordEntryId) {
        ArrayList<BalInfo> copyBalList = new ArrayList<BalInfo>(this.balList.size());
        for (BalInfo info : this.balList) {
            copyBalList.add(info);
        }
        int j = -1;
        for (int i = 0; i < copyBalList.size(); ++i) {
            if (costRecordEntryId.longValue() != ((BalInfo)copyBalList.get(i)).getBillEntryId()) continue;
            j = i;
            break;
        }
        if (j != -1 && j != 0) {
            BalInfo info = (BalInfo)copyBalList.get(j);
            BalInfo lastInfo = (BalInfo)copyBalList.get(0);
            for (int i = 1; i <= j; ++i) {
                BalInfo preInfo = (BalInfo)copyBalList.get(i);
                copyBalList.set(i, lastInfo);
                lastInfo = preInfo;
            }
            copyBalList.set(0, info);
        }
        return copyBalList;
    }

    private void fetchFIFOPrice(LocalRow row) {
        String queueType = row.getQueuetype();
        int pricePrecision = row.getPriceprecision();
        int amtPrecision = row.getAmtprecision();
        BigDecimal billQty = row.getBaseqty();
        BigDecimal sign = BigDecimal.ONE;
        if ("1".equals(queueType)) {
            sign = new BigDecimal("-1");
        }
        Map<Long, BigDecimal> costMap = row.getElementCostMap();
        for (Map.Entry<Long, BigDecimal> entry : costMap.entrySet()) {
            Map<Long, BigDecimal> elementCostMap;
            BigDecimal newQty;
            BigDecimal cost;
            BigDecimal qty;
            BigDecimal sumCost;
            BigDecimal sumQty;
            int i;
            BigDecimal actualCost = null;
            BigDecimal unitCost = null;
            long subElementId = entry.getKey();
            boolean isAddPrice = false;
            for (BalInfo balInfo : this.balList) {
                Map<Long, BigDecimal> balUnitCostMap = balInfo.getUnitCostMap();
                if (balUnitCostMap.get(subElementId).signum() >= 0) continue;
                isAddPrice = true;
                break;
            }
            BigDecimal calQty = billQty.multiply(sign);
            if (!isAddPrice) {
                i = 0;
                sumQty = BigDecimal.ZERO;
                sumCost = BigDecimal.ZERO;
                for (BalInfo balInfo : this.balList) {
                    qty = balInfo.getQty();
                    cost = balInfo.getCostMap().get(subElementId);
                    newQty = calQty.add(qty);
                    if (newQty.signum() >= 0) {
                        actualCost = sumCost.add(billQty.subtract(sumQty).multiply(balInfo.getUnitCostMap().get(subElementId)).setScale(amtPrecision, 4));
                        if (newQty.signum() == 0) {
                            actualCost = sumCost.add(cost).abs().multiply(row.getSign());
                        }
                        if (i == 0) {
                            if (balInfo.getUnitCostMap().get(subElementId).signum() >= 0) {
                                unitCost = balInfo.getUnitCostMap().get(subElementId);
                                break;
                            }
                        } else if (actualCost.signum() * billQty.signum() >= 0) {
                            unitCost = actualCost.divide(billQty, pricePrecision, 4);
                            break;
                        }
                    }
                    calQty = newQty;
                    sumQty = sumQty.add(qty);
                    sumCost = sumCost.add(cost);
                    ++i;
                }
                if (unitCost == null || unitCost.compareTo(BigDecimal.ZERO) == 0) {
                    BigDecimal bigDecimal = unitCost = sumQty.compareTo(BigDecimal.ZERO) == 0 || sumCost.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : sumCost.divide(sumQty, pricePrecision, 4);
                    actualCost = billQty.compareTo(sumQty) == 0 ? sumCost.abs().multiply(new BigDecimal(billQty.signum() * unitCost.signum())) : billQty.multiply(unitCost).setScale(amtPrecision, 4);
                }
            } else {
                i = 0;
                sumQty = BigDecimal.ZERO;
                sumCost = BigDecimal.ZERO;
                for (BalInfo balInfo : this.balList) {
                    qty = balInfo.getQty();
                    cost = balInfo.getCostMap().get(subElementId);
                    newQty = calQty.add(qty);
                    sumCost = sumCost.add(cost);
                    sumQty = sumQty.add(qty);
                    if (newQty.signum() >= 0 && sumCost.signum() * sumQty.signum() >= 0) {
                        unitCost = i == 0 ? balInfo.getUnitCostMap().get(subElementId) : sumCost.divide(sumQty, pricePrecision, 4);
                        if (newQty.signum() == 0) {
                            actualCost = sumCost.abs().multiply(new BigDecimal(billQty.signum() * unitCost.signum()));
                            break;
                        }
                        actualCost = unitCost.multiply(billQty).setScale(amtPrecision, 4);
                        break;
                    }
                    calQty = newQty;
                    ++i;
                }
                if (unitCost == null || unitCost.compareTo(BigDecimal.ZERO) == 0) {
                    unitCost = sumQty.compareTo(BigDecimal.ZERO) == 0 || sumCost.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : sumCost.divide(sumQty, pricePrecision, 4);
                    actualCost = billQty.compareTo(sumQty) == 0 ? sumCost.abs().multiply(new BigDecimal(billQty.signum() * unitCost.signum())) : billQty.multiply(unitCost).setScale(amtPrecision, 4);
                }
            }
            boolean designatedcost = row.isDesignatedcost();
            boolean coverdesigoutcost = this.ctx.enableCoverdesigoutcost();
            if (!designatedcost || designatedcost && coverdesigoutcost) {
                row.setCostpriceSourceType(CostPriceSourceTypeEnum.CALCULATE_COST_SPECIFICATION.getValue());
                row.setDirectUnitCost(subElementId, unitCost);
                row.setDirectCost(subElementId, actualCost);
                if (this.priceResultSuccess) {
                    row.setCostpriceSourceType(CostPriceSourceTypeEnum.GET_COST_SPECIFICATION.getValue());
                    row.setSrcbillno(this.priceResultNo);
                }
            }
            if ("0".equals(row.getRowtype())) {
                if (!row.isPresent()) continue;
                elementCostMap = row.getElementCostMap();
                for (Long element : elementCostMap.keySet()) {
                    elementCostMap.put(element, BigDecimal.ZERO);
                    row.setDirectCost(element, BigDecimal.ZERO);
                    row.setDirectUnitCost(element, BigDecimal.ZERO);
                }
                row.setDirectUnitActualCost(BigDecimal.ZERO);
                row.setActualCost(BigDecimal.ZERO, Boolean.TRUE);
                row.refreshDirectActualCostByElement();
                row.setMarkZero(this.presentMark);
                row.setCostpriceSourceType(CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getValue());
                continue;
            }
            if (!row.isInvTxZeroCost() && (!row.isEnableInBillZeroCost() || !this.isInBillAllAmtZero())) continue;
            elementCostMap = row.getElementCostMap();
            for (Long element : elementCostMap.keySet()) {
                elementCostMap.put(element, BigDecimal.ZERO);
                row.setDirectCost(element, BigDecimal.ZERO);
                row.setDirectUnitCost(element, BigDecimal.ZERO);
            }
            row.setDirectUnitActualCost(BigDecimal.ZERO);
            row.setActualCost(BigDecimal.ZERO, Boolean.TRUE);
            row.refreshDirectActualCostByElement();
            row.setCostpriceSourceType(CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getValue());
            row.setMarkZero(this.zeroCostMark);
        }
    }

    private void dealSpCondition(LocalRow row) {
        boolean isFirstInAdjBill;
        String queueType = row.getQueuetype();
        boolean isInQueueType = "0".equals(queueType);
        boolean bl = isFirstInAdjBill = this.isFirstBill && isInQueueType && row.getRowtype().equals("2");
        if (this.balList.isEmpty() || this.balList.size() > 1 || isFirstInAdjBill) {
            return;
        }
        CostAdjustInfo adjustInfo = null;
        BalInfo lastBalInfo = this.balList.get(this.balList.size() - 1);
        BigDecimal currentTotalQty = lastBalInfo.getQty();
        BigDecimal currentTotalCost = lastBalInfo.getAllCost();
        if (currentTotalQty.compareTo(BigDecimal.ZERO) == 0 && currentTotalCost.compareTo(BigDecimal.ZERO) != 0) {
            DynamicObject costAdjustOutBillType = (DynamicObject)this.ctx.getParamCache().getParamValue("costAdjustOutBillType");
            adjustInfo = this.createCostAdjustInfo(row, "B", "N", costAdjustOutBillType);
            Map<Long, BigDecimal> costMap = lastBalInfo.getCostMap();
            for (Map.Entry<Long, BigDecimal> entry : costMap.entrySet()) {
                BigDecimal totalCost = entry.getValue();
                Long elementId = entry.getKey();
                adjustInfo.setAdjustCost(this.getElementMap().get(elementId), totalCost);
            }
        } else if (currentTotalQty.compareTo(BigDecimal.ZERO) != 0) {
            CostPriceResultInfo priceInfo = null;
            Map<Long, BigDecimal> unitCostMap = lastBalInfo.getUnitCostMap();
            BigDecimal allUnitCost = lastBalInfo.getAllUnitCost();
            for (Map.Entry<Long, BigDecimal> entry : unitCostMap.entrySet()) {
                BigDecimal unitCost = entry.getValue();
                if (allUnitCost.compareTo(BigDecimal.ZERO) >= 0 || !this.ctx.enableBalanceNeg()) continue;
                if (priceInfo == null) {
                    priceInfo = this.getCostPrice(row.getHeadid(), row.getEntryId(), row.getRowtype(), "H");
                    logger.info("\u8d1f\u5355\u4ef7\u53d6\u4ef7\u7ed3\u679c\uff1a" + priceInfo.getCostPriceLog());
                    if (!priceInfo.isSuccess()) {
                        this.hasPriceFailed = true;
                        int errorIndex = this.holder.createNewEntry();
                        String msg = String.format(ResManager.loadKDString((String)"\u7ed3\u5b58\u8d1f\u5355\u4ef7\u53d6\u4ef7\u5931\u8d25\uff1a%1$s", (String)"MovedAvgIntimeAT_11", (String)"fi-calx-algox", (Object[])new Object[0]), priceInfo.getErrMsg());
                        this.holder.setBalanceFormula(errorIndex, msg);
                        break;
                    }
                    int index = this.holder.createNewEntry();
                    this.holder.setBillType(index, ResManager.loadKDString((String)"\u8d1f\u5355\u4ef7\u53d6\u4ef7\u7ed3\u679c", (String)"MovedAvgIntimeAT_0", (String)"fi-calx-algox", (Object[])new Object[0]));
                    StringBuilder sb = new StringBuilder();
                    BigDecimal priceTotalUnitCost = BigDecimal.ZERO;
                    for (Map.Entry<Long, CostSubElement> priceEntry : this.getElementMap().entrySet()) {
                        Long priceElementId = priceEntry.getKey();
                        BigDecimal priceUnitCost = priceInfo.getCostSubElementUnitcostMap().get(priceElementId);
                        if (priceUnitCost == null) {
                            priceUnitCost = BigDecimal.ZERO;
                        }
                        priceTotalUnitCost = priceTotalUnitCost.add(priceUnitCost);
                        int subIndex = this.holder.createNewSubEntry(index, priceEntry.getValue().getName());
                        this.holder.setInFormula(subIndex, priceInfo.getSrcPriceName() + ":" + this.toBigDecimalString(priceUnitCost.setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
                    }
                    sb.append(priceInfo.getSrcPriceName());
                    sb.append(':');
                    sb.append(this.toBigDecimalString(priceTotalUnitCost.setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
                    this.holder.setInFormula(index, sb.toString());
                    DynamicObject costAdjustOutBillType = (DynamicObject)this.ctx.getParamCache().getParamValue("costAdjustOutBillType");
                    adjustInfo = this.createCostAdjustInfo(row, "B", "N", costAdjustOutBillType);
                }
                Long elementId = entry.getKey();
                BigDecimal newUnitCost = priceInfo.getCostSubElementUnitcostMap().get(elementId);
                newUnitCost = newUnitCost == null ? BigDecimal.ZERO : newUnitCost;
                BigDecimal adjustUnitCost = unitCost.subtract(newUnitCost);
                if (adjustInfo == null) continue;
                adjustInfo.setAdjustCost(this.getElementMap().get(elementId), adjustUnitCost.multiply(currentTotalQty).setScale(row.getAmtprecision(), RoundingMode.HALF_UP));
            }
        }
        if (adjustInfo != null) {
            this.joinCalculate(adjustInfo);
        }
    }

    private void mergeBalList(LocalRow row, List<BalInfo> balList) {
        BigDecimal qty = row.getBaseqty();
        BigDecimal sign = BigDecimal.ONE;
        String queueType = row.getQueuetype();
        if ("1".equals(queueType)) {
            sign = new BigDecimal("-1");
        }
        if ("1".equals(queueType) && qty.signum() > 0) {
            BigDecimal calQty = qty.negate();
            for (BalInfo balInfo : balList) {
                BigDecimal balQty = balInfo.getQty();
                Long entryId = balInfo.getBillEntryId();
                List<InOutRelationInfo> relationList = this.addNewRelationMap.get(entryId);
                if (relationList == null && (relationList = this.addEntryRelationMap.get(entryId)) == null) {
                    relationList = new ArrayList<InOutRelationInfo>(16);
                    this.addEntryRelationMap.put(entryId, relationList);
                }
                BigDecimal outQty = calQty.abs().compareTo(balQty) < 0 ? calQty.abs() : balQty;
                InOutRelationInfo outRelationInfo = this.buildRelationInfo(row, outQty, "OUT");
                relationList.add(outRelationInfo);
                this.outRelationMap.put(outRelationInfo.getBillEntryId(), outRelationInfo);
                if ((calQty = calQty.add(balQty)).signum() < 0) continue;
                break;
            }
        }
        Map<Long, BigDecimal> costMap = row.getElementCostMap();
        HashMap<Integer, BigDecimal> qtyMap = new HashMap<Integer, BigDecimal>(16);
        for (int i = 0; i < balList.size(); ++i) {
            qtyMap.put(i, balList.get(i).getQty());
        }
        block2: for (Map.Entry<Long, BigDecimal> entry : costMap.entrySet()) {
            BigDecimal billQty = qty.multiply(sign);
            long subElementId = entry.getKey();
            BigDecimal cost = entry.getValue();
            BigDecimal billCost = cost.multiply(sign);
            boolean isLast = false;
            for (int i = 0; i < balList.size(); ++i) {
                if (i == balList.size() - 1) {
                    isLast = true;
                }
                BalInfo balInfo = balList.get(i);
                BigDecimal balQty = (BigDecimal)qtyMap.get(i);
                BigDecimal balCost = balInfo.getCostMap().get(subElementId);
                BigDecimal newQty = billQty.add(balQty);
                BigDecimal newCost = billCost.add(balCost);
                if (row.getRowtype().equals("2") || newQty.signum() >= 0) {
                    balInfo.setQty(newQty);
                    balInfo.getCostMap().put(subElementId, newCost);
                    balInfo.getUnitCostMap().put(subElementId, newQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : newCost.divide(newQty, row.getPriceprecision(), 4));
                    this.updateBalMap.put(balInfo.getBillEntryId() + "," + subElementId, new Object[]{balInfo.getQty(), balInfo.getCostMap().get(subElementId), balInfo.getUnitCostMap().get(subElementId)});
                    continue block2;
                }
                billQty = newQty;
                billCost = newCost;
                if (!isLast) {
                    balInfo.setQty(BigDecimal.ZERO);
                    balInfo.getCostMap().put(subElementId, BigDecimal.ZERO);
                    balInfo.getUnitCostMap().put(subElementId, BigDecimal.ZERO);
                } else {
                    balInfo.setQty(newQty);
                    balInfo.getCostMap().put(subElementId, newCost);
                    balInfo.getUnitCostMap().put(subElementId, newQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : newCost.divide(newQty, row.getPriceprecision(), 4));
                }
                this.updateBalMap.put(balInfo.getBillEntryId() + "," + subElementId, new Object[]{balInfo.getQty(), balInfo.getCostMap().get(subElementId), balInfo.getUnitCostMap().get(subElementId)});
            }
        }
        for (int i = this.balList.size() - 1; i >= 0; --i) {
            BalInfo balInfo = this.balList.get(i);
            if (balInfo.getQty().signum() != 0 || balInfo.getAllCost().signum() != 0) continue;
            this.balList.remove(i);
        }
    }

    private void mergeBalList(LocalRow row) {
        this.mergeBalList(row, this.balList);
    }

    private void addBalList(LocalRow row) {
        BalInfo balInfo = this.createBalInfo(row);
        this.balList.add(balInfo);
        this.sortBalList(this.balList);
        this.insertBalSet(row, balInfo.getBalId());
    }

    private void sortBalList(List<BalInfo> balList) {
        Collections.sort(balList, new Comparator<BalInfo>(){

            @Override
            public int compare(BalInfo o1, BalInfo o2) {
                Date bizDate1 = o1.getBizDate();
                Date auditDate1 = o1.getAuditDate();
                String billNo1 = o1.getBillNo();
                int entrySeq1 = o1.getEntrySeq();
                Date bizDate2 = o2.getBizDate();
                Date auditDate2 = o2.getAuditDate();
                String billNo2 = o2.getBillNo();
                int entrySeq2 = o2.getEntrySeq();
                if (bizDate1.compareTo(bizDate2) > 0) {
                    return 1;
                }
                if (bizDate1.compareTo(bizDate2) < 0) {
                    return -1;
                }
                if (auditDate1.compareTo(auditDate2) > 0) {
                    return 1;
                }
                if (auditDate1.compareTo(auditDate2) < 0) {
                    return -1;
                }
                if (billNo1.compareTo(billNo2) > 0) {
                    return 1;
                }
                if (billNo1.compareTo(billNo2) < 0) {
                    return -1;
                }
                if (entrySeq1 > entrySeq2) {
                    return 1;
                }
                if (entrySeq1 < entrySeq2) {
                    return -1;
                }
                return 0;
            }
        });
    }

    private BalInfo createBalInfo(LocalRow row) {
        BalInfo balInfo = new BalInfo();
        BigDecimal qty = row.getBaseqty();
        BigDecimal sign = BigDecimal.ONE;
        String queueType = row.getQueuetype();
        if ("1".equals(queueType)) {
            sign = new BigDecimal("-1");
        }
        balInfo.setQty(qty.multiply(sign));
        for (Map.Entry<Long, BigDecimal> entry : row.getElementCostMap().entrySet()) {
            balInfo.getCostMap().put(entry.getKey(), entry.getValue().multiply(sign));
        }
        balInfo.getUnitCostMap().putAll(row.getUnitCostAmt());
        balInfo.setBillEntryId(row.getEntryId());
        balInfo.setAuditDate(row.getAuditTime());
        balInfo.setBillNo(row.getBillnumber());
        balInfo.setBizDate(row.getBizDate());
        balInfo.setEntrySeq(row.getEntrySeq());
        long balId = DB.genLongId((String)this.getFIFOBalTable());
        balInfo.setBalId(balId);
        return balInfo;
    }

    private void insertBalSet(LocalRow row, long balId) {
        Map<Long, BigDecimal> costMap = row.getElementCostMap();
        Map<Long, CostSubElement> eMap = this.getElementMap();
        String divideStr = this.getDivideBasisStr();
        String divideValue = this.getDivideBasisValue();
        String caldimensionStr = this.getCalDimensionStr();
        String caldimensionValue = this.getCalDimensionValue();
        long calRangeId = this.getCalRangeId();
        boolean isEmptyRange = this.isEmptyRange();
        for (Map.Entry<Long, BigDecimal> entry : costMap.entrySet()) {
            long subElementId = entry.getKey();
            long elementId = eMap.get(subElementId).getCostElementId();
            BigDecimal cost = entry.getValue();
            DynamicObject balInfo = BusinessDataServiceHelper.newDynamicObject((String)this.getFIFOBalEntity());
            BigDecimal qty = row.getBaseqty();
            BigDecimal sign = BigDecimal.ONE;
            String queueType = row.getQueuetype();
            if ("1".equals(queueType)) {
                sign = new BigDecimal("-1");
            }
            balInfo.set("costaccount", (Object)this.getCostAccountId());
            balInfo.set("calorg", (Object)this.getCalOrgId());
            balInfo.set("currency", (Object)row.getLocalcurrencyid());
            balInfo.set("baseunit", (Object)row.getBaseUnitId());
            balInfo.set("material", (Object)this.getMaterialId());
            balInfo.set("auditdate", (Object)row.getAuditTime());
            balInfo.set("billno", (Object)row.getBillnumber());
            balInfo.set("billentryid", (Object)row.getEntryId());
            balInfo.set("bizdate", (Object)row.getBizDate());
            balInfo.set("endqty", (Object)qty.multiply(sign));
            balInfo.set("endcost", (Object)cost.multiply(sign));
            balInfo.set("endunitcost", (Object)row.getUnitCost(subElementId));
            balInfo.set("entryseq", (Object)row.getEntrySeq());
            balInfo.set("calrptid", (Object)this.holder.getCalRptID());
            balInfo.set("costelement", (Object)elementId);
            balInfo.set("costsubelement", (Object)subElementId);
            balInfo.set("calrange", (Object)calRangeId);
            if (isEmptyRange) {
                this.setDynValue(balInfo, divideStr, divideValue);
            }
            this.setDynValue(balInfo, caldimensionStr, caldimensionValue);
            this.insertBalSet.add(balInfo);
        }
        String queueType = row.getQueuetype();
        BigDecimal baseQty = row.getBaseqty();
        Set purSet = (Set)this.ctx.getParamCache().getParamValue("purBizEntityObjectSet");
        Set ominSet = (Set)this.ctx.getParamCache().getParamValue("ominBizEntityObjectSet");
        if ((purSet.contains(row.getBizEntityObject()) || ominSet.contains(row.getBizEntityObject())) && "0".equals(queueType) && baseQty.signum() > 0) {
            InOutRelationInfo inRelationInfo = this.buildRelationInfo(row, null, "IN");
            this.addNewRelationMap.put(inRelationInfo.getBillEntryId(), new ArrayList(16));
            this.inRelationMap.put(inRelationInfo.getBillEntryId(), inRelationInfo);
        }
        if ("1".equals(queueType) && baseQty.signum() < 0 && row.isDestBill()) {
            BillGroupRecord groupRecord = this.ctx.getGroupBillHolder().getDestRowRecordMap().get(row.getEntryId());
            Set<Long> srcIdSet = groupRecord.getSrcEntryIds();
            for (Long srcId : srcIdSet) {
                InOutRelationInfo outRelationInfo;
                if (!this.idSet.contains(srcId) || (outRelationInfo = this.outRelationMap.get(srcId)) == null) continue;
                outRelationInfo.setQty(outRelationInfo.getQty().add(baseQty));
            }
        }
    }

    private InOutRelationInfo buildRelationInfo(LocalRow row, BigDecimal outQty, String type) {
        InOutRelationInfo inRelationInfo = new InOutRelationInfo(type);
        inRelationInfo.setBillEntryId(row.getEntryId());
        inRelationInfo.setBillId(row.getHeadid());
        inRelationInfo.setBillNumber(row.getBillnumber());
        inRelationInfo.setBookdate(row.getBizDate());
        if (outQty != null) {
            inRelationInfo.setQty(outQty);
        } else {
            inRelationInfo.setQty(row.getBaseqty());
        }
        inRelationInfo.setMaterialId(this.getMaterialId());
        inRelationInfo.setCostaccountId(this.getCostAccountId());
        return inRelationInfo;
    }

    private void setDynValue(DynamicObject balInfo, String colStr, String colValue) {
        if (StringUtils.isEmpty((String)colStr)) {
            return;
        }
        String[] names = colStr.split(",");
        String[] values = colValue.split("_");
        for (int i = 0; i < names.length; ++i) {
            String value = values[i];
            if (value.equals("#")) continue;
            balInfo.set(names[i], (Object)value);
        }
    }

    @Override
    protected void beforeEndCalculated() {
        ArrayList<LocalRow> costNotDeterminedRows = new ArrayList<LocalRow>(16);
        for (LocalRow row : this.tempInGroupRow) {
            CostAdjustInfo costAdjustInfo;
            if ((row = this.getGroupedRow(row.getEntryId())).isGroupCostCalculated().booleanValue() && !row.isCostDetermined()) {
                CostPriceSourceTypeHelper.setCostpriceSourceByGroup(row, this.ctx.enableCoverdesigoutcost());
                if ("0".equals(row.getQueuetype())) {
                    this.addQtyAmtMark(row);
                    this.addCostUpdateInfo(row);
                    if (!row.isPriced()) {
                        this.joinCalculate(row, ResManager.loadKDString((String)"(\u4e0d\u53c2\u4e0e\u8ba1\u7b97)", (String)"WeightedAvgAT_20", (String)"fi-calx-algox", (Object[])new Object[0]), false, null);
                    }
                } else {
                    this.addCostUpdateInfo(row);
                    this.joinCalculate(row, null, false, null);
                }
            } else if (!row.isPriced() || !row.getPriceResult().isSuccess()) {
                costNotDeterminedRows.add(row);
            }
            if ((costAdjustInfo = this.addGroupBillCostAdjustInfo(row)) == null) continue;
            LocalRow costAdjustRow = this.costAdjustToLocalRow(costAdjustInfo, row);
            this.joinCalculate(costAdjustRow, null, false, costAdjustInfo);
        }
        if (!costNotDeterminedRows.isEmpty()) {
            this.holder.setCalStatus(RptStatus.WARNING);
        }
        for (LocalRow costNotDeterminedRow : costNotDeterminedRows) {
            this.joinCalculate(costNotDeterminedRow, ResManager.loadKDString((String)"(\u6210\u672c\u672a\u786e\u5b9a)", (String)"WeightedAvgAT_13", (String)"fi-calx-algox", (Object[])new Object[0]), false, null);
        }
    }

    protected void addQtyAmtMark(LocalRow row) {
        if ("0".equals(row.getQueuetype()) && !"2".equals(row.getRowtype())) {
            BigDecimal qty;
            BigDecimal amt = row.getActualCost() == null ? BigDecimal.ZERO : row.getActualCost();
            BigDecimal bigDecimal = qty = row.getBaseqty() == null ? BigDecimal.ZERO : row.getBaseqty();
            if (BigDecimal.ZERO.compareTo(amt) != 0) {
                this.setInBillAllAmtZero(false);
            }
            if (BigDecimal.ZERO.compareTo(qty) != 0) {
                this.setInBillAllQtyZero(false);
            }
        }
    }

    @Override
    protected void afterEndCalculated() {
        ArrayList<Object[]> paramList;
        String sql;
        super.afterEndCalculated();
        if (RptStatus.ERROR.getValue().equals(this.holder.getCalStatusValue())) {
            return;
        }
        if (!this.insertBalSet.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])this.insertBalSet.toArray(new DynamicObject[0]));
        }
        if (!this.updateBalMap.isEmpty()) {
            sql = "update t_cal_balance_fifo set fendqty = ?,fendcost = ?,fendunitcost = ? where fbillentryid = ? and fcostsubelementid = ?";
            paramList = new ArrayList<Object[]>(this.updateBalMap.size());
            for (Map.Entry<String, Object[]> entry : this.updateBalMap.entrySet()) {
                String[] params = entry.getKey().split(",");
                Object[] o = entry.getValue();
                paramList.add(new Object[]{o[0], o[1], o[2], Long.valueOf(params[0]), Long.valueOf(params[1])});
            }
            DB.executeBatch((DBRoute)new DBRoute("cal"), (String)sql, paramList);
        }
        if (!this.updateBalRptMap.isEmpty()) {
            sql = "update t_cal_balance_fifo set fcalrptid = ? where fid = ?";
            paramList = new ArrayList(this.updateBalRptMap.size());
            for (Map.Entry<Object, Object> entry : this.updateBalRptMap.entrySet()) {
                paramList.add(new Object[]{entry.getValue(), entry.getKey()});
            }
            DB.executeBatch((DBRoute)new DBRoute("cal"), (String)sql, paramList);
        }
    }

    @Override
    protected String[] getOrderByField() {
        return new String[]{"ordercol", "bizdate", "auditdate", "rowtype", "entryid", "billno", "entryseq"};
    }

    @Override
    protected String getBalanceRowType() {
        return "3";
    }

    @Override
    protected void addRptBeginData(DataSet balanceData) {
        int index = this.holder.createNewEntry();
        this.holder.setBillType(index, ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"AbstractAccountType_4", (String)"fi-calx-algox", (Object[])new Object[0]));
        balanceData = balanceData.orderBy(this.getOrderByField());
        StringBuilder formula = new StringBuilder();
        HashSet<Object> balanceIdSet = new HashSet<Object>(16);
        for (Row row : balanceData) {
            Long balanceId = row.getLong("id");
            if (balanceIdSet.contains(balanceId)) continue;
            balanceIdSet.add(balanceId);
            BalInfo balInfo = new BalInfo();
            BigDecimal sumCost = BigDecimal.ZERO;
            BigDecimal baseQty = row.getBigDecimal("baseqty");
            for (Long elementId : this.getElementMap().keySet()) {
                BigDecimal cost = row.getBigDecimal(elementId.toString());
                balInfo.getCostMap().put(elementId, cost);
                balInfo.getUnitCostMap().put(elementId, baseQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : cost.divide(baseQty, this.getCalPricePrecision(), 4));
                sumCost = sumCost.add(cost);
            }
            balInfo.setBalId(row.getLong("id"));
            balInfo.setBillEntryId(row.getLong("entryid"));
            balInfo.setBillNo(row.getString("billno"));
            balInfo.setBizDate(row.getDate("bizdate"));
            balInfo.setAuditDate(row.getDate("auditdate"));
            balInfo.setEntrySeq(row.getInteger("entryseq"));
            balInfo.setQty(baseQty);
            this.balList.add(balInfo);
            this.updateBalRptMap.put(row.getLong("id"), this.holder.getCalRptID());
        }
        int i = 0;
        int maxRow = 5;
        for (BalInfo balInfo : this.balList) {
            if (i >= maxRow) {
                formula.append("...");
                formula.append('\n');
                break;
            }
            BigDecimal balQty = balInfo.getQty();
            BigDecimal balCost = balInfo.getAllCost();
            formula.append(this.toBigDecimalString(balQty.setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
            formula.append('*');
            formula.append(this.toBigDecimalString(balQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(this.getPricePrecision()) : balCost.divide(balQty, this.getPricePrecision(), RoundingMode.HALF_UP)));
            formula.append('=');
            formula.append(this.toBigDecimalString(balCost.setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
            formula.append('\n');
            ++i;
        }
        if (formula.length() == 0) {
            formula.append(this.toBigDecimalString(BigDecimal.ZERO.setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
            formula.append('*');
            formula.append(this.toBigDecimalString(BigDecimal.ZERO.setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
            formula.append('=');
            formula.append(this.toBigDecimalString(BigDecimal.ZERO.setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
            formula.append('\n');
        }
        BigDecimal sumQty = BigDecimal.ZERO;
        BigDecimal sumCost = BigDecimal.ZERO;
        for (BalInfo balInfo : this.balList) {
            BigDecimal balQty = balInfo.getQty();
            BigDecimal balCost = balInfo.getAllCost();
            if (BigDecimal.ZERO.compareTo(balQty) != 0) {
                this.allBeginQtyZero = false;
            }
            if (BigDecimal.ZERO.compareTo(balCost) != 0) {
                this.allBeginAmtZero = false;
            }
            sumQty = sumQty.add(balQty);
            sumCost = sumCost.add(balCost);
        }
        BigDecimal sumUnitCost = sumQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(this.getPricePrecision(), RoundingMode.HALF_UP) : sumCost.divide(sumQty, this.getPricePrecision(), RoundingMode.HALF_UP);
        this.appendEndMsg(formula, sumQty, sumUnitCost, sumCost);
        this.holder.setBalanceFormula(index, formula.toString());
        for (Map.Entry<Long, CostSubElement> entry : this.getElementMap().entrySet()) {
            Long elementId;
            elementId = entry.getKey();
            if (this.isBalanceZero(elementId)) continue;
            CostSubElement subElement = entry.getValue();
            int subIndex = this.holder.createNewSubEntry(index, subElement.getName());
            formula.setLength(0);
            i = 0;
            for (BalInfo balInfo : this.balList) {
                if (i >= maxRow) {
                    formula.append("...");
                    formula.append('\n');
                    break;
                }
                BigDecimal cost = balInfo.getCostMap().get(elementId);
                BigDecimal baseQty = balInfo.getQty();
                formula.append(this.toBigDecimalString(baseQty.setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
                formula.append('*');
                formula.append(this.toBigDecimalString(baseQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(this.getPricePrecision()) : cost.divide(baseQty, this.getPricePrecision(), RoundingMode.HALF_UP)));
                formula.append('=');
                formula.append(this.toBigDecimalString(cost.setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
                formula.append('\n');
                ++i;
            }
            if (this.balList.isEmpty()) {
                formula.append(this.toBigDecimalString(BigDecimal.ZERO.setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
                formula.append('*');
                formula.append(this.toBigDecimalString(BigDecimal.ZERO.setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
                formula.append('=');
                formula.append(this.toBigDecimalString(BigDecimal.ZERO.setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
                formula.append('\n');
            }
            sumQty = BigDecimal.ZERO;
            sumCost = BigDecimal.ZERO;
            for (BalInfo balInfo : this.balList) {
                BigDecimal balQty = balInfo.getQty();
                BigDecimal elementBalCost = balInfo.getCostMap().get(elementId);
                sumQty = sumQty.add(balQty);
                sumCost = sumCost.add(elementBalCost);
            }
            sumUnitCost = sumQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(this.getPricePrecision(), RoundingMode.HALF_UP) : sumCost.divide(sumQty, this.getPricePrecision(), RoundingMode.HALF_UP);
            this.appendEndMsg(formula, sumQty, sumUnitCost, sumCost);
            this.holder.setBalanceFormula(subIndex, formula.toString());
        }
    }

    @Override
    protected void writeEndRpt() {
        StringBuilder endFormula = new StringBuilder();
        int maxRow = 5;
        int endindex = this.holder.createNewEntry();
        this.holder.setBillType(endindex, ResManager.loadKDString((String)"\u671f\u672b\u4f59\u989d", (String)"AbstractAccountType_1", (String)"fi-calx-algox", (Object[])new Object[0]));
        int i = 0;
        for (BalInfo balInfo : this.balList) {
            if (i >= maxRow) {
                endFormula.append("...");
                endFormula.append('\n');
                break;
            }
            BigDecimal balQty = balInfo.getQty();
            BigDecimal balCost = balInfo.getAllCost();
            BigDecimal balUnitCost = balInfo.getAllUnitCost();
            endFormula.append(this.toBigDecimalString(balQty.setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
            endFormula.append('*');
            endFormula.append(this.toBigDecimalString(balUnitCost.stripTrailingZeros().setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
            endFormula.append('=');
            endFormula.append(this.toBigDecimalString(balCost.stripTrailingZeros().setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
            endFormula.append('\n');
            ++i;
        }
        BigDecimal sumQty = BigDecimal.ZERO;
        BigDecimal sumCost = BigDecimal.ZERO;
        for (BalInfo balInfo : this.balList) {
            BigDecimal balQty = balInfo.getQty();
            BigDecimal balCost = balInfo.getAllCost();
            sumQty = sumQty.add(balQty);
            sumCost = sumCost.add(balCost);
        }
        BigDecimal sumUnitCost = sumQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(this.getPricePrecision(), RoundingMode.HALF_UP) : sumCost.divide(sumQty, this.getPricePrecision(), RoundingMode.HALF_UP);
        this.appendEndMsg(endFormula, sumQty, sumUnitCost, sumCost);
        this.holder.setBalanceFormula(endindex, endFormula.toString());
        this.endSumQty = sumQty;
        this.endSumCost = sumCost;
        String errorInfo = this.getEndErrorMsg();
        if (StringUtils.isEmpty((String)errorInfo)) {
            String warnInfo = this.getEndWarnMsg();
            if (StringUtils.isNotEmpty((String)warnInfo)) {
                this.holder.appendBalanceFormula(endindex, warnInfo);
                this.holder.setCalStatus(RptStatus.WARNING);
            }
        } else {
            this.holder.appendBalanceFormula(endindex, errorInfo);
            this.holder.setCalStatus(RptStatus.ERROR);
            for (int m = 0; m < this.holder.getEntrys().size(); ++m) {
                Object describe;
                String describeStr;
                boolean updateCostPrice;
                if (this.holder.getUpdateCostPriceMap().get(m) == null || !(updateCostPrice = this.holder.getUpdateCostPriceMap().get(m).booleanValue()) || !StringUtils.isNotEmpty((String)(describeStr = String.valueOf(describe = this.holder.getEntrys().get(m)[14])))) continue;
                String[] describeStrs = describeStr.split(",");
                StringBuilder describeSb = new StringBuilder();
                for (int j = 0; j < describeStrs.length - 1; ++j) {
                    describeSb.append(describeStrs[j]);
                    describeSb.append(",");
                }
                if (describeSb.length() <= 0) continue;
                describeStr = describeSb.substring(0, describeSb.length() - 1);
                this.holder.setDescribe(m, describeStr);
            }
        }
        Map<Long, CostSubElement> elementMap = this.getElementMap();
        for (Map.Entry<Long, CostSubElement> entry : elementMap.entrySet()) {
            endFormula.setLength(0);
            Long elementId = entry.getKey();
            if (this.isBalanceZero(elementId)) continue;
            int subIndex = this.holder.createNewSubEntry(endindex, entry.getValue().getName());
            int j = 0;
            for (BalInfo balInfo : this.balList) {
                if (j >= maxRow) {
                    endFormula.append("...");
                    endFormula.append('\n');
                    break;
                }
                BigDecimal elementBalCost = balInfo.getCostMap().get(elementId);
                BigDecimal elementBalUnitCost = balInfo.getUnitCostMap().get(elementId);
                endFormula.append(this.toBigDecimalString(balInfo.getQty().setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
                endFormula.append('*');
                endFormula.append(this.toBigDecimalString(elementBalUnitCost.setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
                endFormula.append('=');
                endFormula.append(this.toBigDecimalString(elementBalCost.stripTrailingZeros().setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
                endFormula.append('\n');
                ++j;
            }
            sumQty = BigDecimal.ZERO;
            sumCost = BigDecimal.ZERO;
            for (BalInfo balInfo : this.balList) {
                BigDecimal balQty = balInfo.getQty();
                BigDecimal elementBalCost = balInfo.getCostMap().get(elementId);
                sumQty = sumQty.add(balQty);
                sumCost = sumCost.add(elementBalCost);
            }
            sumUnitCost = sumQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(this.getPricePrecision(), RoundingMode.HALF_UP) : sumCost.divide(sumQty, this.getPricePrecision(), RoundingMode.HALF_UP);
            this.appendEndMsg(endFormula, sumQty, sumUnitCost, sumCost);
            this.holder.setBalanceFormula(subIndex, endFormula.toString());
        }
    }

    private boolean isBalanceZero(Long elementId) {
        int size = this.balList.size();
        if (size == 0) {
            return true;
        }
        for (int i = 0; i < size; ++i) {
            if (this.balList.get(i).getCostMap().get(elementId).compareTo(BigDecimal.ZERO) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    protected final String getEndErrorMsg() {
        if (this.hasPriceFailed) {
            return ResManager.loadKDString((String)"\u5b58\u5728\u53d6\u4ef7\u5931\u8d25\u7684\u573a\u666f\uff0c\u7ed3\u8f6c\u5931\u8d25\u3002", (String)"MovedAvgIntimeAT_2", (String)"fi-calx-algox", (Object[])new Object[0]);
        }
        return super.getEndErrorMsg();
    }

    @Override
    protected String getEndWarnMsg() {
        if (this.endSumQty.compareTo(BigDecimal.ZERO) < 0) {
            return ResManager.loadKDString((String)"\u8b66\u544a\uff1a\u671f\u672b\u6570\u91cf<0\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"AbstractAccountType_3", (String)"fi-calx-algox", (Object[])new Object[0]);
        }
        if (this.endSumQty.signum() * this.endSumCost.signum() < 0) {
            return ResManager.loadKDString((String)"\u8b66\u544a\uff1a\u671f\u672b\u6570\u91cf\u4e0d\u4e3a0\uff0c\u4f46\u671f\u672b\u5355\u4ef7<0\u3002", (String)"AbstractAccountType_2", (String)"fi-calx-algox", (Object[])new Object[0]);
        }
        if (this.endSumQty.compareTo(BigDecimal.ZERO) != 0 && this.endSumCost.compareTo(BigDecimal.ZERO) == 0) {
            return ResManager.loadKDString((String)"\u8b66\u544a\uff1a\u671f\u672b\u6570\u91cf\u4e0d\u4e3a0\uff0c\u4f46\u671f\u672b\u5355\u4ef7=0\u3002", (String)"AbstractAccountType_13", (String)"fi-calx-algox", (Object[])new Object[0]);
        }
        return null;
    }

    private void appendEndMsg(StringBuilder formula, BigDecimal sumQty, BigDecimal sumUnitCost, BigDecimal sumCost) {
        formula.append(ResManager.loadKDString((String)"\u7ed3\u5b58\uff1a", (String)"FIFOCalAT_2", (String)"fi-calx-algox", (Object[])new Object[0]));
        formula.append(this.toBigDecimalString(sumQty.setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
        formula.append('*');
        formula.append(this.toBigDecimalString(sumUnitCost.stripTrailingZeros().setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
        formula.append('=');
        formula.append(this.toBigDecimalString(sumCost.stripTrailingZeros().setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
        formula.append('\n');
    }

    protected String getFIFOBalEntity() {
        return "cal_balance_fifo";
    }

    protected String getFIFOBalTable() {
        return "t_cal_balance_fifo";
    }

    public boolean isInBillAllAmtZero() {
        return this.inBillAllAmtZero;
    }

    public void setInBillAllAmtZero(boolean inBillAllAmtZero) {
        this.inBillAllAmtZero = inBillAllAmtZero;
    }

    public boolean isInBillAllQtyZero() {
        return this.inBillAllQtyZero;
    }

    public void setInBillAllQtyZero(boolean inBillAllQtyZero) {
        this.inBillAllQtyZero = inBillAllQtyZero;
    }

    private static class BalInfo {
        private long balId;
        private long billEntryId;
        private Date bizDate;
        private Date auditDate;
        private String billNo;
        private int entrySeq;
        private Map<Long, BigDecimal> costMap = new HashMap<Long, BigDecimal>(16);
        private Map<Long, BigDecimal> unitCostMap = new HashMap<Long, BigDecimal>(16);
        private BigDecimal qty;

        private BalInfo() {
        }

        public long getBalId() {
            return this.balId;
        }

        public void setBalId(long balId) {
            this.balId = balId;
        }

        public long getBillEntryId() {
            return this.billEntryId;
        }

        public void setBillEntryId(long billEntryId) {
            this.billEntryId = billEntryId;
        }

        public Date getBizDate() {
            return this.bizDate;
        }

        public void setBizDate(Date bizDate) {
            this.bizDate = bizDate;
        }

        public Date getAuditDate() {
            return this.auditDate;
        }

        public void setAuditDate(Date auditDate) {
            this.auditDate = auditDate;
        }

        public String getBillNo() {
            return this.billNo;
        }

        public void setBillNo(String billNo) {
            this.billNo = billNo;
        }

        public int getEntrySeq() {
            return this.entrySeq;
        }

        public void setEntrySeq(int entrySeq) {
            this.entrySeq = entrySeq;
        }

        public BigDecimal getQty() {
            return this.qty;
        }

        public void setQty(BigDecimal qty) {
            this.qty = qty;
        }

        public Map<Long, BigDecimal> getCostMap() {
            return this.costMap;
        }

        public Map<Long, BigDecimal> getUnitCostMap() {
            return this.unitCostMap;
        }

        public BigDecimal getAllCost() {
            BigDecimal allCost = BigDecimal.ZERO;
            for (BigDecimal cost : this.costMap.values()) {
                allCost = allCost.add(cost);
            }
            return allCost;
        }

        public BigDecimal getAllUnitCost() {
            BigDecimal allCost = BigDecimal.ZERO;
            for (BigDecimal unitCost : this.unitCostMap.values()) {
                allCost = allCost.add(unitCost);
            }
            return allCost;
        }
    }
}

