/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.accounttype;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.calx.algox.InOutRelationInfo;
import kd.fi.calx.algox.accounttype.FIFOCalAT;
import kd.fi.calx.algox.function.AccountTypeContext;
import kd.fi.calx.algox.report.RptStatus;

public class FIFOPeriodCalAT
extends FIFOCalAT {
    private static final long serialVersionUID = 6400870193574210537L;

    public FIFOPeriodCalAT(AccountTypeContext ctx, DataSet dataSet, int runningMode) {
        super(ctx, dataSet, runningMode);
    }

    @Override
    protected void afterEndCalculated() {
        ArrayList<Object[]> paramList;
        String sql;
        super.afterEndCalculated();
        if (RptStatus.ERROR.getValue().equals(this.holder.getCalStatusValue())) {
            return;
        }
        Long periodid = this.getPeriodId();
        if (!this.insertBalSet.isEmpty()) {
            for (DynamicObject balInfo : this.insertBalSet) {
                balInfo.set("period", (Object)periodid);
            }
            SaveServiceHelper.save((DynamicObject[])this.insertBalSet.toArray(new DynamicObject[0]));
        }
        if (!this.updateBalMap.isEmpty()) {
            sql = "update t_cal_bal_fifo_period set fendqty = ?,fendcost = ?,fendunitcost = ? where fbillentryid = ? and fcostsubelementid = ? and fperiodid = ?";
            paramList = new ArrayList<Object[]>(this.updateBalMap.size());
            for (Map.Entry entry : this.updateBalMap.entrySet()) {
                String[] params = ((String)entry.getKey()).split(",");
                Object[] o = (Object[])entry.getValue();
                paramList.add(new Object[]{o[0], o[1], o[2], Long.valueOf(params[0]), Long.valueOf(params[1]), periodid});
            }
            DB.executeBatch((DBRoute)new DBRoute("cal"), (String)sql, paramList);
        }
        if (!this.updateBalRptMap.isEmpty()) {
            sql = "update t_cal_bal_fifo_period set fcalrptid = ? where fid = ?";
            paramList = new ArrayList(this.updateBalRptMap.size());
            for (Map.Entry entry : this.updateBalRptMap.entrySet()) {
                paramList.add(new Object[]{entry.getValue(), entry.getKey()});
            }
            DB.executeBatch((DBRoute)new DBRoute("cal"), (String)sql, paramList);
        }
    }

    @Override
    public void afterAllCalculate() {
        super.afterAllCalculate();
        this.flushInOutRelation();
    }

    private void flushInOutRelation() {
        Object sumOutQty;
        if (!this.addNewRelationMap.isEmpty()) {
            HashSet<DynamicObject> addNewSet = new HashSet<DynamicObject>(this.addNewRelationMap.size());
            for (Map.Entry e : this.addNewRelationMap.entrySet()) {
                Long inEntryId = (Long)e.getKey();
                List outRelationList = (List)e.getValue();
                InOutRelationInfo inRelationInfo = (InOutRelationInfo)this.inRelationMap.get(inEntryId);
                DynamicObject relationInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_inoutrelation");
                relationInfo.set("inbillnunber", (Object)inRelationInfo.getBillNumber());
                relationInfo.set("inbillid", (Object)inRelationInfo.getBillId());
                relationInfo.set("inbillentryid", (Object)inRelationInfo.getBillEntryId());
                relationInfo.set("inbilldate", (Object)inRelationInfo.getBookdate());
                relationInfo.set("inqty", (Object)inRelationInfo.getQty());
                relationInfo.set("material_id", (Object)inRelationInfo.getMaterialId());
                relationInfo.set("costaccount_id", (Object)inRelationInfo.getCostaccountId());
                sumOutQty = BigDecimal.ZERO;
                for (InOutRelationInfo outRelationInfo : outRelationList) {
                    DynamicObject relationEntry = relationInfo.getDynamicObjectCollection("entry").addNew();
                    relationEntry.set("outbillnumber", (Object)outRelationInfo.getBillNumber());
                    relationEntry.set("outbillid", (Object)outRelationInfo.getBillId());
                    relationEntry.set("outbillentryid", (Object)outRelationInfo.getBillEntryId());
                    relationEntry.set("outbilldate", (Object)outRelationInfo.getBookdate());
                    relationEntry.set("outqty", (Object)outRelationInfo.getQty());
                    sumOutQty = ((BigDecimal)sumOutQty).add(outRelationInfo.getQty());
                }
                relationInfo.set("sumoutqty", sumOutQty);
                addNewSet.add(relationInfo);
            }
            if (!addNewSet.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])addNewSet.toArray(new DynamicObject[0]));
            }
        }
        if (!this.addEntryRelationMap.isEmpty()) {
            DynamicObject[] relationInfos;
            QFilter q = new QFilter("inbillentryid", "in", this.addEntryRelationMap.keySet());
            for (DynamicObject relationInfo : relationInfos = BusinessDataServiceHelper.load((String)"cal_inoutrelation", (String)"id,inbillentryid,sumoutqty,entry.id,entry.outbillnumber,entry.outbillid,entry.outbillentryid,entry.outbilldate,entry.outqty", (QFilter[])q.toArray())) {
                List outRelationList = (List)this.addEntryRelationMap.get(relationInfo.get("inbillentryid"));
                for (InOutRelationInfo outRelationInfo : outRelationList) {
                    DynamicObject relationEntry = relationInfo.getDynamicObjectCollection("entry").addNew();
                    relationEntry.set("outbillnumber", (Object)outRelationInfo.getBillNumber());
                    relationEntry.set("outbillid", (Object)outRelationInfo.getBillId());
                    relationEntry.set("outbillentryid", (Object)outRelationInfo.getBillEntryId());
                    relationEntry.set("outbilldate", (Object)outRelationInfo.getBookdate());
                    relationEntry.set("outqty", (Object)outRelationInfo.getQty());
                }
                sumOutQty = BigDecimal.ZERO;
                for (DynamicObject entry : relationInfo.getDynamicObjectCollection("entry")) {
                    sumOutQty = ((BigDecimal)sumOutQty).add(entry.getBigDecimal("outqty"));
                }
                relationInfo.set("sumoutqty", sumOutQty);
            }
            if (relationInfos.length > 0) {
                SaveServiceHelper.save((DynamicObject[])relationInfos);
            }
        }
    }

    @Override
    protected String[] getOrderByField() {
        return new String[]{"ordercol", "bizdate", "auditdate", "rowtype", "entryid", "billno", "entryseq"};
    }

    @Override
    protected String getFIFOBalEntity() {
        return "cal_balance_fifo_period";
    }

    @Override
    protected String getFIFOBalTable() {
        return "t_cal_bal_fifo_period";
    }

    @Override
    protected String getBalanceRowType() {
        return "4";
    }
}

