/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.accounttype;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.fi.calx.algox.CostPriceResultInfo;
import kd.fi.calx.algox.CostSubElement;

public class LocalRow {
    public static final long DEFAULT_MATERIAL_SUBCOSTELEMENT = 773175233367685120L;
    private Long headid;
    private Long entryid;
    private Long periodid;
    private String rowtype;
    private String queuetype;
    private String calbilltype;
    private Long bizbillid;
    private Long bizbillentryid;
    private String billtypenum;
    private String billtype;
    private String billnumber;
    private boolean calbycostelement;
    private Long costaccountid;
    private boolean isInitBill;
    private long costRecordEntryid;
    private Map<Long, CostSubElement> elementMap;
    private Long bizTypeId;
    private Date bizDate;
    private Date auditTime;
    private int entrySeq;
    private BigDecimal baseqty;
    private Map<Long, BigDecimal> costAmt = new LinkedHashMap<Long, BigDecimal>();
    private Map<String, BigDecimal> entryCostAmt = new LinkedHashMap<String, BigDecimal>();
    private Map<Long, BigDecimal> unitCostAmt = new LinkedHashMap<Long, BigDecimal>();
    private Map<String, BigDecimal> entryUnitCostAmt = new LinkedHashMap<String, BigDecimal>();
    private BigDecimal unitActualCost;
    private BigDecimal actualCost;
    private Map<Object, BigDecimal> groupCostAmt = new LinkedHashMap<Object, BigDecimal>();
    private Long exratetable;
    private String convertMode;
    private Long localcurrencyid;
    private Integer amtprecision;
    private Integer priceprecision;
    private int qtyPrecision = 4;
    private long baseUnitId;
    private CostPriceResultInfo priceResult = null;
    private boolean isSrcBill;
    private boolean isDestBill;
    private boolean isCostDetermined = false;
    private Boolean isGroupCostCalculated = null;
    private BigDecimal sign;
    private BigDecimal signnum;
    private String bizEntityObject;
    private Long inCostAdjustEntryId;
    private boolean isGenGroupAdjBill = true;
    private String costDomainId;
    private boolean subbillInvoiceverify;
    private boolean iscalculated;
    private Integer modvalue;
    private BigDecimal addPricePercent;
    private boolean designatedcost;
    private String costpricesource;
    private String srcbillno;
    private String createtype;
    private boolean inventoryTx_ZeroCost;
    private boolean isPresent;
    private int markZero;
    private boolean enableInBillZeroCost = false;
    private String costpriceSourceType;
    private boolean enableJoinCalute;
    private boolean isVoucher;

    public LocalRow(boolean calbycostelement, Map<Long, CostSubElement> elementMap) {
        this.calbycostelement = calbycostelement;
        this.elementMap = elementMap;
    }

    public BigDecimal getCost(Long key) {
        BigDecimal cost = this.costAmt.get(key);
        if (cost == null) {
            cost = BigDecimal.ZERO;
        }
        return cost;
    }

    public BigDecimal getCost(String key) {
        BigDecimal cost = this.entryCostAmt.get(key);
        if (cost == null) {
            cost = BigDecimal.ZERO;
        }
        return cost;
    }

    public BigDecimal getGroupCost(Object elementId) {
        return this.groupCostAmt.get(elementId);
    }

    public Map<Object, BigDecimal> getGroupCostAmtMap() {
        return this.groupCostAmt;
    }

    public void setGroupCost(Object key, BigDecimal cost) {
        this.groupCostAmt.put(key, cost);
    }

    public Map<Long, BigDecimal> getElementCostMap() {
        return this.costAmt;
    }

    public Map<Long, BigDecimal> getElementUnitCostMap() {
        return this.unitCostAmt;
    }

    public Map<String, BigDecimal> getEntryCostMap() {
        return this.entryCostAmt;
    }

    public void setCost(Long key, BigDecimal amt) {
        if (amt == null) {
            this.costAmt.put(key, BigDecimal.ZERO);
            this.getUnitCostAmt().put(key, BigDecimal.ZERO);
            return;
        }
        this.costAmt.put(key, amt.setScale((int)this.amtprecision, RoundingMode.HALF_UP));
        if (this.baseqty.compareTo(BigDecimal.ZERO) == 0) {
            this.getUnitCostAmt().put(key, BigDecimal.ZERO);
        } else {
            this.getUnitCostAmt().put(key, amt.divide(this.baseqty, (int)this.priceprecision, RoundingMode.HALF_UP));
        }
    }

    public void setCost(String key, BigDecimal amt) {
        if (amt == null) {
            this.entryCostAmt.put(key, BigDecimal.ZERO);
            return;
        }
        this.entryCostAmt.put(key, amt.setScale((int)this.amtprecision, RoundingMode.HALF_UP));
    }

    public void setDirectCost(Long key, BigDecimal amt) {
        if (amt == null) {
            this.costAmt.put(key, BigDecimal.ZERO);
            this.getUnitCostAmt().put(key, BigDecimal.ZERO);
            return;
        }
        this.costAmt.put(key, amt.setScale((int)this.amtprecision, RoundingMode.HALF_UP));
    }

    public void setDirectUnitCost(Long key, BigDecimal amt) {
        this.getUnitCostAmt().put(key, amt);
    }

    public void refreshActualCost() {
        this.refreshDirectActualCost();
        this.unitActualCost = this.baseqty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : this.actualCost.divide(this.baseqty, (int)this.priceprecision, RoundingMode.HALF_UP);
    }

    public void refreshDirectActualCost() {
        BigDecimal actualCost = BigDecimal.ZERO;
        if (this.calbycostelement || "2".equals(this.rowtype)) {
            this.entryCostAmt.clear();
            for (Map.Entry<Long, BigDecimal> entry : this.costAmt.entrySet()) {
                Long elementId = entry.getKey();
                BigDecimal cost = entry.getValue();
                String entryCostName = this.elementMap.get(elementId).getEntryCostName();
                BigDecimal entryCost = this.entryCostAmt.get(entryCostName);
                if (entryCost == null) {
                    this.entryCostAmt.put(entryCostName, cost);
                } else {
                    this.entryCostAmt.put(entryCostName, entryCost.add(cost));
                }
                actualCost = actualCost.add(cost);
            }
        } else {
            for (BigDecimal cost : this.entryCostAmt.values()) {
                actualCost = actualCost.add(cost);
            }
            this.costAmt.clear();
            this.unitCostAmt.clear();
            this.setCost(773175233367685120L, actualCost);
        }
        this.actualCost = actualCost.setScale((int)this.amtprecision, RoundingMode.HALF_UP);
    }

    public void refreshDirectActualCostByElement() {
        this.entryCostAmt.clear();
        this.entryUnitCostAmt.clear();
        BigDecimal actualCost = BigDecimal.ZERO;
        for (Map.Entry<Long, BigDecimal> entry : this.costAmt.entrySet()) {
            Long elementId = entry.getKey();
            BigDecimal cost = entry.getValue();
            String entryCostName = this.elementMap.get(elementId).getEntryCostName();
            BigDecimal entryCost = this.entryCostAmt.get(entryCostName);
            if (entryCost == null) {
                this.entryCostAmt.put(entryCostName, cost);
            } else {
                this.entryCostAmt.put(entryCostName, entryCost.add(cost));
            }
            actualCost = actualCost.add(cost);
            BigDecimal entryUnitCost = this.entryUnitCostAmt.get(entryCostName);
            BigDecimal unitCost = this.unitCostAmt.get(elementId);
            if (entryUnitCost == null) {
                this.entryUnitCostAmt.put(entryCostName, unitCost);
                continue;
            }
            this.entryUnitCostAmt.put(entryCostName, entryUnitCost.add(unitCost));
        }
        this.actualCost = actualCost.setScale((int)this.amtprecision, RoundingMode.HALF_UP);
        BigDecimal unitActualCost = BigDecimal.ZERO;
        for (Map.Entry<Long, BigDecimal> entry : this.unitCostAmt.entrySet()) {
            BigDecimal unitCost = entry.getValue();
            unitActualCost = unitActualCost.add(unitCost);
        }
        this.unitActualCost = unitActualCost.setScale((int)this.priceprecision, RoundingMode.HALF_UP);
    }

    public void setActualCost(BigDecimal actualCost, boolean hasSign) {
        if (!hasSign) {
            actualCost = actualCost.multiply(this.sign);
        }
        this.actualCost = actualCost.setScale((int)this.amtprecision, RoundingMode.HALF_UP);
        this.unitActualCost = this.actualCost.divide(this.baseqty, (int)this.priceprecision, RoundingMode.HALF_UP);
    }

    public void setDirectUnitActualCost(BigDecimal untiActualCost) {
        this.unitActualCost = untiActualCost;
    }

    public BigDecimal getUnitCost(Long key) {
        return this.getUnitCostAmt().get(key);
    }

    public BigDecimal getSign() {
        return this.sign;
    }

    public BigDecimal getSignnum() {
        return this.signnum;
    }

    public void setSignnum(BigDecimal signnum) {
        this.signnum = signnum;
    }

    public Long getBizbillid() {
        return this.bizbillid;
    }

    public void setBizbillid(Long bizbillid) {
        this.bizbillid = bizbillid;
    }

    public Long getBizbillentryid() {
        return this.bizbillentryid;
    }

    public void setBizbillentryid(Long bizbillentryid) {
        this.bizbillentryid = bizbillentryid;
    }

    public String getBilltypenum() {
        return this.billtypenum;
    }

    public void setBilltypenum(String billtypenum) {
        this.billtypenum = billtypenum;
    }

    public String getBilltype() {
        return this.billtype;
    }

    public void setBilltype(String billtype) {
        this.billtype = billtype;
    }

    public String getBillnumber() {
        return this.billnumber;
    }

    public void setBillnumber(String billnumber) {
        this.billnumber = billnumber;
    }

    public BigDecimal getUnitActualCost() {
        return this.unitActualCost;
    }

    public int getAmtprecision() {
        return this.amtprecision;
    }

    public void setAmtprecision(int amtprecision) {
        this.amtprecision = amtprecision;
    }

    public int getPriceprecision() {
        return this.priceprecision;
    }

    public void setPriceprecision(int priceprecision) {
        this.priceprecision = priceprecision;
    }

    public BigDecimal getBaseqty() {
        return this.baseqty;
    }

    public void setBaseqty(BigDecimal baseqty) {
        this.baseqty = baseqty;
    }

    public BigDecimal getActualCost() {
        return this.actualCost;
    }

    public Long getEntryId() {
        return this.entryid;
    }

    public void setEntyrId(Long entryid) {
        this.entryid = entryid;
    }

    public Long getHeadid() {
        return this.headid;
    }

    public void setHeadid(Long headid) {
        this.headid = headid;
    }

    public Long getPeriodid() {
        return this.periodid;
    }

    public void setPeriodid(Long periodid) {
        this.periodid = periodid;
    }

    public boolean isPriced() {
        return this.priceResult != null;
    }

    public boolean isCostDetermined() {
        return this.isCostDetermined;
    }

    public void setCostDetermined(boolean isCostDetermined) {
        this.isCostDetermined = isCostDetermined;
    }

    public boolean isVoucher() {
        return this.isVoucher;
    }

    public void setVoucher(boolean isVoucher) {
        this.isVoucher = isVoucher;
    }

    public boolean isSrcBill() {
        return this.isSrcBill;
    }

    public void setSrcBill(boolean isSrcBill) {
        this.isSrcBill = isSrcBill;
    }

    public boolean isDestBill() {
        return this.isDestBill;
    }

    public void setDestBill(boolean isDestBill) {
        this.isDestBill = isDestBill;
    }

    public Boolean isGroupCostCalculated() {
        return this.isGroupCostCalculated;
    }

    public void setGroupCostCalculated(boolean isGroupCostCalculated) {
        if (Boolean.TRUE.equals(this.isGroupCostCalculated)) {
            return;
        }
        this.isGroupCostCalculated = isGroupCostCalculated;
    }

    public String getRowtype() {
        return this.rowtype;
    }

    public void setRowtype(String rowtype) {
        this.rowtype = rowtype;
    }

    public String getQueuetype() {
        return this.queuetype;
    }

    public void setQueuetype(String queuetype) {
        this.queuetype = queuetype;
    }

    public String getCalbilltype() {
        return this.calbilltype;
    }

    public void setCalbilltype(String calbilltype) {
        this.calbilltype = calbilltype;
    }

    public long getLocalcurrencyid() {
        return this.localcurrencyid;
    }

    public void setLocalcurrencyid(long localcurrencyid) {
        this.localcurrencyid = localcurrencyid;
    }

    public Long getExratetable() {
        return this.exratetable;
    }

    public void setExratetable(Long exratetable) {
        this.exratetable = exratetable;
    }

    public String getConvertMode() {
        return this.convertMode;
    }

    public void setConvertMode(String convertMode) {
        this.convertMode = convertMode;
    }

    public boolean isInGroup() {
        return this.isSrcBill || this.isDestBill;
    }

    public BigDecimal getMaterialcost() {
        BigDecimal materialcost = this.entryCostAmt.get("materialcost");
        return materialcost == null ? BigDecimal.ZERO : materialcost;
    }

    public void setMaterialcost(BigDecimal materialcost) {
        this.entryCostAmt.put("materialcost", materialcost);
    }

    public BigDecimal getFee() {
        BigDecimal fee = this.entryCostAmt.get("fee");
        return fee == null ? BigDecimal.ZERO : fee;
    }

    public void setFee(BigDecimal fee) {
        this.entryCostAmt.put("fee", fee);
    }

    public BigDecimal getProcesscost() {
        BigDecimal processcost = this.entryCostAmt.get("processcost");
        return processcost == null ? BigDecimal.ZERO : processcost;
    }

    public void setProcesscost(BigDecimal processcost) {
        this.entryCostAmt.put("processcost", processcost);
    }

    public BigDecimal getManufacturecost() {
        BigDecimal manufacturecost = this.entryCostAmt.get("manufacturecost");
        return manufacturecost == null ? BigDecimal.ZERO : manufacturecost;
    }

    public void setManufacturecost(BigDecimal manufacturecost) {
        this.entryCostAmt.put("manufacturecost", manufacturecost);
    }

    public BigDecimal getResource() {
        BigDecimal resource = this.entryCostAmt.get("resource");
        return resource == null ? BigDecimal.ZERO : resource;
    }

    public void setResource(BigDecimal resource) {
        this.entryCostAmt.put("resource", resource);
    }

    public BigDecimal getUnitMaterialCost() {
        BigDecimal unitMaterialCost = this.entryUnitCostAmt.get("materialcost");
        return unitMaterialCost == null ? BigDecimal.ZERO : unitMaterialCost;
    }

    public BigDecimal getUnitFee() {
        BigDecimal unitFee = this.entryUnitCostAmt.get("fee");
        return unitFee == null ? BigDecimal.ZERO : unitFee;
    }

    public BigDecimal getUnitProcessCost() {
        BigDecimal unitProcessCost = this.entryUnitCostAmt.get("processcost");
        return unitProcessCost == null ? BigDecimal.ZERO : unitProcessCost;
    }

    public BigDecimal getUnitManufactureCost() {
        BigDecimal unitManufactureCost = this.entryUnitCostAmt.get("manufacturecost");
        return unitManufactureCost == null ? BigDecimal.ZERO : unitManufactureCost;
    }

    public BigDecimal getUnitResource() {
        BigDecimal unitResource = this.entryUnitCostAmt.get("resource");
        return unitResource == null ? BigDecimal.ZERO : unitResource;
    }

    public void setSign(BigDecimal sign) {
        this.sign = sign;
    }

    public CostPriceResultInfo getPriceResult() {
        return this.priceResult;
    }

    public boolean isCalbycostelement() {
        return this.calbycostelement;
    }

    public Date getBizDate() {
        return this.bizDate;
    }

    public void setBizDate(Date bizDate) {
        this.bizDate = bizDate;
    }

    public Date getAuditTime() {
        return this.auditTime;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    public void setBizTypeId(Long bizTypeId) {
        this.bizTypeId = bizTypeId;
    }

    public Long getBizTypeId() {
        return this.bizTypeId;
    }

    public void setPriceResult(CostPriceResultInfo priceResult) {
        this.priceResult = priceResult;
        if (priceResult.isSuccess() && !this.isCostDetermined) {
            BigDecimal totalUnitCost = BigDecimal.ZERO;
            for (Map.Entry<Long, BigDecimal> priceEntry : priceResult.getCostSubElementUnitcostMap().entrySet()) {
                Long elementId = priceEntry.getKey();
                BigDecimal unitCost = priceEntry.getValue();
                totalUnitCost = totalUnitCost.add(unitCost);
                this.setDirectUnitCost(elementId, unitCost);
                this.setDirectCost(elementId, unitCost.multiply(this.getBaseqty()).setScale(this.getAmtprecision(), RoundingMode.HALF_UP));
            }
            this.setDirectUnitActualCost(totalUnitCost);
            this.refreshDirectActualCostByElement();
            this.isCostDetermined = true;
        }
    }

    public int getEntrySeq() {
        return this.entrySeq;
    }

    public void setEntrySeq(int entrySeq) {
        this.entrySeq = entrySeq;
    }

    public Map<Long, BigDecimal> getUnitCostAmt() {
        return this.unitCostAmt;
    }

    public int getQtyPrecision() {
        return this.qtyPrecision;
    }

    public void setQtyPrecision(int qtyPrecision) {
        this.qtyPrecision = qtyPrecision;
    }

    public long getBaseUnitId() {
        return this.baseUnitId;
    }

    public void setBaseUnitId(long baseUnitId) {
        this.baseUnitId = baseUnitId;
    }

    public long getCostRecordEntryid() {
        return this.costRecordEntryid;
    }

    public void setCostRecordEntryid(long costRecordEntryid) {
        this.costRecordEntryid = costRecordEntryid;
    }

    public boolean isInitBill() {
        return this.isInitBill;
    }

    public void setInitBill(boolean isInitBill) {
        this.isInitBill = isInitBill;
    }

    public Long getCostaccountid() {
        return this.costaccountid;
    }

    public void setCostaccountid(Long costaccountid) {
        this.costaccountid = costaccountid;
    }

    public boolean isInvTxZeroCost() {
        return this.inventoryTx_ZeroCost;
    }

    public void setInvTxZeroCost(boolean zeroCost) {
        this.inventoryTx_ZeroCost = zeroCost;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public void setPresent(boolean present) {
        this.isPresent = present;
    }

    public int getMarkZero() {
        return this.markZero;
    }

    public void setMarkZero(int markZero) {
        this.markZero = markZero;
    }

    public LocalRow copy() {
        LocalRow copyRow = new LocalRow(this.calbycostelement, this.elementMap);
        copyRow.headid = this.headid;
        copyRow.entryid = this.entryid;
        copyRow.periodid = this.periodid;
        copyRow.rowtype = this.rowtype;
        copyRow.queuetype = this.queuetype;
        copyRow.calbilltype = this.calbilltype;
        copyRow.bizbillid = this.bizbillid;
        copyRow.bizbillentryid = this.bizbillentryid;
        copyRow.billtypenum = this.billtypenum;
        copyRow.billtype = this.billtype;
        copyRow.billnumber = this.billnumber;
        copyRow.calbycostelement = this.calbycostelement;
        copyRow.costaccountid = this.costaccountid;
        copyRow.isInitBill = this.isInitBill;
        copyRow.costRecordEntryid = this.costRecordEntryid;
        copyRow.bizTypeId = this.bizTypeId;
        copyRow.bizDate = this.bizDate;
        copyRow.auditTime = this.auditTime;
        copyRow.entrySeq = this.entrySeq;
        copyRow.baseqty = this.baseqty;
        copyRow.unitActualCost = this.unitActualCost;
        copyRow.actualCost = this.actualCost;
        copyRow.exratetable = this.exratetable;
        copyRow.convertMode = this.convertMode;
        copyRow.localcurrencyid = this.localcurrencyid;
        copyRow.amtprecision = this.amtprecision;
        copyRow.priceprecision = this.priceprecision;
        copyRow.qtyPrecision = this.qtyPrecision;
        copyRow.baseUnitId = this.baseUnitId;
        copyRow.priceResult = this.priceResult;
        copyRow.isSrcBill = this.isSrcBill;
        copyRow.isDestBill = this.isDestBill;
        copyRow.isCostDetermined = this.isCostDetermined;
        copyRow.isGroupCostCalculated = this.isGroupCostCalculated;
        copyRow.sign = this.sign;
        copyRow.signnum = this.signnum;
        copyRow.bizEntityObject = this.bizEntityObject;
        copyRow.inCostAdjustEntryId = this.inCostAdjustEntryId;
        copyRow.isGenGroupAdjBill = this.isGenGroupAdjBill;
        copyRow.costDomainId = this.costDomainId;
        copyRow.subbillInvoiceverify = this.subbillInvoiceverify;
        copyRow.elementMap = new HashMap<Long, CostSubElement>(this.elementMap);
        copyRow.costAmt = new HashMap<Long, BigDecimal>(this.costAmt);
        copyRow.entryCostAmt = new HashMap<String, BigDecimal>(this.entryCostAmt);
        copyRow.unitCostAmt = new HashMap<Long, BigDecimal>(this.unitCostAmt);
        copyRow.entryUnitCostAmt = new HashMap<String, BigDecimal>(this.entryUnitCostAmt);
        copyRow.groupCostAmt = new HashMap<Object, BigDecimal>(this.groupCostAmt);
        copyRow.inventoryTx_ZeroCost = this.inventoryTx_ZeroCost;
        copyRow.isPresent = this.isPresent;
        return copyRow;
    }

    public String getBizEntityObject() {
        return this.bizEntityObject;
    }

    public void setBizEntityObject(String bizEntityObject) {
        this.bizEntityObject = bizEntityObject;
    }

    public Long getInCostAdjustEntryId() {
        return this.inCostAdjustEntryId;
    }

    public void setInCostAdjustEntryId(Long inCostAdjustEntryId) {
        this.inCostAdjustEntryId = inCostAdjustEntryId;
    }

    public boolean isGenGroupAdjBill() {
        return this.isGenGroupAdjBill;
    }

    public void setGenGroupAdjBill(boolean isGenGroupAdjBill) {
        this.isGenGroupAdjBill = isGenGroupAdjBill;
    }

    public String getCostDomainId() {
        return this.costDomainId;
    }

    public void setCostDomainId(String costDomainId) {
        this.costDomainId = costDomainId;
    }

    public boolean isSubbillInvoiceverify() {
        return this.subbillInvoiceverify;
    }

    public void setSubbillInvoiceverify(boolean subbillInvoiceverify) {
        this.subbillInvoiceverify = subbillInvoiceverify;
    }

    public boolean iscalculated() {
        return this.iscalculated;
    }

    public void setIscalculated(boolean iscalculated) {
        this.iscalculated = iscalculated;
    }

    public Integer getModvalue() {
        return this.modvalue;
    }

    public void setModvalue(Integer modvalue) {
        this.modvalue = modvalue;
    }

    public boolean isEnableInBillZeroCost() {
        return this.enableInBillZeroCost;
    }

    public void setEnableInBillZeroCost(boolean enableInBillZeroCost) {
        this.enableInBillZeroCost = enableInBillZeroCost;
    }

    public boolean isDesignatedcost() {
        return this.designatedcost;
    }

    public void setDesignatedcost(boolean designatedcost) {
        this.designatedcost = designatedcost;
    }

    public String getCostpricesource() {
        return this.costpricesource;
    }

    public void setCostpricesource(String costpricesource) {
        this.costpricesource = costpricesource;
    }

    public String getSrcbillno() {
        return this.srcbillno;
    }

    public void setSrcbillno(String srcbillno) {
        this.srcbillno = srcbillno;
    }

    public String getCreatetype() {
        return this.createtype;
    }

    public void setCreatetype(String createtype) {
        this.createtype = createtype;
    }

    public String getCostpriceSourceType() {
        return this.costpriceSourceType;
    }

    public void setCostpriceSourceType(String costpriceSourceType) {
        this.costpriceSourceType = costpriceSourceType;
    }

    public boolean isEnableJoinCalute() {
        return this.enableJoinCalute;
    }

    public void setEnableJoinCalute(boolean enableJoinCalute) {
        this.enableJoinCalute = enableJoinCalute;
    }

    public void setAddPricePercent(BigDecimal addPricePercent) {
        this.addPricePercent = addPricePercent;
    }

    public BigDecimal getAddPricePercent() {
        return this.addPricePercent;
    }
}

