/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.accounttype;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.calx.algox.CostPriceResultInfo;
import kd.fi.calx.algox.CostSubElement;
import kd.fi.calx.algox.accounttype.AbstractAccountType;
import kd.fi.calx.algox.accounttype.CostAdjustInfo;
import kd.fi.calx.algox.accounttype.LocalRow;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.constant.CostAdjustBilCreateTypeEnum;
import kd.fi.calx.algox.constant.CostPriceSourceTypeEnum;
import kd.fi.calx.algox.function.AccountTypeContext;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.helper.CostPriceSourceTypeHelper;
import kd.fi.calx.algox.helper.PrevCostAdjustHelper;
import kd.fi.calx.algox.report.RptStatus;

public class MovedAvgIntimeAT
extends AbstractAccountType {
    protected static Log LOG = LogFactory.getLog(MovedAvgIntimeAT.class);
    private static final long serialVersionUID = -6210517757509318916L;
    private BigDecimal currentUnitCost = BigDecimal.ZERO;
    private Map<Long, BigDecimal> currentElementUnitCost = new HashMap<Long, BigDecimal>();
    private boolean hasPriceFailed = false;
    private Map<Long, BigDecimal> outAdjustCostMap = new HashMap<Long, BigDecimal>();
    private boolean inBillAllAmtZero = true;
    private boolean inBillAllQtyZero = true;
    private boolean curUnitCostZero = false;
    private boolean curUnitCostNegative = false;

    public boolean isInBillAllAmtZero() {
        return this.inBillAllAmtZero;
    }

    public void setInBillAllAmtZero(boolean inBillAllAmtZero) {
        this.inBillAllAmtZero = inBillAllAmtZero;
    }

    public boolean isInBillAllQtyZero() {
        return this.inBillAllQtyZero;
    }

    public void setInBillAllQtyZero(boolean inBillAllQtyZero) {
        this.inBillAllQtyZero = inBillAllQtyZero;
    }

    public MovedAvgIntimeAT(AccountTypeContext ctx, DataSet dataSet, int runningMode) {
        super(ctx, dataSet, runningMode);
    }

    @Override
    protected String[] getOrderByField() {
        String orderModel = CalDbParamServiceHelper.getString(CalDbParamConstant.CALCMOVE_ORDER_MODEL, null);
        if ("A".equals(orderModel)) {
            return new String[]{"bizdate", "auditdate", "bizbillentryid", "queuetype desc", "entryid", "grouptype desc"};
        }
        return new String[]{"auditdate", "bizbillentryid", "queuetype desc", "id", "entryid", "grouptype desc"};
    }

    @Override
    protected void calculateOut(LocalRow row) {
        String currentRowType = row.getQueuetype();
        this.addQtyAmtMark(row);
        if ("0".equals(currentRowType)) {
            this.calInQueueCost(row);
        } else {
            this.calOutQueueCost(row);
        }
    }

    protected void addQtyAmtMark(LocalRow row) {
        if ("0".equals(row.getQueuetype()) && !"2".equals(row.getRowtype())) {
            BigDecimal qty;
            BigDecimal amt = row.getActualCost() == null ? BigDecimal.ZERO : row.getActualCost();
            BigDecimal bigDecimal = qty = row.getBaseqty() == null ? BigDecimal.ZERO : row.getBaseqty();
            if (BigDecimal.ZERO.compareTo(amt) != 0) {
                this.setInBillAllAmtZero(false);
            }
            if (BigDecimal.ZERO.compareTo(qty) != 0) {
                this.setInBillAllQtyZero(false);
            }
        }
    }

    @Override
    protected void beforeCalculated() {
        BigDecimal totalQty = this.getCurrentTotalQty();
        BigDecimal totalCost = this.getCurrentTotalCost();
        this.currentUnitCost = totalQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : totalCost.divide(totalQty, 10, RoundingMode.HALF_UP);
        for (Map.Entry<Long, BigDecimal> entry : this.getElementTotalCostMap().entrySet()) {
            this.currentElementUnitCost.put(entry.getKey(), totalQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : entry.getValue().divide(totalQty, 10, RoundingMode.HALF_UP));
        }
        new PrevCostAdjustHelper().dealAllDataSet(this.dataSet, this.getCalOrgId(), this.getCostAccountId(), this.outAdjustCostMap, this.getAmtPrecision());
    }

    private void calInQueueCost(LocalRow row) {
        if ("2".equals(row.getRowtype())) {
            this.joinCalculate(row, null, null);
            CostAdjustInfo prevCostBill = this.addPrevCostBillCostAdjustInfo(row);
            this.joinCalculate(prevCostBill);
            return;
        }
        if (row.isCostDetermined()) {
            if (2 == this.getRunningMode()) {
                row.setCostpriceSourceType(CostPriceSourceTypeEnum.getLastByCostPriceSource(row.getCostpricesource()));
            }
            this.joinCalculate(row, null, null);
            if (row.isDestBill()) {
                this.tempInGroupRow.add(row);
            }
        } else if (row.isDestBill()) {
            if (row.isGroupCostCalculated().booleanValue()) {
                CostPriceSourceTypeHelper.setCostpriceSourceByGroup(row, this.ctx.enableCoverdesigoutcost());
                this.joinCalculate(row, null, null);
                this.addCostUpdateInfo(row);
                CostAdjustInfo costAdjustInfo = this.addGroupBillCostAdjustInfo(row);
                if (costAdjustInfo != null) {
                    this.joinCalculate(costAdjustInfo);
                }
            } else if (row.isPriced()) {
                CostPriceResultInfo priceResult = row.getPriceResult();
                if (priceResult.isSuccess()) {
                    row.setCostpriceSourceType(CostPriceSourceTypeEnum.GET_COST_SPECIFICATION.getValue());
                    this.addCostUpdateInfo(row);
                    this.tempInGroupRow.add(row);
                }
                this.joinCalculate(row, null, null);
            } else {
                this.tempInGroupRow.add(row);
            }
        } else {
            this.joinCalculate(row, null, null);
        }
        if (row.isDestBill() && row.isGroupCostCalculated().booleanValue() || row.isPriced() && row.getPriceResult().isSuccess()) {
            this.addCostUpdateInfo(row);
        }
    }

    protected final CostAdjustInfo addPrevCostBillCostAdjustInfo(LocalRow row) {
        if (!this.outAdjustCostMap.containsKey(row.getEntryId())) {
            return null;
        }
        String callBillType = "B";
        CostAdjustInfo adjustInfo = null;
        BigDecimal oldAdjustCost = row.getActualCost();
        BigDecimal outAdjustCost = this.outAdjustCostMap.get(row.getEntryId());
        if (outAdjustCost.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        Map<Long, BigDecimal> elementCostMap = row.getElementCostMap();
        adjustInfo = this.createCostAdjustInfo(row, callBillType, "V", null);
        for (Map.Entry<Long, BigDecimal> entry : elementCostMap.entrySet()) {
            BigDecimal oldSubCost = entry.getValue();
            BigDecimal outSubCost = oldSubCost.divide(oldAdjustCost, 10, RoundingMode.HALF_UP).multiply(outAdjustCost).setScale(row.getAmtprecision(), RoundingMode.HALF_UP);
            elementCostMap.put(entry.getKey(), outSubCost);
            adjustInfo.setAdjustCost(this.getElementMap().get(entry.getKey()), outSubCost);
        }
        return adjustInfo;
    }

    private void calOutQueueCost(LocalRow row) {
        if ("2".equals(row.getRowtype())) {
            this.joinCalculate(row, null, null);
            return;
        }
        if (row.isCostDetermined()) {
            if (2 == this.getRunningMode()) {
                row.setCostpriceSourceType(CostPriceSourceTypeEnum.getLastByCostPriceSource(row.getCostpricesource()));
            }
            this.joinCalculate(row, null, null);
            if (row.isDestBill()) {
                this.tempInGroupRow.add(row);
            }
            return;
        }
        if (row.isDestBill()) {
            if (row.isGroupCostCalculated().booleanValue()) {
                CostPriceSourceTypeHelper.setCostpriceSourceByGroup(row, this.ctx.enableCoverdesigoutcost());
                this.joinCalculate(row, null, null);
                this.addCostUpdateInfo(row);
                CostAdjustInfo costAdjustInfo = this.addGroupBillCostAdjustInfo(row);
                if (costAdjustInfo != null) {
                    this.joinCalculate(costAdjustInfo);
                }
            } else {
                this.tempInGroupRow.add(row);
            }
            return;
        }
        BigDecimal qty = row.getBaseqty();
        BigDecimal currentTotalQty = this.getCurrentTotalQty();
        if (this.currentUnitCost.compareTo(BigDecimal.ZERO) == 0 && currentTotalQty.compareTo(BigDecimal.ZERO) == 0 && !row.isInvTxZeroCost() && (!this.isBeginAmtAllZero() || !this.isInBillAllAmtZero() || this.getBeginPrice() == 0 && this.isBeginQtyAllZero())) {
            if (this.ctx.enableZeroPrice()) {
                CostPriceResultInfo priceInfo = this.getCostPrice(row.getHeadid(), row.getEntryId(), row.getRowtype(), "E");
                this.joinCalRpt(ResManager.loadKDString((String)"\u96f6\u5355\u4ef7\u53d6\u4ef7\u7ed3\u679c", (String)"WeightedAvgAT_5", (String)"fi-calx-algox", (Object[])new Object[0]), priceInfo, row);
                this.joinCalculate(row, null, priceInfo);
                row.setGroupCostCalculated(true);
                this.addCostUpdateInfo(row);
                return;
            }
            this.curUnitCostZero = true;
        }
        if (this.currentUnitCost.compareTo(BigDecimal.ZERO) < 0) {
            if (this.ctx.enableBalanceNeg()) {
                CostPriceResultInfo priceInfo = this.getCostPrice(row.getHeadid(), row.getEntryId(), row.getRowtype(), "H");
                this.joinCalRpt(ResManager.loadKDString((String)"\u8d1f\u5355\u4ef7\u53d6\u4ef7\u7ed3\u679c", (String)"MovedAvgIntimeAT_0", (String)"fi-calx-algox", (Object[])new Object[0]), priceInfo, row);
                DynamicObject costAdjustOutBillType = (DynamicObject)this.ctx.getParamCache().getParamValue("costAdjustOutBillType");
                CostAdjustInfo adjustInfo = this.createCostAdjustInfo(row, "B", "N", costAdjustOutBillType);
                for (Map.Entry<Long, BigDecimal> priceEntry : priceInfo.getCostSubElementUnitcostMap().entrySet()) {
                    Long elementId = priceEntry.getKey();
                    BigDecimal newUnitCost = priceEntry.getValue();
                    BigDecimal adjustUnitCost = this.currentElementUnitCost.get(elementId).subtract(newUnitCost);
                    adjustInfo.setAdjustCost(this.getElementMap().get(elementId), adjustUnitCost.multiply(currentTotalQty).setScale(row.getAmtprecision(), RoundingMode.HALF_UP));
                }
                this.joinCalculate(adjustInfo);
            } else {
                this.curUnitCostNegative = true;
            }
        }
        boolean designatedcost = row.isDesignatedcost();
        boolean coverdesigoutcost = this.ctx.enableCoverdesigoutcost();
        if (!designatedcost || designatedcost && coverdesigoutcost) {
            for (Map.Entry<Long, BigDecimal> entry : this.currentElementUnitCost.entrySet()) {
                Long elementId = entry.getKey();
                BigDecimal totalCost = this.getElementTotalCost(elementId);
                BigDecimal unitCost = entry.getValue();
                row.setDirectUnitCost(entry.getKey(), unitCost);
                if (qty.compareTo(currentTotalQty) == 0) {
                    row.setDirectCost(entry.getKey(), totalCost);
                    continue;
                }
                row.setDirectCost(elementId, unitCost.multiply(qty).setScale(this.getAmtPrecision(), RoundingMode.HALF_UP));
            }
        }
        row.refreshDirectActualCostByElement();
        this.joinCalculate(row, null, null);
        row.setGroupCostCalculated(true);
        this.addCostUpdateInfo(row);
    }

    private void joinCalRpt(String description, CostPriceResultInfo priceInfo, LocalRow row) {
        if (!priceInfo.isSuccess()) {
            this.hasPriceFailed = true;
        }
        int index = this.holder.createNewEntry();
        this.holder.setBillType(index, description);
        if (!priceInfo.isSuccess()) {
            this.holder.setInFormula(index, priceInfo.getErrMsg());
        } else {
            row.setCostpriceSourceType(CostPriceSourceTypeEnum.GET_COST_SPECIFICATION.getValue());
            row.setSrcbillno(priceInfo.getSrcPriceName() + priceInfo.getSrcBillno());
            this.holder.setInFormula(index, this.toBigDecimalString(priceInfo.getTotalUnitCost().setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
            for (Map.Entry<Long, BigDecimal> priceEntry : priceInfo.getCostSubElementUnitcostMap().entrySet()) {
                int subIndex = this.holder.createNewSubEntry(index, this.getElementMap().get(priceEntry.getKey()).getName());
                this.holder.setInFormula(subIndex, priceInfo.getSrcPriceName() + ":" + this.toBigDecimalString(priceEntry.getValue().setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
            }
        }
    }

    private void joinCalculate(LocalRow row, String exDescription, CostPriceResultInfo priceInfo) {
        boolean bl;
        BigDecimal unitCost;
        String createtype;
        int index = this.holder.createNewEntry(row);
        String costpricesource = row.getCostpricesource();
        String billtypestr = row.getBilltype();
        String costpriceSourceType = row.getCostpriceSourceType();
        boolean vouStr = false;
        String srcBillNo = null;
        boolean isGroupCost = false;
        boolean designatedcost = row.isDesignatedcost();
        String calbilltype = row.getCalbilltype();
        boolean coverdesigoutcost = this.ctx.enableCoverdesigoutcost();
        if ("1".equals(row.getRowtype())) {
            String msg;
            String costPriceSourceStr;
            if (row.isVoucher()) {
                vouStr = true;
            }
            if (StringUtils.isNotEmpty((CharSequence)costpricesource) && StringUtils.isNotEmpty((CharSequence)(costPriceSourceStr = CostPriceSourceTypeEnum.getLastByCostPriceSource(costpricesource))) && CostPriceSourceTypeEnum.GROUP_COST_SPECIFICATION.getValue().equals(costPriceSourceStr) && row.isDestBill()) {
                srcBillNo = row.getSrcbillno();
                isGroupCost = true;
            }
            if (StringUtils.isNotEmpty((CharSequence)costpriceSourceType) && CostPriceSourceTypeEnum.GET_COST_SPECIFICATION.getValue().equals(costpriceSourceType) && (!designatedcost || designatedcost && coverdesigoutcost)) {
                srcBillNo = row.getSrcbillno();
            }
            if (vouStr && srcBillNo != null) {
                String msg2 = null;
                msg2 = isGroupCost ? String.format(ResManager.loadKDString((String)"%1$s(\u5df2\u751f\u6210\u51ed\u8bc1,\u6765\u6e90\u5355\u53f7\uff1a%2$s)", (String)"CalculateOutCostPlugin_32", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr, srcBillNo) : String.format(ResManager.loadKDString((String)"%1$s(\u5df2\u751f\u6210\u51ed\u8bc1,%2$s)", (String)"CalculateOutCostPlugin_35", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr, srcBillNo);
                billtypestr = msg2;
            } else if (vouStr && srcBillNo == null) {
                billtypestr = msg = String.format(ResManager.loadKDString((String)"%1$s(\u5df2\u751f\u6210\u51ed\u8bc1)", (String)"CalculateOutCostPlugin_33", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr);
            } else if (!vouStr && srcBillNo != null) {
                msg = null;
                msg = isGroupCost ? String.format(ResManager.loadKDString((String)"%1$s(\u6765\u6e90\u5355\u53f7\uff1a%2$s)", (String)"CalculateOutCostPlugin_34", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr, srcBillNo) : String.format(ResManager.loadKDString((String)"%1$s(%2$s)", (String)"CalculateOutCostPlugin_36", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr, srcBillNo);
                billtypestr = msg;
            }
            this.holder.setBillType(index, billtypestr);
        }
        if ("2".equals(row.getRowtype()) && StringUtils.isNotEmpty((CharSequence)(createtype = row.getCreatetype()))) {
            this.holder.setDescribe(index, CostAdjustBilCreateTypeEnum.getEnumDesc(createtype));
            if (row.isVoucher()) {
                String string = String.format(ResManager.loadKDString((String)"%1$s(\u5df2\u751f\u6210\u51ed\u8bc1)", (String)"CalculateOutCostPlugin_33", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr);
                this.holder.setBillType(index, string);
            }
        }
        if (exDescription != null) {
            this.holder.setBillType(index, row.getBilltype() + exDescription);
        } else {
            Iterator<Map.Entry<Long, BigDecimal>> curBillType = "";
            if (row.isPriced()) {
                CostPriceResultInfo costPriceResultInfo = row.getPriceResult();
                if (costPriceResultInfo.isSuccess()) {
                    row.setCostpriceSourceType(CostPriceSourceTypeEnum.GET_COST_SPECIFICATION.getValue());
                    curBillType = billtypestr + "(" + costPriceResultInfo.getSrcPriceName() + ")";
                    this.holder.setBillType(index, (String)((Object)curBillType));
                } else {
                    this.holder.setBillType(index, row.getBilltype() + "(" + costPriceResultInfo.getErrMsg() + ")");
                }
            }
        }
        if (priceInfo != null && priceInfo.isSuccess()) {
            row.setCostpriceSourceType(CostPriceSourceTypeEnum.GET_COST_SPECIFICATION.getValue());
            if (!designatedcost || designatedcost && coverdesigoutcost) {
                this.currentUnitCost = priceInfo.getTotalUnitCost();
                for (Map.Entry entry : priceInfo.getCostSubElementUnitcostMap().entrySet()) {
                    this.currentElementUnitCost.put((Long)entry.getKey(), (BigDecimal)entry.getValue());
                }
                for (Map.Entry<Long, BigDecimal> entry : this.currentElementUnitCost.entrySet()) {
                    Long elementId = entry.getKey();
                    BigDecimal unitCost2 = entry.getValue();
                    row.setDirectUnitCost(entry.getKey(), unitCost2);
                    row.setDirectCost(elementId, unitCost2.multiply(row.getBaseqty()).setScale(this.getAmtPrecision(), RoundingMode.HALF_UP));
                }
                row.refreshDirectActualCostByElement();
            }
        }
        if (!(row.isDestBill() && row.isGroupCostCalculated().booleanValue() || row.isCostDetermined())) {
            Map<Long, BigDecimal> elementCostMap;
            if ("0".equals(row.getRowtype())) {
                if (row.isPresent()) {
                    elementCostMap = row.getElementCostMap();
                    for (Long element : elementCostMap.keySet()) {
                        elementCostMap.put(element, BigDecimal.ZERO);
                        row.setDirectCost(element, BigDecimal.ZERO);
                        row.setDirectUnitCost(element, BigDecimal.ZERO);
                    }
                    row.setDirectUnitActualCost(BigDecimal.ZERO);
                    row.setActualCost(BigDecimal.ZERO, Boolean.TRUE);
                    row.refreshDirectActualCostByElement();
                    row.setCostpriceSourceType(CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getValue());
                    String string = String.format(ResManager.loadKDString((String)"%1$s(\u8d60\u54c1)", (String)"WeightedAvgAT_15", (String)"fi-calx-algox", (Object[])new Object[0]), row.getBilltype());
                    this.holder.setBillType(index, string);
                }
            } else if ((row.isInvTxZeroCost() || row.isEnableInBillZeroCost() && this.isInBillAllAmtZero()) && "1".equals(row.getRowtype())) {
                row.setDirectUnitActualCost(BigDecimal.ZERO);
                elementCostMap = row.getElementCostMap();
                for (Long element : elementCostMap.keySet()) {
                    elementCostMap.put(element, BigDecimal.ZERO);
                    row.setDirectCost(element, BigDecimal.ZERO);
                    row.setDirectUnitCost(element, BigDecimal.ZERO);
                }
                row.setDirectUnitActualCost(BigDecimal.ZERO);
                row.setActualCost(BigDecimal.ZERO, Boolean.TRUE);
                row.refreshDirectActualCostByElement();
                row.setCostpriceSourceType(CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getValue());
                if (row.isInvTxZeroCost()) {
                    String string = String.format(ResManager.loadKDString((String)"%1$s(\u96f6\u6210\u672c)", (String)"WeightedAvgAT_14", (String)"fi-calx-algox", (Object[])new Object[0]), row.getBilltype());
                    this.holder.setBillType(index, string);
                }
            }
        }
        if ("1".equals(row.getRowtype())) {
            CostPriceSourceTypeEnum.setDescribeByCostpricesource(row, coverdesigoutcost, this.holder, index, null);
        }
        StringBuilder formula = new StringBuilder();
        BigDecimal bigDecimal = this.getCurrentTotalQty();
        BigDecimal currentTotalCost = this.getCurrentTotalCost();
        formula.append(this.toBigDecimalString(bigDecimal.setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
        formula.append('*');
        BigDecimal tempUnitCost = bigDecimal.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : currentTotalCost.divide(bigDecimal, 10, RoundingMode.HALF_UP);
        formula.append(this.toBigDecimalString(tempUnitCost.setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
        formula.append('=');
        formula.append(this.toBigDecimalString(currentTotalCost.setScale(row.getAmtprecision(), RoundingMode.HALF_UP)));
        formula.append('\n');
        this.holder.setBalanceFormula(index, formula.toString());
        Map<Long, CostSubElement> elementMap = this.getElementMap();
        HashMap<Long, Integer> subIndexMap = new HashMap<Long, Integer>(elementMap.size());
        for (Map.Entry<Long, CostSubElement> entry : elementMap.entrySet()) {
            Long l = entry.getKey();
            BigDecimal elementCost = row.getCost(l);
            BigDecimal elementTotalCost = this.getElementTotalCostMap().get(l);
            if (priceInfo == null && elementCost.compareTo(BigDecimal.ZERO) == 0 && elementTotalCost.compareTo(BigDecimal.ZERO) == 0) continue;
            int subIndex = this.holder.createNewSubEntry(index, entry.getValue().getName());
            formula.setLength(0);
            formula.append(this.toBigDecimalString(row.getCost(l).setScale(row.getAmtprecision(), RoundingMode.HALF_UP)));
            if ("0".equals(row.getQueuetype())) {
                this.holder.setInFormula(subIndex, formula.toString());
            } else {
                this.holder.setOutFormula(subIndex, formula.toString());
            }
            formula.setLength(0);
            formula.append(this.toBigDecimalString(bigDecimal.setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
            formula.append('*');
            formula.append(bigDecimal.compareTo(BigDecimal.ZERO) == 0 ? this.toBigDecimalString(BigDecimal.ZERO.setScale(this.getPricePrecision(), RoundingMode.HALF_UP)) : this.toBigDecimalString(elementTotalCost.divide(bigDecimal, this.getPricePrecision(), RoundingMode.HALF_UP)));
            formula.append('=');
            formula.append(this.toBigDecimalString(elementTotalCost.setScale(row.getAmtprecision(), RoundingMode.HALF_UP)));
            formula.append('\n');
            this.holder.setBalanceFormula(subIndex, formula.toString());
            subIndexMap.put(l, subIndex);
        }
        formula.setLength(0);
        formula.append(this.toBigDecimalString(row.getBaseqty().setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
        formula.append('*');
        formula.append(this.toBigDecimalString(row.getUnitActualCost().setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
        formula.append('=');
        formula.append(this.toBigDecimalString(row.getActualCost().setScale(row.getAmtprecision(), RoundingMode.HALF_UP)));
        if ("0".equals(row.getQueuetype())) {
            this.holder.setInFormula(index, formula.toString());
        } else {
            this.holder.setOutFormula(index, formula.toString());
        }
        if ("0".equals(row.getQueuetype())) {
            this.sumToTotal(row);
            this.zeroInClearUnitCost(row);
        } else {
            this.substractToTotal(row);
        }
        formula.setLength(0);
        currentTotalCost = this.getCurrentTotalCost();
        BigDecimal bigDecimal2 = this.getCurrentTotalQty();
        BigDecimal bigDecimal3 = unitCost = bigDecimal2.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : currentTotalCost.divide(bigDecimal2, 10, RoundingMode.HALF_UP);
        if (bigDecimal2.compareTo(BigDecimal.ZERO) > 0) {
            this.currentUnitCost = unitCost;
        }
        formula.append(this.toBigDecimalString(bigDecimal2.setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
        formula.append('*');
        formula.append(this.toBigDecimalString(unitCost.setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
        formula.append('=');
        formula.append(this.toBigDecimalString(currentTotalCost.setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
        this.holder.appendBalanceFormula(index, formula.toString());
        for (Map.Entry entry : subIndexMap.entrySet()) {
            BigDecimal elementUnitCost;
            formula.setLength(0);
            BigDecimal elementTotalCost = this.getElementTotalCostMap().get(entry.getKey());
            BigDecimal bigDecimal4 = elementUnitCost = bigDecimal2.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : elementTotalCost.divide(bigDecimal2, 10, RoundingMode.HALF_UP);
            if (bigDecimal2.compareTo(BigDecimal.ZERO) > 0) {
                this.currentElementUnitCost.put((Long)entry.getKey(), elementUnitCost);
            }
            formula.append(this.toBigDecimalString(bigDecimal2.setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
            formula.append('*');
            formula.append(this.toBigDecimalString(elementUnitCost.setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
            formula.append('=');
            formula.append(this.toBigDecimalString(elementTotalCost.setScale(row.getAmtprecision(), RoundingMode.HALF_UP)));
            this.holder.appendBalanceFormula((Integer)entry.getValue(), formula.toString());
        }
        boolean bl2 = bl = row.getRowtype().equals("2") && this.outAdjustCostMap.containsKey(row.getEntryId());
        if (!bl && this.isLastRow) {
            this.dealSpCondition(row);
        }
        if (this.neg2pos) {
            DynamicObject dynamicObject = (DynamicObject)this.ctx.getParamCache().getParamValue("costAdjustOutBillType");
            CostAdjustInfo adjustInfo = this.createCostAdjustInfo(row, "B", "N", dynamicObject);
            boolean notZeroAmt = false;
            for (Long elementId : this.getElementMap().keySet()) {
                BigDecimal elementUnitCost = row.getElementUnitCostMap().get(elementId);
                elementUnitCost = elementUnitCost == null ? BigDecimal.ZERO : elementUnitCost;
                BigDecimal expectCost = elementUnitCost.multiply(bigDecimal2).setScale(row.getAmtprecision(), RoundingMode.HALF_UP);
                BigDecimal currcntElementCost = this.getElementTotalCost(elementId);
                BigDecimal adjustamt = currcntElementCost.subtract(expectCost);
                adjustInfo.setAdjustCost(this.getElementMap().get(elementId), adjustamt);
                notZeroAmt = notZeroAmt || adjustamt.compareTo(BigDecimal.ZERO) != 0;
            }
            if (notZeroAmt) {
                this.joinCalculate(adjustInfo);
            } else {
                adjustInfo.setEmptyEntry(true);
            }
            this.neg2pos = false;
        }
    }

    private void zeroInClearUnitCost(LocalRow row) {
        boolean inQtyNotZero = row.getBaseqty().compareTo(BigDecimal.ZERO) != 0;
        Map<Long, BigDecimal> elementCostMap = row.getElementCostMap();
        boolean allEleCostIsZero = true;
        for (Map.Entry<Long, BigDecimal> entry : elementCostMap.entrySet()) {
            if (entry.getValue().compareTo(BigDecimal.ZERO) == 0) continue;
            allEleCostIsZero = false;
            break;
        }
        if (inQtyNotZero && allEleCostIsZero) {
            for (Map.Entry<Long, BigDecimal> entry : this.currentElementUnitCost.entrySet()) {
                this.currentUnitCost = BigDecimal.ZERO;
                entry.setValue(BigDecimal.ZERO);
            }
        }
    }

    private void dealSpCondition(LocalRow row) {
        String creatediffbilltype = this.getCreateDiffBillType();
        if ("no".equals(creatediffbilltype)) {
            return;
        }
        CostAdjustInfo adjustInfo = null;
        BigDecimal currentTotalQty = this.getCurrentTotalQty();
        BigDecimal currentTotalCost = this.getCurrentTotalCost();
        if (currentTotalQty.compareTo(BigDecimal.ZERO) == 0 && currentTotalCost.compareTo(BigDecimal.ZERO) != 0) {
            DynamicObject costAdjustOutBillType = (DynamicObject)this.ctx.getParamCache().getParamValue("costAdjustOutBillType");
            adjustInfo = this.createCostAdjustInfo(row, "B", "N", costAdjustOutBillType);
            for (Map.Entry<Long, BigDecimal> entry : this.getElementTotalCostMap().entrySet()) {
                BigDecimal totalCost = entry.getValue();
                Long elementId = entry.getKey();
                adjustInfo.setAdjustCost(this.getElementMap().get(elementId), totalCost);
            }
            this.joinCalculate(adjustInfo);
        }
    }

    @Override
    protected final String getEndErrorMsg() {
        if (this.hasPriceFailed) {
            return ResManager.loadKDString((String)"\u5b58\u5728\u53d6\u4ef7\u5931\u8d25\u7684\u573a\u666f\uff0c\u7ed3\u8f6c\u5931\u8d25\u3002", (String)"MovedAvgIntimeAT_2", (String)"fi-calx-algox", (Object[])new Object[0]);
        }
        if (this.curUnitCostZero) {
            return ResManager.loadKDString((String)"\u5b58\u5728\u5373\u65f6\u96f6\u5355\u4ef7\uff0c\u7ed3\u8f6c\u5931\u8d25", (String)"MovedAvgIntimeAT_5", (String)"fi-calx-algox", (Object[])new Object[0]);
        }
        if (this.curUnitCostNegative) {
            return ResManager.loadKDString((String)"\u5b58\u5728\u5373\u65f6\u8d1f\u5355\u4ef7\uff0c\u7ed3\u8f6c\u5931\u8d25", (String)"MovedAvgIntimeAT_6", (String)"fi-calx-algox", (Object[])new Object[0]);
        }
        return super.getEndErrorMsg();
    }

    private void joinCalculate(CostAdjustInfo adjustInfo) {
        BigDecimal unitCost;
        if (adjustInfo == null) {
            return;
        }
        int index = this.holder.createNewEntry(adjustInfo);
        StringBuilder formula = new StringBuilder();
        formula.append(this.toBigDecimalString(BigDecimal.ZERO.setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
        formula.append('*');
        formula.append(this.toBigDecimalString(BigDecimal.ZERO.setScale(this.getPricePrecision())));
        formula.append('=');
        formula.append(this.toBigDecimalString(adjustInfo.getAdjustAmt().setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
        if ("A".equals(adjustInfo.getCallBillType())) {
            this.holder.setInFormula(index, formula.toString());
        } else {
            this.holder.setOutFormula(index, formula.toString());
        }
        String invbillnum = CostPriceSourceTypeEnum.getCostAdjuestInvbillNum(adjustInfo);
        if (!StringUtils.isEmpty((CharSequence)invbillnum)) {
            String msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355(\u5bf9\u5e94\u5e93\u5b58\u5355\u636e\u53f7\uff1a%1$s)", (String)"MoveAddAverageCalculate_14", (String)"fi-calx-algox", (Object[])new Object[0]), invbillnum);
            this.holder.setBillType(index, msg);
        }
        formula.setLength(0);
        BigDecimal currentTotalQty = this.getCurrentTotalQty();
        BigDecimal currentTotalCost = this.getCurrentTotalCost();
        formula.append(this.toBigDecimalString(currentTotalQty.setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
        formula.append('*');
        BigDecimal tempUnitCost = currentTotalQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : currentTotalCost.divide(currentTotalQty, 10, RoundingMode.HALF_UP);
        formula.append(this.toBigDecimalString(tempUnitCost.setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
        formula.append('=');
        formula.append(this.toBigDecimalString(currentTotalCost.setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
        formula.append('\n');
        this.holder.setBalanceFormula(index, formula.toString());
        Map<Long, CostSubElement> elementMap = this.getElementMap();
        HashMap<Long, Integer> subIndexMap = new HashMap<Long, Integer>(elementMap.size());
        for (Map.Entry<Long, CostSubElement> entry : elementMap.entrySet()) {
            Long elementId = entry.getKey();
            BigDecimal elementCost = adjustInfo.getAdjustCost(elementId);
            BigDecimal elementTotalCost = this.getElementTotalCostMap().get(elementId);
            if (elementCost.compareTo(BigDecimal.ZERO) == 0 && elementTotalCost.compareTo(BigDecimal.ZERO) == 0) continue;
            int subIndex = this.holder.createNewSubEntry(index, entry.getValue().getName());
            formula.setLength(0);
            formula.append(this.toBigDecimalString(adjustInfo.getAdjustCost(elementId).setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
            if ("A".equals(adjustInfo.getCallBillType())) {
                this.holder.setInFormula(subIndex, formula.toString());
            } else {
                this.holder.setOutFormula(subIndex, formula.toString());
            }
            formula.setLength(0);
            formula.append(this.toBigDecimalString(currentTotalQty.setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
            formula.append('*');
            formula.append(currentTotalQty.compareTo(BigDecimal.ZERO) == 0 ? this.toBigDecimalString(BigDecimal.ZERO.setScale(this.getPricePrecision(), RoundingMode.HALF_UP)) : this.toBigDecimalString(elementTotalCost.divide(currentTotalQty, this.getPricePrecision(), RoundingMode.HALF_UP)));
            formula.append('=');
            formula.append(this.toBigDecimalString(elementTotalCost.setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
            formula.append('\n');
            this.holder.setBalanceFormula(subIndex, formula.toString());
            subIndexMap.put(elementId, subIndex);
        }
        if ("A".equals(adjustInfo.getCallBillType())) {
            this.sumToTotal(adjustInfo);
        } else {
            this.substractToTotal(adjustInfo);
        }
        formula.setLength(0);
        currentTotalCost = this.getCurrentTotalCost();
        currentTotalQty = this.getCurrentTotalQty();
        BigDecimal bigDecimal = unitCost = currentTotalQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : currentTotalCost.divide(currentTotalQty, 10, RoundingMode.HALF_UP);
        if (currentTotalQty.compareTo(BigDecimal.ZERO) > 0) {
            this.currentUnitCost = unitCost;
        }
        formula.append(this.toBigDecimalString(currentTotalQty.setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
        formula.append('*');
        formula.append(this.toBigDecimalString(unitCost.setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
        formula.append('=');
        formula.append(this.toBigDecimalString(currentTotalCost.setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
        this.holder.appendBalanceFormula(index, formula.toString());
        for (Map.Entry entry : subIndexMap.entrySet()) {
            BigDecimal elementUnitCost;
            formula.setLength(0);
            BigDecimal elementTotalCost = this.getElementTotalCostMap().get(entry.getKey());
            BigDecimal bigDecimal2 = elementUnitCost = currentTotalQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : elementTotalCost.divide(currentTotalQty, 10, RoundingMode.HALF_UP);
            if (currentTotalQty.compareTo(BigDecimal.ZERO) > 0) {
                this.currentElementUnitCost.put((Long)entry.getKey(), elementUnitCost);
            }
            formula.append(this.toBigDecimalString(currentTotalQty.setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
            formula.append('*');
            formula.append(this.toBigDecimalString(elementUnitCost.setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
            formula.append('=');
            formula.append(this.toBigDecimalString(elementTotalCost.setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
            this.holder.appendBalanceFormula((Integer)entry.getValue(), formula.toString());
        }
    }

    @Override
    protected void beforeEndCalculated() {
        this.tempInGroupRow.sort(new Comparator<LocalRow>(){

            @Override
            public int compare(LocalRow row1, LocalRow row2) {
                if (row1.getBizDate().equals(row2.getBizDate())) {
                    if (row1.getAuditTime().equals(row2.getAuditTime())) {
                        if (row1.getQueuetype() == null || row2.getQueuetype() == null) {
                            String billno = row1 == null ? row1.getBillnumber() : row2.getBillnumber();
                            String msg = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u201c%1$s\u201d\u4e2d\uff0c\u5b58\u5728\u5e8f\u5217\u7c7b\u578b\u4e3a\u7a7a\u7684\u5206\u5f55\uff0c\u8ba1\u7b97\u7ec8\u6b62\u3002", (String)"WeightedAvgAT_6", (String)"fi-calx-algox", (Object[])new Object[0]), billno);
                            throw new KDBizException(msg);
                        }
                        return 0 - row1.getQueuetype().compareTo(row2.getQueuetype());
                    }
                    return row1.getAuditTime().compareTo(row2.getAuditTime());
                }
                return row1.getBizDate().compareTo(row2.getBizDate());
            }
        });
        ArrayList<LocalRow> rows = new ArrayList<LocalRow>(16);
        for (LocalRow row : this.tempInGroupRow) {
            row = this.getGroupedRow(row.getEntryId());
            rows.add(row);
        }
        this.afterCalcGroupCost(rows);
        ArrayList<LocalRow> costNotDeterminedRows = new ArrayList<LocalRow>(16);
        for (LocalRow row : rows) {
            if (row.isGroupCostCalculated().booleanValue() && !row.isCostDetermined()) {
                CostPriceSourceTypeHelper.setCostpriceSourceByGroup(row, this.ctx.enableCoverdesigoutcost());
                if ("0".equals(row.getQueuetype())) {
                    this.addCostUpdateInfo(row);
                    if (!row.isPriced()) {
                        this.joinCalculate(row, ResManager.loadKDString((String)"(\u5ef6\u540e\u83b7\u53d6\u6210\u672c)", (String)"MovedAvgIntimeAT_1", (String)"fi-calx-algox", (Object[])new Object[0]), null);
                    }
                } else {
                    this.addCostUpdateInfo(row);
                    this.joinCalculate(row, null, null);
                }
            } else if (!row.isCostDetermined() && !row.isPriced()) {
                costNotDeterminedRows.add(row);
            }
            this.joinCalculate(this.addGroupBillCostAdjustInfo(row));
        }
        if (!costNotDeterminedRows.isEmpty()) {
            this.holder.setCalStatus(RptStatus.WARNING);
            for (LocalRow costNotDeterminedRow : costNotDeterminedRows) {
                this.joinCalculate(costNotDeterminedRow, ResManager.loadKDString((String)"(\u6210\u672c\u672a\u786e\u5b9a)", (String)"WeightedAvgAT_13", (String)"fi-calx-algox", (Object[])new Object[0]), null);
            }
        }
    }

    @Override
    protected void afterEndCalculated() {
        DynamicObject[] recentCosts;
        String property;
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_recentcost");
        if (RptStatus.ERROR.getValue().equals(this.holder.getCalStatusValue())) {
            return;
        }
        QFilter filter = new QFilter("costaccount", "=", (Object)this.getCostAccountId());
        filter.and("material", "=", (Object)this.getMaterialId());
        if (this.isEmptyRange()) {
            for (Map.Entry<String, String> entry : this.getDivideBasisValueMap().entrySet()) {
                property = entry.getKey();
                if (entityType.findProperty(property) instanceof BasedataProp) {
                    filter.and(property, "=", (Object)Long.valueOf(entry.getValue()));
                    continue;
                }
                filter.and(property, "=", (Object)entry.getValue());
            }
        } else {
            filter.and("calrange", "=", (Object)this.getCalRangeId());
        }
        for (Map.Entry<String, String> entry : this.getCalDimensionMap().entrySet()) {
            property = entry.getKey();
            if (entityType.findProperty(property) instanceof BasedataProp) {
                filter.and(property, "=", (Object)Long.valueOf(entry.getValue()));
                continue;
            }
            filter.and(property, "=", (Object)entry.getValue());
        }
        for (DynamicObject recentCost : recentCosts = BusinessDataServiceHelper.load((String)"cal_recentcost", (String)"id,costsubelement,price,recentqty,recentcost,calrptid", (QFilter[])filter.toArray())) {
            Long elementId = recentCost.getDynamicObject("costsubelement").getLong("id");
            BigDecimal cost = this.currentElementUnitCost.remove(elementId);
            if (cost == null) continue;
            recentCost.set("recentcost", (Object)this.getElementTotalCost(elementId));
            recentCost.set("calrptid", (Object)this.holder.getCalRptID());
            recentCost.set("recentqty", (Object)this.getCurrentTotalQty());
            recentCost.set("price", (Object)cost);
        }
        SaveServiceHelper.save((DynamicObject[])recentCosts);
        if (!this.currentElementUnitCost.isEmpty()) {
            ArrayList<DynamicObject> arrayList = new ArrayList<DynamicObject>(this.currentElementUnitCost.size());
            for (Map.Entry<Long, BigDecimal> entry : this.currentElementUnitCost.entrySet()) {
                DynamicObject recentCost;
                recentCost = BusinessDataServiceHelper.newDynamicObject((String)"cal_recentcost");
                arrayList.add(recentCost);
                recentCost.set("costaccount", (Object)this.getCostAccountId());
                recentCost.set("material", (Object)this.getMaterialId());
                Long costSubElementId = entry.getKey();
                recentCost.set("costelement", (Object)this.getElementMap().get(costSubElementId).getCostElementId());
                recentCost.set("costsubelement", (Object)costSubElementId);
                recentCost.set("currency", (Object)this.getCurrency());
                if (this.isEmptyRange()) {
                    for (Map.Entry<String, String> divideEntry : this.getDivideBasisValueMap().entrySet()) {
                        String property2 = divideEntry.getKey();
                        if (entityType.findProperty(property2) instanceof BasedataProp) {
                            recentCost.set(property2, (Object)Long.valueOf(divideEntry.getValue()));
                            continue;
                        }
                        recentCost.set(property2, (Object)divideEntry.getValue());
                    }
                } else {
                    recentCost.set("calrange", (Object)this.getCalRangeId());
                }
                for (Map.Entry<String, String> calDimensionEntry : this.getCalDimensionMap().entrySet()) {
                    String property2 = calDimensionEntry.getKey();
                    if (entityType.findProperty(property2) instanceof BasedataProp) {
                        recentCost.set(property2, (Object)Long.valueOf(calDimensionEntry.getValue()));
                        continue;
                    }
                    recentCost.set(property2, (Object)calDimensionEntry.getValue());
                }
                recentCost.set("recentcost", (Object)this.getElementTotalCost(entry.getKey()));
                recentCost.set("calrptid", (Object)this.holder.getCalRptID());
                recentCost.set("recentqty", (Object)this.getCurrentTotalQty());
                recentCost.set("price", (Object)entry.getValue());
            }
            SaveServiceHelper.save((DynamicObject[])arrayList.toArray(new DynamicObject[arrayList.size()]));
        }
    }
}

