/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.accounttype;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.calx.algox.accounttype.AbstractAccountType;
import kd.fi.calx.algox.accounttype.LocalRow;
import kd.fi.calx.algox.constant.CostAdjustBilCreateTypeEnum;
import kd.fi.calx.algox.constant.CostPriceSourceTypeEnum;
import kd.fi.calx.algox.diff.CostAdjustDetailParams;
import kd.fi.calx.algox.diff.EntityExInfo;
import kd.fi.calx.algox.diff.helper.ExFieldHelper;
import kd.fi.calx.algox.diff.helper.MITStdDiffCostAdjustBillHelper;
import kd.fi.calx.algox.diff.model.StdCostDiffBillModel;
import kd.fi.calx.algox.function.AccountTypeContext;
import kd.fi.calx.algox.groupbill.GroupBillHolder;
import kd.fi.calx.algox.helper.JsonEntryServiceHelper;

public class StandardCostCalAT
extends AbstractAccountType {
    private static final Log logger = LogFactory.getLog(StandardCostCalAT.class);
    private static final long serialVersionUID = 1022700915314870327L;
    Map<Long, Set<LocalRow>> billIdEntryIdsMap;
    private AccountTypeContext ctx;
    private static String[] HEAD = new String[]{"id", "calorg", "period", "billno", "localcurrency", "billnumber", "costaccount", "billstatus", "storageorgunit", "bizentityobject", "calbilltype", "biztype", "bizbillid", "bizdate", "bookdate", "billtype", "transtype", "supplier", "customer", "adminorg"};
    private static String[] ENTRY = new String[]{"id", "seq", "bizbillentryid", "material", "standardcost", "mversion", "assist", "lot", "baseunit", "warehouse", "location", "invtype", "invstatus", "ownertype", "owner", "ecostcenter", "project", "tracknumber", "configuredcode", "calrange", "caldimension", "accounttype", "queuetype", "signnum", "productline", "noupdatecalfields", "stocktype"};
    private static String[] ENTRY_DETAIL = new String[]{"id", "entryid", "material", "costelement", "costsubelement", "currency", "baseunit", "baseqty", "standardcost", "actualcost"};

    public StandardCostCalAT(AccountTypeContext ctx, DataSet dataSet, int runningMode) {
        super(ctx, dataSet, runningMode);
        this.ctx = ctx;
        this.billIdEntryIdsMap = new HashMap<Long, Set<LocalRow>>(16);
    }

    @Override
    protected void afterCalculated() {
        super.afterCalculated();
        List<EntityExInfo> entityExInfos = new ExFieldHelper().getEntityExInfos("cal_stdcostdiffbill");
        List ids = this.billIdEntryIdsMap.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList());
        HashMap<Long, Set<Long>> idAndEntryIds = new HashMap<Long, Set<Long>>();
        HashMap<Long, Long> entryIdAndId = new HashMap<Long, Long>();
        HashMap costRecordGroupIdAndSubElementAmt = new HashMap();
        HashMap costRecordIdAndAmt = new HashMap();
        HashMap idAndCostRecord = new HashMap();
        HashMap entryIdAndCostRecordEntry = new HashMap();
        logger.info("std_diff_create start");
        List<String> headFields = Arrays.asList(HEAD);
        List<String> entrysFields = Arrays.asList(ENTRY);
        List<String> detailsFields = Arrays.asList(ENTRY_DETAIL);
        List headList = Stream.of(headFields).flatMap(Collection::stream).distinct().filter(a -> !StringUtils.isEmpty((String)a)).collect(Collectors.toList());
        List entryList = Stream.of(entrysFields).flatMap(Collection::stream).distinct().filter(a -> !StringUtils.isEmpty((String)a)).map(a -> "entry.".concat((String)a)).collect(Collectors.toList());
        List extEntryList = entityExInfos.stream().filter(a -> !StringUtils.isEmpty((String)a.getPropertyName())).map(a -> "entry.".concat(a.getPropertyName())).collect(Collectors.toList());
        entryList.addAll(extEntryList);
        String headCols = Stream.of(headList, entryList).flatMap(Collection::stream).collect(Collectors.joining(","));
        String detailCols = Stream.of(detailsFields).flatMap(Collection::stream).distinct().filter(a -> !StringUtils.isEmpty((String)a)).collect(Collectors.joining(","));
        QFilter headFilter = new QFilter("id", "in", ids);
        DynamicObjectCollection costRecords = QueryServiceHelper.query((String)this.getClass().getName(), (String)"cal_costrecord_subentity", (String)headCols, (QFilter[])new QFilter[]{headFilter}, null);
        costRecords.stream().forEach(a -> {
            Long costRecordId = a.getLong("id");
            Long costRecordEntryId = a.getLong("entry.id");
            BigDecimal entryAmt = a.getBigDecimal("entry.standardcost");
            idAndCostRecord.put(costRecordId, a);
            entryIdAndCostRecordEntry.put(costRecordEntryId, a);
            idAndEntryIds.putIfAbsent(costRecordId, new HashSet());
            Set curEntryIds = (Set)idAndEntryIds.get(costRecordId);
            curEntryIds.add(costRecordEntryId);
            String groupKey = costRecordId + "#" + costRecordEntryId;
            costRecordIdAndAmt.putIfAbsent(groupKey, BigDecimal.ZERO);
            BigDecimal amt = (BigDecimal)costRecordIdAndAmt.get(groupKey);
            amt = amt.add(entryAmt);
            costRecordIdAndAmt.put(groupKey, amt);
            entryIdAndId.put(costRecordEntryId, costRecordId);
        });
        List entryIds = idAndEntryIds.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        QFilter detailFilter = new QFilter("entryid", "in", entryIds);
        DynamicObjectCollection details = QueryServiceHelper.query((String)"cal_costrecord_detail", (String)detailCols, (QFilter[])new QFilter[]{detailFilter}, null);
        details.stream().forEach(a -> {
            long entryId = a.getLong("entryid");
            long subElementId = a.getLong("costsubelement");
            String groupKey = entryIdAndId.get(entryId) + "#" + entryId + "#" + subElementId;
            costRecordGroupIdAndSubElementAmt.putIfAbsent(groupKey, BigDecimal.ZERO);
            BigDecimal curAmt = (BigDecimal)costRecordGroupIdAndSubElementAmt.get(groupKey);
            BigDecimal amt = a.getBigDecimal("standardcost") == null ? BigDecimal.ZERO : a.getBigDecimal("standardcost");
            curAmt = curAmt.add(amt);
            costRecordGroupIdAndSubElementAmt.put(groupKey, curAmt);
        });
        List rows = this.billIdEntryIdsMap.entrySet().stream().map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toList());
        HashMap<String, BigDecimal> stdGroupIdAndSubElementAmt = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> stdIdAndEntryAmt = new HashMap<String, BigDecimal>();
        this.calculateOldActualCost(idAndEntryIds, entryIdAndId, stdGroupIdAndSubElementAmt, stdIdAndEntryAmt);
        HashMap groupMap = new HashMap();
        for (LocalRow row : rows) {
            Map materialIdAndRows;
            Long headId = row.getHeadid();
            Long entryId = row.getEntryId();
            Long materialId = ((DynamicObject)entryIdAndCostRecordEntry.get(entryId)).getLong("entry.material");
            if (groupMap.get(headId) == null) {
                groupMap.put(headId, new HashMap());
            }
            if ((materialIdAndRows = (Map)groupMap.get(headId)).get(materialId) == null) {
                materialIdAndRows.put(materialId, new ArrayList());
            }
            List localRows = (List)materialIdAndRows.get(materialId);
            localRows.add(row);
        }
        MITStdDiffCostAdjustBillHelper mitStdDiffCostAdjustBillHelper = new MITStdDiffCostAdjustBillHelper();
        HashMap elementCache_subIdAndId = new HashMap();
        HashMap<String, List<StdCostDiffBillModel>> stdCostDiffBills = new HashMap<String, List<StdCostDiffBillModel>>(16);
        ArrayList<CostAdjustDetailParams> params = new ArrayList<CostAdjustDetailParams>();
        groupMap.entrySet().stream().forEach(a -> ((Map)a.getValue()).entrySet().stream().forEach(b -> ((List)b.getValue()).stream().forEach(row -> {
            BigDecimal newActualCost;
            BigDecimal diff;
            GroupBillHolder groupBillHolder = this.ctx.getGroupBillHolder();
            String groupKey = row.getHeadid() + "#" + row.getEntryId();
            BigDecimal costRecordEntryAmt = costRecordIdAndAmt.get(groupKey) == null ? BigDecimal.ZERO : (BigDecimal)costRecordIdAndAmt.get(groupKey);
            BigDecimal stdEntryAmt = stdIdAndEntryAmt.get(groupKey) == null ? BigDecimal.ZERO : (BigDecimal)stdIdAndEntryAmt.get(groupKey);
            BigDecimal oldActualCost = costRecordEntryAmt.add(stdEntryAmt);
            logger.info("groupKey : {},cost : {}, std : {},costrecord : {}", new Object[]{groupKey, oldActualCost, stdEntryAmt, costRecordEntryAmt});
            LocalRow newRow = this.getGroupedRow(row.getEntryId());
            String costpricesource = newRow.getCostpricesource();
            String bizEntityObject = newRow.getBizEntityObject();
            costpricesource = CostPriceSourceTypeEnum.getLastByCostPriceSource(costpricesource);
            if (this.ctx.enableCoverdesigoutcost() && (CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getValue().equals(costpricesource) || CostPriceSourceTypeEnum.CALCULATE_IN_SPECIFICATION.getValue().equals(costpricesource) || CostPriceSourceTypeEnum.EXP_BILL_SPECIFICATION.getValue().equals(costpricesource)) && ("im_disassemblebill".equals(bizEntityObject) || "im_adjustbill".equals(bizEntityObject))) {
                costpricesource = CostPriceSourceTypeEnum.getCostPriceSourceValue(newRow.getCostpricesource(), CostPriceSourceTypeEnum.GROUP_COST_SPECIFICATION.getValue());
                newRow.setCostpricesource(costpricesource);
                newRow.setDesignatedcost(false);
            }
            if ((diff = (newActualCost = newRow.getActualCost()).subtract(oldActualCost)).compareTo(BigDecimal.ZERO) != 0) {
                mitStdDiffCostAdjustBillHelper.genStdCostDiffBill((LocalRow)row, idAndCostRecord, entryIdAndCostRecordEntry, stdCostDiffBills, params, elementCache_subIdAndId, diff, costRecordGroupIdAndSubElementAmt, stdGroupIdAndSubElementAmt, groupBillHolder);
            }
            this.addCostUpdateInfo(newRow);
        })));
        mitStdDiffCostAdjustBillHelper.saveStdCostDiffBillToDB(stdCostDiffBills);
        HashSet headIdSet = new HashSet();
        stdCostDiffBills.values().stream().flatMap(Collection::stream).collect(Collectors.toList()).stream().forEach(a -> headIdSet.add(Long.valueOf(a.getHeaders()[0].toString())));
        Long[] headIds = headIdSet.toArray(new Long[0]);
        mitStdDiffCostAdjustBillHelper.auditCostAdjust(headIds, params);
    }

    @Override
    protected void calculateOut(LocalRow row) {
        boolean destBill = row.isDestBill();
        Long entryId = row.getEntryId();
        if (!destBill) {
            logger.info("std is not des : {}", (Object)entryId);
            return;
        }
        Long headid = row.getHeadid();
        if (this.billIdEntryIdsMap.get(headid) == null) {
            this.billIdEntryIdsMap.put(headid, new HashSet());
        }
        this.billIdEntryIdsMap.get(headid).add(row);
    }

    @Override
    protected String[] getOrderByField() {
        return new String[0];
    }

    private void calculateOldActualCost(Map<Long, Set<Long>> idAndEntryId, Map<Long, Long> entryIdAndId, Map<String, BigDecimal> stdGroupIdAndSubElementAmt, Map<String, BigDecimal> stdIdAndEntryAmt) {
        HashMap stdIdAndEntryId = new HashMap();
        HashMap stdEntryIdAndDetailId = new HashMap();
        HashMap stdEntryIdAndAmt = new HashMap();
        HashMap stdId_CostRecordId = new HashMap();
        HashMap stdEntryId_CostRecordEntryId = new HashMap();
        Set<Long> costRecordIds = idAndEntryId.keySet();
        List entryIds = idAndEntryId.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        HashSet costRecordEntryIds = new HashSet(entryIds);
        QFilter stdFilter = new QFilter("entryentity.invbillid", "in", costRecordIds);
        stdFilter.and(new QFilter("entryentity.invbillentryid", "in", costRecordEntryIds));
        stdFilter.and(new QFilter("createtype", "!=", (Object)CostAdjustBilCreateTypeEnum.DIFF_SHARE.getValue()));
        stdFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        DynamicObjectCollection stdCostDiff = QueryServiceHelper.query((String)"cal_stdcostdiffbill", (String)"id,billno,entryentity.id,entryentity.material,entryentity.invbillid,entryentity.invbillentryid,entryentity.adjustamt", (QFilter[])new QFilter[]{stdFilter}, null);
        stdCostDiff.stream().forEach(a -> {
            long id = a.getLong("id");
            long entryId = a.getLong("entryentity.id");
            long costRecordId = a.getLong("entryentity.invbillid");
            long costRecordEntryId = a.getLong("entryentity.invbillentryid");
            BigDecimal adjustAmt = a.getBigDecimal("entryentity.adjustamt") == null ? BigDecimal.ZERO : a.getBigDecimal("entryentity.adjustamt");
            stdIdAndEntryId.putIfAbsent(id, new HashSet());
            Set curEntryIds = (Set)stdIdAndEntryId.get(id);
            curEntryIds.add(entryId);
            stdEntryIdAndAmt.putIfAbsent(entryId, BigDecimal.ZERO);
            BigDecimal curAmt = (BigDecimal)stdEntryIdAndAmt.get(entryId);
            curAmt = curAmt.add(adjustAmt);
            stdEntryIdAndAmt.put(entryId, curAmt);
            stdId_CostRecordId.put(id, costRecordId);
            stdEntryId_CostRecordEntryId.put(entryId, costRecordEntryId);
            String groupKey = costRecordId + "#" + costRecordEntryId;
            stdIdAndEntryAmt.putIfAbsent(groupKey, BigDecimal.ZERO);
            BigDecimal amt = (BigDecimal)stdIdAndEntryAmt.get(groupKey);
            amt = amt.add(adjustAmt);
            stdIdAndEntryAmt.put(groupKey, amt);
        });
        List stdEntryIds = stdIdAndEntryId.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        if (!stdEntryIds.isEmpty()) {
            QFilter stdDetailFilter = new QFilter("entryentity.id", "in", stdEntryIds);
            DataSet costdiffbillDetailDataSet = JsonEntryServiceHelper.queryJsonSubEntryDataSet(this.getClass().getName(), "cal_stdcostdiffbill", "id as id,entryentity.id as entryid,entryentity.subentryentity.costsubelement as costsubelement,entryentity.subentryentity.sub_adjustamt as sub_adjustamt", "entryentity.subentryentity", new QFilter[]{stdDetailFilter}, null);
            for (Row row : costdiffbillDetailDataSet) {
                Long detailId = row.getLong("id");
                Long entryId = row.getLong("entryid");
                Long subElementId = row.getLong("costsubelement");
                BigDecimal subAmt = row.getBigDecimal("sub_adjustamt") == null ? BigDecimal.ZERO : row.getBigDecimal("sub_adjustamt");
                stdEntryIdAndDetailId.putIfAbsent(entryId, new HashSet());
                Set detailIds = (Set)stdEntryIdAndDetailId.get(entryId);
                detailIds.add(detailId);
                String groupKey = entryIdAndId.get(stdEntryId_CostRecordEntryId.get(entryId)) + "#" + stdEntryId_CostRecordEntryId.get(entryId) + "#" + subElementId;
                stdGroupIdAndSubElementAmt.putIfAbsent(groupKey, BigDecimal.ZERO);
                BigDecimal amt = stdGroupIdAndSubElementAmt.get(groupKey);
                amt = amt.add(subAmt);
                stdGroupIdAndSubElementAmt.put(groupKey, amt);
            }
        }
    }
}

